/****************************************************************************
*
*  Local Includes
*
***************************************************************************/

#ifdef AMIGA
#include <exec/types.h>
#include <proto/exec.h>

int CXBRK(void) { return(0); }  /* Disable Lattice CTRL/C handling */
int chkabort(void) { return(0); }  /* really */
#ifdef SHARED
#include <exec/libraries.h>
#include <libraries/dos.h>

#include "/include/pragmas/FPL_pragmas.h"
#include "/include/clib/FPL_protos.h"
#include "FPL.h"
struct Library *FPLBase = NULL;
#endif

#define REG(x) register __ ## x

#elif defined(UNIX) /* #ifdef AMIGA */
#include <sys/types.h>
#define REG(x) register

#ifdef OS2
#include "FPL.h"
#include "reference.h"
#include "FPL_protos.h"
#define  TRUE  1
#define  FALSE 0
#else
#include "../include/clib/FPL_protos.h"
#include "../include/libraries/FPL.h"
#endif
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>

#include "stdcode.h"
#include "user.h"
#include "comm.h"
#include "files.h"
#include "os.h"
#include "colors.h"
#include "message.h"
#include "system.h"
#include "serial.h"
#include "mystring.h"
#include "fplerr.h"
#include "sprintf.h"
#include "flink.h"

#if defined(AMIGA) && defined(SHARED)
#define CALLER __saveds
#define ASM __asm
#else
#define CALLER
#define ASM
#endif

#define FPLSendInt( xxx )     fplSendTags( anchor, FPLSEND_INT, xxx, \
					   FPLSEND_DONE )
#define FPLSendString( xxx )  fplSendTags( anchor, FPLSEND_STRING, xxx, \
					   FPLSEND_STRLEN, strlen( xxx ), \
					   FPLSEND_DONE)

/****************************************************************************
*
*  Local Function Declarations
*
***************************************************************************/

static long ASM fpl_Func (REG(a0) struct fplArgument *);
static int 	sortCmp ( const void* e1, const void* e2 );
static int 	sortCmpi( const void* e1, const void* e2 );

/****************************************************************************
*
*  Global Variables
*
***************************************************************************/

void* key;
char* fpl_MorePrompt_PC = NULL;
char* fpl_TimeLeft_PC = NULL;
char* fpl_Timeout_PC = NULL;
int   FplErr_I;
int   RunSafe_I = 0;
char  SafePath_AC[256];

t_System System_S;

enum myfunctions {
  /* programmer fuctions*/
  FN_GETINT, FN_GETSTRING, FN_GETCHAR, FN_GETKEY,
  FN_TOUPPER,
  FN_RUNFILE, FN_RUNSAFE,
  FN_PRINTF, FN_LPRINTF, 
  FN_SETFUNC, FN_CLEAR, FN_GOTOXY, FN_COLOUR,
  FN_SYSTEM, FN_LOADSTRING, FN_SAVESTRING, FN_LOADARRAY, FN_SAVEARRAY,
  FN_TRANSLATE, FN_FAPPEND, FN_FPREPEND,FN_FEXISTS, FN_GETENV, FN_STRICMP,
  FN_TOKSTR, FN_SETDATESTR, FN_PARSECMND, FN_RANDOM, FN_SLEEP, FN_SORT,

  /* user functions */
  FN_INITUSER, FN_LOADUSER, FN_SAVEUSER,
  FN_GETUSERVAR, FN_SETUSERVAR, FN_SETUID, FN_GETUID, FN_NEWUID, 
  FN_CHARSET, FN_SCREENLEN, FN_SETTIMEOUT, FN_SETUSERTIME,

  /* message functions */
  FN_GOTOMAREA, FN_GETMAREA, FN_GOTOMSG, FN_GETMSG, FN_PRINTMSG, FN_NEXTMSG,
  FN_MARKMSG, FN_SAVEMSGMAP, FN_PUTMSG, FN_CREATEMSG, FN_SENDMSG, FN_MSGID,
  FN_MSGMEMBER, FN_DELMSG, FN_PUTMSGFLAG, FN_GETMSGFLAG, FN_SETMAREASIZE,

  /* file functions */
  FN_GOTOFAREA, FN_FILELIST, FN_TYPEFILE, FN_FILEINFO, FN_FILEFLAG,
  FN_DSZFIELD, FN_SPLITPATH, FN_CLRFTAGS, FN_GETFTAG, FN_NEWFILES,
  FN_GETFFIELD, FN_SETFFIELD, FN_FKILL, FN_FMOVE, FN_FDELETE, FN_FRENAME,
  FN_FFINDFIRST, FN_FFINDNEXT,

  FN_NOWTIME, FN_TIME2STR, FN_STR2TIME, FN_TIMEPART, FN_SETSYSVAR, FN_BYE,

  VR_ERRNO,VR_LOCAL,VR_COMPORT,VR_COMHANDLE,VR_TIMELEFT,
  VR_VERSION,VR_FPLVERSION,VR_SAFEMODE,

  FN_NOP

};

t_PartId FPL_MsgParts_AAC[] = {
    "body",	/* 0 */
    "from",	/* 1 */
    "to",	/* 2 */
    "subject",	/* 3 */
    "origaddr",	/* 4 */
    "destaddr",	/* 5 */
    "date",	/* 6 */
    "replyto",	/* 7 */
    "reply",	/* 8 */
    "control",	/* 9 */
    "replies",	/* 10 */
    "uid",
    ""
};

t_PartId FPL_SysVar_AAC[] = {
    "colour",
    "usertime",
    ""
};

t_PartId FPL_AreaParts_AAC[] = {
    "total",
    "unread",
    "highest",
    ""
};

t_PartId FPL_FileInfo_AAC[] = {
    "size",
    "year",
    "month",
    "day",
    "hour",
    "min",
    "sec",
    "time"
};

t_PartId FPL_FileList_AAC[] = {
    "string",
    "date"
};

t_PartId FPL_SplitPath_AAC[] = {
    "path",
    "file"
};

t_PartId FPL_SetFunc_AAC[] = {
    "moreprompt",
    "timeleft",
    "timeout"
};

t_PartId FPL_TimePart_AAC[] = {
    "year",
    "month",
    "day",
    "hour",
    "minute",
    "second",
    "wday"
};

t_PartId FPL_DszLog_AAC[] = {
    "protocol",
    "fsize",
    "dte",
    "cps",
    "errors",
    "stops",
    "psize",
    "file",
    "serial"
};

t_PartId FPL_MsgFlag_AAC[] = {
    "private",
    "crash",
    "read",
    "sent",
    "file",
    "forward",
    "orphan",
    "kill",
    "local",
    "hold",
    "freq",
    "rreq",
    "receipt",
    "ureq",
    "scanned",
    "uid"
};

t_PartId FPL_Colours_AAC[] = {
    "black",
    "red",
    "green",
    "brown",
    "blue",
    "magenta",
    "cyan",
    "gray",
    "dgray",
    "lred",
    "lgreen",
    "yellow",
    "lblue",
    "lmagenta",
    "lcyan",
    "white"
};


/****************************************************************************
*
*  Function:    FPL_Init
*  Description: Sets up the FPL environment and starts execution of the FPL
*               files.
*
***************************************************************************/

t_RetCode FPL_Init( char* StartFile_PC )
{
  long n, end=0,rc;
  long count=0;
  struct fplSymbol *symbols;
  long i,Version_I,Revision_I;
  int ms;
  char  path[512];
  char* env;

  OS_Milliseconds( &ms );
  srand( ms );

  key=fplInitTags(fpl_Func, 
		  FPLTAG_CACHEALLFILES, 1, 
		  FPLTAG_REREAD_CHANGES, 1, 
		  FPLTAG_DONE );

  if ( rc = fplSendTags( key, FPLSEND_GETVERSION, &Version_I,
			      FPLSEND_GETREVISION, &Revision_I, NULL ) )
      RET_ERR( "Error getting FPL version", rc );

  printf("Using FPL.DLL version %d.%d.\n",Version_I,Revision_I);

  /* programmer functions */

  fplAddFunction( key, "getstring", FN_GETSTRING, 'S', "si", NULL );
  fplAddFunction( key, "getint",    FN_GETINT,    'I', "si", NULL );
  fplAddFunction( key, "getchar",   FN_GETCHAR,   'I', "si", NULL );
  fplAddFunction( key, "getkey",    FN_GETKEY,    'I', "",   NULL );
  fplAddFunction( key, "loadstring",FN_LOADSTRING,'S', "S",  NULL );
  fplAddFunction( key, "savestring",FN_SAVESTRING,'I', "SSi",NULL );
  fplAddFunction( key, "toupper",   FN_TOUPPER,   'I', "I",  NULL );
  fplAddFunction( key, "runfile",   FN_RUNFILE,   'I', "S",  NULL );
  fplAddFunction( key, "runsafe",   FN_RUNSAFE,   'I', "SS", NULL );
  fplAddFunction( key, "printf",    FN_PRINTF,    'I', "So>",NULL );
  fplAddFunction( key, "lprintf",   FN_LPRINTF,   'I', "So>",NULL );
  fplAddFunction( key, "setfunc",   FN_SETFUNC,   'I', "SS", NULL );
  fplAddFunction( key, "clear",     FN_CLEAR,     'I', "i",  NULL );
  fplAddFunction( key, "system",    FN_SYSTEM,    'I', "S",  NULL );
  fplAddFunction( key, "translate", FN_TRANSLATE, 'S', "SII",NULL );
  fplAddFunction( key, "fappend",   FN_FAPPEND,   'I', "SS", NULL );
  fplAddFunction( key, "fprepend",  FN_FPREPEND,  'I', "SS", NULL );
  fplAddFunction( key, "fexists",   FN_FEXISTS,   'I', "S",  NULL );
  fplAddFunction( key, "getenv",    FN_GETENV,    'S', "S",  NULL );
  fplAddFunction( key, "tokstr",    FN_TOKSTR,    'S', "SIs",NULL );
  fplAddFunction( key, "setdatestr",FN_SETDATESTR,'I', "BB", NULL );
  fplAddFunction( key, "parsecmnd", FN_PARSECMND, 'S', "SB", NULL );
  fplAddFunction( key, "random",    FN_RANDOM,    'I', "",   NULL );
  fplAddFunction( key, "gotoxy",    FN_GOTOXY,    'I', "II", NULL );
  fplAddFunction( key, "colour",    FN_COLOUR,    'S', "Si", NULL );
  fplAddFunction( key, "sleep",	    FN_SLEEP,     'I', "I",  NULL );
  fplAddFunction( key, "sort",	    FN_SORT,      'I', "Bi", NULL );
  fplAddFunction( key, "loadarray", FN_LOADARRAY, 'I', "SB", NULL );
  fplAddFunction( key, "savearray", FN_SAVEARRAY, 'I', "BSi",NULL );


  /* user functions */

  fplAddFunction( key, "inituser",  FN_INITUSER,  'I', "",   NULL );
  fplAddFunction( key, "loaduser",  FN_LOADUSER,  'I', "S",  NULL );
  fplAddFunction( key, "saveuser",  FN_SAVEUSER,  'I', "S",  NULL );
  fplAddFunction( key, "getuservar",FN_GETUSERVAR,'S', "S",  NULL );
  fplAddFunction( key, "setuservar",FN_SETUSERVAR,'I', "SS", NULL );
  fplAddFunction( key, "setuid",    FN_SETUID,    'I', "S",  NULL );
  fplAddFunction( key, "getuid",    FN_GETUID,    'S', "",   NULL );
  fplAddFunction( key, "charset",   FN_CHARSET,   'I', "II", NULL );
  fplAddFunction( key, "screenlen", FN_SCREENLEN, 'I', "i",  NULL );
  fplAddFunction( key, "setusertime",FN_SETUSERTIME,'I', "I",NULL );
  fplAddFunction( key, "settimeout",FN_SETTIMEOUT,'I', "I",  NULL );
  fplAddFunction( key, "setsysvar", FN_SETSYSVAR, 'I', "SI", NULL );
  

  /* message functions */

  fplAddFunction( key, "gotomarea", FN_GOTOMAREA, 'I', "SS", NULL );
  fplAddFunction( key, "getmarea",  FN_GETMAREA,  'I', "S",  NULL );
  fplAddFunction( key, "getmsg",    FN_GETMSG,    'S', "ISi",NULL );
  fplAddFunction( key, "printmsg",  FN_PRINTMSG,  'I', "SSS",NULL );
  fplAddFunction( key, "nextmsg",   FN_NEXTMSG,   'I', "I",  NULL );
  fplAddFunction( key, "markmsg",   FN_MARKMSG,   'I', "Ii", NULL );
  fplAddFunction( key, "savemsgmap",FN_SAVEMSGMAP,'I', "",   NULL );
  fplAddFunction( key, "createmsg", FN_CREATEMSG, 'I', "",   NULL );
  fplAddFunction( key, "putmsg",    FN_PUTMSG,	  'I', "SS", NULL );
  fplAddFunction( key, "sendmsg",   FN_SENDMSG,	  'I', "",   NULL );
  fplAddFunction( key, "msgid",	    FN_MSGID,	  'I', "",   NULL );
  fplAddFunction( key, "msgmember", FN_MSGMEMBER, 'I', "Si", NULL );
  fplAddFunction( key, "delmsg",    FN_DELMSG, 	  'I', "I",  NULL );
  fplAddFunction( key, "putmsgflag",FN_PUTMSGFLAG,'I', "SI", NULL );
  fplAddFunction( key, "getmsgflag",FN_GETMSGFLAG,'I', "IS", NULL );
  fplAddFunction( key, "setmareasize",FN_SETMAREASIZE,'I', "I",NULL );

  /* file functions */

  fplAddFunction( key, "gotofarea", FN_GOTOFAREA, 'I', "SS", NULL );
  fplAddFunction( key, "filelist",  FN_FILELIST,  'I', "sss",NULL );
  fplAddFunction( key, "newfiles",  FN_NEWFILES,  'I', "I",  NULL );
  fplAddFunction( key, "typefile",  FN_TYPEFILE,  'I', "S",  NULL );
  fplAddFunction( key, "fileinfo",  FN_FILEINFO,  'I', "SS", NULL );
  fplAddFunction( key, "fileflag",  FN_FILEFLAG,  'S', "S",  NULL );
  fplAddFunction( key, "dszfield",  FN_DSZFIELD,  'S', "SIS",NULL );
  fplAddFunction( key, "splitpath", FN_SPLITPATH, 'S', "SS", NULL );
  fplAddFunction( key, "clrftags",  FN_CLRFTAGS,  'I', "",   NULL );
  fplAddFunction( key, "getftag",   FN_GETFTAG,	  'S', "I",  NULL );
  fplAddFunction( key, "setffield", FN_SETFFIELD, 'S', "SSS",NULL );
  fplAddFunction( key, "getffield", FN_GETFFIELD, 'S', "SS", NULL );
  fplAddFunction( key, "fkill",     FN_FKILL,     'I', "Si", NULL );
  fplAddFunction( key, "fdelete",   FN_FDELETE,   'I', "S",  NULL );
  fplAddFunction( key, "frename",   FN_FRENAME,   'I', "SS", NULL );
  fplAddFunction( key, "fmove",     FN_FMOVE,     'I', "SS", NULL );

  fplAddFunction( key, "ffindfirst",FN_FFINDFIRST,'S', "Ss", NULL );
  fplAddFunction( key, "ffindnext", FN_FFINDNEXT, 'S', "",   NULL );

  /* system functions */

  fplAddFunction( key, "bye",	    FN_BYE,	  'I', "",   NULL );
  fplAddFunction( key, "nowtime",   FN_NOWTIME,   'I', "",   NULL );
  fplAddFunction( key, "timepart",  FN_TIMEPART,  'I', "IS", NULL );
  fplAddFunction( key, "time2str",  FN_TIME2STR,  'S', "I",  NULL );
  fplAddFunction( key, "str2time",  FN_STR2TIME,  'I', "S",  NULL );

  /* variables */

  fplAddVariable( key, "errno",     VR_ERRNO,     'I',   0,  NULL );
  fplAddVariable( key, "sys_local", VR_LOCAL,     'I',   0,  NULL );
  fplAddVariable( key, "sys_comport",VR_COMPORT,  'I',   0,  NULL );
  fplAddVariable( key, "sys_comhandle",VR_COMHANDLE,'I', 0,  NULL );
  fplAddVariable( key, "sys_timeleft",VR_TIMELEFT,'I',   0,  NULL );
  fplAddVariable( key, "sys_version",VR_VERSION,   'S',  0,  NULL );
  fplAddVariable( key, "fpl_version",VR_FPLVERSION,'S',  0,  NULL );
  fplAddVariable( key, "sys_safemode",VR_SAFEMODE, 'I',  0,  NULL );

  end = fplExecuteFile(key,StartFile_PC,NULL);

  switch ( end ) {
    case FPL_OK:
    case FPL_EXIT_OK:
      break;

    case FPL_OPEN_ERROR:
      env = getenv("FPL");
      if (env) {
	  sprintf(path,"%s\\%s",getenv("FPL"),StartFile_PC);
	  end = fplExecuteFile(key,path,NULL);
	  switch ( end ) {
	    case FPL_OK:
	    case FPL_EXIT_OK:
	      break;

	    case FPL_OPEN_ERROR:
	      printf("FPL file not found: %s\n",StartFile_PC );
	      break;

	    default:
	      printf("FPL reported internal error %d\n",end);
	      break;
	  }
      }
      else {
	  printf("FPL file not found: %s\n",StartFile_PC );
	  printf("Try setting the FPL environment variable to your FPL directory.\n");
      }
      break;

    default:
      printf("FPL reported internal error %d\n",end );
      break;
  }

  fplFree(key); /* free all shit FPL uses internally */

  return end;
}


/****************************************************************************
*
*  Function:    FPL_FixPath
*  Description: Fix path for "safe" mode
*
***************************************************************************/
char* FPL_FixPath( char* File_PC )
{
    static char String_AC[256];
    char* Ptr_PC;

    /* Check for backslash */
    if (!(Ptr_PC = strrchr( File_PC, '\\' )))

	/* Check for colon */
	if (!(Ptr_PC = strrchr( File_PC, ':' )))

	    /* Check for slash */
	    if (!(Ptr_PC = strrchr( File_PC, '/' ))) {
		sprintf(String_AC,"%s\\%s",SafePath_AC,File_PC);
		return String_AC;
	    }

    Ptr_PC++;
    sprintf(String_AC,"%s\\%s",SafePath_AC,Ptr_PC);
    return String_AC;
}

/****************************************************************************
*
*  Function:    FPL_MorePrompt
*  Description: Run the user-defined MorePrompt FPL program.
*
***************************************************************************/
t_RetCode FPL_MorePrompt( long* Result_PI )
{
    long Result_I;
    int  rc;

    if ( NOT fpl_MorePrompt_PC ) {
	*Result_PI = 0;
	return OK;
    }

    if ( rc = fplExecuteScript( key, &fpl_MorePrompt_PC, 1, NULL ) )
	RET_ERR( "Error executing MorePrompt", rc );

    if ( rc = fplSendTags( key, FPLSEND_GETRETURNCODE, &Result_I, NULL ) )
	RET_ERR( "Error getting MorePrompt result", rc );

    System_S.Ypos_I = 0;

    switch ( Result_I ) {
      case 0:
      case 1:
	break;

      default:
	RET_ERR( "Bad return value from MorePrompt!", Result_I );
    }

    *Result_PI = Result_I;

    return OK;
}

/****************************************************************************
*
*  Function:    FPL_TimeLeft
*  Description: Run the user-defined TimeLeft FPL program.
*
***************************************************************************/
t_RetCode FPL_TimeLeft( void )
{
    int  rc;

    if ( NOT fpl_TimeLeft_PC )
	return OK;

    if ( rc = fplExecuteScript( key, &fpl_TimeLeft_PC, 1, NULL ) )
	RET_ERR( "Error executing TimeLeft", rc );

    return OK;
}

/****************************************************************************
*
*  Function:    FPL_Timeout
*  Description: Run the user-defined Timeout FPL program.
*
***************************************************************************/
t_RetCode FPL_Timeout( void )
{
    int  rc;

    if ( NOT fpl_Timeout_PC )
	return OK;

    if ( rc = fplExecuteScript( key, &fpl_Timeout_PC, 1, NULL ) )
	RET_ERR( "Error executing Timeout", rc );

    return OK;
}


/******************************************************/
/* Parameter list frontends of the library functions: */
/******************************************************/

long fplExecuteScriptTags(void *anchor, char **program, long lines,
                          unsigned long tags, ...)
{
  return(fplExecuteScript(anchor, program, lines, (unsigned long *)&tags));
}

long fplExecuteFileTags(void *anchor, char *program, unsigned long tags, ...)
{
  return(fplExecuteFile(anchor, program, (unsigned long *)&tags));
}

void *fplInitTags(long (*func)(struct fplArgument *), unsigned long tags, ...)
{
  return(fplInit(func, (unsigned long *)&tags));
}

long fplResetTags(void *anchor, unsigned long tags, ...)
{
  return(fplReset(anchor, &tags));
}

long fplSendTags(void *anchor, unsigned long tags, ...)
{
  return(fplSend(anchor, &tags));
}

long fplAddFunctionTags(void *anchor, char *name, long ID, char rtrn,
                        char *format, unsigned long tags, ...)
{
  return(fplAddFunction(anchor, name, ID, rtrn, format, &tags));
}

int sortCmp( const void* e1, const void* e2 )
{
    char** s1 = (char**) e1;
    char** s2 = (char**) e2;

    return strcmp(*s1,*s2);
}

int sortCmpi( const void* e1, const void* e2 )
{
    char** s1 = (char**) e1;
    char** s2 = (char**) e2;

    return stricmp(*s1,*s2);
}

/****************************************************************************
*
*  Function:    fpl_Func
*  Description: Interface function for FPL. Contains *all* FPL functions.
*
***************************************************************************/

#undef CALL
#define CALL( function )  do {if ( OK != function ) return OK;} while(0)

#define CHK_SAFE  if (RunSafe_I) break

long ASM fpl_Func(REG(a0) struct fplArgument *arg)
{
    int ret = OK;
    long col;
    char *name;
    char *string;
    void *anchor=arg->key;
    char* String_PC;
    char* TmpStr_PC;
    char  TmpStr_AC[ 1024 ];
    int	  TmpInt_I=0;
    int	  TmpInt2_I=0;

    t_Bool SendInt_B=FALSE, SendString_B=FALSE;

    switch( arg->ID ) {

	/*****************  FPL internal functions ********************/

      case FPL_GENERAL_ERROR: {
	  char  buffer[FPL_ERRORMSG_LENGTH];
	  char* TmpStr_PC;
	  int   TmpInt_I,i;
	  FILE* File_PS;
		  
	  TmpInt_I = (long) arg->argv[0];
	  TmpStr_PC = fplGetErrorMsg( arg->key, (long)TmpInt_I, buffer );
	  
	  fplSendTags(anchor,
		      FPLSEND_GETVIRLINE, &col,
		      FPLSEND_GETVIRFILE, &name,
		      FPLSEND_DONE);
	  
	  if ( RunSafe_I )
	      sprintf(TmpStr_AC,"\r\n>>> FPL error in %s, line %d - %s\n\n",
		      name,col,TmpStr_PC);
	  else
	      sprintf(TmpStr_AC,"\r\n%s>>> %s, line %d - %s\n\n",
		 "!!! Fatal FPL error! Report the following line to SysOp:\n",
		      name,col,TmpStr_PC);
	  COM_Say( TmpStr_AC );

	  /* log the error */
	  File_PS = fopen( "fplerr.log", "a" );
	  if (File_PS) {
	      time_t Time_I = time(NULL);
	      struct tm* Time_PS = localtime( &Time_I );
	      fprintf( File_PS,
		      "%04d-%02d-%02d,%02d:%02d:%02d%c%s, line %d - %s\n",
		      Time_PS->tm_year + 1900,
		      Time_PS->tm_mon + 1,
		      Time_PS->tm_mday,
		      Time_PS->tm_hour,
		      Time_PS->tm_min,
		      Time_PS->tm_sec,
		      RunSafe_I?'*':' ',
		      name,col,TmpStr_PC);
	      fclose(File_PS);
	  }

	  OS_Sleep( 1000 );

	  if (RunSafe_I)
	      ret = OK;
	  else
	      Exit();
      }

      case FPL_UNKNOWN_FUNCTION:
	col=22;			/* only to breakpoint */
	break;
	
      case FPL_COMPILE: /* for experiments! */
	if(arg->format[0]==FPL_STRARG)
	    printf("%s", arg->funcdata);
	else
	    printf("%d", arg->funcdata);
	break;
	
	/*****************  FrexxLink functions ********************/

      case FN_PRINTF:
	if(!strlen(arg->argv[0]))
	    break;
	String_PC = NULL;
        STR_Sprintf( &String_PC, arg->argv[0], arg->argv, arg->format );
	COM_Say( String_PC );
	free( String_PC );

	CALL( COM_ChkBrk() );
	if ( System_S.Halted_B )
	    TmpInt_I = 1;
	else
	    TmpInt_I = 0;
	SendInt_B = TRUE;
	break;

      case FN_LPRINTF:
	if(!strlen(arg->argv[0]))
	    break;
	String_PC = NULL;
        STR_Sprintf( &String_PC, arg->argv[0], arg->argv, arg->format );
	printf( "%s", String_PC );
	free( String_PC );
	break;

      case FN_STRICMP:
	TmpInt_I = stricmp( arg->argv[0], arg->argv[1] );
	SendInt_B = TRUE;
	break;

      case FN_GETENV:
	String_PC = getenv( arg->argv[0] );
	if ( String_PC ) {
	    SendString_B = TRUE;
	    strcpy( TmpStr_AC, String_PC );
	}
	break;

      case FN_FAPPEND: {
	FILE* File_PS;

	CHK_SAFE;
	File_PS = fopen( arg->argv[0], "a" );
	if ( !File_PS ) {
	    fprintf(stderr, "Can't open '%s'. %s\n", 
		    arg->argv[0], strerror(errno) );
	    FplErr_I = FPLERR_NO_FILE;
	    break;
	}
	fprintf( File_PS, "%s", arg->argv[1] );
	fclose( File_PS );
	break;
      }

      case FN_FPREPEND:
	CHK_SAFE;
	FIL_Prepend(arg->argv[0],arg->argv[1]);
	break;

      case FN_FEXISTS: {
	FILE* File_PS;

	File_PS = fopen( arg->argv[0], "r" );
	if ( File_PS ) {
	    TmpInt_I = 1;
	    fclose( File_PS );
	}
	else
	    TmpInt_I = 0;
	SendInt_B = TRUE;
	break;
      }

      case FN_LOADSTRING:
	if ( RunSafe_I )
	    TmpStr_PC = FPL_FixPath(arg->argv[0]);
	else
	    TmpStr_PC = arg->argv[0];
	STR_LoadString( TmpStr_PC, &String_PC );
	if ( String_PC ) {
	    ret = FPLSendString( String_PC );
	    free( String_PC );
	}
	else
	    ret = FPLSendString( "" );
	break;

      case FN_SAVESTRING:
	if ( RunSafe_I )
	    TmpStr_PC = FPL_FixPath(arg->argv[1]);
	else
	    TmpStr_PC = arg->argv[1];
	if ( arg->argc > 2 )
	    TmpInt_I = 1;
	else
	    TmpInt_I = 0;
	STR_SaveString( arg->argv[0], TmpStr_PC, TmpInt_I );
	break;

      case FN_LOADARRAY: {
	  char** list;
	  struct fplRef refStruct;
	  long l[2];
	  unsigned long tags[5];
	  int  Items_I,i;
	  long ll;
	  char** List_PPC;

	  TmpInt_I = -1;
	  SendInt_B = TRUE;

	  if ( RunSafe_I )
	      TmpStr_PC = FPL_FixPath(arg->argv[0]);
	  else
	      TmpStr_PC = arg->argv[0];

	  CALL( STR_LoadArray( TmpStr_PC, &List_PPC, &Items_I ));
	  if (!List_PPC) {
	      TmpInt_I = 0;
	      break;
	  }

	  ll = Items_I;
	  refStruct.ArraySize = &ll;
	  refStruct.Dimensions = 1;

	  tags[0] = (long) FPLREF_ARRAY_RESIZE;
	  tags[1] = (long) &refStruct;
	  tags[2] = (long) FPLREF_DONE;
	  fplReference(key, arg->argv[1], tags );

	  tags[0] = (long) FPLREF_ARRAY_ITEM;
	  tags[1] = (long) &l;
	  tags[2] = (long) FPLREF_SET_MY_STRING;
	  tags[3] = (long) &string;
	  tags[4] = (long) FPLREF_DONE;

	  l[1] = -1;
	  for (i=0; i<Items_I; i++) {
	      l[0] = i;
 	      tags[3] = (long) List_PPC[i];
	      fplReference( key, arg->argv[1], tags );
	  }
	  free(List_PPC);
	  TmpInt_I = Items_I;
      }
	break;

      case FN_SAVEARRAY: {
	  struct fplRef refStruct;
	  long l[2];
	  unsigned long tags[5];
	  int  items,i;
	  char** list;
	  FILE* File_PS;

	  tags[0] = (long) FPLREF_ARRAY_INFO;
	  tags[1] = (long) &refStruct;
	  tags[2] = (long) FPLREF_DONE;
	  
	  fplReference( key, arg->argv[0], tags );
	  items = *refStruct.ArraySize;
	  if (!items) {
	      RET_ERR("No elements in array!",0);
	      break;
	  }

	  /* angav anropet antal rader? */
	  if ( arg->argc > 2 ) {
	      TmpInt_I = (int) arg->argv[2];
	      if ( TmpInt_I < items )
		  items = TmpInt_I;
	  }

	  if ( RunSafe_I )
	      TmpStr_PC = FPL_FixPath(arg->argv[1]);
	  else
	      TmpStr_PC = arg->argv[1];

	  File_PS = fopen( TmpStr_PC, "w" );
	  if ( !File_PS ) {
	      sprintf(TmpStr_AC, "Can't open '%s'. %s\n", 
		      arg->argv[0], strerror(errno) );
	      RET_ERR(TmpStr_AC,errno);
	  }

	  tags[0] = (long) FPLREF_ARRAY_ITEM;
	  tags[1] = (long) &l;
	  tags[2] = (long) FPLREF_GET_STRING;
	  tags[3] = (long) &string;
	  tags[4] = (long) FPLREF_DONE;

	  l[1] = -1;
	  for (i=0; i<items; i++) {
	      int len;
	      l[0] = i;
	      fplReference(key, arg->argv[0], tags );
	      len = FPL_STRLEN( string );
	      fwrite( string, len, 1, File_PS );
	  }

	  fclose( File_PS );
      }
	break;

      case FN_TRANSLATE:
	COM_Translate(arg->argv[0],
		      &String_PC,
		      (int) (arg->argv[1]) - 1,
		      (int) (arg->argv[2]) - 1);
	if ( String_PC ) {
	    ret = FPLSendString( String_PC );
	    free( String_PC );
	}
	else
	    ret = FPLSendString( arg->argv[0] );
	break;

      case FN_GETSTRING:
	if ( arg->argc )
	    COM_Say( arg->argv[0] );
	if ( arg->argc > 1 )
	    TmpInt_I = (int) (arg->argv[1]);
	else
	    TmpInt_I = -1;
	COM_GetString( TmpStr_AC, 1024, TmpInt_I );
	SendString_B = TRUE;
	break;

      case FN_GETINT:
	if( arg->argc )
	    COM_Say( arg->argv[0] );
	if ( arg->argc > 1 )
	    TmpInt_I = (int) (arg->argv[1]);
	else
	    TmpInt_I = -1;
	COM_GetInt( TmpStr_AC, 1024, TmpInt_I );

	TmpInt_I  = atoi( TmpStr_AC );
	SendInt_B = TRUE;
	break;

      case FN_GETCHAR: {
	  char  Buf_AC[5];
	  if ( arg->argc )
	      COM_Say( arg->argv[0] );
	  if ( arg->argc > 1 )
	      TmpInt_I = (int) (arg->argv[1]);
	  else
	      TmpInt_I = -1;
	  COM_GetChar( &TmpInt_I, TmpInt_I );
	  if (!System_S.Online_B)
	      break;

	  Buf_AC[0] = TmpInt_I;
	  Buf_AC[1] = 0;
	  CALL( COM_Import( Buf_AC, System_S.UserCharset_I ) );
	  TmpInt_I = Buf_AC[0];

	  SendInt_B = TRUE;
	  break;
      }
	
      case FN_GETKEY:
	COM_GetKey( &TmpInt_I );
	SendInt_B = TRUE;
	break;

      case FN_TOKSTR:
	if ( arg->argc > 2 )
	    strcpy( TmpStr_AC, arg->argv[2]);
	else
	    strcpy( TmpStr_AC, ";" );

	STR_TokStr( arg->argv[0], (int) arg->argv[1], TmpStr_AC, &String_PC );
	if (String_PC)
	    ret=FPLSendString( String_PC );
	else
	    ret=FPLSendString("");
	free( String_PC );
	break;

      case FN_SORT: {
	struct fplRef refStruct;
	long l[2];
	unsigned long tags[5];
	int  items,i;
	char** list;

	tags[0] = (long) FPLREF_ARRAY_INFO;
	tags[1] = (long) &refStruct;
	tags[2] = (long) FPLREF_DONE;

	fplReference( key, arg->argv[0], tags );
	items = *refStruct.ArraySize;
	if (!items)
	    break;
	list = (char**) malloc( items * sizeof( char* ) );

	tags[0] = (long) FPLREF_ARRAY_ITEM;
	tags[1] = (long) &l;
	tags[2] = (long) FPLREF_GET_STRING;
	tags[3] = (long) &string;
	tags[4] = (long) FPLREF_DONE;

	l[1] = -1;
	for (i=0; i<items; i++) {
	    int len;
	    l[0] = i;
	    fplReference(key, arg->argv[0], tags );
	    len = FPL_STRLEN( string );
	    list[i] = (char*) fplAllocString( key, len );
	    memcpy(list[i], string, len);
	}

	if ( ( arg->argc > 1 ) && ( !(int)arg->argv[1] ) )
	    qsort(list,items,sizeof(char*),sortCmpi);
	else
	    qsort(list,items,sizeof(char*),sortCmp);

	tags[2] = FPLREF_SET_STRING;
	for (i=0; i<items; i++) {
	    l[0] = i;
	    tags[3] = (long) list[i];

	    fplReference(key, arg->argv[0], tags );
	}
	free( list );
      }
	break;
	

      case FN_SETDATESTR: {
	struct fplRef refStruct;
	long l[2];
	long tags[5];
	char* string;

	tags[0] = (long) FPLREF_ARRAY_ITEM;
	tags[1] = (long) &l;
	tags[2] = (long) FPLREF_GET_STRING;
	tags[3] = (long) &string;
	tags[4] = (long) FPLREF_DONE;

	l[1] = -1;
	for (TmpInt_I=0;TmpInt_I<3;TmpInt_I++) {
	    l[0] = TmpInt_I;

	    fplReference( key, arg->argv[0], (unsigned long*) tags);
	    if (strlen(string))
		strcpy(fil_DayName_AAC[TmpInt_I],string);
	    else
		fil_DayName_AAC[TmpInt_I][0] = 0;	
	}

	for (TmpInt_I=0;TmpInt_I<12;TmpInt_I++) {
	    l[0] = TmpInt_I;
	    fplReference( key, arg->argv[1], (unsigned long*) tags);

	    if (strlen(string))
		strcpy(fil_MonthName_AAC[TmpInt_I],string);
	    else
		fil_MonthName_AAC[TmpInt_I][0] = 0;
	}

      }
	break;

      case FN_PARSECMND: {
	struct fplRef refStruct;
	long l[2];
	unsigned long tags[5];
	char* string;
	char  tmpStr[10];
	int  commands,hits=0;

	tags[0] = (long) FPLREF_ARRAY_INFO;
	tags[1] = (long) &refStruct;
	tags[2] = (long) FPLREF_DONE;

	fplReference( key, arg->argv[1], tags );
	commands = *refStruct.ArraySize;

	tags[0] = (long) FPLREF_ARRAY_ITEM;
	tags[1] = (long) &l;
	tags[2] = (long) FPLREF_GET_STRING;
	tags[3] = (long) &string;
	tags[4] = (long) FPLREF_DONE;

	TmpStr_AC[0] = 0;

	l[1] = -1;
	for (TmpInt_I=0; TmpInt_I<commands; TmpInt_I++) {
	    l[0] = TmpInt_I;

	    fplReference( key, arg->argv[1], tags);

	    if ( STR_Match( string, arg->argv[0] ) ) {
		sprintf(tmpStr,"%d,",TmpInt_I);
		strcat(TmpStr_AC,tmpStr);
		hits++;
	    }
	}
	if (hits)
	    SendString_B = TRUE;
	else
	    SendString_B = FALSE;
      }
	break;

      case FN_RANDOM:
	TmpInt_I = rand() % 1000;
	SendInt_B = TRUE;
	break;

      case FN_GOTOXY:
	sprintf(TmpStr_AC,"\x1b[%d;%dH",
		(int)arg->argv[1],(int)arg->argv[0]);
	COM_Say(TmpStr_AC);
	break;

      case FN_COLOUR: {
	  char* escseq[] = {
	      "\x1b[0;30m", "\x1b[0;31m", "\x1b[0;32m", "\x1b[0;33m",
	      "\x1b[0;34m", "\x1b[0;35m", "\x1b[0;36m", "\x1b[0;37m",
	      "\x1b[1;30m", "\x1b[1;31m", "\x1b[1;32m", "\x1b[1;33m",
	      "\x1b[1;34m", "\x1b[1;35m", "\x1b[1;36m", "\x1b[1;37m"
	  };
	  TmpInt_I = STR_WhatString( arg->argv[0], FPL_Colours_AAC );
	  if (-1==TmpInt_I)
	      break;
	  strcpy(TmpStr_AC, escseq[TmpInt_I]);
	  SendString_B = TRUE;
      }
	break;

	/*
	 *  File functions
	 */

      case FN_FFINDFIRST:
	CHK_SAFE;
	TmpStr_AC[0] = 0;
	if ( arg->argc == 2 )
	    String_PC = arg->argv[1];
	else
	    String_PC = NULL;
	CALL( OS_FindFirst( arg->argv[0], String_PC, TmpStr_AC ) );
	if (TmpStr_AC[0])
	    SendString_B = TRUE;
	break;

      case FN_FFINDNEXT:
	CHK_SAFE;
	TmpStr_AC[0] = 0;
	CALL( OS_FindFirst( NULL,NULL,TmpStr_AC ) );
	if (TmpStr_AC[0])
	    SendString_B = TRUE;
	break;

      case FN_FMOVE:
	CHK_SAFE;
	CALL( FIL_MoveLine( arg->argv[0], arg->argv[1] ) );
	break;

      case FN_FKILL:
	CHK_SAFE;
	CALL( FIL_CutLine( arg->argv[0], NULL ) );
	break;

      case FN_FDELETE:
	CHK_SAFE;
	if(remove( arg->argv[0] ))
	    TmpInt_I = errno;
	else
	    TmpInt_I = 0;
	break;

      case FN_FRENAME:
	CHK_SAFE;
	if(rename( arg->argv[0],arg->argv[1] ))
	    TmpInt_I = errno;
	else
	    TmpInt_I = 0;
	break;

      case FN_GETFFIELD:
	CHK_SAFE;
	CALL( FIL_GetField( arg->argv[0], arg->argv[1], TmpStr_AC ) );
	if ( TmpStr_AC[0] )
	    SendString_B = TRUE;
	break;

      case FN_SETFFIELD:
	CHK_SAFE;
	CALL( FIL_SetField( arg->argv[0], arg->argv[1], arg->argv[2] ) );
	break;

      case FN_GOTOFAREA:
	CHK_SAFE;
	CALL( FIL_SetArea( arg->argv[0], arg->argv[1] ) );
	break;

      case FN_NEWFILES:
	CHK_SAFE;
	CALL( FIL_NewFiles( (int) (arg->argv[0]) ) );
	TmpInt_I = System_S.Halted_B?1:0;
	SendInt_B = TRUE;
	break;

      case FN_FILELIST:
	CHK_SAFE;
	if ( !(arg->argc) ) {
	    TmpInt_I = FIL_ListFiles();
	    SendInt_B = TRUE;
	    break;
	}

	TmpInt_I = STR_WhatString( arg->argv[0], FPL_FileList_AAC );

	if ( -1 == TmpInt_I ) {
	    sprintf( TmpStr_AC, "Unknown filelist() part id: %s", 
		    arg->argv[0] );
	    RET_ERR( TmpStr_AC, 0 );
	}

	FIL_FindString( arg->argv[1], arg->argv[2] );
	TmpInt_I = System_S.Halted_B ? 1 : 0;
	SendInt_B = TRUE;
	break;
	
      case FN_TYPEFILE:
	CHK_SAFE;
	FIL_TypeFile( arg->argv[0], &TmpInt_I );
	SendInt_B = TRUE;
	break;

      case FN_FILEINFO: {
	  t_FileInfo	Info_S;
	  
	  CHK_SAFE;
	  SendInt_B = TRUE;

	  TmpInt_I = STR_WhatString( arg->argv[1], FPL_FileInfo_AAC );

	  if ( -1 == TmpInt_I )
	      break;

	  OS_FileInfo( arg->argv[0], &Info_S );
	  if ( Info_S.Missing_B ) {
	      TmpInt_I = -1;
	      break;
	  }
	  
	  switch ( TmpInt_I ) {
	    case 0: TmpInt_I = Info_S.Size_I;		break;
	    case 1: TmpInt_I = Info_S.Time_S.Year_I;	break;
	    case 2: TmpInt_I = Info_S.Time_S.Month_I;	break;
	    case 3: TmpInt_I = Info_S.Time_S.DayOfMonth_I; break;
	    case 4: TmpInt_I = Info_S.Time_S.Hour_I; 	break;
	    case 5: TmpInt_I = Info_S.Time_S.Minute_I; 	break;
	    case 6: TmpInt_I = Info_S.Time_S.Second_I; 	break;
	    case 7: TmpInt_I = Info_S.Time_S.Time_I;	break;

	    default:
	      SendInt_B = FALSE;
	      RET_ERR( "Unknown fileinfo() part no", (int) (arg->argv[1]) );
	  }
      }
	break;

      case FN_DSZFIELD:
	CHK_SAFE;
	TmpInt_I = STR_WhatString( arg->argv[2], FPL_DszLog_AAC );
	if ( -1 != TmpInt_I ) {
	    FIL_DszLog( arg->argv[0], (int)(arg->argv[1]),TmpInt_I,TmpStr_AC);
	    SendString_B = TRUE;
	}
	    
	break;

      case FN_SPLITPATH: {
	char Filename_AC[256];

	TmpInt_I = STR_WhatString( arg->argv[1], FPL_SplitPath_AAC );

	strcpy( TmpStr_AC, arg->argv[0] );

	String_PC = strrchr( TmpStr_AC, '\\' );
	if (String_PC)
	    *String_PC = 0;
	else
	    break;

	switch ( TmpInt_I ) {
	  case 0:
	    SendString_B = TRUE;
	    break;

	  case 1:
	    String_PC++;
	    ret = FPLSendString( String_PC );
	    break;

	  case -1:
	    sprintf( TmpStr_AC, "Unknown splitpath() part id: %s",
		     arg->argv[0] );
	    RET_ERR( TmpStr_AC, 0 );
	}
	break;
      }

      case FN_CLRFTAGS:
	FIL_ClrTags();
	break;

      case FN_GETFTAG:
	FIL_GetTag( (int) (arg->argv[0]) - 1, TmpStr_AC );
	SendString_B = TRUE;
	break;

	/*
	 *  User functions
	 */
	
      case FN_INITUSER:
	CHK_SAFE;
	USR_Init();
	break;
		
      case FN_LOADUSER:
	CHK_SAFE;
	TmpInt_I = USR_Load( arg->argv[0] );
	SendInt_B = TRUE;
	break;

      case FN_SAVEUSER:
	CHK_SAFE;
	TmpInt_I = USR_Save( arg->argv[0] );
	SendInt_B = TRUE;
	break;

      case FN_GETUSERVAR:
	USR_GetVar( arg->argv[0], &String_PC );
	ret = FPLSendString( String_PC ? String_PC : "" );
	break;

      case FN_SETUSERVAR:
	CHK_SAFE;
	TmpInt_I = USR_SetVar( arg->argv[0], arg->argv[1] );
	SendInt_B = TRUE;
	break;

      case FN_SETSYSVAR:
	CHK_SAFE;
	TmpInt_I = STR_WhatString( arg->argv[0], FPL_SysVar_AAC );
	switch ( TmpInt_I ) {

	    /* colour */
	  case 0:
	    System_S.Color_B = ((int)arg->argv[1])?TRUE:FALSE;
	    break;

	  default:
	    sprintf( TmpStr_AC, "Unknown setsysvar() part id: %s",
		     arg->argv[0] );
	    RET_ERR( TmpStr_AC, 0 );
	}
	break;

      case FN_SETUID:
	CHK_SAFE;
	CALL( MSG_SetUser( arg->argv[0] ) );
	break;

      case FN_GETUID:
	strcpy( TmpStr_AC, MSG_GetUser() );
	SendString_B = TRUE;
	break;

      case FN_RUNFILE:
	CHK_SAFE;
	ret = fplExecuteFile(anchor, arg->argv[0], NULL);
	break;
	
      case FN_RUNSAFE:
	CHK_SAFE;
	RunSafe_I++;

	strcpy(SafePath_AC,arg->argv[1]);
	fplExecuteFileTags(anchor, arg->argv[0], 
			   FPLTAG_CACHEFILE, FPLCACHE_NONE,
			   FPLTAG_ISOLATE,   1, 
			   NULL);
	RunSafe_I--;
	break;
	
      case FN_TOUPPER:
	TmpInt_I = STR_ToUpper( (int)(arg->argv[0]) );
	SendInt_B = TRUE;
	break;
	
      case FN_SETFUNC:
	CHK_SAFE;
	TmpInt_I = STR_WhatString( arg->argv[0], FPL_SetFunc_AAC );

	switch ( TmpInt_I ) {

	  case -1:
	    sprintf( TmpStr_AC, "Unknown setfunc() function id: %s", 
		    arg->argv[0] );
	    RET_ERR( TmpStr_AC, 0 );
	    break;

	  case 0:
	    fpl_MorePrompt_PC = (char*) realloc( fpl_MorePrompt_PC, 
						strlen( arg->argv[1] ) + 1 );
	    if ( NOT fpl_MorePrompt_PC )
		RET_ERR( "Out of memory!", strlen( arg->argv[1] ) + 1 );
	    
	    strcpy( fpl_MorePrompt_PC, arg->argv[1] );
	    break;

	  case 1:
	    fpl_TimeLeft_PC = (char*) realloc( fpl_TimeLeft_PC, 
					      strlen( arg->argv[1] ) + 1 );
	    if ( NOT fpl_TimeLeft_PC )
		RET_ERR( "Out of memory!", strlen( arg->argv[1] ) + 1 );
		
	    strcpy( fpl_TimeLeft_PC, arg->argv[1] );
	    break;

	  case 2:
	    fpl_Timeout_PC = (char*) realloc( fpl_Timeout_PC, 
					      strlen( arg->argv[1] ) + 1 );
	    if ( NOT fpl_Timeout_PC )
		RET_ERR( "Out of memory!", strlen( arg->argv[1] ) + 1 );
		
	    strcpy( fpl_Timeout_PC, arg->argv[1] );
	    break;

	}
	break;
	
      case FN_CLEAR:
	if ( arg->argc )
	    if ( 1 == (int) (arg->argv[0]) )
		COM_Say( CLRSCR );
	
	System_S.Ypos_I = 1;
	break;

      case FN_SLEEP:
	TmpInt_I = (int) arg->argv[0];
	if ( RunSafe_I && ( TmpInt_I > 10000 ) )
	    TmpInt_I = 10000;
	OS_Sleep( TmpInt_I );
	break;


	/*
	 *  Message functions
	 */

      case FN_GOTOMAREA:
	CHK_SAFE;
	TmpInt_I = MSG_GotoArea( arg->argv[0], arg->argv[1], MSG_TYPE_SQUISH );
	SendInt_B = TRUE;
	break;
	
      case FN_GETMAREA:
	CHK_SAFE;
	TmpInt_I = STR_WhatString( arg->argv[0], FPL_AreaParts_AAC );
	if ( -1 == TmpInt_I ) {
	    sprintf( TmpStr_AC, "Unknown getmarea() part id: %s", arg->argv[0] );
	    RET_ERR( TmpStr_AC, 0 );
	}
	else {
	    MSG_AreaInfo( TmpInt_I, &TmpInt_I );
	    SendInt_B = TRUE;
	}
	break;

      case FN_DELMSG:
	CHK_SAFE;
	MSG_DelMsg( (int) (arg->argv[0]) );
	break;
	
      case FN_GETMSG: {
        int Part_I;
	CHK_SAFE;
	Part_I = STR_WhatString( arg->argv[1], FPL_MsgParts_AAC );
	if ( -1 == Part_I ) {
	    sprintf( TmpStr_AC, "Unknown getmsg() part id: %s", arg->argv[1] );
	    RET_ERR( TmpStr_AC, 0 );
	}
	else {
	    if ( 3 == arg->argc )
		TmpInt_I = (int) (arg->argv[2]);
	    else
		TmpInt_I = 0;
	    if ( (-1 == MSG_GetMessage((int) (arg->argv[0]),
				       Part_I,
				       TmpInt_I,
				       &String_PC )) OR ( NOT String_PC ) )
		ret = FPLSendString( "" );
	    else
		ret = FPLSendString( String_PC );
	}
	break;
      }

		
      case FN_PRINTMSG:
	CHK_SAFE;
	TmpInt_I = COM_SayMessage( arg->argv[0], arg->argv[1], arg->argv[2] );
	SendInt_B = TRUE;
	break;
	
      case FN_NEXTMSG:
	CHK_SAFE;
	MSG_NextMessage( (int) (arg->argv[0]), &TmpInt_I );
	SendInt_B = TRUE;
	break;
	
      case FN_SAVEMSGMAP:
	CHK_SAFE;
	MSG_WriteMapFile();
	break;
	
      case FN_MSGMEMBER:
	CHK_SAFE;
	if ( arg->argc > 1 )
	    TmpInt2_I = (int) (arg->argv[1]);
	else
	    TmpInt2_I = -1;

	CALL( MSG_Member( arg->argv[0], TmpInt2_I, &TmpInt_I ) );
	SendInt_B = TRUE;
	break;

      case FN_MARKMSG: {
	  t_Bool IsRead_B;
	  
	  CHK_SAFE;
	  if ( 2 == arg->argc )
	      TmpInt_I = (int) (arg->argv[1]);
	  else
	      TmpInt_I = MSG_NOP;
	  
	  MSG_MarkMessage( (int) (arg->argv[0]), TmpInt_I, &IsRead_B );
	  TmpInt_I = IsRead_B ? 1 : 0;
	  SendInt_B = TRUE;
	  break;
      }

      case FN_CREATEMSG:
	CHK_SAFE;
	CALL( MSG_CreateMessage() );
	break;

      case FN_SENDMSG:
	CHK_SAFE;
	CALL( MSG_SendMessage() );
	break;

      case FN_MSGID:
	CALL( MSG_MsgId( &TmpInt_I ) );
	SendInt_B = TRUE;
	break;

      case FN_PUTMSGFLAG:
	CHK_SAFE;
	TmpInt_I = STR_WhatString( arg->argv[0], FPL_MsgFlag_AAC );
	if ( -1 != TmpInt_I )
	    CALL( MSG_PutMessageFlag( TmpInt_I, (int) (arg->argv[1]) ) );
	else {
	    sprintf( TmpStr_AC, "Unknown putmsgflag() part id: %s", 
		     arg->argv[0] );
	    RET_ERR( TmpStr_AC, 0 );
	}
	break;

      case FN_GETMSGFLAG:
	CHK_SAFE;
	TmpInt2_I = STR_WhatString( arg->argv[1], FPL_MsgFlag_AAC );
	if ( -1 != TmpInt2_I )
	    CALL( MSG_GetMessageFlag( (int)(arg->argv[0]), TmpInt2_I,
				      &TmpInt_I ) );
	else {
	    sprintf( TmpStr_AC, "Unknown getmsgflag() part id: %s", 
		     arg->argv[1] );
	    RET_ERR( TmpStr_AC, 0 );
	}
	SendInt_B = TRUE;
	break;

      case FN_SETMAREASIZE:
	CHK_SAFE;
	MSG_SetAreaSize( (int) arg->argv[0] );
	break;
	
      case FN_PUTMSG:
	CHK_SAFE;
	TmpInt_I = STR_WhatString( arg->argv[0], FPL_MsgParts_AAC );
	if ( -1 != TmpInt_I )
	    CALL( MSG_PutMessage( TmpInt_I, arg->argv[1] ) );
	else {
	    sprintf( TmpStr_AC, "Unknown putmsg() part id: %s", arg->argv[0] );
	    RET_ERR( TmpStr_AC, 0 );
	}
	break;


	/*
	 *  Misc functions
	 */


      case FN_SETUSERTIME:
	CHK_SAFE;
	System_S.HangupTime_I = time(NULL) + (int) (arg->argv[0]);
	break;
 
      case FN_SETTIMEOUT:
	CHK_SAFE;
	System_S.Timeout_I = (int) (arg->argv[0]);
	break;

      case FN_SCREENLEN:
	if ( !RunSafe_I && arg->argc )
	    System_S.Height_I = (int) (arg->argv[0]);
	else {
	    TmpInt_I = System_S.Height_I;
	    SendInt_B = TRUE;
	}
	break;

      case FN_CHARSET:
	CHK_SAFE;
	if ( ( !(int) (arg->argv[0]) ) || ( !(int) (arg->argv[0]) ) )
	    RET_ERR( "Invalid charset value", 0 );
	System_S.UserCharset_I = ((int) (arg->argv[0])) - 1;
	System_S.DataCharset_I = ((int) (arg->argv[1])) - 1;
	break;

      case FN_SYSTEM:
	CHK_SAFE;
	if ( !System_S.Local_B )
	    CALL( SER_Exit() );
	TmpInt_I = system( arg->argv[0] );
	if ( !System_S.Local_B )
	    CALL( SER_Init( System_S.ComHandle_I ) );
	SendInt_B = TRUE;
	break;

      case FN_BYE:
	CHK_SAFE;
	Exit();
	break;

      case FN_NOWTIME:
	TmpInt_I = time( NULL );
	SendInt_B = TRUE;
	break;

      case FN_TIMEPART: {
	  struct tm* Time_PS;
	  time_t     Time_I = (unsigned int) (arg->argv[0]);
	  
	  TmpInt_I = STR_WhatString( arg->argv[1], FPL_TimePart_AAC );
	  if ( -1==TmpInt_I ) {
	      fprintf( stderr, "\nUnknown time part: '%s'.\n", arg->argv[1] );
	      break;
	  }

	  if ( Time_I>0 ) {
	      Time_PS = localtime( &Time_I );
	      switch ( TmpInt_I ) {
		case 0: TmpInt_I = Time_PS->tm_year+1900; break;
		case 1: TmpInt_I = Time_PS->tm_mon + 1; break;
		case 2: TmpInt_I = Time_PS->tm_mday; break;
		case 3: TmpInt_I = Time_PS->tm_hour; break;
		case 4: TmpInt_I = Time_PS->tm_min ; break;
		case 5: TmpInt_I = Time_PS->tm_sec ; break;
		case 6: 
		  TmpInt_I = Time_PS->tm_wday - 1; 
		  if(TmpInt_I<0)
		      TmpInt_I = 6;
		  break;
	      }
	  }
	  else
	      TmpInt_I = 0;
	  SendInt_B = TRUE;
	  break;
      }

      case FN_TIME2STR: {
	  struct tm* Time_PS;
	  time_t     Time_I;

	  Time_I = (int) (arg->argv[0]);

	  if (Time_I<1)
	      strcpy( TmpStr_AC, "<null time>" );
	  else {
	      Time_PS = localtime( &Time_I );
	      sprintf( TmpStr_AC, "%04d-%02d-%02d,%02d:%02d:%02d",
		      Time_PS->tm_year + 1900,
		      Time_PS->tm_mon + 1,
		      Time_PS->tm_mday,
		      Time_PS->tm_hour,
		      Time_PS->tm_min,
		      Time_PS->tm_sec );
	  }
	  String_PC = TmpStr_AC;
	  SendString_B = TRUE;
	  break;
      }

      case FN_STR2TIME: {
	  struct tm Time_S;
	  int yr,mo,da,hr,mn,se;

	  TmpInt_I = sscanf( arg->argv[0],
			    "%04d%*c%02d%*c%02d%*c%02d%*c%02d%*c%02d",
			    &yr, &mo, &da, &hr, &mn, &se );
	  if ( 6 > TmpInt_I )
	      TmpInt_I = 0;
	  else {
	      Time_S.tm_year = yr - 1900;
	      Time_S.tm_mon  = mo - 1;
	      Time_S.tm_mday = da;
	      Time_S.tm_hour = hr;
	      Time_S.tm_min  = mn;
	      Time_S.tm_sec  = se;
	      TmpInt_I = mktime( &Time_S );
	      if ( -1 == TmpInt_I )
		  TmpInt_I = 0;
	  }

	  SendInt_B = TRUE;

	  break;
      }

#if 0
      case FN_LOADFILE:
	CALL( FIL_LoadFile( arg->argv[0], &String_PC ) );
	if ( String_PC ) {
	    FPLSendString( String_PC );
	    free( String_PC );
	}
	else
	    FPLSendString( "" );
#endif


	/* Variables */

      case VR_ERRNO:
	TmpInt_I = FplErr_I;
	SendInt_B= TRUE;
	break;

      case VR_LOCAL:
	TmpInt_I = System_S.Local_B?1:0;
	SendInt_B= TRUE;
	break;

      case VR_COMPORT:
	TmpInt_I = System_S.ComPort_I;
	SendInt_B= TRUE;
	break;

      case VR_COMHANDLE:
	TmpInt_I = System_S.ComHandle_I;
	SendInt_B= TRUE;
	break;

      case VR_TIMELEFT:
	TmpInt_I = System_S.HangupTime_I - time(NULL);
	SendInt_B= TRUE;
	break; 

      case VR_VERSION:
	strcpy(TmpStr_AC,VERSION);
	String_PC = TmpStr_AC;
	SendString_B= TRUE;
	break;

      case VR_FPLVERSION: {
	long Version_I,Revision_I,rc;
	if ( rc = fplSendTags( key, FPLSEND_GETVERSION, &Version_I,
			            FPLSEND_GETREVISION, &Revision_I, NULL ) )
	    RET_ERR( "Error getting FPL version", rc );

	sprintf( TmpStr_AC, "%d.%d", Version_I, Revision_I );
	String_PC = TmpStr_AC;
	SendString_B= TRUE;
      }
	break;

      case VR_SAFEMODE:
	TmpInt_I = RunSafe_I ? 1 : 0;
	SendInt_B= TRUE;
	break; 
    }

    if ( !System_S.Online_B )
	Exit();

    if ( SendInt_B )
	ret=FPLSendInt( TmpInt_I );

    if ( SendString_B )
	ret=FPLSendString( TmpStr_AC );

    return ret;
}
