/******************************************************************************
 *                        FREXX PROGRAMMING LANGUAGE                          *
 ******************************************************************************
 
 compile.c
 
 All compiling functions.
 
 *****************************************************************************/

/************************************************************************
 *                                                                      *
 * fpl.library - A run time library interpreting script langauge.       *
 * Copyright (C) 1992, 1993 FrexxWare                                   *
 * Author: Daniel Stenberg                                              *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2, or (at your option)  *
 * any later version.                                                   *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                      *
 * Daniel Stenberg                                                      *
 * Birger Jarlsgatan 93b 3tr                                            *
 * 113 56 Stockholm                                                     *
 * Sweden                                                               *
 *                                                                      *
 * FidoNet 2:201/328 email: dast@sth.frontec.se                         *
 *                                                                      *
 ************************************************************************/

#include "script.h"
#ifdef COMPILE_AVAIL

ReturnCode REGARG GetString(struct Data *scr, char *string)
{
  /*
   * This function receives a parsed constant string.
   */

  struct fplArgument *pass;
  ReturnCode ret;
  GETMEM(pass, sizeof(struct fplArgument));

  pass->ID=FPL_COMPILE;
  pass->funcdata = (void *)string;
  pass->format = "S";

  CALL(InterfaceCall(scr, pass, scr->function));

  FREE(pass);

  return FPL_OK;
}

ReturnCode REGARG GetSymbol(struct Data *scr, char *string)
{
  /*
   * This function receives a parsed symbol name.
   */

  ReturnCode ret;
  struct fplArgument *pass;
  GETMEM(pass, sizeof(struct fplArgument));

  pass->ID=FPL_COMPILE;
  pass->funcdata = (void *)string;
  pass->format = "S";

  CALL(InterfaceCall(scr, pass, scr->function));

  FREE(pass);

  return FPL_OK;
}

ReturnCode REGARG GetInt(struct Data *scr, int value)
{
  /*
   * This function receives a parsed symbol name.
   */

  ReturnCode ret;
  struct fplArgument *pass;
  GETMEM(pass, sizeof(struct fplArgument));

  pass->ID=FPL_COMPILE;
  pass->funcdata = (void *)value;
  pass->format = "I";

  CALL(InterfaceCall(scr, pass, scr->function));

  FREE(pass);

  return FPL_OK;
}

ReturnCode REGARG GetSpecial(struct Data *scr, CompileCode what)
{
  /*
   * This function receives a parsed symbol name.
   */

  ReturnCode ret;
  struct fplArgument *pass;
  char *output;
  GETMEM(pass, sizeof(struct fplArgument));

  switch(what) {
  case COMP_ERROR:
    output = "The compiler called a function that it shouldn't!\n";
    break;

  case COMP_START_OF_BLOCK:
    output = "{";
    break;

  case COMP_END_OF_BLOCK:
    output = "}";
    break;

  case COMP_END_OF_PROGRAM:
    output = "<end of program>";
    break;

  case COMP_SEMICOLON:
    output = ";";
    break;

  case COMP_START_OF_CODE:
    output = "<start of code>";
    break;

  case COMP_ARRAY:
    output = "<array>";
    break;

  case COMP_COMMA:
    output = ",";
    break;

  case COMP_POSTINC:
    output = "++";
    break;

  case COMP_PREINC:
    output =" ++";
    break;

  case COMP_POSTDEC:
    output = "--";
    break;

  case COMP_PREDEC:
    output = "--";
    break;

  case COMP_START_OF_PARAMETERS:
    output = "<start of parameters>";
    break;

  case COMP_END_OF_PARAMETERS:
    output = "<end of parameters>";
    break;

  case COMP_START_OF_EXPR:
    output = "<start of expression>";
    break;

  case COMP_END_OF_EXPR:
    output = "<end of expression>";
    break;

  case COMP_NOT:
    output ="!";
    break;

  case COMP_1COMPL:
    output ="~";
    break;

  case COMP_PLUS:
    output = "+";
    break;

  case COMP_MINUS:
    output = "-";
    break;

  case COMP_EQUAL:
    output = "==";
    break;

  case COMP_LOGAND:
    output = "&&";
    break;

  case COMP_BINAND:
    output = "&";
    break;

  case COMP_LOGOR:
    output = "||";
    break;

  case COMP_BINOR:
    output = "|";
    break;

  case COMP_BINXOR:
    output = "^";
    break;

  case COMP_COND1:
    output = "?";
    break;

  case COMP_COND2:
    output = ":";
    break;

  case COMP_MULTIPLY:
    output = "*";
    break;

  case COMP_REMAIN:
    output = "%";
    break;

  case COMP_LESSEQ:
    output = "<=";
    break;

  case COMP_SHIFTL:
    output = "<<";
    break;

  case COMP_LESS:
    output = "<";
    break;

  case COMP_GRETEQ:
    output = ">=";
    break;

  case COMP_SHIFTR:
    output = ">>";
    break;

  case COMP_GRET:
    output = ">";
    break;

  case COMP_NOTEQUAL:
    output = "!=";
    break;

  case COMP_START_OF_ARRAYINFO:
    output = "<start of array info>";
    break;

  case COMP_END_OF_ARRAYINFO:
    output = "<end of array info>";
    break;

  case COMP_VARIABLEREF:
    output ="&";
    break;

  case COMP_CMPPLUS:
    output ="+=";
    break;

  case COMP_CMPMINUS:
    output ="-=";
    break;

  case COMP_CMPMUL:
    output ="*=";
    break;

  case COMP_CMPDIV:
    output ="/=";
    break;

  case COMP_CMPAND:
    output ="&=";
    break;

  case COMP_CMPOR:
    output ="|=";
    break;

  case COMP_CMPREMAIN:
    output ="%=";
    break;

  case COMP_CMPXOR:
    output ="^=";
    break;

  case COMP_CMPSHIFTL:
    output ="<<=";
    break;

  case COMP_CMPSHIFTR:
    output =">>=";
    break;

  case COMP_ASSIGN:
    output ="=";
    break;

  case COMP_NO_PARAMETER:
    output ="<no parameter>";
    break;

  case COMP_INT_PARAMETER:
    output ="<int parameter>";
    break;

  case COMP_STRING_PARAMETER:
    output ="<string parameter>";
    break;

  default:
    break;
  }

  pass->ID=FPL_COMPILE;
  pass->funcdata = (void *)output;
  pass->format = "S";

  CALL(InterfaceCall(scr, pass, scr->function));

  FREE(pass);

  return FPL_OK;
}

#endif /* COMPILE_AVAIL */

