#ifndef FILESBBS_H
#define FILESBBS_H

#include <time.h>
#include "stdcode.h"

/****************************************************************************
*
*  Global Defines
*
***************************************************************************/

#define FILE_ID_SIZE	3  	/* 'XX:' */
#define FILE_ID_FN	17998	/* 'F' << 8 + 'N' */
#define FILE_ID_UL	21836
#define FILE_ID_DL	17484
#define FILE_ID_TX	21592
#define FILE_ID_DA	17473

extern char	fil_DayName_AAC[3][10];
extern char	fil_MonthName_AAC[12][10];

/****************************************************************************
*
*  Global Typedefs
*
***************************************************************************/

typedef struct {
    uchar  Millenium_I;
    uchar  Year_I;
    uchar  Month_I;
    uchar  DayOfMonth_I;
    uchar  Hour_I;
    uchar  Minute_I;
    uchar  Second_I;
    time_t Time_I;
} t_FileTime;

typedef struct {
    t_FileTime	Time_S;
    long   	Size_I;
    uint   	Missing_B : 1;
} t_FileInfo;

/****************************************************************************
*
*  Global Function Declarations
*
***************************************************************************/

t_RetCode FIL_TypeFile  ( char*, int* );
t_RetCode FIL_ListFiles ( void );
t_RetCode FIL_FileInfo  ( uchar*, t_FileInfo* );
t_RetCode FIL_SayFile   ( char * );
t_RetCode FIL_DszLog	( char*, int, int, char* );
t_RetCode FIL_ClrTags	( void );
t_RetCode FIL_GetTag	( int, char* );
t_RetCode FIL_FindString( char*, char* );
t_RetCode FIL_SetArea   ( char*, char* );
t_RetCode FIL_NewFiles	( time_t );
t_RetCode FIL_GetField  ( char*, char*, char* );
t_RetCode FIL_SetField  ( char*, char*, char* );
t_RetCode FIL_MoveLine  ( char*, char* );
t_RetCode FIL_CutLine	( char* Filename_PC, char* Result_PC );
t_RetCode FIL_Prepend	( char* Filename_PC, char* Line_PC );

#endif
