/****************************************************************************
*
*  Local Includes
*
***************************************************************************/

#define INCL_DOSFILEMGR   /* File Manager values */
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include <fcntl.h>
#include <share.h>

#include "fplmain.h"
#include "stdcode.h"
#include "comm.h"
#include "mystring.h"
#include "colors.h"
#include "system.h"
#include "os.h"
#include "fplerr.h"

#include "files.h"


/****************************************************************************
*
*  Local Defines
*
***************************************************************************/

#define  FILE_INFO_WIDTH  32
#define  FILE_FILES	  ".files"
#define  MAX_TAGS	  99
#define  MAX_PATH_LEN	  512
#define	 MAX_FILE_LEN	  8192

#define DECLARE_LINES \
    char** Lines_PPC = NULL; \
    int	   Lines_I = 256;

#define ALLOC_LINES \
    Lines_PPC = (char**) malloc( sizeof( char* ) * Lines_I ); \
    if (!Lines_PPC) \
	RET_ERR("Out of memory",Lines_I*sizeof(char*));

#define EXPAND_LINES \
    if (Line_I>=Lines_I){ \
      Lines_I*=4; \
      Lines_PPC = (char**) realloc( Lines_PPC, sizeof(char*)*Lines_I); \
      if(!Lines_PPC) RET_ERR("Out of memory!",sizeof(char*)*Lines_I);\
    }

#define FREE_LINES free(Lines_PPC);

PRIVATE	int	fil_TagNo_I = 0;
PRIVATE char	fil_Tag_AAC[MAX_TAGS][ MAX_TAGS ];
PRIVATE char	fil_FilePath_AC[ MAX_PATH_LEN ];
PRIVATE char	fil_ListPath_AC[ MAX_PATH_LEN ];
PRIVATE t_Bool  fil_FoundFile_B;
PRIVATE t_Bool  fil_FoundField_B;
PRIVATE long	fil_Line_I = 0;
char	fil_DayName_AAC[3][10] = {"Today","Yestrday",""};
char	fil_MonthName_AAC[12][10] = {"Jan","Febr","March","April","May","June",
				     "July","Aug","Sept","Oct","Nov","Dec" };

/****************************************************************************
*
*  Local Function Declarations
*
***************************************************************************/

PRIVATE t_RetCode fil_FindField	( char*, int, char** );
PRIVATE t_RetCode fil_NewLine   ( char*, unsigned int, char*, char* );


/****************************************************************************
*
*  Function:    FIL_Prepend
*  Description: Add a line at the top of a file
*
***************************************************************************/
t_RetCode FIL_Prepend( char* Filename_PC, char* Line_PC )
{
    FILE*  InFile_PS;
    FILE*  OutFile_PS;
    int	   Size_I;
    void*  Buffer_P;
    char   TmpStr_AC[256];
    t_Bool More_B;

    t_FileInfo	Info_S;

    sprintf( TmpStr_AC, "%s.new", Filename_PC );
    OutFile_PS = fopen( TmpStr_AC, "w" );
    if ( !OutFile_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't create '%s'. %s\n", 
		TmpStr_AC, strerror(errno) );
	return OK;
    }

    fprintf( OutFile_PS, "%s", Line_PC );

    CALL(OS_FileInfo(Filename_PC,&Info_S));

    if (!Info_S.Missing_B){
#if 1
	Size_I = 4096;
	Line_PC = (char*) malloc( Size_I );
	if ( NOT Line_PC )
	    RET_ERR( "Out of memory!", Size_I );
	
	InFile_PS = fopen( Filename_PC, "r" );
	if ( !InFile_PS ) {
	    FplErr_I = FPLERR_NO_FILE;
	    fprintf(stderr, "Can't open '%s'. %s\n",
		    Filename_PC, strerror(errno) );
	    return OK;
	}

	for ( STR_ReadLine( InFile_PS, &Line_PC, &Size_I, &More_B );
	     More_B;
	     STR_ReadLine( InFile_PS, &Line_PC, &Size_I, &More_B ) ) {
	    fprintf( OutFile_PS, "%s", Line_PC );
	}
#else
	Size_I = Info_S.Size_I;
	if (Size_I ){
	    Buffer_P = (void*) malloc( Size_I );
	    if(!Buffer_P)
		RET_ERR("Out of memory!",Size_I);

	    fread(Buffer_P,Size_I,1,InFile_PS);
	    fclose(InFile_PS);
	    fwrite(Buffer_P,Size_I,1,OutFile_PS);
	    free(Buffer_P);
	}
#endif
	fclose( InFile_PS );
    }
    fclose( OutFile_PS );

    /* replace the old file with the new */
    if(remove( Filename_PC ))
	RET_ERR("Failed removing .Files!",errno);
    if(rename( TmpStr_AC, Filename_PC ))
	RET_ERR("Failed renaming .Files.new => .Files!",errno);

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_SetArea
*  Description: Copy paths
*
***************************************************************************/
t_RetCode FIL_SetArea( char* ListPath_PC, char* FilePath_PC )
{
    strcpy( fil_FilePath_AC, FilePath_PC );
    strcpy( fil_ListPath_AC, ListPath_PC );

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_GetField
*  Description: Obtain a file field
*
***************************************************************************/
t_RetCode FIL_GetField( char* Filename_PC, char* Field_PC, char* Result_PC )
{
    char   TmpStr_AC[256];
    FILE*  File_PS;
    char*  Line_PC;
    char*  Ptr_PC;
    t_Bool More_B = FALSE;
    int	   Size_I = 1024;
    long   Field_I = ( Field_PC[0] << 8 ) + Field_PC[1];

    fil_FoundFile_B = FALSE;
    *Result_PC = 0;

    File_PS = fopen( fil_ListPath_AC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't open '%s'. %s\n", 
		fil_ListPath_AC, strerror(errno) );
	return OK;
    }

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    fil_Line_I = 0;

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {
	fil_Line_I++;

	if ( isspace( *Line_PC ) )
	    continue;

	Ptr_PC = strchr( Line_PC, ',' );
	if (!Ptr_PC)
	    continue;
	else
	    *Ptr_PC = 0;

	if (!stricmp( Filename_PC, Line_PC ) ) {
	    fil_FoundFile_B = TRUE;
	    *Ptr_PC = ',';
	    CALL( fil_FindField( Line_PC, Field_I, &Ptr_PC ) );
	    if ( Ptr_PC ) {
		strcpy( Result_PC, Ptr_PC );
		free( Ptr_PC );
	    }
	    else
		*Result_PC = 0;
	    break;
	}
    }

    fclose( File_PS );
    free( Line_PC );

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_SetField
*  Description: Change/create a file field
*
***************************************************************************/
t_RetCode FIL_SetField( char* Filename_PC, char* Field_PC, char* Value_PC )
{
    char   TmpStr_AC[4096];
    char   TmpStr2_AC[4096];
    FILE*  File_PS;
    FILE*  OutFile_PS;
    char*  Line_PC;
    char*  Ptr_PC;
    t_Bool More_B = FALSE;
    int	   Size_I = 1024;
    long   Field_I = ( Field_PC[0] << 8 ) + Field_PC[1];

    CALL( FIL_GetField( Filename_PC, Field_PC, TmpStr_AC ) );
    if ( !TmpStr_AC[0] && !fil_FoundFile_B )
	return OK;

    File_PS = fopen( fil_ListPath_AC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't open '%s'. %s\n", 
		fil_ListPath_AC, strerror(errno) );
	return OK;
    }

    sprintf( TmpStr_AC, "%s.new", fil_ListPath_AC );
    OutFile_PS = fopen( TmpStr_AC, "w" );
    if ( !OutFile_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't create '%s'. %s\n", 
		TmpStr_AC, strerror(errno) );
	fclose( File_PS );
	return OK;
    }

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    fil_Line_I = 0;
    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {
	fil_Line_I++;
	Ptr_PC = strchr( Line_PC, ',' );

	if ( (!isspace( *Line_PC )) && Ptr_PC ) {
	    *Ptr_PC = 0;
	    if (!stricmp( Filename_PC, Line_PC ) ) {
		*Ptr_PC = ',';
		strcpy( TmpStr_AC, Line_PC );
		CALL( fil_FindField( Line_PC, Field_I, &Ptr_PC ) );
		if ( Ptr_PC ) {
		    fil_FoundField_B = TRUE;
		    free( Ptr_PC );
		}
		else
		    fil_FoundField_B = FALSE;
		CALL( fil_NewLine( TmpStr_AC, Field_I,
				   Value_PC, TmpStr2_AC ) );
		fprintf( OutFile_PS, "%s", TmpStr2_AC );
	    }
	    else {
		*Ptr_PC = ',';
		fprintf( OutFile_PS, "%s", Line_PC );
	    }
	}
	else
	    fprintf( OutFile_PS, "%s", Line_PC );
    }

    fclose( File_PS );
    fclose( OutFile_PS );
    free( Line_PC );

    /* replace the old file with the new */
    sprintf( TmpStr_AC,  "%s.new", fil_ListPath_AC );
    remove( fil_ListPath_AC );
    rename( TmpStr_AC, fil_ListPath_AC );

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_MoveLine
*  Description: Move a file line from one file to another
*
***************************************************************************/
t_RetCode FIL_MoveLine( char* Filename_PC, char* DestFile_PC )
{
    char   CutLine_AC[4096];
    char   TmpStr_AC[256];
    FILE*  File_PS;
    FILE*  OutFile_PS;
    char*  Line_PC;
    t_Bool More_B = FALSE;
    int	   Size_I = 1024;

    FIL_CutLine( Filename_PC, CutLine_AC );

    File_PS = fopen( DestFile_PC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't open '%s'. %s\n", 
		fil_ListPath_AC, strerror(errno) );
	return OK;
    }

    sprintf( TmpStr_AC, "%s.new", DestFile_PC );
    OutFile_PS = fopen( TmpStr_AC, "w" );
    if ( !OutFile_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't create '%s'. %s\n", 
		TmpStr_AC, strerror(errno) );
	fclose( File_PS );
	return OK;
    }

    fprintf( OutFile_PS, "%s", CutLine_AC );

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {
	fprintf( OutFile_PS, "%s", Line_PC );
    }

    fclose( File_PS );
    fclose( OutFile_PS );
    free( Line_PC );

    /* replace the old file with the new */
    sprintf( TmpStr_AC,  "%s.new", DestFile_PC );
    remove( DestFile_PC );
    rename( TmpStr_AC, DestFile_PC );

    return OK;
}
    

/****************************************************************************
*
*  Function:    fil_NewLine
*  Description: Create a new file list line
*
***************************************************************************/
PRIVATE t_RetCode fil_NewLine( char* Line_PC,  unsigned int Field_I, 
			       char* Field_PC, char* Result_PC )
{
    char*  Ptr_PC;
    char*  ResPtr_PC = Result_PC;
    int    Fi_I;
    t_Bool Break_B = FALSE;

    Ptr_PC = strchr( Line_PC, ',' );
    *Ptr_PC = 0;

    strcpy( ResPtr_PC, Line_PC );
    ResPtr_PC = Result_PC + strlen( Result_PC );

    if ( !fil_FoundField_B ) {
	sprintf( ResPtr_PC, ",%c%c:%s", 
		 Field_I >> 8, Field_I & 0xff, Field_PC );
	ResPtr_PC = Result_PC + strlen( Result_PC );
    }

    while ( !Break_B ) {
	Line_PC = Ptr_PC + 1;
	Fi_I = ( Line_PC[0] << 8 ) + Line_PC[1];

	Ptr_PC = strchr( Line_PC, ',' );
	if ( !Ptr_PC || ( FILE_ID_TX == Fi_I ) )
	    Break_B = TRUE;
	else
	    *Ptr_PC = 0;

	if ( Fi_I == Field_I )
	    sprintf( ResPtr_PC, ",%c%c:%s%s", 
		    Line_PC[0], Line_PC[1], Field_PC,
		    ( FILE_ID_TX == Fi_I )?"\n":"" );
	else
	    sprintf( ResPtr_PC, ",%s", Line_PC );

	ResPtr_PC = Result_PC + strlen( Result_PC );
    }

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_TypeFile
*  Description: Output a file
*
***************************************************************************/
t_RetCode FIL_TypeFile( char* File_PC, int* Status_I )
{
    char   TmpStr_AC[256];
    FILE*  File_PS;
    char*  Line_PC, TmpStr_PC;
    t_Bool Stopped_B = FALSE,More_B;
    int	   Size_I = 1024;
    int	   Line_I = 0;
    int	   Result_I = 0;

    if ( NOT File_PC )
	return OK;

    File_PS = fopen( File_PC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	*Status_I = errno;
	return OK;
    }

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {

	COM_Import( Line_PC, System_S.DataCharset_I );

	if ( OK != COM_Say( Line_PC ) ) {
	    fclose( File_PS );
	    free( Line_PC );
	    return ERROR;
	}

	CALL( COM_ChkBrk() );
	if ( System_S.Halted_B )
	    break;
    }

    fclose( File_PS );
    free( Line_PC );

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_ListFiles
*  Description: List all files in a dir
*
***************************************************************************/
t_RetCode FIL_ListFiles( void )
{
    char   TmpStr_AC[256];
    FILE*  File_PS;
    char*  Line_PC;
    t_Bool Stopped_B = FALSE;
    t_Bool More_B = FALSE;
    t_Bool Fine_B = TRUE;
    int	   Size_I = 1024;
    int	   Result_I = 0;
    int	   Line_I = 0;
    int    i;
    char*  TmpStr_PC;
    DECLARE_LINES;

    if ( NOT fil_ListPath_AC )
	return OK;

    File_PS = fopen( fil_ListPath_AC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't open '%s'. %s\n", 
		fil_ListPath_AC, strerror(errno) );
	return OK;
    }

    ALLOC_LINES;

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {
	i = strlen( Line_PC ) + 1;
	TmpStr_PC = (char*) malloc( i );
	if (!TmpStr_PC)
	    RET_ERR( "Out of memory!", i );
	strcpy( TmpStr_PC, Line_PC );
	Lines_PPC[ Line_I ] = TmpStr_PC;
	Line_I++;
	EXPAND_LINES;
    }
    fclose( File_PS );
    free( Line_PC );

    fil_Line_I = 0;
    for ( i=0; i<Line_I; i++ ) {
	fil_Line_I++;
	Line_PC = Lines_PPC[ i ];

	if ( OK != FIL_SayFile( Line_PC ) ) {
	    Fine_B = FALSE;
	    break;
	}

	CALL( COM_ChkBrk() );
	if ( System_S.Halted_B )
	    break;
    }

    for ( i=0; i<Line_I; i++ )
	free( Lines_PPC[i] );
    FREE_LINES;

    return Fine_B==TRUE?OK:ERROR;
}


/****************************************************************************
*
*  Function:    FIL_FindString
*  Description: Find a string in a field
*
***************************************************************************/

t_RetCode FIL_FindString( char* Field_PC, char* String_PC )
{
    char   TmpStr_AC[256];
    FILE*  File_PS;
    char*  Line_PC;
    char*  FoundStr_PC;
    t_Bool More_B = FALSE;
    int	   Size_I = 1024;
    int	   Line_I = 0;
    int	   Result_I = 0;
    t_Bool Fine_B = TRUE;
    t_Bool First_B = TRUE;
    long   Field_I = ( Field_PC[0] << 8 ) + Field_PC[1];
    int    i;
    char*  TmpStr_PC;
    DECLARE_LINES;

    File_PS = fopen( fil_ListPath_AC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf( stderr, "Can't open '%s'. %s\n", 
		fil_ListPath_AC, strerror(errno) );
	return OK;
    }

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    ALLOC_LINES;

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {

	i = strlen( Line_PC ) + 1;
	TmpStr_PC = (char*) malloc( i );
	if (!TmpStr_PC)
	    RET_ERR( "Out of memory!", i );
	strcpy( TmpStr_PC, Line_PC );
	Lines_PPC[ Line_I ] = TmpStr_PC;
	Line_I++;
	EXPAND_LINES;
    }
    fclose( File_PS );
    free( Line_PC );

    fil_Line_I = 0;
    for ( i=0; i<Line_I; i++ ) {
	fil_Line_I++;
	Line_PC = Lines_PPC[ i ];

	if ( isspace( *Line_PC ) )
	    continue;

	CALL( fil_FindField( Line_PC, Field_I, &FoundStr_PC ) );
	if ( FoundStr_PC ) {
	    if ( stristr( FoundStr_PC, String_PC ) ) {
		if ( First_B ) {
		    COM_Say( "\n\n" );
		    First_B = FALSE;
		}
		if ( OK != FIL_SayFile( Line_PC ) ) {
		    Fine_B = FALSE;
		    break;
		}
	    }
	    else {
	    /* If we're checking in TX field, check FN too... */

		if ( FILE_ID_TX == Field_I) {
		    free( FoundStr_PC );
		    CALL( fil_FindField( Line_PC, FILE_ID_FN, &FoundStr_PC ) );
		    if ( FoundStr_PC ) {
			if ( stristr( FoundStr_PC, String_PC ) ) {
			    if ( First_B ) {
				COM_Say( "\n\n" );
				First_B = FALSE;
			    }
			    if ( OK != FIL_SayFile( Line_PC ) ) {
				Fine_B = FALSE;
				break;
			    }
			}
			free( FoundStr_PC );
		    }
		}
	    }
	}

	CALL( COM_ChkBrk() );
	if ( System_S.Halted_B )
	    break;
    }

    for ( i=0; i<Line_I; i++ )
	free( Lines_PPC[i] );
    FREE_LINES;

    if ( (!First_B) && (!System_S.Halted_B) )
	COM_Say( "\n" );

    return Fine_B==TRUE?OK:ERROR;
}



/****************************************************************************
*
*  Function:    FIL_NewFiles
*  Description: Find all newer files
*
***************************************************************************/
t_RetCode FIL_NewFiles( time_t Time_I )
{
    char   TmpStr_AC[256];
    char   Filename_AC[128];
    char*  Date_PC;
    FILE*  File_PS;
    char*  Line_PC;
    char*  Ptr_PC;
    int	   Size_I = 1024;
    t_Bool Fine_B = TRUE;
    t_Bool First_B = TRUE;
    t_Bool More_B;
    t_FileInfo Info_S;
    int	   Line_I=0;
    int    i;
    char*  TmpStr_PC;
    DECLARE_LINES;

    File_PS = fopen( fil_ListPath_AC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf( stderr, "Can't open '%s'. %s\n", 
		 fil_ListPath_AC, strerror(errno) );
	return OK;
    }

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    ALLOC_LINES;

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {
	i = strlen( Line_PC ) + 1;
	TmpStr_PC = (char*) malloc( i );
	if (!TmpStr_PC)
	    RET_ERR( "Out of memory!", i );
	strcpy( TmpStr_PC, Line_PC );
	Lines_PPC[ Line_I ] = TmpStr_PC;
	Line_I++;
	EXPAND_LINES;
    }
    fclose( File_PS );
    free( Line_PC );

    fil_Line_I = 0;
    for ( i=0; i<Line_I; i++ ) {
	fil_Line_I++;
	
	Line_PC = Lines_PPC[ i ];

	if ( isspace( *Line_PC ) )
	    continue;

	Ptr_PC = strchr( Line_PC, ',' );
	if (!Ptr_PC)
	    continue;
	else
	    *Ptr_PC = 0;

	strcpy(Filename_AC,Line_PC);
	/* Restore the comma... */
	*Ptr_PC = ',';

	/* is there a date stored in the .Files file? */
	CALL( fil_FindField( Line_PC, FILE_ID_DA, &Date_PC ) );
	if ( Date_PC ) {
	    t_FileTime*	t = &(Info_S.Time_S);
	    int y,m,d,c;
	    c=sscanf(Date_PC,"%04d%02d%02d",&y,&m,&d);
	    if(3==c) {
		struct tm ts;

		/* Fill out struct */
		t->Year_I = y - 1900;
		t->Month_I = m;
		t->DayOfMonth_I = d;

		/* Create time_t */
		ts.tm_year = y - 1900;
		ts.tm_mon  = m-1;
		ts.tm_mday = d;
		ts.tm_hour = 0;
		ts.tm_min  = 0;
		ts.tm_sec  = 0;
		t->Time_I = mktime( &ts );
	    }
	    free( Date_PC );
	}
	else {
	    /* get file info */
	    sprintf( TmpStr_AC, "%s\\%s", fil_FilePath_AC, Filename_AC );
	    CALL( OS_FileInfo( TmpStr_AC, &Info_S ) );
	}

	if ( Info_S.Time_S.Time_I >= Time_I ) {
	    if ( First_B ) {
		COM_Say( "\n\n" );
		First_B = FALSE;
	    }
	    if ( OK != FIL_SayFile( Line_PC ) ) {
		Fine_B = FALSE;
		break;
	    }

	    CALL( COM_ChkBrk() );
	    if ( System_S.Halted_B )
		break;
	}
    }

    for ( i=0; i<Line_I; i++ )
	free( Lines_PPC[i] );

    FREE_LINES;

    if ( (!First_B) && (!System_S.Halted_B) )
	COM_Say( "\n" );

    return Fine_B==TRUE?OK:ERROR;
}



/****************************************************************************
*
*  Function:    FIL_SayFile
*  Description: Parse, format and output a line from the file list
*
***************************************************************************/

t_RetCode FIL_SayFile( char* Line_PC )
{
    char*   Descr_PC;
    char*   Date_PC;
    char    ExtraDate_AC[10];
    char*   Filename_PC;
    long    Ul_I;
    long    Dl_I;
    t_FileInfo  Info_S;
    char*   Ptr_PC;
    t_Bool  Eol_B = FALSE;
    t_Bool  Malloc_B = FALSE;
    char    TmpStr_AC[256];
    char    Str_AC[64];
    char    Date_AC[12];
    char*   TmpStr_PC;
    int	    Length_I, i;
    time_t  Time_I;
    t_RetCode Error_I = OK;
    struct tm Time_S;
    struct tm* Time_PS;

    /* if we were passed an empty string */
    if ( NOT strlen( Line_PC ) )
	return OK;

    /* if we were passed a line starting with a space */
    if ( isspace( Line_PC[0] ) ) {
	CALL( COM_Say( CYAN ) );
	CALL( COM_Say( Line_PC ) );
	return OK;
    }    

    /* find first item on line */
    Filename_PC = Ptr_PC = Line_PC;

    Ptr_PC = strchr( Ptr_PC, ',' );
    if ( NOT Ptr_PC ) {
	printf( "???'%s'\n", Line_PC );
	RET_ERR( "No comma after filename!", fil_Line_I );
    }

    /* find date */
    CALL( fil_FindField( Ptr_PC, FILE_ID_DA, &Date_PC ) );
    if ( Date_PC ) {
	strcpy(ExtraDate_AC,Date_PC);
	free( Date_PC );
    }
    else
	ExtraDate_AC[0]=0;

    /* find description */
    CALL( fil_FindField( Ptr_PC, FILE_ID_TX, &Descr_PC ) );
    if ( NOT Descr_PC ) {
	fprintf( stderr, "No TX: field for '%s'\n", Filename_PC );
	return OK;
    }

    Ptr_PC[0] = 0;

    /* clean up the filename */
    CALL( STR_FixCase( Filename_PC ) );

    /* get a long string */
    Length_I = strlen( Filename_PC ) + strlen( Descr_PC );
    if ( 200 < Length_I ) {
	TmpStr_PC = (char*) malloc( Length_I + 100 );
	if ( NOT TmpStr_PC )
	    RET_ERR( "Out of memory!", Length_I+100 );
	Malloc_B = TRUE;
    }
    else {
	TmpStr_PC = TmpStr_AC;
	Malloc_B = FALSE;
    }

    /* get file info */
    sprintf( TmpStr_AC, "%s\\%s", fil_FilePath_AC, Filename_PC );

    CALL( OS_FileInfo( TmpStr_AC, &Info_S ) );

    if ( Info_S.Missing_B ) {
        sprintf( TmpStr_PC, "   %s%-16s%s  missing         %s%s\n",
                 YELLOW, Filename_PC,
                 RED,
                 CYAN,   Descr_PC );
    }
    else {

	/* handle file tags */
	fil_TagNo_I++;
	if ( fil_TagNo_I > MAX_TAGS )
	    fil_TagNo_I = 1;
	strcpy( fil_Tag_AAC[ fil_TagNo_I - 1 ], TmpStr_AC );

	if ( strlen( Filename_PC ) <= 16 ) {
	    sprintf( Str_AC, "%s%-16s%s%8d",
		    YELLOW, Filename_PC, MAGENTA, Info_S.Size_I );
	}
	else {
	    sprintf( Str_AC, "%d", Info_S.Size_I );
	    i = strlen( Str_AC ) + strlen( Filename_PC ) + 1;
	    if ( i > 24 )
		i = 0;
	    else
		i = 24 - i + strlen( Str_AC );
	    sprintf( Str_AC, "%s%-16s %s%*d",
		    YELLOW, Filename_PC, 
		    MAGENTA, i, Info_S.Size_I );
	}

	Time_I = time(NULL);
	Time_PS = localtime( &Time_I );
	Time_S = *Time_PS;

	if (ExtraDate_AC[0]) {
	    t_FileTime*	t = &(Info_S.Time_S);
	    int y,m,d,c;
	    c=sscanf(ExtraDate_AC,"%04d%02d%02d",&y,&m,&d);
	    if(3==c) {
		struct tm ts;

		/* Fill out struct */
		t->Year_I = y - 1900;
		t->Month_I = m;
		t->DayOfMonth_I = d;

		/* Create time_t */
		ts.tm_year = y - 1900;
		ts.tm_mon  = m-1;
		ts.tm_mday = d;
		ts.tm_hour = 0;
		ts.tm_min  = 0;
		ts.tm_sec  = 0;
		t->Time_I = mktime( &ts );
	    }
	}

	sprintf(Date_AC, "%02d-%02d-%02d", 
		Info_S.Time_S.Year_I, 
		Info_S.Time_S.Month_I, 
		Info_S.Time_S.DayOfMonth_I );

	while ( Time_S.tm_year == Info_S.Time_S.Year_I ) {
	    if (fil_MonthName_AAC[Info_S.Time_S.Month_I-1][0])
		sprintf(Date_AC,"%2d %-5.5s",
			Info_S.Time_S.DayOfMonth_I,
			fil_MonthName_AAC[Info_S.Time_S.Month_I-1] );

	    Time_S.tm_hour = 23;
	    Time_S.tm_min  = 59;
	    Time_S.tm_sec  = 59;
	    i = mktime( &Time_S ) - Info_S.Time_S.Time_I;
	    if (i<0)
		break;

	    if ( (i<24*60*60) && fil_DayName_AAC[0][0] ) {
		sprintf(Date_AC, "%-8s", fil_DayName_AAC[0] );
		break;
	    }
	    if ( (i<48*60*60) && fil_DayName_AAC[1][0] ) {
		sprintf(Date_AC, "%-8s", fil_DayName_AAC[1] );
		break;
	    }
	    if ( (i<72*60*60) && fil_DayName_AAC[2][0] ) {
		sprintf( Date_AC, "%-8s", fil_DayName_AAC[2] );
		break;
	    }
	    break;
	}

        sprintf( TmpStr_PC, "%s%2d %s %s%s %s%s\n",
		 RED,	  fil_TagNo_I,
		 Str_AC, 
                 GREEN,   Date_AC,
                 CYAN,    Descr_PC );
    }

    System_S.Indent_I = 37;
    Error_I = COM_Wrap( TmpStr_PC );
    System_S.Indent_I = 0;

    free( Descr_PC );

    if ( Malloc_B )
	free( TmpStr_PC );

    return Error_I;
}


/****************************************************************************
*
*  Function:    FIL_ClrTags
*  Description: Clear file tags
*
***************************************************************************/
t_RetCode FIL_ClrTags( void )
{
    int Tag_I;

    fil_TagNo_I = 0;
    for ( Tag_I = 0; Tag_I < MAX_TAGS; Tag_I++ )
	fil_Tag_AAC[Tag_I][0] = 0;

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_GetTag
*  Description: Get a file tag
*
***************************************************************************/
t_RetCode FIL_GetTag( int TagNo_I, char* Buffer_PC )
{
    if ( TagNo_I < MAX_TAGS )
	strcpy( Buffer_PC, fil_Tag_AAC[ TagNo_I ] );
    else
	Buffer_PC[0] = 0;

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_DszLog
*  Description: Obtain a field from the DSZ log file.
*
***************************************************************************/
t_RetCode FIL_DszLog( char* File_PC, int Line_I, int Field_I, char* Data_PC )
{
    FILE* File_PS;
    char  Line_AC[1024];
    int	  Count_I;
    char* Status_PC;
    int   Spaces_I;
    char* Found_PC = Line_AC;

    /* clear data area */
    Data_PC[0] = 0;

    File_PS = fopen( File_PC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	return OK;
    }

    for ( Count_I = 0; Count_I < Line_I; Count_I++ )
	Status_PC = fgets( Line_AC, 1000, File_PS );

    fclose( File_PS );

    if ( NOT Status_PC )
	return OK;

    switch ( Field_I ) {
      case 0: Spaces_I = 0; break; /* protocol */
      case 1: Spaces_I = 1; break; /* file size */
      case 2: Spaces_I = 2; break; /* DTE speed */
      case 3: Spaces_I = 4; break; /* cps */
      case 4: Spaces_I = 6; break; /* errors */
      case 5: Spaces_I = 8; break; /* flow stops */
      case 6: Spaces_I = 9; break; /* packet size */
      case 7: Spaces_I =10; break; /* filename */
      case 8: Spaces_I =11; break; /* serial no */
    }

    for ( Count_I = 0; Count_I < Spaces_I; Count_I++ ) {
	if ( NOT (Found_PC = strchr( Found_PC, ' ' )))
	    return OK;

	Found_PC = stripspace( Found_PC );
    }

    if ( NOT Found_PC )
	return OK;

    /* primitive word copy */
    Count_I = 0;

    while ( !isspace( Found_PC[ Count_I ] ) ) {
	Data_PC[ Count_I ] = Found_PC[ Count_I ];
	Count_I++;
    }
    Data_PC[ Count_I ] = 0;

    return OK;
}


/****************************************************************************
*
*  Function:    FIL_FindField
*  Description: Obtain a field from a .Files line.
*
***************************************************************************/
t_RetCode fil_FindField( char* OLine_PC, int Field_I, char** Field_PPC )
{
    char* Ptr_PC;
    char* Line_PC;
    int   olen = strlen( OLine_PC ) + 1;

    *Field_PPC = NULL;

    Line_PC = (char*) malloc( olen );
    if(!Line_PC)
	RET_ERR("Out of memory!",olen);
    strcpy( Line_PC, OLine_PC );

    Ptr_PC = strchr( Line_PC, ',' );
    if ( NOT Ptr_PC ) {
	printf(">> '%s'\n",OLine_PC);
	RET_ERR( "No comma after filename!", fil_Line_I );
    }

    if ( FILE_ID_FN == Field_I ) {
	*Ptr_PC = 0;
	*Field_PPC = Line_PC;
	return OK;
    }

    Ptr_PC++; /* skip comma */

    while ( strlen( Ptr_PC ) > 2 ) {
	long Ident_I = ( Ptr_PC[0] << 8 ) + Ptr_PC[1];

	/* skip over 'ID:' string */
	if ( strlen( Ptr_PC ) < 3 )
	    RET_ERR( "Short string.", strlen( Ptr_PC ) );
	Ptr_PC += FILE_ID_SIZE;

	/* is it the right field? */
	if ( Ident_I == Field_I ) {
	    int TruncByte_I,len;
	    char* buf;
	    char* start;

	    start = stripspace( Ptr_PC );

	    if ( FILE_ID_TX == Field_I )
		TruncByte_I = '\n';
	    else
		TruncByte_I = ',';

	    /* truncate string */
	    Ptr_PC = strchr( start, TruncByte_I );
	    if ( Ptr_PC )
		Ptr_PC[0] = 0;

	    /* create mem buf to return */
	    len = strlen( start ) + 1;
	    buf = (char*) malloc( len );
	    if(!buf)
		RET_ERR("Out of memory!",len);
	    strcpy(buf,start);
	    *Field_PPC = buf;
	    break;
	}
	if ( FILE_ID_TX == Ident_I )
	    break;
	Ptr_PC = strchr( Ptr_PC, ',' );
	if ( NOT Ptr_PC )
	    RET_ERR( "No comma after field!", Ident_I );
	Ptr_PC++; /* skip comma */
    }

    free( Line_PC );

    return OK;
}

/****************************************************************************
*
*  Function:    FIL_CutLine
*  Description: Remove a line from a file list
*
***************************************************************************/
t_RetCode FIL_CutLine( char* Filename_PC, char* Result_PC )
{
    char   TmpStr_AC[4096];
    char   TmpStr2_AC[4096];
    FILE*  File_PS;
    FILE*  OutFile_PS;
    char*  Line_PC;
    char*  Ptr_PC;
    t_Bool More_B = FALSE;
    int	   Size_I = 1024;

    File_PS = fopen( fil_ListPath_AC, "r" );
    if ( NOT File_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't open '%s'. %s\n", 
		fil_ListPath_AC, strerror(errno) );
	return OK;
    }

    sprintf( TmpStr_AC, "%s.new", fil_ListPath_AC );
    OutFile_PS = fopen( TmpStr_AC, "w" );
    if ( !OutFile_PS ) {
	FplErr_I = FPLERR_NO_FILE;
	fprintf(stderr, "Can't create '%s'. %s\n", 
		TmpStr_AC, strerror(errno) );
	fclose( File_PS );
	return OK;
    }

    Line_PC = (char*) malloc( Size_I );
    if ( NOT Line_PC )
	RET_ERR( "Out of memory!", Size_I );

    for ( STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B );
	  More_B;
	  STR_ReadLine( File_PS, &Line_PC, &Size_I, &More_B ) ) {

	Ptr_PC = strchr( Line_PC, ',' );

	if ( (!isspace( *Line_PC )) && Ptr_PC ) {
	    *Ptr_PC = 0;
	    if (!stricmp( Filename_PC, Line_PC ) ) {
		*Ptr_PC = ',';
		if ( Result_PC )
		    strcpy( Result_PC, Line_PC );
		continue;
	    }
	    *Ptr_PC = ',';
	}
	fprintf( OutFile_PS, "%s", Line_PC );
    }

    fclose( File_PS );
    fclose( OutFile_PS );
    free( Line_PC );

    /* replace the old file with the new */
    sprintf( TmpStr_AC,  "%s.new", fil_ListPath_AC );
    remove( fil_ListPath_AC );
    rename( TmpStr_AC, fil_ListPath_AC );

    return OK;
}
