/***************************************************************************
*
*  PRIVATE #includes
*
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>

#include "stdcode.h"
#include "fplmain.h"
#include "mystring.h"
#include "os.h"
#include "comm.h"
#include "colors.h"
#include "system.h"
#include "serial.h"
#include "os.h"
#include "fplerr.h"

#include "charsets.h"

/***************************************************************************
*
*  PRIVATE #defines
*
***************************************************************************/

#define  wrappable(c) (isspace(c) || '-'==c)

/***************************************************************************
*
*  PRIVATE functions
*
***************************************************************************/

PRIVATE int	  com_TransInC		( int Char_I );
PRIVATE t_RetCode com_TransInS		( char*, int );
PRIVATE int	  com_TransOutC		( int Char_I );
PRIVATE t_RetCode com_TransOutS		( char*, int );
PRIVATE t_RetCode com_Output		( char*, int );
PRIVATE t_RetCode com_Ident		( void );
PRIVATE t_RetCode com_StripControl	( char* );
#if 0
#define  com_Put(x,y) fwrite( x, y, 1, stdout );fflush(stdout)
#else
PRIVATE t_RetCode com_Put			( void*, int );
#endif

/***************************************************************************
*
*  PRIVATE variables
*
***************************************************************************/

/* translations tables: */

PRIVATE unsigned char com_CharTo850_AAC[][256]= {

    /* CP437 -> CP850 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ' ', 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 0, 190, 'P', 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 0, 0, 0, 0, 0, 0,
      0, 0, '+', '+', '+', '+', 0, 0, 0, 0, '+', '+', 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, '+', '+', 0, 0, 0, 0, 0, 0, 0, '+',
      '+', '+', '+', '+', '+', '+', '+', '+', '+', 0, 0, 0, 0, '|', '|', 0,
      'a', 0, 'F','n','E','o', 0, 'r','f', '0', 'O', 'd', '8', 155, 'E', 'n',
      '=', 0, '>','<','f','J', 0, '=', 0, 250, 0, 'V', 'n', 0, 0, 0
  },

    /* ISO8859-1 -> CP850 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0  ,'','','','','','','','','','','','',  0,'','',
      '','','','','','','','','','','','','','','','',

      '','','','','','','','','','','','','','','','',
      '','','','','','','','','','','','','','','','',
      '','','','','','','','','','','','','','','','',
      '','','','','','','','','','','','','','','',''
  },
	/* ISO-11 -> CP850 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '','','', 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '','','', 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
  }
};

PRIVATE unsigned char com_CharFr850_AAC[][256]= {

	/* CP850 -> CP437  ****** INTE KORREKT!!! ****** */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
  },
	/* CP850 -> ISO 8859-1 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 

      '','','','','','','','','','','','','','','','',
      '','','','','','','','','','','','','','','',0, 
      '','','','','','','','','','','','','','','','',
      0, 0, 0, 0, 0, '','','','',0, 0, 0, 0, '','',0, 
      0, 0, 0, 0, 0, 0, '','',0, 0, 0, 0, 0, 0, 0, '',
      '','','','','',0, '','','',0, 0, 0, 0, '','',0, 
      '','','','','','','','','','','','','','','','',
      0, '',0, '','','','','','','','','','','',0, 0
  },
	/* CP850 -> ISO 11 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '(','/',')', 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '(','!',')', 0, 0,

      'C','u','e','a','{','a','}','c','e','e','e','i','i','i','[',']',
      'E','a','A','o','|','o','u','u','y','\\','U','|','L','\\','x','f',
      'a','i','o','u','n','N','a','o','?','R','-',  0,  0,'!','<','>',
        0,  0,  0,  0,  0,'A','A','A','C','+','+','+','+','c','Y','+',

      '+','+','+','+','-','+','a','A','+','+','+','+','+','+','+','o',
      'd','D','E','E','E','i','i','i','i','+','+',  0,  0,  0,'i',  0,
      'o','B','o','o','O','o','u','P','p','U','U','U','y','Y','-','\'',
      '-',  0,'=',  0,  0,'S','/',',','o',  0,  0,'1','3','2', 0, 0
  }
};


#if 0
t_RetCode COM_CharSet()
{
    int x,y,p;

    /* calculate */
    for ( y=0; y<16; y++ )
	for ( x=0; x<16; x++ ) {
	    p = com_Charset_AAC[ 1 ][ y*16+x ];
	    if ( p )
		com_Charset_AAC[ 3 ][ p ] = y*16+x;
	}
			

    /* display */
    for ( y=0; y<16; y++ ) {
	for ( x=0; x<16; x++ )
	    if ( com_Charset_AAC[ 3 ][ y*16+x ] )
		printf( "'%c',", com_Charset_AAC[ 3 ][ y*16+x ] );
	    else
		printf( "%d, ", com_Charset_AAC[ 3 ][ y*16+x ] );
	
	printf( "\n" );
    }

}
#endif

void COM_SaveTab( void )
{
    FILE* File_PS;
    int x,y;

#if 1
    File_PS = fopen( "transtabs.txt", "a" );

    fprintf( File_PS, "ISO8859-1 => CP850\n\n" );

    for ( y = 0; y < 32; y++ ) {
	for ( x = 0; x < 8; x++ )
	    fprintf( File_PS, "0x%02x, ", com_CharTo850_AAC[1][y*8+x] );
	fprintf( File_PS, "\n" );
    }
#else
    unsigned char buf[2];
    buf[1] = 0;
    File_PS = fopen( "lw.xlt", "wb" );
    for (x=0;x<256;x++) {
	y = com_CharTo850_AAC[1][x];
	if (y)
	    x=y;
	buf[0] = x;
	fwrite( buf, 2, 1, File_PS );
    }
    for (x=0;x<256;x++) {
	y = com_CharFr850_AAC[1][x];
	if (y)
	    x=y;
	buf[0] = x;
	fwrite( buf, 2, 1, File_PS );
    }
#endif
    fclose( File_PS );
}

/***************************************************************************
*
*  Function:	COM_Translate
*  Description: Translate a string
*
***************************************************************************/
t_RetCode COM_Translate( char* String_PC, char** Buf_PPC,
			 int FromSet_I, int ToSet_I )
{
    char* Buf_PC;
    int   Len_I = strlen( String_PC );

    *Buf_PPC = NULL;
    
    /* If anything goes wrong, i'm outta here! */
    if ( ( FromSet_I == ToSet_I ) || (!Len_I ) )
	return OK;

    Buf_PC = (char*) malloc( Len_I );
    if ( !Buf_PC )
	RET_ERR( "Out of memory!", Len_I );

    strcpy( Buf_PC, String_PC );

    CALL( COM_Import( Buf_PC, FromSet_I ) );
    CALL( COM_Export( Buf_PC, ToSet_I ) );

    *Buf_PPC = Buf_PC;

    return OK;
}


/****************************************************************************
*
*  Function:    COM_ChkBrk
*  Description: Check for Ctrl-C keys in the input
*
***************************************************************************/
t_RetCode COM_ChkBrk( void )
{
#if 1
    if ( System_S.Local_B ) {
	if ( OS_KbdHit() )
	    System_S.Halted_B = TRUE;
    }
    else
	/* If remote user is on, only the remote
	   keyboard can stop output. */
	if ( SER_QSize() )
	    System_S.Halted_B = TRUE;

#else

    int Char_I;

    while ( 1 ) {
	if ( System_S.Local_B )
	    Char_I = OS_ReadKey();
	else
	    CALL( SER_ReadC( &Char_I ) );

	switch ( Char_I ) {
	  case -1:
	    return OK;

	  case 3:
	  case 1:
	    System_S.Halted_B = TRUE;
	    break;
	}
    }
#endif

    return OK;
}

/****************************************************************************
*
*  Function:    COM_GetChar
*  Description: Read a char
*
***************************************************************************/
t_RetCode COM_GetChar( int* Char_PI, int Display_I )
{
    static int LastMin_I = -1;
    time_t LastHit_I = 0;
    char a[2] = { 0, 0 };
    int	 Char_I;
    int  Min_I;
    char Buf_AC[5];

    System_S.Ypos_I = 1;

    LastHit_I = time(NULL);

    while ( 1 ) {
	Char_I = OS_ReadKey();
	if ( -1 != Char_I ) {
	    Char_I = com_TransOutC( Char_I );
	    break;
	}
	
	if ( NOT System_S.Local_B ) {
	    CALL( SER_Online( &System_S.Online_B ) );
	    if (!System_S.Online_B)
		return OK;
	    CALL( SER_ReadC( &Char_I ) );
	    if ( -1 == Char_I )
		continue;
	    break;
	}

	/* Call timeleft function */
	Min_I = (System_S.HangupTime_I - time(NULL)) / 60;
	if ( Min_I != LastMin_I ) {
	    FPL_TimeLeft();
	    LastMin_I = Min_I;
	}

	/* Check input timeout */
	if ( System_S.Timeout_I )
	    if ( ( time(NULL) - LastHit_I ) > System_S.Timeout_I ) {
		FPL_Timeout();
		LastHit_I = time(NULL);
	    }
#if 1
	CALL( OS_Sleep( 20 ) );
#endif
    }

    LastHit_I = time(NULL);

    if ( Display_I ) {
	if ( Display_I < 0 )
	    a[0] = Char_I;
	else
	    a[0] = Display_I;
	
	com_Put( a, 1 );
    }

    *Char_PI = Char_I;

    return OK;
}

/****************************************************************************
*
*  Function:    COM_GetKey
*  Description: Return a char from the input queue, or -1 for no data
*
***************************************************************************/
t_RetCode COM_GetKey( int* Char_PI )
{
    int Char_I;

    Char_I = OS_ReadKey();
    if ( -1 != Char_I ) {
	*Char_PI = Char_I;
	return OK;
    }
	
    if ( NOT System_S.Local_B ) {
	CALL( SER_Online( &System_S.Online_B ) );
	CALL( SER_ReadC( &Char_I ) );
	if ( -1 != Char_I ) {
	    *Char_PI = Char_I;
	    return OK;
	}
    }

    *Char_PI = -1;
    return OK;
}


/****************************************************************************
*
*  Function:    COM_GetString
*  Description: Read a string
*
***************************************************************************/
t_RetCode COM_GetString( char* String_PC, int MaxSize_I, int Display_I )
{
    int Pos_I = 0;
    int Char_I = 0;
    char a[2] = { 0, 0 };
    int Break_I = 0;

    if ( NOT MaxSize_I )
	return OK;

    for ( Pos_I = 0; Pos_I < MaxSize_I; Pos_I++ ) {
      
	COM_GetChar( &Char_I, 0 );
	if ( !System_S.Local_B && !System_S.Online_B )
	    return OK;

	switch ( Char_I ) {

	  case 0x0d:	/* CR */
	  case 0x0a:	/* LF */
	    String_PC[ Pos_I ] = 0;
	    if ( !Pos_I )
		FplErr_I = FPLERR_NO_INPUT;
	    else
		FplErr_I = 0;
	    Break_I = 1;
	    break;

	  case 0x7f:	/* DEL */
	  case 0x08:	/* BS */
	    if ( Pos_I > 0 ) {
		Pos_I -= 2;
		if ( Display_I )
		    COM_Say( "\b \b" );
	    }
	    else
		Pos_I -= 1;
	    break;

	  case 0x1b:	/* ESC */
	    Pos_I--;
	    break;

	  default:
	    if ( Display_I ) {
		if ( Display_I < 0 )
		    a[0] = Char_I;
		else
		    a[0] = Display_I;

		com_Put( a, 1 );
	    }
	    String_PC[ Pos_I ] = Char_I;
	    break;
	}
	if ( Break_I )
	    break;
    }

    CALL( COM_Import( String_PC, System_S.UserCharset_I ) );

    return OK;
}

/****************************************************************************
*
*  Function:    COM_GetInt
*  Description: Read a string consisting of only digits
*
***************************************************************************/
t_RetCode COM_GetInt( char* String_PC, int MaxSize_I, int Display_I )
{
    int Pos_I = 0;
    int Char_I = 0;
    char a[2] = { 0, 0 };
    int Break_I = 0;

    if ( NOT MaxSize_I )
	return OK;

    for ( Pos_I = 0; Pos_I < MaxSize_I; Pos_I++ ) {
      
	COM_GetChar( &Char_I, 0 );
	if ( !System_S.Local_B && !System_S.Online_B )
	    return OK;

	switch ( Char_I ) {

	  case 0x0d:	/* CR */
	  case 0x0a:	/* LF */
	    String_PC[ Pos_I ] = 0;
	    if ( !Pos_I )
		FplErr_I = FPLERR_NO_INPUT;
	    else
		FplErr_I = 0;
	    Break_I = 1;
	    break;

	  case 0x7f:	/* DEL */
	  case 0x08:	/* BS */
	    if ( Pos_I > 0 ) {
		Pos_I -= 2;
		if ( Display_I )
		    COM_Say( "\b \b" );
	    }
	    else
		Pos_I -= 1;
	    break;

	  case '-':
	  case '+':
	  case '0':
	  case '1':
	  case '2':
	  case '3':
	  case '4':
	  case '5':
	  case '6':
	  case '7':
	  case '8':
	  case '9':
	    if ( Display_I ) {
		if ( Display_I < 0 )
		    a[0] = Char_I;
		else
		    a[0] = Display_I;
#if 1	
#if 0
		COM_Say( a );
#else
		com_Put( a, 1 );
#endif
#else	
		printf( "0x%02x, ", a[0] );
		fflush(stdout);
#endif	
	    }
	    String_PC[ Pos_I ] = Char_I;
	    break;

	  default:
	    Pos_I--;
	    break;

	}
	if ( Break_I )
	    break;
    }

    return OK;
}

/****************************************************************************
*
*  Function:    COM_Export
*  Description: Convert buffer from CP850 to ToSet charset
*
***************************************************************************/
t_RetCode COM_Export( char* Buf_PC, int ToSet_I )
{
    int UserSet_I = System_S.UserCharset_I;
    int Status_I;

    System_S.UserCharset_I = ToSet_I;

    Status_I = com_TransOutS( Buf_PC, strlen( Buf_PC ) );

    System_S.UserCharset_I = UserSet_I;

    if ( Status_I )
	return ERROR;

    return OK;
}

/****************************************************************************
*
*  Function:    COM_Import
*  Description: Convert buffer from FromSet to CP850 charset
*
***************************************************************************/
t_RetCode COM_Import( char* Buf_PC, int FromSet_I )
{
    int i,Set_I,Char_I,Size_I=strlen( Buf_PC );

    /* if he's using our internal charset, don't translate */
    if ( CHARSET_CP850 == FromSet_I )
	return OK;

    Set_I = FromSet_I - 1;

    for ( i=0; i<Size_I; i++ ) {

	/* if there is a translation for this char */
	if ( com_CharTo850_AAC[ Set_I ][ Buf_PC[i] ] )
	    Buf_PC[i] = com_CharTo850_AAC[ Set_I ][ Buf_PC[i] ];;
    }

    return OK;
}


/****************************************************************************
*
*  Function:    COM_Say
*  Description: Print string
*
***************************************************************************/
t_RetCode COM_Say( char* String_PC )
{
    System_S.Halted_B = FALSE;

    CALL( com_TransOutS( String_PC, strlen( String_PC ) ) );

    com_Output( String_PC, strlen( String_PC ) );

    return OK;
}


/****************************************************************************
*
*  Function:    COM_Wrap
*  Description: Print string with word wrapping
*
***************************************************************************/
t_RetCode COM_Wrap( char* String_PC )
{
    int Len_I = strlen( String_PC );
    int Pos_I;
    int Width_I = System_S.Width_I - 1;
    int Colors_I = 0;

    if ( NOT String_PC )
	return OK;

    if ( NOT Len_I )
	return OK;

    System_S.Halted_B = FALSE;
    CALL( com_TransOutS( String_PC, strlen( String_PC ) ) );

    while ( Width_I < Len_I ) {
        Pos_I = Width_I;

        if ( System_S.Color_B ) {
            CALL( STR_HowMany( String_PC, (char)(0x1b), Width_I, &Colors_I ) );

            if ( Colors_I ) {
                Colors_I *= COL_SIZE;

                /* check if the line really should wrap */
                if ( ( Len_I - Colors_I ) <= Width_I )
                    /* no it fits anyway, leave loop */
                    break;

                /* it should wrap alright, but push the right margin a bit */
                Pos_I += Colors_I;
                if ( Pos_I > Len_I ) {
		    PING;
                    Pos_I = Len_I;
		}
            }
        }

	Pos_I--;
        /* find a place to wrap */
        while( NOT wrappable( String_PC[ Pos_I ] ) AND Pos_I )
            Pos_I--;

        /* do we have somewhere to wrap? */
        if ( Pos_I ) {
	    Pos_I++;
            CALL( com_Output( String_PC, Pos_I ) );
	    if ( System_S.Halted_B )
		return OK;
            String_PC += Pos_I;
            String_PC = stripspace( String_PC );

#if 1
	    CALL( com_Output( "\n", strlen("\n") ) );
	    if ( System_S.Halted_B )
		return OK;
            if ( Len_I = strlen( String_PC ) ) {
#else
                if ( Pos_I < ( Width_I + Colors_I ) ) {
                    CALL( com_Output( "\n", strlen("\n") ) );

		    if ( System_S.Halted_B ) return OK;
		}
		else
		    System_S.Ypos_I++;
#endif
		CALL( com_Ident() );
            }
        }
        /* no, let's do it the hard way */
        else {
            CALL( com_Output( String_PC, Width_I ) );
	    System_S.Ypos_I++;
	    String_PC += Width_I;
            CALL( com_Ident() );
        }

        String_PC = stripspace( String_PC );

        /* check out the string length */
        Len_I = strlen( String_PC );
        if ( NOT Len_I )
            break;

        Width_I = System_S.Width_I - System_S.Indent_I - 1;

	if ( System_S.Halted_B )
	    break;
    }

    if ( NOT System_S.Halted_B )
	CALL( com_Output( String_PC, Len_I ) );

    return OK;
}


/****************************************************************************
*
*  Function:    COM_SayMessage
*  Description: Display a string (long) with standard message parsing
*
***************************************************************************/
t_RetCode COM_SayMessage( char* String_PC, char* QuoteCol_PC, char* NormCol_PC )
{
    char*   Brace_PC;
    char*   NextParagraph_PC;
    char    LineFeed_AC[15] = "\n";
    char    LFLength_I = strlen( LineFeed_AC );
    t_Bool  Quote_B = FALSE;
    int	    i;
    
    /* Strip all LF chars */
    for ( i = 0; String_PC[i]; i++ )
	if ( 0x0a == String_PC[i] )
	    String_PC[i] = 0x20;


    for ( NextParagraph_PC = strchr( String_PC, '\r' );
	  NextParagraph_PC;
	  NextParagraph_PC = strchr( String_PC, '\r' ) ) {
	NextParagraph_PC[0] = 0;

	CALL( com_StripControl( String_PC ) );

	Brace_PC = strchr( String_PC, '>' );
	if ( Brace_PC )
	    Quote_B = ( ( Brace_PC - String_PC ) < 10 );
	else
	    Quote_B = FALSE;
	
	if ( Quote_B )
	    CALL( COM_Say( QuoteCol_PC ) );
#if 1	
	CALL( COM_Wrap( String_PC ) );
	if ( System_S.Halted_B ) return OK;
	CALL( COM_Say( LineFeed_AC ) );
	if ( System_S.Halted_B ) return OK;
#else
	COM_DumpMem( String_PC, strlen( String_PC ) );
#endif
	if ( Quote_B )
	    CALL( COM_Say( NormCol_PC ) );

	if ( NOT strncmp( " * Origin:", String_PC, 10 ) )
	    break;

	String_PC = NextParagraph_PC + 1;
    }

    return OK;
}


/****************************************************************************
*
*  Function:    COM_DumpMem
*  Description: Display a chunk of memory
*
***************************************************************************/
void COM_DumpMem( char* Start_PC, int Size_I )
{
    int Rows_I = Size_I / 16;
    int x,y;

    for ( y=0; y < Rows_I; y++ ) {

		printf( "0x%08x: ", Start_PC );

		for ( x=0; x<16; x++ )
			printf( "%02x ", Start_PC[x] );

		printf( "| " );

		for ( x=0; x<16; x++ )
			printf( "%c", Start_PC[x] >31 ? Start_PC[x] : '.' );

		Start_PC += 16;
		printf( "\n" );
		fflush( stdout );
    }
}

/*==========================================================================
=
=  LOCAL functions
=
===========================================================================*/

/****************************************************************************
*
*  Function:    com_StripControl
*  Description: Strip all control characters from string
*
***************************************************************************/
PRIVATE t_RetCode com_StripControl( char* String_PC )
{
	int i;
	int Len_I = strlen( String_PC ) - 1;

	String_PC = stripspace( String_PC );

	for ( i=0; i < Len_I; i++ )
		if ( ( 32 > String_PC[i] ) OR ( String_PC[i] == 0x8d ) )
			String_PC[i] = 32;

	return OK;
}

/****************************************************************************
*
*  Function:    com_Ident
*  Description: Move to indent position
*
***************************************************************************/
PRIVATE t_RetCode com_Ident( void )
{
    static char String_AC[] = "                                                                                                     ";

    if ( System_S.Indent_I )
        CALL( com_Output( String_AC, System_S.Indent_I ) );

    return OK;
}

/****************************************************************************
*
*  Function:    com_TransOutS
*  Description: Convert buffer from CP850 to user charset
*
***************************************************************************/
PRIVATE t_RetCode com_TransOutS( char* Buf_PC, int Size_I )
{
    int i,Set_I,Char_I,Last_I=0;

    /* if he's using our internal charset, don't translate */
    if ( CHARSET_CP850 == System_S.UserCharset_I )
	return OK;

    Set_I = System_S.UserCharset_I - 1;

    for ( i=0; i<Size_I; i++ ) {

	/* Support escape sequences in 7-bit mode */
	if ((CHARSET_ASCII == (Set_I+1)) && ('['==Buf_PC[i]) && (27 == Last_I))
	    continue;
	Last_I = Buf_PC[i];

	if ( com_CharFr850_AAC[ Set_I ][ Buf_PC[i] ] )
	    Buf_PC[i] = com_CharFr850_AAC[ Set_I ][ Buf_PC[i] ];
    }

    return OK;
}

/****************************************************************************
*
*  Function:    com_TransInS
*  Description: Convert buffer from user charset to CP850
*
***************************************************************************/
PRIVATE t_RetCode com_TransInS( char* Buf_PC, int Size_I )
{
    int i,Set_I,Char_I;

    /* if he's using our internal charset, don't translate */
    if ( CHARSET_CP850 == System_S.UserCharset_I )
	return OK;

    Set_I = System_S.UserCharset_I - 1;

    for ( i=0; i<Size_I; i++ )
	if ( com_CharTo850_AAC[ Set_I ][ Buf_PC[i] ] )
	    Buf_PC[i] = com_CharTo850_AAC[ Set_I ][ Buf_PC[i] ];

    return OK;
}

/****************************************************************************
*
*  Function:    com_TransInC
*  Description: Convert one (1) character from user charset to CP850
*
***************************************************************************/
PRIVATE int com_TransInC( int Char_I )
{
    int i,Set_I,Newchar_I;

    /* if he's using our internal charset, don't translate */
    if ( CHARSET_CP850 == System_S.UserCharset_I )
	return Char_I;

    Set_I = System_S.UserCharset_I - 1;

    if ( com_CharTo850_AAC[ Set_I ][ Char_I ] )
	Newchar_I = com_CharTo850_AAC[ Set_I ][ Char_I ];
    else
	Newchar_I = Char_I;

    return Newchar_I;
}

/****************************************************************************
*
*  Function:    com_TransOutC
*  Description: Convert one (1) character from CP850 to user charset
*
***************************************************************************/
PRIVATE int com_TransOutC( int Char_I )
{
    int i,Set_I,Newchar_I;

    /* if he's using our internal charset, don't translate */
    if ( CHARSET_CP850 == System_S.UserCharset_I )
	return Char_I;

    Set_I = System_S.UserCharset_I - 1;

    if ( com_CharFr850_AAC[ Set_I ][ Char_I ] )
	Newchar_I = com_CharFr850_AAC[ Set_I ][ Char_I ];
    else
	Newchar_I = Char_I;

    return Newchar_I;
}

/****************************************************************************
*
*  Function:    com_Output
*  Description: Actually print the buffer to the device
*  Returns:     0 if output should continue as usual
*               1 if output should be stopped
*
***************************************************************************/
PRIVATE t_RetCode com_Output( char* Buf_PC, int Size_I )
{
    
    int   Status_I = 0;

    if ( NOT Size_I )
	return OK;

    if ( memchr( Buf_PC, '\n', Size_I ) ) {
	char* ThisLine_PC = Buf_PC;
	char* NextLine_PC;
	int   Size2_I = Size_I;

	/* print one line at a time */
	while ( NextLine_PC = memchr( ThisLine_PC, '\n', Size2_I ) ) {
	    
	    Size_I = NextLine_PC + 1 - ThisLine_PC;
	    com_Put( ThisLine_PC, Size_I );
	    ThisLine_PC += Size_I;
	    Size2_I -= Size_I;
	    
	    System_S.Ypos_I++;

	    /* should we "More?" prompt? */
	    if ( System_S.Ypos_I >= System_S.Height_I - 1 )
		CALL( FPL_MorePrompt( &Status_I ) );

	    if ( 1 == Status_I ) {
		System_S.Halted_B = TRUE;
		break;
	    }
	}
	if (!System_S.Halted_B)
	    com_Put( ThisLine_PC, strlen( ThisLine_PC ) );
    }
    else
	com_Put( Buf_PC, Size_I );

    return OK;

#if 0

    char* Pos1_PC = Buf_PC;
    char* Pos2_PC = Buf_PC;
    int   Left_I = Size_I;
    int   Len_I  = 0;

    /* find first newline */
    while ( Pos1_PC = memchr( Pos1_PC, '\n', Left_I ) ) {

        /* see how long this line is */
        Len_I = (int) (Pos1_PC - Pos2_PC);

        /* output this line */
        com_Put( Pos1_PC, Len_I );

        /* output newline */
        com_Put( "\n", sizeof( "\n" ) );

        /* skip over the newline */
        while ( isspace( *Pos1_PC ) )
            Pos1_PC++;

        /* store position of next line */
        Pos2_PC = Pos1_PC;

        /* reduce "to go" count */
        Left_I -= Len_I;
    }

    com_Put( Buf_PC, Size_I );

#if 1
    if ( Pos2_PC )
        System_S.Xpos_I = Left_I;
    else
        System_S.Xpos_I += Size_I;
#endif
#if 0
    printf("(%d,%d,%c)", System_S.Xpos_I, Size_I, Pos2_PC ? 'y':'n' );
#endif

#endif
}

/****************************************************************************
*
*  Function:    com_Put
*  Description: Actually print the buffer to the device
*
***************************************************************************/
PRIVATE t_RetCode com_Put( void* Buf_P, int Size_I )
{
    int	  Len_I, Left_I=Size_I;
    char* Token_PC = (char*) Buf_P;
    char* NewPos_PC;
    char  NewLine_AC[5] = "\x0d\x0a";

    fwrite( Buf_P, Size_I, 1, stdout );
    fflush( stdout );

    if ( ! System_S.Local_B ) {
	while (1) {
	    Len_I = STR_Index( Token_PC, 0x0a, Left_I );
	    if ( -1 != Len_I ) {
		CALL( SER_Write( Token_PC, Len_I ) );
		CALL( SER_Write( NewLine_AC, 2 ) );
		Token_PC += Len_I + 1;
		Left_I -= Len_I + 1;
		if ( !Left_I )
		    break;
	    }
	    else {
		CALL( SER_Write( Token_PC, Left_I ) );
		break;
	    }
	}
    }

    return OK;
}
