/****************************************************************************
*
*  Local Defines
*
***************************************************************************/
#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#define INCL_DOSERRORS

/****************************************************************************
*
*  Local Includes
*
***************************************************************************/
#include <os2.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include "stdcode.h"
#include "os.h"
#include "fplerr.h"

/****************************************************************************
*
*  Local Functions
*
***************************************************************************/
t_RetCode os_CreateTime( FILESTATUS3*, t_FileTime* );

/****************************************************************************
*
*  Function:    OS_FindFirst
*  Description: Find a filename
*
***************************************************************************/
t_RetCode OS_FindFirst( char* Pattern_PC, char* Flags_PC, char* DestBuf_PC )
{
    static ULONG	Attr_I;

    HDIR          FindHandle = 1;
    FILEFINDBUF3  FindBuffer;
    ULONG         FindCount = 1;
    APIRET        rc;          /* Return code */
    int		i;
    char*	ptr;

    Attr_I = FILE_READONLY|FILE_ARCHIVED;

    if ( Pattern_PC ) {
	if ( Flags_PC ) {
	    for( ptr=Flags_PC; *ptr; ptr++ ) {
		switch( *ptr ) {
		  case 'h': Attr_I |= FILE_HIDDEN; break;
		  case 's': Attr_I |= FILE_SYSTEM; break;
		  case 'd': Attr_I |= FILE_DIRECTORY; break;
		    
		  case 'H': Attr_I |= MUST_HAVE_HIDDEN; break;
		  case 'S': Attr_I |= MUST_HAVE_SYSTEM; break;
		  case 'D': Attr_I |= MUST_HAVE_DIRECTORY; break;
		  case 'A': Attr_I |= MUST_HAVE_ARCHIVED; break;
		  case 'R': Attr_I |= MUST_HAVE_READONLY; break;
		}
	    }
	}
 
	rc = DosFindFirst(Pattern_PC,        /* File pattern */
			  &FindHandle,       /* Directory search handle */
			  Attr_I,    	     /* Search attribute */
			  (PVOID) &FindBuffer,/* Result buffer */
			  sizeof(FindBuffer), /* Result buffer length */
			  &FindCount,         /* Number of entries to find */
			  FIL_STANDARD);      /* Return level 1 file info */
    }
    else {
	rc = DosFindNext(FindHandle,         /* Directory handle */
			 (PVOID) &FindBuffer,  /* Result buffer */
			 sizeof(FindBuffer), /* Result buffer length */
			 &FindCount);        /* Number of entries to find */
    }

    if(rc)
	*DestBuf_PC=0;
    else
	strcpy( DestBuf_PC, FindBuffer.achName );
 
    FplErr_I = rc;

    return OK;
}
    
/****************************************************************************
*
*  Function:    OS_FileSize
*  Description: Obtain the size of an open file
*
***************************************************************************/
t_RetCode OS_FileSize( int Handle_I, unsigned long* Size_I )
{
    *Size_I = _filelength( Handle_I );

    return OK;
}

/****************************************************************************
*
*  Function:    OS_FileInfo
*  Description: Obtain info struct about file
*
***************************************************************************/

t_RetCode OS_FileInfo( uchar* Filename_PC, t_FileInfo* Info_PS )
{
static ULONG     BufSize_I = sizeof( FILESTATUS3 );
    FILESTATUS3  InfoBuf_S;
    APIRET       rc = 0;

    rc = DosQueryPathInfo( Filename_PC, 1, &InfoBuf_S, BufSize_I );

    if ( NO_ERROR != rc ) {
        Info_PS->Missing_B = TRUE;
        return OK;
    }

    Info_PS->Missing_B = FALSE;
    Info_PS->Size_I = InfoBuf_S.cbFile;

    CALL( os_CreateTime( &InfoBuf_S, &(Info_PS->Time_S) ) );

    return OK;
}

/****************************************************************************
*
*  Function:    os_CreateTime
*  Description: Create a t_FileTime struct from a FILESTATUS3 struct.
*
***************************************************************************/

t_RetCode os_CreateTime( FILESTATUS3* File_PS, t_FileTime* Time_PS )
{
    struct tm Time_S;

    Time_PS->Year_I      = File_PS->fdateLastWrite.year + 80;
    Time_PS->Month_I     = File_PS->fdateLastWrite.month;
    Time_PS->DayOfMonth_I= File_PS->fdateLastWrite.day;
    Time_PS->Hour_I	 = File_PS->ftimeLastWrite.hours;
    Time_PS->Minute_I    = File_PS->ftimeLastWrite.minutes;
    Time_PS->Second_I    = File_PS->ftimeLastWrite.twosecs*2;
    
    Time_S.tm_year = Time_PS->Year_I;
    Time_S.tm_mon  = Time_PS->Month_I - 1;
    Time_S.tm_mday = Time_PS->DayOfMonth_I;
    Time_S.tm_hour = Time_PS->Hour_I;
    Time_S.tm_min  = Time_PS->Minute_I;
    Time_S.tm_sec  = Time_PS->Second_I;

    Time_PS->Time_I = mktime( &Time_S );

    Time_PS->Hour_I	 = 23;
    Time_PS->Minute_I    = 59;
    Time_PS->Second_I    = 59;

    return OK;
}

/****************************************************************************
*
*  Function:    OS_Milliseconds
*  Description: Report current millisecond count (real-time clock)
*
***************************************************************************/
t_RetCode	OS_Milliseconds( int* Ms_PI )
{
    APIRET rc;
    unsigned long Ms_I;

    rc = DosQuerySysInfo( QSV_MS_COUNT, QSV_MS_COUNT,
			  &Ms_I, sizeof( unsigned long ) );

    if ( rc )
	RET_ERR( "Error fetching millisecond counter.", rc );

    /* Only use milliseconds past the second */
    Ms_I = ( Ms_I % 1000 );

    *Ms_PI = Ms_I;

    return OK;
}

/****************************************************************************
*
*  Function:    OS_ReadKey
*  Description: Read a character from the keyboard
*
***************************************************************************/
int	OS_ReadKey( void )
{
    if ( kbhit() )
	return getch();
    else
	return -1;
}

/****************************************************************************
*
*  Function:    OS_KbdHit
*  Description: Returns 1 if there are characters in the keyboard input queue
*
***************************************************************************/
int	OS_KbdHit( void )
{
    return kbhit();
}

/****************************************************************************
*
*  Function:    OS_Sleep
*  Description: Sleep a number of milliseconds
*
***************************************************************************/
t_RetCode OS_Sleep( int mSec_I )
{
    DosSleep( mSec_I );

    return OK;
}


