#ifndef __MESSAGE_H__
#define __MESSAGE_H__

#include "stdcode.h"

#define	MSG_NOP		-1
#define MSG_MARK	1
#define MSG_UNMARK	0

#define MSG_TYPE_SQUISH 0
#define MSG_TYPE_JAM	1

#define MSG_BUFSIZE 65536
#define M_BODY      0
#define M_FROM      1
#define M_TO        2
#define M_SUBJECT   3
#define M_ORIG      4
#define M_DEST      5
#define M_DATE      6
#define M_REPLYTO   7
#define M_REPLIES   8
#define M_CONTROL   9
#define M_REPLYCNT  10

#define A_FIRST     0
#define A_TOTAL     1
#define A_UNREAD    2

t_RetCode MSG_Init( void );
t_RetCode MSG_Exit( void );

t_RetCode MSG_GotoArea		( char*, char*, int );
t_RetCode MSG_AreaInfo		( int, int* );
t_RetCode MSG_GetMessage	( int, int, int, char** );
t_RetCode MSG_GetMessageFlag	( int, int, int* );
t_RetCode MSG_NextMessage	( int, int* );
t_RetCode MSG_FindNextMessage	( int, int* );
t_RetCode MSG_MarkMessage	( int, int, t_Bool* );
t_RetCode MSG_WriteMapFile	( void );
t_RetCode MSG_PutMessage	( int, char* );
t_RetCode MSG_PutMessageFlag	( int, int );
t_RetCode MSG_CreateMessage	( void );
t_RetCode MSG_SendMessage	( void );
t_RetCode MSG_MsgId		( int* );
t_RetCode MSG_Member		( char*, int, int* );
t_RetCode MSG_DelMsg		( int );
t_RetCode MSG_SetUser		( char* );
char* 	  MSG_GetUser		( void );
t_RetCode MSG_SetAreaSize	( int );

#ifdef MSG_SUBSYSTEM

#define THISMAP		(msg_ThisArea_PS->Map_PS)
#define MSG_PID		"FrexxLink " VERSION

typedef struct {
    ulong   FirstMsg_I;
    ulong   MsgCount_I;
    ulong   MapSize_I;
    t_Bool* Read_PB;
    t_Bool  Member_B;
    t_Bool  Touched_B;
} t_AreaMap;

typedef struct {
    char*   	Tag_PC;
    t_AreaMap*  Map_PS;
    int		Type_I;
    void*   	Next_PS;
} t_Area;

#endif

#endif
