/***************************************************************************
*
*  PRIVATE #includes
*
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "stdcode.h"
#include "fplmain.h"
#include "message.h"
#include "system.h"
#include "charsets.h"
#include "serial.h"
#include "flink.h"

extern char* DateStamp_AC;

/***************************************************************************
*
*  PRIVATE #defines
*
***************************************************************************/
/*
#pragma pack()
*/

/***************************************************************************
*
*  PRIVATE functions
*
***************************************************************************/

        int		main	( int, char* argv[] );
PRIVATE t_RetCode	Init	( int, char* argv[] );

/***************************************************************************
*
*  PRIVATE variables
*
***************************************************************************/

static char	FplFile_AC[64];

/****************************************************************************
*
*  Function:    main
*  Description: Guess what?
*
***************************************************************************/
int main( int argc, char* argv[] )
{
    int 	Status_I;

#if 0
    COM_SaveTab();
    return 0;
#endif

    printf( "FrexxLink %s (%s)  Copyright (C) 1996 Bjrn Stenberg\n", 
	   VERSION, DateStamp_AC );

    if ( Init( argc, argv ) )
	return 3;

    System_S.HangupTime_I = time(NULL) + 15*60;

    Status_I = FPL_Init( FplFile_AC );

    Exit();

    return 0;
}


void Usage(void) {
    printf( "\nusage: FrexxLink [options] [fpl file]\n" );
    printf( "\nOptions are:\n" );
    printf( "  -handle <port handle>    ex: -h %%2 (in a batch file)\n" );
    printf( "  -debug                   enable debug output\n" );
    printf( "\nIf no com handle is specified, local mode is assumed.\n");
    exit(1);
}


/****************************************************************************
*
*  Function:    Init
*  Description: Initialize everything but FPL
*
***************************************************************************/
PRIVATE t_RetCode Init( int argc, char* argv[] )
{
    t_Bool	Handle_B = FALSE;
    int		Param_I;
    char	ComPort_AC[32];
    int		Handle_I;

    FplFile_AC[0] = 0;

    System_S.Local_B = TRUE;
    System_S.Debug_B = FALSE;

    for ( Param_I = 1; Param_I < argc; Param_I++ ) {
	if ( '-' != argv[ Param_I ][ 0 ] )
	    strcpy( FplFile_AC, argv[ Param_I ] );
	else {
	    switch ( toupper( argv[ Param_I ][ 1 ] ) ) {
	      case 'C':
#if 1
		printf("\nParameter -C is no longer supported!\n");
		exit(1);
#else
		Handle_B = System_S.Local_B = FALSE;
		strcpy( ComPort_AC, argv[ Param_I + 1 ] );
		System_S.ComPort_I = atoi( ComPort_AC + 3 );
#endif
		break;
		
	      case 'H':
		Handle_I = atoi( argv[ Param_I + 1 ] );
		if ( Handle_I ) {
		    Handle_B = TRUE;
		    System_S.Local_B = FALSE;
		    System_S.ComHandle_I = Handle_I;
		}
		Param_I++;
		break;
		
	      case 'D':
		System_S.Debug_B = TRUE;
		break;
		
	      default:
		printf( "?Unknown option: '%s'.\n", argv[ Param_I ] );
		return ERROR;
	    }
	}
    }

    if(!FplFile_AC[0])
	Usage();

    if ( NOT System_S.Local_B )
	if ( Handle_B )
	    CALL( SER_Init( Handle_I ) );

    /* setup default system struct */
    System_S.Width_I = 80;
    System_S.Height_I = 43;
    System_S.UserCharset_I  = CHARSET_CP850;
    System_S.DataCharset_I = CHARSET_CP850;
    System_S.Online_B = TRUE;
    System_S.Color_B = TRUE;
    System_S.Timeout_I = 0;
    
    CALL( MSG_Init() );
    
    return OK;
}

/****************************************************************************
*
*  Function:    Exit
*  Description: Deinitialize everything but FPL
*
***************************************************************************/
void Exit( void )
{
    if ( NOT System_S.Local_B ) {
	DBG("Closing com port",0);
	SER_Exit();
    }
    
    DBG("Closing MSGAPI32.DLL",0);
    MSG_Exit();

    DBG("Exiting FrexxLink",0);

    exit(0);
}
