/* The Main Menu */

ARG line

/*
   Below I am defining the return codes for specific control and key
   return codes that AdeptTimedInKey will return
*/

CTRL_A = 1
CTRL_B = 2
CTRL_C = 3
CTRL_D = 4
CTRL_E = 5
CTRL_F = 6
CTRL_G = 7
CTRL_H = 8
CTRL_I = 9
CTRL_J = 10
CTRL_K = 11
CTRL_L = 12
CTRL_N = 14
CTRL_O = 15
CTRL_P = 16
CTRL_Q = 17
CTRL_R = 18
CTRL_S = 19
CTRL_T = 20
CTRL_U = 21
CTRL_V = 22
CTRL_W = 23
CTRL_X = 24
CTRL_Y = 25
CTRL_Z = 26

/*
   Below are the return codes for ANSI, VT100, VT220, and Local keyboard
   entry
*/

HOME   = 71+1024
UP     = 72+1024
PGUP   = 73+1024
BS     = 75+1024
FWD    = 77+1024
END    = 79+1024
DN     = 80+1024
PGDN   = 81+1024
INS    = 82+1024
DEL    = 83+1024
LEFT   = 75+1024
RIGHT  = 77+1024

DisplayTimer = AdeptSetTimer(line, 10)

AdeptSleep(line, 64)
CALL SHOWDATA

GETKEY:
   KeyIn = AdeptComPeekByte(line, 64)
   KeyIn = AdeptPeekKey(line)
   if(KeyIn > 0) then do
      exit
   end
   CALL SHOWDATA
   AdeptSleep(line, 64)
   SIGNAL GETKEY
return

SHOWDATA:
     MyRet = AdeptTimerUp(line, DisplayTimer)
     if MyRet == 1 then
     do
       AdeptPrint(line, "[s[15;2H{CR - {D3-{D4-{D2[u")
       DisplayTimer = AdeptSetTimer(line, 2000)
     end
return
