/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

#include <dir.h>
#include <math.h>

#define EMS_XMS


void far interrupt inlii();
void far interrupt checkai();
void far interrupt plai();
void far interrupt outchri();
void far interrupt outstri();
void far interrupt nli();
void far interrupt pli();
void far interrupt emptyi();
void far interrupt inkeyi();
void far interrupt getkeyi();
void far interrupt inputi();
void far interrupt inputli();
void far interrupt yni();
void far interrupt nyi();
void far interrupt ansici();
void far interrupt oneki();
void far interrupt prti();
void far interrupt mpli();


void far *mallocx(unsigned long l, char *where)
{
  void *x;
  char huge *xx;

  if (!l)
    l=1;
  x=farmalloc(l);
  if (!x) {
    printf("Insufficient memory (%ld bytes) for %s.\n",l,where);
    end_bbs(noklevel);
  }

  xx=(char huge *)x;
  while (l>0) {
    if (l>32768) {
      memset((void *)xx,0,32768);
      l-=32768;
    } else {
      memset((void *)xx,0,l);
      break;
    }
  }

  return(x);
}

#define OFFOF(x) (FP_OFF(&(thisuser.x))-FP_OFF(&thisuser))


int read_config(void)
{
  char s[81];
  int f,i;

  f=sh_open1("CONFIG.DAT",O_RDONLY | O_BINARY);
  if (f<0) {
    printf("CONFIG.DAT NOT FOUND.\n");
    return(1);
  }
  sh_read(f,(void *) (&syscfg), sizeof(configrec));
  sh_close(f);

  f=sh_open1("CONFIG.OVR", O_RDONLY|O_BINARY);
  if ((f>0) && (filelength(f) < (long)instance*(long)sizeof(configoverrec))) {
    f=sh_close(f);
  }
  if (f<0) {
    /* slap in the defaults */
    for (i=0; i<4; i++) {
      syscfgovr.com_ISR[i+1]=syscfg.com_ISR[i+1];
      syscfgovr.com_base[i+1]=syscfg.com_base[i+1];
      syscfgovr.com_ISR[i+5]=syscfg.com_ISR[i+1];
      syscfgovr.com_base[i+5]=syscfg.com_base[i+1];
    }
    syscfgovr.primaryport=syscfg.primaryport;
    strcpy(syscfgovr.modem_type, syscfg.modem_type);
    strcpy(syscfgovr.tempdir, syscfg.tempdir);
    strcpy(syscfgovr.batchdir, syscfg.batchdir);
    if (syscfg.sysconfig & sysconfig_high_speed)
      syscfgovr.comflags |= comflags_buffered_uart;
  } else {
    lseek(f, (instance-1)*sizeof(configoverrec), SEEK_SET);
    read(f, &syscfgovr, sizeof(configoverrec));
    sh_close(f);
  }
  return(0);
}


int save_config(void)
{
  char s[81];
  int f;

  f=sh_open1("CONFIG.DAT",O_RDWR | O_BINARY);
  if(f>0) {
    sh_write(f,(void *) (&syscfg), sizeof(configrec));
    sh_close(f);
    return(0);
  }
  return(1);
}


void read_nextern(void)
{
  int f;
  char s[81];
  long l;

  if (externs)
    farfree(externs);
  externs=NULL;

  sprintf(s,"%sNEXTERN.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f>0) {
    l=filelength(f);
    if (l>15*sizeof(newexternalrec))
      l=15*sizeof(newexternalrec);
    externs=mallocx(l+10, "external protocols");
    numextrn=(sh_read(f,(void *)externs, (unsigned) l))/sizeof(newexternalrec);
    sh_close(f);
  } else
    numextrn=0;
}


void read_editors(void)
{
  int f;
  char s[81];
  long l;

  if(editors)
    farfree(editors);
  editors=NULL;
  sprintf(s,"%sEDITORS.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if(f>0) {
    l=filelength(f);
    if (l>10*sizeof(editorrec))
      l=10*sizeof(editorrec);
    editors=mallocx(l+10, "external editors");
    numed=(sh_read(f,(void *)editors, (unsigned) l))/sizeof(editorrec);
    sh_close(f);
  }
}


void read_nintern(void)
{
  int f;
  char s[81];
  long l;

  if(over_intern)
    farfree(over_intern);
  over_intern=NULL;
  sprintf(s,"%sNINTERN.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY|O_BINARY);
  if (f>0) {
    over_intern=mallocx(3*sizeof(newexternalrec),"interal protocol overrides");
    sh_read(f,over_intern, 3*sizeof(newexternalrec));
    sh_close(f);
  }
}


int read_subs(void)
{
  int f;
  char s[81];

  if(subboards)
    farfree(subboards);
  subboards=NULL;
  max_subs=syscfg.max_subs;
  subboards=(subboardrec *) mallocx(max_subs*sizeof(subboardrec), "subboards");
  sprintf(s,"%sSUBS.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f<0) {
    printf("%s NOT FOUND.\n",s);
    return(1);
  }
  num_subs=(sh_read(f,subboards, (max_subs*sizeof(subboardrec))))/
    sizeof(subboardrec);
  f=sh_close(f);
  return(read_subs_xtr(max_subs, num_subs, subboards));
}


void read_networks(void)
{
  int f,i;
  char s[81],*ss;

  if(net_networks)
    farfree(net_networks);
  net_networks=NULL;
  sprintf(s,"%sNETWORKS.DAT", syscfg.datadir);
  f=sh_open1(s,O_RDONLY|O_BINARY);
  if (f>0) {
    net_num_max=filelength(f)/sizeof(net_networks_rec);
    if (net_num_max) {
      net_networks=mallocx(net_num_max*sizeof(net_networks_rec),"networks.dat");
      sh_read(f, net_networks, net_num_max*sizeof(net_networks_rec));
    }
    sh_close(f);
    for (i=0; i<net_num_max; i++) {
      ss=strchr(net_networks[i].name, ' ');
      if (ss)
        *ss=0;
    }
  }
  if (!net_networks) {
    net_networks=mallocx(sizeof(net_networks_rec), "networks.dat");
    net_num_max=1;
    strcpy(net_networks->name,"WWIVnet");
    strcpy(net_networks->dir, syscfg.datadir);
    net_networks->sysnum=syscfg.systemnumber;
  }
}


int read_names(void)
{
  int f;
  char s[81];

  if(smallist)
    farfree((void *)smallist);
  smallist=NULL;
  smallist=(smalrec *) mallocx(((long)syscfg.maxusers) * ((long)sizeof(smalrec)),
                               "names.lst - try decreasing max users in INIT");
  sprintf(s,"%sNAMES.LST",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f<0) {
    printf("%s NOT FOUND.\n",s);
    return(1);
  }
  huge_xfer(f, smallist, sizeof(smalrec), status.users, 0);
  sh_close(f);
  read_status();
  return(0);
}


void read_voting(void)
{
  int f,n,i;
  char s[81];
  votingrec v;

  for (i=0; i<20; i++)
    questused[i]=0;
  sprintf(s,"%sVOTING.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f>0) {
    n=(int) (filelength(f) / sizeof(votingrec)) -1;
    for (i=0; i<n; i++) {
      sh_lseek(f,(long) i * sizeof(votingrec),SEEK_SET);
      sh_read(f,(void *)&v,sizeof(votingrec));
      if (v.numanswers)
        questused[i]=1;
    }
    f=sh_close(f);
  }
}


int read_dirs(void)
{
  int f;
  char s[81];

  if(directories)
    farfree((void *)directories);
  directories=NULL;
  max_dirs=syscfg.max_dirs;
  directories=(directoryrec huge *)mallocx(((long)max_dirs)*((long)sizeof(directoryrec)),
    "directories");
  sprintf(s,"%sDIRS.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f<0) {
    printf("%s NOT FOUND.\n",s);
    return(1);
  }
  num_dirs=huge_xfer(f, directories, sizeof(directoryrec), max_dirs, 0) /
    sizeof(directoryrec);
  sh_close(f);
  return(0);
}


void read_chains(void)
{
  int f,i,i1;
  char s[81];

  if(chains)
    farfree(chains);
  chains=NULL;
  chains=(chainfilerec *) mallocx(MAX_CHAINS* sizeof(chainfilerec), "chains");
  sprintf(s,"%sCHAINS.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f>0) {
    numchain=(sh_read(f,(void *)chains, MAX_CHAINS*sizeof(chainfilerec)))/
      sizeof(chainfilerec);
    numchain=numchain;
  }
  sh_close(f);
#ifdef OPT_CHAIN_REG
  if(chains_reg)
    farfree(chains_reg);
  chains_reg=NULL;
  chains_reg=(chainregrec *) mallocx(MAX_CHAINS* sizeof(chainregrec),
    "chain registration");
  sprintf(s,"%sCHAINS.REG",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f>0) {
    sh_read(f,(void *)chains_reg, MAX_CHAINS*sizeof(chainregrec));
  } else {
    for(i=0;i<numchain;i++) {
      for (i1=0; i1<sizeof(chains_reg[i].regby)/sizeof(chains_reg[i].regby[0]); i1++)
        chains_reg[i].regby[i1]=0;
      chains_reg[i].usage=0;
    }
    f=sh_open(s,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    sh_write(f,(void *) (chains_reg), (sizeof(chainregrec) * numchain));
  }
  sh_close(f);
#endif
}


int read_language(void)
{
  int f;
  char s[81];

  if(languages)
    farfree(languages);
  languages=NULL;
  sprintf(s,"%sLANGUAGE.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY|O_BINARY);
  if (f>=0) {
    num_languages=filelength(f)/sizeof(languagerec);
    if (num_languages) {
      languages=mallocx(num_languages*sizeof(languagerec),"language.dat");
      sh_read(f,languages,num_languages*sizeof(languagerec));
    }
    sh_close(f);
  }
  if (!num_languages) {
    languages=mallocx(sizeof(languagerec),"language.dat");
    num_languages=1;
    strcpy(languages->name,"English");
    strncpy(languages->dir,syscfg.gfilesdir, sizeof(languages->dir)-1);
  }
  cur_lang=-1;
  if (set_language(0)) {
    printf("You need the default language fully installed to run the BBS.\n");
    return(1);
  }
  return(0);
}


int read_modem(void)
{
  int f;
  char s[81];
  long l;

  if(modem_i)
    farfree(modem_i);
  modem_i=NULL;
  if(instance > 1)
    sprintf(s,"%sMODEM.%3.3d",syscfg.datadir,instance);
  else
    sprintf(s,"%sMODEM.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f>0) {
    l=filelength(f);
    modem_i = mallocx(l, "modem.dat");
    sh_read(f,modem_i, (unsigned) l);
    sh_close(f);
    return(0);
  } else {
    printf("\nRun INIT.EXE to convert modem data.\n\n");
    return(1);
  }
}


void read_gfile(void)
{
  int f;
  char s[81];

  if(gfilesec)
    farfree(gfilesec);
  gfilesec=NULL;
  gfilesec=(gfiledirrec *) mallocx((long) (MAX_GFILESEC* sizeof(gfiledirrec)), "gfiles");
  sprintf(s,"%sGFILE.DAT",syscfg.datadir);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f<0)
    num_sec=0;
  else
    num_sec=sh_read(f,(void *)gfilesec,MAX_GFILESEC*sizeof(gfiledirrec))/sizeof(gfiledirrec);
  sh_close(f);
}

int make_abs_path(unsigned char *checkdir)
/*
 * Makes a path into an absolute path, returns 1 if original path altered,
 * else returns 0.
 */
{
  unsigned char olddir[81];

  if ((strlen(checkdir)<3) || (checkdir[1]!=':') || (checkdir[2]!='\\')) {
    get_dir(olddir,1);
    cd_to(cdir);
    cd_to(checkdir);
    get_dir(checkdir, 1);
    cd_to(olddir);
    return(1);
  }
  return(0);
}

void fix_paths(void)
/*
 * Makes relative paths into absolute paths. Can solve some hard-to-find
 * problems.
 */
{
  int f=-1, update=0;

  /* config.dat paths */
  if (make_abs_path(syscfg.gfilesdir))
    update|=1;
  if (make_abs_path(syscfg.datadir))
    update|=1;
  if (make_abs_path(syscfg.msgsdir))
    update|=1;
  if (make_abs_path(syscfg.dloadsdir))
    update|=1;

  /* config.ovr paths */
  if (make_abs_path(syscfgovr.tempdir)) {
    if (instance==1) {
      strncpy(syscfg.tempdir,syscfgovr.tempdir,sizeof(syscfg.tempdir));
      update|=1;
    }
    update|=2;
  }
  if (make_abs_path(syscfgovr.batchdir)) {
    if (instance==1) {
      strncpy(syscfg.batchdir,syscfgovr.batchdir,sizeof(syscfg.batchdir));
      update|=1;
    }
    update|=2;
  }

  if (update&1) {
    save_config();
  }
  if (update&2) {
    f=sh_open1("CONFIG.OVR", O_RDWR|O_BINARY);
    if ((f<0) || (filelength(f) < (long)instance*(long)sizeof(configoverrec)))
      f=sh_close(f);
    else {
      lseek(f, (instance-1)*sizeof(configoverrec), SEEK_SET);
      write(f, &syscfgovr, sizeof(configoverrec));
      sh_close(f);
    }
  }
}


void init(void)
{
  char *ss,s[161];
  int i,i1,sm;
  int f1,f2,f3,f4,f5,f6,f7, pk;
  union REGS r;
  struct date today;

  save_dos=find_interrupt();
  if (!save_dos) {
    printf("\nNo spare interrupt vector found to use.\n\n");
    end_bbs(noklevel);
  }
  crttype=peekb(0x0040,0x0049);
  if (crttype==7)
    scrn=MK_FP(0xb000,0x0000);
  else
    scrn=MK_FP(0xb800,0x0000);

  detect_multitask();

  r.h.ah=15;
  int86(0x10,&r,&r);
  sm=r.h.al;
  if (r.h.ah!=80) {
    printf("\n\nYou must be in 80 column mode to run WWIV.\n\n");
    end_bbs(noklevel);
  }
  if ((sm==4) || (sm==5) || (sm==6)) {
    printf("\n\nYou must be in text mode to run WWIV.\n\n");
    end_bbs(noklevel);
  }
  defscreenbottom=(int) peekb(0x0000,0x0484);
  if (defscreenbottom<24)
    defscreenbottom=24;
  if (defscreenbottom>63)
    defscreenbottom=24;
  if ((defscreenbottom!=42) && (defscreenbottom!=49))
    defscreenbottom=24;
  screenbottom=defscreenbottom;
  screenlen=160*(screenbottom+1);
  if(instance > 1)
    sprintf(s,"RESTORE.%3.3d",instance);
  else
    sprintf(s,"RESTORE.WWV");
  if (!exist(s)) {
    for (i=0; i<screenbottom; i++)
      printf("\n");
    strcpy(s,wwiv_version);
    strcat(s,", Copyright (c) 1988-1993 by Wayne Bell.\n\n");
    printf(s);
  }
  strcpy(cdir,"X:\\");
  cdir[0]='A'+getdisk();
  getcurdir(0,&(cdir[3]));


#ifdef EMS_XMS
  if (_OvrInitEms(0,0,16)!=0)
    _OvrInitExt(0L,0);
#endif

  curlsub=-1;
  curldir=-1;
  setvect(save_dos, getvect(INT_REAL_DOS));
  oldx=0;
  oldy=0;
  itimer();
  r.h.ah=0x33;
  r.h.al=0x01;
  r.h.dl=0x00;
  int86(INT_REAL_DOS,&r,&r);
  use_workspace=0;
  input_extern=0;
  chat_file=0;
  sysop_alert=0;
  global_handle=0;
  tagptr=0;

  for (i=0; i<25; i++)
    funcs[i]=NULL;
  funcs[0]=(void far *)inlii;
  funcs[1]=(void far *)checkai;
  funcs[2]=(void far *)plai;
  funcs[3]=(void far *)outchri;
  funcs[4]=(void far *)outstri;
  funcs[5]=(void far *)nli;
  funcs[8]=(void far *)pli;
  funcs[9]=(void far *)emptyi;
  funcs[10]=(void far *)inkeyi;
  funcs[11]=(void far *)getkeyi;
  funcs[12]=(void far *)inputi;
  funcs[13]=(void far *)inputli;
  funcs[14]=(void far *)yni;
  funcs[15]=(void far *)nyi;
  funcs[16]=(void far *)ansici;
  funcs[17]=(void far *)oneki;
  funcs[18]=(void far *)prti;
  funcs[19]=(void far *)mpli;
  sprintf(ver_no2,"WWIV_FP=%04.4X:%04.4X",FP_SEG(funcs), FP_OFF(funcs));

  strcpy(ver_no1,"BBS=");
  strcat(ver_no1,wwiv_version);

  getdate(&today);
  if (today.da_year<1988) {
    printf("You need to set the date & time before running the BBS.\n");
    end_bbs(noklevel);
  }

  if (read_config())
    end_bbs(noklevel);

  fix_paths();

  write_inst(INST_LOC_INIT,0,INST_FLAGS_NONE);

  /* make sure it is the new userrec structure */
  sprintf(s,"%sUSER.QSC",syscfg.datadir);
  if (!exist(s)) {
    printf("You must go into INIT and convert your userlist before running the BBS.\n");
    end_bbs(noklevel);
  }

  /* update user info data */
  f1=sizeof(userrec);
  f2=OFFOF(waiting);
  f3=OFFOF(inact);
  f4=OFFOF(sysstatus);
  f5=OFFOF(forwardusr);
  f6=OFFOF(forwardsys);
  f7=OFFOF(net_num);

  if ((f1!=syscfg.userreclen) ||
      (f2!=syscfg.waitingoffset) ||
      (f3!=syscfg.inactoffset) ||
      (f4!=syscfg.sysstatusoffset) ||
      (f5!=syscfg.fuoffset) ||
      (f6!=syscfg.fsoffset) ||
      (f7!=syscfg.fnoffset)) {

    syscfg.userreclen=f1;
    syscfg.waitingoffset=f2;
    syscfg.inactoffset=f3;
    syscfg.sysstatusoffset=f4;
    syscfg.fuoffset=f5;
    syscfg.fsoffset=f6;
    syscfg.fnoffset=f7;

    /* store the new config.dat file */
    save_config();
  }

  if (!syscfgovr.primaryport)
    ok_modem_stuff=0;

  languages=NULL;
  if(read_language())
    end_bbs(noklevel);

  net_networks=NULL;
  net_num=0;
  read_networks();
  set_net_num(0);

  strcpy(s,syscfgovr.tempdir);
  i=strlen(s);
  if (s[0]==0)
    i1=1;
  else {
    if ((s[i-1]=='\\') && (s[i-2]!=':'))
      s[i-1]=0;
    i1=chdir(s);
  }
  if (i1) {
    printf("\nYour temporary directory isn't valid.\n");
    printf("It is now set to: '%s'\n\n",syscfgovr.tempdir);
    end_bbs(noklevel);
  } else
    cd_to(cdir);

  strcpy(s,syscfgovr.batchdir);
  i=strlen(s);
  if (s[0]==0)
    i1=1;
  else {
    if ((s[i-1]=='\\') && (s[i-2]!=':'))
      s[i-1]=0;
    i1=chdir(s);
  }
  if (i1) {
    printf("\nYour batchdirectory isn't valid.\n");
    printf("It is now set to: '%s'\n\n",syscfgovr.batchdir);
    end_bbs(noklevel);
  } else
    cd_to(cdir);

  get_status(0, 1);

  status.wwiv_version=wwiv_num_version;
  if (status.callernum!=65535) {
    status.callernum1=(long)status.callernum;
    status.callernum=65535;
  }
  save_status();

  gat=(unsigned short *) mallocx(2048 * sizeof(short), "gat");

  gfilesec=NULL;
  read_gfile();

  smallist=NULL;

  if(read_names())
    end_bbs(noklevel);

  subboards=NULL;

  if(read_subs())
    end_bbs(noklevel);

  directories=NULL;

  if(read_dirs())
    end_bbs(noklevel);

  numchain=0;
  chains=NULL;
  read_chains();

  modem_i=NULL;
  if(read_modem())
    end_bbs(noklevel);

  numextrn=0;
  externs=NULL;
  read_nextern();

  over_intern=NULL;
  read_nintern();

  numed=0;
  editors=NULL;
  read_editors();

  batch=mallocx(MAX_BATCH * sizeof(batchrec), "batch list");
  filelist=(tagrec *) mallocx(50 * sizeof(tagrec),"File tag list");

  read_user(1,&thisuser);
  if (thisuser.inact & inact_deleted)
    fwaiting=0;
  else
    fwaiting=thisuser.waiting;

  read_status();
  if (ok_modem_stuff && !restoring_shrink) {
    initport(syscfgovr.primaryport);
    do_result(&(modem_i->defl));
  }
  if (syscfg.sysconfig & sysconfig_no_local)
    topdata=0;
  else
    topdata=2;
  ss=getenv("PROMPT");
  strcpy(newprompt,"PROMPT=WWIV: ");
  if (ss)
    strcat(newprompt,ss);
  else
    strcat(newprompt,"$P$G");
  if(instance > 1)
    sprintf(dszlog,"%s\\WWIVDSZ.%3.3d",cdir,instance);
  else
    sprintf(dszlog,"%s\\WWIVDSZ.LOG",cdir);
  sprintf(s,"DSZLOG=%s",dszlog);
  pk=i=i1=0;
  while (environ[i]!=NULL) {
    if (strncmp(environ[i],"PKNOFASTCHAR=",13)==0)
      pk=1;
    if (strncmp(environ[i],"PROMPT=",7)==0)
      xenviron[i1++]=newprompt;
    else
      if (strncmp(environ[i],"DSZLOG=",7)==0)
        xenviron[i1++]=strdup(s);
      else {
        if ((strncmp(environ[i],"BBS=",4)) &&
            (strncmp(environ[i],"WWIV_FP=",8)) &&
            (strncmp(environ[i],"WWIV_NET=",8)))
          xenviron[i1++]=environ[i];
      }
    ++i;
  }
  if (!getenv("DSZLOG"))
    xenviron[i1++]=strdup(s);
  if (!ss)
    xenviron[i1++]=newprompt;
  xenviron[i1++]=ver_no1;
  xenviron[i1++]=ver_no2;
  xenviron[i1++]=wwiv_net_no;
  if (!pk)
    xenviron[i1++]="PKNOFASTCHAR=Y";
  xenviron[i1]=NULL;

  read_voting();

  if (syscfgovr.comflags & comflags_buffered_uart)
    high_speed=1;
  else
    high_speed=0;
  time_event=((double)syscfg.executetime)*60.0;
  last_time=time_event-timer();
  if (last_time<0.0)
    last_time+=24.0*3600.0;
  do_event=0;
  msgs=(postrec *) mallocx((long)(255 * sizeof(postrec)), "posts");

  usub=(usersubrec *)mallocx(max_subs*sizeof(usersubrec), "usub");
  sub_dates=(unsigned long *) mallocx(max_subs*sizeof(long),"sub_dates");

  udir=(usersubrec *)mallocx(max_dirs*sizeof(usersubrec), "udir");
  dir_dates=(unsigned long *) mallocx(max_dirs*sizeof(long),"dir_dates");

  uconfsub=(userconfrec *)mallocx(MAX_CONFERENCES*sizeof(userconfrec), "uconfsub");
  uconfdir=(userconfrec *)mallocx(MAX_CONFERENCES*sizeof(userconfrec), "uconfdir");

  qsc=(unsigned long *)mallocx(syscfg.qscn_len, "quickscan");
  qsc_n=qsc+1;
  qsc_q=qsc_n+(max_dirs+31)/32;
  qsc_p=qsc_q+(max_subs+31)/32;

  ss=getenv("WWIV_INSTANCE");
  if (ss) {
    i=atoi(ss);
    if (i>0)
      sprintf(nete,".%3.3d",i);
    else
      strcpy(nete,".NET");
  } else {
    strcpy(nete,".NET");
  }

  read_bbs_list_index();
  frequent_init();
  if (!restoring_shrink && !already_on) {
    remove_from_temp("*.*", syscfgovr.tempdir, 1);
    remove_from_temp("*.*", syscfgovr.batchdir, 1);
    imodem(1);
    cleanup_net();
  }

  lecho=ok_local();
  daylight=0;
  find_devices();

  subconfnum=dirconfnum=0;
  read_all_conferences();

  if (!restoring_shrink && !already_on) {
    sprintf(s,"%s, inst %d, brought up at %s on %s.",wwiv_version,
            instance, times(), date());
    sl1(0,"");
    sl1(0,s);
    sl1(0,"");
  }

  if(instance > 1)
    sprintf(s,"WWIV_NET.%3.3d",instance);
  else
    sprintf(s,"WWIV_NET.DAT");
  unlink(s);

  randomize();

  if (!restoring_shrink)
    catsl();

  write_inst(INST_LOC_WFC,0,INST_FLAGS_NONE);
}
