/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

#include "subxtr.h"

#include <dir.h>




#define ALLOW_FULLSCREEN 1
#define EMAIL_STORAGE 2

/****************************************************************************/

void send_net_post(postrec *p, char *extra, int subnum)
{
  net_header_rec nh, nh1;
  char *b, *b1;
  long len1, len2;
  char s[81];
  int f,i,onn,nn,n,nn1;
  unsigned int *list;
  xtrasubsnetrec *xnp;

  b=readfile(&(p -> msg),extra,&len1);
  if (b==NULL)
    return;

  onn=net_num;
  if (p->status & status_post_new_net)
    nn=p->title[80];
  else if (xsubs[subnum].num_nets)
    nn=xsubs[subnum].nets[0].net_num;
  else
    nn=net_num;

  nn1=nn;
  if (p->ownersys==0)
    nn=-1;

  nh1.tosys=0;
  nh1.touser=0;
  nh1.fromsys=p->ownersys;
  nh1.fromuser=p->owneruser;
  nh1.list_len=0;
  nh1.daten=p->daten;
  nh1.length=len1+1+strlen(p -> title);
  nh1.method=0;

  if (nh1.length > 32755) {
    outstr(get_string(645));
    npr("%lu",nh1.length-32755L);
    outstr(get_string(646));
    nh1.length = 32755;
    len1=nh1.length-strlen(p->title)-1;
  }

  if ((b1=malloca(nh1.length+100))==NULL) {
    farfree(b);
    set_net_num(onn);
    return;
  }

  strcpy(b1,p -> title);
  memmove(&(b1[strlen(p -> title)+1]),b,(unsigned int) len1);
  farfree(b);

  for (n=0; n<xsubs[subnum].num_nets; n++) {
    xnp=&(xsubs[subnum].nets[n]);

    if ((xnp->net_num==nn) && (xnp->host))
      continue;

    set_net_num(xnp->net_num);

    nh=nh1;
    list=NULL;
    nh.minor_type=xnp->type;
    if (!nh.fromsys)
      nh.fromsys=net_sysnum;

    if (xnp->host) {
      nh.main_type=main_type_pre_post;
      nh.tosys=xnp->host;
    } else {
      nh.main_type=main_type_post;
      sprintf(s,"%sN%s.NET",net_data, xnp->stype);
      f=sh_open1(s,O_RDONLY|O_BINARY);
      if (f>0) {
        len1=filelength(f);
        list=(unsigned int *)malloca(len1*2+1);
        if (!list)
          continue;
        if ((b=malloca(len1+100L))==NULL) {
          farfree(list);
          continue;
        }
        sh_read(f,b,len1);
        sh_close(f);
        b[len1]=0;
        len2=0;
        while (len2<len1) {
          while ((len2<len1) && ((b[len2]<'0') || (b[len2]>'9')))
            ++len2;
          if ((b[len2]>='0') && (b[len2]<='9') && (len2<len1)) {
            i=atoi(&(b[len2]));
            if (((net_num!=nn) || (nh.fromsys!=i)) && (i!=net_sysnum))
              list[(nh.list_len)++]=i;
            while ((len2<len1) && (b[len2]>='0') && (b[len2]<='9'))
              ++len2;
          }
        }
        farfree(b);
      }
      if (!nh.list_len) {
        if (list)
          farfree(list);
        continue;
      }
    }
    if (!xnp->type)
      nh.main_type=main_type_new_post;
    if (nn1==net_num)
      send_net(&nh, list, b1, xnp->type?NULL:xnp->stype);
    else
      gate_msg(&nh, b1, xnp->net_num, xnp->stype, list, nn);
    if (list)
      farfree(list);
  }

  farfree(b1);
  set_net_num(onn);
}

/****************************************************************************/

int busy_sub(int subnum)
{
  int f;
  char s[81];

  sprintf(s,"%s%s.SUB",syscfg.datadir,subboards[subnum].filename);
  f=sh_open1(s,O_BINARY | O_RDWR);

  read_status();

  if ((f>0) && subchg) {
    sh_lseek(f,0L,SEEK_SET);
    nummsgs=(sh_read(f,(void *) (&msgs[0]),255*sizeof(postrec)) / sizeof(postrec))-1;
    nummsgs=msgs[0].owneruser;

    if (qsc_p[curlsub] >= status.qscanptr)
      qsc_p[curlsub] = status.qscanptr-1;

    subchg=0;

  }

  return(f);
}


void post(void)
{
  messagerec m;
  postrec p;
  char s[121];
  int i,dm,a,f,f1;
  slrec ss;
#ifdef OPT_POSTTIME_COMPENSATION
  time_t time1, time2;
#endif

  if (!iscan(cursub)) {
    nl();
    pl(get_string(1195));
    return;
  }
  if (curlsub<0) {
    nl();
    pl(get_string(668));
    nl();
    return;
  }

  ss=syscfg.sl[actsl];

  if (freek1(syscfg.msgsdir)<10.0) {
    nl();
    pl(get_string(332));
    nl();
    return;
  }

  if ((restrict_post & thisuser.restrict) || (thisuser.posttoday>=ss.posts)) {
    nl();
    pl(get_string(669));
    nl();
    return;
  }

  if (actsl<subboards[curlsub].postsl) {
    nl();
    pl(get_string(670));
    nl();
    return;
  }

  m.storage_type=subboards[curlsub].storage_type;
  a=subboards[curlsub].anony & 0x0f;
  if ((a==0) && (ss.ability & ability_post_anony))
    a=anony_enable_anony;
  if ((a==anony_enable_anony) && (thisuser.restrict & restrict_anony))
    a=0;
  if (xsubs[curlsub].num_nets) {
    a &= (anony_real_name);
    if (thisuser.restrict & restrict_net) {
      nl();
      pl(get_string(671));
      nl();
      return;
    }
    if (net_sysnum) {
      nl();
      outstr(get_string(672));
      for (i=0; i<xsubs[curlsub].num_nets; i++) {
        if (i)
          outstr(", ");
        outstr(net_networks[xsubs[curlsub].nets[i].net_num].name);
      }
      outstr(".\r\n");
      nl();
    }
  }

#ifdef OPT_POSTTIME_COMPENSATION
  time1=time(NULL);
#endif

  write_inst(INST_LOC_POST,curlsub,INST_FLAGS_ONLINE);

  inmsg(&m,p.title,&a,1,(subboards[curlsub].filename),ALLOW_FULLSCREEN,
    subboards[curlsub].name, (subboards[curlsub].anony&anony_no_tag)?1:0);
  if (m.stored_as!=0xffffffff) {

    f=busy_sub(curlsub);

    if (f==-1) {
      nl();
      pl(get_string(1195));
      return;
    }

    p.anony=a;
    p.msg=m;
    p.ownersys=0;
    p.owneruser=usernum;
    lock_status();
    p.qscan=status.qscanptr++;
    save_status();
    time((long *)(&p.daten));
    if (thisuser.restrict & restrict_validate)
      p.status=status_unvalidated;
    else
      p.status=0;
    if ((xsubs[curlsub].num_nets) &&
      (subboards[curlsub].anony & anony_val_net) && (!lcs() || irt[0])) {
      p.status |= status_pending_net;
      dm=1;
      for (i=1; i<=nummsgs; i++)
        if (msgs[i].status & status_pending_net)
          dm=0;
      if (dm) {
        sprintf(s,get_stringx(1,37),subboards[curlsub].name);
        ssm(1,0,s);
      }
    }
    if (nummsgs>=subboards[curlsub].maxmsgs) {
      i=1;
      dm=0;
      while ((dm==0) && (i<=nummsgs)) {
        if ((msgs[i].status & status_no_delete)==0)
          dm=i;
        ++i;
      }
      if (dm==0)
        dm=1;
      delete(dm);
    }
    msgs[++nummsgs]=p;
    sub_dates[curlsub]=p.qscan;
    bchanged=1;
    f=savebase(f);
    ++thisuser.msgpost;
    ++thisuser.posttoday;
    lock_status();
    ++status.msgposttoday;
    ++status.localposts;

#ifdef OPT_POSTTIME_COMPENSATION
    time2=time(NULL);
    if (time1>time2)
      time2+=24*3600;
    time1=(float)(time2-time1);
    if ((time1/60.0)>syscfg.sl[actsl].time_per_logon)
      time1=(float)(syscfg.sl[actsl].time_per_logon*60.0);
		thisuser.extratime+=(float)(time1);
#endif

    save_status();
    topscreen();
    sprintf(s,get_stringx(1,38),p.title,subboards[curlsub].name);
    sysoplog(s);
    outstr(get_string(673));
    pl(subboards[curlsub].name);
    if (xsubs[curlsub].num_nets) {
      ++thisuser.postnet;
      if (!(p.status & status_pending_net))
        send_net_post(&p, subboards[curlsub].filename, curlsub);
    }
  }
}


void grab_user_name(messagerec *m, char *fn)
{
  char *ss,*ss1,*ss2;
  long len;

  ss=readfile(m,fn,&len);
  if (ss) {
    ss1=strchr(ss,'\r');
    if (ss1) {
      *ss1=0;
      ss2=ss;
      if ((ss[0]=='`') && (ss[1]=='`')) {
        for (ss1=ss+2; *ss1; ss1++) {
          if ((ss1[0]=='`') && (ss1[1]=='`'))
            ss2=ss1+2;
        }
        while (*ss2==' ')
          ++ss2;
      }
      strcpy(net_email_name,ss2);
    } else
      net_email_name[0]=0;
    farfree(ss);
  } else
    net_email_name[0]=0;
}

void scan(int msgnum, int optype, int *nextsub)
{
  char s[161],s1[81],*b,*ss1, *toval;
  int i,i1,i2,done,quit,abort,next,val,realexpress,f;
  int title_lines;
  slrec ss;
  long len;
  postrec p,p1, p2;
  userrec tu;

  irt[0]=0;
  irt_name[0]=0;
  done=0;
  quit=0;
  val=0;
  realexpress=express;
  iscan(cursub);
  if (curlsub<0) {
    nl();
    pl(get_string(668));
    nl();
    return;
  }
  do {
    tleft(1);
    checkhangup();
    if (xsubs[curlsub].num_nets)
      set_net_num(xsubs[curlsub].nets[0].net_num);
    else
      set_net_num(0);
    if (optype!=0)
      resynch(cursub, &msgnum, NULL);
    write_inst(INST_LOC_SUBS, usub[cursub].subnum, INST_FLAGS_ONLINE);
    switch(optype) {
      case 0: /* Read Prompt */
#ifdef OPT_EXTRA_COLOR
        sprintf(s,"1%s0:7(11-%u,^%u7)1,? 0: 2",get_string(678),
          nummsgs,msgnum);
#else
        sprintf(s,"%s:(1-%u,^%u),? :",get_string(678),
          nummsgs,msgnum);
#endif
        nl();
        if (express) {
          s[0]=0;
          nl();
          nl();
        } else {
#ifdef OPT_EXTRA_COLOR
          sprintf(s1,"7[1%s7] [1%s7]",usub[cursub].keys,
            subboards[usub[cursub].subnum].name);
#else
          sprintf(s1,"[%s] [%s]",usub[cursub].keys,
            subboards[usub[cursub].subnum].name);
#endif
          ansic(2); pl(s1);
          prt(2,s);
          helpl=16;
          input(s,3);
          resynch(cursub, &msgnum, NULL);
          while (s[0]==32) {
            strcpy(s1,&(s[1]));
            strcpy(s,s1);
          }
        }
        optype=0;
        i=atoi(s);
        if (s[0]==0) {
          i=msgnum+1;
          if (i>=nummsgs+1)
            done=1;
        }
        if ((i!=0) && (i<=nummsgs) && (i>=1)) {
          optype=2;
          msgnum=i;
        } else
          if (s[1]==0) {
            switch(s[0]) {
              case 'Q':
                quit=1;
                done=1;
                *nextsub=0;
                break;
              case 'B':
                if (*nextsub!=0) {
                  *nextsub=1;
                  done=1;
                  quit=1;
                }
                break;
              case 'T':
                optype=1;
                break;
              case 'R':
                optype=2;
                break;
              case 'A':
                if ((msgs[msgnum].ownersys) && (!msgs[msgnum].owneruser))
                  grab_user_name(&(msgs[msgnum].msg),subboards[curlsub].filename);
                grab_quotes(&(msgs[msgnum].msg),subboards[curlsub].filename);
                ss=syscfg.sl[actsl];
                if (msgs[msgnum].status & status_post_new_net) {
                  set_net_num(msgs[msgnum].title[80]);
                  if (msgs[msgnum].title[80]==-1) {
                    pl(get_string(679));
                    break;
                  }
                }
                if ((lcs()) || (ss.ability & ability_read_post_anony) || (msgs[msgnum].anony==0))
                  email(msgs[msgnum].owneruser,msgs[msgnum].ownersys,0,0);
                else
                  email(msgs[msgnum].owneruser,msgs[msgnum].ownersys,0,msgs[msgnum].anony);
                grab_quotes(NULL, NULL);
                break;
              case 'P':
                irt[0]=0;
                irt_name[0]=0;
              case 'W':
                p2=msgs[msgnum];
                grab_quotes(&(p2.msg),subboards[curlsub].filename);
                post();
                resynch(cursub, &msgnum, &p2);
                grab_quotes(NULL, NULL);
                break;
              case '?':
                if (lcs())
                  printmenu(13);
                else
                  printmenu(1);
                break;
              case '-':
                if ((msgnum>1) && (msgnum-1<nummsgs)) {
                  --msgnum;
                  optype=2;
                }
                break;
              case 'C':
                express=1;
                break;
/*************/
              case 'V':
                if ((cs()) && (msgs[msgnum].ownersys==0) && (msgnum>0) && (msgnum<=nummsgs))
                  valuser(msgs[msgnum].owneruser);
                else
                  if ((cs()) && (msgnum>0) && (msgnum<=nummsgs)) {
                    nl();
                    pl(get_string(680));
                    nl();
                  }
                break;
              case 'N':
                if ((lcs()) && (msgnum>0) && (msgnum<=nummsgs)) {
                  f=busy_sub(curlsub);
                  msgs[msgnum].status ^= status_no_delete;
                  bchanged=1;
                  f=savebase(f);
                  nl();
                  if (msgs[msgnum].status & status_no_delete)
                    pl(get_string(681));
                  else
                    pl(get_string(682));
                  nl();
                }
                break;
              case 'X':
                if ((lcs()) && (msgnum>0) && (msgnum<=nummsgs) &&
                    (subboards[curlsub].anony & anony_val_net) &&
                    (xsubs[curlsub].num_nets)) {
                  f=busy_sub(curlsub);
                  msgs[msgnum].status ^= status_pending_net;
                  bchanged=1;
                  f=savebase(f);
                  nl();
                  if (msgs[msgnum].status & status_pending_net) {
                    val |= 2;
                    pl(get_string(683));
                  } else
                    pl(get_string(684));
                  nl();
                }
                break;
              case 'U':
                if ((lcs()) && (msgnum>0) && (msgnum<=nummsgs)) {
                  f=busy_sub(curlsub);
                  msgs[msgnum].anony=0;
                  bchanged=1;
                  f=savebase(f);
                  nl();
                  pl(get_string(685));
                }
                break;
              case 'D':
                p2=msgs[msgnum];
                f=busy_sub(curlsub);
                if (lcs()) {
                  if (msgnum) {
                    if (msgs[msgnum].ownersys==0) {
                      read_user(msgs[msgnum].owneruser,&tu);
                      if ((tu.inact & inact_deleted)==0) {
                        if (date_to_daten(tu.firston) < msgs[msgnum].daten) {
                          nl();
                          prt(2,get_string(980));
                          mpl(3);
                          input(s1,3);
                          if (s1[0])
                            i1=(atoi(s1));
                          else
                            i1=1;
                          if (i1>tu.msgpost)
                            i1=tu.msgpost;
                          if (i1)
                            tu.msgpost-=i1;
                          nl();
                          ansic(3);
                          outstr(get_string(993));
                          pln(i1);
                          tu.deletedposts++;
                          write_user(msgs[msgnum].owneruser,&tu);
                          topscreen();
                        }
                      }
                    }
                    delete(msgnum);
                    f=savebase(f);
                  }
                }
                if (f!=-1)
                  f=sh_close(f);
                resynch(cursub, &msgnum, &p2);
                break;
              case 'E':
                if (so()) {
                  if ((msgnum>0) && (msgnum<=nummsgs)) {
                    b=readfile(&(msgs[msgnum].msg),(subboards[curlsub].filename),&len);
                    extract_out(b,len, msgs[msgnum].title);
                  }
                }
                break;
              case 'M':
                if ((lcs()) && (msgnum>0) && (msgnum<=nummsgs)) {
                  p2=msgs[msgnum];
                  f=busy_sub(curlsub);
                  if (f==-1) {
                    nl();
                    pl(get_string(1195));
                    break;
                  }

                  tmp_disable_conf(1);
                  nl();
                  do {
                    prt(2,get_string(686));
                    ss1=mmkey(0);
                    if (ss1[0]=='?') {
                      sublist();
                    }
                  } while ((!hangup) && (ss1[0]=='?'));
                  i=-1;
                  if (ss1[0]==0)
                    break;
                  for (i1=0; (i1<num_subs) && (usub[i1].subnum!=-1); i1++)
                    if (strcmp(usub[i1].keys,ss1)==0)
                      i=i1;
                  if (i!=-1) {
                    p=msgs[msgnum];
                    b=readfile(&(p.msg),(subboards[curlsub].filename),&len);
                    delete(msgnum);
                    if (msgnum>1)
                      msgnum--;
                    f=savebase(f);
                    iscan(i);
                    f=busy_sub(curlsub);
                    p.msg.storage_type=subboards[curlsub].storage_type;
                    savefile(b,len,&(p.msg),(subboards[curlsub].filename));
                    lock_status();
                    p.qscan=status.qscanptr++;
                    save_status();
                    if (nummsgs>=subboards[curlsub].maxmsgs) {
                      i1=1;
                      i2=0;
                      while ((i2==0) && (i1<=nummsgs)) {
                        if ((msgs[i1].status & status_no_delete)==0)
                          i2=i1;
                        ++i1;
                       }
                       if (i2==0)
                         i2=1;
                       p1=msgs[i2];
                       remove_link(&p1.msg,(subboards[curlsub].filename));
                       for (i1=i2; i1<nummsgs; i1++)
                         msgs[i1]=msgs[i1+1];
                       --nummsgs;
                     }
                     if ((!(subboards[curlsub].anony & anony_val_net)) ||
                         (!xsubs[curlsub].num_nets))
                       p.status &= ~status_pending_net;
                     msgs[++nummsgs]=p;
                     sub_dates[curlsub]=p.qscan;
                     bchanged=1;
                     f=savebase(f);
                     tmp_disable_conf(0);
                     iscan(cursub);
                     nl();
                     pl(get_string(687));
                     nl();
                  } else
                    tmp_disable_conf(0);
                  if (f!=-1)
                    f=sh_close(f);
                  resynch(cursub, &msgnum, &p2);
                }
                break;
              case 'L':
                if (!so())
                  break;
                nl();
                prt(2,get_string(7));
                input(s,50);
                if (s[0]) {
                  nl();
                  prt(5,get_string(17));
                  if (yn()) {
                    nl();
                    load_workspace(s,0);
                  } else {
                    nl();
                    load_workspace(s,1);
                  }
                }
                break;
/*************/
            }
        } else {
          if (strcmp(s,"CLS")==0)
            outchr('\x0c');
        }
        break;
      case 1: /* List Titles */
        i=0;
        abort=0;
        if (msgnum>=nummsgs)
          abort=1;
        else
          nl();
        title_lines=screenlinest-6;
        if (title_lines<1)
          title_lines=1;
        while ((!abort) && (!hangup) && (++i<=title_lines)) {
          ++msgnum;
          if ((msgs[msgnum].ownersys==0) && (msgs[msgnum].owneruser==usernum))
            sprintf(s1,"7[1%d7]",msgnum);
          else if (msgs[msgnum].ownersys!=0)
            sprintf(s1,"7<1%d7>",msgnum);
          else
            sprintf(s1,"7(1%d7)",msgnum);
          for (i1=0; i1<5; i1++)
            s[i1]=32;
          if (msgs[msgnum].qscan>qsc_p[curlsub])
            s[0]='*';
          if (msgs[msgnum].status & (status_pending_net | status_unvalidated))
            s[0]='+';
          strcpy(&s[7-strlen(stripcolors(s1))],s1);
          strcat(s,"1 ");
          if ((msgs[msgnum].status&(status_unvalidated|status_delete))&&(!lcs()))
            strcat(s,get_string(665));
          else
            strcat(s,stripcolors(msgs[msgnum].title));

          if (thisuser.screenchars>=80) {
            if (strlen(stripcolors(s))>50)
              while (strlen(stripcolors(s))>50)
                s[strlen(s)-1]=0;
            strcat(s,charstr(51-strlen(stripcolors(s)),' '));
            if (okansi())
              strcat(s,"71");
            else
              strcat(s,"|");
            strcat(s," ");
            if ((msgs[msgnum].anony & anony_sender) &&
              ((syscfg.sl[actsl].ability & ability_read_post_anony)==0)) {
                strcat(s,get_string(482));
            } else {
              b=readfile(&(msgs[msgnum].msg),(subboards[curlsub].filename),
                         &len);
              if (b) {
                strncpy(s1,b,sizeof(s1)-1);
                s1[sizeof(s1)-1]=0;
                strcpy(b, stripcolors(s1));
                i1=0; strcpy(s1,"");
                while ((b[i1]!=13) && (b[i1]) && ((long)i1<len) &&
                  (i1<(thisuser.screenchars-54)))
                  s1[i1]=b[i1++];
                s1[i1]=0;
                strcat(s,s1);
                farfree(b);
              }
            }
          }

          ansic(2);
          pla(s,&abort);
          if (msgnum>=nummsgs)
            abort=1;
        }
        optype=0;
        break;
      case 2: /* Read Message */
        if ((msgnum>0) && (msgnum<=nummsgs))
          read_message(msgnum,&next,&val);
        ansic(0);
        nl();
        if (next) {
          ++msgnum;
          if (msgnum>nummsgs)
            done=1;
          optype=2;
        } else
          optype=0;
        if (expressabort)
          if (realexpress) {
            done=1;
            quit=1;
            *nextsub=0;
          } else {
            expressabort=0;
            express=0;
            optype=0;
          }
        break;
    }
  } while ((!done) && (!hangup));
  if (!realexpress) {
    express=0;
    expressabort=0;
  }
  if ((val & 1) && (lcs()) && (!express)) {
    nl();
    prt(5,get_string(688));
    if (yn()) {
      f=busy_sub(curlsub);
      for (i=1; i<=nummsgs; i++)
        if (msgs[i].status & (status_unvalidated | status_delete))
          msgs[i].status &= (~(status_unvalidated | status_delete));
      bchanged=1;
      f=savebase(f);
    }
  }
  if ((val & 2) && (lcs()) && (!express)) {
    nl();
    prt(5,get_string(689));
    if (yn()) {
      toval=malloca(nummsgs+1);
      if (toval) {
        memset(toval, 0, nummsgs+1);
        f=busy_sub(curlsub);
        for (i=1; i<=nummsgs; i++) {
          if (msgs[i].status & status_pending_net) {
            toval[i]=1;
            msgs[i].status &= (~status_pending_net);
          }
        }
        bchanged=1;
        f=savebase(f);

        i1=0;
        for (i=1; i<=nummsgs; i++) {
          if (toval[i]) {
            send_net_post(msgs+i, subboards[curlsub].filename, curlsub);
            ++i1;
          }
        }
        farfree(toval);
        nl();
        npr("%d",i1);
        pl(get_string(690));
        nl();
      }
    }
  }
  if ((!quit) && (!express)) {
    nl();
    ss=syscfg.sl[actsl];
    if (
        ((restrict_post & thisuser.restrict)==0) &&
        (thisuser.posttoday<ss.posts) &&
        (actsl>=subboards[curlsub].postsl)) {
      sprintf(s,"%s %s? ",get_string(691), subboards[curlsub].name);
      prt(5,s);
      irt[0]=0;
      irt_name[0]=0;
      grab_quotes(NULL, NULL);
      if (yn()) {
        post();
      }
    }
  }
  nl();
}


void qscan(int bn, int *ns)
{
  int i,nextsub,os,sn;
  char s[81];
  unsigned long qscnptrx,sd;

  sn=usub[bn].subnum;

  if ((hangup) || (sn<0))
    return;

  nl();

  qscnptrx=qsc_p[sn];
  sd=sub_dates[sn];
  if ((!sd) || (sd>qscnptrx)) {
    nextsub=*ns;
    os=cursub;
    cursub=bn;
    i=1;

    if (!iscan(cursub)) {
      nl();
      pl(get_string(1195));
      return;
    }
    qscnptrx=qsc_p[sn];

    sprintf(s,"< %s %s %s - %u %s >",get_string(692), subboards[curlsub].name,
              usub[cursub].keys,nummsgs, "msgs");
    prt(1,s);
    nl();

    while ((i<=nummsgs) && (msgs[i].qscan<=qscnptrx))
      ++i;
    if ((nummsgs>0) && (msgs[nummsgs].qscan<=qscnptrx)) {
      read_status();
      qsc_p[curlsub]=status.qscanptr-1;
    }
    if ((nummsgs>0) && (i<=nummsgs))
      if (msgs[i].qscan>qsc_p[curlsub])
        scan(i,2,&nextsub);

    cursub=os;
    *ns=nextsub;
    sprintf(s,"< %s %s >",subboards[curlsub].name, get_string(693));
    prt(1,s);
  } else {
    sprintf(s,"< %s %s %s >",get_string(694), subboards[sn].name, usub[bn].keys);
    prt(1,s);
  }
  nl();
}


void nscan(int ss)
{
  int i,nextsub,abort,next;
  unsigned char ch;

  nl();
  nextsub=1;

  prt(3,get_string(695));
  nl();
  for (i=ss; (usub[i].subnum!=-1) && (i<num_subs) && (nextsub) && (!hangup); i++) {
    if (qsc_q[usub[i].subnum/32]&(1L<<(usub[i].subnum%32)))
      qscan(i,&nextsub);
    abort=next=0;
    checka(&abort,&next);
    if (abort)
      nextsub=0;
  }
  nl();
  prt(3,get_string(696));
  nl();
  nl();
  if ((nextsub) && (thisuser.sysstatus & sysstatus_nscan_file_system) &&
    ((syscfg.sysconfig & sysconfig_no_xfer)==0)) {
    abort=0;
    lines_listed=0;
    tagging=1;
    tmp_disable_conf(1);
    nscanall();
    tmp_disable_conf(0);
    tagging=0;
  }
}



void scan2(void)
{
  char s[81];
  int i,i1;

  if (!iscan(cursub)) {
    nl();
    pl(get_string(1195));
    return;
  }
  nl();
  if (curlsub<0) {
    pl(get_string(668));
    nl();
    return;
  }
  npr("%d",nummsgs);
  outstr(get_string(697));
  pl(subboards[curlsub].name);
  if (nummsgs==0)
    return;
  helpl=11;
  prt(2,get_string(698));
  input(s,4);
  i=atoi(s);
  if (i<1)
    i=0;
  else
    if (i>nummsgs)
      i=nummsgs;
    else
      i--;
  i1=0;
  if (strcmp(s,"S")==0)
    scan(0,0,&i1);
  else
    if (strcmp(s,"Q")) {
      if (strcmp(s,"N")==0) {
      } else
        scan(i,1,&i1);
    }
}


void printmenu(int i)
{
  char s[81],s1[81];
  int next;

  next=0;

  if ((thisuser.sysstatus & (sysstatus_color | sysstatus_ansi))
      == (sysstatus_color | sysstatus_ansi)) {
    sprintf(s1,"MENU%u.ANS", i);
    sprintf(s,"%s%s",languagedir,s1);
    if (exist(s)) {
      printfile(s1);
      return;
    }
  }
  sprintf(s1,"MENU%u.MSG", i);
  sprintf(s,"%s%s",languagedir,s1);
  if (exist(s)) {
    printfile(s1);
    return;
  }

  if ((thisuser.screenchars==40) && (menus2[i].stored_as)) {
    sprintf(s,"%sMENUS40.MSG",languagedir);
    read_message1(&menus2[i],0,0,&next,s);
  } else
    if ((okansi()) && (menus1[i].stored_as)) {
      sprintf(s,"%sMENUSANS.MSG",languagedir);
      read_message1(&menus1[i],0,0,&next,s);
    } else {
      sprintf(s,"%sMENUS.MSG",languagedir);
      if (menus[i].stored_as)
        read_message1(&menus[i],0,0,&next,s);
    }
}


void delmail(int f, int loc)
{
  mailrec m,m1;
  userrec u;
  int rm,i,t,otf;

  sh_lseek(f,((long) loc) * ((long) sizeof(mailrec)), SEEK_SET);
  sh_read(f,(void *)&m,sizeof(mailrec));

  if ((m.touser==0) && (m.tosys==0))
    return;

  rm=1;
  if (m.status & status_multimail) {
    t=filelength(f)/sizeof(mailrec);
    otf=0;
    for (i=0; i<t; i++)
      if (i!=loc) {
        sh_lseek(f,((long)i)*((long)sizeof(mailrec)),SEEK_SET);
        sh_read(f,(void *)&m1,sizeof(mailrec));
        if ((m.msg.stored_as==m1.msg.stored_as) && (m.msg.storage_type==m1.msg.storage_type) && (m1.daten!=0xffffffff))
          otf=1;
      }
    if (otf)
      rm=0;
  }

  if (rm)
    remove_link(&m.msg,"EMAIL");

  if (m.tosys==0) {
    read_user(m.touser,&u);
    if (u.waiting) {
      --u.waiting;
      write_user(m.touser,&u);
    }
    if (m.touser==1)
      --fwaiting;
  }

  sh_lseek(f,((long) loc) * ((long) sizeof(mailrec)), SEEK_SET);
  m.touser=0;
  m.tosys=0;
  m.daten=0xffffffff;
  m.msg.storage_type=0;
  m.msg.stored_as=0xffffffff;
  sh_write(f,(void *)&m,sizeof(mailrec));
  mailcheck=1;
}

void remove_post(void)
{
  int i,any,abort,f;
  char s[161];
  userrec tu;

  if (!iscan(cursub)) {
    nl();
    pl(get_string(1195));
    return;
  }
  if (curlsub<0) {
    nl();
    pl(get_string(668));
    nl();
    return;
  }
  any=0;
  abort=0;
  nl();
  nl();
  outstr(get_string(723));
  pl(subboards[curlsub].name);
  nl();
  for (i=1; (i<=nummsgs) && (!abort); i++) {
    if ((msgs[i].ownersys==0) && (msgs[i].owneruser==usernum)) {
      any=1;
      sprintf(s,"%u: %s",i,msgs[i].title);
      pla(s,&abort);
    }
  }
  if (!any) {
    pl(get_string(5));
    if (!cs())
      return;
  }
  nl();
  prt(2,get_string(724));
  input(s,3);
  i=atoi(s);
  f=busy_sub(curlsub);
  if ((i>0) && (i<=nummsgs)) {
    if (((msgs[i].ownersys==0) && (msgs[i].owneruser==usernum)) || (lcs())) {
      if ((msgs[i].owneruser==usernum) && (msgs[i].ownersys==0)) {
        read_user(msgs[i].owneruser,&tu);
        if ((tu.inact & inact_deleted)==0) {
          if (date_to_daten(tu.firston) < msgs[i].daten) {
            if (tu.msgpost) {
              tu.msgpost--;
              write_user(msgs[i].ownersys,&tu);
            }
          }
        }
      }
      sprintf(s,get_stringx(1,39),msgs[i].title,subboards[curlsub].name);
      sysoplog(s);
      delete(i);
      f=savebase(f);
      nl();
      pl(get_string(725));
      nl();
    }
  }
  if (f!=-1)
    sh_close(f);
}



int external_edit(char *fn1, char *direc, int ednum, int numlines, char *dest, char *title, int flags)
{
  char s[255],s1[128],fn[128],s3[81],sx1[21],sx2[21],sx3[21],cdir1[81];
  int i,i2,filethere,mod,newtl,inst;
  struct ftime ftimep,ftimep1;
  FILE *f;


  if ((ednum>=numed) || (!okansi())) {
    nl();
    pl(get_string(726));
    nl();
    return(0);
  }
  if (incom)
    strcpy(s1,(editors[ednum].filename));
  else
    strcpy(s1,(editors[ednum].filenamecon));
  if (s1[0]==0) {
    nl();
    pl(get_string(726));
    nl();
    return(0);
  }

  make_abs_cmd(s1);

  get_dir(cdir1,0);
  cd_to(direc);

  _chmod("editor.inf",1,0);
  unlink("editor.inf");
  _chmod("result.ed",1,0);
  unlink("result.ed");

  strcpy(s3,fn1);
  stripfn1(s3);
  if (direc[0]) {
    cd_to(direc);
    get_dir(fn,1);
    cd_to(direc);
  } else
    fn[0]=0;
  strcat(fn,s3);
  filethere=exist(fn);
  if (filethere) {
    i=sh_open1(fn,O_RDONLY | O_BINARY);
    getftime(i,&ftimep);
    sh_close(i);
  }
  itoa(thisuser.screenchars,sx1,10);
  if (screenlinest>defscreenbottom-topline)
    newtl=0;
  else
    newtl=topline;
  if (using_modem)
    itoa(thisuser.screenlines,sx2,10);
  else
    itoa(defscreenbottom+1-newtl,sx2,10);
  itoa(numlines,sx3,10);
  stuff_in(s,s1,fn,sx1,sx2,sx3,"");

  if ((f=fsh_open("EDITOR.INF","wt"))!=NULL) {
    if (irt_name[0])
      flags |= 2;
    if (irt[0])
      flags |= 4;
    fprintf(f,"%s\n%s\n%u\n%s\n%s\n%u\n%u\n%u\n%u\n",
      title,
      dest,
      usernum,
      thisuser.name,
      thisuser.realname,
      thisuser.sl,
      flags,
      topline,
      thisuser.language);
    fsh_close(f);
  }
  if (flags&1) {
    /* disable tag lines */
    f=fsh_open("disable.tag","w");
    if (f) fsh_close(f);
  } else {
    unlink("disable.tag");
  }
  if (!irt[0]) {
    unlink("quotes.txt");
    unlink("quotes.ind");
  }

  in_fsed=1;
  full_external(s,0,1);
  cd_to(direc);
  in_fsed=0;
  unlink("editor.inf");
  unlink("disable.tag");
  unlink("quotes.txt");
  unlink("quotes.ind");
  if (!wfc)
    topscreen();
  mod=0;
  if (!filethere) {
    mod=exist(fn);
  } else {
    i=sh_open1(fn,O_RDONLY | O_BINARY);
    getftime(i,&ftimep1);
    sh_close(i);
    if ((ftimep.ft_year!=ftimep1.ft_year) ||
        (ftimep.ft_month!=ftimep1.ft_month) ||
        (ftimep.ft_day!=ftimep1.ft_day) ||
        (ftimep.ft_hour!=ftimep1.ft_hour) ||
        (ftimep.ft_min!=ftimep1.ft_min) ||
        (ftimep.ft_tsec!=ftimep1.ft_tsec))
      mod=1;
  }
  cd_to(cdir1);
  return(mod);
}

#define LINELEN 79

#define NL {if (!cp) fsh_write(pfx,1,pfxlen,f);fsh_write("\r\n",1,2,f); cp=ns=ctlc=0;}
#define FLSH {if (ss1) { if (cp && (l3+cp>=LINELEN)) NL else if (ns) cp+=fsh_write(" ",1,1,f);\
              if (!cp) {if (ctld) fprintf(f,"\x4%c",ctld);ctld=0;cp=fsh_write(pfx,1,pfxlen,f);}\
              fsh_write(ss1,1,l2,f); cp+=l3; ss1=NULL;l2=l3=0;ns=1;}}

void grab_quotes(messagerec *m, char *aux)
{
  char *ss,*ss1;
  long l,l1,l2,l3;
  FILE *f;
  char *pfx;
  int cp=0,ctla=0,ctlc=0,ns=0,ctld=0;
  int pfxlen;
  char q_txt[81],q_ind[81];

  sprintf(q_txt,"%squotes.txt",syscfgovr.tempdir);
  sprintf(q_ind,"%squotes.ind",syscfgovr.tempdir);

  pfx=get_stringx(1,102);
  pfxlen=strlen(pfx);

  _chmod(q_txt,1,0);
  unlink(q_txt);
  _chmod(q_ind,1,0);
  unlink(q_ind);
  if (quotes_nrm)
    farfree(quotes_nrm);
  if (quotes_ind)
    farfree(quotes_ind);

  quotes_nrm=quotes_ind=NULL;
  quotes_nrm_l=quotes_ind_l=0;

  if (m && aux) {

    ss=readfile(m, aux, &l);

    if (ss) {
      quotes_nrm=ss;
      quotes_nrm_l=l;

      f=fsh_open(q_txt, "wb");
      if (f) {
        fsh_write(ss, 1, l, f);
        fsh_close(f);
      }

      f=fsh_open(q_ind, "wb");
      if (f) {
        l3=l2=0;
        ss1=NULL;
        for (l1=0; l1<l; l1++) {
          if (ctld==-1)
            ctld=ss[l1];
          else switch(ss[l1]) {
            case 1:
              ctla=1;
              break;
            case 2:
              break;
            case 3:
              if (!ss1)
                ss1=ss+l1;
              l2++;
              ctlc=1;
              break;
            case 4:
              ctld=-1;
              break;
            case '\n':
              if (ctla) {
                ctla=0;
              } else {
                FLSH;
                NL;
              }
              break;
            case ' ':
            case '\r':
              if (ss1) {
                FLSH;
              } else {
                if (ss[l1]==' ') {
                  if (cp+1>=LINELEN)
                    NL;
                  if (!cp) {
                    if (ctld)
                      fprintf(f,"\x4%c",ctld);
                    ctld=0;
                    cp=fsh_write(pfx,1,pfxlen,f);
                  }
                  cp++;
                  fsh_write(" ",1,1,f);
                }
              }
              break;
            default:
              if (!ss1)
                ss1=ss+l1;
              l2++;
              if (ctlc)
                ctlc=0;
              else
                l3++;
              break;
          }
        }
        FLSH;
        if (cp)
          fsh_write("\r\n",1,2,f);
        fsh_close(f);
#ifdef SAVE_IN_MEM
        ff=sh_open1(q_ind,O_RDONLY|O_BINARY);
        if (ff>0) {
          quotes_ind_l=filelength(ff);
          quotes_ind=(char *)farmalloc(quotes_ind_l);
          if (quotes_ind) {
            sh_read(ff,quotes_ind, quotes_ind_l);
          } else
            quotes_ind_l=0;
          sh_close(ff);
        }
#else
        farfree(quotes_nrm);
        quotes_nrm=NULL;
        quotes_nrm_l=0;
#endif
      }
    }
  }
}

