@echo off
REM  You can rename this file to UPGRADE.BAT and run it to upgrade your
REM  system to v4.30 after editing any paths below as needed
REM
REM  Commandline must include the MAIN BBS destination directory for the
REM  upgrade with *NO* trailing slash i.e. D:\WWIV

cls
ECHO.
ECHO.
ECHO                      WWIV v4.30 Upgrade Batch
ECHO.

if %1a == a goto HELP

ECHO         *************** THIS IS BETA SOFTWARE ****************
ECHO.
ECHO  BETA SOFTWARE IS SOFTWARE IN THE FINAL STAGES OF DEVELOPMENT AND MAY
ECHO   OR MAY NOT CAUSE PROBLEMS ON YOUR SYSTEM.  IT MAY HAVE EVIDENT OR
ECHO        INVISIBLE FLAWS THAT MAY OR MAY NOT CAUSE LOSS OF DATA.
ECHO.
ECHO YOUR INSTALLATION OF THE SOFTWARE AND EXECUTION OF THE INIT.EXE PROGRAM
ECHO  INDICATES YOUR EXPLICIT AGREEMENT TO HOLD WWIV SOFTWARE SERVICES, LLC
ECHO    HARMLESS FOR ANY DAMAGES CAUSED AS A RESULT OF USING THE SOFTWARE
ECHO.
ECHO    IT IS HIGHLY RECOMMENDED THAT YOU MAKE A COMPLETE BACKUP OF YOUR
ECHO          DATA PRIOR TO INSTALLING AND RUNNNING THIS SOFTWARE.
ECHO.
ECHO  WWIV SOFTWARE SERVICES, LLC DISCLAIMS ANY AND ALL RESPONSIBILITY AND
ECHO  LIABILITY FOR ANY HARDWARE OR SOFTWARE DAMAGE, CORRUPTION OR LOSS OF
ECHO             DATA AS A RESULT OF YOUR USE OF THIS SOFTWARE.
ECHO.
ECHO         ******************************************************
ECHO.
ECHO.
choice /C:YN /N /T:N,60 Continue?  [Y,N] :
if errorlevel == 2 goto END

cls
ECHO.
ECHO.
ECHO                      WWIV v4.30 Upgrade Batch
ECHO.
ECHO  If your system does not use a standard WWIV directory tree, you
ECHO  must edit this file prior to upgrading to account for directories
ECHO  or files that are in non-standard locations.
ECHO.
ECHO  Your current WWIV.INI and MODEMS.MDM will be renamed to
ECHO  WWIVINI.OLD and MDMSMDM.OLD prior to upgrading.
ECHO.
ECHO.
choice /C:YN /N /T:N,40 Upgrade to WWIV v4.30 now?  [Y,N] :
if errorlevel == 2 goto END


:UPGRADE
echo Upgrading to WWIV v4.30...  Please wait....
echo.
echo.
rem ******************************* save INI and MDM files
echo Renaming WWIV.INI to WWIVINI.OLD...
rename %1\wwiv.ini %1\wwivini.old
echo Renaming DATA\MODEMS.MDM to DATA\MDMSMDM.OLD...
rename %1\data\modems.mdm %1\data\mdmsmdm.old

rem ******************************* Change the attributes if set
echo Changing file attributes if set...
attrib -r %1\init.exe
attrib -r %1\bbs.exe
attrib -r %1\fix.exe
attrib -r %1\return.exe

rem ******************************* copy EXE's
echo Copying EXE's...
copy init.exe %1
copy bbs.exe %1
attrib +r %1\bbs.exe
copy fix.exe %1
copy return.exe %1
copy stredit.exe %1
copy menuedit.zip %1

rem ******************************* copy INI's and text files
echo Copying INI and text files...
copy wwiv.ini %1
copy chat.ini %1
copy bbsads.txt %1
copy betaread.me %1
copy history.txt %1
copy whats.new %1
copy readme.430 %1
copy menu.doc %1
copy *.sam %1

rem ******************************* copy data files
echo Copying data files...
copy wfc.dat %1\data
copy menu.txt %1\data
copy menucmds.dat %1\data
copy modems.mdm %1\data

rem ******************************* copy string files
echo Copying string files...
copy sysoplog.str %1\gfiles
copy ini.str %1\gfiles
copy chat.str %1\gfiles
copy english.str %1\gfiles\bbs.str

rem ******************************* unzip menus regions and zip code files
echo Unzipping archives...
md %1\data\menus
md %1\data\menus\wwiv
pkunzip -od en-menus.zip %1\gfiles
md %1\data\regions
pkunzip -od regions.zip %1\data
md %1\data\zip-city
pkunzip -od zip-city.zip %1\data

rem ******************************* run INIT to convert data files to
rem ******************************* v4.30 format
cls
cd %1
type | more betaread.me
ECHO.
ECHO.
ECHO.
choice /C:YN /N /T:N,30 Run INIT.EXE now?  [Y,N] :
if errorlevel == 2 goto END
init.exe ,1
goto CLOSE



rem Display Help
:HELP
echo.
echo.
echo Commandline must include destination directory!
echo.
echo  i.e.  UPGRADE.BAT D:\WWIV
goto END

rem Exit Batch file
:CLOSE
cls
echo.
echo.
echo All done!  You must ensure that your fossil driver is loaded prior
echo to running the BBS.  Examples of known working commands are in
echo WWIVBAT.SAM.

:END
echo.
echo.
echo.
