/****************************************************************************
 *
 * This program should be used by registered WWIV sysops with modified
 * userrecords.  Compile this with your modified vardec.h, and run it
 * in your main WWIV directory.  It will appropriately update your
 * config.dat file.
 *
 ****************************************************************************/

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include "vardec.h"

  int f,configfile,urlen,uroff,nl,no,uroff1,no1,uroff2;
  configrec syscfg;
  char ch,s[81];
  userrec *u;


void main()
{
  printf("The netinit program is a utility for registered WWIV sysops.\n");
  printf("It is necessary to run netinit.exe ONLY if you are a registered WWIV sysop and\n");
  printf("have modified some of the data in the vardec.h file.\n\n");
  printf("Compile (with your modified vardec.h file) and run netinit, and it\n");
  printf("will set the appropriate fields in the config.dat file.\n\n");

  configfile=open("CONFIG.DAT",O_RDWR | O_BINARY);
  if (configfile<0) {
    printf("CONFIG.DAT NOT FOUND.\n");
    exit(1);
  }
  read(configfile,(&syscfg), sizeof(configrec));
  close(configfile);


  /* these are the default values */
  urlen=700;
  uroff=423;
  uroff1=385;
  uroff2=620;

  /* doesn't hurt to put them in here, even though they'll be overwritten */
  if (syscfg.userreclen==0)
    syscfg.userreclen=urlen;
  if (syscfg.waitingoffset==0)
    syscfg.waitingoffset=uroff;
  if (syscfg.inactoffset==0)
    syscfg.inactoffset=uroff1;
#ifdef v421
  if (syscfg.sysstatusoffset==0)
    syscfg.sysstatusoffset=uroff2;
#endif

  /* find the new values to use */
  urlen=sizeof(userrec);
  uroff=FP_OFF(&(u->waiting))-FP_OFF(u);
  uroff1=FP_OFF(&(u->inact))-FP_OFF(u);
  uroff2=FP_OFF(&(u->sysstatus))-FP_OFF(u);

  /* tell the user what the new values are */
  printf("setting userreclen=%d, waitingoffset=%d, inactoffset=%d, sysstatusoffset=%d\n\n",
    urlen, uroff, uroff1, uroff2);

  /* put the new values into the syscfg structure */
  syscfg.userreclen=urlen;
  syscfg.waitingoffset=uroff;
  syscfg.inactoffset=uroff1;
#ifdef v421
  syscfg.sysstatusoffset=uroff2;
#else
  *((int *)(((char *)&syscfg)+5621))=uroff2;
#endif

  /* store the new config.dat file */
  configfile=open("CONFIG.DAT",O_RDWR | O_BINARY);
  write(configfile,(void *) (&syscfg), sizeof(configrec));
  close(configfile);
  printf("\nConfiguration set.\n");
}
