/*****************************************************************************
*                                                                            *
*   VBDATIM.H                                                                *
*                                                                            *
*   Copyright (c) 1994-1996 Galacticomm, Inc.        All rights reserved.    *
*                                                                            *
*   This is the global header file for VBDATIM.C utilities.                  *
*                                                                            *
*                                                 - Bill Hyatt 8/9/94        *
*                                                                            *         *
*****************************************************************************/

#define DOSBYR 1980                /* base year for DOS dates               */
#define DOSBVB (double)29221.0     /* 1/1/1980 in VB format                 */
#define DOSMVB (double)75971.0     /* max DOS date (12/31/2107) in VB fmt   */
#define VBBYR  1800                /* base year for VB dates                */
#define VBBDAT (double)(-36522.0)  /* 1/1/1800 in VB format                 */
#define VBMYR  2200                /* max year for VB dates                 */
#define VBMDAT (double)109939.0    /* max date for VB format (12/31/2200)   */
#define THSCEN 1900                /* base year for this century            */

#define isleap(yr) ((yr)%4 == 0 && ((yr)%100 != 0 || (yr)%400 == 0))
                                   /* is this year a leap year?             */

extern
int century;                       /* 19-23 - ind's century for v2sdat()    */

/* VBDATIM.C */
int v2ddat(double vbdat);
int v2dtim(double vbdat);
char *v2sdat(double vbdat);
char *v2stim(double vbdat);
double d2vdat(int dosdat,int dostim);
double s2vdat(char *stgdat,char *stgtim);

