###############################################################################
##### This Makefile generates the "MAJORBBS.EXE" and all standard DLL's   #####
###############################################################################

.autodepend
.silent
.path.c=$(MBBS)\src
.path.h=$(MBBS)\src
.path.def=$(MBBS)\dlib
.path.dll=$(MBBS)
.path.exe=$(MBBS)
.path.msg=$(MBBS)
!ifdef DEBUG
.path.obj=$(MBBS)\phobjd
!else
.path.obj=$(MBBS)\phobj
!endif
.path.stb=$(MBBS)\dlib

majorbbs: \
     galme.dll      galmsg.dll     galmhs.dll     galfil.dll     galmjd.dll  \
     galnote.dll    galchdir.dll   galp&q.dll     galqwk.dll     galreg.dll  \
     galrsy.dll     galtlc.dll     galtxv.dll     galuie.dll     galxit.dll  \
     bbsignup.dll   bbsmainm.dll   bbsfse.dll     galtext.dll    majorbbs.exe
     cd $(MBBS)
!ifdef DEBUG
     echo Build Complete! (DEBUG Version Built)
!else
     echo Build Complete!
!endif


majorbbs.exe: \
     bbsacct.h      bbsfsd.h       bbsftf.h                                  \
     bbsmajor.h     bbssup.h       bbsrip.h       bbserver.h     gcsasys.h   \
     about.obj      account.obj    accscn.obj     ain.obj        audit.obj   \
     autsns.obj     bbsgen.obj     bbsrip.obj     bbsutils.obj   cncutl.obj  \
     dftstats.obj   emulate.obj    filexfer.obj                              \
     fsd.obj        fsdbbs.obj     ftf.obj        ftfascii.obj   ftfkerm.obj \
     ftfview.obj    ftfxymd.obj    ftfzmod.obj                               \
     helpscn.obj    local.obj      locknkey.obj   majorbbs.obj               \
     menuing.obj    mnuutl.obj     monitor.obj    oprlow.obj     plbbs.obj   \
     plbtvstf.obj   plstuff.obj    saputl.obj     signup.obj                 \
     statscns.obj   summary.obj    users.obj      gcsasys.obj    gcsgagt.obj \
     $(MBBS)\dlib\gcspsrv.lib      $(MBBS)\dlib\phgcomm.lib                  \
     $(MBBS)\dlib\phdgcomm.lib     $(MBBS)\dlib\plhide.lib                   \
     $(MBBS)\dlib\gmeimp.lib       $(MBBS)\dlib\msgimp.lib                   \
     $(MBBS)\dlib\mhsimp.lib                                                 \
     $(PHARLAP)\bc4\lib\bch286.lib $(PHARLAP)\bc4\lib\phapi.lib              \
     $(MBBS)\dlib\majorbbs.def
!ifdef DEBUG
     ltphd
!else
     ltph
!endif


###############################################################################
#####                           Build DLL's                               #####
###############################################################################

bbsignup.dll: \
     bbsignup.h                                                              \
     bbsignup.obj                                                            \
     $(MBBS)\dlib\galimp.lib                                                 \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld bbsignup
!else
     ltdll bbsignup
!endif

bbsmainm.dll: \
     bbsmainm.h                                                              \
     bbsmainm.obj   gcwinver.obj                                             \
     $(MBBS)\dlib\galimp.lib                                                 \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld bbsmainm
!else
     ltdll bbsmainm
!endif

bbsfse.dll: \
     bbsedtf.h      bbsedtm.h                                                \
     editfse.obj    editasm.obj                                              \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld bbsfse
!else
     ltdll bbsfse
!endif

galfil.dll: \
     galfil.h       galfilu.obj                                              \
     galfil.obj     galfilut.obj   galfiluz.obj   galfilcs.obj   reserve.obj \
     $(MBBS)\dlib\galimp.lib       $(MBBS)\dlib\gsblimp.lib                  \
     $(MBBS)\dlib\galfil.lib       $(PHARLAP)\bc4\lib\phapi.lib              \
     $(MBBS)\dlib\galfil.def
!ifdef DEBUG
     ltdlld galfil
!else
     ltdll galfil
!endif

galmjd.dll: \
     galmjd.h                                                                \
     galmjd.obj                                                              \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galmjd
!else
     ltdll galmjd
!endif

galnote.dll: \
     galnote.h      bbsmajor.h                                               \
     galnote.obj                                                             \
     $(MBBS)\dlib\galimp.lib       $(MBBS)\dlib\gsblimp.lib                  \
     $(PHARLAP)\bc4\lib\phapi.lib  $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galnote
!else
     ltdll galnote
!endif

galme.dll: \
     galme.h                                                                 \
     gmeutl.obj     gmeloc.obj     gmeonl.obj     gmecore.obj                \
     datutils.obj   threadu.obj                                              \
     $(MBBS)\dlib\galimp.lib       $(PHARLAP)\bc4\lib\phapi.lib              \
     $(MBBS)\dlib\galtext.lib      $(MBBS)\dlib\gmedef.def
!ifdef DEBUG
     ltdlld galme
!else
     ltdll galme
!endif

galmsg.dll: \
     galmsg.h                                                                \
     datutils.obj   efutl.obj      aaefu.obj      aaeml.obj                  \
     aafor.obj      csefu.obj      cseml.obj      csfor.obj                  \
     $(MBBS)\dlib\galimp.lib       $(MBBS)\dlib\gsblimp.lib                  \
     $(MBBS)\dlib\gmeimp.lib       $(PHARLAP)\bc4\lib\phapi.lib              \
     $(MBBS)\dlib\galtext.lib      $(MBBS)\dlib\galmsg.def
!ifdef DEBUG
     ltdlld galmsg
!else
     ltdll galmsg
!endif

galmhs.dll: \
     galmhs.h                                                                \
     galmhs.obj                                                              \
     $(MBBS)\dlib\galimp.lib       $(MBBS)\dlib\gsblimp.lib                  \
     $(MBBS)\dlib\gmeimp.lib       $(PHARLAP)\bc4\lib\phapi.lib              \
     $(MBBS)\dlib\galmhs.def
!ifdef DEBUG
     ltdlld galmhs
!else
     ltdll galmhs
!endif

galtext.dll: \
     galtext.obj    galrtf.obj                                               \
     $(MBBS)\dlib\galimp.lib       $(PHARLAP)\bc3\lib\phapi.lib              \
     $(MBBS)\dlib\galtext.def
!ifdef DEBUG
     ltdlld galtext
!else
     ltdll galtext
!endif

galp&q.dll: \
     galp&q.h galp&qh.h                                                      \
     galp&q.obj galp&qa.obj                                                  \
     $(MBBS)\dlib\galimp.lib       $(MBBS)\dlib\gsblimp.lib                  \
     $(MBBS)\dlib\gmeimp.lib                                                 \
     $(PHARLAP)\bc4\lib\phapi.lib  $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galp&q
!else
     ltdll galp&q
!endif

galqwk.dll: \
     galqwk.h                                                                \
     galqwk.obj                                                              \
     $(MBBS)\dlib\galimp.lib       $(MBBS)\dlib\gsblimp.lib                  \
     $(MBBS)\dlib\gmeimp.lib       $(MBBS)\dlib\galchdir.lib                 \
     $(PHARLAP)\bc4\lib\phapi.lib  $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galqwk
!else
     ltdll galqwk
!endif

galchdir.dll: \
     chandir.h                                                               \
     chandir.obj                                                             \
     $(MBBS)\dlib\galchdir.def                                               \
     $(MBBS)\dlib\galimp.lib                                                 \
     $(PHARLAP)\bc4\lib\phapi.lib
!ifdef DEBUG
     ltdlld galchdir
!else
     ltdll galchdir
!endif

galreg.dll: \
     galregis.h                                                              \
     registry.obj                                                            \
     csregis.obj                                                             \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galreg
!else
     ltdll galreg
!endif

galrsy.dll: \
     galrsy.h                                                                \
     remsys.obj     remsys2.obj   csrsys.obj                                 \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galrsy
!else
     ltdll galrsy
!endif

galtlc.dll: \
     galtlc.h                                                                \
     mjrtlc.obj                                                              \
     csmjrtlc.obj                                                            \
     tlcutl.obj                                                              \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galtlc
!else
     ltdll galtlc
!endif

galtxv.dll: \
     txtvbl.obj                                                              \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galtxv
!else
     ltdll galtxv
!endif

galuie.dll: \
     bbssup.h                                                                \
     uinfed.obj                                                              \
     csuinfed.obj                                                            \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galuie
!else
     ltdll galuie
!endif

galxit.dll: \
     bbsmajor.h                                                              \
     mjrexit.obj                                                             \
     $(MBBS)\dlib\galimp.lib         $(MBBS)\dlib\gsblimp.lib                \
     $(PHARLAP)\bc4\lib\phapi.lib   $(MBBS)\dlib\nodef.def
!ifdef DEBUG
     ltdlld galxit
!else
     ltdll galxit
!endif

###############################################################################
#####                 Build Objects For BBSIGNUP DLL                      #####
###############################################################################

bbsignup.obj: bbsignup.c
!ifdef DEBUG
     ctdlld bbsignup
!else
     ctdll bbsignup
!endif

###############################################################################
#####                 Build Objects For BBSMAINM DLL                      #####
###############################################################################

bbsmainm.obj: bbsmainm.c
!ifdef DEBUG
     ctdlld bbsmainm
!else
     ctdll bbsmainm
!endif

gcwinver.obj: gcwinver.c
!ifdef DEBUG
     ctdlld gcwinver
!else
     ctdll gcwinver
!endif

###############################################################################
#####                 Build Objects For BBSFSE DLL                        #####
###############################################################################

editasm.obj: editasm.c
!ifdef DEBUG
     ctdlld editasm
!else
     ctdll editasm
!endif

editfse.obj: editfse.c
!ifdef DEBUG
     ctdlld editfse
!else
     ctdll editfse
!endif

###############################################################################
#####                 Build Objects For GALFIL DLL                        #####
###############################################################################

galfil.obj: galfil.c
!ifdef DEBUG
     ctdlld galfil.c
!else
     ctdll galfil.c
!endif

galfilu.obj: galfilu.c
!ifdef DEBUG
     ctdlld galfilu.c
!else
     ctdll galfilu.c
!endif

galfilut.obj: galfilut.c
!ifdef DEBUG
     ctdlld galfilut.c
!else
     ctdll galfilut.c
!endif

galfiluz.obj: galfiluz.c
!ifdef DEBUG
     ctdlld galfiluz.c
!else
     ctdll galfiluz.c
!endif

galfilcs.obj: galfilcs.c
!ifdef DEBUG
     ctdlld galfilcs.c
!else
     ctdll galfilcs.c
!endif

reserve.obj: reserve.c
!ifdef DEBUG
     ctdlld reserve.c
!else
     ctdll reserve.c
!endif

###############################################################################
#####                 Build Objects For GALMJD DLL                        #####
###############################################################################

galmjd.obj: galmjd.c
!ifdef DEBUG
     ctdlld galmjd
!else
     ctdll galmjd
!endif

###############################################################################
#####                  Build Objects For GALME.DLL                        #####
###############################################################################

gmeutl.obj: gmeutl.c
!ifdef DEBUG
     ctdlld gmeutl.c
!else
     ctdll gmeutl.c
!endif

gmeloc.obj: gmeloc.c
!ifdef DEBUG
     ctdlld gmeloc.c
!else
     ctdll gmeloc.c
!endif

gmeonl.obj: gmeonl.c
!ifdef DEBUG
     ctdlld gmeonl.c
!else
     ctdll gmeonl.c
!endif

gmecore.obj: gmecore.c
!ifdef DEBUG
     ctdlld gmecore.c
!else
     ctdll gmecore.c
!endif

datutils.obj: datutils.c
!ifdef DEBUG
     ctdlld datutils.c
!else
     ctdll datutils.c
!endif

threadu.obj: threadu.c
!ifdef DEBUG
     ctdlld threadu.c
!else
     ctdll threadu.c
!endif

###############################################################################
#####                 Build Objects For GALMSG DLL                        #####
###############################################################################

efutl.obj: efutl.c
!ifdef DEBUG
     ctdlld efutl.c
!else
     ctdll efutl.c
!endif

aaefu.obj: aaefu.c
!ifdef DEBUG
     ctdlld aaefu.c
!else
     ctdll aaefu.c
!endif

aaeml.obj: aaeml.c
!ifdef DEBUG
     ctdlld aaeml.c
!else
     ctdll aaeml.c
!endif

aafor.obj: aafor.c
!ifdef DEBUG
     ctdlld aafor.c
!else
     ctdll aafor.c
!endif

csefu.obj: csefu.c
!ifdef DEBUG
     ctdlld csefu.c
!else
     ctdll csefu.c
!endif

cseml.obj: cseml.c
!ifdef DEBUG
     ctdlld cseml.c
!else
     ctdll cseml.c
!endif

csfor.obj: csfor.c
!ifdef DEBUG
     ctdlld csfor.c
!else
     ctdll csfor.c
!endif

###############################################################################
#####                  Build Objects For GALMHS.DLL                       #####
###############################################################################

galmhs.obj: galmhs.c
!ifdef DEBUG
     ctdlld galmhs.c
!else
     ctdll galmhs.c
!endif

###############################################################################
#####                 Build Objects For GALTEXT.DLL                       #####
###############################################################################

galtext.obj: galtext.c
!ifdef DEBUG
     ctdlld galtext.c
!else
     ctdll galtext.c
!endif

galrtf.obj: galrtf.c
!ifdef DEBUG
     ctdlld galrtf.c
!else
     ctdll galrtf.c
!endif

###############################################################################
#####                 Build Objects For GALNOTE DLL                       #####
###############################################################################

galnote.obj: galnote.c
!ifdef DEBUG
     ctdlld galnote
!else
     ctdll galnote
!endif

###############################################################################
#####                 Build Objects For GALP&Q DLL                        #####
###############################################################################

galp&q.obj: galp&q.c
!ifdef DEBUG
     ctdlld galp&q
!else
     ctdll galp&q
!endif

galp&qa.obj: galp&qa.c
!ifdef DEBUG
     ctdlld galp&qa
!else
     ctdll galp&qa
!endif

###############################################################################
#####                 Build Objects For GALQWK DLL                        #####
###############################################################################

galqwk.obj: galqwk.c
!ifdef DEBUG
     ctdlld galqwk
!else
     ctdll galqwk
!endif

###############################################################################
#####                 Build Objects For GALCHDIR DLL                      #####
###############################################################################

chandir.obj: galchdir.h chandir.c
!ifdef DEBUG
     ctdlld chandir
!else
     ctdll chandir
!endif

###############################################################################
#####                 Build Objects For GALREG DLL                        #####
###############################################################################

registry.obj: registry.c
!ifdef DEBUG
     ctdlld registry
!else
     ctdll registry
!endif

csregis.obj: csregis.c
!ifdef DEBUG
     ctdlld csregis
!else
     ctdll csregis
!endif

###############################################################################
#####                 Build Objects For GALRSY DLL                        #####
###############################################################################

remsys.obj: remsys.c
!ifdef DEBUG
     ctdlld remsys
!else
     ctdll remsys
!endif

remsys2.obj: remsys2.c
!ifdef DEBUG
     ctdlld remsys2
!else
     ctdll remsys2
!endif

csrsys.obj: csrsys.c
!ifdef DEBUG
     ctdlld csrsys
!else
     ctdll csrsys
!endif

###############################################################################
#####                 Build Objects For GALTLC DLL                        #####
###############################################################################

mjrtlc.obj: mjrtlc.c
!ifdef DEBUG
     ctdlld mjrtlc
!else
     ctdll mjrtlc
!endif

csmjrtlc.obj: csmjrtlc.c
!ifdef DEBUG
     ctdlld csmjrtlc
!else
     ctdll csmjrtlc
!endif

tlcutl.obj: tlcutl.c
!ifdef DEBUG
     ctdlld tlcutl
!else
     ctdll tlcutl
!endif

###############################################################################
#####                 Build Objects For GALTXV DLL                        #####
###############################################################################

txtvbl.obj: txtvbl.c
!ifdef DEBUG
     ctdlld txtvbl
!else
     ctdll txtvbl
!endif

###############################################################################
#####                 Build Objects For GALUIE DLL                        #####
###############################################################################

uinfed.obj: uinfed.c
!ifdef DEBUG
     ctdlld uinfed
!else
     ctdll uinfed
!endif

csuinfed.obj: csuinfed.c
!ifdef DEBUG
     ctdlld csuinfed
!else
     ctdll csuinfed
!endif

###############################################################################
#####                 Build Objects For GALXIT DLL                        #####
###############################################################################

mjrexit.obj: mjrexit.c
!ifdef DEBUG
     ctdlld mjrexit
!else
     ctdll mjrexit
!endif

###############################################################################
#####                    Build Objects For main Executive                 #####
###############################################################################

about.obj: about.c
!ifdef DEBUG
     ctphd about
!else
     ctph about
!endif

account.obj: account.c
!ifdef DEBUG
     ctphd account
!else
     ctph account
!endif

accscn.obj: accscn.c
!ifdef DEBUG
     ctphd accscn
!else
     ctph accscn
!endif

ain.obj: ain.c
!ifdef DEBUG
     ctphd ain
!else
     ctph ain
!endif

audit.obj: audit.c
!ifdef DEBUG
     ctphd audit
!else
     ctph audit
!endif

autsns.obj: autsns.c
!ifdef DEBUG
     ctphd autsns
!else
     ctph autsns
!endif

bbsgen.obj: bbsgen.c
!ifdef DEBUG
     ctphd bbsgen
!else
     ctph bbsgen
!endif

bbsrip.obj: bbsrip.c
!ifdef DEBUG
     ctphd bbsrip
!else
     ctph bbsrip
!endif

bbsutils.obj: bbsutils.c
!ifdef DEBUG
     ctphd bbsutils
!else
     ctph bbsutils
!endif

cncutl.obj: cncutl.c
!ifdef DEBUG
     ctphd cncutl
!else
     ctph cncutl
!endif

dftstats.obj: dftstats.c
!ifdef DEBUG
     ctphd dftstats
!else
     ctph dftstats
!endif

emulate.obj: emulate.c
!ifdef DEBUG
     ctphd emulate
!else
     ctph emulate
!endif

filexfer.obj: filexfer.c
!ifdef DEBUG
     ctphd filexfer
!else
     ctph filexfer
!endif

fsd.obj: fsd.c
!ifdef DEBUG
     ctphd fsd
!else
     ctph fsd
!endif

fsdbbs.obj: fsdbbs.c
!ifdef DEBUG
     ctphd fsdbbs
!else
     ctph fsdbbs
!endif

ftf.obj: ftf.c
!ifdef DEBUG
     ctphd ftf
!else
     ctph ftf
!endif

ftfascii.obj: ftfascii.c
!ifdef DEBUG
     ctphd ftfascii
!else
     ctph ftfascii
!endif

ftfkerm.obj: ftfkerm.c
!ifdef DEBUG
     ctphd ftfkerm
!else
     ctph ftfkerm
!endif

ftfview.obj: ftfview.c
!ifdef DEBUG
     ctphd ftfview
!else
     ctph ftfview
!endif

ftfxymd.obj: ftfxymd.c
!ifdef DEBUG
     ctphd ftfxymd
!else
     ctph ftfxymd
!endif

ftfzmod.obj: ftfzmod.c
!ifdef DEBUG
     ctphd ftfzmod
!else
     ctph ftfzmod
!endif

helpscn.obj: helpscn.c
!ifdef DEBUG
     ctphd helpscn
!else
     ctph helpscn
!endif

local.obj: local.c
!ifdef DEBUG
     ctphd local
!else
     ctph local
!endif

locknkey.obj: locknkey.c
!ifdef DEBUG
     ctphd locknkey
!else
     ctph locknkey
!endif

majorbbs.obj: majorbbs.c
!ifdef DEBUG
     ctphd majorbbs
!else
     ctph majorbbs
!endif

menuing.obj: menuing.c
!ifdef DEBUG
     ctphd menuing
!else
     ctph menuing
!endif

mnuutl.obj: mnuutl.c
!ifdef DEBUG
     ctphd mnuutl
!else
     ctph mnuutl
!endif

monitor.obj: monitor.c
!ifdef DEBUG
     ctphd monitor
!else
     ctph monitor
!endif

oprlow.obj: oprlow.c
!ifdef DEBUG
     ctphd oprlow
!else
     ctph oprlow
!endif

plbbs.obj: plbbs.c
!ifdef DEBUG
     ctphd plbbs
!else
     ctph plbbs
!endif

plbtvstf.obj: plbtvstf.c
!ifdef DEBUG
     ctphd plbtvstf
!else
     ctph plbtvstf
!endif

plstuff.obj: plstuff.c
!ifdef DEBUG
     ctphd plstuff.c
!else
     ctph plstuff.c
!endif

saputl.obj: saputl.c
!ifdef DEBUG
     ctphd saputl
!else
     ctph saputl
!endif

signup.obj: signup.c
!ifdef DEBUG
     ctphd signup
!else
     ctph signup
!endif

statscns.obj: statscns.c
!ifdef DEBUG
     ctphd statscns
!else
     ctph statscns
!endif

summary.obj: summary.c
!ifdef DEBUG
     ctphd summary
!else
     ctph summary
!endif

users.obj: users.c
!ifdef DEBUG
     ctphd users
!else
     ctph users
!endif

gcsasys.obj: gcsasys.c
!ifdef DEBUG
     ctphd gcsasys
!else
     ctph gcsasys
!endif

gcsgagt.obj: gcsgagt.c
!ifdef DEBUG
     ctphd gcsgagt
!else
     ctph gcsgagt
!endif


############################################################################
#####                       Generate .LIB files                        #####
############################################################################

$(MBBS)\dlib\galimp.lib: majorbbs.def libstub.stb
     cd $(MBBS)\dlib
     copy libstub.stb tempdeff.def > NUL
     copy tempdeff.def+majorbbs.def > NUL
     implib galimp.lib tempdeff.def
     del tempdeff.def > NUL
     cd $(MBBS)\src

$(MBBS)\dlib\msgimp.lib: galmsg.def
     cd $(MBBS)\dlib
     implib msgimp.lib galmsg.def
     cd $(MBBS)\src

$(MBBS)\dlib\mhsimp.lib: galmhs.def
     cd $(MBBS)\dlib
     implib mhsimp.lib galmhs.def
     cd $(MBBS)\src

$(MBBS)\dlib\gmeimp.lib: gmedef.def
     cd $(MBBS)\dlib
     implib gmeimp.lib gmedef.def
     cd $(MBBS)\src

$(MBBS)\dlib\galtext.lib: galtext.def
     cd $(MBBS)\dlib
     implib galtext.lib galtext.def
     cd $(MBBS)\src

$(MBBS)\dlib\galchdir.lib: galchdir.def
     cd $(MBBS)\dlib
     implib galchdir.lib galchdir.def
     cd $(MBBS)\src

$(MBBS)\dlib\gsblimp.lib: brkthu.def
     cd $(MBBS)\dlib
     implib gsblimp.lib brkthu.def
     cd $(MBBS)\src

$(MBBS)\dlib\galfil.lib: galfil.def
     cd $(MBBS)\dlib
     implib galfil.lib galfil.def
     cd $(MBBS)\src

############################################################################
#####               Generate Headers for Compilation                   #####
############################################################################

bbsacct.h: bbsacct.msg
     cd $(MBBS)
     wgsmsx bbsacct -osrc
     cd $(MBBS)\src

galme.h: galme.msg
     cd $(MBBS)
     wgsmsx galme -osrc
     cd $(MBBS)\src

galmsg.h: galmsg.msg
     cd $(MBBS)
     wgsmsx galmsg -osrc
     cd $(MBBS)\src

galmhs.h: galmhs.msg
     cd $(MBBS)
     wgsmsx galmhs -osrc
     cd $(MBBS)\src

bbsfsd.h: bbsfsd.msg
     cd $(MBBS)
     wgsmsx bbsfsd -osrc
     cd $(MBBS)\src

bbsftf.h: bbsftf.msg
     cd $(MBBS)
     wgsmsx bbsftf -osrc
     cd $(MBBS)\src

bbsmajor.h: bbsmajor.msg
     cd $(MBBS)
     wgsmsx bbsmajor -osrc
     cd $(MBBS)\src

bbserver.h: bbserver.msg
     cd $(MBBS)
     wgsmsx bbserver -osrc
     cd $(MBBS)\src

galtlc.h: galtlc.msg
     cd $(MBBS)
     wgsmsx galtlc -osrc
     cd $(MBBS)\src

galnote.h: galnote.msg
     cd $(MBBS)
     wgsmsx galnote -osrc
     cd $(MBBS)\src

galp&q.h: galp&q.msg
     cd $(MBBS)
     wgsmsx galp&q -osrc
     cd $(MBBS)\src

galregis.h: galregis.msg
     cd $(MBBS)
     wgsmsx galregis -osrc
     cd $(MBBS)\src

galrsy.h: galrsy.msg
     cd $(MBBS)
     wgsmsx galrsy -osrc
     cd $(MBBS)\src

bbssup.h: bbssup.msg
     cd $(MBBS)
     wgsmsx bbssup -osrc
     cd $(MBBS)\src

bbsignup.h: bbsignup.msg
     cd $(MBBS)
     wgsmsx bbsignup -osrc
     cd $(MBBS)\src

bbsmainm.h: bbsmainm.msg
     cd $(MBBS)
     wgsmsx bbsmainm -osrc
     cd $(MBBS)\src

bbsedtf.h: bbsedtf.msg
     cd $(MBBS)
     wgsmsx bbsedtf -osrc
     cd $(MBBS)\src

bbsedtm.h: bbsedtm.msg
     cd $(MBBS)
     wgsmsx bbsedtm -osrc
     cd $(MBBS)\src

galfil.h: galfil.msg
     cd $(MBBS)
     wgsmsx galfil -osrc
     cd $(MBBS)\src

galmjd.h: galmjd.msg
     cd $(MBBS)
     wgsmsx galmjd -osrc
     cd $(MBBS)\src

bbsrip.h: bbsrip.msg
     cd $(MBBS)
     wgsmsx bbsrip -osrc
     cd $(MBBS)\src

galqwk.h: galqwk.msg
     cd $(MBBS)
     wgsmsx galqwk -osrc
     cd $(MBBS)\src

galchdir.h: galchdir.msg
     cd $(MBBS)
     wgsmsx galchdir -osrc
     cd $(MBBS)\src
