/***************************************************************************
 *                                                                         *
 *   GMEONL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1995 GALACTICOMM, Inc     All Rights Reserved.     *
 *                                                                         *
 *   This file contains common and utility functions used by and for GME   *
 *   only while online.                                                    *
 *                                                                         *
 *                                           - J. Alvrus   6/9/94          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "fcntl.h"
#include "share.h"
#include "sys\stat.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "galme.h"
#include "galtext.h"
#include "gme.h"
#include "gmeutl.h"
#include "gmeloc.h"
#include "gmecore.h"

#define FILREV "$Revision: 1.10 $"

#define CNKPCYC 4                  /* "chunks" of file to copy per cycle   */

STATIC
BOOL gmeinit=FALSE;                /* has init__galme() been called yet?   */

STATIC
struct sscache {                   /* simple send cache struct             */
     char work[GMEWRKSZ];          /*   GME work space                     */
     struct message msg;           /*   new message structure              */
     char attspc[MAXPATH];         /*   path+file name of att (if any)     */
     char text[1];                 /*   message body text                  */
} *ssbuf;

STATIC
int sstskid=-1;                    /* simple send task ID                  */
STATIC
BOOL ssiuflg=FALSE;                /* simple send in use flag              */
STATIC
BTVFILE *sscbb=NULL;               /* simple send cache file               */

unsigned ncflfn=0;                 /* number of registered conflict chkers */
cflfunc *cflfnar=NULL;             /* array of pointers to conflict chkers */

int ngmelk=0;                      /* number of slots in lock array        */
struct gmelock *gmelkarr=NULL;     /* pointer to lock array                */

unsigned numsl=0;                  /* number of sysop dist lists           */
struct slinfo *losl=NULL;          /* array of sysop dist list info structs*/

unsigned ngmehooks=0;              /* number of hooks                      */
struct gmehook *gmehooks=NULL;     /* pointer to hook array                */

STATIC void ck4gpf(void);
STATIC void emlnewu(void);
STATIC void gmecup(void);
STATIC void gmedla(char *uid);
STATIC void gmesht(void);
STATIC void bgmcupt(int taskid);
STATIC void inisimp(void);
STATIC void clssimp(void);
STATIC void cpy2cache(struct sscache *cache,struct gmework *work,
                      struct message *msg,char *text,char *filatt);
STATIC void sndtask(int taskid);
STATIC BOOL old2new(char *to,struct oldmsg *old,struct message *msg,
                    char *text,char *filatt);
STATIC char *_oldafn(struct oldmsg *msg);

void
init__galme(void)                  /* GME initialization function          */
{
     if (!gmeinit) {
          gmeinit=TRUE;
          iniutl();
          iniloc();
          inicore();
          inisimp();
          inilosl();
          hook_cleanup(gmecup);
          hook_delacct(gmedla);
          hook_finalshutdown(gmesht);
          if (needbgc()) {
               bgcipg=TRUE;
               initask(bgmcupt);
          }
          if (emlsdrou == NULL) {
               emlsdrou=emlnewu;
          }
          rtkick(1,ck4gpf);
     }
}

STATIC void
ck4gpf(void)                  /* send email to sysop if GP.FLG exists      */
{
     if (fnd1st(&gmefb,"GP.FLG",0)) {
          setmem(utlmsg,sizeof(struct message),0);
          utlmsg->forum=EMLID;
          strcpy(utlmsg->from,"Sysop");
          strcpy(utlmsg->to,"Sysop");
          strcpy(utlmsg->topic,"Reboot occurred after GP");
          utlmsg->flags=FILATT+FILAPV+FILIND;
          strcpy(utlmsg->attname,"GP.OUT");
          setmbk(gmemb);
          stlcpy(utltxt,getmsg(GPNOTI),TXTLEN);
          rstmbk();
          inigmerq(utlwork);
          while (gsndmsg(utlwork,utlmsg,utltxt,"GP.OUT") == GMEAGAIN) {
               /* this is OK here since it's only once, at startup */
          }
          unlink("GP.FLG");
     }
}

STATIC void
emlnewu(void)                      /* send E-mail regarding new user       */
{
     int svcl;
     char *tmps;

     setmbk(gmemb);
     svcl=clingo;
     clingo=0;
     if (supu2s) {
          setmem(utlmsg,sizeof(struct message),0);
          utlmsg->forum=EMLID;
          stlcpy(utlmsg->from,usaptr->userid,UIDSIZ);
          strcpy(utlmsg->to,"Sysop");
          stlcpy(utlmsg->topic,nuemtp,TPCSIZ);
          utlmsg->flags=NOMOD+NODEL;
          prfmsg(NUEMHD);
          shwusr(usaptr);
          new2ret(prf2str(utltxt,TXTLEN));
          inigmerq(utlwork);
          while (gsndmsg(utlwork,utlmsg,utltxt,NULL) == GMEAGAIN) {
               /* prefer not to do this but don't have option to cycle */
          }
          if (onsys(utlmsg->to)) {
               prfmlt(NEWUEM,usaptr->userid);
               injoth();
          }
     }
     if (supe2u) {
          setmem(utlmsg,sizeof(struct message),0);
          utlmsg->forum=EMLID;
          ininew(utlmsg);
          strcpy(utlmsg->from,"Sysop");
          stlcpy(utlmsg->to,usaptr->userid,UIDSIZ);
          stlcpy(utlmsg->topic,e2utpc,TPCSIZ);
          utlmsg->thrid=cmptid(utlmsg);
          tmps=NULL;
          utlmsg->flags=(e2urrr ? RECREQ : 0L);
          if (*e2uatt != '\0') {
               utlmsg->flags|=(FILATT+FILAPV+FILIND);
               stlcpy(utlmsg->attname,e2uanm,FLNSIZ);
               tmps=e2uatt;
          }
          stlcpy(utltxt,getmsg(E2UTXT),TXTLEN);
          inigmerq(utlwork);
          while (gme1wnm(utlwork,utlmsg,utltxt,tmps) == GMEAGAIN) {
               /* prefer not to do this but don't have option to cycle */
          }
          *utlwork->cpyatt='\0';
          clsgmerq(utlwork);
     }
     clingo=svcl;
}

BOOL
gmeoffl(void)                      /* is the GME running in offline mode?  */
{
     return(FALSE);
}

STATIC void
gmecup(void)                       /* GME cleanup routine                  */
{
     gmeclean(absdtdy());
}

STATIC void
gmedla(char *uid)                  /* GME delete account routine           */
{
     setbtv(qscbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
     rstbtv();
     setbtv(qikbb);
     if (acqbtv(NULL,uid,0)) {
          delbtv();
     }
     rstbtv();
     cleandla(uid);
}

STATIC void
gmesht(void)                       /* GME shutdown routine                 */
{
     #ifdef DEBUG
          int i;
     #endif

     clssimp();
     clsloc(TRUE);
     clsutl();
     #ifdef DEBUG
          for (i=0 ; i < ngmelk ; ++i) {
               if (gmelkarr[i].rqid != 0U) {
                    shocst("MESSAGE LOCK LEFT ON:","Forum=%u, Msgid=%s",
                              gmelkarr[i].forum,l2as(gmelkarr[i].msgid));
               }
          }
     #endif
}

STATIC void
bgmcupt(                           /* background message cleanup task      */
int taskid)
{
     if (!pumpcup()) {
          mfytask(taskid,NULL);
          shocst("BACKGROUND CLEANUP COMPLETE",
                 "E-mail/Forums completed background cleanup for the day.");
     }
}

char *
gmexinf(void)                      /* get extended return information      */
{
     return(extinf);
}

char *                             /*   copy of pointer to destination     */
prf2str(                           /* copy prfbuf contents to a string     */
char *str,                         /*   string to copy into                */
unsigned len)                      /*   length of string                   */
{
     stpans(prfbuf);
     stlcpy(str,prfbuf,len);
     clrprf();
     return(str);
}

int                                /*   returns GME status code            */
inigmeu(void)                      /* initialize GME/user stuff at logon   */
{                                  /*   (must be called by user interface) */
     int i,qslen,idx,nfors;
     struct qscfg *qsc;
     struct fordef *fdef;

     qsc=uqsptr(usrnum);
     ASSERT(qsc->userid[0] == '\0');
     setbtv(qscbb);
     if (acqbtv(NULL,usaptr->userid,0)) {
          if ((qslen=llnbtv()) > qssiz) {
               while (qsdptr->nforums > MAXQSF && (i=qsdelf(qsdptr)) != NOIDX) {
                    idelqs(qsdptr,i);
               }
               while (qsdptr->nforums > MAXQSF && (i=qsoldm(qsdptr)) != NOIDX) {
                    idelqs(qsdptr,i);
               }
               while (qsdptr->nforums > MAXQSF && (i=qsoldr(qsdptr)) != NOIDX) {
                    idelqs(qsdptr,i);
               }
               while (qsdptr->nforums > MAXQSF) {
                    idelqs(qsdptr,qsoldest(qsdptr));
               }
               qslen=qsrlen(qsdptr->nforums);
          }
          movmem(qsdptr,qsc,qslen);
          if (!fidxst(qsc->curfor)) {
               qsc->curfor=dftfor;
               if (!inqs(qsc,dftfor)) {
                    idx=absadqs(qsc,dftfor);
                    if (idx != NOIDX) {
                         isethi(qsc,idx,-1L);
                    }
               }
          }
     }
     else {
          initqs(qsc,usaptr->userid);
     }
     rstbtv();
     if (autqsc) {
          nfors=numforums();
          for (i=0 ; i < nfors ; i++) {
               fdef=idxdef(i);
               if (fdef->crdate >= usaptr->usedat && !inqs(qsc,fdef->forum)) {
                    idx=add2qs(qsc,fdef->forum);
                    if (idx != NOIDX) {
                         isethi(qsc,idx,1L);
                    }
               }
          }
     }
     setbtv(qikbb);
     if (!qeqbtv(usaptr->userid,0)) {
          iniqik(qkdptr,usaptr->userid);
          invbtv(qkdptr,sizeof(struct qikdat)-1);
     }
     rstbtv();
     if (usaptr->emllim > _highmsg) {
          usaptr->emllim=FIRSTM;
          return(GMERST);
     }
     return(GMEOK);
}

void
clsgmeu(void)                      /* close GME/user stuff at logoff       */
{                                  /* (must be called by user interface)   */
     struct qscfg *qsc;

     qsc=uqsptr(usrnum);
     ASSERT(qsc->userid[0] != '\0');
     setbtv(qscbb);
     if (acqbtv(NULL,qsc->userid,0)) {
          if (memcmp(qsdptr,qsc,qsrlen(qsc->nforums)) != 0) {
               upvbtv(qsc,qsrlen(qsc->nforums));
          }
     }
     else {
          invbtv(qsc,qsrlen(qsc->nforums));
     }
     rstbtv();
     setmem(qsc,qssiz,0);
}

void
setgmecb(                          /* set handler for GME status reports   */
void *workb,                       /*   work area being used for request   */
void (*callback)(int,int))         /*   pointer to callback handler        */
{
     struct gmework *work=(struct gmework *)workb;

     work->callback=callback;
}

void
callback(                          /* call callback handler if any         */
struct gmework *work,              /*   being used by this work area       */
int evt,                           /*   event to report                    */
int res,                           /*   result code to report              */
char *info)                        /*   string to put in extinf            */
{
     if (work->callback != NULL) {
          if (info != NULL) {
               stlcpy(extinf,info,XINFSZ);
          }
          (*work->callback)(evt,res);
          *extinf='\0';
     }
}

BOOL                               /*   returns TRUE if able to add to list*/
setcfl(                            /* set cooperative conflict checker     */
cflfunc cflchk)                    /*   function to check                  */
{
     if (ncflfn < MAXPARSZ) {
          if (alcpar((void ***)&cflfnar,ncflfn,SMLBLK)) {
               cflfnar[ncflfn++]=cflchk;
               return(TRUE);
          }
     }
     return(FALSE);
}

BOOL                               /*   returns TRUE if a conflict         */
chkcfl(                            /* chk others for conflict w/my cur msg */
void *workb)                       /*   work area being used to read       */
{
     struct gmework *work=(struct gmework *)workb;

     if (work->rdctx.mid <= 0L) {
          return(FALSE);
     }
     return(gmecfl(work,work->rdctx.fid,work->rdctx.mid));
}

BOOL                               /*   returns TRUE if a conflict         */
chkmycfl(                          /* check my current message for conflict*/
void *workb,                       /*   my work area being used to read    */
unsigned forum,                    /*   forum ID w/possible conflict       */
long msgid)                        /*   message ID w/possible conflict     */
{
     struct gmework *work=(struct gmework *)workb;

     if (msgid == 0L) {
          return(forum == work->rdctx.fid);
     }
     return(msgid == work->rdctx.mid);
}

BOOL                               /*   returns TRUE if a conflict         */
gencfl(                            /* generic conflict checker             */
void *workb,                       /*   work area in use                   */
unsigned forum,                    /*   forum ID to check                  */
long msgid)                        /*   msg ID to check (0L for forum only)*/
{
     return(gmecfl((struct gmework *)workb,forum,msgid));
}

BOOL                               /*   returns TRUE if a conflict         */
gmecfl(                            /* check for any conflict               */
struct gmework *work,              /*   work area in use                   */
unsigned forum,                    /*   forum ID w/possible conflict       */
long msgid)                        /*   message ID w/possible conflict     */
{
     int i;

     ASSERT(work != NULL);
     ASSERT(forum == EMLID || fidxst(forum));
     if (msgid == 0L) {
          for (i=0 ; i < ngmelk ; ++i) {
               if (gmelkarr[i].rqid != 0U
                && gmelkarr[i].rqid != work->rqid
                && gmelkarr[i].forum == forum) {
                    return(TRUE);
               }
          }
     }
     else {
          for (i=0 ; i < ngmelk ; ++i) {
               if (gmelkarr[i].rqid != 0U
                && gmelkarr[i].rqid != work->rqid
                && gmelkarr[i].msgid == msgid) {
                    return(TRUE);
               }
          }
     }
     for (i=0 ; i < ncflfn ; ++i) {
          if ((*(cflfnar[i]))(work,forum,msgid)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

BOOL                               /*   was lock successful?               */
gmelok(                            /* put a lock on a message or forum     */
struct gmework *work,              /*   work area associated w/lock        */
unsigned forum,                    /*   forum ID to lock                   */
long msgid)                        /*   message ID to lock                 */
{
     int i;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     for (i=0 ; i < ngmelk && gmelkarr[i].rqid != 0U ; ++i) {
     }
     if (i < ngmelk) {
          gmelkarr[i].rqid=work->rqid;
          gmelkarr[i].forum=forum;
          gmelkarr[i].msgid=msgid;
          return(TRUE);
     }
     else {
          if (alcarr((void **)&gmelkarr,sizeof(struct gmelock),ngmelk,SMLBLK)) {
               gmelkarr[ngmelk].rqid=work->rqid;
               gmelkarr[ngmelk].forum=forum;
               gmelkarr[ngmelk].msgid=msgid;
               ++ngmelk;
               return(TRUE);
          }
          #ifdef DEBUG
               else {
                    catastro("Out of GME internal locks!");
               }
          #endif
     }
     return(FALSE);
}

void
gmeulk(                            /* unlock a message or forum            */
struct gmework *work,              /*   work area associated w/lock        */
unsigned forum,                    /*   forum ID to unlock                 */
long msgid)                        /*   message ID to unlock               */
{
     int i;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     for (i=0 ; i < ngmelk ; ++i) {
          if (gmelkarr[i].rqid == work->rqid
           && gmelkarr[i].forum == forum
           && gmelkarr[i].msgid == msgid) {
               gmelkarr[i].rqid=0U;
               break;
          }
     }
}

void
gmeulkr(                           /* remove all locks assoc with a request*/
struct gmework *work)              /*   work area associated w/request     */
{
     int i;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     for (i=0 ; i < ngmelk ; ++i) {
          if (gmelkarr[i].rqid == work->rqid) {
               gmelkarr[i].rqid=0U;
          }
     }
}

void
setscan(                           /* set the scan context                 */
void *workb,                       /*   for this work space                */
struct otscan *newscn)             /*   to this scan buffer                */
{
     ASSERT(workb != NULL);
     ASSERT(gmerqopn(workb));
     ASSERT(newscn != NULL);
     ((struct gmework *)workb)->curscn=newscn;
}

struct otscan *
getscan(                           /* get the current scan context buffer  */
void *workb)                       /*   for this work space                */
{
     ASSERT(workb != NULL);
     ASSERT(gmerqopn(workb));
     return(((struct gmework *)workb)->curscn);
}

void
gmeSetAppInfo(                     /* set app-defined info (when sending)  */
void *workb,                       /*   for this work area                 */
const char *appinf)                /*   to this buffer                     */
{
     ASSERT(workb != NULL);
     ASSERT(gmerqopn(workb));
     ((struct gmework *)workb)->appinf=appinf;
}

const char *                       /*   returns pointer to temp buffer     */
gmeGetAppInfo(void)                /* get app-defined info (after reading) */
{
     if (curapi == NULL) {
          return("");
     }
     return(curapi);
}

void
hdlfmtxt(                          /* handle formatted text (cvt to ASCII) */
char *text)                        /*   text buffer                        */
{
     if (isfmtted(text) && cvt2asc(text,utltxt,TXTLEN-1)) {
          text[0]='\r';
          stlcpy(&text[1],utltxt,TXTLEN-1);
     }
}

BOOL                               /*   returns TRUE if hook set           */
hook_gme(                          /* set a GME function hook              */
int hooktype,                      /*   type of hook to set                */
voidfunc hookfunc)                 /*   hook function pointer              */
{
     ASSERT(hooktype >= GMEHOOK_NOT_NEWMSG && hooktype <= GMEHOOK_NOT_DELFORL);
     ASSERT(hookfunc != NULL);
     if (alcarr((void **)&gmehooks,sizeof(struct gmehook),ngmehooks,SMLBLK)) {
          gmehooks[ngmehooks].hooktype=hooktype;
          gmehooks[ngmehooks].hookfunc=hookfunc;
          ++ngmehooks;
          return(TRUE);
     }
     return(FALSE);
}

void
notnwm(                            /* handle new message notification hook */
int nwmtyp,                        /*   new message type code              */
struct gmework *work,              /*   work area in use                   */
struct message *msg,               /*   header of new message              */
const char *text)                  /*   message text                       */
{
     int i;
     char savehist[HSTSIZ];

     curapi=(char *)work->appinf;
     if (work->flags&FWDMSG) {
          stlcpy(extinf,work->auxto,UIDSIZ);
     }
     else {
          *extinf='\0';
     }
     i=NOIDX;
     while ((i=nexthook(GMEHOOK_NOT_NEWMSG,i)) != NOIDX) {
          (*(gmehook_not_newmsg)(gmehooks[i].hookfunc))(nwmtyp,msg,text);
     }
     if (newmsghook != NULL) {
          if (work->flags&FWDMSG) {
               stlcpy(extinf,msg->to,MAXADR);
               stlcpy(msg->to,work->auxto,UIDSIZ);
               stlcpy(savehist,msg->history,HSTSIZ);
               stlcpy(msg->history,work->auxhist,HSTSIZ);
               (*newmsghook)(nwmtyps(nwmtyp),msg,extinf);
               stlcpy(msg->to,extinf,MAXADR);
               stlcpy(msg->history,savehist,HSTSIZ);
          }
          else {
               (*newmsghook)(nwmtyps(nwmtyp),msg,NULL);
          }
     }
     curapi=utlapi;
}

int                                /*   returns updated hook index         */
notnwml(                           /* low-level new message notification   */
int curidx,                        /*   current hook index (NOIDX == first)*/
const struct message *msg,         /*   header of new message              */
const char *text,                  /*   message text                       */
const char *appinf)                /*   app-defined info ("" if none)      */
{
     int i;

     curapi=(char *)appinf;
     *extinf='\0';
     if ((i=nexthook(GMEHOOK_NOT_NEWMSGL,curidx)) != NOIDX) {
          (*(gmehook_not_newmsgl)(gmehooks[i].hookfunc))(msg,text);
     }
     curapi=utlapi;
     return(i);
}

int                                /*   returns updated hook index         */
notnwf(                            /* handle new forum notification hooks  */
int curidx,                        /*   current hook index (NOIDX == first)*/
const struct fordsk *newdef,       /*   new forum definition structure     */
const char *desc,                  /*   descriptive text                   */
const char *echoes)                /*   pointer to array of echo addresses */
{
     int i;

     *utlapi='\0';
     *extinf='\0';
     if ((i=nexthook(GMEHOOK_NOT_NEWFOR,curidx)) != NOIDX) {
          (*(gmehook_not_newfor)(gmehooks[i].hookfunc))(newdef,desc,echoes);
     }
     return(i);
}

void
notudm(                            /* handle message update notification   */
int updtyp,                        /*   update type code                   */
struct gmework *work,              /*   work area in use                   */
struct message *msg,               /*   header of new message              */
const char *text)                  /*   message text                       */
{
     int i;

     (void)work;
     *extinf='\0';
     i=NOIDX;
     while ((i=nexthook(GMEHOOK_NOT_UPDMSG,i)) != NOIDX) {
          (*(gmehook_not_updmsg)(gmehooks[i].hookfunc))(updtyp,msg,text);
     }
}

int                                /*   returns updated hook index         */
notmdf(                            /* handle forum update notification     */
int curidx,                        /*   current hook index (NOIDX == first)*/
const struct fordef *def,          /*   forum definition structure         */
const char *desc,                  /*   descriptive text                   */
const char *echoes)                /*   pointer to array of echo addresses */
{
     int i;

     *utlapi='\0';
     *extinf='\0';
     if ((i=nexthook(GMEHOOK_NOT_UPDFOR,curidx)) != NOIDX) {
          (*(gmehook_not_updfor)(gmehooks[i].hookfunc))(def,desc,echoes);
     }
     return(i);
}

void
notdlm(                            /* handle message delete notification   */
int deltyp,                        /*   delete type code                   */
struct gmework *work,              /*   work area in use                   */
struct message *msg,               /*   header of new message              */
const char *text)                  /*   message text                       */
{
     int i;

     (void)work;
     *extinf='\0';
     i=NOIDX;
     while ((i=nexthook(GMEHOOK_NOT_DELMSG,i)) != NOIDX) {
          (*(gmehook_not_delmsg)(gmehooks[i].hookfunc))(deltyp,msg,text);
     }
}

void
notdlml(                           /* low-level message delete notification*/
unsigned forum,                    /*   forum ID                           */
long msgid)                        /*   message ID                         */
{
     int i;

     *extinf='\0';
     curapi=NULL;
     i=NOIDX;
     while ((i=nexthook(GMEHOOK_NOT_DELMSGL,i)) != NOIDX) {
          (*(gmehook_not_delmsgl)(gmehooks[i].hookfunc))(forum,msgid);
     }
     curapi=utlapi;
}

void
notdlf(                            /* handle forum delete notification     */
const struct fordsk *def,          /*   forum definition structure         */
const char *desc,                  /*   descriptive text                   */
const char *echoes)                /*   pointer to array of echo addresses */
{
     int i;

     *utlapi='\0';
     *extinf='\0';
     i=NOIDX;
     if ((i=nexthook(GMEHOOK_NOT_DELFOR,i)) != NOIDX) {
          (*(gmehook_not_delfor)(gmehooks[i].hookfunc))(def,desc,echoes);
     }
}

int                                /*   returns updated hook index         */
notdlfl(                           /* low-level forum delete notification  */
int curidx,                        /*   current hook index (NOIDX == first)*/
unsigned forum)                    /*   forum ID of deleted forum          */
{
     int i;

     *utlapi='\0';
     *extinf='\0';
     if ((i=nexthook(GMEHOOK_NOT_DELFORL,curidx)) != NOIDX) {
          (*(gmehook_not_delforl)(gmehooks[i].hookfunc))(forum);
     }
     return(i);
}

int                                /*   returns index or NOIDX if not found*/
nexthook(                          /* find next GME hook function          */
int hooktype,                      /*   of a given type                    */
int curidx)                        /*   after this index (NOIDX == first)  */
{
     int i;

     for (i=(curidx == NOIDX ? 0 : curidx+1) ; i < ngmehooks ; ++i) {
          if (gmehooks[i].hooktype == hooktype) {
               return(i);
          }
     }
     return(NOIDX);
}

char *
nwmtyps(                           /* get new message type string          */
int nwmtyp)                        /*   given new message type code        */
{
     switch (nwmtyp) {
     case NEWMSG_WRITE:
          return(WRITENOT);
     case NEWMSG_REPLY:
          return(REPLYNOT);
     case NEWMSG_IMPRT:
          return(IMPRTNOT);
     case NEWMSG_DISTR:
          return(DISTRNOT);
     case NEWMSG_CCOPY:
          return(CCOPYNOT);
     case NEWMSG_COPY:
          return(MCOPYNOT);
     case NEWMSG_FORWD:
          return(FORWDNOT);
     case NEWMSG_RTRCP:
          return(RTRCPNOT);
     }
     ASSERT(FALSE);
     return("");
}

int                                /*   returns standard GME status code   */
val2gme(                           /* convert a VAL code to status code    */
int valcode)                       /*   VAL code to convert                */
{
     switch (valcode) {
     case VALYES:
          return(GMEOK);
     case VALNO:
          return(GMEERR);
     case VALACC:
          return(GMEACC);
     case VALCRD:
          return(GMECRD);
     }
     return(GMEAGAIN);
}

BOOL
islocal(                           /* is this a valid local address        */
const char *adr)                   /*   address to check                   */
{
     int i;

     ASSERT(adr != NULL);
     if (isdlst(adr) || isforum(adr) || isexpa(adr)) {
          return(FALSE);
     }
     for (i=0 ; adr[i] != '\0' ; ++i) {
          if (i >= UIDSIZ || !isuidc(adr[i])) {
               return(FALSE);
          }
     }
     return(TRUE);
}

void
initqs(                            /* initialize a new user's quickscan    */
struct qscfg *qsc,                 /*   pointer to quickscan buffer        */
char *uid)                         /*   User-ID to initialize              */
{
     setmem(qsc,qssiz,0);
     qsc->flags=dfpref|NEWMSG;
     qsc->curfor=dftfor;
     stlcpy(qsc->userid,uid,UIDSIZ);
     isethi(qsc,add2qs(qsc,dftfor),1L);
}

struct qscfg *                     /*   pointer to quickscan data          */
othqsp(                            /* get a user's quickscan configuration */
char *uid)                         /*   User-ID to find                    */
{                                  /*   (for one-cycle use only)           */
     struct qscfg *tmpqsp;

     if ((tmpqsp=onsqsp(uid)) != NULL) {
          return(tmpqsp);
     }
     setbtv(qscbb);
     if (acqbtv(utlqsc,uid,0)) {
          rstbtv();
          return(utlqsc);
     }
     rstbtv();
     return(NULL);
}

struct qscfg *                     /*   returns NULL if not found          */
onsqsp(                            /* get online user's quickscan          */
char *uid)                         /*   given User-ID                      */
{
     int i;
     struct qscfg *tmpqsp;

     for (i=0 ; i < nterms ; ++i) {
          if (sameas(uid,(tmpqsp=uqsptr(i))->userid)) {
               return(tmpqsp);
          }
     }
     return(NULL);
}

struct qscfg *
uqsptr(                            /* get online user's quickscan          */
int unum)                          /*   given user number                  */
{
     return((struct qscfg *)ptrblok(usrqs,unum));
}

struct qscfg *
myqsptr(void)                      /* get current user's quickscan         */
{
     return((struct qscfg *)ptrblok(usrqs,usrnum));
}

int                                /*   returns standard GME status codes  */
setaxes(                           /* set access for a user                */
unsigned fid,                      /*   forum to set access for            */
char *uid,                         /*   user to set access for             */
int acc)                           /*   access to set to                   */
{
     int i,curacc;
     struct qscfg *qsc;

     ASSERT(fidxst(fid));
     ASSERT(uid != NULL);
     ASSERT(uidxst(uid));
     ASSERT(acc == NOTSET || acc <= OPAXES);
     curacc=foracc(fid);
     if (curacc < OPAXES || (acc == OPAXES && curacc < SYAXES)) {
          return(GMEACC);
     }
     curacc=gforac(uid,fid);
     if (curacc == acc) {
          return(GMEOK);
     }
     if (acc == OPAXES) {
          setfop(fid,uid);
     }
     else {
          if (curacc == OPAXES) {
               setfop(fid,usaptr->userid);
          }
          qsc=othqsp(uid);
          if (qsc == NULL) {
               qsc=utlqsc;
               initqs(qsc,uid);
          }
          if (acc == NOTSET) {
               i=qsidx(qsc,fid);
               if (i != NOIDX) {
                    if (igethi(qsc,i) == 0L) {
                         idelqs(qsc,i);
                    }
                    else {
                         isetac(qsc,i,acc);
                    }
               }
          }
          else {
               i=absadqs(qsc,fid);
               if (i == NOIDX) {
                    return(GMEMEM);
               }
               isetac(qsc,i,acc);
          }
          setbtv(qscbb);
          if (acqbtv(NULL,uid,0)) {
               upvbtv(qsc,qsrlen(qsc->nforums));
          }
          else {
               invbtv(qsc,qsrlen(qsc->nforums));
          }
          rstbtv();
     }
     return(GMEOK);
}

int                                /*   returns standard GME status codes  */
cpyaxes(                           /* copy forum access                    */
char *dstusr,                      /*   to this User-ID                    */
char *srcusr)                      /*   from this User-ID                  */
{
     int srcidx,dstidx,access;
     BOOL newguy;
     char *accarr;
     struct fmidky *fmarr;
     struct qscfg *srcqsc,*dstqsc;

     ASSERT(dstusr != NULL);
     ASSERT(srcusr != NULL);
     if (!haskey(forsys)) {
          return(GMEACC);
     }
     if ((srcqsc=othqsp(srcusr)) == NULL) {
          return(GMENSRC);
     }
     if (!uidxst(dstusr)) {
          return(GMENDST);
     }
     newguy=FALSE;
     if ((dstqsc=onsqsp(dstusr)) == NULL) {
          setbtv(qscbb);
          ASSERT(srcqsc != qsdptr);
          dstqsc=qsdptr;
          if (!acqbtv(NULL,dstusr,0)) {
               newguy=TRUE;
               initqs(dstqsc,dstusr);
          }
          rstbtv();
     }
     fmarr=(struct fmidky *)srcqsc->accmsg;
     accarr=(char *)&fmarr[srcqsc->nforums];
     for (srcidx=0 ; srcidx < srcqsc->nforums ; ++srcidx) {
          access=acclvl(accarr,srcidx);
          if (access != NOTSET) {
               dstidx=absadqs(dstqsc,fmarr[srcidx].forum);
               if (dstidx != NOIDX) {
                    isetac(dstqsc,dstidx,access);
               }
          }
     }
     if (dstqsc == qsdptr) {
          setbtv(qscbb);
          if (newguy) {
               invbtv(NULL,qsrlen(dstqsc->nforums));
          }
          else {
               upvbtv(NULL,qsrlen(dstqsc->nforums));
          }
          rstbtv();
     }
     return(GMEOK);
}

void
addhist(                           /* add to message history               */
char *history,                     /*   current history string             */
char *newhist)                     /*   string to add                      */
{
     char histbuf[HSTSIZ*2];

     stlcpy(histbuf,newhist,HSTSIZ);
     if (*history != '\0') {
          stzcat(histbuf,", ",HSTSIZ*2);
          stzcat(histbuf,history,HSTSIZ*2);
          if (strlen(histbuf) > HSTSIZ-1) {
               histbuf[HSTSIZ-2]='*';
               histbuf[HSTSIZ-1]='\0';
          }
     }
     stlcpy(history,histbuf,HSTSIZ);
}

int                                /*   returns appropriate GME work flag  */
dlstyp(                            /* get dist list type                   */
char *to)                          /*   given to address                   */
{
     ASSERT(to != NULL);
     if (!isdlst(to)) {
          return(0);
     }
     if (sameas(to,"!quick")) {
          return(QIKLST);
     }
     if (sameas(to,"!mass")) {
          return(MASSLST);
     }
     ASSERT(*to == '@');
     return(SYSLST);
}

char *                             /*   ptr to next entry (NULL if done)   */
parscc(                            /* parse next cc: from list             */
char *addr,                        /*   buffer to put cc: address into     */
char *list)                        /*   ';'-delimited cc: list             */
{
     char *cp;
     unsigned size;

     cp=strchr(list,';');
     if (cp == NULL) {
          stlcpy(addr,skpwht(list),MAXADR);
          unpad(addr);
     }
     else {
          ++cp;
          list=skpwht(list);
          size=(unsigned)(cp-list);
          size=min(size,MAXADR);
          stlcpy(addr,list,size);
          unpad(addr);
     }
     return(cp);
}

long
newmid(void)                       /* generate a new message ID            */
{
     ++sv.msgtot;
     return(++_highmsg);
}

BOOL                               /*   returns FALSE if couldn't open     */
opn4cpy(                           /* open files for copy                  */
struct gmework *work,              /*   work area to open files for        */
char *srcfil)                      /*   source file name                   */
{                                  /*   (work->cpyatt is always dest)      */
     ASSERT(work != NULL);
     ASSERT(srcfil != NULL);
     if (*work->cpyatt == '\0') {
          return(FALSE);
     }
     work->fp=fopen(srcfil,FOPRB);
     if (work->fp == NULL) {
          cantopen(srcfil,FALSE);
          return(FALSE);
     }
     work->fpout=fopen(work->cpyatt,FOPWB);
     if (work->fpout == NULL) {
          fclose(work->fp);
          cantopen(work->cpyatt,TRUE);
          return(FALSE);
     }
     fnd1st(&gmefb,srcfil,0);
     work->cfdate=gmefb.date;
     work->cftime=gmefb.time;
     return(TRUE);
}

int                                /*   returns standard GME status codes  */
copychunk(                         /* cycled file copy utility             */
struct gmework *work)              /*   work area in use                   */
{
     int i;
     int siz;

     for (i=0 ; i < CNKPCYC ; ++i) {
          if ((siz=(int)fread(tmpbuf,1,TMPBSZ,work->fp)) > 0) {
               fwrite(tmpbuf,1,siz,work->fpout);
          }
          if (ferror(work->fpout) || ferror(work->fp)) {
               fclose(work->fp);
               work->fp=NULL;
               fclose(work->fpout);
               work->fpout=NULL;
               unlink(work->cpyatt);
               return(GMENOAT);
          }
          if (feof(work->fp)) {
               fclose(work->fp);
               work->fp=NULL;
               fclose(work->fpout);
               work->fpout=NULL;
               setdtd(work->cpyatt,work->cftime,work->cfdate);
               return(GMEOK);
          }
     }
     return(GMEAGAIN);
}

char *                             /*   returns NULL if doesn't exist      */
getfnm(                            /* get forum name                       */
unsigned fid)                      /*   given forum ID                     */
{
     struct fordef *tmpdef;
     static char tmpnam[FORNSZ];

     if (fid == EMLID || (tmpdef=getdef(fid)) == NULL) {
          return(NULL);
     }
     return(stlcpy(tmpnam,tmpdef->name,FORNSZ));
}

char *                             /*   returns NULL if doesn't exist      */
getftpc(                           /* get forum topic                      */
unsigned fid)                      /*   given forum ID                     */
{
     struct fordef *tmpdef;
     static char tmptpc[TPCSIZ];

     if (fid == EMLID || (tmpdef=getdef(fid)) == NULL) {
          return(NULL);
     }
     return(stlcpy(tmptpc,tmpdef->topic,TPCSIZ));
}

BOOL                               /*   TRUE if access > NOAXES            */
faccok(                            /* current user has access to Forum?    */
unsigned forum)                    /*   forum ID to get topic for          */
{
     struct qscfg *tmpqsp;

     tmpqsp=uqsptr(usrnum);
     if (*tmpqsp->userid != '\0') {
          return(qforac(tmpqsp,forum) > NOAXES);
     }
     return(FALSE);
}

int                                /*   returns standard GME status codes  */
inidist(                           /* initialize sending a dist list       */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg)               /*   new message structure              */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     ASSERT(isdlst(msg->to));
     stlcpy(work->dlstnam,msg->to,DLNMSZ);
     work->flags|=dlstyp(msg->to);
     switch (work->flags&(QIKLST|MASSLST|SYSLST)) {
     case QIKLST:
          if (!iniqksnd(work,msg->from)) {
               return(GMEMEM);
          }
          break;
     case MASSLST:
          if (!inimssnd(work)) {
               return(GMEERR);
          }
          break;
     case SYSLST:
          if (!inislsnd(work,msg->to)) {
               return(GMEERR);
          }
          break;
     default:
          ASSERT(FALSE);
     }
     return(GMEOK);
}

BOOL                               /*   returns TRUE there was another     */
nxtdist(                           /* get next entry in dist list          */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg)               /*   message header structure           */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(msg != NULL);
     switch (work->flags&(QIKLST|MASSLST|SYSLST)) {
     case QIKLST:
          return(nxtqik(work,msg->to));
     case MASSLST:
          return(nxtmass(work,msg->to));
     case SYSLST:
          return(nxtsys(work,msg->to));
     default:
          ASSERT(FALSE);
     }
     return(FALSE);
}

void
clsdist(                           /* finish up distribution               */
struct gmework *work)              /*   GME work space (provided by caller)*/
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     switch (work->flags&(QIKLST|MASSLST|SYSLST)) {
     case QIKLST:
          clsqik(work);
          break;
     case MASSLST:
          clsmass(work);
          break;
     case SYSLST:
          clssys(work);
          break;
     default:
          ASSERT(FALSE);
     }
}

BOOL                               /*   returns TRUE if started OK         */
inimssnd(                          /* start up !MASS dist                  */
struct gmework *work)              /*   work area to initialize            */
{
     setbtv(accbb);
     work->d.m.fpos=0L;
     work->d.m.more=qlobtv(0);
     if (work->d.m.more) {
          work->d.m.fpos=absbtv();
     }
     rstbtv();
     return(work->d.m.more);
}

BOOL                               /*   returns TRUE if started OK         */
nxtmass(                           /* get next !MASS entry                 */
struct gmework *work,              /*   work area to use                   */
char *addr)                        /*   buffer for address                 */
{
     struct usracc *tmpacc;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     ASSERT(work->d.m.fpos != 0L);
     setbtv(accbb);
     if (!work->d.m.more
      || !aabbtv(NULL,work->d.m.fpos,0)) {
          rstbtv();
          return(FALSE);
     }
     tmpacc=(struct usracc *)(accbb->data);
     while (tmpacc->flags&DELTAG) {
          if (!qnxbtv()) {
               rstbtv();
               return(FALSE);
          }
     }
     stlcpy(addr,tmpacc->userid,UIDSIZ);
     work->d.m.more=qnxbtv();
     if (work->d.m.more) {
          work->d.m.fpos=absbtv();
     }
     rstbtv();
     return(TRUE);
}

void
clsmass(                           /* shut down !MASS distribution         */
struct gmework *work)              /*   work area used                     */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     work->d.m.fpos=0L;
     work->d.m.more=FALSE;
}

void
inilosl(void)                      /* initialize list of sysop lists       */
{
     int tmpchg;
     char tmpnam[DLNMSZ];
     char tmpkey[KEYSIZ];
     char *cp;
     FILE *fp;
     struct fndblk fb;

     ASSERT(losl == NULL);
     numsl=0;
     if (fnd1st(&fb,dlstpfn("@*"),0)) {
          do {
               tmpnam[0]='@';
               stlcpy(&tmpnam[1],fb.name,DLNMSZ-1);
               cp=strchr(tmpnam,'.');
               if (cp != NULL) {
                    *cp='\0';
               }
               fp=opndlst(tmpnam,FOPRA);
               if (fp != NULL) {
                    if (rdlstinf(fp,tmpkey,&tmpchg)) {
                         if (!add2losl(tmpnam,tmpkey,tmpchg)) {
                              memcata();
                         }
                    }
                    fclose(fp);
               }
          } while (fndnxt(&fb));
     }
}

BOOL                               /*   returns TRUE if added              */
add2losl(                          /* add to list of sysop dist lists      */
char *lstnam,                      /*   list name                          */
char *lstkey,                      /*   list key                           */
int lstchg)                        /*   list surcharge                     */
{
     int i;

     for (i=0 ; i < numsl && stricmp(losl[i].name,lstnam) < 0 ; ++i) {
     }
     if (i < numsl && sameas(losl[i].name,lstnam)) {
          return(FALSE);
     }
     if (alcarr((void **)&losl,sizeof(struct slinfo),numsl,SMLBLK)) {
          if (i < numsl) {
               movmem(&losl[i],&losl[i+1],(numsl-i)*sizeof(struct slinfo));
          }
          stlcpy(losl[i].name,lstnam,DLNMSZ);
          stlcpy(losl[i].key,lstkey,KEYSIZ);
          losl[i].surchg=lstchg;
          ++numsl;
          return(TRUE);
     }
     return(FALSE);
}

int                                /*   returns standard GME status codes  */
nxtslst(                           /* get name of next sysop dist list     */
char *lstnam,                      /*   buffer for list name               */
char *lstkey,                      /*   buffer for list key                */
int *surchg)                       /*   buffer for list surcharge          */
{
     int i;

     ASSERT(lstnam != NULL);
     ASSERT(lstkey != NULL);
     ASSERT(surchg != NULL);
     for (i=0 ; i < numsl ; i++) {
          if (strcmpi(losl[i].name,lstnam) > 0) {
               stlcpy(lstnam,losl[i].name,DLNMSZ);
               stlcpy(lstkey,losl[i].key,KEYSIZ);
               *surchg=losl[i].surchg;
               return(GMEOK);
          }
     }
     return(GMENFND);
}

int                                /*   returns standard GME status codes  */
getslst(                           /* get info about sysop list            */
char *lstnam,                      /*   list name                          */
char *lstkey,                      /*   buffer for list key                */
int *surchg)                       /*   buffer for list surcharge          */
{
     int i;

     ASSERT(lstnam != NULL);
     ASSERT(lstkey != NULL);
     ASSERT(surchg != NULL);
     for (i=0 ; i < numsl ; i++) {
          if (sameas(losl[i].name,lstnam)) {
               stlcpy(lstkey,losl[i].key,KEYSIZ);
               *surchg=losl[i].surchg;
               return(GMEOK);
          }
     }
     return(GMENFND);
}

int                                /*   returns standard GME status codes  */
newslst(                           /* create a new sysop distribution list */
void *workb,                       /*   GME work space                     */
char *lstnam,                      /*   name for new list                  */
char *lstkey,                      /*   key required to use list           */
int surchg)                        /*   surcharge to use list              */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     if (!haskey(edstky)) {
          clsgmerq(work);
          return(GMEACC);
     }
     if (lstnam[0] != '@') {
          clsgmerq(work);
          return(GMEERR);
     }
     if (dlstxst(lstnam)) {
          clsgmerq(work);
          return(GMEDUP);
     }
     work->d.s.fp=opndlst(lstnam,FOPWRA);
     if (work->d.s.fp == NULL) {
          clsgmerq(work);
          return(GMEUSE);
     }
     if (!add2losl(lstnam,lstkey,surchg)) {
          fclose(work->d.s.fp);
          clsgmerq(work);
          return(GMEMEM);
     }
     work->flags|=SYSLST;
     fprintf(work->d.s.fp,"%s%s\n",DLKRQS,lstkey);
     fprintf(work->d.s.fp,DLCHGS,surchg);
     work->d.s.fpos=ftell(work->d.s.fp);
     work->fpos=work->d.s.fpos;
     return(GMEOK);
}

int                                /*   returns standard GME status codes  */
delslst(                           /* delete a sysop dist list             */
char *lstnam)                      /*   name of list                       */
{
     int i;
     FILE *fp;

     if (!haskey(edstky)) {
          return(GMEACC);
     }
     if (lstnam[0] != '@') {
          return(GMEERR);
     }
     i=dlstidx(lstnam);
     if (i == NOIDX) {
          return(GMENFND);
     }
     if ((fp=opndlst(lstnam,FOPRWA)) == NULL) {
          return(GMEUSE);
     }
     fclose(fp);
     unlink(dlstpfn(lstnam));
     --numsl;
     if (i < numsl) {
          movmem(&losl[i+1],&losl[i],sizeof(struct slinfo)*(numsl-i));
     }
     return(GMEOK);
}

int                                /*   returns standard GME status codes  */
edtslst(                           /* open a sysop dist list for editing   */
void *workb,                       /*   work area to initialize            */
char *lstnam)                      /*   name of list                       */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     if (!haskey(edstky)) {
          clsgmerq(work);
          return(GMEACC);
     }
     if (lstnam[0] != '@') {
          clsgmerq(work);
          return(GMEERR);
     }
     if (!dlstxst(lstnam)) {
          clsgmerq(work);
          return(GMENFND);
     }
     work->d.s.fp=opndlst(lstnam,FOPRWA);
     if (work->d.s.fp == NULL) {
          clsgmerq(work);
          return(GMEUSE);
     }
     if (!rdlstinf(work->d.s.fp,tmpbuf,tmpbuf)) {
          fclose(work->d.s.fp);
          work->d.s.fp=NULL;
          clsgmerq(work);
          return(GMEERR);
     }
     work->flags|=SYSLST;
     work->d.s.fpos=ftell(work->d.s.fp);
     work->fpos=work->d.s.fpos;
     return(GMEOK);
}

int                                /*   returns standard GME status codes  */
addslst(                           /* add an address to a sysop list       */
void *workb,                       /*   GME work space                     */
char *addr)                        /*   address to add to list             */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     if (!(work->flags&SYSLST) || work->d.s.fp == NULL) {
          return(GMEERR);
     }
     fseek(work->d.s.fp,0L,SEEK_END);
     fprintf(work->d.s.fp,"%s\n",addr);
     return(GMEOK);
}

int                                /*   returns standard GME status codes  */
rstlstp(                           /* set sysop list pointer to top of list*/
void *workb)                       /*   GME work space                     */
{
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     if (!(work->flags&SYSLST) || work->d.s.fp == NULL) {
          return(GMEERR);
     }
     work->d.s.fpos=work->fpos;
     return(GMEOK);
}

char *                             /*   returns pointer to temporary buffer*/
udlnam(void)                       /* path & file name to upload new list  */
{
     return(spr("%s\\%s",dlstpth,tmpanam(NULL)));
}

int                                /*   returns standard GME status codes  */
setslst(                           /* import file to replace existing list */
char *lstnam,                      /*   name for new list                  */
char *lstfil)                      /*   file containing new list           */
{
     int i,tmpchg;
     char *cp,tmpkey[KEYSIZ];
     FILE *fp;

     ASSERT(lstnam != NULL);
     ASSERT(lstfil != NULL);
     ASSERT(sameto(normspec(tmpbuf,dlstpth),
                   normspec((char *)tmpbuf+MAXPATH,lstfil)));
     if (!haskey(edstky)) {
          return(GMEACC);
     }
     if (lstnam[0] != '@') {
          return(GMEERR);
     }
     if (!dlstxst(lstnam)) {
          return(GMENFND);
     }
     fp=opndlst(lstnam,FOPRWA);
     if (fp == NULL) {
          return(GMEUSE);
     }
     fclose(fp);
     fp=fopen(lstfil,FOPRA);
     if (fp == NULL) {
          return(GMEERR);
     }
     if (!rdlstinf(fp,tmpkey,&tmpchg)) {
          fclose(fp);
          return(GMEERR);
     }
     fclose(fp);
     i=dlstidx(lstnam);
     ASSERT(i != NOIDX);
     stlcpy(losl[i].key,tmpkey,KEYSIZ);
     losl[i].surchg=tmpchg;
     cp=dlstpfn(lstnam);
     if (unlink(cp) != 0 || rename(lstfil,cp) != 0) {
          return(GMEERR);
     }
     return(GMEOK);
}

BOOL                               /*   returns TRUE if successful         */
rdlstinf(                          /* return key/charge info from list file*/
FILE *fp,                          /*   stream to read from                */
char *tmpkey,                      /*   key buffer                         */
int *tmpchg)                       /*   charge buffer                      */
{
     char *cp;

     fgets((char *)tmpbuf,TMPBSZ,fp);
     if (sameto(DLKRQS,(char *)tmpbuf) && fscanf(fp,DLCHGS,tmpchg) == 1) {
          cp=unpad(skpwht(&((char *)tmpbuf)[sizeof(DLKRQS)-1]));
          stlcpy(tmpkey,cp,KEYSIZ);
          return(TRUE);
     }
     return(FALSE);
}

BOOL                               /*   returns TRUE if started OK         */
inislsnd(                          /* start up sysop list dist             */
struct gmework *work,              /*   work area to initialize            */
char *lstnam)                      /*   name of list                       */
{
     int dummy;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     if (lstnam[0] != '@' || !dlstxst(lstnam)
      || (work->d.s.fp=opndlst(lstnam,FOPRA)) == NULL) {
          return(FALSE);
     }
     fgets((char *)tmpbuf,TMPBSZ,work->d.s.fp);
     if (!sameto(DLKRQS,(char *)tmpbuf)) {
          fclose(work->d.s.fp);
          work->d.s.fp=NULL;
          return(FALSE);
     }
     if (fscanf(work->d.s.fp,DLCHGS,&dummy) != 1) {
          fclose(work->d.s.fp);
          work->d.s.fp=NULL;
          return(FALSE);
     }
     work->d.s.fpos=ftell(work->d.s.fp);
     return(TRUE);
}

BOOL
nxtsys(                            /* get next entry in sysop list         */
void *workb,                       /*   work area to use                   */
char *addr)                        /*   new message header                 */
{
     unsigned l;
     struct gmework *work=(struct gmework *)workb;

     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     fseek(work->d.s.fp,work->d.s.fpos,SEEK_SET);
     if (fgets((char *)tmpbuf,TMPBSZ,work->d.s.fp) != NULL) {
          work->d.s.fpos=ftell(work->d.s.fp);
          l=strlen((char *)tmpbuf);
          if (((char *)tmpbuf)[l-1] == '\n') {
               ((char *)tmpbuf)[l-1]='\0';
          }
          stlcpy(addr,(char *)tmpbuf,MAXADR);
          return(TRUE);
     }
     return(FALSE);
}

void
clssys(                            /* close sysop distribution list        */
struct gmework *work)              /*   work area in use                   */
{
     ASSERT(work != NULL);
     ASSERT(gmerqopn(work));
     if (work->d.s.fp != NULL) {
          fclose(work->d.s.fp);
          work->d.s.fp=NULL;
     }
}

BOOL
dlstxst(                           /* does dist list exist?                */
char *name)                        /*   complete list name (incl @ or !)   */
{
     ASSERT(name != NULL);
     if (*name == '!') {
          return(sameas(name,"!quick") || sameas(name,"!mass"));
     }
     else {
          if (valslnm(name)) {
               return(dlstidx(name) != NOIDX);
          }
     }
     return(FALSE);
}

int
dlstidx(                           /* get index of list in list of lists   */
char *name)                        /*   sysop list name                    */
{
     int i;

     ASSERT(name != NULL);
     ASSERT(name[0] == '@');
     for (i=0 ; i < numsl ; ++i) {
          if (sameas(losl[i].name,name)) {
               return(i);
          }
     }
     return(NOIDX);
}

FILE *                             /*   returns file pointer               */
opndlst(                           /* open a sysop dist list file          */
char *name,                        /*   complete name (including @)        */
char *mode)                        /*   open mode to use                   */
{
     int handle,access,shflag,smode;
     FILE *fp;

     if (sameas(mode,FOPRA)) {
          access=O_RDONLY|O_TEXT;
          shflag=SH_DENYNO;
          smode=0;
     }
     else if (sameas(mode,FOPRWA)) {
          access=O_RDWR|O_TEXT;
          shflag=SH_DENYWR;
          smode=0;
     }
     else if (sameas(mode,FOPWRA)) {
          access=O_RDWR|O_TEXT|O_CREAT|O_TRUNC;
          shflag=SH_DENYWR;
          smode=S_IREAD|S_IWRITE;
     }
     else {
          ASSERT(FALSE);
     }
     fp=NULL;
     handle=sopen(dlstpfn(name),access,shflag,smode);
     if (handle != -1) {
          fp=fdopen(handle,mode);
          if (fp == NULL) {
               close(handle);
          }
     }
     return(fp);
}

int                                /*   returns standard GME status codes  */
slstfil(                           /* get info about sysop list            */
char *lstnam,                      /*   list name                          */
char *lstpath)                     /*   buffer for list path & file name   */
{
     if (haskey(edstky)) {
          if (dlstxst(lstnam)) {
               stlcpy(lstpath,dlstpfn(lstnam),MAXPATH);
               return(GMEOK);
          }
          return(GMENFND);
     }
     return(GMEACC);
}

char *                             /*   returns pointer to path & file name*/
dlstpfn(                           /* get path & file name of dist list    */
char *name)                        /*   complete name (including @)        */
{
     ASSERT(name != NULL);
     ASSERT(*name == '@');
     return(spr("%s\\%s.DIS",dlstpth,name+1));
}

void
cantopen(                          /* audit failed file open               */
char *fname,                       /*   file that couldn't be opened       */
BOOL waswrt)                       /*   was the open for write             */
{
     if (waswrt) {
          shocst("GME FILE OPEN ERROR","unable to open \"%s\" for write",fname);
     }
     else {
          shocst("GME FILE OPEN ERROR","unable to open \"%s\" for read",fname);
     }
}

/* simple send functions */

STATIC void
inisimp(void)                      /* init simple send stuff               */
{
     FILE *fvir,*fdat;
     unsigned siz;

     fvir=fopen("GALSSC.VIR",FOPRB);
     if (fvir == NULL) {
          catastro("Unable to open simple-send cache: GALSSC.VIR");
     }
     fdat=fopen("GALSSC.DAT",FOPWB);
     if (fdat == NULL) {
          fclose(fvir);
          catastro("Unable to open simple-send cache: GALSSC.DAT");
     }
     while (!feof(fvir)) {
          if ((siz=fread(utltxt,1,TXTLEN,fvir)) <= TXTLEN) {
               if (siz > 0) {
                    fwrite(utltxt,1,siz,fdat);
               }
          }
          else {
               fclose(fvir);
               fclose(fdat);
               catastro("Error reading virgin simple-send cache: GALSSC.VIR");
          }
          if (ferror(fdat) || ferror(fvir)) {
               fclose(fvir);
               fclose(fdat);
               catastro("Error resetting simple-send cache: GALSSC.DAT");
          }
     }
     fclose(fvir);
     fclose(fdat);
     sscbb=opnbtv("GALSSC.DAT",sizeof(struct sscache)+TXTLEN-1);
     ssbuf=(struct sscache *)alcmem(sizeof(struct sscache)+TXTLEN-1);
}

STATIC void
clssimp(void)                      /* close simple send stuff              */
{
     if (ssiuflg) {
          while (gsndmsg(ssbuf->work,&ssbuf->msg,ssbuf->text,ssbuf->attspc)
              == GMEAGAIN) {
          }
     }
     setbtv(sscbb);
     while (alobtv(ssbuf,0)) {
          delbtv();
          while (gsndmsg(ssbuf->work,&ssbuf->msg,ssbuf->text,ssbuf->attspc)
             == GMEAGAIN) {
          }
          setbtv(sscbb);
     }
     if (sscbb != NULL) {
          clsbtv(sscbb);
          sscbb=NULL;
     }
}

int                                /*   returns standard GME status codes  */
simpsnd(                           /* simple send msg (non-user specific)  */
struct message *msg,               /*   message header structure           */
char *text,                        /*   message body text                  */
char *filatt)                      /*   path+file name of att (if any)     */
{
     int rc;

     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     inigmerq(utlwork);
     rc=gsndmsg(utlwork,msg,text,filatt);
     if (rc == GMEAGAIN) {
          if (ssiuflg) {
               setbtv(sscbb);
               cpy2cache((struct sscache *)(sscbb->data),utlwork,msg,text,filatt);
               invbtv(NULL,sizeof(struct sscache)+strlen(text));
               rstbtv();
          }
          else {
               cpy2cache(ssbuf,utlwork,msg,text,filatt);
               ssiuflg=TRUE;
               sstskid=initask(sndtask);
          }
          setmem(utlwork,sizeof(struct gmework),0);
     }
     return(rc);
}

STATIC void
cpy2cache(                         /* copy message info to cache buffer    */
struct sscache *cache,             /*   cache buffer                       */
struct gmework *work,              /*   work area                          */
struct message *msg,               /*   message header                     */
char *text,                        /*   text buffer                        */
char *filatt)                      /*   file attachment path+file name     */
{
     ASSERT(cache != NULL);
     ASSERT(work != NULL);
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(!(msg->flags&FILATT) || filatt != NULL);
     movmem(work,cache->work,sizeof(struct gmework));
     movmem(msg,&cache->msg,sizeof(struct message));
     stlcpy(cache->text,text,TXTLEN);
     if (msg->flags&FILATT) {
          stlcpy(cache->attspc,filatt,MAXPATH);
     }
     else {
          *cache->attspc='\0';
     }
}

STATIC void
sndtask(                           /* background send handler              */
int taskid)                        /*   task ID (from initask)             */
{
     ASSERT(taskid == sstskid);
     ASSERT(ssbuf != NULL);
     (void)taskid;
     if (gsndmsg(ssbuf->work,&ssbuf->msg,ssbuf->text,ssbuf->attspc)
      != GMEAGAIN) {
          setbtv(sscbb);
          if (alobtv(ssbuf,0)) {
               delbtv();
          }
          else {
               ssiuflg=FALSE;
               mfytask(sstskid,NULL);
          }
          rstbtv();
     }
}

/* backward-compatibility functions */

BOOL                               /*   returns TRUE if successful         */
_oldsend(                          /* backward-compatible to 6.X sendmsg() */
struct oldmsg *msg,                /*   6.X message structure              */
char *to)                          /*   destination address                */
{
     BOOL rc;
     char tmpatt[MAXPATH];

     ASSERT(msg != NULL);
     rc=FALSE;
     if (old2new(to,msg,utlmsg,utltxt,tmpatt)) {
          rc=(simpsnd(utlmsg,utltxt,tmpatt) >= GMEAGAIN);
     }
     return(rc);
}

STATIC BOOL                        /*   returns TRUE if old message is OK  */
old2new(                           /* copy old message format to new format*/
char *to,                          /*   destination for message            */
struct oldmsg *old,                /*   old message structure              */
struct message *msg,               /*   new message header buffer          */
char *text,                        /*   new message text buffer            */
char *filatt)                      /*   new attachment path+file name buf  */
{
     char *tmps;
     FILE *fp;

     ASSERT(old != NULL);
     ASSERT(msg != NULL);
     ASSERT(text != NULL);
     ASSERT(!(msg->flags&FILATT) || filatt != NULL);
     if (to == NULL || *to == '\0') {
          to=old->to;
     }
     msg->forum=EMLID;
     if (*to == FORIDC) {
          msg->forum=getfid(to+1);
          if (msg->forum == EMLID) {
               return(FALSE);
          }
          to=old->userto;
     }
     stlcpy(msg->to,to,MAXADR);
     if (old->flags&FILATT) {
          tmps=_oldafs(old);
          if (old->flags&FILIND) {
               fp=fopen(tmps,FOPRA);
               if (fp == NULL) {
                    return(FALSE);
               }
               fgets(filatt,MAXPATH,fp);
               fclose(fp);
               unlink(tmps);
          }
          else {
               if (!fnd1st(&gmefb,tmps,0)) {
                    return(FALSE);
               }
               stlcpy(filatt,tmps,MAXPATH);
          }
          tmps=tpcfnm(old->topic);
          if (tmps != NULL) {
               stlcpy(msg->attname,tmps,FLNSIZ);
          }
          else {
               stlcpy(msg->attname,_oldafn(old)+1,FLNSIZ);
          }
     }
     msg->thrid=0L;
     stlcpy(msg->from,old->from,UIDSIZ);
     stlcpy(msg->topic,old->topic,TPCSIZ);
     stlcpy(msg->history,old->auxtpc,HSTSIZ);
     msg->flags=(long)old->flags&(EXEMPT|RECREQ|FILIND|FILATT|FILAPV);
     if (old->flags&(int)NODEL) {  /* old ISRETR flag */
          msg->flags|=(NODEL|NOMOD);
     }
     stlcpy(text,old->text,TXTLEN);
     return(TRUE);
}

char *                             /*   pointer to filespec                */
_oldafs(                           /* backward-compatible attachment fspec */
struct oldmsg *msg)                /*   old message structure              */
{
     static char filespec[MAXPATH];

     strcpy(filespec,msg->to[0] == FORIDC ? msg->to+1 : "EMAIL");
     strcat(filespec,_oldafn(msg));
     return(filespec);
}

STATIC char *                      /*   pointer to file name               */
_oldafn(                           /* backward-compatible attachment name  */
struct oldmsg *msg)                /*   old message structure              */
{
     char *fnp;
     int fnplen;

     fnp=spr("\\%ld.ATT",msg->msgno);
     while ((fnplen=strlen(fnp)) >= 14) {    /* ensures over 2 billion     */
          fnp[fnplen-2]=fnp[fnplen-1];       /*   unique filenames         */
          fnp[fnplen-1]=fnp[1];
          movmem(fnp+2,fnp+1,strlen(fnp+1));
     }
     return(fnp);
}

char *                             /*   returns NULL if none               */
tpcfnm(                            /* extract file name from topic         */
char *tpc)                         /*   topic string                       */
{
     static char fname[FLNSIZ];
     char *cp;
     int i;

     cp=tpc;
     for (i=0 ; *cp != '\0' && *cp != '.' && !isspace(*cp) ; cp++,i++) {
     }
     if (i < 1 || i > 8 || *cp != '.') {
          return(NULL);
     }
     cp++;
     for (i=0 ; *cp != '\0' && *cp != '.' && !isspace(*cp) ; cp++,i++) {
     }
     if (i > 3 || *cp == '.') {
          return(NULL);
     }
     stlcpy(fname,tpc,(int)(cp-tpc+1));
     strupr(fname);
     return(valfnm(fname) ? fname : NULL);
}

