/***************************************************************************
 *                                                                         *
 *   GMELOC.H                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Galacticomm Messaging Engine local message base manager's *
 *   exported variables, functions, etc.  THESE RESOURCES SHOULD ONLY BE   *
 *   USED BY INTERNAL GME FILES.                                           *
 *                                                                         *
 *                                            - J. Alvrus   6/5/94         *
 *                                                                         *
 ***************************************************************************/

#define TMPBSZ 1024                /* size of temporary buffer             */

#define DFDFNPV RDAXES             /* default default non-privileged access*/
#define DFDFPRV ULAXES             /* default default privileged access    */
#define DFMXNPV COAXES             /* default maximum non-privileged access*/

                                   /* GME Btrieve file keys                */
#define ETOMKY 0                   /*   E-mail: to + message ID key        */
#define EFRMKY 1                   /*   E-mail: from + message ID key      */
#define ETIDKY 2                   /*   E-mail: thread ID key              */
#define EMIDKY 3                   /*   E-mail: message ID key             */
#define FFMKY  0                   /*   forum: forum ID + message ID key   */
#define FFTKY  1                   /*   forum: forum ID + thread ID key    */
#define FGIDKY 2                   /*   forum: global ID key               */
#define DIDKY  0                   /*   forum def: forum ID key            */
#define DNMKY  1                   /*   forum def: forum name key          */

struct umidky {                    /* User-ID/msgID composite key          */
     char usrid[UIDSIZ];
     long msgid;
};

struct etidky {                    /* E-mail threadID/msgID composite key  */
     long thrid;
     long msgid;
};

struct ftidky {                    /* forumID/threadID/msgID composite key */
     unsigned forum;
     long thrid;
     long msgid;
};

#ifdef DEBUG
#define NVMSGSZ 250                /* size of non-variable part of msg rec */
#endif
struct msgdsk {                    /* on-disk message structure            */
     unsigned forum;               /*   ID of forum message belongs to     */
     long msgid;                   /*   unique message identifier          */
     struct globid gmid;           /*   unique global message identifier   */
     long thrid;                   /*   ID of thread message is part of    */
     char from[UIDSIZ];            /*   originator                         */
     char to[UIDSIZ];              /*   recipient                          */
     char topic[TPCSIZ];           /*   main topic, editable, carried over */
     char history[HSTSIZ];         /*   history/routing (reply to #88888,  */
                                   /*     fw by Aaaaaaaaa, cc: of #99999)  */
     char attname[FLNSIZ];         /*   attached file name                 */
     unsigned crdate;              /*   message creation date              */
     unsigned crtime;              /*   message creation time of day       */
     struct globid rplto;          /*   message that this is a reply to    */
     int nrpl;                     /*   number of times replied to         */
     long flags;                   /*   message/attachment flag bits       */
     char spare[27];               /*   spare space, decrease when adding  */
     char info[sizeof(struct fmidky)];  /* variable-length message         */
                                   /*   text/address/pointer region        */
};

extern
long _highmsg;                     /* highest message number on system     */

extern
int nfdf;                          /* number of forum data files           */
extern
int maxfdf;                        /* max forum data files allowed by Sysop*/
extern
BTVFILE **fdfarr;                  /* forum data file array                */

extern
BOOL bgcipg;                       /* is background cleanup in progress?   */
extern
BTVFILE *qscbb,                    /* user quickscan data file             */
        *qikbb;                    /* user !QUICK list data file           */
extern
void *tmpbuf,                      /* temporary buffer, one-cycle use only */
     *usrqs;                       /* head of per-user quickscan array     */
extern
char *emldp;                       /* E-mail data file path and file name  */
extern
struct qscfg *utlqsc;              /* GME utility quickscan buffer         */
extern
char *utlapi;                      /* GME utility app-defined info buffer  */
extern
struct fndblk gmefb;               /* for finding files (one-shot only)    */

#define qkdptr ((struct qikdat *)(qikbb->data))/* !QUICK btvfile data      */
#define qsdptr ((struct qscfg *)(qscbb->data))/* quickscan file buffer ptr */
#define qsoffln(qsc) ((qsc) == utlqsc)

void
iniloc(void);                      /* initialize GME local message base    */

void
clsloc(                            /* close GME local message base         */
BOOL updfors);                     /*   update all the Forums on disk?     */

struct fordef *                    /*   returns NULL if doesn't exist      */
getdef(                            /* get pointer to forum definition      */
unsigned fid);                     /*   given forum ID                     */

struct fordef *                    /*   returns NULL if doesn't exist      */
idxdef(                            /* get pointer to forum definition      */
int idx);                          /*   given def array index              */

struct fordef *                    /*   returns NULL if doesn't exist      */
fiddef(                            /* get pointer to forum definition      */
int idx);                          /*   given xrf array index              */

struct fordef *                    /*   returns NULL if doesn't exist      */
seqdef(                            /* get pointer to forum definition      */
unsigned seqid);                   /*   given sequence ID                  */

int                                /*   (returns NOIDX if not found)       */
prvfnmi(                           /* get index of prev forum in def array */
char *name);                       /*   base forum name                    */

int                                /*   (returns NOIDX if not found)       */
nxtfnmi(                           /* get index of next forum in def array */
char *name);                       /*   after this forum name              */

void
cleandlf(void);                    /* removes all traces of deleted forums */

void
cleandla(                          /* clean up after a deleted account     */
char *userid);                     /*   account to clean up after          */

void
cpymdef(                           /* copy modifyable part of in-memory def*/
struct fordef *dest,               /*   destination definition             */
struct fordef *src);               /*   source definition                  */

char *                             /*   returns pointer to path string     */
attpfn(                            /* attachment path+file name            */
unsigned fid,                      /*   for specified forum                */
long mid);                         /*   and message number                 */

char *                             /*   pointer to static name buffer      */
attnam(                            /* attachment name                      */
long mid);                         /*   given message number               */

char *                             /*   returns pointer to path string     */
attpth(                            /* attachment path                      */
unsigned fid);                     /*   for specified forum                */

BOOL
needbgc(void);                     /* do we need to do background cleanup? */

BOOL                               /*   keep pumping?                      */
pumpcup(void);                     /* pump the normal cleanup process      */

void
gmeclean(                          /* do full GME cleanup                  */
BOOL crashed);                     /*   have we crashed some time today?   */

BOOL                               /*   returns TRUE if started OK         */
iniqksnd(                          /* start up !QUICK distribution         */
struct gmework *work,              /*   work area to initialize            */
char *userid);                     /*   user ID to use                     */

BOOL                               /*   returns TRUE if started OK         */
nxtqik(                            /* get next !QUICK entry                */
struct gmework *work,              /*   work area to use                   */
char *addr);                       /*   buffer for address                 */

void
clsqik(                            /* shut down !QUICK dist                */
struct gmework *work);             /*   work area used                     */

void
setfop(                            /* set the forum-op                     */
unsigned fid,                      /*   for this forum                     */
char *uid);                        /*   to this user                       */

int                                /*   returns index of data file in array*/
opnfdf(                            /* open forum data file & add to array  */
char *name);                       /*   path and file name of data file    */

BOOL                               /*   return TRUE if file created        */
creatfdf(                          /* create a new forum data file         */
char *name);                       /*   name of new forum data file        */

BOOL
fdfisopn(                          /* is forum data file already open?     */
char *name);                       /*   path+name of forum data file       */

char *                             /*   returns pointer to description     */
gme1fdsc(                          /* get forum description                */
unsigned fid);                     /*   given forum ID                     */

void
gme1afi(                           /* get all forum info                   */
unsigned forum,                    /*   forum ID to get                    */
struct fordsk *workdef,            /*   on-disk forum definition format    */
char *desc,                        /*   buffer for description             */
char *echoes);                     /*   buffer for echoes                  */

int                                /*   returns standard GME status codes  */
recfdf(                            /* recommend a forum data file          */
struct gmework *work,              /*   GME work space (provided by caller)*/
char *recname);                    /*   buffer for recommended name        */

int                                /*   returns standard GME status codes  */
gme1crf(                           /* create a new forum                   */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct fordsk *newdef,             /*   new forum definition structure     */
char *desc,                        /*   descriptive text                   */
char *echoes);                     /*   pointer to array of echo addresses */
                                   /*   (may be NULL if no echoes)         */

int                                /*   returns standard GME status codes  */
gme1dlf(                           /* delete a forum                       */
struct gmework *work,              /*   GME work space (provided by caller)*/
unsigned forum);                   /*   forum ID to delete                 */

int                                /*   returns standard GME status codes  */
gme1modf(                          /* modify a forum definition            */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct fordef *newdef,             /*   modified forum description         */
char *desc,                        /*   descriptive text                   */
char *echoes);                     /*   pointer to array of echo addresses */
                                   /*(desc & echoes may be NULL if no chng)*/

int                                /*   returns standard GME status codes  */
gme1wnm(                           /* send a new message                   */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of attachment       */

int                                /*   returns standard GME status codes  */
gme1wap(                           /* write message as pointer to another  */
struct gmework *work,              /*   GME work space (provided by caller)*/
unsigned orgfor,                   /*   forum ID of original message       */
long orgmid,                       /*   message ID of original message     */
BOOL truecopy,                     /*   is pointer a complete copy?        */
struct message *msg,               /*   message header structure           */
char *filatt);                     /*   path+file name of attachment       */

int                                /*   returns standard GME status codes  */
gme1rti(                           /* read info on a thread (orig message) */
struct gmework *work,              /*   GME work space (provided by caller)*/
int direct,                        /*   direction (0=same, 1=next, -1=prev)*/
unsigned *nmsgs,                   /*   number of messages in thread       */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
gme1rdm(                           /* read a message utility               */
struct gmework *work,              /*   GME work space (provided by caller)*/
int direct,                        /*   read direction code                */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

int                                /*   returns standard GME status codes  */
gme1rdg(                           /* read a message given global ID       */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct globid *gmid,               /*   global message ID of parent        */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

BOOL
gidxst(                            /* does message with global ID exist    */
unsigned forum,                    /*   in this forum                      */
struct globid *globid);            /*   with this global ID                */

BOOL                               /*   returns TRUE if could get message  */
grabmsg(                           /* grab message using file position     */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

BOOL                               /*   returns TRUE if update successful  */
updmsg(                            /* update message on disk               */
struct gmework *work,              /*   GME work space (provided by caller)*/
const struct message *msg,         /*   message header structure buffer    */
const char *text,                  /*   message body text buffer           */
const char *appinf);               /*   app-defined info buffer            */

BOOL                               /*   returns TRUE if delete successful  */
gme1dlm(                           /* delete message (and attachment)      */
struct gmework *work);             /*   GME work space (provided by caller)*/

void
estctx(                            /* establish read context               */
struct rdctx *rdctx,               /*   context structure to establish     */
struct message *msg);              /*   message to use as context          */

