/***************************************************************************
 *                                                                         *
 *   GMECORE.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Galacticomm Messaging Engine core shared variables,       *
 *   functions, etc. FOR USE BY GMEUTL.C ONLY                              *
 *                                                                         *
 *                                            - J. Alvrus   6/5/94         *
 *                                                                         *
 ***************************************************************************/

                                   /* Miscellaneous GME-use strings        */
#define DLKRQS  "key required="    /*   dist list "key req" string         */
#define DLCHGS  "charge=%d\n"      /*   dist list "surcharge" string       */
#define DFFAPTH "FORUMS"           /*   default forum attachment directory */
#define AUTFWD  "Auto-fwd from %s" /*   auto-forward history string        */
#define CCOF    "cc: of #%s"       /*   carbon copy of history string      */
#define COPYBY  "Copy by %s"       /*   copy by history string             */
#define FWDBY   "Fw by %s"         /*   forwarded by history string        */
#define RPLTO   "Reply to #%s"     /*   reply to history string            */
#define DSTMSG  "Distributed"      /*   !QUICK or !MASS history string     */
#define SDLMSG  "Distributed to %s"/*   Sysop dist list history string     */

struct gmetag {                    /* GME-specific attachment tag structure*/
     unsigned fid;                 /*   forum in which message is located  */
     long mid;                     /*   message ID of message              */
     long pos;                     /*   file position of message           */
     long chg;                     /*   charge for download                */
};

extern
char dlstpth[MAXPATH];             /* path to sysop distribution lists     */
extern
BOOL supu2s,                       /* signups generate E-Mail to Sysop?    */
     supe2u,                       /* signups generate E-Mail to user?     */
     e2urrr,                       /* ret. rec. on new-user E-mail         */
     autqsc;                       /* put new forums in quickscan?         */
extern
char *nuemtp,                      /* topic of new-user E-Mail to sysop    */
     *e2utpc,                      /* topic of new-user E-Mail to user     */
     *e2uatt,                      /* attachment to E-Mail to user         */
     *e2uanm,                      /* name of attachment to new-user E-mail*/
     *rrtpc,                       /* return receipt topic                 */
     *curapi;                      /* current app-defined info buffer      */

void
inicore(void);                     /* initialize GME core                  */

int                                /*   returns standard GME status codes  */
chkread(                           /* check access/credits when reading    */
struct gmework *work);             /*   GME work space (provided by caller)*/

int                                /*   returns standard GME status codes  */
gme2scn(                           /* scan for a message                   */
struct gmework *work,              /*   GME work space (provided by caller)*/
int direct,                        /*   read direction code                */
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

BOOL                               /*   returns TRUE if another forum      */
nxtscnf(                           /* set up for next forum in scan        */
struct gmework *work);             /*   GME work space (provided by caller)*/

BOOL                               /*   returns TRUE if another forum      */
prvscnf(                           /* set up for previous forum in scan    */
struct gmework *work);             /*   GME work space (provided by caller)*/

BOOL
chkscn(                            /* check if message is in one-time scan */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure buffer    */
char *text);                       /*   message body text buffer           */

BOOL                               /*   returns FALSE if invalid search str*/
parsrch(                           /* parse search string                  */
char *usrstr,                      /*   string user typed in               */
char *kwdbuf,                      /*   buffer to store keywords in        */
char *search);                     /*   buffer to store search template    */

char *                             /*   returns ptr to string buffer       */
hdrstr(                            /* generate msg header string for search*/
struct message *msg);              /*   message header structure buffer    */

char *
datlin(                            /* build date/time string               */
unsigned date,                     /*   from DOS packed date               */
unsigned time);                    /*   and DOS packed time                */

char *
nrstr(                             /* generate "number of replies" string  */
int nr);                           /*   number of replies                  */

BOOL
chkwds(                            /* check if a string matches keywords   */
char *hstr,                        /*   message header to check            */
char *tstr,                        /*   message text to check              */
char *kwds,                        /*   ' '-delimited keyword list         */
char *srch);                       /*   search template string             */

BOOL
wrdinstr(                          /* is a word in a string?               */
char *wordstr,                     /*   word to search for                 */
char *srchstr);                    /*   string to search in                */

BOOL
deparse(                           /* reduces and/or/not primitive to y/n  */
char *p);                          /*   keyword primitive (!0&(0|!(1^0)))  */

void
dlaud(                             /* audit a download                     */
char *userid,                      /*   User-ID attachment downloaded for  */
char *tag);                        /*   tag used for download              */

void
ininew(                            /* initialize fields of a new message   */
struct message *msg);              /*   new message structure              */

void
iniamsg(                           /* init auto-filled fields of a message */
struct message *msg);              /*   new message structure              */

void
inicfmsg(                          /* init auto-filled fields for copy/fwd */
struct message *msg);              /*   message header structure           */

void
setgid(                            /* set global ID as local system        */
struct message *msg);              /*   message structure to set up        */

void
setflgs(                           /* set only appropriate message flags   */
struct message *msg,               /*   for new message                    */
char *userid);                     /*   user-id sending message            */

void
clrwrt(                            /* clr write-specific flds of work area */
struct gmework *work);             /*   GME work space in use              */

int                                /*   returns standard GME status codes  */
gme3cc(                            /* send cc:s when writing or replying   */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header structure           */
char *text,                        /*   message text                       */
char *cclist);                     /*   list of cc: addresses              */

BOOL                               /*   returns TRUE if a cc: to send      */
nextcc(                            /* set up to send next cc:              */
struct gmework *work,              /*   GME work space in use              */
struct message *msg,               /*   message header structure           */
char *cclist);                     /*   cc: list string                    */

int                                /*   returns standard GME status codes  */
gme2dst(                           /* send dist list                       */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of att (if any)     */

int                                /*   returns standard GME status codes  */
gme2wnm(                           /* send a message                       */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of att (if any)     */

BOOL                               /*   returns FALSE if can't send at all */
stripit(                           /* val a msg & strip unavail features   */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg);              /*   message header to strip            */

long
normchg(                           /* compute charges for a "normal" msg   */
struct message *msg,               /*   message header to check            */
long attsiz);                      /*   size of attachment (if any)        */

char *                             /*   path & file name of attachment     */
gdlname(                           /* gen path & file name to dnload att   */
BOOL indirect,                     /*   attachment is indirect             */
unsigned forum,                    /*   forum message is in                */
long msgid);                       /*   message ID                         */

char *                             /*   pointer to string buffer           */
indasp(                            /* get path+file name of indirect att   */
char *buf,                         /*   string buffer to path              */
unsigned forum,                    /*   forum message is in                */
long msgid);                       /*   message ID of message              */

char *                             /*   pointer to string buffer           */
dirasp(                            /* get path+file name of direct att     */
char *buf,                         /*   string buffer to path              */
unsigned forum,                    /*   forum message is in                */
long msgid);                       /*   message ID of message              */

void
wrtaud(                            /* do new-message audit stuff           */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg);              /*   new message structure              */

int                                /*   returns standard GME status codes  */
copychunk(                         /* cycled file copy utility             */
struct gmework *work);             /*   work area in use                   */

void
formrr(                            /* form return receipt message          */
struct message *msg,               /*   message header structure to use    */
char *text);                       /*   text buffer to use                 */

int                                /*   returns standard GME status codes  */
chksnd(                            /* check credits/access before sending  */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *filatt);                     /*   file attachment (if any)           */

int                                /*   returns standard GME status codes  */
chkcf(                             /* check credits/access for copy/forward*/
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   message header being sent          */
char *filatt);                     /*   file attachment (if any)           */

void
addchg(                            /* add up charges for current message   */
struct gmework *work,              /*   work area in use                   */
struct message *msg);              /*   new message structure              */

void
chkrqs(                            /* check recipient's quickscan          */
struct gmework *work,              /*   work area in use                   */
struct message *msg);              /*   new message structure              */
                                   /* (checks autofwd & forum to E-mail)   */

void
chkafwd(                           /* check out auto forwarding            */
struct gmework *work,              /*   work area in use                   */
struct qscfg *rcpqsp,              /*   pointer to recipient's quickscan   */
struct message *msg);              /*   new message structure              */

void
rstafwd(                           /* restore msg->to after auto-forward   */
struct gmework *work,              /*   work area in use                   */
struct message *msg);              /*   message structure                  */

void
swapto(                            /* swap between msg->to and work->auxto */
struct gmework *work,              /*   work area in use                   */
struct message *msg);              /*   message structure                  */

void
chkfor(                            /* check for E-mail to a forum          */
struct message *msg);              /*   new message structure              */

char *
expasp(                            /* get exporter attachment file spec    */
char *to,                          /*   address message is being sent to   */
struct message *msg);              /*   given message header structure     */

int                                /*   returns standard GME status codes  */
sndexp(                            /* send a message an exporter           */
struct gmework *work,              /*   work area in use                   */
char *to,                          /*   address to send message to         */
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of att (if any)     */

BOOL
iniecho(                           /* start up forum echoing               */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg);              /*   new message structure              */

int                                /*   returns standard GME status codes  */
gme1echo(                          /* send message to forum echoes         */
struct gmework *work,              /*   GME work space (provided by caller)*/
struct message *msg,               /*   new message structure              */
char *text,                        /*   message body text                  */
char *filatt);                     /*   path+file name of att (if any)     */

void
invecho(                           /* audit invalid echo address           */
char *addr,                        /*   echo address                       */
char *fnam);                       /*   forum name                         */

BOOL
valdest(                           /* is this a valid to address?          */
char *to,                          /*   to address                         */
unsigned dest);                    /*   destination (forum ID or E-mail)   */

BOOL                               /*   returns TRUE if a valid address    */
massage(                           /* convert address to final format      */
char *from,                        /*   User-ID of sender                  */
char *to,                          /*   to address                         */
unsigned dest);                    /*   destination (forum ID or E-mail)   */

BOOL
valexa(                            /* is this a valid E-mail export addr?  */
char *to);                         /*   address to check                   */

BOOL                               /*   returns TRUE if a valid address    */
masexa(                            /* convert export address to proper form*/
char *from,                        /*   User-ID of sender                  */
char *to);                         /*   address to check                   */

BOOL
thisexp(                           /* does address refer to this exporter? */
struct exporter *exp,              /*   pointer to exporter control block  */
char *to);                         /*   address to check                   */

struct expinfo *                   /*   returns pointer to destination     */
exp2inf(                           /* copy exporter struct to expinfo      */
struct exporter *exp,              /*   exporter structure                 */
struct expinfo *info);             /*   expinfo structure                  */

