/***************************************************************************
 *                                                                         *
 *   GALTEXT.H                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This module contains declarations for handling formatted text.        *
 *                                                                         *
 *                                                - J. Alvrus  7/17/95     *
 *                                                                         *
 ***************************************************************************/

#define FMTDSCSZ 11                /* format description size              */
#define RTFSTKSZ 10                /* RTF reader stack size                */

typedef BOOL                       /*   is this text in your format?       */\
        (txtdetf)(                 /* format detection function            */\
        const char *srcstr);       /*   string to examine                  */

typedef BOOL                       /*   could handle conversion?           */\
        (txtcvtf)(                 /* text converter function type         */\
        const char *srcbuf,        /*   source buffer                      */\
        char *dstbuf,              /*   destination buffer                 */\
        unsigned dstsiz);          /*   destination buffer size            */

typedef BOOL                       /*   was able to insert?                */\
        (txtinsf)(                 /* text inserter function type          */\
        BOOL endflg,               /*   insert at end (vs. at beginning)   */\
        const char *srcbuf,        /*   buffer containing ASCII text       */\
        char *dstbuf,              /*   buffer containing formatted text   */\
        unsigned dstsiz);          /*   destination buffer size            */

struct fmthlr {                    /* formattted text handling structure   */
     char fmtdesc[FMTDSCSZ];       /*   format description (e.g. "RTF")    */
     int flags;                    /*   format handler flags               */
     txtdetf *detect;              /*   function for detecting format      */
     txtcvtf *toasc;               /*   function for converting to ASCII   */
     txtinsf *insasc;              /*   function to insert ASCII           */
     txtcvtf *stpfmt;              /*   simple format stripping function   */
};

void
register_fmthlr(                   /* register formatted text handler      */
struct fmthlr *fmthlr);            /*   formatted text handling struct     */

int
nfmthlr(void);                     /* number of registered format handlers */

struct fmthlr **
fharr(void);                       /* ptr to array of ptrs to fmt handlers */

BOOL                               /*   is this text formatted?            */
isfmtted(                          /* check for formatted text             */
const char *srcstr);               /*   string to examine                  */

const char *                       /*   returns name of format             */
fmtname(                           /* get name of format used in this text */
const char *fmtstr);               /*   string containing formatted text   */

BOOL                               /*   was able to convert?               */
cvt2asc(                           /* convert formatted text to ASCII      */
const char *fmtsrc,                /*   formatted source string            */
char *ascdst,                      /*   ASCII destination buffer           */
unsigned dstsiz);                  /*   destination buffer size            */

BOOL                               /*   was able to insert?                */
insasc(                            /* insert ASCII into formatted text     */
BOOL endflg,                       /*   insert at end (vs. at beginning)   */
const char *srcbuf,                /*   buffer containing ASCII text       */
char *dstbuf,                      /*   buffer containing formatted text   */
unsigned dstsiz);                  /*   destination buffer size            */

BOOL                               /*   was able to strip?                 */
stripfmt(                          /* strip formatting                     */
const char *fmtsrc,                /*   formatted source string            */
char *ascdst,                      /*   ASCII destination buffer           */
unsigned dstsiz);                  /*   destination buffer size            */
