/***************************************************************************
 *                                                                         *
 *   GALRTF.H                                                              *
 *                                                                         *
 *   Copyright (c) 1988-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains declarations for handling Rich Text Format (RTF).  *
 *                                                                         *
 *   The reader is based on a sample RTF reader published in Microsoft     *
 *   Application Note GC0165.                                              *
 *                                                                         *
 *                                                - J. Alvrus  7/17/95     *
 *                                                                         *
 ***************************************************************************/

#define TWIPERC (1440/12)          /* twips per character                  */
                                   /*   (1440 twips/in. / 12 char/in.)     */
#define MAXTABS 14                 /* maximum number of custom tabs        */

extern
struct tabsetup {                  /* tab setup structure                  */
     unsigned char type;           /*   type (left, center, right, decimal)*/
     int pos;                      /*   position (relative to left margin) */
} temptab;                         /* temporary tab building struct        */

                                   /* tab type codes                       */
#define TTNONE    0                /*   not a tab (and no more tabs)       */
#define TTLEFT    1                /*   left                               */
#define TTCENTER  2                /*   centered                           */
#define TTRIGHT   3                /*   right                              */
#define TTDEC     4                /*   decimal                            */
#define TTBAR     5                /*   bar                                */

#define BARCHAR '|'                /* bar character for bar tabs           */

                                   /* flag properties                      */
#define SKIPFLG  0x0001            /*   ignore current output              */
#define CHPCAPS  0x0002            /*   char prop:  all-caps               */

                                   /* byte-sized properties                */
#define PAPJUST 0                  /*   para prop:  justification          */
#define NBYTEPROP 1                /* number of byte-sized properties      */

                                   /* word-sized properties                */
#define SCPPGW  0                  /*   sect prop:  page width             */
#define SCPMRGL 1                  /*   sect prop:  left margin            */
#define SCPMRGR 2                  /*   sect prop:  right margin           */
#define PAPFI   3                  /*   para prop:  first line indent      */
#define PAPLI   4                  /*   para prop:  left indent            */
#define PAPRI   5                  /*   para prop:  right indent           */
#define NWORDPROP 6                /* number of word-sized properties      */

                                   /* paragraph justification types        */
#define JUSTL 0                    /*   left                               */
#define JUSTR 1                    /*   right                              */
#define JUSTC 2                    /*   center                             */
#define JUSTF 3                    /*   full                               */

extern
struct rtfrstt {                   /* RTF reader state                     */
     int flag;                     /*   property/destination flags         */
     signed char byte[NBYTEPROP];  /*   byte-sized properties              */
     int word[NWORDPROP];          /*   word-sized properties              */
     struct tabsetup tab[MAXTABS]; /*   tab setup table                    */
} rtfrstt,                         /* current state                        */
 *rtfrstk;                         /* state stack                          */

extern
unsigned rtfrksz;                  /* RTF reader stack size                */

extern
struct rtfrglob {                  /* RTF reader global info               */
     int flags;                    /*   flags                              */
     int dftpgw;                   /*   default page width (\paperw)       */
     int dftmrgl;                  /*   default left margin (\margl)       */
     int dftmrgr;                  /*   default right margin (\margl)      */
     int dfttab;                   /*   default tab width (\deftab)        */
} rtfrglob;                        /* global info buffer                   */

                                   /* global info flags                    */
#define RGFPWS 0x0001              /*   default page width set             */
#define RGFMLS 0x0002              /*   default left margin set            */
#define RGFMRS 0x0004              /*   default right margin set           */
#define RGFTBS 0x0008              /*   default tab width set              */

extern
struct kwdtab {                    /* keyword parsing table structue       */
    char *keyword;                 /*   RTF keyword                        */
    int  dftval;                   /*   default value to use               */
    BOOL usedft;                   /*   always use default value?          */
    int  kwdtyp;                   /*   action to take                     */
    int  idx;                      /*   flag prop mask if kwdtyp == KWTYPPF*/
                                   /*   byte prop idx if kwdtyp == KWTYPPB */
                                   /*   word prop idx if kwdtyp == KWTYPPW */
                                   /*   unused if kwdtyp == KWTYPPT        */
                                   /*   dest type if kwdtyp == KWTYPDS     */
                                   /*   char to print if kwdtyp == KWTYPCH */
                                   /*   action code if kwdtyp == KWTYPSP   */
} kwdtab[];                        /* keyword parsing table                */

#define KWTABSZ _kwtabsz           /* # entries in keyword parsing table   */
extern unsigned _kwtabsz;          /* use KWTABSZ, not this                */

                                   /* keyword action type                  */
#define KWTYPPF 0                  /*   set flag property                  */
#define KWTYPPB 1                  /*   set byte-sized property            */
#define KWTYPPW 2                  /*   set word-sized property            */
#define KWTYPPT 3                  /*   set tab property                   */
#define KWTYPDS 4                  /*   set destination                    */
#define KWTYPCH 5                  /*   output special character           */
#define KWTYPSP 6                  /*   special handling required          */

                                   /* destination codes                    */
#define DESTBODY 0                 /*   body text                          */
#define DESTSKIP -1                /*   discard output                     */

                                   /* special action codes                 */
#define SPECSKPD 0                 /*   skip destination due to \*         */
#define SPECBIN  1                 /*   read binary data                   */
#define SPECDFTB 2                 /*   set default tabs                   */
#define SPECMRGL 3                 /*   set default left margin            */
#define SPECMRGR 4                 /*   set default right margin           */
#define SPECPGW  5                 /*   set default page width             */
#define SPECPAPD 6                 /*   return paragraph props to default  */
#define SPECCHPD 7                 /*   return character props to default  */
#define SPECSCPD 8                 /*   return section props to default    */
#define SPECTAB  9                 /*   set tab                            */
#define SPECTABB 10                /*   set bar tab                        */
#define SPECHEX  11                /*   read hexadecimal character         */

extern
const char *srcptr;                /* RTF reader global source pointer     */
extern
char *dstptr;                      /* RTF reader global destination pointer*/
extern
unsigned dstsiz;                   /* RTF reader global destination size   */
extern
int rtfrgrp,                       /* RTF reader current group (stack ptr) */
    rtfris,                        /* RTF reader internal state            */
    curtbidx;                      /* current tab index in rtfrstt.tab     */
extern
long rtfnbin;                      /* # bytes to read in binary mode       */
extern
BOOL skipunk;                      /* skip if next destination unknown     */

                                   /* RTF reader internal state codes      */
#define RISNORM 0                  /*   normal input mode                  */
#define RISBIN  1                  /*   reading binary info                */

                                   /* RTF reader error codes               */
#define RTFOK     0                /*   everything's fine!                 */
#define RTFNOTRTF 1                /*   source is not RTF                  */
#define RTFUNDFL  2                /*   unmatched '}'                      */
#define RTFOVRFL  3                /*   too many '{' -- stack overflow     */
#define RTFEOF    4                /*   unexpected end of source           */
#define RTFINVHX  5                /*   invalid hex character found in data*/
#define RTFXERR   100              /*   extended errors start here         */

#define RTFIDSTR "{\\rtf"          /* RTF identifier string                */

#define RTFDONE RTFXERR            /* finished successfully code for start */
                                   /* of text finder                       */
#define AFNTSZSTR "\\fs24 "        /* ASCII font size string               */
#define AFNTSZLEN (sizeof(AFNTSZSTR)-1)/* ASCII font size string length    */

extern
int (*rtfputc)(int ch);            /* output character function pointer    */
extern
void (*finout)(void);              /* finish output function pointer       */
extern
void (*grpbeg)(void);              /* new group beginning function pointer */
extern
void (*grpend)(void);              /* group ending function pointer        */

void
initrtf(                           /* initialize RTF handler               */
unsigned stacksiz);                /*   number of elements to stack        */

BOOL
isrtf(                             /* is this RTF?                         */
const char *s);                    /*   string to check                    */

int                                /*   returns result code                */
rtf2asc(                           /* convert RTF text to ASCII            */
const char *rtfsrc,                /*   RTF source buffer                  */
char *ascdst,                      /*   ASCII destination buffer           */
unsigned bufsiz);                  /*   destination buffer size            */

void
ascfin(void);                      /* finish ASCII output                  */

int                                /*   returns result of operation        */
putasc(                            /* output character to ASCII destination*/
int ch);                           /*   character to output                */

unsigned                           /*   returns length in characters       */
linelen(                           /* compute length of line (expand tabs) */
char *s,                           /*   line buffer (not nul terminated)   */
unsigned n);                       /*   # characters in line buffer        */

void
addline(                           /* add completed line to output buffer  */
char *s,                           /*   line buffer (not nul terminated)   */
unsigned n,                        /*   # characters in line buffer        */
char term,                         /*   line terminator character          */
BOOL lastline);                    /*   last line in paragraph?            */

char *                             /*   returns a copy of destination      */
formline(                          /* form completed line                  */
char *dst,                         /*   destination buffer                 */
char *src,                         /*   source buffer (not nul terminated) */
unsigned n,                        /*   # characters in line buffer        */
BOOL lastline);                    /*   last line in paragraph?            */

int                                /*   returns index in tab array (or -1) */
nexttab(                           /* figure out next tab                  */
int charpos);                      /*   after this character position      */

void
applyjust(                         /* apply full justification to a string */
char *strbuf,                      /*   string buffer                      */
unsigned justlen);                 /*   length after justification         */

BOOL                               /*   was able to insert?                */
rtfinasc(                          /* insert ASCII into RTF                */
BOOL endflg,                       /*   insert at end (vs. at beginning)   */
const char *srcbuf,                /*   buffer containing ASCII text       */
char *dstbuf,                      /*   buffer containing formatted text   */
unsigned dstsiz);                  /*   destination buffer size            */

char *                             /*   copy of pointer to destination     */
asc2rtf(                           /* "convert" ASCII to RTF (only chars)  */
const char *ascsrc,                /*   buffer containing ASCII text       */
char *rtfdst,                      /*   buffer to put RTF                  */
unsigned dstsiz);                  /*   size of destination buffer         */
                                   /*   (single-character EOLs assumed)    */

char *                             /*   pointer to start of text           */
rtfbotxt(                          /* find start of text                   */
const char *rtfsrc);               /*   in this RTF text                   */

int                                /*   returns result code                */
striprtf(                          /* super-simple RTFormat stripper       */
const char *rtfsrc,                /*   RTF source buffer                  */
char *ascdst,                      /*   ASCII destination buffer           */
unsigned bufsiz);                  /*   destination buffer size            */

void
stpfin(void);                      /* finish RTF stripper output           */

int                                /*   returns result of operation        */
putstp(                            /* output char to stripped destination  */
int ch);                           /*   character to output                */

int                                /*   returns result code                */
initrtfr(                          /* initialize RTF reader                */
const char *rtfsrc);               /*   RTF source buffer pointer          */

int                                /*   returns result code                */
rtfread(                           /* read RTF                             */
const char *rtfsrc);               /*   RTF source buffer                  */

int                                /*   returns result of operation        */
pushrtf(void);                     /* save current RTF parser state        */

int                                /*   returns result of operation        */
poprtf(void);                      /* restore saved RTF parser state       */

int                                /*   returns result of operation        */
xrtfkwd(void);                     /* extract RTF keyword and parameter    */

int                                /*   returns result of operation        */
parsech(                           /* route character to appropriate dest  */
int ch);                           /*   character to output                */

int                                /*   returns result of operation        */
hrtfkwd(                           /* find and handle RTF keyword          */
const char *keyword,               /*   keyword                            */
long param,                        /*   parameter                          */
BOOL parmflg);                     /*   was there a param (param is valid)?*/

int                                /*   index of keyword in table          */
findrk(                            /* find RTF keyword in table            */
const char *keyword);              /*   keyword                            */

int                                /*   returns result of operation        */
rtfpchg(                           /* change a property                    */
int propidx,                       /*   index of property in arrays        */
long propval,                      /*   value to set property to           */
int proptyp);                      /*   type of property                   */

int                                /*   returns result of operation        */
rtfdchg(                           /* change destination                   */
int dest);                         /*   new destination                    */

int                                /*   returns result of operation        */
rtfspec(                           /* evaluate a special keyword           */
int action,                        /*   action required                    */
long value);                       /*   keyword value                      */

int                                /*   returns result of operation        */
hdlhex(void);                      /* handle hex data keyword              */

int                                /*   returns numeric equivalent         */
hex2bin(                           /* convert a hex character to binary    */
char c);                           /*   hex character to convert           */

void
settab(                            /* add new tab to array of tabs         */
int tabpos);                       /*   with this position                 */

int                                /*   returns index of open slot         */
lasttab(void);                     /* find open slot in tab array          */

void
sorttabs(                          /* sort tabs to keep in ascending order */
int numtabs);                      /*   number of tabs in array            */
