/***************************************************************************
 *                                                                         *
 *   GALP&QR.C                                                             *
 *                                                                         *
 *   Copyright (c) 1988-1996 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *                                                                         *
 *                                          - M. Timothy Stark 11/01/93    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "conio.h"

#define FILREV "$Revision: 1.2 $"

#define UIDSIZ        30           /* user-id size                         */
#define PNAMELEN      26           /* poll name size                       */
#define PDESCLEN      40           /* poll description length              */
#define PTHFILSIZ     50           /* text buffer for path size            */
#define INPLEN        80           /* input length for command parsing     */
#define KEYLEN        16           /* key length                           */
#define MAXASTGS      16           /* maximum number of answer strings     */
#define ANSSTGLEN     65           /* answer string length                 */
#define PSSIZ  (PNAMELEN)          /* poll selection size                  */
#define TXTSIZ      2000           /* size of text buffer for question     */
#define ANSSIZ      1000           /* size of text buffer for answer       */
#define DISONLY        3           /* display only question type number    */
#define MAXQUES      100           /* maximum number of questions per poll */
#define DFTOUT       "s"           /* output to users screen               */

#define BLKWHT      0x70           /* Black on white                       */
#define YELWHT      0x7E           /* Yellow on white                      */
#define YELCYN      0x3E           /* Yellow on cyan                       */
#define WHTBLK      0x0F           /* White on black                       */
#define YELBLU      0x1E           /* Yellow on blue                       */
#define WHTBLU      0x1F           /* White on blue                        */
#define GRNBLU      0x1A           /* Green on blue                        */
#define CYNBLU      0x1B           /* Cyan on blue                         */
#define REDBLU      0x1C           /* Red on blue                          */
#define BLKBLU      0x10           /* Black on blue                        */

#define DELETE       256           /* flag to show poll is tagged for del. */

static char dosscn[SCNSIZ];        /* saved DOS screen image               */
static char savbak[SCNSIZ];        /* saved background (for help screen)   */
static char scrsav1[SCNSIZ];
static char scrsav2[SCNSIZ];
static char scrsav3[SCNSIZ];
extern char scntbl[][SCNSIZ];      /* array of screens (c/o MAKESCNS)      */

char uid[UIDSIZ],                  /* storage for user-id                  */
     repchr[2];

char *polllst,                     /* poll list                            */
     **selptr;                     /* poll selector                        */


FILE *outfp;                       /* output file pointer (GALPLRPT.TXT)   */
FILE *polmb;                       /* pollester message file pointer       */

BTVFILE *sbb,                      /* user statistic data file pointer     */
        *pbb,                      /* general poll data file pointer       */
        *qbb,                      /* poll question data file pointer      */
        *abb,                      /* poll answer data file pointer        */
        *tbb;                      /* poll tally data file pointer         */

char *msgptr,                      /* pointer to last message gotten       */
     *plnams[10];                  /* array of poll names                  */

static
char *type[]={
     "Questionnaire",
     "Poll"
};

static
char *repopts[]={
     " User-ID",
     " Polls",
     " Questionnaires"
};

static
char *pqopts[]={
     " Summary Report",
     " Template Report"
};

static
char *rpthdr[]={
     "Polls and Questionnaires User Report for \"%s\"",
     "Poll Summary Report for %s \"%s\"",
     "Questionnaire Summary Report for %s \"%s\""
};

int cnt,                           /* global counter for poll selection    */
    redir=0,
    pagbrk=0,
    line=-1,
    ques,
    expuid,                        /* explode get user-id box? 1=YES 0=NO  */
    explst,                        /* explode poll listing?    1=YES 0=NO  */
    explst2;                       /* explode p&q option listing?          */

char inpnam[15],
     outnam[15];

FILE *outf=stdout;

struct pollstat {                  /* current poll status for this user    */
     char      uid[UIDSIZ];        /* userid                               */
     char      pname[PNAMELEN];    /* poll name                            */
};

struct polldata {                  /* master poll data structure           */
     char      pname[PNAMELEN];    /* poll name                            */
     char      pdesc[PDESCLEN];    /* poll description                     */
     int       polltype;           /* poll type 0=QUES 1=POLL 2=SURVEY     */
     int       priority;           /* poll priority 0=SKIP 1=ANNOUNCE      */
                                   /* 2=ASK 3=INSIST  */
     int       data;               /* data storage method array element    */
                                   /* 0/1=BTRIEVE 2=ASCII 3=BOTH 4=NONE    */
     int       answer;             /* 0/1=ONCE 2=REPLACE 3=ACCUMULATE      */
     unsigned  createdate;         /* date poll was created                */
     unsigned  closedate;          /* date to close this poll              */
     char      lookup_key[KEYLEN]; /* key required to look up answers      */
     char      logon_key[KEYLEN];  /* key required to get logon option     */
     char      acc_key[KEYLEN];    /* key required to answer poll          */
     int       acc_attr;           /* access display attribute             */
     char      res_key[KEYLEN];    /* key required to view results         */
     char      grant_key[KEYLEN];  /* key to grant users that complete     */
     char      grant_class[KEYLEN];/* class to grant users that complete   */
     long      grant_crd;          /* credits to grant users that complete */
     char      grant_file[PTHFILSIZ]; /* file to grant users that complete */
     int       flags;              /* poll flags                           */
};

struct quesdata {                  /* poll question data structure         */
     int       qnum;               /* question identification number       */
     char      pollname[PNAMELEN]; /* poll name this question is related to*/
     int       qtype;              /* question type                        */
     char      ansstg[MAXASTGS][ANSSTGLEN];   /* array of answer strings   */
     int       branch[MAXASTGS];   /* branching designators                */
     int       prev;               /* previous question                    */
     int       next;               /* default next question                */
     long      max;                /* maximum value/length of answer       */
     long      min;                /* minimum value/length of answer       */
     int       field;              /* field array element for usracc struct*/
     int       flags;              /* question flags                       */
     int       ansparam;           /* number of answer parameters to allow */
     char      txtmsg[TXTSIZ];     /* question/text display message        */
};

struct ansrdata {                  /* poll answer data structure           */
     int       qnum;               /* question number for this answer      */
     char      pollname[PNAMELEN]; /* poll name this answer is related to  */
     char      uid[UIDSIZ];        /* userid of owner of this data         */
     char      answer[ANSSIZ];     /* variable length answer string        */
};


struct polltally {                 /* survey answer tally structure        */
     char pollname[PNAMELEN];      /* tally for what pollname              */
     int  answer[MAXQUES][MAXASTGS];
};

/* construct composite key for question acquisition */
struct quescomp {                  /* composite key for question           */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
     int       qnum;               /* question number of ques to acquire   */
};

/* construct composite key for answer acquisition */
struct ansrcomp {                  /* composite key for answer             */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
     char      uid[UIDSIZ];        /* userid of owner of this data         */
     int       qnum;               /* question number of this answer       */
};

struct statcomp {                  /* user statistics composit key struct  */
     char      uid[UIDSIZ];        /* userid                               */
     char      pname[PNAMELEN];    /* poll name                            */
};

struct pollstat *sp;
struct polldata *dp;
struct quesdata *qp;
struct ansrdata *ap;
struct quescomp qcomp;
struct ansrcomp acomp;
struct statcomp scomp;
struct polltally tally;

void iniwin (void);
void gohome (int mode);
int getopt (void);
int uidrpt (void);
int valuid (int c,char *stg);
int getpoll (int mode);
void lodopt (int opt);
void lodpol (int opt, int mode);
int haspols (void);
int valout (int c, char *stg);
void dourpt (int mode);
int whrout (void);
int ismult (void);
int showmult (int mode);
int getfil (void);
static void prfsp (char *fmat,...);
int finup (int mode);
int ispols (int mode);
void dosrpt (int mode);
void doprpt (int mode);
void usrrpt (char *usr, char *pq, char *out);
void polrpt (char *poll, char *out);
void qusrpt (char *ques, char *out);
void init (void);
void fmtuid (char *stg);
int isuplo (char *stg);
void stripb (char *stg);
void shutdown (void);
void stamp (void);
char *rsltper(int num,int tot);

void
main(argc,argv)                    /* main GALPLRPT.EXE program loop       */
int argc;                               /* number of command-line params   */
char *argv[];                           /* parsed command-line params      */
{
     int ropt,opt,i,mode,cat;
     char inp[INPLEN],
          *ip,
          usr[UIDSIZ],
          pq[PNAMELEN],
          out[PTHFILSIZ];

     mode=cat=0;
     iniwin();
     if (argc > 1) {
          if (sameas(argv[1],"/u")) {
               init();
               i=2;
               do {
                    stzcpy(inp,argv[i++],INPLEN);
                    ip=inp;
                    if (*ip == '/') {
                         ip++;
                         mode++;
                         cat=0;
                    }
                    switch (mode) {
                    case 0:
                    case 1:
                         if (!cat && strlen(ip) < (mode == 0 ? UIDSIZ
                            : PNAMELEN)) {
                              strcpy(mode == 0 ? usr : pq,ip);
                              cat=1;
                         }
                         else if (strlen(mode == 0 ? usr : pq)+strlen(ip)
                              < (mode == 0 ? UIDSIZ : PNAMELEN)) {
                              strcat(mode == 0 ? usr : pq," ");
                              strcat(mode == 0 ? usr : pq,ip);
                         }
                         break;
                    case 2:
                         if (!cat) {
                              if (strlen(ip) == 0) {
                                   strcpy(out,DFTOUT);
                              }
                              else if (strlen(ip) < PTHFILSIZ) {
                                   strcpy(out,ip);
                              }
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(out) < PTHFILSIZ) {
                              strcat(out,ip);
                         }
                    }
               } while (i < argc);
               usrrpt(usr,pq,out);
          }
          else if (sameas(argv[1],"/p")) {
               init();
               i=2;
               do {
                    stzcpy(inp,argv[i++],INPLEN);
                    ip=inp;
                    if (*ip == '/') {
                         ip++;
                         mode++;
                         cat=0;
                    }
                    switch(mode) {
                    case 0:
                         if (!cat && strlen(ip) < PNAMELEN) {
                              strcpy(pq,ip);
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(pq)+1 < PNAMELEN) {
                              strcat(pq," ");
                              strcat(pq,ip);
                         }
                         break;
                    case 1:
                         if (!cat) {
                              if (strlen(ip) == 0) {
                                   strcpy(out,DFTOUT);
                              }
                              else if (strlen(ip) < PTHFILSIZ) {
                                   strcpy(out,ip);
                              }
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(out) < PTHFILSIZ) {
                              strcat(out,ip);
                         }
                    }
               } while (i < argc);
               polrpt(pq,out);
          }
          else if (sameas(argv[1],"/q")) {
               init();
               i=2;
               do {
                    stzcpy(inp,argv[i++],INPLEN);
                    ip=inp;
                    if (*ip == '/') {
                         ip++;
                         mode++;
                         cat=0;
                    }
                    switch (mode) {
                    case 0:
                         if (!cat && strlen(ip) < PNAMELEN) {
                              strcpy(pq,ip);
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(pq)+1 < PNAMELEN) {
                              strcat(pq," ");
                              strcat(pq,ip);
                         }
                         break;
                    case 1:
                         if (!cat) {
                              if (strlen(ip) == 0) {
                                   strcpy(out,DFTOUT);
                              }
                              else if (strlen(ip) < PTHFILSIZ) {
                                   strcpy(out,ip);
                              }
                              cat=1;
                         }
                         else if (strlen(ip)+strlen(out) < PTHFILSIZ) {
                              strcat(out,ip);
                         }
                    }
               } while (i < argc);
               qusrpt(pq,out);
          }
          else {
               system("cls");
               explodeto(scntbl[3],0,0,79,22,0,0);
               locate(0,23);
               cursiz(LILCURS);
               shutdown();
               exit(0);
          }
          gohome(0);
          shutdown();
          exit(0);
     }
     else {
          init();
          while ((ropt=getopt()) != -ESC) {
               if (ropt == 0) {
                    do {
                         if (uidrpt()) {
                              while ((opt=getpoll(ropt)) != -ESC) {
                                   lodopt(opt);
                                   if (whrout()) {
                                        dourpt(1);
                                        break;
                                   }
                              }
                              free(polllst);
                              free(selptr);
                              opt=ESC;
                         }
                         else {
                              if (edtvalc != ESC) {
                                   scn2mem(frzseg(),savbak,SCNSIZ);
                                   explodeto(scntbl[0],0,19,41,22,18,14);
                                   proff(0,0);
                                   cursiz(NOCURS);
                                   if (getchc() == ESC) {
                                        break;
                                   }
                                   rstcur();
                                   movmem(savbak,frzseg(),SCNSIZ);
                              }
                              else {
                                   opt=ESC;
                              }
                         }
                    } while (opt != ESC);
               }
               else {
                    if (ispols(ropt)) {
                         while ((opt=getpoll(ropt)) != -ESC) {
                              lodpol(opt,ropt);
                              if (ropt == 2) {    /* questionnaire report  */
                                   if (whrout()) {
                                        dosrpt(1);
                                        break;
                                   }
                              }
                              else {              /* poll report           */
                                   if (whrout()) {
                                        doprpt(1);
                                        break;
                                   }
                              }
                         }
                         free(polllst);
                         free(selptr);
                    }
                    else {
                         scn2mem(frzseg(),scrsav1,SCNSIZ);
                         if (ropt == 1) {
                              explodeto(scntbl[0],45,19,78,23,23,10);
                         }
                         else {
                              explodeto(scntbl[0],45,14,78,18,23,10);
                         }
                         proff(0,0);
                         cursiz(NOCURS);
                         if (getchc() == ESC) {
                              break;
                         }
                         rstcur();
                         movmem(scrsav1,frzseg(),SCNSIZ);
                    }
               }
          }
     }
     gohome(1);
     shutdown();
     exit(0);
}

void
iniwin(void)                       /* initialize the windowing system      */
{
     int i;

     scn2mem(frzseg(),dosscn,SCNSIZ);
     monorcol();
     for (i=0 ; i < 5 ; i++) {
          cvtscn(scntbl[i]);
     }
     cursiz(NOCURS);
}

void
init(void)
{
     sbb=opnbtv("galp&qs.dat",sizeof(struct pollstat));
     pbb=opnbtv("galp&qp.dat",sizeof(struct polldata));
     qbb=opnbtv("galpqq.dat",sizeof(struct quesdata));
     abb=opnbtv("galpqa.dat",sizeof(struct ansrdata));
     tbb=opnbtv("galp&qt.dat",sizeof(struct polltally));
     sp=(struct pollstat *)alczer(sizeof(struct pollstat));
     dp=(struct polldata *)alczer(sizeof(struct polldata));
     qp=(struct quesdata *)alczer(sizeof(struct quesdata));
     ap=(struct ansrdata *)alczer(sizeof(struct ansrdata));
}

void
dourpt(mode)
int mode;
{
     int done=0;
     char *tp;

     explode(scntbl[2],0,0,79,24);
     locate(2,1);
     setatr(WHTBLU);
     printf(rpthdr[0],uid);
     setwin(0L,2,3,77,22,1);
     locate(2,3);
     setatr(WHTBLU);
     if (redir) {
          fprintf(outf,"\nUser Report for \"%s\", %s %s:\n",
               sp->uid,type[dp->polltype],dp->pname);
     }
     setbtv(qbb);
     ques=0;
     do {
          qcomp.qnum=ques++;
          strncpy(qcomp.pollname,sp->pname,PNAMELEN);
          if (acqbtv(qp,&qcomp,0)) {
               acomp.qnum=qp->qnum;
               strncpy(acomp.pollname,sp->pname,PNAMELEN);
               strncpy(acomp.uid,sp->uid,UIDSIZ);
               setbtv(abb);
               if (acqbtv(ap,&acomp,0)) {
                    for (tp=ap->answer ; *tp != '\0' ; tp++) {
                         if (*tp == '\r') {
                              line++;
                              *tp='\n';
                         }
                    }
                    if (mode && line > pagbrk) {
                         if (finup(0) == 0) {
                              done=1;
                         }
                    }
                    prfsp("\nAnswer for Question #%d: %s\n",
                         qp->qnum+1,qp->qtype == DISONLY ? "<Display Only>"
                         : ap->answer);
                    line++;
               }
               rstbtv();
          }
          if (ques >= MAXQUES) {
               done=1;
          }
     } while (!done);
     if (mode) {
          printf("\nPress RETURN to continue.");
          getchc();
     }
     movmem(dosscn,frzseg(),SCNSIZ);
}

void
doprpt(mode)                            /* polls summary report            */
int mode;
{
     int done=0;
     char *tp;

     explode(scntbl[2],0,0,79,24);
     locate(2,1);
     setatr(WHTBLU);
     printf(rpthdr[1],type[dp->polltype],dp->pname);
     setwin(0L,2,3,77,22,1);
     locate(2,2);
     setatr(WHTBLU);
     if (redir) {
          fprintf(outf,"\nReport for %s '%s':\n",type[dp->polltype],dp->pname);
     }
     ques=0;
     do {
          setbtv(qbb);
          qcomp.qnum=ques++;
          strncpy(qcomp.pollname,dp->pname,PNAMELEN);
          if (acqbtv(qp,&qcomp,0)) {
               for (tp=qp->txtmsg ; *tp != '\0' ; tp++) {
                    if (*tp == '\r') {
                         line++;
                         *tp='\n';
                    }
               }
               if (mode && line > pagbrk) {
                    if (finup(0) == 0) {
                         done=1;
                    }
               }
               if (ismult()) {
                    if (showmult(mode) == 0) {
                         done=1;
                    }
               }
               prfsp("\n");
               line++;
               if (mode && finup(0) == 0) {
                    done=1;
               }
               else {
                    setatr(WHTBLU);
                    printf("\f");
                    locate(2,2);
               }
          }
          if (ques >= MAXQUES) {
               done=1;
          }
     } while (!done);
     movmem(scrsav3,frzseg(),SCNSIZ);
}

void
dosrpt(mode)                            /* questionnaires summary report   */
int mode;
{
     int done=0,ques,fnd;
     char *tp;

     explode(scntbl[2],0,0,79,24);
     setatr(YELBLU);
     locate(2,1);
     setatr(WHTBLU);
     printf(rpthdr[2],type[dp->polltype],dp->pname);
     setwin(0L,2,3,77,22,1);
     locate(2,3);
     setatr(WHTBLU);
     if (redir) {
          fprintf(outf,"\nReport for %s '%s':\n",type[dp->polltype],dp->pname);
     }
     ques=0;
     do {
          setbtv(qbb);
          qcomp.qnum=ques++;
          strncpy(qcomp.pollname,dp->pname,PNAMELEN);
          if (acqbtv(qp,&qcomp,0)) {
               for (tp=qp->txtmsg ; *tp != '\0' ; tp++) {
                    if (*tp == '\r') {
                         line++;
                         *tp='\n';
                    }
               }
               if (mode && line > pagbrk) {
                    if (finup(0) == 0) {
                         done=1;
                    }
               }
               if (ismult()) {
                    if (showmult(mode) == 0) {
                         done=1;
                    }
               }
               else {
                    setatr(WHTBLU);
                    prfsp("\nQuestion #%d:\n",qp->qnum+1);
                    setatr(GRNBLU);
                    prfsp("%s\n",qp->txtmsg);
               }
               prfsp("\n");
               line++;
               if (mode && finup(0) == 0) {
                    done=1;
               }
               else {
                    setatr(WHTBLU);
                    printf("\f");
                    locate(2,2);
               }
          }
          if (ques >= MAXQUES) {
               done=1;
          }
     } while (!done);
     ques=0;
     setbtv(abb);
     if (alobtv(ap,2)) {
          do {
               qcomp.qnum=ques;
               strncpy(qcomp.pollname,dp->pname,PNAMELEN);
               setbtv(qbb);
               if (acqbtv(qp,&qcomp,0)) {
                    fnd=0;
                    do {
                         acomp.qnum=qp->qnum;
                         strncpy(acomp.pollname,dp->pname,PNAMELEN);
                         strncpy(acomp.uid,ap->uid,UIDSIZ);
                         setbtv(abb);
                         if (acqbtv(ap,&acomp,0)) {
                              if (!sameas(ap->pollname,dp->pname)) {
                                   break;
                              }
                              if (fnd == 0) {
                                   setatr(WHTBLU);
                                   prfsp("\nAnswers for User-ID \"%s\":\n\n",
                                        ap->uid);
                                   line+=4;
                                   fnd=1;
                              }
                              for (tp=ap->answer ; *tp != '\0' ; tp++) {
                                   if (*tp == '\r') {
                                        *tp='\n';
                                        line++;
                                   }
                              }
                              setatr(GRNBLU);
                              prfsp("Question #%d: %s\n",
                                   qp->qnum+1,ap->answer);
                              if (line++ > pagbrk) {
                                   if (mode && finup(0) == 0) {
                                        movmem(scrsav3,frzseg(),SCNSIZ);
                                        return;
                                   }
                              }
                         }
                         qcomp.qnum++;
                         rstbtv();
                    } while (acqbtv(qp,&qcomp,0));
               }
               setbtv(abb);
          } while (agtbtv(ap,ap->uid,2));
     }
     if (mode) {
          finup(1);
     }
     movmem(scrsav3,frzseg(),SCNSIZ);
}

int
ismult(void)
{
     if (qp->qtype == 4 || qp->qtype == 7 || qp->qtype == 8) {
          return(1);
     }
     return(0);
}

int
showmult(mode)                     /* show multiple choice answers         */
int mode;
{
     int i,showstat=0,tot=0;

     setbtv(tbb);
     if (acqbtv(&tally,dp->pname,0)) {
          showstat=1;
          for (i=0,tot=0 ; i < MAXASTGS ; i++) {
               tot+=tally.answer[qp->qnum][i];
          }
          if (tot == 0) {
               showstat=0;
          }
     }
     setatr(WHTBLU);
     if (dp->polltype == 1) {
          prfsp("\nQuestion #%d (%d response%s):\n",qp->qnum+1,tot,
               tot == 1 ? "" : "s");
     }
     else {
          prfsp("\nQuestion #%d:\n",qp->qnum+1);
     }
     setatr(GRNBLU);
     prfsp("%s\n",qp->txtmsg);
     line+=2;
     for (i=0 ; i < MAXASTGS ; i++) {
          if (strlen(qp->ansstg[i]) > 0) {
               line++;
               setatr(CYNBLU);
               prfsp("\n%c",(char)(65+i));
               setatr(YELBLU);
               prfsp(" ... %-35.35s",qp->ansstg[i]);
               if (showstat) {
                    setatr(GRNBLU);
                    prfsp(" %s ",rsltper(tally.answer[qp->qnum][i],tot));
                    setatr(WHTBLU);
                    printf("[");
                    setatr(YELBLU);
                    prfsp("%-22.22s",
                         bargph(22,tally.answer[qp->qnum][i],tot));

                    setatr(WHTBLU);
                    printf("]");
               }
          }
          if (mode && line > pagbrk) {
               if (finup(0) == 0) {
                    return(0);
               }
          }
     }
     return(1);
}

void
gohome(mode)                       /* get ready to go back to DOS now      */
int mode;
{
     setatr(0x07);
     printf(" ");
     locate(0,24);
     if (mode == 1) {
          movmem(dosscn,frzseg(),SCNSIZ);
     }
     cursiz(LILCURS);
}


int
getopt(void)                       /* get main option                      */
{
     int savexp;
     static int first=1;

     if (first) {
          first=0;
          explodeto(scntbl[0],0,0,55,13,12,4);
     }
     else {
          movmem(dosscn,frzseg(),SCNSIZ);
          savexp=explodem;
          explodem=0;
          explodeto(scntbl[0],0,0,55,13,12,4);
          explodem=savexp;
     }
     expuid=explst=1;
     proff(0,0);
     selatr=YELWHT;
     nslatr=YELCYN;
     return(choose(3,repopts,19,12,59,15,1));
}

int
getpoll(mode)                      /* get poll to use                      */
int mode;
{
     int savexp;

     explst2=1;
     if (explst) {
          explst=0;
          explodeto(scntbl[1],0,0,43,13,18,6);
          locate(30,6);
          setatr(BLKWHT);
          printf("%s ",mode == 2 ? "Questionnaire"
               : mode == 1 ? "Poll" : "Poll or Questionnaire");
     }
     else {
          savexp=explodem;
          explodem=0;
          explodeto(scntbl[1],0,0,43,13,18,6);
          locate(30,6);
          setatr(BLKWHT);
          printf("%s ",mode == 2 ? "Questionnaire"
               : mode == 1 ? "Poll" : "Poll or Questionnaire");
          explodem=savexp;
     }
     proff(0,0);
     selatr=YELWHT;
     nslatr=YELCYN;
     return(choose(cnt,selptr,25,10,54,16,1));
}

int
uidrpt(void)                       /* User-ID report option                */
{
     int savexp;

     setmem(uid,UIDSIZ,0);
     if (expuid) {
          expuid=0;
          explodeto(scntbl[0],0,14,44,18,18,10);
     }
     else {
          savexp=explodem;
          explodem=0;
          explodeto(scntbl[0],0,14,44,18,18,10);
          explodem=savexp;
     }
     proff(0,0);
     setatr(WHTBLK);
     rstcur();
     if (edtval(30,12,UIDSIZ,uid,valuid,0)) {
          cursiz(NOCURS);
          setatr(WHTBLK);
          locate(30,12);
          fmtuid(uid);
          printf("%s",uid);
          if (haspols()) {
               return(1);
          }
     }
     return(0);
}

int
getpqo(void)                       /* get poll and questionnaire option    */
{
     if (explst2) {
          explst2=0;
          explodeto(scntbl[1],43,13,78,20,20,8);
     }
     else {
          movmem(scrsav3,frzseg(),SCNSIZ);
     }
     proff(0,0);
     selatr=YELWHT;
     nslatr=YELCYN;
     return(choose(2,pqopts,23,12,51,13,1));
}

int
haspols(void)                      /* check a specific User-ID for p&q's   */
{
     int i,j;
     char tmp[PSSIZ];

     cnt=0;
     setbtv(sbb);
     if (acqbtv(sp,uid,1)) {
          do {
               setbtv(pbb);
               if (acqbtv(dp,sp->pname,0)) {
                    if (!(dp->flags&DELETE)) {
                         cnt++;
                    }
               }
               rstbtv();
          } while (aqnbtv(sp));
          if (cnt == 0) {
               return(0);
          }
          polllst=alczer(cnt*PSSIZ);
          selptr=(char **)alczer((cnt+1)*sizeof(char *));
          for (i=0 ; i < cnt ; i++) {
               selptr[i]=&polllst[i*PSSIZ];
          }
          selptr[cnt]=NULL;
          for (i=0 ; i < cnt ; ) {
               if (i == 0) {
                    acqbtv(sp,uid,1);
               }
               else {
                    aqnbtv(sp);
               }
               setbtv(pbb);
               if (acqbtv(dp,sp->pname,0)) {
                    if (!(dp->flags&DELETE)) {
                         setmem(tmp,PSSIZ,0);
                         strcpy(tmp," ");
                         strcat(tmp,dp->pname);
                         for (j=strlen(tmp) ; j < PSSIZ ; j++) {
                              tmp[j]=' ';
                         }
                         tmp[PSSIZ-1]='\0';
                         strcpy(&polllst[i*PSSIZ],tmp);
                         i++;
                    }
               }
               rstbtv();
          }
          return(1);
     }
     return(0);
}


int
ispols(mode)                       /* check for presence of any p&q's      */
int mode;
{
     int i,j,first;
     char tmp[PSSIZ];

     cnt=0;
     setbtv(pbb);
     if (qlobtv(0)) {
          do {
               gcrbtv(dp,0);
               if (!(dp->flags&DELETE) && dp->polltype == mode) {
                    cnt++;
               }
          } while (qnxbtv());
          if (cnt == 0) {
               return(0);
          }
          polllst=alczer(cnt*PSSIZ);
          selptr=(char **)alczer((cnt+1)*sizeof(char *));
          for (i=0 ; i < cnt ; i++) {
               selptr[i]=&polllst[i*PSSIZ];
          }
          selptr[cnt]=NULL;
          for (i=0,first=1 ; i < cnt ; ) {
               setbtv(pbb);
               if (first) {
                    qlobtv(0);
                    first=0;
               }
               else {
                    qnxbtv();
               }
               gcrbtv(dp,0);
               if (!(dp->flags&DELETE) && dp->polltype == mode) {
                    setmem(tmp,PSSIZ,0);
                    strcpy(tmp," ");
                    strcat(tmp,dp->pname);
                    for (j=strlen(tmp) ; j < PSSIZ ; j++) {
                         tmp[j]=' ';
                    }
                    tmp[PSSIZ-1]='\0';
                    strcpy(&polllst[i*PSSIZ],tmp);
                    i++;
               }
          }
          return(1);
     }
     return(0);
}

int
valuid(
int c,
char *stg)                         /* valid User-ID entry routine          */
{
     stg=stg;
     return(isuidc(c));
}

int
valout(
int c,
char *stg)                         /* check for valid output device        */
{
     switch(c) {
     case '1':
          strcpy(stg,"1");
          break;
     case '2':
          strcpy(stg,"2");
          break;
     case '3':
          strcpy(stg,"3");
          break;
     default:
          return(1);
     }
     return(0);
}

valfil(c)                          /* validate file name                   */
int c;
{
     if (c <= 255 && isprint(c)) {
          return(1);
     }
     return(0);
}

void
lodopt(opt)                        /* load up selected option              */
int opt;
{
     int cnt=0;
     setbtv(sbb);
     if (acqbtv(sp,uid,1)) {
          do {
               setbtv(pbb);
               if (acqbtv(dp,sp->pname,0)) {
                    if (!(dp->flags&DELETE)) {
                         if (opt == cnt++) {
                              rstbtv();
                              return;
                         }
                    }
               }
               rstbtv();
          } while (aqnbtv(sp));
     }
}

void
lodpol(opt,mode)                   /* load up selected p&q                 */
int opt;
int mode;
{
     int cnt=0;
     setbtv(pbb);
     qlobtv(0);
     do {
          gcrbtv(dp,0);
          if (!(dp->flags&DELETE) && dp->polltype == mode) {
               if (opt == cnt++) {
                    rstbtv();
                    return;
               }
          }
     } while (qnxbtv());
}

int
whrout(void)                       /* find out where to put output         */
{
     scn2mem(frzseg(),scrsav3,SCNSIZ);
     strcpy(repchr,"1");
     explodeto(scntbl[1],0,14,37,23,19,8);
     do {
          rstcur();
          if (!(edtval(51,16,sizeof(repchr),repchr,valout,0))) {
               return(0);
          }
     } while(repchr[0] == '\0');
     switch (repchr[0]) {
     case '1':
          outnam[0]='\0';
          pagbrk=17;
          line=-1;
          redir=0;
          break;
     case '2':
          pagbrk=0;
          line=-1;
          strcpy(inpnam,"PRN");
          if ((outf=fopen(inpnam,FOPWA)) == NULL) {
               scn2mem(frzseg(),scrsav2,SCNSIZ);
               explodeto(scntbl[1],44,0,76,3,19,7);
               getchc();
               movmem(scrsav2,frzseg(),SCNSIZ);
               inpnam[0]='\0';
          }
          redir=1;
          break;
     case '3':
          pagbrk=17;
          line=-1;
          if (getfil()) {
               strcpy(outnam,inpnam);
               redir=1;
          }
          else {
               movmem(scrsav3,frzseg(),SCNSIZ);
               inpnam[0]='\0';
               return(0);
          }
          break;
     }
     movmem(scrsav3,frzseg(),SCNSIZ);
     return(1);
}

int
getfil(void)                       /* if out to file, get the file name    */
{
     inpnam[0]='\0';
     scn2mem(frzseg(),scrsav2,SCNSIZ);
     explodeto(scntbl[1],44,8,77,12,22,9);
     do {
          if (!edtval(35,12,sizeof(inpnam),inpnam,valfil,0)) {
               movmem(scrsav2,frzseg(),SCNSIZ);
               return(0);
          }
          if (!rsvnam(inpnam)) {
               if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                    scn2mem(frzseg(),scrsav2,SCNSIZ);
                    explodeto(scntbl[1],44,4,76,7,22,9);
                    getchc();
                    movmem(scrsav2,frzseg(),SCNSIZ);
                    inpnam[0]='\0';
               }
          }
          else {
               scn2mem(frzseg(),scrsav2,SCNSIZ);
               explodeto(scntbl[1],44,4,76,7,22,9);
               getchc();
               movmem(scrsav2,frzseg(),SCNSIZ);
               inpnam[0]='\0';
          }
     } while (inpnam[0] == '\0');
     return(1);
}

static
void
prfsp(char *fmat,...)         /* print to proper places during output */
{
     char buffer[1024];
     char * args;

     args=(char *)&fmat+sizeof(char *);
     vsprintf(buffer,fmat,(va_list)args);
     if (redir) {
          fprintf(outf,"%s",buffer);
     }
     printf("%s",buffer);
}


int
finup(mode)                        /* Hit any key to continue              */
int mode;
{
     int c,savex,savey;

     savex=curcurx();
     savey=curcury();
     setatr(BLKWHT);
     locate(18,23);
     if (mode == 0) {
          printf("<< Hit Any Key to Continue or ESC to abort >>");
     }
     else {
          printf("<<  End of Report Hit Any Key to Continue  >>");
     }
     c=getchc();
     setatr(CYNBLU);
     locate(18,23);
     printf("");
     if (c == ESC) {
          return(0);
     }
     else {
          line=-1;
          locate(savex,savey);
          return(1);
     }
}

void
usrrpt(usr,pq,out)                 /* user report                          */
char *usr, *pq, *out;
{
     char *op=strupr(out);

     fmtuid(usr);
     stzcpy(scomp.uid,usr,UIDSIZ);
     stzcpy(scomp.pname,strupr(pq),PNAMELEN);
     setbtv(sbb);
     if (acqbtv(sp,&scomp,0)) {
          setbtv(pbb);
          if (acqbtv(dp,sp->pname,0)) {
               if (!(dp->flags&DELETE)) {
                    switch(*op) {
                    case 'S':
                         outnam[0]='\0';
                         pagbrk=17;
                         line=-1;
                         redir=0;
                         break;
                    case 'P':
                         pagbrk=0;
                         line=-1;
                         strcpy(inpnam,"PRN");
                         if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                              explodeto(scntbl[1],44,0,76,3,19,7);
                              *op='\0';
                              return;
                         }
                         redir=1;
                         break;
                    case 'F':
                         op++;
                         if (!rsvnam(op)) {
                              if ((outf=fopen(op,FOPWA)) == NULL) {
                                   explodeto(scntbl[1],44,4,76,7,22,9);
                                   delay(500);
                                   *op='\0';
                              }
                              else {
                                   stamp();
                              }
                         }
                         else {
                              explodeto(scntbl[1],44,4,76,7,22,9);
                              delay(500);
                              *op='\0';
                         }
                         strcpy(outnam,op);
                         if (strlen(outnam) > 0) {
                              redir=1;
                         }
                    }
                    dourpt(0);
                    delay(500);
               }
          }
     }
}

void
polrpt(poll,out)                   /* poll report                          */
char *poll, *out;
{
     char *op=strupr(out);

     setbtv(pbb);
     if (acqbtv(dp,strupr(poll),0)) {
          if (!(dp->flags&DELETE)) {
               switch(*op) {
               case 'S':
                    outnam[0]='\0';
                    pagbrk=17;
                    line=-1;
                    redir=0;
                    break;
               case 'P':
                    pagbrk=0;
                    line=-1;
                    strcpy(inpnam,"PRN");
                    if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                         explodeto(scntbl[1],44,0,76,3,19,7);
                         *op='\0';
                         return;
                    }
                    redir=1;
                    break;
               case 'F':
                    op++;
                    if (!rsvnam(op)) {
                         if ((outf=fopen(op,FOPWA)) == NULL) {
                              explodeto(scntbl[1],44,4,76,7,22,9);
                              delay(500);
                              *op='\0';
                         }
                         else {
                              stamp();
                         }
                    }
                    else {
                         explodeto(scntbl[1],44,4,76,7,22,9);
                         delay(500);
                         *op='\0';
                    }
                    strcpy(outnam,op);
                    if (strlen(outnam) > 0) {
                         redir=1;
                    }
               }
               doprpt(0);
               delay(500);
          }
     }

}

void
qusrpt(ques,out)                   /* questionnaire report                 */
char *ques, *out;
{
     char *op=strupr(out);

     setbtv(pbb);
     if (acqbtv(dp,strupr(ques),0)) {
          if (!(dp->flags&DELETE)) {
               switch(*op) {
               case 'S':
                    outnam[0]='\0';
                    pagbrk=17;
                    line=-1;
                    redir=0;
                    break;
               case 'P':
                    pagbrk=0;
                    line=-1;
                    strcpy(inpnam,"PRN");
                    if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                         explodeto(scntbl[1],44,0,76,3,19,7);
                         *op='\0';
                         return;
                    }
                    redir=1;
                    break;
               case 'F':
                    op++;
                    if (!rsvnam(op)) {
                         if ((outf=fopen(op,FOPWA)) == NULL) {
                              explodeto(scntbl[1],44,4,76,7,22,9);
                              delay(500);
                              *op='\0';
                         }
                         else {
                              stamp();
                         }
                    }
                    else {
                         explodeto(scntbl[1],44,4,76,7,22,9);
                         delay(500);
                         *op='\0';
                    }
                    strcpy(outnam,op);
                    if (strlen(outnam) > 0) {
                         redir=1;
                    }
               }
               dosrpt(0);
               delay(500);
          }
     }
}

void
fmtuid(stg)                        /* format User-ID                       */
char *stg;
{
     char *inpptr;
     int space=1,format;

     stripb(stg);
     format=isuplo(stg);
     for (inpptr=stg ; *inpptr != '\0' ; inpptr++) {
          if (format) {
               if (*inpptr == ' ') {
                    space=1;
               }
               else if (space) {
                    *inpptr=toupper(*inpptr);
                    space=0;
               }
               else {
                    *inpptr=tolower(*inpptr);
               }
          }
     }
     while (++inpptr-stg < UIDSIZ) {
          *inpptr='\0';
     }
}

int
isuplo(stg)                        /* is stg formated correctly up/low case*/
char *stg;
{
     char *ptr;

     for (ptr=stg ; *ptr != '\0' ; ptr++) {
          if (isalpha(*ptr) && !islower(*ptr)) {
               break;
          }
     }
     if (*ptr == '\0') {
          return(1);
     }
     for (ptr=stg ; *ptr != '\0' ; ptr++) {
          if (isalpha(*ptr) && !isupper(*ptr)) {
               break;
          }
     }
     if (*ptr == '\0') {
          return(1);
     }
     return(0);
}

void
stripb(stg)                        /* "strip" blank spaces after input     */
char *stg;
{
     int len;
     char *inpptr;

     len=strlen(stg);
     for (inpptr=stg+len-1 ; inpptr >= stg && isspace(*inpptr) ; ) {
          *inpptr--='\0';
     }
}

void
shutdown(void)                     /* system shutdown routine              */
{
     clsbtv(sbb);
     clsbtv(pbb);
     clsbtv(qbb);
     clsbtv(abb);
     clsbtv(tbb);
     fclose(outf);
}

void
stamp(void)                        /* output date and time                 */
{
     fprintf(outf,"%s %s\n",ncdate(today()),nctime(now()));
}

char *
rsltper(num,tot)                   /* results percentage calculation       */
int num,tot;
{
     long comp;


     if (tot == 0) {
          comp=0L;
     }
     else {
          comp=(long)num*1000L/(long)tot;
          comp-=comp/10L*10L;
     }
     return(spr("(%3ld.%1.1ld%%)",tot == 0 ? 0L : (long)num*100L/(long)tot,
                                  tot == 0 ? 0L : comp));
}
