/***************************************************************************
 *                                                                         *
 *   EMLFOR.H                                                              *
 *                                                                         *
 *   Copyright (c) 1988-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   E-mail and Forums shared variable and function definitions            *
 *   (common to both ASCII/ANSI and Client/Server).                        *
 *                                                                         *
 *                                                - J. Alvrus  10/20/94    *
 *                                                                         *
 ***************************************************************************/

                                   /* per-user, non-VDA or per-request     */
#define INEMAIL 0x0001             /*   user is in E-mail (not a Forum)    */
#define INEDIT  0x0002             /*   user is in the editor              */
#define INFTF   0x0004             /*   user is in file transfer           */
#define INFSD   0x0008             /*   user is in full-screen data service*/
#define INEDHLP 0x0010             /*   user is editing forum help message */
#define WRTIPG  0x0020             /*   write in progress on this channel  */

extern
FILE *efmb;                        /* E-mail/Forums CNF options file       */
extern
struct fndblk effb;                /* E-mail/Forums find block (one-shot)  */
extern
struct qscfg *qsptr;               /* current user's quickscan             */
extern
int *peruflg;                      /* per-user, non-VDA flags              */
extern
struct message *msg;               /* current message header structure     */
extern
char *msgtxt,                      /* current message text buffer          */
     *filatt,                      /* current file att path+file name      */
     *abvcmt,                      /* header above comment in message text */
     *blwcmt;                      /* header below comment in message text */
extern
int ccmax;                         /* max # CCs to allow                   */
extern
BOOL alwcpy;                       /* allow user to CC a message           */
extern
void *efwork;                      /* current GME request work area        */
extern
int numscans;                      /* number of scan buffers available     */
extern
struct otscan **usrscn;            /* per-user array of scan buffer ptrs   */

void
iniaa(void);                       /* initialize ASCII/ANSI stuff          */

void
inics(void);                       /* initialize Client/Server stuff       */

struct otscan *                    /*   returns NULL if not available      */
rsvscan(                           /* reserve a scan buffer                */
int unum);                         /*   for this channel                   */

void
unrscan(                           /* unreserve scan buffer                */
int unum);                         /*   for this channel                   */

BOOL                               /*   returns TRUE if recip notified     */
wrtnot(                            /* notify recipient of new mail to them */
char *to,                          /*   to whom the message was written    */
struct message *msg);              /*   message header structure           */

BOOL                               /*   returns TRUE if recip notified     */
cpynot(                            /* notify recipient of copy to them     */
char *to);                         /*   to whom the message was copied     */

BOOL                               /*   returns TRUE if recip notified     */
fwdnot(                            /* notify recipient of fwd to them      */
char *to);                         /*   to whom the message was forwarded  */

BOOL                               /*   returns TRUE if recip notified     */
rrgnot(                            /* notify sender of receipt generation  */
char *to);                         /*   to whom the return receipt was sent*/

char *                             /*   returns copy of pointer to string  */
lf2cr(                             /* change \n to \r in a string          */
char *text);                       /*   string to change                   */

BOOL
valfdfnam(                         /* is this a valid forum data file name?*/
const char *nam);                  /*   file name to change                */

char *                             /*   returns copy of pointer to buffer  */
fixfdfnam(                         /* fix up forum data file name          */
char *nambuf);                     /*   file name buffer (must be MAXPATH) */
