/***************************************************************************
 *                                                                         *
 *   CSFOR.C                                                               *
 *                                                                         *
 *   Copyright (c) 1988-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Worldgroup Client/Server Forums (public messaging areas)  *
 *   handler.                                                              *
 *                                                                         *
 *                                                - J. Alvrus  11/11/94    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "filexfer.h"
#include "gme.h"
#include "galtext.h"
#include "galmsg.h"
#include "emlfor.h"
#include "csef.h"

#define FILREV "$Revision: 1.12 $"

                                   /* forums dynapak suffix-prefixes       */
#define FORINF   "forum "          /*   get basic forum info               */
#define FORDET   "fordet "         /*   get details on a forum             */
#define THRINF   "thread "         /*   get info on a thread               */
#define FORHDR   "forhdr "         /*   get forum msg header               */
#define FORMSG   "formsg "         /*   get forum message                  */
#define THRHDR   "h "              /*   get thread msg header              */
#define THREXC   "e "              /*   get thread msg excerpt             */
#define THRMSG   "m "              /*   get thread message                 */
#define SCNHDR   "scnhdr "         /*   get scan msg header                */
#define SCNMSG   "scnmsg "         /*   get scan message                   */
#define PARHDR   "parhdr "         /*   get parent msg header              */
#define PARMSG   "parmsg "         /*   get parent message                 */
#define UNAHDR   "unahdr "         /*   get header of msg w/unapv att      */
#define UNAMSG   "unamsg "         /*   get message w/unapproved attachment*/
#define MODMSG   "modmsg "         /*   modify forum message               */
#define FWDFOR   "fwdmsg "         /*   forward forum message              */
#define CPYFOR   "cpymsg "         /*   copy forum message                 */
#define INIFOR   "inifor"          /*   create a forum (read and write)    */
#define CRTFOR   "crtfor"          /*   create a forum (read and write)    */
#define MODFOR   "modfor "         /*   modify or delete a forum           */
#define MSGXMT   "msgxmt "         /*   exempt/unexempt a message          */
#define MSGAPV   "msgapv "         /*   approve/unapprove an attachment    */
#define USRACC   "usracc "         /*   get/set user access to a forum     */
#define CPYACC   "cpyacc"          /*   copy user access to all forums     */
#define CFGACC   "cfgacc "         /*   set default access to a forum      */

#define FIECHO   0x0010            /* forum info flag: forum is echoed     */

                                   /* global forum access flags            */
#define GFAOPMOD 0x0001            /*   forum-ops can modify whole forum   */
/*      EAINDATT 0x0020                 make indirect attachments to msgs  */

                                   /* scan init error codes                */
#define SCINVR 0                   /*   can't scan at all                  */
#define SCINOW 1                   /*   can't scan now (no buffers)        */
#define SCINVF 2                   /*   no valid forums in scan            */

STATIC BOOL badaxes(int usraxes,int newaxes,int oldaxes);
STATIC void f_read(int direction,struct saunam *dpknam);
STATIC void f_write(struct saunam *dpknam,unsigned length,void *value);
STATIC void fxdone(void);
STATIC void fabort(void);

struct agent foragt={              /* agent information structure          */
     FORAPID,                      /*   appid                              */
     f_read,                       /*   read-dynapak function pointer      */
     f_write,                      /*   write-dynapak function pointer     */
     fxdone,                       /*   file xfer-done function pointer    */
     fabort                        /*   abort-request function pointer     */
};

struct globfacc {                  /* global forum access structure        */
     int flags;                    /*   global access flags                */
     char dftfor[FORNSZ-1];        /*   default forum name                 */
     int maxscnf;                  /*   max # of forums allowed in scan    */
     long txtlen;                  /*   max message text length            */
     int ccmax;                    /*   max # cc:s per message             */
};

struct basfinf {                   /* basic forum info structure           */
     unsigned forum;               /*   forum ID                           */
     char axes;                    /*   current user's access level        */
     char topic[TPCSIZ];           /*   forum topic                        */
};

struct credfdpk {                  /* create/edit-a-forum dpk structure    */
     int dfnpv;                    /*   default non-priv access setting    */
     int dfprv;                    /*   default priviledged access setting */
     int mxnpv;                    /*   maximum non-priv access setting    */
     int msglif;                   /*   message lifetime (days)            */
     int chgmsg;                   /*   charge per message posted          */
     int chgrdm;                   /*   charge per message read            */
     int chgatt;                   /*   charge per file attachment uploaded*/
     int chgadl;                   /*   charge per file attachment download*/
     int chgupk;                   /*   charge per-kbyte for upload        */
     int chgdpk;                   /*   charge per-kbyte for download      */
     int ccr;                      /*   credit consumption rate            */
     int pfnlvl;                   /*   profanity suppression level        */
     long seqid;                   /*   number of forum in list of forums  */
     int necho;                    /*   number of echo addresses           */
     char info[1];                 /*   variable-length forum info:        */
                                   /*   (forum name, forum topic, forum op,*/
                                   /*   privleged access key, echo         */
                                   /*   addresses (if any), help message,  */
                                   /*   data file (if creating), attachment*/
                                   /*   path (if creating))                */
};

struct viewfdpk {                  /* view-a-forum dpk structure           */
     int forum;                    /*   forum ID                           */
     long nthrs;                   /*   number of threads in forum         */
     long nmsgs;                   /*   number of messages in forum        */
     long nfiles;                  /*   number of files in forum           */
     long nw4app;                  /*   number of files waiting for apprvl */
     int dfnpv;                    /*   default non-privileged access      */
     int dfprv;                    /*   default privileged access setting  */
     int mxnpv;                    /*   maximum non-privileged access      */
     int msglif;                   /*   message lifetime (days)            */
     int chgmsg;                   /*   charge per message posted          */
     int chgrdm;                   /*   charge per message read            */
     int chgatt;                   /*   charge per file attachment uploaded*/
     int chgadl;                   /*   charge per file attachment download*/
     int chgupk;                   /*   charge per-kbyte for upload        */
     int chgdpk;                   /*   charge per-kbyte for download      */
     int ccr;                      /*   credit consumption rate            */
     int pfnlvl;                   /*   profanity suppression level        */
     double crdatim;               /*   forum creation date/time           */
     int necho;                    /*   number of echo addresses           */
     long seqid;                   /*   number of forum in list of forums  */
     char info[1];                 /*   variable-length forum info:        */
                                   /*   (forum name, forum topic, forum op,*/
                                   /*   privileged access key, echo        */
                                   /*   addresses (if any), help message,  */
                                   /*   data file, attachment path)        */
};

struct thrinfo {                   /* info on a thread structure           */
     int nmsgs;                    /*   number of messages in the thread   */
     char topic[TPCSIZ];           /*   thread topic                       */
};

STATIC char *csfkey;               /* key required to use C/S Forums agent */

STATIC void foracinf(struct saunam *dpknam);
STATIC void forinf(int direction,struct saunam *dpknam);
STATIC void getbasinf(struct fordef *fdef,struct basfinf *finf);
STATIC void fordet(struct saunam *dpknam);
STATIC void cpyfdet(struct viewfdpk *dpk,struct fordsk *def,char *desc,
                    adr_t *echoes);
STATIC void thrinf(int direction,struct saunam *dpknam);
STATIC void crdtinf(void);
STATIC void rdtinf(void);
STATIC void rdformsg(int direction,struct saunam *dpknam,BOOL incltxt);
STATIC void crdfmsg(void);
STATIC void rdfmsg(void);
STATIC void rdthrmsg(int direction,struct saunam *dpknam,int flags);
STATIC void crdtmsg(void);
STATIC void rdtmsg(void);
STATIC char *excerpt(char *dst,char *src,unsigned maxlen);
STATIC BOOL isquoted(char *s);
STATIC void iniscan(struct otscan *newscn);
STATIC int remfor(unsigned *forlst,int ninlst,int f2ridx);
STATIC void clsscan(void);
STATIC void rdscnmsg(int direction,struct saunam *dpknam,BOOL incltxt);
STATIC void crdsmsg(void);
STATIC void rdsmsg(void);
STATIC void rdparmsg(struct saunam *dpknam,BOOL incltxt);
STATIC void crdpmsg(void);
STATIC void rdpmsg(void);
STATIC void rdunamsg(int direction,struct saunam *dpknam,BOOL incltxt);
STATIC void crdumsg(void);
STATIC void rdumsg(void);
STATIC void foratt(struct saunam *dpknam);
STATIC BOOL getfms(char *sfx,unsigned *fid,long *mid);
STATIC void initfor(struct saunam *dpknam);
STATIC void crsvfbuf(void);
STATIC void rsvfbuf(void);
STATIC void cgetfdft(void);
STATIC void getfdft(void);
STATIC void fdsk2dpk(struct fordsk *dsk,struct credfdpk *dpk,BOOL inclfil);
STATIC void getuacc(struct saunam *dpknam);
STATIC void csmodmsg(struct saunam *dpknam,char *modtxt);
STATIC void fwdfor(struct saunam *dpknam,char *fwdinf);
STATIC void cpyfor(struct saunam *dpknam,char *cpyinf);
STATIC void delfmsg(struct saunam *dpknam);
STATIC void cscrtfor(struct credfdpk *newdpk);
STATIC void ccreatef(void);
STATIC void createf(void);
STATIC void csdelfor(struct saunam *dpknam);
STATIC void csmodfor(struct saunam *dpknam,struct credfdpk *moddpk);
STATIC BOOL fdpk2dsk(struct credfdpk *dpk,struct fordsk *dsk,BOOL inclfil);
STATIC BOOL fdpk2def(unsigned forum,struct credfdpk *dpk,struct fordef *def,
                     char *info);
STATIC BOOL parsecho(int necho,char *list,char *arr);
STATIC void csxmtmsg(struct saunam *dpknam,BOOL exempt);
STATIC void crd4xmt(void);
STATIC void rd4xmt(void);
STATIC void csapvatt(struct saunam *dpknam,BOOL approve);
STATIC void crd4apv(void);
STATIC void rd4apv(void);
STATIC void setuacc(struct saunam *dpknam,int access);
STATIC void cpyuacc(struct saunam *dpknam,char *srcusr);
STATIC void cscfgac(struct saunam *dpknam,unsigned length,
                    struct foracc *newdfts);

void
inicsfor(void)                     /* initialize Client/Server Forums agent*/
{
     register_agent(&foragt);
     csfkey=stgopt(CSFKEY);
}

STATIC void
f_read(                            /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstr;

     dpkstr=cnvs2d(dpknam);
     if (direction == 0 && sameas("sau:foracc",dpkstr)) {
          if (stdchk(csfkey)) {
               foracinf(dpknam);
          }
          else {
               setmem(rsptmp,sizeof(struct globfacc),0);
               rsp2read(dpknam,sizeof(struct globfacc),rsptmp);
          }
          return;
     }
     if (!stdchk(csfkey)) {
          rejectreq();
          return;
     }
     cssetup();
     if (direction == 0 && sameto("saf:",dpkstr)
      && sameto(FORATT,dpknam->suffix)) {
          foratt(dpknam);
     }
     else if (direction == 0 && sameto("saf:",dpkstr)
      && sameto(LEXDPK,dpknam->suffix)) {
          getlex(dpknam);
     }
     else if (sameto("sau:",dpkstr) && sameto(FORINF,dpknam->suffix)) {
          forinf(direction,dpknam);
     }
     else if (direction == 0 && sameto("sa:",dpkstr)
      && sameto(FORDET,dpknam->suffix)) {
          fordet(dpknam);
     }
     else if (direction >= 0 && sameto("sa:",dpkstr)
      && sameto(THRINF,dpknam->suffix)) {
          thrinf(direction,dpknam);
     }
     else if (sameto("sau:",dpkstr) && sameto(FORHDR,dpknam->suffix)) {
          rdformsg(direction,dpknam,FALSE);
     }
     else if (sameto("sau:",dpkstr) && sameto(FORMSG,dpknam->suffix)) {
          rdformsg(direction,dpknam,TRUE);
     }
     else if (sameto("sau:",dpkstr) && sameto(THRHDR,dpknam->suffix)) {
          rdthrmsg(direction,dpknam,0);
     }
     else if (sameto("sau:",dpkstr) && sameto(THREXC,dpknam->suffix)) {
          rdthrmsg(direction,dpknam,EXCERPT);
     }
     else if (sameto("sau:",dpkstr) && sameto(THRMSG,dpknam->suffix)) {
          rdthrmsg(direction,dpknam,INCLTXT);
     }
     else if (sameto("sau:",dpkstr) && sameto(SCNHDR,dpknam->suffix)) {
          rdscnmsg(direction,dpknam,FALSE);
     }
     else if (sameto("sau:",dpkstr) && sameto(SCNMSG,dpknam->suffix)) {
          rdscnmsg(direction,dpknam,TRUE);
     }
     else if (direction == 0 && sameto("sau:",dpkstr)
      && sameto(PARHDR,dpknam->suffix)) {
          rdparmsg(dpknam,FALSE);
     }
     else if (direction == 0 && sameto("sau:",dpkstr)
      && sameto(PARMSG,dpknam->suffix)) {
          rdparmsg(dpknam,TRUE);
     }
     else if (sameto("sau:",dpkstr) && sameto(UNAHDR,dpknam->suffix)) {
          rdunamsg(direction,dpknam,FALSE);
     }
     else if (sameto("sau:",dpkstr) && sameto(UNAMSG,dpknam->suffix)) {
          rdunamsg(direction,dpknam,TRUE);
     }
     else if (direction == 0 && sameto("sau:",dpkstr)
      && sameas(INIFOR,dpknam->suffix)) {
          initfor(dpknam);
     }
     else if (direction == 0 && samepato("sau:",dpkstr)
      && sameto(USRACC,dpknam->suffix)) {
          getuacc(dpknam);
     }
     else {
          rejectreq();
     }
}

STATIC void
f_write(                           /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *dpkstr;

     dpkstr=cnvs2d(dpknam);
     if (!stdchk(csfkey)) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     cssetup();
     if (length > 0 && sameto("saf:",dpkstr)
      && sameto(UPLATT,dpknam->suffix)) {
          ASSERT(length == sizeof(struct filinf));
          uplatt(dpknam,(struct filinf *)value);
     }
     else if (sameto("sa:",dpkstr) && sameas(WRTNEW,dpknam->suffix)) {
          wrtnew(dpknam,(struct newdpk *)value);
     }
     else if (sameto("sa:",dpkstr) && sameas(WRTRPL,dpknam->suffix)) {
          wrtrpl(dpknam,(struct newdpk *)value);
     }
     else if (sameto("sa:",dpkstr) && sameto(CCLSFX,dpknam->suffix)) {
          gcclst(dpknam,unpad((char *)value));
     }
     else if (length >= (sizeof(struct otscan)-sizeof(unsigned))
           && sameas("sau:iniscn",dpkstr)) {
          iniscan((struct otscan *)value);
     }
     else if (sameas("sau:clsscn",dpkstr)) {
          clsscan();
     }
     else if (sameto("sa:",dpkstr) && sameto(MODMSG,dpknam->suffix)) {
          if (length == 0) {
               delfmsg(dpknam);
          }
          else {
               csmodmsg(dpknam,unpad((char *)value));
          }
     }
     else if (length > 0 && sameto("sa:",dpkstr)
      && sameto(FWDFOR,dpknam->suffix)) {
          fwdfor(dpknam,unpad((char *)value));
     }
     else if (length > 0 && sameto("sa:",dpkstr)
      && sameto(CPYFOR,dpknam->suffix)) {
          cpyfor(dpknam,unpad((char *)value));
     }
     else if (length >= sizeof(struct credfdpk)-1 && sameto("sa:",dpkstr)
      && sameas(CRTFOR,dpknam->suffix)) {
          cscrtfor((struct credfdpk *)value);
     }
     else if (sameto("sa:",dpkstr) && sameto(MODFOR,dpknam->suffix)) {
          if (length == 0) {
               csdelfor(dpknam);
          }
          else if (length >= sizeof(struct credfdpk)-1) {
               csmodfor(dpknam,(struct credfdpk *)value);
          }
     }
     else if (length == sizeof(BOOL) && sameto("sa:",dpkstr)
      && sameto(MSGXMT,dpknam->suffix)) {
          csxmtmsg(dpknam,*(BOOL *)value);
     }
     else if (length == sizeof(BOOL) && sameto("sa:",dpkstr)
      && sameto(MSGAPV,dpknam->suffix)) {
          csapvatt(dpknam,*(BOOL *)value);
     }
     else if (length == sizeof(int) && samepato("sau:",dpkstr)
      && sameto(USRACC,dpknam->suffix)) {
          setuacc(dpknam,*(int *)value);
     }
     else if (length > 0 && samepato("sau:",dpkstr)
      && sameto(CPYACC,dpknam->suffix)) {
          cpyuacc(dpknam,unpad((char *)value));
     }
     else if (length >= sizeof(struct foracc)-KEYSIZ && sameto("sa:",dpkstr)
      && sameto(CFGACC,dpknam->suffix)) {
          cscfgac(dpknam,length,(struct foracc *)value);
     }
     else {
          rsp2write(FALSE,0,NULL);
     }
}

STATIC void
fxdone(void)                       /* file transfer-done handler           */
{
     cssetup();
     if (iswrite()) {
          if (sameto(UPLATT,rqiptr->dpknam.suffix)) {
               uladone();
          }
     }
     else {
          if (sameto(FORATT,rqiptr->dpknam.suffix)) {
               dldone(rqiptr->u.tag);
          }
     }
}

STATIC void
fabort(void)                       /* abort-request handler                */
{
     cssetup();
     if (sameto(FORATT,rqiptr->dpknam.suffix)) {
          if (rqiptr->stt == 0) {
               clsgmerq(efwork);
          }
          else {
               dlabt(rqiptr->u.tag);
          }
     }
     else if (sameas(WRTNEW,rqiptr->dpknam.suffix)
           || sameas(WRTRPL,rqiptr->dpknam.suffix)) {
          wrtabt();
     }
     else if (sameto(UPLATT,rqiptr->dpknam.suffix)) {
          uplabt();
     }
     else {
          if (gmerqopn(efwork)) {
               clsgmerq(efwork);
          }
          if (rqiptr->flags&BUFINU) {
               unrarea(wrmpool,rqiptr->wrthdl);
          }
     }
}

STATIC void
foracinf(                          /* get generic Forum access/info        */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     ASSERT(getfnm(dftfor) != NULL);
     ((struct globfacc *)rsptmp)->flags=fopmfd ? GFAOPMOD : 0;
     if (haskey(fprlock)) {
          ((struct globfacc *)rsptmp)->flags|=EAINDATT;
     }
     c2bcpy(((struct globfacc *)rsptmp)->dftfor,getfnm(dftfor),FORNSZ-1);
     ((struct globfacc *)rsptmp)->maxscnf=MAXQSF;
     ((struct globfacc *)rsptmp)->txtlen=(long)(TXTLEN-1);
     if (alwcpy) {
          ((struct globfacc *)rsptmp)->ccmax=usrptr->flags&MASTER ? -1 : csmaxcc;
     }
     else {
          ((struct globfacc *)rsptmp)->ccmax=0;
     }
     rsp2read(dpknam,sizeof(struct globfacc),rsptmp);
}

STATIC void
forinf(                            /* get basic info on a Forum            */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     unsigned fid;
     struct fordef *tmpdef;

     ASSERT(sameto(FORINF,dpknam->suffix));
     if (direction == 0) {
          fid=getfid(&dpknam->suffix[sizeof(FORINF)-1]);
          if (fid != EMLID && foracc(fid) >= RDAXES) {
               getbasinf(getdefp(fid),(struct basfinf *)rsptmp);
               rsp2read(dpknam,sizeof(struct basfinf)-TPCSIZ
                              +strlen(((struct basfinf *)rsptmp)->topic),
                        rsptmp);
               return;
          }
     }
     else if (direction > 0) {
          tmpdef=nxtdefp(&dpknam->suffix[sizeof(FORINF)-1]);
          while (tmpdef != NULL && foracc(tmpdef->forum) < RDAXES) {
               tmpdef=nxtdefp(tmpdef->name);
          }
          if (tmpdef != NULL) {
               getbasinf(tmpdef,(struct basfinf *)rsptmp);
               *namtmp=*dpknam;
               sprintf(namtmp->suffix,"%s%s",FORINF,tmpdef->name);
               rsp2read(namtmp,sizeof(struct basfinf)-TPCSIZ
                              +strlen(((struct basfinf *)rsptmp)->topic),
                        rsptmp);
               return;
          }
     }
     else if (direction < 0) {
          tmpdef=prvdefp(&dpknam->suffix[sizeof(FORINF)-1]);
          while (tmpdef != NULL && foracc(tmpdef->forum) < RDAXES) {
               tmpdef=prvdefp(tmpdef->name);
          }
          if (tmpdef != NULL) {
               getbasinf(tmpdef,(struct basfinf *)rsptmp);
               *namtmp=*dpknam;
               sprintf(namtmp->suffix,"%s%s",FORINF,tmpdef->name);
               rsp2read(namtmp,sizeof(struct basfinf)-TPCSIZ
                              +strlen(((struct basfinf *)rsptmp)->topic),
                        rsptmp);
               return;
          }
     }
     rejectreq();
}

STATIC void
getbasinf(                         /* get basic info on forum              */
struct fordef *fdef,               /*   from full forum def structure      */
struct basfinf *finf)              /*   into basic info structure          */
{
     finf->forum=fdef->forum;
     finf->axes=(char)foracc(fdef->forum);
     if (fdef->necho > 0) {
          finf->axes|=FIECHO;
     }
     stlcpy(finf->topic,fdef->topic,TPCSIZ);
}

STATIC void
fordet(                            /* get details on a Forum               */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     unsigned fid;
     char *desc;
     adr_t *echoes;
     struct fordsk *tmpdef;

     ASSERT(dpknam != NULL);
     ASSERT(sameto(FORDET,dpknam->suffix));
     fid=getfid(&dpknam->suffix[sizeof(FORDET)-1]);
     if (fid != EMLID && foracc(fid) > NOAXES) {
          tmpdef=(struct fordsk *)vdatmp;
          echoes=(adr_t *)tmpdef->info;
          desc=(char *)echoes[getdefp(fid)->necho];
          getallf(fid,tmpdef,desc,(char *)echoes);
          cpyfdet((struct viewfdpk *)rsptmp,tmpdef,desc,echoes);
          rsp2read(dpknam,sizeof(struct viewfdpk)-1
                         +strlen(((struct viewfdpk *)rsptmp)->info),
                   rsptmp);
          return;
     }
     rejectreq();
}

STATIC void
cpyfdet(                           /* copy forum details to dpk form       */
struct viewfdpk *dpk,              /*   dynapak structure buffer           */
struct fordsk *def,                /*   forum header                       */
char *desc,                        /*   forum description/help message     */
adr_t *echoes)                     /*   array of echo addresses            */
{
     int i;
     char *cp;

     dpk->forum=def->forum;
     dpk->nthrs=def->nthrs;
     dpk->nmsgs=def->nmsgs;
     dpk->nfiles=def->nfiles;
     dpk->nw4app=def->nw4app;
     dpk->dfnpv=def->dfnpv;
     dpk->dfprv=def->dfprv;
     dpk->mxnpv=def->mxnpv;
     dpk->msglif=def->msglif;
     dpk->chgmsg=def->chgmsg;
     dpk->chgrdm=def->chgrdm;
     dpk->chgatt=def->chgatt;
     dpk->chgadl=def->chgadl;
     dpk->chgupk=def->chgupk;
     dpk->chgdpk=def->chgdpk;
     dpk->ccr=def->ccr;
     dpk->pfnlvl=def->pfnlvl;
     dpk->crdatim=d2vdat(def->crdate,def->crtime);
     dpk->necho=def->necho;
     dpk->seqid=def->seqid;
     stlcpy(dpk->info,def->name,FORNSZ);
     cp=dpk->info+strlen(dpk->info);
     *cp++=FLDSEP;
     stlcpy(cp,def->topic,TPCSIZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,def->forop,UIDSIZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,def->forlok,KEYSIZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     for (i=0 ; i < def->necho ; ++i) {
          if (i != 0) {
               *cp++=';';
          }
          stlcpy(cp,echoes[i],MAXADR);
          cp+=strlen(cp);
     }
     *cp++=FLDSEP;
     lf2cr(desc);
     if (desc[0] == '\r') {
          ++desc;
     }
     stpans(desc);
     i=strlen(def->attpath)+strlen(def->datfil)+2;
     i=(MAXDPKV-sizeof(struct viewfdpk))-(int)(cp-dpk->info)-i;
     if (strlen(desc) > i) {
          desc[i]='\0';
     }
     strcpy(cp,desc);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     strcpy(cp,def->attpath);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     strcpy(cp,def->datfil);
}

STATIC void
thrinf(                            /* get info on a thread                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     unsigned forum;
     unsigned long thrid;
     char *cp;

     forum=getfid(itemidxd(dpknam->suffix,1," "));
     if (forum == EMLID || foracc(forum) < RDAXES) {
          rejectreq();
          return;
     }
     thrid=0L;
     cp=itemidxd(dpknam->suffix,2," ");
     if (strlen(cp) > 10 || (strlen(cp) > 0 && !lsfxval(&thrid,cp))) {
          rejectreq();
          return;
     }
     if (cp[0] == '0' && thrid == 0xFFFFFFFFL) {
          thrid=0L;
     }
     rqiptr->dpknam=*dpknam;
     inigmerq(efwork);
     rqiptr->stt=(signed char)direction;
     inormrd(efwork,usaptr->userid,forum,FIRSTM);
     thrctx(efwork,thrid);
     rdtinf();
}

STATIC void
crdtinf(void)                      /* cycled read message for thread info  */
{
     cssetup();
     cycleme(NULL);
     rdtinf();
}

STATIC void
rdtinf(void)                       /* read message for thread info         */
{
     unsigned nmsgs;

     msg=(struct message *)vdatmp;
     switch (thrinfo(efwork,(int)rqiptr->stt,&nmsgs,msg,(char *)rsptmp)) {
     case GMEAGAIN:
          cycleme(crdtinf);
          return;
     case GMEOK:
          stlcpy(((struct thrinfo *)rsptmp)->topic,msg->topic,TPCSIZ);
          ((struct thrinfo *)rsptmp)->nmsgs=nmsgs;
          *namtmp=rqiptr->dpknam;
          if (rqiptr->stt != 0) {
               sprintf(namtmp->suffix,"%s%s %010lu",
                       THRINF,getfnm(msg->forum),msg->thrid);
          }
          rsp2read(namtmp,sizeof(struct thrinfo)-TPCSIZ
                         +strlen(((struct thrinfo *)rsptmp)->topic),rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
}

STATIC void
rdformsg(                          /* fire up forum message read process   */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam,             /*   dynapak name to read               */
BOOL incltxt)                      /*   TRUE=whole message, FALSE=header   */
{
     unsigned forum;
     long msgid;

     ASSERT(dpknam != NULL);
     if (!getfms(dpknam->suffix,&forum,&msgid)) {
          rejectreq();
          return;
     }
     rqiptr->dpknam=*dpknam;
     rqiptr->stt=(signed char)direction;
     if (incltxt) {
          rqiptr->flags|=INCLTXT;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     rdfmsg();
}

STATIC void
crdfmsg(void)                      /* cycled read forum message            */
{
     cssetup();
     cycleme(NULL);
     rdfmsg();
}

STATIC void
rdfmsg(void)                       /* read forum message                   */
{

     vdamsg();
     switch (readir(rqiptr->stt,efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(crdfmsg);
          return;
     case GMEOK:
          if ((rqiptr->flags&INCLTXT) && forreal()
           && markreadf(efwork,msg,msgtxt) != GMEOK) {
               rejectreq();
               break;
          }
          *namtmp=rqiptr->dpknam;
          if (rqiptr->stt != 0) {
               sprintf(&namtmp->suffix[sizeof(FORMSG)-1],"%s %010ld",
                       getfnm(msg->forum),msg->msgid);
          }
          msg2dpk(msg,msgtxt,(struct msgdpk *)rsptmp,rqiptr->flags&INCLTXT);
          ((struct msgdpk *)rsptmp)->axes=(char)foracc(msg->forum);
          rsp2read(namtmp,sizeof(struct msgdpk)
                         +strlen(((struct msgdpk *)rsptmp)->info)-1,rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
}

STATIC void
rdthrmsg(                          /* fire up msg-in-thread read process   */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam,             /*   dynapak name to read               */
int flags)                         /*   dynapak type flags                 */
{                                  /*   0=header, INCLTXT=whole, EXCERPT   */
     unsigned forum;
     unsigned long thrid;
     long msgid;
     char *cp;

     if (itemcntd(dpknam->suffix," ") < 3) {
          rejectreq();
          return;
     }
     forum=getfid(itemidxd(dpknam->suffix,1," "));
     if (forum == EMLID || foracc(forum) < RDAXES) {
          rejectreq();
          return;
     }
     thrid=0L;
     cp=itemidxd(dpknam->suffix,2," ");
     if (strlen(cp) > 10 || !lsfxval(&thrid,cp)) {
          rejectreq();
          return;
     }
     if (cp[0] == '0' && thrid == 0xFFFFFFFFL) {
          thrid=0L;
     }
     msgid=0L;
     cp=itemidxd(dpknam->suffix,3," ");
     if (strlen(cp) > 10
      || (strlen(cp) > 0 && !lsfxval((unsigned long *)&msgid,cp))) {
          rejectreq();
          return;
     }
     if (msgid < 0L) {
          msgid=0L;
     }
     rqiptr->dpknam=*dpknam;
     rqiptr->stt=(signed char)direction;
     rqiptr->flags=flags;
     inigmerq(efwork);
     inictx(efwork,usaptr->userid,FSQTHR,forum,msgid,thrid);
     rdtmsg();
}

STATIC void
crdtmsg(void)                      /* cycled read message in a thread      */
{
     cssetup();
     cycleme(NULL);
     rdtmsg();
}

STATIC void
rdtmsg(void)                       /* read message in a thread             */
{
     char *cp;

     vdamsg();
     switch (readir(rqiptr->stt,efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(crdtmsg);
          return;
     case GMEOK:
          if ((rqiptr->flags&INCLTXT) && forreal()
           && markreadf(efwork,msg,msgtxt) != GMEOK) {
               rejectreq();
               break;
          }
          *namtmp=rqiptr->dpknam;
          if (rqiptr->stt != 0) {
               sprintf(&namtmp->suffix[sizeof(THRMSG)-1],"%s %010lu %010ld",
                       getfnm(msg->forum),msg->thrid,msg->msgid);
          }
          if (rqiptr->flags&EXCERPT) {
               if (isfmtted(msgtxt)) {
                    if (stripfmt(msgtxt,rsptmp,TXTLEN)) {
                         stlcpy(msgtxt,rsptmp,TXTLEN);
                    }
               }
          }
          msg2dpk(msg,msgtxt,(struct msgdpk *)rsptmp,rqiptr->flags&INCLTXT);
          ((struct msgdpk *)rsptmp)->axes=(char)foracc(msg->forum);
          if (rqiptr->flags&EXCERPT) {
               cp=strchr(((struct msgdpk *)rsptmp)->info,FLDSEP);
               ASSERT(cp != NULL);
               cp=strchr(++cp,FLDSEP);
               ASSERT(cp != NULL);
               excerpt(++cp,lf2cr(msgtxt),TPCSIZ+HSTSIZ-1);
          }
          rsp2read(namtmp,sizeof(struct msgdpk)
                         +strlen(((struct msgdpk *)rsptmp)->info)-1,rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
}

STATIC char *                      /*   returns copy of dst                */
excerpt(                           /* generate an "excerpt" of a message   */
char *dst,                         /*   buffer to fill in                  */
char *src,                         /*   source buffer (message text)       */
unsigned maxlen)                   /*   maximum size of filled-in dst      */
{                                  /*   NOTE: assumes EOLs are \r          */
     int i;
     BOOL lastsp;
     char *cp;

     cp=src;
     do {
          while (*src <= ' ' && *src != '\0') {
               ++src;
          }
          if (isquoted(src)) {
               if ((cp=strchr(src,'\r')) == NULL) {
                    break;
               }
               src=cp+1;
          }
          else {
               break;
          }
     } while (*src != '\0');
     for (cp=dst,i=0,lastsp=FALSE ; i < maxlen && *src != '\0' ; ++i,++src) {
          if (*src <= ' ') {
               if (!lastsp) {
                    *cp++=' ';
               }
               lastsp=TRUE;
          }
          else {
               *cp++=*src;
               lastsp=FALSE;
          }
     }
     *cp='\0';
     return(dst);
}

STATIC BOOL
isquoted(                          /* does line start with quote symbol?   */
char *s)                           /*   pointer to start of line           */
{
     if (isalnum(*s)) {
          ++s;
          if (isalnum(*s)) {
               ++s;
          }
     }
     return(strchr("<>{}[]|:",*s) != NULL);
}

STATIC void
iniscan(                           /* init one-time scan for this channel  */
struct otscan *newscn)             /*   new scan buffer to use             */
{
     int i,j;
     unsigned tmpfid;
     char *cp,ifnm[FORNSZ];

     if (numscans == 0) {
          *(int *)rsptmp=SCINVR;
          rsp2write(FALSE,sizeof(int),rsptmp);
          return;
     }
     if (newscn->nforums < 0 || newscn->nforums > MAXQSF) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (usrscn[usrnum] == NULL) {
          usrscn[usrnum]=rsvscan(usrnum);
          if (usrscn[usrnum] == NULL) {
               *(int *)rsptmp=SCINOW;
               rsp2write(FALSE,sizeof(int),rsptmp);
               return;
          }
     }
     for (i=0 ; i < newscn->nforums ; ) {
          if (!fidxst(newscn->forlst[i]) || !faccok(newscn->forlst[i])) {
               newscn->nforums=remfor(newscn->forlst,newscn->nforums,i);
          }
          else {
               ++i;
          }
     }
     for (i=0 ; i < newscn->nforums ; i++) {
          cp=getfnm(newscn->forlst[i]);
          ASSERT(cp != NULL);
          stlcpy(ifnm,cp,FORNSZ);
          for (j=i+1 ; j < newscn->nforums ; j++) {
               cp=getfnm(newscn->forlst[j]);
               ASSERT(cp != NULL);
               if (stricmp(cp,ifnm) < 0) {
                    tmpfid=newscn->forlst[i];
                    newscn->forlst[i]=newscn->forlst[j];
                    newscn->forlst[j]=tmpfid;
                    stlcpy(ifnm,cp,FORNSZ);
               }
          }
     }
     if (!(newscn->flags&SCALL) && newscn->nforums == 0) {
          *(int *)rsptmp=SCINVF;
          rsp2write(FALSE,sizeof(int),rsptmp);
          return;
     }
     movmem(newscn,usrscn[usrnum],sizeof(struct otscan)
                                 +sizeof(unsigned)*(newscn->nforums-1));
     b2ccvt(usrscn[usrnum]->keywds,MAXSKWD);
     rsp2write(TRUE,0,NULL);
}

STATIC int                         /*   returns new # forums in list       */
remfor(                            /* remove forum ID from list            */
unsigned *forlst,                  /*   list of forum IDs                  */
int ninlst,                        /*   number of forums currently in list */
int f2ridx)                        /*   index of forum to remove           */
{
     ASSERT(forlst != NULL);
     ASSERT(ninlst != 0);
     ASSERT(0 <= f2ridx && f2ridx < ninlst);
     if (f2ridx < ninlst-1) {
          movmem(&forlst[f2ridx+1],&forlst[f2ridx],
                 sizeof(unsigned)*(ninlst-f2ridx-1));
     }
     return(ninlst-1);
}

STATIC void
clsscan(void)                      /* shut down one-time scan for channel  */
{
     if (usrscn[usrnum] == NULL) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     unrscan(usrnum);
     usrscn[usrnum]=NULL;
     rsp2write(TRUE,0,NULL);
}

STATIC void
rdscnmsg(                          /* fire up scan msg read process        */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam,             /*   dynapak name to read               */
BOOL incltxt)                      /*   TRUE=whole message, FALSE=header   */
{
     int i;
     unsigned forum;
     long msgid,tmpmid;
     struct otscan *tmpscn;
     char *cp;

     if (usrscn[usrnum] == NULL) {
          rejectreq();
          return;
     }
     tmpscn=usrscn[usrnum];
     msgid=FIRSTM;
     cp=itemidxd(dpknam->suffix,1," ");
     if (*cp == '\0') {
          forum=fstscnf(usaptr->userid,tmpscn);
          if (forum == EMLID) {
               rejectreq();
               return;
          }
     }
     else {
          if (!getfms(dpknam->suffix,&forum,&msgid)) {
               rejectreq();
               return;
          }
          for (i=0 ; i < tmpscn->nforums && forum != tmpscn->forlst[i] ; ++i) {
          }
          if ((i >= tmpscn->nforums && !(tmpscn->flags&SCALL))
           || (i < tmpscn->nforums && (tmpscn->flags&SCALL))) {
               rejectreq();
               return;
          }
     }
     tmpmid=fstscnm(usaptr->userid,tmpscn,forum);
     if (msgid < tmpmid) {
          msgid=tmpmid;
     }
     rqiptr->dpknam=*dpknam;
     rqiptr->stt=(signed char)direction;
     if (incltxt) {
          rqiptr->flags|=INCLTXT;
     }
     inigmerq(efwork);
     setscan(efwork,tmpscn);
     inictx(efwork,usaptr->userid,FSQSCN,forum,msgid,0L);
     rdsmsg();
}

STATIC void
crdsmsg(void)                      /* cycled read message in a scan        */
{
     cssetup();
     cycleme(NULL);
     rdsmsg();
}

STATIC void
rdsmsg(void)                       /* read message in a scan               */
{
     vdamsg();
     switch (readir(rqiptr->stt,efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(crdsmsg);
          return;
     case GMEOK:
          if ((rqiptr->flags&INCLTXT) && forreal()
           && markreadf(efwork,msg,msgtxt) != GMEOK) {
               rejectreq();
               break;
          }
          *namtmp=rqiptr->dpknam;
          if (rqiptr->stt != 0) {
               sprintf(&namtmp->suffix[sizeof(SCNMSG)-1],"%s %010ld",
                       getfnm(msg->forum),msg->msgid);
          }
          msg2dpk(msg,msgtxt,(struct msgdpk *)rsptmp,rqiptr->flags&INCLTXT);
          ((struct msgdpk *)rsptmp)->axes=(char)foracc(msg->forum);
          rsp2read(namtmp,sizeof(struct msgdpk)
                         +strlen(((struct msgdpk *)rsptmp)->info)-1,rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
}

STATIC void
rdparmsg(                          /* read parent of a forum message       */
struct saunam *dpknam,             /*   dpk name to read                   */
BOOL incltxt)                      /*   TRUE=whole message, FALSE=header   */
{
     unsigned forum;
     long msgid;

     ASSERT(sameto(PARMSG,dpknam->suffix));
     if (!getfms(dpknam->suffix,&forum,&msgid)) {
          rejectreq();
          return;
     }
     rqiptr->dpknam=*dpknam;
     if (incltxt) {
          rqiptr->flags|=INCLTXT;
     }
     rqiptr->dpknam=*dpknam;
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     rdpmsg();
}

STATIC void
crdpmsg(void)                      /* cycled read-parent-message           */
{
     cssetup();
     rdpmsg();
}

STATIC void
rdpmsg(void)                       /* read parent of a message             */
{
     vdamsg();
     switch (*(int *)rsptmp=readparf(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(crdpmsg);
          return;
     case GMEOK:
          if ((rqiptr->flags&INCLTXT) && forreal()
           && markreadf(efwork,msg,msgtxt) != GMEOK) {
               rejectreq();
               break;
          }
          msg2dpk(msg,msgtxt,(struct msgdpk *)rsptmp,rqiptr->flags&INCLTXT);
          ((struct msgdpk *)rsptmp)->axes=(char)foracc(msg->forum);
          rsp2read(&rqiptr->dpknam,
                 sizeof(struct msgdpk)+strlen(((struct msgdpk *)rsptmp)->info),
                 rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
}

STATIC void
rdunamsg(                          /* fire up forum message read process   */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam,             /*   dynapak name to read               */
BOOL incltxt)                      /*   TRUE=whole message, FALSE=header   */
{
     unsigned forum;
     long msgid;

     if (!getfms(dpknam->suffix,&forum,&msgid) || foracc(forum) < OPAXES) {
          rejectreq();
          return;
     }
     rqiptr->dpknam=*dpknam;
     rqiptr->stt=(signed char)direction;
     if (incltxt) {
          rqiptr->flags|=INCLTXT;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     rdumsg();
}

STATIC void
crdumsg(void)                      /* cycled read message w/unapv att      */
{
     cssetup();
     cycleme(NULL);
     rdumsg();
}

STATIC void
rdumsg(void)                       /* read message w/unapproved attachment */
{
     vdamsg();
     switch (readir(rqiptr->stt,efwork,msg,msgtxt)) {
     case GMEOK:
          if ((msg->flags&FILATT) && !(msg->flags&FILAPV)) {
               if ((rqiptr->flags&INCLTXT) && forreal()
                && markreadf(efwork,msg,msgtxt) != GMEOK) {
                    rejectreq();
                    break;
               }
               *namtmp=rqiptr->dpknam;
               if (rqiptr->stt != 0) {
                    sprintf(&namtmp->suffix[sizeof(UNAMSG)-1],"%s %010ld",
                            getfnm(msg->forum),msg->msgid);
               }
               msg2dpk(msg,msgtxt,(struct msgdpk *)rsptmp,
                       rqiptr->flags&INCLTXT);
               ((struct msgdpk *)rsptmp)->axes=(char)foracc(msg->forum);
               rsp2read(namtmp,sizeof(struct msgdpk)
                              +strlen(((struct msgdpk *)rsptmp)->info)-1,
                        rsptmp);
               break;
          }
          if (rqiptr->stt == 0) {
               rejectreq();
               break;
          }
     case GMEAGAIN:
          cycleme(crdumsg);
          return;
     default:
          rejectreq();
          break;
     }
     clsgmerq(efwork);
}

STATIC void
foratt(                            /* get attachment to Forum message      */
struct saunam *dpknam)             /*   dynapak name in use                */
{
     unsigned forum;
     long msgid;

     if (!getfms(dpknam->suffix,&forum,&msgid)) {
          rejectreq();
          return;
     }
     if (foracc(forum) < DLAXES) {
          rejectreq();
          return;
     }
     rqiptr->stt=0;
     rqiptr->dpknam=*dpknam;
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     rd4att();
}

STATIC BOOL                        /*   returns TRUE if got OK             */
getfms(                            /* get forum ID & msg ID from dpk suffix*/
char *sfx,                         /*   dynapak suffix                     */
unsigned *fid,                     /*   buffer for forum ID                */
long *mid)                         /*   buffer for message ID              */
{                                  /* (forum must be present, msg # optnl) */
     char *cp;

     if (itemcntd(sfx," ") < 2) {
          return(FALSE);
     }
     *mid=0L;
     cp=itemidxd(sfx,2," ");
     if (strlen(cp) > 10
      || (strlen(cp) > 0 && !lsfxval((unsigned long *)mid,cp))) {
          return(FALSE);
     }
     if (*mid < 0L) {
          *mid=0L;
     }
     *fid=getfid(itemidxd(sfx,1," "));
     return(*fid != EMLID && foracc(*fid) >= RDAXES);
}

STATIC void
initfor(                           /* initialize forum def with defaults   */
struct saunam *dpknam)             /*   dpk name in use                    */
{
     inigmerq(efwork);
     rqiptr->dpknam=*dpknam;
     rsvfbuf();
}

STATIC void
crsvfbuf(void)                     /* cycled reserve buffer for forum init */
{
     cssetup();
     cycleme(NULL);
     rsvfbuf();
}

STATIC void
rsvfbuf(void)                      /* reserve pool buffer for forum init   */
{
     rqiptr->wrthdl=rsvarea(wrmpool);
     if (rqiptr->wrthdl == NOHDL) {
          cycleme(crsvfbuf);
     }
     else {
          rqiptr->flags|=BUFINU;
          getfdft();
     }
}

STATIC void
cgetfdft(void)                     /* cycled get forum defaults process    */
{
     cssetup();
     cycleme(NULL);
     getfdft();
}

STATIC void
getfdft(void)                      /* get forum defaults                   */
{
     struct fordsk *tmpdef;

     tmpdef=areaptr(wrmpool,rqiptr->wrthdl);
     switch (inifdef(efwork,tmpdef)) {
     case GMEAGAIN:
          cycleme(cgetfdft);
          return;
     case GMEOK:
          fdsk2dpk(tmpdef,(struct credfdpk *)rsptmp,TRUE);
          rsp2read(&rqiptr->dpknam,
               sizeof(struct credfdpk)
                    +strlen(((struct credfdpk *)rsptmp)->info)-1,
               rsptmp);
          break;
     default:
          rejectreq();
          break;
     }
     unrarea(wrmpool,rqiptr->wrthdl);
}

STATIC void
fdsk2dpk(                          /* copy forum on-disk struct to dpk     */
struct fordsk *dsk,                /*   on-disk structure                  */
struct credfdpk *dpk,              /*   in-dynapak structure               */
BOOL inclfil)                      /*   include file name/path info        */
{
     int i;
     char *cp;
     adr_t *tmpecho;

     dpk->dfnpv=dsk->dfnpv;
     dpk->dfprv=dsk->dfprv;
     dpk->mxnpv=dsk->mxnpv;
     dpk->msglif=dsk->msglif;
     dpk->chgmsg=dsk->chgmsg;
     dpk->chgrdm=dsk->chgrdm;
     dpk->chgatt=dsk->chgatt;
     dpk->chgadl=dsk->chgadl;
     dpk->chgupk=dsk->chgupk;
     dpk->chgdpk=dsk->chgdpk;
     dpk->ccr=dsk->ccr;
     dpk->pfnlvl=(int)dsk->pfnlvl;
     dpk->seqid=(long)dsk->seqid;
     dpk->necho=dsk->necho;
     cp=dpk->info;
     stlcpy(cp,dsk->name,FORNSZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,dsk->topic,TPCSIZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,dsk->forop,UIDSIZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     stlcpy(cp,dsk->forlok,KEYSIZ);
     cp+=strlen(cp);
     *cp++=FLDSEP;
     tmpecho=(adr_t *)dsk->info;
     for (i=0 ; i < dsk->necho ; ++i) {
          if (i > 0) {
               *cp++=';';
          }
          stlcpy(cp,tmpecho[i],MAXADR);
          cp+=strlen(cp);
     }
     *cp++=FLDSEP;
     stlcpy(cp,&dsk->info[dsk->necho*MAXADR],MAXFDV-dsk->necho*MAXADR);
     if (inclfil) {
          cp+=strlen(cp);
          *cp++=FLDSEP;
          stlcpy(cp,dsk->attpath,MAXDIR);
          cp+=strlen(cp);
          *cp++=FLDSEP;
          stlcpy(cp,dsk->datfil,MAXPATH);
     }
}

STATIC void
getuacc(                           /* set access for a user                */
struct saunam *dpknam)             /*   dynapak name in use                */
{
     unsigned forum;

     forum=getfid(&dpknam->suffix[sizeof(USRACC)-1]);
     if (forum == EMLID) {
          rejectreq();
          return;
     }
     if (foracc(forum) < OPAXES) {
          rejectreq();
          return;
     }
     if (!uidxst(dpknam->usrid)) {
          rejectreq();
          return;
     }
     *(int *)rsptmp=gforac(dpknam->usrid,forum);
     rsp2read(dpknam,sizeof(int),rsptmp);
}

STATIC void
csmodmsg(                          /* modify a message                     */
struct saunam *dpknam,             /*   dynapak name in use                */
char *modtxt)                      /*   new topic and text                 */
{
     unsigned forum;
     long msgid;
     char *cp;

     ASSERT(sameto(MODMSG,dpknam->suffix));
     *((char *)vdatmp)='\0';
     if (sscanf(&dpknam->suffix[sizeof(MODMSG)-1],"%s %U",
                (char *)vdatmp,&msgid) < 2) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     forum=getfid((char *)vdatmp);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (foracc(forum) < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     msg=(struct message *)vdatmp;
     cp=strchr(modtxt,FLDSEP);
     if (cp == NULL) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     *cp='\0';
     stlcpy(msg->topic,modtxt,TPCSIZ);
     if (isfmtted(cp+1)) {
          ++cp;
     }
     else {
          *cp='\r';
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     *(int *)rsptmp=modmsg(efwork,msg,cp);
     ASSERT(*(int *)rsptmp != GMEAGAIN);
     clsgmerq(efwork);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}

STATIC void
fwdfor(                            /* forward a forum message              */
struct saunam *dpknam,             /*   dynapak name in use                */
char *fwdinf)                      /*   address to fwd to/comments         */
{
     unsigned forum;
     long msgid;

     ASSERT(sameto(FWDFOR,dpknam->suffix));
     *((char *)vdatmp)='\0';
     if (sscanf(&dpknam->suffix[sizeof(FWDFOR)-1],"%s %U",
                (char *)vdatmp,&msgid) < 2) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     forum=getfid((char *)vdatmp);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (foracc(forum) < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     csfwd(dpknam,fwdinf);
}

STATIC void
cpyfor(                            /* copy a forum message                 */
struct saunam *dpknam,             /*   dynapak name in use                */
char *cpyinf)                      /*   address to copy to/comments        */
{
     unsigned forum;
     long msgid;

     ASSERT(sameto(CPYFOR,dpknam->suffix));
     *((char *)vdatmp)='\0';
     if (sscanf(&dpknam->suffix[sizeof(CPYFOR)-1],"%s %U",
                (char *)vdatmp,&msgid) < 2) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     forum=getfid((char *)vdatmp);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (foracc(forum) < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     cscopy(dpknam,cpyinf);
}

STATIC void
delfmsg(                           /* delete a forum message               */
struct saunam *dpknam)             /*   dynapak name in use                */
{
     unsigned forum;
     long msgid;

     ASSERT(sameto(MODMSG,dpknam->suffix));
     *((char *)vdatmp)='\0';
     if (sscanf(&dpknam->suffix[sizeof(MODMSG)-1],"%s %U",
                (char *)vdatmp,&msgid) < 2) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     forum=getfid((char *)vdatmp);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (foracc(forum) < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     *(int *)rsptmp=delmsg(efwork);
     clsgmerq(efwork);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}

STATIC void
cscrtfor(                          /* create a forum                       */
struct credfdpk *newdpk)           /*   new forum dynapak structure        */
{
     struct fordsk *tmpdef;

     rqiptr->wrthdl=rsvarea(wrmpool);
     if (rqiptr->wrthdl == NOHDL) {
          *(int *)rsptmp=WRTBUSY;
          rsp2write(FALSE,sizeof(int),rsptmp);
          return;
     }
     rqiptr->flags|=BUFINU;
     tmpdef=areaptr(wrmpool,rqiptr->wrthdl);
     if (!fdpk2dsk(newdpk,tmpdef,TRUE)) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     createf();
}

STATIC void
ccreatef(void)                     /* cycled create a forum process        */
{
     cssetup();
     cycleme(NULL);
     createf();
}

STATIC void
createf(void)                      /* create a new forum                   */
{
     char *tmpdesc,*tmpecho;
     struct fordsk *tmpdef;

     tmpdef=areaptr(wrmpool,rqiptr->wrthdl);
     tmpecho=tmpdef->info;
     tmpdesc=&tmpdef->info[tmpdef->necho*MAXADR];
     switch (*(int *)rsptmp=creatfor(efwork,tmpdef,tmpdesc,tmpecho)) {
     case GMEAGAIN:
          cycleme(ccreatef);
          break;
     default:
          unrarea(wrmpool,rqiptr->wrthdl);
          rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
          break;
     }
}

STATIC void
csdelfor(                          /* delete a forum                       */
struct saunam *dpknam)             /*   dynapak name in use                */
{
     unsigned forum;

     forum=getfid(&dpknam->suffix[sizeof(MODFOR)-1]);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     inigmerq(efwork);
     *(int *)rsptmp=delfor(efwork,forum);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}

STATIC void
csmodfor(                          /* modify a forum                       */
struct saunam *dpknam,             /*   dynapak name in use                */
struct credfdpk *moddpk)           /*   modify forum dynapak structure     */
{
     unsigned forum;
     char *tmpinf;
     struct fordef *tmpdef;

     forum=getfid(&dpknam->suffix[sizeof(MODFOR)-1]);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     tmpdef=(struct fordef *)vdatmp;
     tmpinf=(char *)vdatmp+sizeof(struct fordef);
     if (!fdpk2def(forum,moddpk,tmpdef,tmpinf)) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     tmpdef->forum=forum;
     inigmerq(efwork);
     *(int *)rsptmp=modfor(efwork,tmpdef,&tmpinf[tmpdef->necho*MAXADR],tmpinf);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}

STATIC BOOL                        /*   returns FALSE if bad dynapak format*/
fdpk2dsk(                          /* copy forum dpk to on-disk struct     */
struct credfdpk *dpk,              /*   in-dynapak structure               */
struct fordsk *dsk,                /*   on-disk structure                  */
BOOL inclfil)                      /*   include file name/path info        */
{
     char *scp,*ecp;

     if ((dpk->dfprv&1) || dpk->dfprv > OPAXES) {
          return(FALSE);
     }
     dsk->dfprv=dpk->dfprv;
     if ((dpk->mxnpv&1) || dpk->mxnpv > OPAXES) {
          return(FALSE);
     }
     dsk->mxnpv=dpk->mxnpv;
     if ((dpk->dfnpv&1) || dpk->dfnpv > OPAXES) {
          return(FALSE);
     }
     dsk->dfnpv=dpk->dfnpv;
     if (dpk->msglif < -1) {
          return(FALSE);
     }
     dsk->msglif=dpk->msglif;
     dsk->chgmsg=dpk->chgmsg;
     dsk->chgrdm=dpk->chgrdm;
     dsk->chgatt=dpk->chgatt;
     dsk->chgadl=dpk->chgadl;
     dsk->chgupk=dpk->chgupk;
     dsk->chgdpk=dpk->chgdpk;
     dsk->ccr=dpk->ccr;
     if (dpk->pfnlvl < 0 || dpk->pfnlvl > DFTPFN) {
          return(FALSE);
     }
     dsk->pfnlvl=(signed char)dpk->pfnlvl;
     dsk->seqid=(unsigned)dpk->seqid;
     dsk->necho=dpk->necho;
     if (dsk->necho < 0 || dsk->necho > MAXECHO) {
          return(FALSE);
     }
     scp=unpad(dpk->info);
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(dsk->name,scp,FORNSZ);
     if (strlen(dsk->name) == 0 || !valfornm(dsk->name)) {
          return(FALSE);
     }
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(dsk->topic,scp,TPCSIZ);
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(dsk->forop,scp,UIDSIZ);
     if (strlen(dsk->forop) == 0) {
          return(FALSE);
     }
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     strupr(stlcpy(dsk->forlok,scp,KEYSIZ));
     if (strlen(dsk->forlok) > 0 && !keynam(dsk->forlok)) {
          return(FALSE);
     }
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     if (dsk->necho > 0) {
          if (!parsecho(dsk->necho,scp,dsk->info)) {
               return(FALSE);
          }
     }
     scp=ecp+1;
     if (inclfil) {
          ecp=strchr(scp,FLDSEP);
          if (ecp == NULL) {
               return(FALSE);
          }
          *ecp='\0';
     }
     stlcpy(&dsk->info[dsk->necho*MAXADR],scp,MAXFDV-dsk->necho*MAXADR);
     if (inclfil) {
          scp=ecp+1;
          ecp=strchr(scp,FLDSEP);
          if (ecp == NULL) {
               return(FALSE);
          }
          *ecp='\0';
          stlcpy(dsk->attpath,scp,MAXDIR);
          scp=ecp+1;
          stlcpy(dsk->datfil,scp,MAXPATH);
          if (strlen(dsk->datfil) == 0 || strlen(dsk->datfil) >= MAXBTVP
           || !valfdfnam(dsk->datfil)) {
               return(FALSE);
          }
          strupr(dsk->attpath);
          strupr(fixfdfnam(dsk->datfil));
     }
     return(TRUE);
}

STATIC BOOL                        /*   returns FALSE if bad dynapak format*/
fdpk2def(                          /* copy forum dpk to in-memory struct   */
unsigned forum,                    /*   forum being edited                 */
struct credfdpk *dpk,              /*   in-dynapak structure               */
struct fordef *def,                /*   on-disk structure                  */
char *info)                        /*   buffer for echoes and description  */
{
     char *scp,*ecp;
     unsigned usraxes;
     struct fordef *curdef;

     curdef=getdefp(forum);
     usraxes=foracc(forum);
     if (badaxes(usraxes,dpk->dfnpv,curdef->dfnpv)) {
          return(FALSE);
     }
     def->dfnpv=dpk->dfnpv;
     if (badaxes(usraxes,dpk->dfprv,curdef->dfprv)) {
          return(FALSE);
     }
     def->dfprv=dpk->dfprv;
     if (badaxes(usraxes,dpk->mxnpv,curdef->mxnpv)) {
          return(FALSE);
     }
     def->mxnpv=dpk->mxnpv;
     if (dpk->msglif < -1) {
          return(FALSE);
     }
     def->msglif=dpk->msglif;
     def->chgmsg=dpk->chgmsg;
     def->chgrdm=dpk->chgrdm;
     def->chgatt=dpk->chgatt;
     def->chgadl=dpk->chgadl;
     def->chgupk=dpk->chgupk;
     def->chgdpk=dpk->chgdpk;
     def->ccr=dpk->ccr;
     if (dpk->pfnlvl < 0 || dpk->pfnlvl > DFTPFN) {
          return(FALSE);
     }
     def->pfnlvl=(signed char)dpk->pfnlvl;
     def->seqid=(unsigned)dpk->seqid;
     def->necho=dpk->necho;
     if (def->necho < 0 || def->necho > MAXECHO) {
          return(FALSE);
     }
     scp=unpad(dpk->info);
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(def->name,scp,FORNSZ);
     if (strlen(def->name) == 0 || !valfornm(def->name)) {
          return(FALSE);
     }
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(def->topic,scp,TPCSIZ);
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     stlcpy(def->forop,scp,UIDSIZ);
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     strupr(stlcpy(def->forlok,scp,KEYSIZ));
     if (strlen(def->forlok) > 0 && !keynam(def->forlok)) {
          return(FALSE);
     }
     scp=ecp+1;
     ecp=strchr(scp,FLDSEP);
     if (ecp == NULL) {
          return(FALSE);
     }
     *ecp='\0';
     if (def->necho > 0) {
          if (!parsecho(def->necho,scp,info)) {
               return(FALSE);
          }
     }
     scp=ecp+1;
     stlcpy(&info[def->necho*MAXADR],scp,MAXFDV-def->necho*MAXADR);
     return(TRUE);
}

STATIC BOOL
badaxes(                           /* is default access level invalid?     */
int usraxes,                       /*   current user's access              */
int newaxes,                       /*   access level being set             */
int oldaxes)                       /*   current access level               */
{
     return((newaxes&1)
         || (newaxes > (usraxes >= SYAXES ? OPAXES : COAXES)
          && newaxes != oldaxes));
}

STATIC BOOL                        /*   returns FALSE if wrong # of addrs  */
parsecho(                          /* parse ';'-delimited list of echoes   */
int necho,                         /*   number of echoes expected          */
char *list,                        /*   ';'-delimited list                 */
char *arr)                         /*   echo address array                 */
{
     int i;
     adr_t *tmpecho;

     tmpecho=(adr_t *)arr;
     for (i=0 ; i < necho ; ++i) {
          if (list == NULL) {
               break;
          }
          list=parscc(tmpecho[i],list);
     }
     return(i == necho && list == NULL);
}

STATIC void
csxmtmsg(                          /* exempt/unexempt a message            */
struct saunam *dpknam,             /*   dynapak name in use                */
BOOL exempt)                       /*   turn exempt on=TRUE, off=FALSE     */
{
     unsigned forum;
     long msgid;

     *((char *)vdatmp)='\0';
     if (sscanf(&dpknam->suffix[sizeof(MSGXMT)-1],"%s %U",
                (char *)vdatmp,&msgid) < 2) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     forum=getfid((char *)vdatmp);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (foracc(forum) < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     rqiptr->stt=!(!exempt);
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     rd4xmt();
}

void
crd4xmt(void)                      /* cycled read message to exempt        */
{
     cssetup();
     cycleme(NULL);
     rd4xmt();
}

void
rd4xmt(void)                       /* read message to exempt               */
{
     vdamsg();
     switch (*(int *)rsptmp=readmsgf(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(crd4xmt);
          return;
     case GMEOK:
          *(int *)rsptmp=exmtmsg(efwork,msg,msgtxt,(BOOL)rqiptr->stt);
          break;
     }
     clsgmerq(efwork);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}

STATIC void
csapvatt(                          /* approve/unapprove attachment         */
struct saunam *dpknam,             /*   dynapak name in use                */
BOOL approve)                      /*   approve att on=TRUE, off=FALSE     */
{
     unsigned forum;
     long msgid;

     *((char *)vdatmp)='\0';
     if (sscanf(&dpknam->suffix[sizeof(MSGAPV)-1],"%s %U",
                (char *)vdatmp,&msgid) < 2) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     forum=getfid((char *)vdatmp);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (foracc(forum) < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     rqiptr->stt=!(!approve);
     inigmerq(efwork);
     inormrd(efwork,usaptr->userid,forum,msgid);
     rd4apv();
}

void
crd4apv(void)                      /* cycled read message to approve       */
{
     cssetup();
     cycleme(NULL);
     rd4apv();
}

void
rd4apv(void)                       /* read message to approve attachment   */
{
     vdamsg();
     switch (*(int *)rsptmp=readmsgf(efwork,msg,msgtxt)) {
     case GMEAGAIN:
          cycleme(crd4apv);
          return;
     case GMEOK:
          *(int *)rsptmp=aprvmsg(efwork,msg,msgtxt,(BOOL)rqiptr->stt);
          break;
     }
     clsgmerq(efwork);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}

STATIC void
setuacc(                           /* set access for a user                */
struct saunam *dpknam,             /*   dynapak name in use                */
int access)                        /*   access level to set to             */
{
     unsigned forum;

     forum=getfid(&dpknam->suffix[sizeof(USRACC)-1]);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (foracc(forum) < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (!uidxst(dpknam->usrid)) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     if (access == SYAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     *(int *)rsptmp=setaxes(forum,dpknam->usrid,access);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}

STATIC void
cpyuacc(                           /* copy forum access levels             */
struct saunam *dpknam,             /*   dynapak name in use                */
char *srcusr)                      /*   source User-ID                     */
{
     if (!uidxst(dpknam->usrid) || !uidxst(srcusr)) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     *(int *)rsptmp=cpyaxes(dpknam->usrid,srcusr);
     rsp2write(*(int *)rsptmp > GMEAGAIN,sizeof(int),rsptmp);
}

STATIC void
cscfgac(                           /* set default access for a forum       */
struct saunam *dpknam,             /*   dynapak name in use                */
unsigned length,                   /*   dynapak length                     */
struct foracc *newdfts)            /*   new default access structure       */
{
     int access;
     unsigned forum;
     struct foracc tmpacc;

     forum=getfid(&dpknam->suffix[sizeof(CFGACC)-1]);
     if (forum == EMLID) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     access=foracc(forum);
     if (access < RDAXES) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     setmem(&tmpacc,sizeof(struct foracc),0);
     movmem(newdfts,&tmpacc,length);
     b2ccvt(tmpacc.forlok,KEYSIZ);
     if (tmpacc.dfnpv < NOAXES
      || tmpacc.dfnpv > (access < SYAXES ? COAXES : OPAXES)
      || (tmpacc.dfnpv&1)
      || tmpacc.dfprv < NOAXES
      || tmpacc.dfprv > (access < SYAXES ? COAXES : OPAXES)
      || (tmpacc.dfprv&1)
      || tmpacc.mxnpv < NOAXES
      || tmpacc.mxnpv > (access < SYAXES ? COAXES : OPAXES)
      || (tmpacc.mxnpv&1)
      || (strlen(tmpacc.forlok) > 0 && !keynam(tmpacc.forlok))) {
          rsp2write(FALSE,0,NULL);
          return;
     }
     *(int *)rsptmp=cfgfacc(forum,&tmpacc);
     rsp2write(*(int *)rsptmp == GMEOK,sizeof(int),rsptmp);
}
