/***************************************************************************
 *                                                                         *
 *   AAEF.H                                                                *
 *                                                                         *
 *   Copyright (c) 1988-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   ASCII/ANSI E-mail and Forums shared variable and function             *
 *   definitions.                                                          *
 *                                                                         *
 *                                                - J. Alvrus 8/5/94       *
 *                                                                         *
 ***************************************************************************/

#define LINLEN 80                  /* line length (for est. FSE needs)     */
#define MAXLSI 1024                /* max size of cycled list items        */
#define LISTIL 100                 /* stay in cycled list state til btuoba<*/
#define MAXPRV 5                   /* max # of previous positions stored   */

                                   /* cycled process substates             */
#define CHK4NEW  -1                /*   checking for new messages (logon)  */
#define SENDING  -2                /*   sending message                    */
#define CRDNEAR  -4                /*   read message                       */
#define CRDNEXT  -5                /*   read next message                  */
#define CRDPREV  -6                /*   read previous message              */
#define CREREAD  -7                /*   re-read current message            */
#define CMARKRD  -8                /*   mark message read                  */
#define RPLING   -9                /*   sending a reply                    */
#define DELING   -10               /*   deleting message                   */
#define MODING   -11               /*   modifying message                  */
#define FWDING   -12               /*   forwarding message                 */
#define COPYING  -13               /*   copying message                    */
#define XMTING   -14               /*   transmitting message text          */
#define CRDPRNT  -15               /*   reading parent of current message  */
#define LISTING  -16               /*   showing a cycled list              */
#define CINIFOR  -17               /*   initializing new forum definition  */
#define CRTFOR   -18               /*   waiting for OUTMT to create a forum*/
#define EDTFOR   -19               /*   waiting for OUTMT to edit a forum  */
#define CREATING -20               /*   creating a forum                   */
#define EDITING  -21               /*   editing a forum                    */
#define FDELING  -22               /*   deleting a forum                   */
#define MSGLST   -23               /*   listing forum messages             */
#define NAPVING  -24               /*   searching for next msg to approve  */
#define PAPVING  -25               /*   searching for prev msg to approve  */

struct formid {                    /* forum ID + message ID structure      */
     unsigned fid;                 /*   forum ID                           */
     long mid;                     /*   message ID                         */
};

extern
struct efvda {                     /* ASCII/ANSI E-mail/Forums VDA struct  */
     int count;                    /*   generic counter (also # of echoes) */
     int savstt;                   /*   which module currently in use      */
     long curmid;                  /*   current message ID                 */
     long tmpmid;                  /*   for saving a message ID            */
     long prethr;                  /*   msg being read @ start of thread   */
     unsigned tmpfid;              /*   for saving a forum ID              */
     char *txtptr;                 /*   output position in message text    */
     unsigned char prvidx;         /*   scan previous position index       */
     struct formid prvlst[MAXPRV]; /*   array of previous scan positions   */
     char tmpadr[MAXADR];          /*   general-use address buffer         */
     long attsiz;                  /*   size of attachment                 */
     int numcc;                    /*   current number of cc: addresses    */
     char *cclist;                 /*   pointer to cc: list buffer         */
     char *ccptr;                  /*   current position in cc: list       */
     unsigned cclstsz;             /*   size of cc: list buffer            */
     unsigned cmtspc;              /*   space available for comments       */
     char *fsdspc;                 /*   FSD - Memory for forum create/edit */
     char *fsdtmp;                 /*   FSD - Pointer to answer strings    */
     FILE *fp;                     /*   general use file                   */
     int flags;                    /*   general purpose flags              */
     int cflags;                   /*   cycled process control flags       */
     int savflg;                   /*   place to save message flags        */
     char dftchr;                  /*   result of call to getdft()         */
     int nearop;                   /*   current read near style            */
     char inpsav[DFTIMX+1];        /*   buf for saving input while cycling */
     void (*whndun)(int rc);       /*   current when-done routine          */
     BOOL (*nxtlst)(void);         /*   current list output routine        */
     char efwork[GMEWRKSZ];        /*   GME work area                      */
     union {                       /*   large, overlaid buffer area        */
          struct {                      /* message reading/writing buffers */
               char filatt[MAXPATH];    /*   file attachment path+file name*/
               struct message msg;      /*   message header buffer         */
               char msgtxt[1];          /*   message text buffer           */
          } m;
          struct {                      /* !QUICK list editing buffers     */
               struct qikdat qik;       /*   !QUICK list header structure  */
               char l[MAXQKR-sizeof(struct qikdat)-1]; /* ensure size      */
          } q;
          struct {                      /* view/edit/create forum buffers  */
               union {
                    struct fordef def;  /*   edit forum buffer             */
                    struct fordsk dsk;  /*   create forum buffer           */
               } d;
               union {
                    char echo[MAXADR];  /*   echo address buffer           */
                    char v[MAXFDV];     /*   ensure size                   */
               } v;
          } f;
          struct foracc a;              /* configure user access structure */
     } u;
} *efvda;                          /* properly typed pointer to VDA        */

                                   /* efvda flags                          */
#define RAFIPG  0x0001             /*   "reply-after-forward" in progress  */
#define LSTFUL  0x0001             /*   listing full message               */
#define LSTBRF  0x0002             /*   listing brief message descriptions */
#define ATTOK   0x0002             /*   attachment has been validated      */
#define RRROK   0x0004             /*   return receipt has been validated  */
#define PRIOK   0x0008             /*   priority message has been validated*/
#define LONIPG  0x0010             /*   logon in progress                  */
#define JUMPED  0x0020             /*   user "jumped" to specific message  */
#define CCLST   0x0040             /*   include cc: list in message        */
#define LOFUPL  0x0080             /*   user wants to log off after upload */
#define QSCIPG  0x0100             /*   quickscan in progress (not search) */
#define FUPOK   0x0200             /*   file upload completed successfully */
#define ISRPL   0x0400             /*   current write operation is a reply */
#define RDFROM  0x0800             /*   reading messages from user         */
#define THRING  0x1000             /*   reading messages in a thread       */
#define CRTING  0x2000             /*   creating (not editing) forum flag  */
#define LONFIN  0x8000             /*   time-to-exit-from-logon flag       */

                                   /* efvda cflags                         */
#define DIDCYC  0x0001             /*   did a cycled routine flag          */
#define CKDCYC  0x0002             /*   have already checked for cycle     */
#define XMTDONE 0x0004             /*   done sending message text          */
#define LONGMSG 0x0008             /*   message text longer than OUTSIZ    */
#define INJOSAV 0x0010             /*   user did not have NOINJO flag set  */
#define NOCUR   0x0020             /*   no current message while reading   */
#define WDSTING 0x0040             /*   current write op is distribution   */
#define WCCING  0x0080             /*   current write op is carbon copying */
#define WCPYING 0x0100             /*   copying attachment                 */
#define SCN4UA  0x0200             /*   scanning for unapproved attachments*/
#define UATFND  0x0400             /*   an unapproved attachment was found */
#define LSTDONE 0x0800             /*   forum message list finished        */

extern
int emlstate,                      /* E-mail module state code             */
    forstate;                      /* Forums module state code             */
extern
struct qikdat *qikbuf;             /* !QUICK struct in VDA                 */
extern
struct fordef *fdef;               /* forum def struct in VDA              */
extern
struct fordsk *fdsk;               /* on-disk forum struct in VDA          */
extern
char *desc,                        /* forum description buf in VDA         */
     *msgatr;                      /* ANSI message body color string       */
extern
adr_t *echo;                       /* forum echoes buffer in VDA           */
extern
BOOL cb4hdr;                       /* A/A clear before message (non-browse)*/

/* functions from AAEML.C */

void
iniaaeml(void);                    /* initialize ASCII/ANSI E-mail module  */

void
dsetprf(                           /* display: set preferences menu        */
int pmt);                          /*   which menu to show (normal or help)*/

/* functions from AAFOR.C */

void
iniaafor(void);                    /* initialize ASCII/ANSI Forums module  */

void
gfmain(                            /* go to main forum menu                */
BOOL shortform);                   /*   show short form?                   */

char *
curfnm(void);                      /* name of current Forum                */

char *
curftpc(void);                     /* topic of current Forum               */

BOOL
dnldok(                            /* can user download attachment (if any)*/
unsigned forum);                   /*   forum in which message resides     */

BOOL
isauth(void);                      /* is current user author of current msg*/

void
gfoprdst(void);                    /* show forum-op post-read prompt       */

void
listfor(                           /* list forums                          */
int retstt);                       /*   substate to go to when done        */

/* functions from AAEFU.C */

BOOL
efcflck(                           /* E-mail/Forums conflict checker       */
void *work,                        /*   work area to check                 */
unsigned forum,                    /*   forum to check                     */
long msgid);                       /*   message ID to check                */

unsigned                           /*   updated spinner position           */
spin(                              /* output a spinner                     */
unsigned count);                   /*   spinner position index             */

void
setmeup(void);                     /* set up E-mail/Forums files & pointers*/

BOOL                               /*   returns TRUE if user warned        */
pfnwrn(void);                      /* warn user about profanity            */

void
gostt(                             /* prompt and change substate           */
int stt);                          /*   state to go to                     */

void
errhlp(                            /* display error/help message & reprompt*/
int ehmsg,                         /*   error/help message to display      */
int repmt);                        /*   reprompt with this message         */

void
startlst(                          /* fire up a cycled listing process     */
BOOL (*nxtlst)(void),              /*   function to output next line       */
void (*whndun)(int rc));           /*   function to call when finished     */

void
lister(void);                      /* cycled show-a-list process           */

void
wrthlp(void);                      /* show help for who-to-write prompt    */

void
startwrt(                          /* start message write process          */
void (*whndun)(int rc));           /*   function to invoke when finished   */

void
startrpl(                          /* start reply process                  */
void (*whndun)(int rc));           /*   function to invoke when finished   */

void
susequo(void);                     /* state: use quoting when replying?    */

void
goedit(                            /* start editing a message              */
int flags);                        /*   flags for editor                   */

BOOL                               /*   returns TRUE if found spec'd msg   */
efimr(                             /* import message into editor           */
long msgid);                       /*   message ID to import               */

BOOL                               /*   returns TRUE to stay in module     */
edtdone(                           /* finished editing message             */
int edflgs);                       /*   edit result flags                  */

void
chkitout(void);                    /* check available post-write options   */

void
shopwm(void);                      /* show post-write menu                 */

void
shopwh(void);                      /* show post-write help                 */

void
spostwrt(void);                    /* state: E-mail/Forums post-write menu */

void
efupload(void);                    /* E-mail/Forums upload utility         */

void
clofwait(void);                    /* handle cycling during logoff wait    */

void
slofwait(void);                    /* handle user input during logoff wait */

void
snamatt(void);                     /* state: enter name of attachment      */

void
swhotocc(void);                    /* state: to whom to send cc            */

void
sender(void);                      /* cycled message send process          */

void
replyr(void);                      /* cycled reply process                 */

void
fnotify(                           /* do notification of message forward   */
int rc);                           /*   result of forward operation        */

void
cnotify(                           /* do notification of message copy      */
int rc);                           /*   result of copy operation           */

void
startmod(                          /* initiate modification of message     */
void (*whndun)(int rc));           /*   function to call when finished     */

void
cmodr(void);                       /* cycled message modify process        */

void
xmtext(                            /* transmit text of message             */
void (*whndun)(int rc));           /*   function to call when finished     */

void
cxmtxt(void);                      /* cycled text transmit process         */

void
xmtdone(                           /* done sending message text            */
BOOL aborted);                     /*   TRUE if user aborted output        */

void
cfhlp(void);                       /* show help for copy/forward prompt    */

void
comment(                           /* check for comments when copy/fwd     */
void (*whndun)(int rc));           /*   function to call when finished     */

void
scmtpmt(void);                     /* state: add comments when copy/fwd?   */

void
fwdit(                             /* initiate message forward process     */
void (*whndun)(int rc));           /*   function to invoke when finished   */

void
cfwdr(void);                       /* cycled message forward process       */

void
copyit(                            /* initiate message copy process        */
void (*whndun)(int rc));           /*   function to invoke when finished   */

void
ccopyr(void);                      /* cycled message copy process          */

void
deletem(                           /* initiate cycled delete-message       */
void (*whndun)(int rc));           /*   function to call when finished     */

void
cdelm(void);                       /* cycled delete message process        */

BOOL
srchipg(void);                     /* is there a message search in progress*/

void
getprnt(                           /* initiate read parent message process */
void (*whndun)(int rc));           /*   function to call when finished     */

void
cgetprnt(void);                    /* cycled read message parent process   */

void
getnear(                           /* initiate read near message process   */
int nearop,                        /*   get near "style" to use            */
void (*whndun)(int rc));           /*   function to call when finished     */

void
cgetnear(void);                    /* cycled read near message process     */

void
reget(                             /* initiate re-read of current message  */
void (*whndun)(int rc));           /*   function to call when finished     */

void
creget(void);                      /* cycled re-read of current message    */

void
getnext(                           /* initiate read next message process   */
void (*whndun)(int rc));           /*   function to call when finished     */

void
cgetnext(void);                    /* cycled read next message process     */

void
getprev(                           /* initiate get previous message process*/
void (*whndun)(int rc));           /*   function to call when finished     */

void
cgetprev(void);                    /* cycled get previous message process  */

void
markoff(                           /* mark message read, generate ret.rcp. */
void (*whndun)(int rc));           /*   function to call when finished     */

void
cmarkoff(void);                    /* cycled mark-message-read process     */

void
sdlnow(                            /* state: query to download attachment  */
void (*whndun)(int rc));           /*   function to call when done         */

void
efdnload(                          /* E-mail/Forums download utility       */
void (*whndun)(int rc));           /*   function to call when finished     */

void
docyc(                             /* switch from input mode to cycle mode */
BOOL lock);                        /*   lock out input while cycling?      */

void
cycall(void);                      /* cncall() equivalent for cycled proc  */

void
chkcyc(void);                      /* return from cycling to input handler */

void
rstcnc(void);                      /* restore concat context after cycling */

void
sumams(                            /* generate message summary lines       */
int txtblk,                        /*   level 6 text block to use          */
struct message *dspmsg);           /*   for given message                  */

char *
anpstr(                            /* ALWAYS/NEVER/PROMPT string           */
int flags,                         /*   flag field to check                */
int pmtflg,                        /*   flag set when "PROMPT"             */
int alwflg);                       /*   flag set when "ALWAYS"             */

char *
ynstr(                             /* YES/NO string                        */
int flags,                         /*   flag field to check                */
int ynflg);                        /*   flag set when "YES"                */

char *
rmodstr(                           /* read mode string (FULL/BROWSE)       */
int flags,                         /*   flag field to check                */
int modflg);                       /*   flag set when "FULL"               */

