/***************************************************************************/
/*                                                                         */
/*   TLC.H                                                                 */
/*                                                                         */
/*   Copyright (c) 1994-1996 Galacticomm, Inc.    All Rights Reserved.     */
/*                                                                         */
/*   Common declarations between MJRTLC.C, CSMJRTLC.C, TLCUTL.C.           */
/*                                                                         */
/*                                            - Bill Hyatt 10/4/94         */
/*                                                                         */
/***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "gme.h"
#include "galtlc.h"

#define TLCAID "GALTLC"       /* teleconference C/S appid                  */

/* teleconference user flags */
#define NOPAGE 0x0001         /* user page-flag set to "off"               */
#define SHWCHN 0x0002         /* user's channel is displayed in scan       */
#define SQUCHD 0x0004         /* this guy has been "squelched" by modera   */
#define LUISSU 0x0008         /* list or unlist command has been issued    */
#define JUSTEX 0x0010         /* user "just exited" during current intvl   */
#define OKPAGE 0x0020         /* user doesn't mind being paged to death    */
#define XTOOTH 0x0040         /* exit to "caller" module when finished     */
#define CCHVLD 0x0080         /* chat-channel value is valid               */
#define TYPING 0x0100         /* user is now typing (for chat colors)      */
#define RSTX2M 0x0200         /* reset X2MAIN when XTOOTH is invoked       */
#define TLCGCS 0x0400         /* tele user is in C/S mode                  */
#define DBRDUP 0x0800         /* C/S user has his drawing board up         */
#define TLCCHT 0x1000         /* C/S user is in chat mode                  */
#define TLCRCV 0x2000         /* C/S user is receiving a file now          */
#define JUSTDB 0x4000         /* C/S usr open/clsd drw bd during cur intrvl*/

/* send flags for outtlc() */
#define AA   0                /* send to A/A users only                    */
#define CS   1                /* send to C/S users only                    */
#define ALLU 2                /* send to all users                         */

/* list flags for tlsrui() */
#define LSTALL 0              /* all users in tele                         */
#define LSTSCH 1              /* users in same chan as current user        */
#define LSTCS  2              /* C/S tele users only                       */
#define LSTCRQ 3              /* users who have req'd chat w/ cur user     */

/* states for user sending file (sndstt) */
#define NOSEND 0              /*   not currently sending file at all       */
#define WT4ROK 1              /*   waiting for receiver ok to send file    */
#define WT4DAT 2              /*   waiting for data to come from client    */
#define WT4RRM 3              /*   waiting to for room in receiver queue   */

/* results of ck4pfn() calls */
#define NOPFN  0              /* input had no profanity                    */
#define WARNED 1              /* user was given warning message            */
#define HUNGUP 2              /* user was hung up on                       */

#define MAXOPC 5              /* max # of outstanding file xfer packets    */

#define CTPSIZ 41             /* max size of teleconf channel topic        */
#define DBRDDN -DBRDUP        /* C/S user just shut down his drawing brd   */
#define CHANOK -1             /* chkchn(): ok to switch user to chan       */
#define TDBFSZ 512            /* size of buf for data sent w/ senddpk()    */

#define SQLFLS(u) sqlflg[(u)/32]   /* squelch flags bank, as func of user# */
#define SQLBIT(u) (1L<<((u)&0x1F))

#define tlcsex(c) ((c) == 'M' ? (c) : 'F') /* force vld sex byte in tele   */
#define tlcsxp(c) ((c) == 'M' ? "him" : "her") /* vld sex pronoun in tele  */

struct tlc {                  /* teleconference per-user volatile data     */
     int flags;               /*   telecon user "flag" bits                */
     long sqlflg[8];          /*   "squelch" flags by modem number         */
     int paged;               /*   intervals-since-last-paged counter      */
     int blinkc;              /*   intervals-since-paged-Sysop counter     */
     int swchan;              /*   # of times switched chans in interval   */
     unsigned channel;        /*   teleconference channel number in use    */
     unsigned modchn;         /*   channel moderated by telecon user       */
     char topic[CTPSIZ];      /*   channel topic as set by moderator       */
     int inpcnt;              /*   input message counter for freeloaders   */
     int reqcha;              /*   intervals-since-last-chat-request ctr.  */
     int chatch;              /*   channel of other user being chatted with*/
     int retstt;              /*   return state number when XTOOTH         */
     int retsub;              /*   return sub-state number when XTOOTH     */
     int retrat;              /*   return cred consumption rt when XTOOTH  */
     int sndstt;              /*   sender's state, when sending file       */
     long sndbyt;             /*   sender's bytes to go, when sending file */
     int rcvchn;              /*   receiver's channel number, when sending */
     int sndchn;              /*   sender's chan #, when receiving file    */
     int rcvopc;              /*   receiver's outstanding packet count     */
};

extern
struct tlc *tlclst,           /* dynamic array of tele volatile user area  */
           *tlcptr,*tptr;     /* handy pointers for speed                  */

extern
FILE *tlcmb;                  /* teleconf named-message file block pointer */

extern
int tlcstt,                   /* teleconferenc state number for A/A users  */
    nswchx,                   /* max times can switch chans or on-off/15sec*/
    tlcovr,                   /* does the tele cc rate over-ride Forums'?  */
    tlcccr,                   /* teleconference credit consumption rate    */
    reqint,                   /* minimum interval bewteen requesting a user*/
    npaymx,                   /* max times can talk per session if no pay  */
    tinpsz,                   /* allowable input size for teleconference   */
    swtfrm,                   /* alw A/A usrs to swt to & from Forum chans?*/
    cswto;                    /* allow C/S users to switch to Forum chans? */

extern
char *modkey,                 /* key req'd to moderate tele channels       */
     *unlkey;                 /* key req'd for unlimited tele use          */

extern
unsigned maxfre;              /* top freeloader telecon channel            */

int chkchn(long newchn);
void swtchn(long newchn);
void sndwsp(char *what);
void tlcctx(void);
void inicstlc(void);
int chncnt(void);
void initls(void);
char *tlsrui(int lsttyp);
BOOL inscan(int unum,struct tlc *tp);
char *scnchn(int unum,struct tlc *tp);
char *scntpc(struct tlc *tp);
int urinv(void);
int ck4mod(int excusr);
BOOL xfrmod(char *uid);
void ntfyres(unsigned excchn);
BOOL squsqu(char *uid,BOOL squel);
int howmny(char *stg,int prec,int samas);
int chkcht(char *uid);
void reqcht(void);
void entcht(void);
char tlchat(int chan,int ch);
void rmvcht(int excusr);
void xitcht(int hangup);
void tlchup(void);
void outtlc();
int ck4pfn(void);
char *flgbyt(int unum);
void abosnd(void);
void aborcv(int sndchn);
void aboarcvs(void);

