/***************************************************************************
 *                                                                         *
 *   SUMMARY.C                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Summary screen code                                                   *
 *                                                                         *
 *                                            - Robert A. Rose 02/05/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsmajor.h"
#include "oprlow.h"
#include "statscns.h"

#define FILREV "$Revision: 1.4 $"

#define CMLSIZ 80             /* max input command-line length             */
#define SKBSIZ 50             /* max number of keys used to construct it   */

#define CMWYUL 19             /* command window y-top boundary             */
#define CMWXLR 77             /* command window x-right boundary           */
#define CMWXUL  2             /* command window x-left boundary            */
#define CMWYLR 21             /* command window y-bottom boundary          */

void (*shochl_hook)(int chan)=NULL;     /* shochl hook for C/S applications*/
void (*rsyfad_hook)(void)=NULL;         /* rsyfad hook for C/S audit trail */
void dspact(char *userid);
char *rtmfmt(unsigned long ntval);
void calrtm(void);
void sysrtm(void);

extern
int rsetop,                   /* reset option: busy=B; no-answer=N         */
    visbel,                   /* bell setting when emulation is visible    */
    invbel,                   /* bell setting when emulation is hidden     */
    sopaud,                   /* route Audit Trail stuff to online Sysop   */
    auxist,                   /* secondary CRT support                     */
    maxscns,                  /* maximum number of screens                 */
    kilipg,                   /* kill-system command in progress           */
    kilctr,                   /* number of minutes to shutdown             */
    kilsrc;                   /* kill-cmd src (-1=console, -2=MCU, -3=auto)*/

extern
int errcod;                   /* MS-DOS exit code (for batch files)        */

int lblhue=0x1F;              /* soft-key labels display attribute code    */
static
int kilnow;                   /* system has been slated for kill "NOW"     */

struct otrail {               /* trail structure for backspace key         */
     struct otrail *link;     /*   link                                    */
     int opistt;              /*   operator input state                    */
     char *cmlptr;            /*   command-line string pointer             */
} opinf;                      /* trail header                              */

char cmlbuf[CMLSIZ];          /* command line input buffer                 */
int skbuf[SKBSIZ],            /* soft-key input buffer                     */
    *skbptr,                  /* soft-key buffer pointer                   */
    *skbpeu,                  /* skbptr value upon transition to ENTUID    */
    quiefl;                   /* quiet soft-key legends just put in place  */
char cskbuf[SKBSIZ];          /* collapsed (char-wise) soft-key input buf  */

#define SK_QUIET    0         /* nothing going on                          */
#define SK_DISPLAY  1         /* 'Display ...'                             */
#define SK_DISSAVR  2         /* 'Display saver after...                   */
#define SK_DISAUXC  3         /* 'Display on aux crt...                    */
#define SK_SEND     4         /* 'Send...'                                 */
#define SK_KILL     5         /* 'Kill...'                                 */
#define SK_KILLCHN  6         /* 'Kill channel...'                         */
#define SK_KILLSYS  7         /* 'Kill system...'                          */
#define SK_ENTER    8         /* <ENTER>                                   */
#define SK_UID      9         /* Asking for UID (no enter)                 */
#define SK_UIDENTER 10        /* Asking for UID (and enter is ok)          */
#define SK_INPMSG   11        /* Inputting a message                       */
#define SK_KILLCHN2 12        /* 'Kill channel ?' (second digit)           */
#define SK_KILLCHNM 13        /* 'Kill channel xx' (get mode or enter only)*/
#define SK_INPCHN   14        /* Getting first digit of channel number     */
#define SK_INPCHN2  15        /* Getting second digit of channel number    */
#define SK_DISPOST  16        /* Display position set                      */
#define SK_PDORFREE 17        /* Paid or free credits?                     */
#define SK_CRDAMTS  18        /* list of popular numbers                   */
#define SK_MSGTOTS  19        /* totals of various msg types               */

                              /* soft-key legend table                     */
char *sklegs[][10]={
/*0*/{" help  "," send  ","display"," post  ","detail","set msg"," login ","       ","       "," kill  "},
/*1*/{"mem avl","message","dsk avl","rsptime","accnts"," calls ","uploads","dnloads","aux crt"," saver "},
/*2*/{" 1 min "," 2 min "," 5 min ","30 min "," 1 hr "," never ","       ","       ","       ","       "},
/*3*/{"nothing","account"," audit ","emulate","stats ","monitor"," users "," about ","       ","       "},
/*4*/{"  ALL  ","channel","       ","       ","      ","       ","       ","       ","       ","       "},
/*5*/{"User-ID","account","channel","       ","      ","       ","       ","       ","system ","       "},
/*6*/{"       ","       ","       ","       ","      ","       ","       ","       ","       ","       "},
/*7*/{"in 1min","in 2min","in 5min","in10min","      "," UNDO! ","       "," asap  ","       "," NOW!  "},
/*8*/{"       ","       ","       ","       ","      ","       ","       ","       ","<ENTER>","       "},
/*9*/{"       ","       ","       ","       ","      ","       ","       ","       ","       ","       "},
/*0*/{"       ","       ","       ","       ","      ","       ","       ","       ","<ENTER>","       "},
/*1*/{"  OK   ","       ","       ","       ","      ","       ","       ","       ","       "," QUIT  "},
/*2*/{"busyout","no-ansr","normal ","       ","      ","       ","       ","       ","<ENTER>","       "},
/*3*/{"busyout","no-ansr","normal ","       ","      ","       ","       ","       ","<ENTER>","       "},
/*4*/{"       ","       ","       ","       ","      ","       ","       ","       ","       ","       "},
/*5*/{"       ","       ","       ","       ","      ","       ","       ","       ","<ENTER>","       "},
/*6*/{"   1   ","   2   ","   3   ","   4   ","  5   ","   6   ","       ","       ","       ","       "},
/*7*/{" PAID  "," FREE  ","       ","       ","      ","       ","       ","       ","       ","       "},
/*8*/{" 1800  "," 3600  "," 7200  "," 18000 ","36000 ","72000  ","180000 ","360000 ","720000 ","       "},
/*9*/{" Total "," Email "," Forum ","       ","      ","       ","       ","       ","       ","       "},
};

#define NUMOFP 9              /* number of ptrs in atptrs                  */
long atbptr,                  /* audit trail window-bottom absolute pos    */
     atptrs[NUMOFP];          /* audit trail record absolute positions     */
BTVFILE *audbb;               /* Btrieve file block ptr for audit trail    */
extern
long acptrs[8];               /* audit trail record absolute positions     */

extern struct scrnid accnscn; /* Account screen variables                  */
extern int acchdl;
extern struct scrnid audiscn; /* Audit screen variables                    */
extern int audhdl;
extern struct scrnid emulscn; /* Emulation screen variables                */
extern int ehdl;
extern struct scrnid emfuscn;
extern int emful;
extern struct scrnid statscn; /* Graph screen variables                    */
extern int stahdl;
extern struct scrnid monascn; /* monitor all screen variables              */
extern int mhdl;
extern struct scrnid ussscn;  /* Users screen variables                    */
extern int usshdl;
extern struct scrnid abouscn; /* about screen variables                    */
extern int ahdl;
extern struct scrnid lsesscn; /* local login screen variables              */
extern int lsehdl;
extern struct scrnid hlpscn;  /* help screen variables                     */
extern int hlphdl;

int stthue=0x1D,              /* Audit Trail display attribute code        */
    ndfhue=0x13,              /* undefined channels display attribute code */
    gphhue=0x1E,              /* System load graph display attribute       */
    vtxhue=0x1A;              /* variable text display attribute code      */

int vcx,vcy;                  /* virtual cursor location                   */

int shdl;                     /* handle for the summary screen             */
int atmess=0;                 /* has the audit trail been changed?         */
extern
int emubel;                   /* period for emulation bells                */

unsigned c;                   /* key passed to us                          */
int fiddle=0;                 /* have we processed this key?               */

struct uidisp *uidarr;        /* users screen info array                   */

#define LILYELBOX '\376'      /* little yellow box character               */

int sysload[60];              /* System loading per minute                 */
int intload;                  /* interval load accumulator                 */
int invocnt;                  /* invocation counter                        */

static
char savmins[10]={1,2,5,30,60,0,0,0,0,0};

int sndchn;                   /* destination for message to be sent        */
char txtstg[MTXSIZ],          /* message text string buffer                */
     *txtptr;                 /* message text string pointer               */

struct scrnid summscn={
     "bbss.bin",              /* screen filename                           */
     4000,                    /* length of screen (4000 for full screen)   */
     ALT_S,                   /* select scan code (from main screen)       */
                              /* ala 'Keyboard Accelerator'                */
     NULL,                    /* screen going away routine                 */
     sumrep,                  /* screen repaint routine                    */
     sumkey,                  /* key handler routine                       */
     sumocc,                  /* occasional update routine                 */
     1,                       /* seconds between occasional updates        */
     0,                       /* seconds to go before next update          */
     NULL,                    /* called every cycle when displayed         */
     2,0,                     /* current cursor position on screen         */
     0,                       /* does cursor move?                         */
     0,                       /* should screen scroll?                     */
     1,1,79,20,               /* scrolling for window (default)            */
     NULL,                    /* perm. save buffer                         */
     NULL                     /* current location of screen                */
};

static
char *minlabl="00   15   30   45   00   15   30   45   ";

#define RTMRAT 2              /* response time display rate (seconds)      */
#define RTMSMP 4              /* response time smooth factor (5s halflife) */
#define LOADFX 164L           /* rsptim/syslod ratio:  65536 * 2.5 / 1000  */
#define HRTONE 0x00010000UL   /* 1 second, in 1/65536 units (ala hrtval()) */

void (*oldsys)(void);         /* saved value for (*syscyc)()               */
unsigned long rtmcnt=0L;      /* count of system cycles in RTMRAT period   */
unsigned long rtmfst;         /* hrtval() at 1st cycle in RTMRAT period    */
unsigned long rtmlst;         /* hrtval() at last cycle in RTMRAT period   */
unsigned long rtmlls;         /* hrtval() at next-to-last cycle in period  */
unsigned long rsptim=0L;      /* avg response time, in 1/65536 sec units   */

void
sumocc(void)                  /* Summary screen occasional update          */
{
     int cmin;

     cmin=dtmin(now());
     if (invocnt%6 == 0) {    /* calculate load every minute               */
          sysload[cmin]=intload/6;
          intload=0;
          loadgph(cmin);
     }
     invocnt++;
     intload+=linsusd();
     doaditbx();
}

unsigned
sumkey(                       /* Summary screen keystroke handler routine  */
unsigned scncod)                        /* keystroke hit                   */
{
     int i;

     fiddle=0;
     c=scncod;
     if ((c == 8 || c == 27 || c == CRSRLF)
       && opinf.opistt != SK_INPMSG
       && opinf.opistt != SK_QUIET) {
          bckspc();
          fiddle=1;
     }
     else {
          switch(scncod) {
          case TAB:
               if (mainhdl == shdl) {
                    scn2mai(usshdl);
                    fiddle=1;
               }
               else {
                    i=skcipg;
                    skcipg=0;
                    keyhit(scncod);
                    skcipg=i;
               }
               break;
          case BAKTAB:
               if (mainhdl == shdl) {
                    scn2mai(mhdl);
                    fiddle=1;
               }
               else {
                    i=skcipg;
                    skcipg=0;
                    keyhit(scncod);
                    skcipg=i;
               }
               break;
          case HOME:
               setbtv(audbb);
               globtv(NULL,0);
               for (i=0 ; i < NUMOFP-2 ; i++) {
                    qnxbtv();
               }
               iniaud();
               fiddle=1;
               atmess=1;
               break;
          case END:
               setbtv(audbb);
               ghibtv(NULL,0);
               iniaud();
               fiddle=1;
               atmess=0;
               break;
          case PGUP:
               for (i=0 ; i < NUMOFP ; i++) {
                    scroat(0);
               }
               fiddle=1;
               break;
          case PGDN:
               for (i=0 ; i < NUMOFP ; i++) {
                    scroat(1);
               }
               fiddle=1;
               break;
          case CRSRUP:
               scroat(0);
               fiddle=1;
               break;
          case CRSRDN:
               scroat(1);
               fiddle=1;
               break;
          default:
               if ((scncod >= F1 && scncod <= F10) || skcipg) {
                    softgroup();
                    fiddle=1;
               }
          }
     }
     skcipg=(opinf.opistt != SK_QUIET);
     if (!fiddle && scncod == ESC) {
          keyhit(F7);
     }
     return(fiddle ? 0 : scncod);
}

void
softgroup(void)
{
     actvscnsp(dfltmscn,CMWXUL,CMWYUL,CMWXLR,CMWYLR,1);
     switch (opinf.opistt) {
     case SK_QUIET:
          squiet();
          break;
     case SK_SEND:
          ssndac();
          break;
     case SK_DISPLAY:
          sseldsp();
          break;
     case SK_CRDAMTS:
          sentamt();
          break;
     case SK_PDORFREE:
          sentapf();
          break;
     case SK_KILL:
          skill();
          break;
     case SK_KILLSYS:
          sentmin();
          break;
     case SK_KILLCHN:
     case SK_KILLCHN2:
     case SK_KILLCHNM:
          scklmod();
          break;
     case SK_INPCHN:
          sinpchn();
          break;
     case SK_INPCHN2:
          sinpch2();
          break;
     case SK_ENTER:
          if (c == '\r' || c == F9) {
               retkey();
          }
          break;
     case SK_DISPOST:
          sselpos();
          break;
     case SK_MSGTOTS:
          smsgdsp();
          break;
     case SK_DISAUXC:
          sauxcrt();
          break;
     case SK_DISSAVR:
          sscnsav();
          break;
     case SK_UID:
          sentuid();
          break;
     case SK_UIDENTER:
          if (isuidc(c&eurmsk) && skbptr-skbpeu < UIDSIZ-1) {
               c=c&eurmsk;
               hdlskc(SK_UIDENTER);
          }
          if (c == '\r' || c == F9) {
               retkey();
          }
          break;
     case SK_INPMSG:
          dwtxte();
          break;
     }
}

void
squiet(void)                       /* main menu of soft keys               */
{
     extern int lsechn;

     switch (c) {
     case F1:
          if (chlpfn() != NULL) {
               iniscn(chlpfn(),actvscn(hlphdl));
               scn2mai(hlphdl);
          }
          break;
     case F2:
          hdlsk("Send a message to ",SK_SEND);
          break;
     case F3:
          hdlsk("Display ",SK_DISPLAY);
          break;
     case F4:
          hdlsk("Post ",SK_CRDAMTS);
          break;
     case F5:
          hdlsk("Detail info on User-ID: ",SK_UID);
          skbpeu=skbptr;
          break;
     case F6:
          hdlsk("Set log-on message",SK_ENTER);
          break;
     case F7:
          scn2mai(lsehdl);
          if (user[nterms-1].class == VACANT) {
               entlse(nterms-1);
          }
          break;
     case F10:
          hdlsk("Kill ",SK_KILL);
          break;
     }
}

void
sseldsp(void)                      /* select "display" variable            */
{
     switch (c) {
     case F1:
          hdlsk("memory available in position ",SK_DISPOST);
          break;
     case F2:
          hdlsk("messages: ",SK_MSGTOTS);
          break;
     case F3:
          hdlsk("disk space available in position ",SK_DISPOST);
          break;
     case F4:
          hdlsk("average response time in position ",SK_DISPOST);
          break;
     case F5:
          hdlsk("total number of accounts in position ",SK_DISPOST);
          break;
     case F6:
          hdlsk("total number of calls to date in position ",SK_DISPOST);
          break;
     case F7:
          hdlsk("total number of uploads to date in position ",SK_DISPOST);
          break;
     case F8:
          hdlsk("total number of downloads to date in position ",SK_DISPOST);
          break;
     case F9:
          hdlsk("on auxiliary CRT ",SK_DISAUXC);
          break;
     case F10:
          hdlsk("screen saver after ",SK_DISSAVR);
          break;
     }
}

void
smsgdsp(void)                      /* select "display" variables           */
{
     switch (c) {
     case F1:
          hdlsk("total no. of E-mail & Forum msgs in position ",SK_DISPOST);
          break;
     case F2:
          hdlsk("open no. of E-mail msgs in position ",SK_DISPOST);
          break;
     case F3:
          hdlsk("open no. of Forum msgs in position ",SK_DISPOST);
          break;
     }
}

void
sscnsav(void)                      /* select screen saver option           */
{
     switch (c) {
     case F1:
          hdlsk("1 min. unused",SK_ENTER);
          break;
     case F2:
          hdlsk("2 min. unused",SK_ENTER);
          break;
     case F3:
          hdlsk("5 min. unused",SK_ENTER);
          break;
     case F4:
          hdlsk("30 min. unused",SK_ENTER);
          break;
     case F5:
          hdlsk("1 hour unused",SK_ENTER);
          break;
     case F6:
          hdlsk("never",SK_ENTER);
          break;
     }
}

void
skill(void)
{
     switch (c) {
     case F1:
          hdlsk("(suspend) User-ID: ",SK_UID);
          skbpeu=skbptr;
          break;
     case F2:
          hdlsk("user-account database record of User-ID: ",SK_UID);
          skbpeu=skbptr;
          break;
     case F3:
          hdlsk("channel no. ",SK_KILLCHN);
          break;
     case F9:
          hdlsk("system ",SK_KILLSYS);
          break;
     }
}

void
sentmin(void)                      /* select a minute count      */
{
     switch (c) {
     case F1:
          hdlsk("within 1 minute",SK_ENTER);
          break;
     case F2:
          hdlsk("within 2 minutes",SK_ENTER);
          break;
     case F3:
          hdlsk("within 5 minutes",SK_ENTER);
          break;
     case F4:
          hdlsk("within 10 minutes",SK_ENTER);
          break;
     case F6:
          hdlsk("UNDO!",SK_ENTER);
          break;
     case F8:
          hdlsk("as soon as possible",SK_ENTER);
          break;
     case F10:
          hdlsk("NOW",SK_ENTER);
          break;
     }
}

void
sauxcrt(void)                      /* select screen for aux. crt           */
{
     switch (c) {
     case F1:
          hdlsk("nothing",SK_ENTER);
          break;
     case F2:
          hdlsk("the account screen",SK_ENTER);
          break;
     case F3:
          hdlsk("the audit trail",SK_ENTER);
          break;
     case F4:
          hdlsk("the emulation screen",SK_ENTER);
          break;
     case F5:
          hdlsk("the statistics screen",SK_ENTER);
          break;
     case F6:
          hdlsk("the monitor-all screen",SK_ENTER);
          break;
     case F7:
          hdlsk("the users screen",SK_ENTER);
          break;
     case F8:
          hdlsk("the about screen",SK_ENTER);
          break;
     }
}

void
scklmod(void)                      /* enter a channel to kill and a mode   */
{
     if (opinf.opistt != SK_KILLCHNM && isxdigit(c&eurmsk)) {
          c=toupper(c&eurmsk);
          hdlskc(opinf.opistt == SK_KILLCHN ? SK_KILLCHN2 : SK_KILLCHNM);
     }
     else if (opinf.opistt != SK_KILLCHN) {
          switch (c) {
          case F1:
               hdlsk(" to \"BUSY-OUT\"",SK_ENTER);
               break;
          case F2:
               hdlsk(" to \"NO-ANSWER\"",SK_ENTER);
               break;
          case F3:
               hdlsk(" to normal",SK_ENTER);
               break;
          case F9:
          case '\r':
               retkey();
               break;
          }
     }
}

void
ssndac(void)                       /* send message to channel or all       */
{
     switch (c) {
     case F1:
          hdlsk("ALL online channels ",SK_ENTER);
          break;
     case F2:
          hdlsk("channel no. ",SK_INPCHN);
          break;
     }
}

void
sentamt(void)                      /* enter amount of credits to post      */
{
     char tmpbuf[10];

     if (isdigit(c&eurmsk) || c == '-') {
          hdlskc(SK_PDORFREE);
     }
     else if (c >= F1 && c <= F10) {
          strcpy(tmpbuf,skpwht(sklegs[SK_CRDAMTS][(c-F1)>>8]));
          depad(tmpbuf);
          hdlskm(tmpbuf,SK_PDORFREE);
     }
}

void
sentapf(void)                      /* enter "paid" or "free" credits       */
{
     switch (c) {
     case F1:
          hdlsk(" PAID credits to User-ID: ",SK_UID);
          skbpeu=skbptr;
          break;
     case F2:
          hdlsk(" FREE credits to User-ID: ",SK_UID);
          skbpeu=skbptr;
          break;
     default:
          if (isdigit(c&eurmsk) && strlen(cmlbuf) < 13) {
               hdlskc(SK_PDORFREE);
          }
     }
}

void
sentuid(void)                      /* enter a user-id                      */
{
     if (isuidc(c&eurmsk)) {
          c=c&eurmsk;
          if (skbptr == skbpeu) {
               hdlskc(SK_UID);
          }
          else {
               if (skbptr-skbpeu < 2) {
                    hdlskc(SK_UID);
               }
               else {
                    hdlskc(SK_UIDENTER);
               }
          }
     }
}

void
dwtxte(void)                       /* deal with text entered               */
{
     int clrcurs;

     locate(vcx,vcy);
     sstatr(lblhue);
     if (c == F1) {
          clrcurs=1;
          xltctls(txtstg);
          if (*(txtptr-1) == '\r') {
               *--txtptr='\0';
          }
          if (sndchn == -2) {
               strcpy(sv.lonmsg,txtstg);
          }
          else if (txtptr == txtstg) {
               sstatr(lblhue);
               printf(" \nNULL -- MESSAGE IGNORED ");
               clrcurs=0;
          }
          else if (sndchn >= 0) {
               snd2ch(sndchn,txtstg);
          }
          else if (sndchn == -1) {
               snd2al(txtstg);
          }
          vcx=curcurx();
          vcy=curcury();
          if (clrcurs) {
               setatr(lblhue);
               printf(" ");
          }
          quiesk(0);
          return;
     }
     else if (c == F10) {
          sstatr(lblhue);
          printf(" \nQUIT -- MESSAGE IGNORED ");
          vcx=curcurx();
          vcy=curcury();
          quiesk(0);
          return;
     }
     else if (c == 8 && txtptr != txtstg && *(txtptr-1) != '\r') {
          printf(" \10\10");
          *--txtptr='\0';
     }
     else if (txtptr-txtstg < MTXSIZ-1) {
          if (c == '\r') {
               printf(" \n");
               *txtptr++=(char)c;
               *txtptr='\0';
          }
          else if (c >= ' ' && (c&eurmsk)) {
               printf("%c",c);
               *txtptr++=(char)c;
               *txtptr='\0';
          }
     }
     vcx=curcurx();
     vcy=curcury();
     setatr(lblhue+0x80);
     printf("");
     if (vcx >= 77) {
          printf("\b ");
          vcx=curcurx();
          vcy=curcury();
          printf("");
     }
}

void
sselpos(void)                      /* select position for variables        */
{
     char tbuf[2]={0,0};

     if (c >= '1' && c <= '6') {
          c=F1+((c-'1')<<8);
     }
     tbuf[0]='1'+((c-F1)>>8);
     if (tbuf[0] >= '1' && tbuf[0] <= '6') {
          hdlsk(tbuf,SK_ENTER);
     }
}

void
sinpchn(void)                      /* input a channel number (first digit) */
{
     if (isxdigit(c&eurmsk)) {
          c=toupper(c&eurmsk);
          hdlskc(SK_INPCHN2);
     }
}

void
sinpch2(void)                      /* input a channel number (second digit)*/
{
     if (isxdigit(c&eurmsk)) {
          c=toupper(c&eurmsk);
          hdlskc(SK_ENTER);
     }
     else if (c == '\r' || c == F9) {
          retkey();
     }
}

void
sumrep(void)                  /* Summary screen repaint routine            */
{
     loadgph(dtmin(now()));
     doaditbx();
}

void
inisho(void)
{
     inilopr(maxscns,auxist);
     audbb=opnbtv("bbsaudit.dat",AUDSIZ);
     shdl=regscn(&summscn);
     backhdl=shdl;
     mhdl=regscn(&monascn);
     ahdl=regscn(&abouscn);
     emful=regscn(&emfuscn);
     ehdl=regscn(&emulscn);
     inidst();
     stahdl=regscn(&statscn);
     audhdl=regscn(&audiscn);
     acchdl=regscn(&accnscn);
     lsehdl=regscn(&lsesscn);
     hlphdl=regscn(&hlpscn);
     dfltmscn=shdl;
     quiesk(1);
     actvscn(shdl);
     scn2mai(shdl);
     auxups(sv.monmal);
     oldsys=syscyc;
     syscyc=sysrtm;
     rtkick(1,calrtm);
}

void
inisho2(void)
{
     int i;
     struct uidisp *uidptr;

     uidarr=(struct uidisp *)alcmem(hichp1*sizeof(struct uidisp));
     for (i=0,uidptr=uidarr ; i < hichp1 ; i++,uidptr++) {
          uidptr->attrib=ndfhue;
          uidptr->sing=LILYELBOX;
          uidptr->labl[0]='\0';
     }
     usshdl=regscn(&ussscn);
     emuchn(0);
     cur2sav=sec2sav=sv.savmin*60;
     doaditbx();
}

void
finsho(void)                       /* finish up stuff for shutdown         */
{
     int i;

     clsbtv(audbb);
     locate(0,24);
     for (i=0 ; i < 2 ; i++) {
          belper(600);
          printf("\7\7");
          belper(800);
          printf("\7\7");
     }
     endlopr();
}

void
dwopr(void)
{
     if (kbhit()) {
          keyhit(getchc());
     }
     emulupd();
     lsesupd();
     conupd();
}

void
iniaud(void)                       /* initialize audit trail display       */
{
     int i;
     extern long acptrs[8];

     setbtv(audbb);
     sstatr(stthue);
     setmem(atptrs,sizeof(atptrs),0);
     actvscnsp(shdl,23,1,70,9,1);
     printf("\14");
     gcrbtv(NULL,0);
     for (i=1 ; i <= NUMOFP ; i++) {
          atptrs[NUMOFP-i]=absbtv();
          printfat(23,10-i,"%14.14s %-32.32s",audbb->data,audbb->data+14);
          if (!qprbtv()) {
               break;
          }
     }
}

void
shocst(tex1,tex2,parm1,parm2,parm3)     /* display text to audit trail     */
char *tex1,*tex2,*parm1,*parm2,*parm3;
{
     char audrec[AUDSIZ+80];
     long oatbpt;
     char tmp[33];
     void fasadd(void);

     setmem(audrec,AUDSIZ,0);
     sprintf(audrec,"%-5.5s %s ",nctime(now()),ncdate(today()));
     sprintf(audrec+14,"%-32.32s ",tex1);
     switch (usrnum) {
     case -3:
          strcat(audrec,spr("Event %1.1d",errcod-10));
          break;
     case -2:
          strcat(audrec,"Cleanup");
          break;
     case -1:
          strcat(audrec,"Console");
          break;
     default:
          if (usrnum >= 0 && usrnum < nterms) {
               sprintf(tmp,"Chan %02X",channel[usrnum]);
          }
          else {
               sprintf(tmp,"U# %04X",usrnum);
          }
          strcat(audrec,tmp);
     }
     audrec[sizeof(audrec)-1]='\0';
     audrec[AUDSIZ-2]='\0';
     sprintf(audrec+67,tex2,parm1,parm2,parm3);
     if (audrec[sizeof(audrec)-1] != '\0') {
          catastro("AUDIT TRAIL MESSAGE TOO LONG!\n\"%s\"",audrec+67);
     }
     if (audrec[AUDSIZ-2] != '\0') {
          strcpy(&audrec[AUDSIZ-3],"*");
     }
     setbtv(audbb);
     insbtv(audrec);
     if (sopaud && ntfysopr != NULL) {
          (*ntfysopr)(audrec);
     }
     oatbpt=atbptr;
     atbptr=absbtv();
     rstbtv();
     if (atptrs[NUMOFP-1] == oatbpt) {
          sstatr(stthue);
          actvscnsp(shdl,23,1,70,9,1);
          printfat(23,9,"\n%14.14s %-32.32s",audrec,audrec+14);
          movmem(atptrs+1,atptrs,(NUMOFP-1)*sizeof(long));
          atptrs[NUMOFP-1]=atbptr;
          rstloc();
          rstwin();
     }
     fasadd();
     if (rsyfad_hook != NULL) {
          (*rsyfad_hook)();
     }
     doaditbx();
}

void
scroat(dirct)                      /* scroll audit trail window up (0=down)*/
int dirct;
{
     int i;
     char *crtadr;

     crtadr=actvscnsp(shdl,23,1,70,9,1);
     setbtv(audbb);
     sstatr(stthue);
     if (dirct) {
          gabbtv(NULL,atptrs[NUMOFP-1],0);
          if (qnxbtv()) {
               printfat(23,9,"\n%14.14s %-32.32s",audbb->data,audbb->data+14);
               movmem(atptrs+1,atptrs,(NUMOFP-1)*sizeof(long));
               atptrs[NUMOFP-1]=absbtv();
          }
     }
     else if (atptrs[0] != 0) {
          for (i=NUMOFP-1 ; i >= 1 ; i--) {
               movmem(crtadr+(i*160)+46,crtadr+((i+1)*160)+46,(70-23)*2);
          }
          gabbtv(NULL,atptrs[0],0);
          movmem(atptrs,atptrs+1,(NUMOFP-1)*sizeof(long));
          locate(23,1);
          if (qprbtv()) {
               printf("%14.14s %-32.32s",audbb->data,audbb->data+14);
               atptrs[0]=absbtv();
          }
          else {
               printf("%14.14s %-32.32s","","");
               atptrs[0]=0;
          }
     }
     atmess=1;
}

void
shochl(legend,sing,attr)           /* show legend for chan with any attrib   */
char *legend;
char sing;
int attr;
{
     int chan;
     int chncol,chnrow;
     char *vptr;

     vptr=actvscn(shdl);
     chan=channel[usrnum];
     sprintf(uidarr[chan].labl,"%-*.*s",LGNSIZ-1,LGNSIZ-1,legend);
     uidarr[chan].attrib=attr;
     uidarr[chan].sing=sing;
     chnrow=chan&0x0F;
     chncol=(chan&0xF0)>>4;
     *(vptr+((chnrow+2)*160)+(2*(chncol+3))+1)=scncolor(attr|0x08);
     *(vptr+((chnrow+2)*160)+(2*(chncol+3)))=sing;
     if (shochl_hook != NULL) {
          (*shochl_hook)(chan);
     }
     usrchl();
}

void
loadgph(min)                  /* draw the load graph!                      */
int min;
{
     int loff,i,j,avld,modmin;
     int l1,l2,l3,thmin;

     modmin=min%3;
     thmin=((min+3)%60)-modmin;         /* graph begins on 3 minute bound  */
     loff=thmin/3;                      /* label offset                    */
     actvscn(shdl);
     sstatr(gphhue);
     printfat(25,17,"%20.20s",minlabl+loff);
     for (i=0 ; i < 20 ; i++) {
          l1=l2=l3=sysload[(thmin+(3*i))%60];
          if (i != 19 || modmin > 0) {
               l2=sysload[(thmin+(3*i)+1)%60];
          }
          if (i != 19 || modmin > 1) {
               l3=sysload[(thmin+(3*i)+2)%60];
          }
          avld=((nterms+(nterms>>1))+10*(l1+l2+l3))/(3*nterms);
          for (j=0 ; j < 10 ; j+=2) {
               if (avld >= j+1) {
                    printfat(25+i,16-(j/2),"");
               }
               else if (avld == j) {
                    printfat(25+i,16-(j/2),"");
               }
               else {
                    printfat(25+i,16-(j/2)," ");
               }
          }
     }
}

int
linsusd(void)                 /* return number of lines in use             */
{
     int i,y;

     y=0;
     for (i=0 ; i < nterms ; i++) {
          if (user[i].class != VACANT) {
               y++;
          }
     }
     return(y);
}

void
doaditbx(void)                     /* Do green additional info box         */
{
     static int wycoor[6]={12,13,14,15,16,17};
     int i;
     unsigned long eavl;

     actvscnsp(shdl,48,12,71,18,0);
     if (kilipg) {
          sstatr(0x09c);
          if (kilctr > 0) {
               printfat(48,11,"Shutdown in %2.2d min.",kilctr);
          }
          else if (kilctr == 0) {
               printfat(48,11,"Shutting down NOW! ",kilctr);
          }
          else {
               printfat(48,11,"Shutting down ASAP ",kilctr);
          }
     }
     else {
          sstatr(vtxhue);
          printfat(48,11,"%-5.5s %s      ",nctime(now()),ncdate(today()));
     }
     sstatr(vtxhue);
     for (i=0 ; i < 6 ; i++) {
          locate(48,wycoor[i]);
          sstatr(vtxhue);
          switch (sv.dspopt[i]) {
          case 0:
               break;
          case 1:
#ifdef PHARLAP
               DosMemAvail(&eavl);
#else
               eavl=sizmem();
#endif
               if (eavl < 4096L) {
                    sstatr(0x9c);
               }
               printf("Memory avail:  %8.8s",dbytes(eavl));
               break;
          case 3:
               eavl=getdfre(0);
               if (eavl < 1024L*1024L) {
                    sstatr(0x9c);
               }
               printf("HD room avail:  %7.7s",dbytes(eavl));
               break;
          case 4:
               printf("Response time:  %s",rtmfmt(rsptim));
               break;
          case 5:
               printf("Active accnts: %8.8u",sv2.numact);
               break;
          case 6:
               printf("Calls to date: %8.8s",l2as(sv2.totcalls));
               break;
          case 7:
               printf("Tot uploads:   %8.8s",l2as(sv.uplds));
               break;
          case 8:
               printf("Tot dnloads:   %8.8s",l2as(sv.dwnlds));
               break;
          case 21:
               printf("Tot mail/Forum: %7.7s",l2as(sv.msgtot));
               break;
          case 22:
               printf("Opn E-mail:   %9.9u",sv.emlopn);
               break;
          case 23:
               printf("Opn Forum msgs: %7.7u",sv.sigopn);
               break;
          }
     }
}

void
quiesk(int blk)                    /* quiescent soft key legends setup     */
{
     int dif;

     actvscnsp(dfltmscn,CMWXUL,CMWYUL,CMWXLR,CMWYLR,1);
     if (blk == 1) {
          dif=(int)(opinf.cmlptr-cmlbuf);
          if (dif >= 0 && dif <= 78) {
               locate(CMWXUL+dif,CMWYLR);
               setatr(lblhue);
               printf(" ");
          }
     }
     zappo();
     opinf.opistt=SK_QUIET;
     plosk(0);
     *(opinf.cmlptr=cmlbuf)='\0';
     *(skbptr=skbuf)=0;
     acckey();
     quiefl=1;
     skcipg=0;
}

void
zappo(void)                        /* unravel soft key linked-list trail   */
{
     struct otrail *otrptr;

     while ((otrptr=opinf.link) != NULL) {
          opinf.link=otrptr->link;
          free(otrptr);
     }
}

void
plosk(sktnum)                      /* "plot" soft key table no. sktnum     */
int sktnum;
{
     char **plskpt;
     int i;

     actvscn(dfltmscn);
     sstatr(lblhue);
     zapskl();
     for (plskpt=sklegs[sktnum],i=1 ; i <= 10 ; plskpt++,i++) {
          lblsk(i,*plskpt);
     }
}

void
zapskl(void)                  /*  clear soft key legends                   */
{
     int i;

     for (i=1 ; i <= 10 ; i++) {
          lblsk(i,i == 5 ? "      ": "       ");
     }
}

void
lblsk(sknum,lblstg)           /* label soft keys with legends              */
int sknum;
char *lblstg;
{
     locate((sknum-1)*8+(sknum < 6),23);
     printf(lblstg);
}

void
acckey(void)                  /* accept a soft-key keystroke (build trail) */
{
     struct otrail *otrptr;

     otrptr=(struct otrail *)alcmem(sizeof(struct otrail));
     movmem(&opinf,otrptr,sizeof(struct otrail));
     opinf.link=otrptr;
}

void
bckspc(void)                  /* backspace over previous soft-key command  */
{
     struct otrail *otrptr;

     if (opinf.link->link != NULL) {
          otrptr=opinf.link;
          opinf.link=otrptr->link;
          free(otrptr);
          otrptr=opinf.link;
          movmem(otrptr,&opinf,sizeof(struct otrail));
          opinf.link=otrptr;
          plosk(opinf.opistt);
          *opinf.cmlptr='\0';
          *--skbptr='\0';
          actvscnsp(dfltmscn,CMWXUL,CMWYUL,CMWXLR,CMWYLR,1);
          locate(CMWXUL+((int)(opinf.cmlptr-cmlbuf)),CMWYLR);
          if (curcurx() > CMWXUL) {
               setatr(lblhue+0x80);
               printf("");
          }
          sstatr(lblhue);
          clreol();
          cursact(0);
     }
}

void
hdlskm(echstg,opistt)              /*  handle entry of a soft key macro    */
char *echstg;
int opistt;
{
     int i;

     for (i=0 ; i < strlen(echstg) ; i++) {
          c=echstg[i];
          hdlskc(opistt);
     }
}

void
hdlskc(                            /* handle entry of a soft key command   */
int opistt)
{
     static char stg[2]={0,0};

     stg[0]=(char)c;
     hdlsk(stg,opistt);
}

void
hdlsk(                        /* handle entry of a soft key command utility*/
char *echstg,
int opistt)
{
     fiddle=1;
     strcpy(opinf.cmlptr,echstg);
     opinf.cmlptr+=strlen(echstg);
     actvscnsp(dfltmscn,CMWXUL,CMWYUL,CMWXLR,CMWYLR,1);
     locate(CMWXUL,CMWYLR);
     sstatr(lblhue);
     if (quiefl) {
          quiefl=0;
          printf("\n");
     }
     printf("%s",cmlbuf);
     setatr(lblhue+0x80);
     printf("");
     *skbptr++=c;
     *skbptr=0;
     cursact(0);
     plosk(opistt);
     opinf.opistt=opistt;
     acckey();
}

void
retkey(void)                       /* handle soft-key commands now         */
{
     int tmplen,real;

     collap();
     actvscnsp(dfltmscn,CMWXUL,CMWYUL,CMWXLR,CMWYLR,1);
     locate(CMWXUL+((int)(opinf.cmlptr-cmlbuf)),CMWYLR);
     fiddle=1;
     switch (skbuf[0]) {
     case F2:
          if (skbuf[1] == F1) {
               sndchn=-1;
          }
          else {
               locate(curcurx()+strlen(&cskbuf[2])-1,CMWYLR);
               sscanf(&cskbuf[2],"%x",&sndchn);
               if ((sndchn=usridx(sndchn)) < 0) {
                    break;
               }
          }
          sstatr(lblhue);
          if ((skbuf[1] == F1) || (skbuf[1] != F1 && skbptr-skbuf == 4)) {
               printf("\b");
          }
          printf(": \n");
          *(txtptr=txtstg)='\0';
          vcx=2;
          vcy=21;
          setatr(lblhue+0x80);
          printf("");
          plosk(opinf.opistt=SK_INPMSG);
          break;
     case F3:
          if (skbuf[1] == F9) {                        /* aux crt          */
               sv.monmal=(char)((skbuf[2]-F1)>>8);
               auxups(sv.monmal);
          }
          else if (skbuf[1] == F10) {                  /* saver control    */
               sv.savmin=savmins[(skbuf[2]-F1)>>8];
               cur2sav=sec2sav=sv.savmin*60;
          }
          else if (skbuf[1] == F2) {
               sv.dspopt[(skbuf[3]-F1)>>8]=((skbuf[2]-F1)>>8)+21;
          }
          else {
               sv.dspopt[(skbuf[2]-F1)>>8]=((skbuf[1]-F1)>>8)+1;
          }
          quiesk(1);
          doaditbx();
          break;
     case F4:
          usrnum=-1;
          tmplen=strlen(&cskbuf[1]);
          real=(skbuf[tmplen+1] == F1);
          switch (addcrd(&cskbuf[tmplen+2],&cskbuf[1],real)) {
          case 1:
               saycrd(&cskbuf[1],real);
          case 0:
               quiesk(1);
          }
          break;
     case F5:
          quiesk(1);
          dspact(&cskbuf[1]);
          scn2mai(acchdl);
          break;
     case F6:
          sstatr(lblhue);
          printf(": \n");
          sndchn=-2;
          *(txtptr=txtstg)='\0';
          vcx=2;
          vcy=21;
          plosk(opinf.opistt=SK_INPMSG);
          break;
     case F10:
          switch (skbuf[1]) {
          case F1:
               usrnum=-1;
               if (kiluid(&cskbuf[2]) >= 0) {
                    quiesk(1);
               }
               break;
          case F2:
               usrnum=-1;
               if (delacct(&cskbuf[2]) >= 0) {
                    quiesk(1);
               }
               break;
          case F3:
               sscanf(&cskbuf[2],"%x",&usrnum);
               if ((usrnum=usridx(usrnum)) < 0) {
                    break;
               }
               else {
                    switch (!isxdigit(skbuf[3]&eurmsk) ? skbuf[3] : skbuf[4]) {
                    case 0:
                         hdlsk(" to normal",SK_ENTER);
                    case F3:
                         rsmode=NORMRS;
                         break;
                    case F2:
                         rsmode=NANSRS;
                         break;
                    case F1:
                         rsmode=BUSYRS;
                         break;
                    }
                    rsmodes[usrnum]=rsmode;
                    kilchn(usrnum);
               }
               quiesk(1);
               break;
          case F9:
               if (skbuf[2] == F6) {         /* kill system UNDO           */
                    if (!kilnow) {
                         kilipg=0;
                         rsmode=NORMRS;
                         prepff();
                         kilctr=-1;
                    }
               }
               else {
                    kilsrc=-1;
                    switch (skbuf[2]) {
                    case F1:                 /* kill system in 1 minute    */
                         kilctr=1;
                         break;
                    case F2:
                         kilctr=2;
                         break;
                    case F3:
                         kilctr=5;
                         break;
                    case F4:
                         kilctr=10;
                         break;
                    case F8:
                         kilctr=-1;                    /* kill system ASAP */
                         break;
                    case F10:
                         kilctr=0;                     /* kill system NOW  */
                         kilnow=1;
                         break;
                    }
                    fupkil();
               }
               quiesk(1);
               break;
          }
     }
}

void
auxups(char snum)             /* display an aux. screen                    */
{
     switch (snum) {
     case 0:
          break;
     case 1:
          scn2aux(acchdl);
          break;
     case 2:
          scn2aux(audhdl);
          break;
     case 3:
          scn2aux(emful);
          break;
     case 4:
          scn2aux(stahdl);
          break;
     case 5:
          scn2aux(mhdl);
          break;
     case 6:
          scn2aux(usshdl);
          break;
     case 7:
          scn2aux(ahdl);
          break;
     }
}

void
collap(void)                  /* collapse 2-bytes/key to 1-byte/key buffer */
{
     int *skptr;
     char *cskptr;

     setmem(cskbuf,sizeof(cskbuf),0);
     for (skptr=skbuf,cskptr=cskbuf ; skptr != skbptr ; ) {
          *cskptr++=(char)((*skptr++)&255);
     }
}

void
fupkil(void)                       /* prep for kill from remote sysop      */
{
     int kilib4,temp;

     rsmode=rsetop;
     kilib4=kilipg;
     kilipg=1;
     temp=usrnum;
     prepff();
     if (!kilib4 || kilctr == 0) {
          kiloop();
     }
     curusr(temp);
}

void
snd2ch(chan,text)                  /* send text to a specific channel      */
int chan;
char *text;
{
     if (user[chan].class > SUPIPG) {
          othusn=chan;
          setmbk(mjrmb);
          prfmlt(FRMSYS,text);
          prfmlt(FSYSTRL);
          injoth();
          rstmbk();
     }
}

void
snd2al(text)                       /* send text to all online channels     */
char *text;
{
     int i;

     for (i=0 ; i < nterms ; i++) {
          snd2ch(i,text);
     }
}

void
dftbel(local)                      /* set belper() for screen update       */
int local;                              /* local session? (1 or 0=emulated)*/
{
     if ((local && mainhdl == lsehdl) ||
         (!local && (mainhdl == ehdl || mainhdl == emful))) {
          emubel=visbel;
     }
     else {
          emubel=invbel;
     }
     belper(emubel);
}

char *
chlpfn(void)                       /* get current screen's help file name  */
{
     if (mainhdl == acchdl) {
          return("BBSACHLP.BIN");
     }
     if (mainhdl == audhdl) {
          return("BBSATHLP.BIN");
     }
     if (mainhdl == stahdl) {
          return("BBSSTHLP.BIN");
     }
     if (mainhdl == mhdl) {
          return("BBSMOHLP.BIN");
     }
     if (mainhdl == shdl) {
          return("BBSSMHLP.BIN");
     }
     if (mainhdl == usshdl) {
          return("BBSUSHLP.BIN");
     }
     if (mainhdl == ahdl) {
          return("BBSABHLP.BIN");
     }
     if (mainhdl == ehdl || mainhdl == emful) {
          return("BBSEMHLP.BIN");
     }
     return(NULL);
}

void
psmatm(void)                  /* send sysop page to main console (old form)*/
{
     if (margc > 2) {
          psmatms(margv[2]);
     }
}

void
psmatms(                      /* send sysop page to main console           */
char *pagmsg)
{
     if (opinf.opistt == SK_QUIET && pagmsg[0] != '\0') {
          if (sec2sav > 0 && cur2sav == 0) {
               unsavscns();
               cur2sav=sec2sav;
          }
          actvscnsp(dfltmscn,CMWXUL,CMWYUL,CMWXLR,CMWYLR,1);
          locate(CMWXUL,CMWYLR);
          sstatr(lblhue);
          rstrin();
          printf("\n%s paged (%-5.5s): %s",usaptr->userid,nctime(now()),
                                           pagmsg);
          quiefl=1;
          updbckgnd();
     }
}

char *
rtmfmt(                            /* format Response Time number          */
unsigned long ntval)               /* interval, 1/65536 second units       */
{                                  /* returns pointer to 7-character string*/
     char *cp;

     if (ntval >= HRTONE) {
          if (strlen(cp=ul2as((ntval+HRTONE/2)>>16)) > 3) {
               return("999 sec");
          }
          else if ((ntval=((ntval+HRTONE/20)*10)>>16) > 99L) {
               return(spr("%3s sec",cp));
          }
          else {
               return(spr("%d.%d sec",((int)ntval)/10,((int)ntval)%10));
          }
     }
     else {
          if (strlen(cp=ul2as(ntval=((ntval+HRTONE/2000)*1000)>>16)) > 3) {
               return(" 999 ms");
          }
          else if (ntval > 0L) {
               return(spr("%4s ms",cp));
          }
          else {
               return(" < 1 ms");
          }
     }
}

void
calrtm(void)                            /* calculate system response time  */
{
     unsigned long cyctim;              /* cycle time (2*avg response time)*/

     if (rtmcnt <= 1L) {
          cyctim=max(rtmlst-rtmlls,hrtval()-rtmlst);
     }
     else {
          cyctim=(rtmlst-rtmfst)/(rtmcnt-1L);
     }
     rsptim=(cyctim/2+(RTMSMP-1)*rsptim+RTMSMP/2)/RTMSMP;
     if (rsptim > LOADFX*65535U) {
          syslod=65535U;
     }
     else {
          syslod=(unsigned)(rsptim/LOADFX);
     }
     rtmcnt=0L;
     rtkick(RTMRAT,calrtm);
}

void
sysrtm(void)                            /* record info for response time   */
{
     rtmlls=rtmlst;
     rtmlst=hrtval();
     if (rtmcnt == 0L) {
          rtmfst=rtmlst;
     }
     rtmcnt++;
     (*oldsys)();
}

