/***************************************************************************
 *                                                                         *
 *   OPRLOW.H                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Low level operator console for dealing with virtual screens,          *
 *   screen saving, dynamic registration, etc.                             *
 *                                                                         *
 *                                            - Robert A. Rose 02/05/92    *
 *                                                                         *
 ***************************************************************************/

struct scrnid {
     char *scnnam;            /* screen filename                           */
     int scnlen;              /* length of screen (4000 for full screen)   */
     int selssc;              /* select scan code (from main screen)       */
                              /* ala 'Keyboard Accelerator'                */
     void (*byerou)();        /* screen going away routine                 */
     void (*updrou)();        /* screen repaint routine                    */
     unsigned (*keyrou)();    /* key handler routine                       */
     void (*occrou)();        /* occasional update routine                 */
     int secs;                /* seconds between occasional updates        */
     int secs2go;             /* seconds to go before next update          */
     void (*disrou)();        /* called every cycle when displayed         */
     int cx,cy;               /* current cursor position on screen         */
     int curmove;             /* does cursor move?                         */
     int scroll;              /* should screen scroll?                     */
     int x1,y1,x2,y2;         /* scrolling for window (default)            */
     char *buffer;            /* perm. save buffer                         */
     char *location;          /* current location of screen                */
};

extern int mainhdl,           /* handle of screen on main (0=none)         */
           auxhdl,            /* handle of screen on aux (0=none)          */
           actvhdl,           /* what handle is active currently?          */
           backhdl,           /* handle for background (on actvscns < 4000)*/
           sec2mov,           /* seconds left before moving saver display  */
           sec2sav,           /* configured seconds to save screens 0=never*/
           cur2sav,           /* how much longer before we save screens    */
                              /* cur2sav=0 means screens are saved         */
           occgran,           /* granularity of occrou cycling             */
           maxscns,           /* maximum number of screens to allow        */
           regscns,           /* number of registered screens              */
           dfltmscn,          /* default main screen to show               */
           dfltascn,          /* default aux screen to show                */
           skcipg,            /* force all keys to background handler      */
           color;             /* is main display color?                    */

extern struct scrnid *scnids,*scncur;

#define LGNSIZ      47        /* maximum size of channel legends           */

extern
struct uidisp {               /* users screen display data                 */
     char sing;               /*    single character legend                */
     char attrib;             /*    attribute for legend/labels            */
     char labl[LGNSIZ];       /*    full legend for channel                */
} *uidarr;

#define saveworld(x) movmem(&curatr,x,sizeof(struct curatr))
#define restworld(x) movmem(x,&curatr,sizeof(struct curatr))

/* OPRLOW API calls:                                                       */

char *                             /* rtns pointer to screen buffer        */
actvscn(                      /* make scnhdl the active screen for printfs */
int scnhdl);                       /* screen handle (returned by regscn)   */

char *                             /* rtns pointer to screen buffer        */
actvscnsp(                    /* make scnhdl the active screen for printfs */
int scnhdl,                        /* screen handle (returned by regscn)   */
int x1, int y1,                    /* bounds and scroll (ovrids scnid sets)*/
int x2, int y2,
int scn);

void
updbckgnd();                  /* update visible piece of the background    */

void
scngoaway(                    /* screen wants to hide itself               */
int scnhdl);                       /* screen handle                        */

int                                /* returns handle number                */
regscn(                       /* register a screen for display             */
struct scrnid *newscn);            /* screen id block                      */

void
memswap(                      /* swap two memory regions (without buffer)  */
char *source,                      /* source buffer                        */
char *dest,                        /* destination buffer                   */
int length);                       /* length in bytes to move              */

void
hidecurs(                     /* hide cursor on a screen                   */
int scnhdl);

int
baudat(                       /* Set color attribute based on baud         */
unsigned baud,
int blink);

void
cls(                          /* Clear a screen to blanks                  */
char *buf,                         /* screen buffer to clear               */
int atr);                          /* attribute to clear to                */

/* OPRLOW System calls:                                                    */
void
inilopr(                      /* initialize OPRLOW code                    */
int mxscn,                         /* maximum number of screens to allow   */
int auxena);                       /* aux crt support enabled              */

void
endlopr();                    /* shutdown OPRLOW code                      */

unsigned
keyhit(                       /* Process a key from the console            */
unsigned scan);                    /* scan code of key hit                 */

void
conupd();                     /* Constant update (for displayed screens)   */

void
scn2mai(                      /* make screen visible on main crt           */
int scnhdl);                       /* screen handle                        */

void
scn2aux(                      /* make screen visible on aux. crt           */
int scnhdl);                       /* screen handle                        */

/* OPRLOW Internal calls:                                                  */

void
occhdl();                     /* Occasional update routine                 */

void
mai2aux();                    /* swap main and aux. crts                   */

void
shobox(                       /* Message that walks during screen saving   */
int w,                             /* Which screen coords to use (main,aux)*/
int sho);                          /* 1=show boxe, 0=remove box            */

void
unsavscns();                  /* unsave screens that have been saved       */

void
savscns();                    /* save screens to prevent burn-in           */

char *
dbytes(                       /* convert # into xxx, xxxKb, xxxMb, or xxxGb*/
long bytes);
