/***************************************************************************
 *                                                                         *
 *   OPRLOW.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Low level operator console (version 6+) for dealing with virtual      *
 *   screens, screen saving, dynamic registration, etc.                    *
 *                                                                         *
 *                                            - Robert A. Rose 02/01/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

#define FILREV "$Revision: 1.2 $"

void scn2mai(int scnhdl);
void scn2aux(int scnhdl);
void mai2aux(void);

struct scrnid *scnids,*scncur;

char *maincrt=NULL;           /* pointer to main crt                       */
char *auxcrtm=NULL;           /* pointer to aux. crt                       */
int  mainx,mainy;             /* cursor storage spots                      */
int  wasactv=0;               /* 1=cursor position is actvhdl, 0=mainhdl   */
int  mainhdl=0;               /* handle of screen on main (0=none)         */
int  auxhdl=0;                /* handle of screen on aux (0=none)          */
int  savmai=0,savaux=0;       /* handle of saved screens                   */
int  actvhdl=0;               /* what handle is active currently?          */
int  lasmhdl=0;               /* handle before last scn2mai()              */
int  lasahdl=0;               /* handle before last scn2aux()              */
int  backhdl=0;               /* handle for background (on actvscns < 4000)*/
int  skcipg=0;                /* force all keys to background handler      */

int  sec2mov=0;               /* seconds left before moving saver display  */
int  sec2sav=0;               /* configured seconds to save screens 0=never*/
int  cur2sav=16500;           /* how much longer before we save screens    */
                              /* cur2sav=0 means screens are saved         */
int  occgran=60;              /* granularity of occrou cycling             */

int  mxscns=0;                /* maximum number of screens to allow        */
int  regscns=0;               /* number of registered screens              */
int  dfltmscn=0;              /* default main screen to show               */
int  dfltascn=0;              /* default aux screen to show                */

void
inilopr(                      /* initialize OPRLOW code                    */
int maxs,                          /* maximum number of screens to allow   */
int auxena)                        /* aux crt support enabled              */
{
     mxscns=maxs;
     scnids=(struct scrnid *)alczer(mxscns*sizeof(struct scrnid));
     maincrt=frzseg();
     if (auxena) {
          auxcrtm=auxcrt();
     }
     rtkick(2,occhdl);
}

void
endlopr(void)                 /* shutdown OPRLOW code                      */
{
     free(scnids);
}

char *                             /* rtns pointer to screen buffer        */
actvscn(                      /* make scnhdl the active screen for printfs */
int scnhdl)                        /* screen handle (returned by regscn)   */
{
     return(actvscnsp(scnhdl,
         scnids[scnhdl].x1,scnids[scnhdl].y1,
         scnids[scnhdl].x2,scnids[scnhdl].y2,
         scnids[scnhdl].scroll));
}

char *                             /* rtns pointer to screen buffer        */
actvscnsp(                    /* make scnhdl the active screen for printfs */
int scnhdl,                        /* screen handle (returned by regscn)   */
int x1,int y1,                     /* bounds and scroll (ovrids scnid sets)*/
int x2,int y2,int scr)
{
     if (scnhdl == 0) {
          scnhdl=actvhdl;
     }
     scnids[actvhdl].cx=curcurx();
     scnids[actvhdl].cy=curcury();
     setwin(scnids[scnhdl].location,x1,y1,x2,y2,scr);
     cursact(0);
     locate(scnids[scnhdl].cx,scnids[scnhdl].cy);
     if (scnhdl == mainhdl) {
          if (scnids[scnhdl].curmove) {
               cursact(1);
               cursiz(LILCURS);
          }
          else {
               cursiz(NOCURS);
          }
     }
     actvhdl=scnhdl;
     return(scnids[scnhdl].location);
}

void
updbckgnd(void)               /* update visible piece of the background    */
{
     int mainlen;

     mainlen=scnids[mainhdl].scnlen;
     if (mainlen < 4000) {
          movmem(scnids[backhdl].location+mainlen,maincrt+mainlen,4000-mainlen);
     }
}

void
conupd(void)                  /* Constant update (for displayed screens)   */
{
     void (*rouptr)();
     static unsigned long oldhrt;

     if (hrtval()-oldhrt > 3855) {      /* 3855=1/17 sec                   */
          if ((rouptr=scnids[mainhdl].disrou) != NULL) {
               (*(rouptr))();
          }
          if ((rouptr=scnids[auxhdl].disrou) != NULL) {
               (*(rouptr))();
          }
          oldhrt=hrtval();
     }
}

void
occhdl(void)                  /* Occasional update routine                 */
{
     int i;
     void (*rouptr)();
     struct scrnid *occscn;

     for (i=1 ; i <= regscns ; i++) {
          occscn=scnids+i;
          if ((rouptr=occscn->occrou) != NULL) {
               occscn->secs2go-=occgran;
               if (occscn->secs2go <= 0) {
                    (*(rouptr))();
                    occscn->secs2go=occscn->secs;
               }
          }
     }
     if (sec2sav != 0) {
          if (cur2sav > 0) {            /* not saved, but getting there..  */
               cur2sav-=occgran;
               if (cur2sav <= 0) {      /* actively save these guys...     */
                    cur2sav=0;
                    sec2mov=60+occgran;
                    savscns();
               }
          }
          else if (cur2sav == 0) {      /* already saved...                */
               sec2mov-=occgran;
               if (sec2mov <= 0) {
                    sec2mov=60;
                    setwin(NULL,0,0,79,24,1);
                    shobox(0,1);
                    rstwin();
               }
          }
     }
     rtkick(occgran,occhdl);
}

unsigned
keyhit(                       /* Process a key from the console            */
unsigned scan)                     /* scan code of key hit                 */
{
     int i;

     if (sec2sav > 0) {
          if (cur2sav > 0) {       /* reset counter if saver is turned on  */
               cur2sav=sec2sav;
          }
          else if (cur2sav == 0) {
               unsavscns();
               cur2sav=sec2sav;
               scan=0;
          }
     }
     if (scan != 0 && skcipg) {
          scan=(*(scnids[backhdl].keyrou))(scan);
          updbckgnd();
     }
     else {
          if (scan != 0 && scnids[mainhdl].keyrou != NULL) {
               scan=(*(scnids[mainhdl].keyrou))(scan);
          }
          if (scan != 0 && scnids[auxhdl].keyrou != NULL) {
               scan=(*(scnids[auxhdl].keyrou))(scan);
          }
          if (scan != 0 && scnids[backhdl].keyrou != NULL) {
               scan=(*(scnids[backhdl].keyrou))(scan);
               updbckgnd();
          }
          if (scan != 0) {
               for (i=1 ; i <= regscns ; i++) {
                    if (scan == scnids[i].selssc) {
                         scn2mai(i);
                         break;
                    }
               }
          }
     }
     return(scan);
}

void
scngoaway(                    /* screen wants to hide itself               */
int scnhdl)                        /* screen handle                        */
{
     if (scnhdl == 0 || (scnhdl != mainhdl && scnhdl != auxhdl)) {
          return;
     }
     if (scnhdl == mainhdl && lasmhdl != 0) {
          scn2mai(lasmhdl);
     }
     else if (scnhdl == auxhdl && lasahdl != 0) {
          scn2aux(lasahdl);
     }
     else if (scnhdl == mainhdl && dfltmscn != 0) {
          scn2mai(dfltmscn);
     }
     else if (scnhdl == auxhdl && dfltascn != 0) {
          scn2aux(dfltascn);
     }
}

void
scn2mai(                      /* make screen visible on main crt           */
int scnhdl)                        /* screen handle                        */
{
     int i;
     void (*rouptr)();

     if ((rouptr=scnids[mainhdl].byerou) != NULL) {
          (*(rouptr))();
     }
     if (scnhdl == auxhdl) {
          scncur=scnids+auxhdl;              /* put back current main scn  */
          *((char *)auxcrtm+scncur->scnlen-160)='';
          *((char *)auxcrtm+scncur->scnlen-2)='';
          movmem(auxcrtm,scncur->buffer,scncur->scnlen);
          scncur->location=scncur->buffer;
          for (i=0 ; i < 4000 ; i+=2) {
               *(auxcrtm+i)=' ';
               *(auxcrtm+i+1)=0x07;
          }
          auxhdl=0;
     }
     lasmhdl=mainhdl;
     scncur=scnids+mainhdl;             /* put back current main scn  */
     scn2mem(maincrt,scncur->buffer,scncur->scnlen);
     scncur->location=scncur->buffer;
     mainhdl=scnhdl;
     actvscn(scnhdl);
     if ((rouptr=scnids[scnhdl].updrou) != NULL) {
          (*(rouptr))();
     }
     scncur=scnids+scnhdl;              /* put new guy up             */
     movmem(scncur->buffer,maincrt,scncur->scnlen);
     if (scncur->scnlen < 4000) {       /* if partial screen...       */
          movmem(scnids[backhdl].location+scncur->scnlen,
                 maincrt+scncur->scnlen,4000-scncur->scnlen);
     }
     scncur->location=maincrt;
     if (auxhdl != sv.monmal) {
          auxups(sv.monmal);
     }
}

void
scn2aux(                      /* make screen visible on aux. crt           */
int scnhdl)                        /* screen handle                        */
{
     void (*rouptr)();
     int i;

     if ((rouptr=scnids[scnhdl].updrou) != NULL) {
          (*(rouptr))();
     }
     if (auxcrtm != NULL && scnhdl != mainhdl) {
          lasahdl=auxhdl;
          if (auxhdl != 0 && (rouptr=scnids[auxhdl].byerou) != NULL) {
               (*(rouptr))();
          }
          if (auxhdl != 0) {
               scncur=scnids+auxhdl;              /* put back current main scn  */
               movmem(auxcrtm,scncur->buffer,scncur->scnlen);
               scncur->location=scncur->buffer;
          }
          if (scnhdl == 0) {
               for (i=0 ; i < 4000 ; i+=2) {
                    *(auxcrtm+i)=' ';
                    *(auxcrtm+i+1)=0x07;
               }
               auxhdl=0;
               return;
          }
          scncur=scnids+scnhdl;              /* put new guy up             */
          movmem(scncur->buffer,auxcrtm,scncur->scnlen);
          if (scncur->scnlen < 4000) {       /* if partial screen blank it */
               *((char *)auxcrtm+scncur->scnlen-160)='';
               *((char *)auxcrtm+scncur->scnlen-2)='';
               for (i=scncur->scnlen ; i < 4000 ; i+=2) {
                    *(auxcrtm+i)=' ';
                    *(auxcrtm+i+1)=0x07;
               }
          }
          scncur->location=auxcrtm;
          auxhdl=scnhdl;
     }
}

void
mai2aux(void)                 /* swap main and aux. crts                   */
{
     int tint;
     char *tstg;

     lasmhdl=mainhdl;
     lasahdl=auxhdl;
     scncur=scnids+mainhdl;
     if (scnids[mainhdl].scnlen < 4000 || scnids[auxhdl].scnlen < 4000) {
          memswap(maincrt,auxcrtm,min(scnids[mainhdl].scnlen,scnids[auxhdl].scnlen));
     }
     else {
          memswap(maincrt,auxcrtm,4000);
     }
     tstg=scnids[auxhdl].location;
     scnids[auxhdl].location=scncur->location;
     scncur->location=tstg;
     if (actvhdl == mainhdl) {
          scncur->cx=curcurx();
          scncur->cy=curcury();
     }
     cursact(1);
     scncur=scnids+auxhdl;
     locate(scncur->cx,scncur->cy);
     cursact(scncur->curmove);
     tint=auxhdl;
     auxhdl=mainhdl;
     mainhdl=tint;
}

int                                /* returns handle number                */
regscn(                       /* register a screen for display             */
struct scrnid *newscn)             /* screen id block                      */
{
     void (*rouptr)();

     regscns++;
     if (regscns == mxscns) {
          catastro("Too many screens (%d)! (increase option MAXDSCN)",regscns);
     }
     movmem(newscn,scnids+regscns,sizeof(struct scrnid));
     if (scnids[regscns].secs > 0 && scnids[regscns].secs < occgran) {
          occgran=scnids[regscns].secs;
     }
     scnids[regscns].location=vidalc(4000);
     scnids[regscns].buffer=scnids[regscns].location;
     if (scnids[regscns].scnnam != NULL) {
          iniscn(scnids[regscns].scnnam,scnids[regscns].location);
     }
     else {
          cls(scnids[regscns].location,0x70);
     }
     if ((rouptr=scnids[regscns].updrou) != NULL) {
          actvscn(regscns);
          (*(rouptr))();
          if ((rouptr=scnids[regscns].byerou) != NULL) {
               (*(rouptr))();
          }
     }
     return(regscns);
}

void
shobox(                       /* Message that walks during screen saving   */
int w,                             /* Which screen coords to use (main,aux)*/
int sho)                           /* 1=show boxe, 0=remove box            */
{
     int i;
     static int bbx[2]={40,5},     /* Location of last blanking box        */
                bby[2]={14,4};

     cursact(0);
     sstatr(0x0A);
     for (i=0 ; i < 4 ; i++) {
          printfat(bbx[w],bby[w]+i,"                            ");
     }
     if (sho) {
          bbx[w]=(bbx[w]+(w == 1 ? 12 : 56))%52;
          bby[w]=(bby[w]+(w == 1 ? 2 : 18))%20;
          printfat(bbx[w],bby[w]," Worldgroup %1d.%02d ͻ",BBSVER/100,BBSVER%100);
          printfat(bbx[w],bby[w]+1,"     %-5.5s  %8.8s     ",nctime(now()),ncdate(today()));
          printfat(bbx[w],bby[w]+2,"      Press any key      ");
          printfat(bbx[w],bby[w]+3,"ͼ");
          cursact(1);
          locate(bbx[0]+4,bby[0]);
          cursact(0);
     }
}

void
unsavscns(void)               /* unsave screens that have been saved       */
{
     setwin(NULL,0,0,79,24,1);
     shobox(0,0);
     if (savmai != 0 && mainhdl == 0) {
          scncur=scnids+savmai;
          movmem(scncur->buffer,maincrt,SCNSIZ);
          scncur->location=maincrt;
          cursact(1);
          locate(scncur->cx,scncur->cy);
          cursact(scncur->curmove);
          mainhdl=savmai;
     }
     if (savaux != 0 && auxhdl == 0) {
          scncur=scnids+savaux;
          movmem(scncur->buffer,auxcrtm,SCNSIZ);
          scncur->location=auxcrtm;
          auxhdl=savaux;
     }
}

void
savscns(void)                 /* save screens to prevent burn-in           */
{
     if (mainhdl != 0) {
          scncur=scnids+mainhdl;
          scn2mem(maincrt,scncur->buffer,SCNSIZ);
          scncur->location=scncur->buffer;
          cls(maincrt,0x0A);
          savmai=mainhdl;
          mainhdl=0;
     }
     if (auxhdl != 0) {
          scncur=scnids+auxhdl;
          movmem(auxcrtm,scncur->buffer,SCNSIZ);
          scncur->location=scncur->buffer;
          cls(auxcrtm,0x0A);
          savaux=auxhdl;
          auxhdl=0;
     }
     setwin(NULL,0,0,79,24,1);
     shobox(0,1);
}

void
memswap(                      /* swap two memory regions (without buffer)  */
char *source,                      /* source buffer                        */
char *dest,                        /* destination buffer                   */
int length)                        /* length in bytes to move              */
{
     int i;
     int tmp;

     for (i=0 ; i < length ; i++) {
          tmp=*source;
          *source=*dest;
          *dest=tmp;
          source++;
          dest++;
     }
}

int
baudat(baud,blink)                 /* Set color attribute based on baud    */
unsigned baud;
int blink;
{
     int i,attr;
     static unsigned bauds[]={   0,1200,2400,4800,9600,19200,38400U};
     static char    colors[]={0x19,0x1A,0x1B,0x1C,0x1D, 0x1E,  0x1F};

     for (i=sizeof(bauds)/sizeof(unsigned)-1 ; i >= 0 ; i--) {
          if (baud >= bauds[i]) {
               break;
          }
     }
     sstatr(attr=colors[i]+(blink ? 0x80 : 0));
     return(attr);
}

void
cls(                               /* Clear a screen to blanks             */
char *buf,                              /* screen buffer to clear          */
int atr)                                /* attribute to clear to           */
{
     int i;

     for (i=0 ; i < (160*25) ; i+=2) {
          *(buf+i)=' ';
          *(buf+i+1)=atr;
     }
}

void
printfat(x,y,stg,p1,p2)            /* printf string on screen at (x,y)     */
int x,y;
char *stg;
long p1,p2;
{
     locate(x,y);
     printf(stg,p1,p2);
}


char *
dbytes(                       /* convert # into xxxx, xxxK, or xxxMb       */
long bytes)
{
     static char lbuff[30];

     if (bytes < 10240L) {
          sprintf(lbuff,"%s b ",l2as(bytes));
     }
     else if (bytes < 10485760L) {
          sprintf(lbuff,"%s Kb",l2as(bytes/1024L));
     }
     else {
          sprintf(lbuff,"%s Mb",l2as(bytes/1048576L));
     }
     return(lbuff);
}

void *
vidalc(                            /* allocate a buffer for video memory   */
int len)
{
     return(alcmem(len));
}
