/***************************************************************************
 *                                                                         *
 *   MSGUTL.H                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Structures and variables for MSGUTL.C and other library utilities     *
 *   for reading .MCV files.  This header file is used internally by       *
 *   those library routines, and for some special purposes by              *
 *   the application program.                                              *
 *                                                                         *
 *                                                                         *
 *                                    - T. Stryker 1992                    *
 *                                    - Robert N. Stein 1/23/93            *
 *                                                                         *
 ***************************************************************************/

struct msgblk {                    /* named-message file block             */
     FILE *msgfp;                  /*   fopen()-style file block pointer   */
     long *msgloc;                 /*   dynam-alloc'd fseek() msg offsets  */
     unsigned *lengths;            /*   dyn 2D array of message lengths    */
     int *mslidx;                  /*   xlate:  0..nlingo-1 to 0..lngcnt-1 */
     char *filnam;                 /*   message file name for error reports*/
     int lstmsg;                   /*   last message number since setmbk() */
     long lnglist;                 /*   ptr to languages    \              */
     long lenlist;                 /*   ptr to length array  \  always last*/
     long loclist;                 /*   ptr to location list  > 16 bytes of*/
     int lngcnt;                   /*   count of languages   /  a .MCV file*/
     int msgcnt;                   /*   count of messages   /              */
};

#define MCVEND 16             /* bytes included in lenlist,loclist,msgcnt  */
#define WHREND lnglist        /* where that information goes in msgblk     */
#define lclmbk ((struct msgblk *)curmbk)  /* set by setmbk()               */

extern
char *msgbuf;                      /* message text buffer                  */
extern
int starit;                        /* flag set by msgseek() if msg too long*/
extern
int rlingo;                        /* actual language read by msgseek()    */
extern
int badlang;                       /* to flag undefined languages in .MCVs */

