/***************************************************************************
 *                                                                         *
 *   MSGRDR.H                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1996 Galacticomm, Inc.   All rights reserved.      *
 *                                                                         *
 *   Utilities for reading and writing multilingual .MSG files (header).   *
 *                                                                         *
 *                                               - R. Stein  1/21/93       *
 *                                                                         *
 ***************************************************************************/

#define OPTLEN 8                              /* Maximum option name length */
#define MAXOPTS 4800                          /* maximum number of messages */
#define OPTSIZE 16384         /* absolute max contents of options, incl NUL */
#define MAXLANG 100                     /* max number of languages possible */
#define HLPLEN 1000                    /* max length of option help message */
#define OPNMSG '{'                        /* opening character of an option */
#define CLSMSG '}'                        /* closing character of an option */
#define OPNHNG '('                          /* opening character of a hinge */
#define HNGEQ  '='                               /* hinge operator:  equals */
#define HNGNE  '#'                           /* hinge operator:  not-equals */
#define HNGDLM ','                            /* hinge value list delimeter */
#define CLSHNG ')'                          /* closing character of a hinge */

struct altlng {                           /* alternate language information */
     char altered;                              /* this version was altered */
     char *value;      /* alt=>ptr to value, !alt=>fseek() of value in .MSG */
};

                                                    /*--- rdmsg() inputs ---*/
extern char *curfn;                         /* filename of current MSG file */
extern FILE *rdfp;                       /* file to rdmsg() or rdopt() from */

                                                   /*--- rdmsg() outputs ---*/
extern long cmtptr;                 /* pointer to comment preceding message */
extern int cmtlen;                                /* length of that comment */
extern char msgnam[OPTLEN+1];                               /* message name */
extern char *txtbuf;                            /* Text buffer for 'T' vbls */
extern char hlpbuf[HLPLEN+1];             /* buffer for option help message */

extern
struct altlng *altlnm;          /* dynamic array of alternate language info */
                                          /* altlnm[0] is output by rdmsg() */
                     /* altlnm[1]..altlnm[salingo-1] is output by scanalt() */

extern unsigned bufsize;        /* size of txtbuf, including NUL terminator */
extern int salingo;        /* scanalt() reports # alternates (incl lingo 0) */
extern int sachar;             /* last character (or EOF) read by scanalt() */
extern int sachar;  /* last character (or EOF) rd by scanalt() or litopts() */
extern int valsiz;                    /* getvalbuf() output (not incl '\0') */
extern int valsiz;  /* chars read by getvalbuf(),getval(),loadtv() (no NUL) */
extern int sincebl;               /* Chars since last \n -- set by nxtink() */
extern int gvbust;       /* set to 1 by getval() to indicate option too big */
extern int tdremv;           /* should getvalbuf(), etc. remove '~' tildes? */

#define LOBMAX 128                    /* size of lobuf[], not including NUL */
extern char lobuf[LOBMAX+1];                 /* buffer output for litopts() */

void
inimsgrdr(                        /* initialize msg reader and text buffers */
unsigned siz);           /* size of text buffers, including terminating NUL */
      /* may be called multiple times, last time *must* be after inilingo() */

int
rdmsg(void);       /* reads msg from file rdfp:  <comments> MSGNAM {TXTBUF} */
                                   /* returns 0 if EOF reached, 1 otherwise */

int
scanalt(void);   /* scan alternate language version(s) of getval()'d option */
              /* salingo is number of alternates read, including language 0 */
                      /* salingo is never allowed to get larger than nlingo */
                     /* altlnm[1..salingo-1].value are the implicit outputs */
                             /* 1 extra character will be read and returned */
                                   /* implicit inputs:  rdfp, msgnam, curfn */

void
litopts(void);                /* read option specs line into lobuf[] string */

char
lotype(void);                     /* option type, per recent litopts() call */

void
loadtv(                    /* put 'T' option value in txtbuf (read or copy) */
FILE *msgfp,                                                   /* .MSG file */
struct altlng *alptr);      /* pointer to info for the appropriate language */

int
getval(                  /* reads in current 'T' option from file to txtbuf */
FILE *msgfp);

int
getvalbuf(                   /* reads in current 'T' option value from file */
FILE *msgfp,
char *buf);                               /* where to put it (NULL=nowhere) */

void
putval(                          /* writes the current 'T' option to a file */
FILE *msgfp);

int
nxtink(void);               /* find next non-white character from .MSG file */

void
clsmsgrdr(void);                  /* close down msg reader and text buffers */
