/***************************************************************************
 *                                                                         *
 *   MNUUTL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file contains routines for dealing with records in BBSMENU.DAT.  *
 *                                                                         *
 *                                            - D. Pitchford 6/10/94       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 1.2 $"

void
unpack(                            /* unpack pages after loading           */
struct mnupag *menupage)                /* page to unpack                  */
{
     struct pglink *pg;
     int i;

     i=MAXSEL-menupage->npages;
     if (i > 0 && i <= MAXSEL) {
          setmem(&menupage->page[menupage->npages],
             i*sizeof(struct pglink),0);
     }
     for (i=menupage->npages-1 ; i >= 0 ; i--) {
          pg=&menupage->page[i];
          ASSERT(pg->position >= 0);
          ASSERT(pg->position < MAXSEL);
          if (pg->position != i
           && pg->position > 0
           && pg->position < MAXSEL) {
               movmem(pg,&menupage->page[pg->position],sizeof(struct pglink));
               setmem(pg,sizeof(struct pglink),0);
          }
     }
}

void
repack(                            /* repack pages to save to disk         */
struct mnupag *menupage)                /* page to repack                  */
{
     struct pglink *pg;
     int curidx=0,i;

     for (i=0 ; i < MAXSEL ; i++) {
          pg=&menupage->page[i];
          if (pg->selchr != '\0') {
               pg->position=i;
               if (curidx != i) {
                    movmem(pg,&menupage->page[curidx],sizeof(struct pglink));
                    setmem(pg,sizeof(struct pglink),0);
               }
               curidx++;
          }
          else {
               setmem(pg,sizeof(struct pglink),0);
          }
     }
     menupage->npages=curidx;
}

void
savepage(                          /* save a menu page                     */
struct mnupag *menupage,                /* page to save                    */
BOOL insert)                            /* FALSE=update, TRUE=insert       */
{
     int length;

     repack(menupage);
     length=sizeof(struct mnupag);
     length-=(MAXSEL-menupage->npages)*sizeof(struct pglink);
     if (insert) {
          invbtv(menupage,length);
     }
     else {
          upvbtv(menupage,length);
     }
     unpack(menupage);
}
