/***************************************************************************
 *                                                                         *
 *   MJRTLC.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Worldgroup default teleconference handler.                *
 *                                                                         *
 *                                            - T. Stryker 6/29/86         *
 *                                                                         *
 *   Worldgroup mods.                         - Bill Hyatt 10/4/94         *
 *                                                                         *
 ***************************************************************************/

#include "tlc.h"

#define FILREV "$Revision: 1.4 $"

void EXPORT init__telecon(void);
STATIC void pageini(void);
void joint(unsigned chan);
int tlclon(void);
int tlcinp(void);
int glopag(void);
STATIC int pgset(void);
STATIC void setpgset(BOOL on,BOOL ok);
STATIC void page(void);
STATIC int sndpage(char *uidto,char *pagmsg);
STATIC char *prspow(char *start,int mnum,int prec,int *count);
STATIC void chat(void);
STATIC void whisper(char *whoto,int mnum);
void tlctck(void);
void tlcfin(void);

struct module telecon={       /* module interface block               */
     "",                      /*    name used to refer to this module */
     tlclon,                  /*    user logon supplemental routine   */
     tlcinp,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     tlchup,                  /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     tlcfin                   /*    finish-up (sys shutdown) routine  */
};

int tlcstt;                   /* teleconferencing state number             */

#define NEEDCO -1             /* target user-id count when colon is needed */

FILE *tlcmb;                  /* teleconf named-message file block pointer */

struct tlc *tlclst,           /* dynamic array of tele volatile user area  */
           *tlcptr,*tptr;     /* handy pointers for speed                  */

/*--- OPTIONS FROM GALTLC.MSG ---*/

int nswchx,                   /* max times can switch chans or on-off/15sec*/
    tlcovr,                   /* does the tele cc rate over-ride Forums'?  */
    tlcccr,                   /* teleconference credit consumption rate    */
    reqint,                   /* minimum interval bewteen requesting a user*/
    npaymx,                   /* max times can talk per session if no pay  */
    tinpsz,                   /* allowable input size for teleconference   */
    swtfrm;                   /* allow usrs to swt to & from Forum chans?  */

unsigned maxfre;              /* top freeloader telecon channel            */

char *modkey,                 /* key req'd to moderate tele channels       */
     *unlkey,                 /* key req'd for unlimited tele use          */
     *pgekey;                 /* key req'd to page other users             */

static
int pagint,                   /* minimum interval between paging a user    */
    sopbel,                   /* Sysop page at main console bell period    */
    dftpop;                   /* default page option setting (ON/OFF/OK)   */

static char *somoth;          /* displaying names of users in telecon      */

void EXPORT
init__telecon(void)           /* initialize teleconference module          */
{
     char *cp;

     stzcpy(telecon.descrp,gmdnam("GALTLC.MDF"),MNMSIZ);
     tlcstt=register_module(&telecon);
     tlcmb=opnmsg("GALTLC.MCV");
     tlclst=(struct tlc *)alczer(nterms*sizeof(struct tlc));
     npaymx=numopt(NPAYMX,0,32767);
     nswchx=numopt(NSWCHX,1,32767);
     maxfre=(unsigned)lngopt(MAXFRE,1L,65535L);
     gpagint=pagint=numopt(PAGINT,0,32767);
     reqint=numopt(REQINT,0,32767);
     tinpsz=numopt(TINPSZ,1,255);
     sopbel=numopt(SOPBEL,1,2000);
     tlcccr=numopt(TLCCCR,-32767,32767);
     tlcovr=ynopt(TLCOVR);
     somoth=stgopt(SOMOTH);
     swtfrm=(tlcovr || ynopt(SWTFRM));
     cp=lastwd(rawmsg(DFTPOP));
     dftpop=*(cp+strlen(cp)-1);
     pgekey=stgopt(PGEKEY);
     modkey=stgopt(MODKEY);
     unlkey=stgopt(UNLKEY);
     if (tjoinrou == NULL) {
          tjoinrou=joint;
     }
     rtkick(10,tlctck);
     rtkick(1,pageini);
     pagerou=sndpage;
     pageset=pgset;
     spageset=setpgset;
     inicstlc();
}

STATIC void
pageini(void)                      /* rtkick'ed page ini routine           */
{                            /* allows GALETL to defeat pagerou, if loaded */
     globalcmd(glopag);
}

void
joint(chan)                        /* join teleconference from other module*/
unsigned chan;
{
     tlcptr=&tlclst[usrnum];
     if (!(usrptr->flags&X2MAIN)) {
          tlcptr->flags|=RSTX2M;
          usrptr->flags|=X2MAIN;
     }
     tlcptr->retstt=usrptr->state;
     tlcptr->retsub=usrptr->substt;
     tlcptr->retrat=usrptr->crdrat;
     tlcptr->flags|=XTOOTH;
     tlcptr->channel=chan+1;
     usrptr->state=tlcstt;
     usrptr->substt=0;
     tlcinp();
}

int
tlclon(void)                       /* user logon supplemental routine      */
{
     setmem(&tlclst[usrnum],sizeof(struct tlc),0);
     if (!(usrptr->flags&WSGCSU)) {
          switch (dftpop) {
          case 'N':
               break;
          case 'F':
               tlclst[usrnum].flags|=NOPAGE;
               break;
          case 'K':
               tlclst[usrnum].flags|=OKPAGE;
               break;
          }
     }
     return(0);
}

int
tlcinp(void)                       /* main teleconferencing input handler  */
{
     long actchn;
     struct tlc *tp;
     int chkres;
     char *chn,*tpc;

     setmbk(tlcmb);
     tlcptr=&tlclst[usrnum];
     switch (usrptr->substt) {
     case 0:
          usrptr->substt=1;
          btumil(usrnum,tinpsz);
          btuxnf(usrnum,0,19);
          if (!(usrptr->flags&INVISB)) {
               outtlc(ENTTLC,ALLU,usrnum,-1,usaptr->userid,flgbyt(usrnum));
          }
          prfmsg(INTRO);
          tlcctx();
          if (tlcovr || !(tlcptr->flags&XTOOTH)) {
               usrptr->crdrat=tlcccr;
          }
          break;
     case 1:
          if (margc == 0) {
               tlcctx();
               break;
          }
          if (margc == 1) {
               if (sameas(margv[0],"?")
                || sameas(margv[0],"'?'")
                || sameas(margv[0],"\"?\"")
                || sameas(margv[0],"help")) {
                    prfmsg(TLCHLP);
                    break;
               }
               if (sameas(margv[0],"nopage")) {
                    tlcptr->flags|=NOPAGE;
                    prfmsg(PAGTOF);
                    break;
               }
               if (sameas(margv[0],"exit") || sameas(margv[0],"x")) {
                    if ((tlcptr->flags&JUSTEX) && !(usrptr->flags&OPCHAT)) {
                         prfmsg(NANNOY);
                         break;
                    }
                    tlcptr->flags|=JUSTEX;
                    if (!(usrptr->flags&INVISB)) {
                         outtlc(LVITLC,ALLU,usrnum,-1,usaptr->userid);
                    }
                    rmvcht(-1);
                    rstrxf();
                    if (tlcptr->flags&XTOOTH) {
                         tlcptr->channel=0;
                         if (tlcptr->flags&RSTX2M) {
                              usrptr->flags&=~X2MAIN;
                         }
                         tlcptr->flags&=~(XTOOTH+RSTX2M);
                         condex();
                         usrptr->state=tlcptr->retstt;
                         usrptr->substt=tlcptr->retsub;
                         usrptr->crdrat=tlcptr->retrat;
                         injacr();
                         return(1);
                    }
                    return(0);
               }
               if (sameas(margv[0],"scan")) {
                    prfmsg(NSCNHDR);
                    for (tp=tlclst,othusn=0 ; othusn < nterms ; tp++,othusn++) {
                         if (inscan(othusn,tp)) {
                              prf("%-30s... ",uacoff(othusn)->userid);
                              chn=scnchn(othusn,tp);
                              tpc=scntpc(tp);
                              if (sameas(chn,"(Chat)")) {
                                   prf("%s\r",chn);
                              }
                              else {
                                   if (tpc != NULL) {
                                        prf("%s%s%s\r",chn,
                                            sameas(chn,"(Unlisted)")
                                                   ? "  " : "       ",
                                            tpc);
                                   }
                                   else {
                                        prf("%s\r",chn);
                                   }
                              }
                         }
                    }
                    break;
               }
               if (sameas(margv[0],"unlist")) {
                    tlcptr->flags&=~SHWCHN;
                    tlcptr->flags|=LUISSU;
                    prfmsg(UNLSTC);
                    break;
               }
               if (sameas(margv[0],"list")) {
                    tlcptr->flags|=(SHWCHN+LUISSU);
                    prfmsg(LSTCHN);
                    break;
               }
          }
          if (margc <= 2) {
               if (sameas(margv[0],"channel")) {
                    if (margc == 1) {
                         prfmsg(WHATCH,tlcptr->channel+1);
                    }
                    else if (strlen(margv[1]) > 5) {
                         prfmsg(OUTORG);
                    }
                    else {
                         actchn=atol(margv[1]);
                         switch (chkres=chkchn(actchn)) {
                         case OUTORG:
                         case YOURCH:
                         case CANTLV:
                         case CANTGO:
                         case PRVLCH:
                         case NANNOY:
                              prfmsg(chkres);
                              break;
                         case PAYONL:
                              prfmsg(PAYONL,maxfre);
                              howbuy();
                              break;
                         case CHANOK:
                              swtchn(actchn);
                              tlcctx();
                              break;
                         }
                    }
                    break;
               }
          }
          if (sameas(margv[0],"squelch") || sameas(margv[0],"unsquelch")) {
               if (margc == 1) {
                    prfmsg(NUIHLP);
               }
               else {
                    rstrin();
                    squsqu(margv[1],sameto("squelch",margv[0]));
               }
               break;
          }
          if (sameas(margv[0],"appoint")) {
               if (margc == 1) {
                    prfmsg(NUIHLP);
               }
               else {
                    rstrin();
                    xfrmod(margv[1]);
               }
               break;
          }
          if (sameas(margv[0],"chat")) {
               chat();
               break;
          }
          if (sameas(margv[0],"page")) {
               page();
               break;
          }
          if (ck4pfn() != NOPFN) {
               break;
          }
          if (sameas(margv[0],"moderate")) {
               if (urinv()) {
               }
               else if (margc == 1) {
                    xfrmod(NULL);
               }
               else if (tlcptr->channel == 0) {
                    prfmsg(NOMCH1);
               }
               else if (fidxst(tlcptr->channel)) {
                    prfmsg(NOOVRS);
               }
               else if (ck4mod(usrnum)) {
                    prfmsg(ANOMOD,uacoff(othusn)->userid);
               }
               else if (!haskey(modkey)) {
                    prfmsg(MODLIV);
                    howbuy();
               }
               else {
                    rstrin();
                    *(margv[1]+CTPSIZ-1)='\0';
                    strcpy(tlcptr->topic,margv[1]);
                    ntfyres(tlcptr->channel);
                    tlcptr->modchn=tlcptr->channel;
                    outtlc(BGNCON,ALLU,usrnum,-1,usaptr->userid,tlcptr->topic);
                    prfmsg(BMODER,tlcptr->topic);
               }
               break;
          }
          if (tlcptr->flags&SQUCHD) {
               prfmsg(TLKSQU);
               break;
          }
          if (!haskey(unlkey) && (tlcptr->inpcnt)++ >= npaymx) {
               prfmsg(NPAYXC,npaymx);
               howbuy();
               break;
          }
          if (urinv()) {
               break;
          }
          if (sameas(margv[0],"whisper")) {
               if (margc < 4) {
                    prfmsg(WHSFMT);
               }
               else {
                    whisper(margv[2],2);
               }
               break;
          }
          if (margv[0][0] == '/') {
               whisper(margv[0]+1,0);
               break;
          }
          rstrin();
          outtlc(NMTALK,ALLU,usrnum,-1,usaptr->userid,input);
          if (chncnt() == 1) {
               prfmsg(BYSELF,tlcptr->channel+1);
          }
          else {
               prfmsg(MSGSNT);
          }
          break;
     case 2:
          if (margc == 1 && sameas(margv[0],"x")) {
               xitcht(0);
          }
          return(1);
     }
     if (usrptr->substt == 1 && *prfbuf != '\0') {
          prfmsg(TLCPMT);
     }
     outprf(usrnum);
     return(1);
}

void
tlcctx(void)                       /* teleconference channel user display  */
{
     char *curguy,tmpbuf[UIDSIZ+6],*stp;
     unsigned chan;

     initls();
     chan=tlclst[usrnum].channel+1;
     switch (chncnt()) {
     case 0:
     case 1:
          prfmsg(BYSELF,chan);
          break;
     case 2:
          prfmsg(ONEOTH,tlsrui(LSTSCH),chan);
          break;
     case 3:
          strcpy(tmpbuf,tlsrui(LSTSCH));
          prfmsg(TWOOTH,tmpbuf,tlsrui(LSTSCH),chan);
          break;
     default:
          strcpy(tmpbuf,tlsrui(LSTSCH));
          while ((curguy=tlsrui(LSTSCH)) != NULL) {
               prf(somoth,tmpbuf);
               strcpy(tmpbuf,curguy);
          }
          prfmsg(SEVOTH,tmpbuf,chan);
     }
     if (ck4mod(usrnum)) {
          prfmsg(CHNTPC,tptr->topic,uacoff(othusn)->userid);
     }
     else if ((stp=getftpc(tlcptr->channel)) != NULL) {
          prfmsg(STOPIC,stp);
     }
     if (tlcptr->modchn != 0) {
          if (tlcptr->channel == tlcptr->modchn) {
               prfmsg(URMODR,tlcptr->topic);
          }
          else {
               prfmsg(URMODO,tlcptr->modchn+1,tlcptr->topic);
          }
     }
     prfmsg(IROEPI);
}

int
glopag(void)                       /* globally-accessible form of "page"   */
{
     if (margc >= 1 && sameas(margv[0],"/p")) {
          setmbk(tlcmb);
          if (margc == 1 || (margc == 2 && sameas(margv[1],"?"))) {
               prfmsg(GLPFMT);
          }
          else {
               tlcptr=&tlclst[usrnum];
               page();
          }
          if (!(usrptr->flags&ISGCSU)) {
               outprf(usrnum);
          }
          return(1);
     }
     return(0);
}

STATIC int
pgset(void)                        /* get page on/off/ok setting           */
{
     tlcptr=&tlclst[usrnum];
     if (tlcptr->flags&NOPAGE) { /* /P OFF */
          return(2);
     }
     if (tlcptr->flags&OKPAGE) { /* /P OK */
          return(1);
     }
     return(3);  /* /P ON */
}

STATIC void
setpgset(                          /* set page on/off/ok                   */
BOOL on,
BOOL ok)
{
     setmbk(tlcmb);
     tlcptr=&tlclst[usrnum];
     if (on) {
          tlcptr->flags&=~(NOPAGE+OKPAGE);
          prfmsg(PAGTON,(pagint+30)/60);
     }
     else if (ok) {
          tlcptr->flags|=OKPAGE;
          tlcptr->flags&=~NOPAGE;
          prfmsg(PAGTOK,(pagint+30)/60);
     }
     else {
          tlcptr->flags|=NOPAGE;
          prfmsg(PAGTOF);
     }
     rstmbk();
}

STATIC void
page(void)                         /* "page" function                      */
{
     int count;
     char *pagmsg;

     if (urinv()) {
          return;
     }
     else if (margc == 1) {
          prfmsg(PAGFMT);
     }
     else {
          rstrin();
          if (margc == 2) {
               if (sameas(margv[1],"on")) {
                    (*spageset)(TRUE,FALSE);
                    return;
               }
               else if (sameas(margv[1],"off")) {
                    (*spageset)(FALSE,FALSE);
                    return;
               }
               else if (sameas(margv[1],"ok")) {
                    (*spageset)(FALSE,TRUE);
                    return;
               }
          }
          if ((count=howmny(margv[1],0,1)) == 1) {
               pagmsg="";
          }
          else {
               pagmsg=prspow(margv[1],1,0,&count);
          }
          if (count == 0) {
               if (sameas(margv[1],"Sysop") || sameto("Sysop ",margv[1])) {
                    (*pagerou)("Sysop",margc > 2 ? margv[2] : "");
               }
               else {
                    prfmsg(PAGNON,margv[1]);
               }
          }
          else if (count == NEEDCO) {
               prfmsg(PAMBIG,margv[1],"/p");
          }
          else if (count != 1) {
               prfmsg(AMBIG,margv[1],"page");
          }
          else {
               (*pagerou)(othuap->userid,pagmsg);
          }
     }
}

STATIC int
sndpage(                           /* send page to user, specifically      */
char *uidto,                            /* user to                         */
char *pagmsg)                           /* message                         */
{                                       /* assumes usrptr, etc. is sender  */
                                        /* ret: 0=fail, 1=ok, 2=console    */
     char *pgfrom;

     setmbk(tlcmb);
     if (urinv()) {
          rstmbk();
          return(0);
     }
     setpfn(pagmsg);
     if (ck4pfn() != NOPFN) {
          rstmbk();
          return(0);
     }
     if (!onsys(uidto)) {
          if (sameas(uidto,"Sysop")) {
               belper(sopbel);
               printf("\7");
               prfmsg(PAGEOK,"Sysop (at main console)");
               psmatms(pagmsg);
               shochl(usaptr->userid,(usrptr->flags&ISGCSU) ? '' : '',
                  baudat(usrptr->baud,1));
               tlcptr->blinkc=8;
               rstmbk();
               return(2);
          }
          else {
               prfmsg(PAGNON,uidto);
          }
          rstmbk();
          return(0);
     }
     else if (!haskey(pgekey) && !sameas(uidto,"Sysop")) {
          prfmsg(NPGEKEY);
          rstmbk();
          return(0);
     }
     else if (tlclst[othusn].flags&NOPAGE) {
          prfmsg(PAGOFF,othuap->userid);
          rstmbk();
          return(0);
     }
     else if (!(tlclst[othusn].flags&OKPAGE) && tlclst[othusn].paged) {
          prfmsg(PAGL2M,othuap->userid,(pagint+30)/60);
          rstmbk();
          return(0);
     }
     if (usrptr->state == tlcstt) {
          pgfrom=spr("teleconference channel %u",tlcptr->channel+1);
     }
     else {
          pgfrom=module[usrptr->state]->descrp;
     }
     if (*pagmsg == '\0') {
          prfmlt(PAGMSG2,usaptr->userid,pgfrom);
     }
     else {
          prfmlt(PAGNOT2,usaptr->userid,pgfrom,pagmsg);
     }
     if ((othusp->flags&ISGCSU) && cspagerou != NULL) {
          clrmlt();
          if ((*cspagerou)(usaptr->userid,pagmsg)) {
               tlclst[othusn].paged=(pagint+7)/15;
               prfmsg(PAGEOK,othuap->userid);
               rstmbk();
               return(1);
          }
          else {
               prfmsg(PAGNPS,othuap->userid);
               rstmbk();
               return(0);
          }
     }
     else {
          for (pagmsg=prfbuf ; *pagmsg != '\0' ; pagmsg++) {
               if (*pagmsg == '\n') {
                    *pagmsg=' ';
               }
          }
          if (injoth()) {
               clrmlt();
               tlclst[othusn].paged=(pagint+7)/15;
               prfmsg(PAGEOK,othuap->userid);
               rstmbk();
               return(1);
          }
          else {
               prfmsg(PAGNPS,othuap->userid);
               rstmbk();
               return(0);
          }
     }
}

STATIC char *
prspow(start,mnum,prec,count)      /* parse destination of some action     */
char *start;
int mnum,prec,*count;
{
     char *msg;
     int gobl,i;

     for (i=0 ; i < margc ; i++) {
          margn[i][0]='\0';
     }
     if ((*count=howmny(start,prec,0)) == 0) {
          msg=margn[mnum];
          if (*(msg-1) == ':') {
               *(msg-1)='\0';
               *count=howmny(start,prec,1);
               if (mnum != margc-1) {
                    msg++;
               }
          }
          else {
               msg="";
          }
          rstrin();
     }
     else if (*count == 1) {
          rstrin();
          for (i=mnum+1 ; i < margc ; i++) {
               msg=margn[i];
               if (*(msg-1) == ':') {
                    *(msg-1)='\0';
                    if (!sameto(start,othuap->userid)) {
                         *(msg-1)=':';
                    }
                    else {
                         i++;
                    }
                    break;
               }
               else {
                    *msg='\0';
                    gobl=sameto(start,othuap->userid);
                    if (i < margc-1) {
                         *msg=' ';
                    }
               }
               if (!gobl) {
                    break;
               }
          }
          msg=(i == margc ? "" : margv[i]);
     }
     else {
          rstrin();
          if ((msg=strchr(start,':')) == NULL) {
               margn[mnum][0]='\0';
               *count=NEEDCO;
               msg="";
          }
          else {
               *msg='\0';
               if (*++msg != '\0') {
                    msg++;
               }
               *count=howmny(start,prec,1);
          }
     }
     return(msg);
}

STATIC void
chat(void)                         /* "chat" function                      */
{
     rstrin();
     switch (chkcht(margc == 1 ? "" : margv[1])) {
     case URINVS:
          break;
     case CHAFMT:
          prfmsg(CHAFMT);
          break;
     case WHSNHR:
          prfmsg(WHSNHR,margv[1]);
          break;
     case AMBIG:
          prfmsg(AMBIG,margv[1],"chat");
          break;
     case NCHSLF:
          prfmsg(NCHSLF);
          break;
     case NOCHCS2:
          prfmsg(NOCHCS2,othuap->userid,tlcsxp(othuap->sex));
          break;
     case ENTCHA:
          entcht();
          break;
     case PAGOFF:
          prfmsg(PAGOFF,othuap->userid);
          break;
     case CHAL2M:
          prfmsg(CHAL2M,othuap->userid,(reqint+30)/60);
          break;
     case CHAREQ:
          reqcht();
          break;
     }
}

char
tlchat(chan,ch)                    /* btuchi() chat routine, A/A->A/A      */
int chan;
int ch;
{
     int oth;
     char c;

     oth=tlclst[chan].chatch;
     c=((char)ch)&eurmsk;
     switch (c) {
     case '\r':
          chiinp(oth,c);
          chiout(oth,c);
          chiout(oth,'\n');
          return(c);
     case '\b':
          chiinp(oth,c);
          chiout(oth,c);
          chiout(oth,' ');
          chiout(oth,c);
          return(c);
     default:
          if (c >= 32) {
               if (!(tlclst[chan].flags&TYPING)) {
                    if (uacoff(oth)->ansifl&ANSON) {
                         chious(oth,"\33[32m");
                    }
                    if (uacoff(chan)->ansifl&ANSON) {
                         chious(chan,"\33[33m");
                    }
                    tlclst[chan].flags|=TYPING;
                    tlclst[oth].flags&=~TYPING;
               }
               chiinp(oth,c);
               chiout(oth,c);
               return(c);
          }
     }
     return(0);
}

STATIC void
whisper(                           /* "whisper" function                   */
char *whoto,                       /*   uid to whisper to                  */
int mnum)                          /*   idx into margv[] where msg starts  */
{
     int count;
     char *what;

     what=prspow(whoto,mnum,2,&count);
     if (count == NEEDCO) {
          prfmsg(PAMBIG,whoto,"whisper to");
     }
     else if (count == 0) {
          prfmsg(WHSNHR,whoto);
     }
     else if (count != 1) {
          prfmsg(AMBIG,whoto,"whisper");
     }
     else if (*what == '\0') {
          prfmsg(WHSFMT);
     }
     else {
          sndwsp(what);
     }
}

void
tlctck(void)                       /* real-time teleconference kicker      */
{
     struct tlc *tlcptr;

     for (usrnum=0,tlcptr=tlclst ; usrnum < nterms ; usrnum++,tlcptr++) {
          if (tlcptr->paged != 0) {
               tlcptr->paged--;
          }
          if (tlcptr->blinkc != 0) {
               if ((tlcptr->blinkc-=1) == 0) {
                    usrptr=&user[usrnum];
                    shochl(uacoff(usrnum)->userid,
                           (usrptr->flags&ISGCSU) ? '' : '',
                           baudat(user[usrnum].baud,0));
               }
          }
          if (tlcptr->reqcha != 0) {
               tlcptr->reqcha--;
          }
          tlcptr->swchan=0;
          tlcptr->flags&=~JUSTEX;
          tlcptr->flags&=~JUSTDB;
     }
     rtkick(15,tlctck);
}

void
tlcfin(void)                  /* close teleconference files for shutdown   */
{
     clsmsg(tlcmb);
}
