/***************************************************************************
 *                                                                         *
 *   MJREXIT.C                                                             *
 *                                                                         *
 *   Copyright (c) 1987-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the Worldgroup default user-exit handler.                     *
 *                                                                         *
 *                                            - T. Stryker 6/28/86         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "bbsmajor.h"

#define FILREV "$Revision: 1.2 $"

void EXPORT init__exit(void);
int xitter(void);
int finlof(void);

struct module exit_bbs={      /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     xitter,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    "injoth" routine for this module  */
     finlof,                  /*    user logoff supplemental routine  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL                     /*    finish-up (sys shutdown) routine  */
};

void EXPORT
init__exit(void)                   /* initialize exit module               */
{
     stzcpy(exit_bbs.descrp,gmdnam("GALXIT.MDF"),MNMSIZ);
     register_module(&exit_bbs);
}

int
xitter(void)                       /* exit handler                         */
{
     bgnlof();
     return(1);
}

int
finlof(void)                       /* finish off logoff procedure          */
{
     int rc=1;

     setmbk(mjrmb);
     if (usrptr->substt == 0 || margc == 0) {
          if (usrptr->flags&WSGCSU) {
               prfmsg(RUSXITC);
          }
          else {
               prfmsg(hasmkey(RLGKEY) ? RUSXITL : RUSXITN);
          }
          outprf(usrnum);
          usrptr->substt=1;
     }
     else if (usrptr->flags&WSGCSU) {
          switch (lingyn(margv[0][0])) {
          case 'Y':
               gcs2cs();
               break;
          default:
               rc=0;
               break;
          }
     }
     else {
          switch (lingyn(margv[0][0])) {
          case 'Y':
               byenow(SEEYA);
               break;
          case 'R':
               if (hasmkey(RLGKEY)) {
                    btuinj(usrnum,RELOG);
                    break;
               }
          default:
               rc=0;
               break;
          }
     }
     return(rc);
}
