/***************************************************************************
 *                                                                         *
 *   MHSALIAS.H                                                            *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This file declares structures and functions used to create exporters  *
 *   that alias MHS.  These exporters appear to GME to be distinct         *
 *   exporters (with their own prefix, etc.), but the actual importing/    *
 *   exporting is done by MHS.                                             *
 *                                                                         *
 *                                            - J. Alvrus   1/9/95         *
 *                                                                         *
 ***************************************************************************/

struct mhsalias {                  /* MHS alias structure                  */
     struct exporter exp;          /*   exporter control block for GME     */
     char *outmsg;                 /*   outgoing message directory         */
     char *outfil;                 /*   outgoing attachment directory      */
     char *inmsg;                  /*   incoming message directory         */
     char *infil;                  /*   incoming attachment directory      */
     char *outpfx;                 /*   outgoing message address prefix    */
     char *outsfx;                 /*   outgoing message address suffix    */
};

extern
char *gtwnme;                      /* server gateway name                  */

BOOL                               /*   returns FALSE if bad directories   */
register_mhsalias (                /* set up an MHS alias                  */
struct mhsalias *alias);           /*   alias definition block             */

BOOL
valmhs(                            /* does addr contain valid MHS '@' char */
char *adr);                        /* ('!' is considered valid for MG/I)   */

char *
aliasasp(                          /* get outbound att file path+name      */
struct mhsalias *alias,            /*   for this exporter alias            */
char *to,                          /*   address to which message being sent*/
struct message *msg);              /*   header of message being sent       */

int                                /*   returns GME error codes            */
sndalias(                          /* send a message for an MHS alias      */
struct mhsalias *alias,            /*   exporter alias being used          */
char *to,                          /*   to field (MHS address)             */
struct message *msg,               /*   header of message to send off      */
char *text,                        /*   message text buffer                */
char *filatt);                     /*   path+file name of attachment       */
