/***************************************************************************
 *                                                                         *
 *   LOCKNKEY.H                                                            *
 *                                                                         *
 *   Copyright (c) 1991-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file for the suite of routines contained in        *
 *   LOCKNKEY.C.                                                           *
 *                                                                         *
 *                                   - S. Brinker and C. Robert  10/3/91   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This routine will first clear a user's list of keys, then read in     *
 *   all his keys from disk (including all the keys on the keyring).  You  *
 *   should use this routine when assigning an online user a different     *
 *   keyring.                                                              *
 *                                                                         *
 *        void                                                             *
 *        loadkeys(           load keys from disk into usrptr->keys        *
 *        char *keyring)           name of keyring to load (NULL if none)  *
 *                                                                         *
 *                                                                         *
 *   These three routines can be used to test if a certain user has a key  *
 *   or not.  The uidkey() routine reads the Btrieve file, and should      *
 *   therefore only be used when checking a user not online (otherwise     *
 *   use haskey() for "usrptr" checks and othkey() for "othusp" checks).   *
 *                                                                         *
 *        int                      1=user has key, 0=user doesn't have key *
 *        haskey(             does current user have the key to this lock? *
 *        char *lock)              name of lock for which key is used      *
 *                                                                         *
 *        int                      1=user has key, 0=user doesn't have key *
 *        othkey(             does other user have the key to this lock?   *
 *        char *lock)              name of lock for which key is used      *
 *                                                                         *
 *        int                      1=user has key, 0=user doesn't have key *
 *        uidkey(             does other user have the key to this lock?   *
 *        char *uid                user-id to check (whether online or not)*
 *        char *lock)              name of lock for which key is used      *
 *                                                                         *
 *                                                                         *
 *   These next two routines can be used to give and remove keys from a    *
 *   user.  You can either pass them a single key name, or a list of       *
 *   keys, each separated from each other by a single space, and           *
 *   terminated with a NULL (e.g., "CUSTOMER COSYSOP BETATEST\0").  They   *
 *   both will update the user's access in real-time if he is online.      *
 *                                                                         *
 *   You can also use these routines to add or remove keys from a keyring  *
 *   by passing a keyring name with a leading ampersand ('&') tacked on    *
 *   for the "uid" parameter.                                              *
 *                                                                         *
 *        int                      0=couldn't give key, 1=key granted      *
 *        givkey(             give a userid a particular (update if online)*
 *        char *uid,               user-id (or keyring) to give key to     *
 *        char *keylist)           list of lock for which key is used      *
 *                                                                         *
 *        void                                                             *
 *        rmvkey(             remove a key from a userid (update if online)*
 *        char *uid,               user-id (or keyring) to remove key from *
 *        char *keylist)           name of lock for which key is used      *
 *                                                                         *
 *                                                                         *
 *   You can also manage your own ASCII lists of keys (each key separated  *
 *   by a space, the entire list NULL-terminated).  This routine can be    *
 *   used to determine if a key name is in a given list or not (and if so, *
 *   give you the option of removing it or not).  To add keys to your own  *
 *   lists, just strcat() a space and the key name to your list.           *
 *                                                                         *
 *        int                      1=key in list, 0=key not in list        *
 *        fndkey(             is a certain key in a ASCII list of keys     *
 *        char *lock,              name of lock for which key is used      *
 *        char *keylist,           ptr to NULL-termin. list of key names   *
 *        int remove)              if found, remove from list? 0=no, 1=yes *
 *                                                                         *
 ***************************************************************************/

#define KEYSIZ      16        /* max size of key name (and class name also)*/
#define LOKSIZ      48        /* max size of lock name (can have ands/ors) */
#define RINGID      '&'       /* first character for a "keyring"-id        */
#define KLSTOF      30        /* offset of keylist into "keyrec" (kysbuf)  */
#define RINGSZ      1024      /* size of largest possible keyring record   */
#define RSZBLK      20        /* block size for alcrsz() calls in locknkey */

extern
char **locks;                 /* dynamically resized list of known locks   */

extern
int nlocks,                   /* current number of known locks in memory   */
    npkeys;                   /* current number of pseudokeys in memory    */

extern
struct pskeys {               /* psuedokeys data structure definition      */
     char pskbeg[KEYSIZ];          /* beginning of pseudokey name (sameto) */
     int (*pskrou)(int unum,char *lock); /* does unum have this pseudokey? */
} *pkeys;                     /* dynamic array of regustered pseudokeys    */

extern
char *kysbuf;                 /* pointer to one-shot internal keys buffer  */

/* LOCKNKEY.C 03/04/92 11.12.42 */
void inikys(void);
int register_pseudok(char *pskbeg,int (*pskrou)(int unum,char *lock));
void nkyrec(char *uid);
void loadkeys(char *keyring);
void setkey(char *lock);
int haskno(int bitno);
int gen_haskey(char *lock,int unum,struct user *uptr);
int low_haskey(char *lock,int unum,struct user *uptr);
int scnpsk(int unum,char *lock);
int uhsmkey(char *uid,int mnum);
int hasmkey(int mnum);
int uhskey(char *uid,char *lock);
int haskey(char *lock);
int othkey(char *lock);
int uidkey(char *uid,char *lock);
int getlst(char *uid,char *buffer);
int fndkey(char *lock,char *keylist,int remove);
int givkey(char *uid,char *keylist);
int addkyu(char *keyptr,int update);
void ustkey(char *lock);
void rmvkey(char *uid,char *keylist);
int lockbit(char *lock,int ins);
int keynam(char *keyname);
int loknam(char *lokname);
void dlkeys(char *uid);
void clslnk(void);
void axschg(char *uid);

