/***************************************************************************
 *                                                                         *
 *   GCWINVER.H                                                            *
 *                                                                         *
 *   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These routines perform Windows version control on files.              *
 *                                                                         *
 *                                            - D. Pitchford 12/26/95      *
 *                                                                         *
 ***************************************************************************/

#define SSFDIR "GALSSF"            /* shared support file directory        */

struct dpkwv {                     /* dynapak structure for Windows vers   */
     unsigned long msl;            /*   version number - major             */
     unsigned long lsl;            /*   version number - minor             */
     int date;                     /*   date of file                       */
     int time;                     /*   time of file                       */
     unsigned long size;           /*   size of file                       */
     char filnam[MAXPATH];         /*   full path to file                  */
};

int                                /*   returns 0 if files are same version*/
winvertest(                        /* compare Windows versions of 2 files  */
char *f1,                          /*   file 1 - returns -1 if newer       */
char *f2);                         /*   file 2 - returns 1 if newer        */

int                                /*   rtns -1, 0, 1 (newer, same, older) */
wvcompare(                         /* compare Windows file versions        */
struct dpkwv *v1,                  /*   info for file 1  (-1 if this newer)*/
struct dpkwv *v2);                 /*   info for file 2  (1 if this newer) */

BOOL                               /*   returns FALSE if no file           */
getwinver(                         /* read Windows file version            */
struct dpkwv *info);               /*   version info (needs filnam)        */
