/***************************************************************************
 *                                                                         *
 *   GCWINVER.C                                                            *
 *                                                                         *
 *   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These routines perform Windows version control on files.              *
 *                                                                         *
 *                                            - D. Pitchford 12/26/95      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gcwinver.h"

#define VERBUF 16384               /* size of file chunk for getwinver()   */

static struct dpkwv *
cachefnd(                          /* find info in cache                   */
struct dpkwv *info);

static void
cacheinf(                          /* store info in cache                  */
struct dpkwv *info);

static
struct cachestr {
     struct dpkwv dpkwv;
     struct cachestr *next;
} *head=NULL;

int                                /*   returns 0 if files are same version*/
winvertest(                        /* compare Windows versions of 2 files  */
char *f1,                          /*   file 1 - returns -1 if newer       */
char *f2)                          /*   file 2 - returns 1 if newer        */
{
     struct dpkwv v1,v2;

     stzcpy(v1.filnam,f1,MAXPATH);
     if (!getwinver(&v1)) {
          return(1);
     }
     stzcpy(v2.filnam,f2,MAXPATH);
     if (!getwinver(&v2)) {
          return(-1);
     }
     return(wvcompare(&v1,&v2));
}

int                                /*   rtns -1, 0, 1 (newer, same, older) */
wvcompare(                         /* compare Windows file versions        */
struct dpkwv *v1,                  /*   info for file 1  (-1 if this newer)*/
struct dpkwv *v2)                  /*   info for file 2  (1 if this newer) */
{
     unsigned int a1,a2;

     if (v1->msl > v2->msl) {
          return(-1);
     }
     if (v1->msl < v2->msl) {
          return(1);
     }
     if (v1->lsl > v2->lsl) {
          return(-1);
     }
     if (v1->lsl < v2->lsl) {
          return(1);
     }
     if (v1->msl != 0L || v1->lsl != 0L) {
          if (v2->msl != 0L || v2->lsl != 0L) {
               return(0);
          }
          return(-1);
     }
     if (v2->msl != 0L || v2->lsl != 0L) {
          return(1);
     }
     a1=cofdat(v1->date);
     a2=cofdat(v2->date);
     if (a1 > a2) {
          return(-1);
     }
     if (a1 < a2) {
          return(1);
     }
     if (v1->time > v2->time) {
          return(-1);
     }
     if (v1->time < v2->time) {
          return(1);
     }
     return(0);
}

BOOL                               /*   returns FALSE if no file           */
getwinver(                         /* read Windows file version            */
struct dpkwv *info)                /*   version info (needs filnam)        */
{
     struct fndblk fb;
     FILE *fp;
     char *buf,*s;
     int i,sz;
     long sk;
     struct dpkwv *cache;

     if (!fnd1st(&fb,info->filnam,0)) {
          return(FALSE);
     }
     if ((cache=cachefnd(info)) != NULL) {
          if (fb.date == cache->date
           && fb.time == cache->time
           && fb.size == cache->size) {
               *info=*cache;
               return(TRUE);
          }
     }     
     if ((fp=fopen(info->filnam,FOPRB)) == NULL) {
          return(FALSE);
     }
     info->date=fb.date;
     info->time=fb.time;
     info->size=fb.size;
     info->msl=info->lsl=0L;
     buf=alczer(VERBUF+1);
     sz=VERBUF/2;
     sk=fb.size;
     do {
          sk-=VERBUF/2;
          if (sk < 0L) {
               sz+=(int)sk;
               sk=0L;
          }
          movmem(buf,buf+sz,sz);
          fseek(fp,sk,SEEK_SET);
          if (fread(buf,sz,1,fp) != 1) {
               break; /* breaks do {} while(); */
          }
          for (s=buf,i=0 ; i < VERBUF-32 ; s++,i++) {
               if (sameto("VS_VERSION_INFO",s)) {
                    if (*((unsigned long *)(s+16)) == 0xFEEF04BDL) {
                         info->msl=*((unsigned long *)(s+24));
                         info->lsl=*((unsigned long *)(s+28));
                    }
                    sk=0L;    /* indicating "i'm done" */
                    break;    /* breaks for() {} */
               }
          }
     } while (sk > 0L);
     free(buf);
     fclose(fp);
     cacheinf(info);
     return(TRUE);
}

static struct dpkwv *
cachefnd(                          /* find info in cache                   */
struct dpkwv *info)
{
     struct cachestr *cur;

     for (cur=head ; cur != NULL ; cur=cur->next) {
          if (sameas(info->filnam,cur->dpkwv.filnam)) {
               return(&cur->dpkwv);
          }
     }
     return(NULL);
}

static void
cacheinf(                          /* store info in cache                  */
struct dpkwv *info)
{
     struct dpkwv *cache;
     struct cachestr *new;

     if ((cache=cachefnd(info)) != NULL) {
          *cache=*info;
     }    
     else {
          new=(struct cachestr *)alczer(sizeof(struct cachestr));
          new->dpkwv=*info;
          new->next=head;
          head=new;
     }
}
