/***************************************************************************
 *                                                                         *
 *   GCSPSRV.H                                                             *
 *                                                                         *
 *   Copyright (c) 1993 Consensus Systems, Inc.  All rights reserved.      *
 *   Copyright (c) 1993-1996 Galacticomm, Inc.   All rights reserved.      *
 *                                                                         *
 *   This is the include file for the Galacticomm Client/Server Protocol   *
 *   server-side handler for Worldgroup.  .                                *
 *                                                                         *
 *                                                - T. Stryker 8/5/93      *
 *                                                  C. Robert              *
 *                                                  B. Love                *
 *                                                                         *
 ***************************************************************************/

#include "gcsp.h"
#include "gendpk.h"

extern
struct agent {                     /* agent information structure          */
     char appid[AIDSIZ];
     void (*read)(int direction,struct saunam *dpknam);
     void (*write)(struct saunam *dpknam,unsigned length,void *value);
     void (*xferdone)(void);
     void (*abort)(void);
} *agents;

extern
int clisrv;                        /* support client/server logons?        */

extern
char msysid[SIDSIZ],               /* master sysid for this system         */
     *supappid,                    /* signup agent's appid                 */
     *mmappid;                     /* main menu agent's appid              */

#define FINFPTR ((struct filinf *)value)/* file info ptr (for read vector) */

extern
struct reqdat {                    /* engine's internal per-request data   */
     struct saunam saunam;         /*   dynapak name                       */
     char priority;                /*   priority from client               */
     char state;                   /*   state used for tracking request    */
     void (*cycaddr)(void);        /*   "cycle me" address (or NULL)       */
     FILE *fp;                     /*   curr file pointer (file dynapaks)  */
     union {
          long crc[GLCSIZ];        /*   crc from client (dpk read only)    */
          long fbytes;             /*   # file bytes left (dpk write only) */
     } u;
     signed char direction;        /*   direction for lt/gt requests       */
     unsigned askcnt;              /*   count for lt/gt requests           */
     char minmat;                  /*   saunam minimum byte match required */
     char flags;                   /*   various per-request flags          */
} *rqdptr;                         /* global ptr to engine's current reqdat*/

                                   /* per-request flags                    */
#define ACKRES      1              /*   acknowledge d/l resume next block  */

extern
struct usrdat {                    /* engine's internal per-user C/S data  */
     char sysid[SIDSIZ];           /*   this channel's default 's' value   */
     char usrid[UIDSIZ];           /*   this channel's default 'u' value   */
     int apierr;                   /*   API layer error code => disconnect */
     int ncyclers;                 /*   number of cyclers for this channel */
     int rrobin;                   /*   round-robin counter for cycling    */
     int ndowners;                 /*   number of downloads on this channel*/
     int rrobdl;                   /*   round-robin counter for downloading*/
     int ngtlters;                 /*   number of gt/lt reqs needing svc   */
     int rrobgl;                   /*   round-robin counter for gt/lt svc  */
     unsigned filechnk;            /*   chunk size for downloading         */
     int nintbl;                   /*   # of agents in server app table    */
     int flags;                    /*   various per-user flags             */
} *usrdat,                         /* pointer to per-user C/S data array   */
  *usdptr;                         /* pointer to current user's C/S data   */
                                   /* usdptr->flags bit definitions        */
#define SENTSAP     1              /*   user was sent server app table     */
#define USRISUP     2              /*   user up-and-running with app layer */

extern
int  mrqsiz;                       /* size of per-request memory area      */
extern
char *mrqptr;                      /* ptr to per-request memory for agents */
extern
int  greqid;                       /* global copy of request id underway   */

#define srvrqid(u,r) ((u)*MAXREQS+(r)) /* get server reqid from client one */
#define clirqid(r) ((r)%MAXREQS)   /* get client reqid from server one     */
#define rqidunm(r) ((r)/MAXREQS)   /* get server user # from server reqid  */

extern
char *rsptmp;                      /* buffer for agents to store responses */
extern
struct saunam *namtmp;             /* temp buffer for agents to store names*/
extern
int nagents;                       /* number of agents                     */
extern
char erraid[AIDSIZ];               /* appid that generated API error       */

#define APRMXERR    401            /* reqid received from client > MAXREQS */
#define APAVLERR    402            /* reqid not available                  */
#define APTYPERR    403            /* bad header type received             */
#define APR2RERR    404            /* agent called rsp2read() for no reason*/
#define APR2WERR    405            /* agent called rsp2write() "  "    "   */
#define APSHORTP    406            /* received packet too short            */
#define APWRFERR    407            /* received file packet out of sequence */
#define APNOFILR    408            /* agent failed to handle file dynapak  */
#define APOK2ERR    409            /* agent called ok2write() for no reason*/
#define APOK2WNG    410            /* ok2write() couldn't fopen() filespec */
#define APFWRERR    411            /* disk I/O error on upload-file write  */
#define APFRDERR    412            /* disk I/O error on download-file read */
#define APF2SHRT    413            /* received file shorter than expected  */
#define APF2LONG    414            /* received file longer than expected   */
#define APFINFNG    415            /* received file info header bad length */
#define APR2RNAM    416            /* agent gave rsp2read() bad dpk name   */
#define APR2RFNM    417            /* agent gave rsp2read() !existent file */
#define APC2SERR    418            /* incoming dpk name formatting error   */
#define APCSUOOS    419            /* incoming change "su" cmd out of seq  */

#define MAXTASK       1            /* max # of EXE's active at once        */
#define DMSINOB    1000            /* dft. ms of data to keep in outbuf buf*/

#define samepat(sau1,sau2) samepatu(sau1,sau2,TRUE)
#define samepato(shorts,longs) samepatu(shorts,longs,FALSE)

void inigcsp(void);
void sndsap(int chan);
BOOL apinid(int chan);
void gcsasc(void);
void gcs2cs(void);
char *rnosid(char *regno);
void inisysagt(void);
void gcsplon(void);
void gcsphup(void);
void gcsprst(void);
BOOL gcspaus(unsigned snccon,char *incbuf,int nbytes);
BOOL gcsplas(char *stg);

void register_agent(struct agent *agdptr);
void curcsu(int chan);
void curreq(int reqid);
BOOL forreal(void);
BOOL iswrite(void);
BOOL ismyreq(int reqid,char *appid);
void rsp2read(struct saunam *name,unsigned length,void *value);
void ok2write(char *filespec);
void rsp2write(BOOL ok,unsigned length,void *data);
void senddpk(int chan,char *dstapp,int priority,struct saunam *dpknam,
                                          unsigned length,void *value);
BOOL qroom(int chan,int priority);
void dclmrq(int minsiz);
char *mrqoff(int reqid);
void cycleme(void (*cycaddr)(void));

/* GAUTLSRV.C prototypes */

BOOL
stdchk(                            /* does current C/S user have key?      */
char *key);                        /*   key name                           */

BOOL
stdmchk(                           /* does cur user have key in message?   */
int mnum);                         /*   message number with key name       */

void
rejectreq(void);                   /* reject current request               */

void
r2rgdp(                            /* respond to read with generic dynapak */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam);            /*   dynapak name to respond to read of */

void
r2rprf(                            /* respond to read with prfbuf contents */
struct saunam *name);              /*   dynapak name to respond to read of */

void
r2wprf(                            /* respond to write w/ prfbuf contents  */
BOOL ok);                          /*   TRUE/FALSE, write succeeded?       */

char *                             /*   returns dev form dpk               */
cnvs2d(                            /* convert dpk from struct to dev form  */
struct saunam *saunam);            /*   structure form dynapak name        */

BOOL                               /*   returns whether successful         */
cnvd2s(                            /* convert dpk from dev to struct form  */
char *saustg,                      /*   dynapak name in developer form     */
struct saunam *saunam);            /*   (dest) dpk name in structure form  */

char *
stp4cs(                            /* strip buffer for C/S output          */
char *buf);                        /*   buffer to strip, returns also      */

void
reflow(                            /* re-flow buffer for C/S output        */
char *buf);                        /*   buffer to re-flow                  */

struct saunam *
saunmu(                            /* return WGM-specific unsol dpk struct */
char *suffix);                     /*   suffix to use                      */

BOOL
vtmsndok(                          /* ok to send to this channel?          */
int tochan);                       /*   c/s user's usrnum                  */

void                               /*   call right after vtmsndok() == TRUE*/
vtmsend(                           /* send data to the channel             */
int srcid,                         /*   source identifier (hwnd)           */
int length,                        /*   length of data                     */
void *value);                      /*   data to send                       */

