/***************************************************************************
 *                                                                         *
 *   GCSP.H                                                                *
 *                                                                         *
 *   Copyright (c) 1993 Consensus Systems, Inc.  All rights reserved.      *
 *   Copyright (c) 1993-1996 Galacticomm, Inc.   All rights reserved.      *
 *                                                                         *
 *   This is the header file for client/server side-independent logic.     *
 *                                                                         *
 *                                                - T. Stryker 8/5/93      *
 *                                                  C. Robert              *
 *                                                  B. Love                *
 *                                                                         *
 ***************************************************************************/

#define STGLEN  0xFFFF             /* pass as length for implicit length   */

#define SIDSIZ   5                 /* sysid size                           */
#define AIDSIZ   9                 /* appid size                           */
#define UIDSIZ  30                 /* usrid size                           */
#define FLGSIZ   1                 /* flags for file and local             */
#define SFXSIZ  40                 /* suffix size                          */

#define DNAMSIZ (3+SIDSIZ-1+3+AIDSIZ-1+3+UIDSIZ-1+FLGSIZ+1+1+SFXSIZ)
#define CNAMSIZ (2+AIDSIZ-1+1+SIDSIZ-1+1+UIDSIZ+1+SFXSIZ)

/* Physical Layer */

                                   /* network connection types for phneto()*/
#define TYPSPX  0                  /*   Novell's SPX protocol              */
#define TYPTEL  1                  /*   Telnet                             */
                                   /* non-network connection types         */
#define TYPSER  10                 /*   serial (or modem) connection       */

                                   /* statuses while opening network port  */
#define OPENIP  1                  /*   open still in progress             */
#define OPENOK  0                  /*   connection is up                   */
#define OPENNS -1                  /*   open failed: couldn't find server  */
#define OPENNC -2                  /*   open failed: couldn't connect to " */

void phsini(void);
void phises(int contyp);
void phinap(int taskid);
BOOL phopen(int chan,int comport);
char *phsrvl(int netype);
BOOL phneto(int chan,int netype,char *srvnam);
int phnost(int chan);
BOOL phsetb(int chan,unsigned baudcd);
BOOL pherrf(int chan);
unsigned phavai(int chan);
unsigned phosiz(int chan);
void phclro(int chan);
unsigned phinbw(int chan);
void phclri(int chan);
BOOL phoutp(int chan,unsigned length,char *outbuf);
int phpump(int chan);
BOOL phstat(int chan);
unsigned phinpu(int chan,unsigned length,char *inpbuf);
void phclap(int taskid);
BOOL phclos(int chan);
unsigned long phtckr(void);
void phfses(void);
void phfin(void);

/* Cross-layer codes */

#define DLTYPCTL    1              /* data link link-start packet          */

#define TRTYPTBC   10              /* transport packet to-be-continued     */
#define TRTYPEND   11              /* end of transport packet              */

#define APTYPCSU   20              /* change default 's' and 'u' values    */

#define APTYPREQ   30              /* read specific dynapak                */
#define APTYPRGL   31              /* read greater-than/less-than w/count  */
#define APTYPWRT   32              /* write specific dynapak               */
#define APTYPWRF   33              /* write dynapak, file continuation     */
#define APTYPSTS   34              /* status/length check                  */
#define APTYPABO   35              /* abort request by reqid               */
#define APTYPDNR   36              /* download of file not required        */
#define APTYPRES   37              /* download can be resumed              */
#define APTYPSGL   38              /* directional status/length check      */

#define APTYPSAP   59              /* server apps table download           */

#define APTYPROK   60              /* read data CRC is OK                  */
#define APTYPRDI   61              /* read data download w/implied name    */
#define APTYPXOK   62              /* read data CRC is OK w/index          */
#define APTYPRDX   63              /* read data download w/explicit name   */
#define APTYPRDF   64              /* read dynapak, file continuation      */
#define APTYPRDN   65              /* read denied                          */
#define APTYPWRR   66              /* write response                       */
#define APTYPEVT   67              /* "event": unsolicited dpk received    */
#define APTYPLEN   68              /* dynapak length for APTYPSTS          */
#define APTYPDNC   69              /* download-not-required confirmation   */
#define APTYPABC   70              /* abort confirmation                   */
#define APTYPSLN   71              /* dynapak length for APTYPSGL          */
#define APTYPSDN   72              /* directional status read denied       */

#define NPRIOS      6              /* total number of request priorities   */

                                   /* priority levels (-1 for file reqs)   */
#define BACKGND     1              /*   background priority                */
#define NORMAL      3              /*   normal priority (user waiting)     */
#define CRASH       5              /*   ultra-urgent priority              */

#define ZLNCRC      0xFFFFFFFFL    /* CRC of zero-length string            */

/* Data Link Layer */

#define DLDESYNC   101             /* other guy ACK'ed a packet not sent   */
#define DLCTLERR   102             /* link-start control out of sequence   */
#define DLNAKLIM   103             /* too many NAKs in a row to continue   */

#define MINWCT   2                 /* minimum window packet count          */
#define MAXWCT  32                 /* maximum window packet count          */
#define MAXPSZ 275                 /* maximum packet size (w/o overhead)   */
#define PAKOVH   7                 /* minimum packet overhead              */
#define MAXPZO (MAXPSZ*2+PAKOVH*2) /* maximum packet size (w/ overhead)    */

struct rtxarr {                    /* structure for retransmission array   */
     unsigned length;              /*   length of packet                   */
     char data[MAXPSZ];            /*   packet contents                    */
};

struct dldata {                    /* datalink layer per-channel structure */
     BOOL dlup;                    /*   is datalink initialized?           */
     unsigned paksiz;              /*   negotiated packet size             */
     unsigned bytthr;              /*   output buffer transmit threshold   */
     int rtxhdl;                   /*   hdl for retransmit array or window */
     int rtxaix;                   /*   retransmission array ahead index   */
     int rtxbix;                   /*   retransmission array behind index  */
     int rtxkix;                   /*   ACK'd-so-far packet index          */
     unsigned winpct;              /*   negotiated window packet count     */
     int rnakct;                   /*   received NAK counter               */
     char rcvdok;                  /*   last packet number received OK     */
     int gotsyn;                   /*   got the <SYN> part of <DLE><SYN>?  */
     int gotdle;                   /*   got the <DLE> part of <DLE><SYN>?  */
     int mstsnd;                   /*   do we need to send something now?  */
     int mstrcv;                   /*   need to receive something now?     */
     BOOL locked;                  /*   is our output currently locked?    */
     char rpkbuf[MAXPZO];          /*   buffer to receive packets into     */
     char *rpkptr;                 /*   current pointer into rpkbuf[]      */
     unsigned long time;           /*   time of last action req'ing resp   */
     int dlerr;                    /*   datalink error code                */
};

void dlsini(int nchans,int ncperw);
void dlinit(int chan,unsigned cpsrat,unsigned moutms,unsigned winsiz);
void dlrini(int chan);
void dlclos(int chan);
int dlpump(int chan);
void dlrecv(int chan,unsigned len,char *buf);
void dllock(int chan);
BOOL dllokd(int chan);
void dlunlk(int chan);
unsigned dlavai(int chan);
void dloutp(int chan,unsigned length,char *outbuf);
void dlfin(void);

/* Transport Layer */

#define   TRSHORTP  201            /* received packet too short            */
#define   TROVRFLO  202            /* transport buffer overflow            */
#define   TRBADPRI  203            /* bad priority passed to troutp()      */
#define   TRBADLEN  204            /* bad length passed to troutp()        */
#define   TRQUEFUL  205            /* output queue full                    */
#define   TRRPBPRI  206            /* received packet had bad priority     */

#define   MAXQUE    200            /* max # of packets queued per priority */
#define   MAXDPKV   16384          /* maximum dynapak blob-value size      */
#define   TREXTRA   100            /* extra > 16K in MAXTPSZ for API overhd*/

#define MAXTPSZ (MAXDPKV+TREXTRA)  /* maximum raw transport buffer size    */

#define   ZSPACE    1              /* # of '\0' chars after in-mem record  */
#define   TRKEYSZ   4              /* Btrieve key size in swap file        */
#define   TRNVLSZ   5              /* non-volatile size of Btrieve record  */

#define   RECVIN    0              /* sndrcv value for inbound buffer      */
#define   SNDOUT    1              /* sndrcv value for outbound buffer     */

struct trbrec {                    /* structure for transport packet cache */
     char chan;                    /*   channel transport packet is for    */
     char priority;                /*   priority of transport packet       */
     char sndrcv;                  /*   send/receive buffer indicator      */
     char seqnum;                  /*   sequential number for sequence     */
     char partial;                 /*   is this packet partially sent?     */
     char data[MAXTPSZ];           /*   transport packet data              */
};

struct trbuf {                     /* struct for transport in-memory buffer*/
     unsigned reclen;              /*   length of current in-memory record */
     unsigned nqdinm;              /*   number of records queued in memory */
     unsigned bytsqd;              /*   total number of bytes queued in mem*/
     struct trbrec *rec;           /*   cur packet rec, or NULL if on disk */
     int memidx;                   /*   idx of rec's mem record, if != NULL*/
};

struct trdata {                    /* per-channel transport layer structure*/
     struct trbuf in;              /*   input transport packet memory      */
     struct trbuf out;             /*   output transport packet memory     */
     char tpkinq[NPRIOS];          /*   per-prio: input packet in queue?   */
     char trbptr[NPRIOS];          /*   per-prio: output packet ahead ptr  */
     char traptr[NPRIOS];          /*   per-prio: output packet behind ptr */
     int lockseq;                  /*   sequence number to begin locking at*/
     int trerr;                    /*   transport error code               */
};

void trsini(int maxtask,int nchans,int ncperb,char *msfile);
void trinit(int chan);
void trinap(int opnmode,char *path);
void trrcvp(int chan,unsigned paklen,char *pakbuf);
void trlknx(int chan);
BOOL trlokd(int chan);
void trunlk(int chan);
unsigned travai(int chan,int priority);
BOOL troclr(int chan);
void troutp(int chan,unsigned paklen,char *pakbuf,int priority);
int trpump(int chan);
void trclap(void);
void trclos(int chan);
void trfin(void);

/* API Layer */

struct saunam {                    /* name of dynapak in "structure form"  */
     char sysid[SIDSIZ];           /*   system ID                          */
     char appid[AIDSIZ];           /*   application ID                     */
     char usrid[UIDSIZ];           /*   user ID                            */
     char flags;                   /*   flags (local, file, etc.)          */
     char suffix[SFXSIZ];          /*   suffix                             */
};

struct vbsaunam {                  /* VB form of saunam structure          */
     char sysid[SIDSIZ-1];         /*   system ID                          */
     char appid[AIDSIZ-1];         /*   application ID                     */
     char usrid[UIDSIZ-1];         /*   user ID                            */
     char flags;                   /*   flags (local, file, etc.)          */
     char suffix[SFXSIZ-1];        /*   suffix                             */
};
                                   /* side-independent flag bits for saunam*/
#define FLGFIL    1                /*   dynapak is a file                  */
                                   /* additional client-side flag bits     */
#define FLGLCL    2                /*   dynapak is local to client         */

#define MAXREQS  30                /* max number of outstanding requests   */
#define MINFRQS   5                /* min free requests for qroom()        */

#define DLMCHR      ';'            /* delimiter for prefix overrides       */

#define GLCSIZ   16                /* greater-than/less-than chunk size    */

#define FLNSIZ  (MAXFILE+MAXEXT-1) /* filename size (i.e. 13)              */

struct filinf {                    /* info in first packet of file dynapak */
     char name[FLNSIZ];            /*   file name                          */
     unsigned time;                /*   file time                          */
     unsigned date;                /*   file date                          */
     long size;                    /*   file size in bytes                 */
};

                                   /* flags for typwrf and typrdf records  */
#define FILDUN      1              /*   this is the last packet in the file*/
#define ATRESO      2              /*   resuming file from here (rdf only) */

     /* APTYP record layouts from client to server */

struct typcsu {          /* APTYPCSU: change default 's' and 'u' values    */
     char hdrtyp;
     char sysid[SIDSIZ];
     char usrid[1];
};

struct typreq {          /* APTYPREQ: read specific dynapak                */
     char hdrtyp;             /* priority and crc MUST follow reqid        */
     char reqid;
     char priority;
     long crc;
     char name[1];
};

struct typrgl {          /* APTYPRGL: read greater-than/less-than w/count  */
     char hdrtyp;
     char reqid;
     char priority;
     signed char direction;
     unsigned askcnt;
     char minmat;
     char namncrcs[1];
};

struct typwrt {          /* APTYPWRT: write specific dynapak               */
     char hdrtyp;
     char reqid;
     char priority;
     char namnval[1];
};

struct typwrf {          /* APTYPWRF: write dynapak, file continuation     */
     char hdrtyp;
     char reqid;
     char flags;
     char data[1];
};

struct typsts {          /* APTYPSTS: status/length check                  */
     char hdrtyp;             /* priority and crc MUST follow reqid        */
     char reqid;
     char priority;
     long crc;
     char name[1];
};

struct typabo {          /* APTYPABO: abort request by reqid               */
     char hdrtyp;
     char reqid;
     char priority;
};

struct typdnr {          /* APTYPDNR: download of file not required        */
     char hdrtyp;
     char reqid;
     char priority;
     int  whodnr;
};

struct typres {          /* APTYPRES: download of file can be resumed      */
     char hdrtyp;
     char reqid;
     char priority;
     int whores;
     long resoff;
};

     /* APTYP record layouts from server to client */

struct typrok {          /* APTYPROK: read data CRC is OK                  */
     char hdrtyp;
     char reqid;
};

struct typrdi {          /* APTYPRDI: read data download w/implied name    */
     char hdrtyp;
     char reqid;
     unsigned length;
     char data[1];
};

struct typxok {          /* APTYPXOK: read data CRC is OK w/index          */
     char hdrtyp;
     char reqid;
     char crcidx;
};

struct typrdx {          /* APTYPRDX: read data download w/explicit name   */
     char hdrtyp;
     char reqid;
     unsigned length;
     char namnval[1];
};

struct typsln {          /* APTYPSLN: directional status/length check      */
     char hdrtyp;
     char reqid;
     long length;
     char name[1];
};

struct typrdf {          /* APTYPRDF: read dynapak, file continuation      */
     char hdrtyp;
     char reqid;
     char flags;
     char data[1];
};

struct typrdn {          /* APTYPRDN/APTYPSDN: read denied                 */
     char hdrtyp;
     char reqid;
};

struct typwrr {          /* APTYPWRR: write response                       */
     char hdrtyp;
     char reqid;
     char ok;
     char data[1];
};
                                   /* typwrr.ok flag bits                  */
#define WRRWOK 1                   /*   write was OK by the agent          */
#define WRRABR 2                   /*   agent responded early (abort req'd)*/

struct typevt {          /* APTYPEVT: "event": unsolicited dpk received    */
     char hdrtyp;
     char anamval[1];
};

struct typlen {          /* APTYPLEN: dynapak length for stsdpk()          */
     char hdrtyp;
     char reqid;
     long length;
};

struct typdnc {          /* APTYPDNC: download-not-required confirmation   */
     char hdrtyp;
     char reqid;
};

struct typabc {          /* APTYPABC: abort confirmation                   */
     char hdrtyp;
     char reqid;
};

void apsini(void);
void apinit(int chan,unsigned cpsrat);
void aprcvp(int chan,unsigned paklen,char *pakbuf,BOOL endofp);
int appump(int chan);
void apclos(int chan);
void apfin(void);

unsigned cnvs2c(struct saunam *saunam,char *combuf,char *dsysid,char *dusrid);
unsigned s2capp(char *cbfptr,char *appid);
unsigned cnvc2s(char *combuf,struct saunam *saunam,char *dsysid,char *dusrid);
unsigned c2sapp(char *dest,char *cbfptr);
long namcrc(long crc,struct saunam *sautmp);
BOOL samepatu(char *sau1,char *sau2,BOOL exact);

int lupapp(char *appid);
char *namapp(int appno);

/* Management Layer -- side independent prototypes */

int gmtidx(void);
struct dldata *dldptr(int chan);
struct trdata *trdptr(int chan);

