/***************************************************************************/
/*                                                                         */
/*   GCSASYS.C                                                             */
/*                                                                         */
/*   Copyright (C) 1993 Consensus Systems, Inc.  All rights reserved.      */
/*   Copyright (c) 1993-1996 Galacticomm, Inc.   All rights reserved.      */
/*                                                                         */
/*   This is the Galacticomm Client/Server "System Agent".                 */
/*                                                                         */
/*                                                - T. Stryker 8/5/93      */
/*                                                  C. Robert              */
/*                                                  B. Love                */
/*                                                                         */
/*   - Added standard system dynapak read/write support.                   */
/*   - Added support for C/S version of userid x-ref list.                 */
/*                                                                         */
/*                                                - Bill Hyatt 7/15/94     */
/*                                                                         */
/*   - Added new system dynapaks for remote console capability.            */
/*                                                                         */
/*                                                - Joe Delekto 1/20/96    */
/*                                                                         */
/***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "gcsasys.h"
#include "bbserver.h"

#define FILREV "$Revision: 1.27 $"

#define   LOKDLY    32768L         /* delay for locking/unlocking datalink */
#define   w4atck    (*((unsigned long *)mrqptr))
                                   /* ticker for C/S-A/A mode swiches      */
#define   XRFPCY    10             /* # of uid's to cross-ref per cycle    */
#define   FREE2U    -1             /* chan's req free to use uid x-ref     */
#define   XSFXSZ    5              /* size of suffix info in uid x-ref list*/
#define   STDNSZ    14             /* size of std dpk/field names (w/ NULL)*/
#define   NSYSEL    4              /* #elems in sysstg[] array             */
#define   NANSEL    4              /* #elems in ansstg[] array             */
#define   UIDISZ    14+1           /* size of ret stg for "useridinfo" dpk */
#define   UIDDLM    ';'            /* delim chr for uids in dpk names/vals */
#define   LSFXSZ    4              /* size of suffix info in lnglst stg    */
#define   LNGSEP    9              /* delimiter for langs in lnglst        */
#define   MXGCDI    20             /* max len for "gcditype" chaninfo fld  */
#define   MINSWD    40             /* minimum ANSI screen width allowed    */
#define   MAXSWD    136            /* maximum ANSI screen width allowed    */
#define   MINSLN    3              /* minimum ANSI screen length allowed   */
#define   MAXSLN    254            /* maximum ANSI screen length allowed   */
#define   UINAID    "GALUIE"       /* acc disp/edit appid used by uintfy() */

/* types of possible parameters in "chaninfo" std dpk suffix */
#define   ISNULL    0              /* parm is '\0'                         */
#define   ISCNUM    1              /* parm is channel number (c=nn)        */
#define   ISUID     2              /* parm is user-id (u=xxx)              */
#define   ISUNUM    3              /* parm is a usrnum (n=nn)              */
#define   ISFLD     4              /* parm is possibly a field name        */

/* possible actions for write of language dpks */
#define   CHGNON    0              /* no change                            */
#define   CHGAUT    1              /* change preference to AUTO            */
#define   CHGONL    2              /* change online for this session only  */
#define   CHGOND    3              /* change permanently on disk           */

/* length of return values for dynapak fields */
#define   CHRLEN    sizeof(char)   /* used for char return values          */
#define   INTLEN    sizeof(int)    /* used for int return values           */
#define   LNGLEN    sizeof(long)   /* used for long return values          */
#define   DBLLEN    sizeof(double) /* used for double return values        */
#define   AXSLEN    (sizeof(int)*7)/* used for array of access flags       */

                          /* note: unsigned values are cast as longs for VB*/
#define   cdr(vp,t) (*((t *)vp))   /* cast and dereference void pointer    */
#define   cvp(vp,t) ((t *)vp)      /* cast a void pointer                  */

#define   NCLSSZ    ((4*(KEYSIZ-1))+11) /* len of stg from "nextclass" fld */

/* length of return values for "sysinfo" fields */
#define   TTLSIZ    50             /* sysname (same as CNF opt BBSTTL)     */
#define   CMPSIZ    46             /* syscompnay (same as CNF opt COMPANY) */
#define   ADDRSZ    44             /* sysaddr1/2 (sam as CNF opt ADDRES1/2)*/
#define   DTPHSZ    32             /* sysphone (same as CNF opt DATAPH)    */
#define   LVPHSZ    31             /* restpho (same as CNF opt LIVEPH)     */
#define   CGHRSZ    22             /* chghour ( "   "   "   "  CHGHOUR)    */
#define   CGMNSZ    31             /* mincharge (same as CNF opt CHGMIN)   */
#define   RNOSIZ    8              /* regnumber                            */


#define   cpyrsp(s) stlcpy(rsptmp,(s),MAXDPKV)    /* start new response str*/
#define   delimiter() stlcat(rsptmp,"\t",MAXDPKV) /* add delimiter to rsp  */
#define   catrsp(s) stlcat(rsptmp,(s),MAXDPKV)    /* add to response str   */

static void sysread(int direction,struct saunam *dpknam);
static void syswrite(struct saunam *dpknam,unsigned length,void *value);
static void sysxdone(void);
static void sysabort(void);

struct agent sysagt={              /* agent information structure           */
     "",                           /*   appid                               */
     sysread,                      /*   read-dynapak function pointer       */
     syswrite,                     /*   write-dynapak function pointer      */
     sysxdone,                     /*   file xfer-done function pointer     */
     sysabort                      /*   abort-request function pointer      */
};

struct srchdat {                   /* per-channel user-id x-ref data       */
     char begxrf[XRFSIZ];          /*   x-ref string to start with         */
     int usingid;                  /*   FREE2U, or id of req using x-ref   */
     unsigned long curpos;         /*   current pos in xrf data file       */
     int nsofar;                   /*   # of userids sent so far           */
     char *uidlst;                 /*   list of uids to send to client     */
} *srchdat,                        /* array of user-id x-ref data          */
  *sdatptr;                        /* ptr to current channel's x-ref data  */

struct pndreq {                    /* per-req area for pending x-ref req's */
     char begxrf[XRFSIZ];          /*   x-ref string to start with         */
};

#define spndptr ((struct pndreq *)mrqptr) /* ptr to pending req mem area   */

struct ncicrdvb {                  /* for uintfy(): new cls info if shwcrd */
     char clname[KEYSIZ-1];        /*   class name                         */
     int limcal;                   /*   time limit per call                */
     int limday;                   /*   time limit per day                 */
     long dbtlmt;                  /*   debt limit                         */
     char exempt;                  /*   exempt from credit charges? (Y/N)  */
};

struct ncivb {                     /* for uintfy(): new cls info, no shwcrd*/
     char clname[KEYSIZ-1];        /*   class name                         */
     int limcal;                   /*   time limit per call                */
     int limday;                   /*   time limit per day                 */
};

char dpkrvchr,                     /* used for type char dpk read resp's   */
     nilrvchr='\0',                /* used to ret "nil" for char read rsp's*/
     *supappid,                    /* signup agent's appid                 */
     *mmappid,                     /* main menu agent's appid              */
     *stakey;                      /* key required to read "sysstat" dpk   */

int dpkrvint,                      /* used for type int dpk read resp's    */
    nilrvint=-MAXINT,              /* used to ret "nil" for int read resp's*/
    dpkusn,                        /* std dpk: req'd uid's usrnum          */
    csnumxrf,                      /* max userid x-refs for C/S users      */
    chglngt,                       /* action for "su:userinfo language" wrt*/
    nwlingot,                      /* new lingo for "su:userinfo language" */
    chglngp,                       /* action for "su:userinfo permlang" wrt*/
    nwlingop;                      /* new lingo for "su:userinfo permlang" */

BOOL usron,                        /* std dpk: req'd uid currently online? */
     uidsame,                      /* std dpk: is req'd uid current user?  */
     invldres;                     /* reason that vlduid() rejected userid */

long dpkrvlng,                     /* used for type long dpk read resp's   */
     nilrvlng=-MAXLONG;            /* used to ret "nil" for long read rsp's*/

double dpkrvdbl;                   /* used for type double dpk read resp's */

FILE *gcsmb;                       /* GCSP message block pointer           */

int jumpflags;                     /* controls plugin main menu execution  */

struct user *dpkusp;               /* std dpk: req'd uid's user struct     */

struct usracc *dpkuap,             /* std dpk: req'd uid's in-mem usracc   */
              accrec;              /* std dpk: req'd uid's on-disk usracc  */

struct extusr *dpkext;             /* std dpk: req'd uid's extusr struct   */

BOOL (*swtcls_hook)(struct usracc *usract,char *class,int days)=NULL;

extern
char *langchg;                     /* key required to change lang pref     */

extern
struct clstab *clshead;                 /* pointer to class info in memory */

extern
int maxpol,                        /* system polling rate                  */
    shwcrd;                        /* show users' credits?                 */

extern
BTVFILE *keysbb,                   /* keys database pointer                */
        *clsbb,                    /* class database pointer               */
        *xrfbb;                    /* user-id x-ref database pointer       */

static void wt2srch(void);
static void gtuids(char *begxrf);
static void bldlst(void);
static void snduids(char *uidlst);
static struct clstab *getctp(void);
static BOOL wrtlng(int newlang,BOOL wrtonl);
static int *rdlng(BOOL rdonl);
static int adjlgo(int ilingo);
static BOOL vlduid(char *dpkuid,char *reqkey);
static void onlacc(struct usracc *dpkuap);
static void gtkrng(char *ringid,BOOL clsrng,struct saunam *dpknam);
static void ptkrng(char *ringid,char *rings,BOOL clsrng);
void uintfy(int chan,char *uid,struct clstab *cltptr);
static void wt4lok(void);
static void w4ldly(void);
static void w4udly(void);
static void retwgmvr(void);
static void retfilist(void);
static void dontzap(void);
static void retfile(char *filname);
static void retupdfile(char *filname,int direction);
static void sysfin(void);
static BOOL csdftpsw(char *psword);


/* dynapak/field read routines and aux. functions */
static void dpkr_agentver(struct saunam *dpknam);
static void dpkr_chaninfo(struct saunam *dpknam);
static BOOL prssfx(char *suffix,char **fldnam);
static int  prmtyp(char *parm);
static void dpkra_chaninfo(struct chninfvb *chninfvb);
static void *fldr_useridc(void),   *fldr_channel(void),
            *fldr_chantype(void),  *fldr_gcditype(void),
            *fldr_usernumber(void),*fldr_baud(void),
            *fldr_mode(void);
static void dpkr_classinfo(struct saunam *dpknam);

static void dpkra_classinfo(struct clsinfvb *clsinfvb);
static void *fldr_nextclass(void),*fldr_limpercall(void),
            *fldr_limperday(void),*fldr_defdayexp(void),
            *fldr_debtlimtc(void),*fldr_forgivdays(void),
            *fldr_idledays(void), *fldr_flags(void),
            *fldr_seconds(void),  *fldr_usersin(void);
static void dpkr_classkeys(struct saunam *dpknam);
static void dpkr_classmsgs(struct saunam *dpknam);
static void dpkr_classlist(struct saunam *dpknam);
static void dpkr_langlist(struct saunam *dpknam);
static void dpkr_rsptime(struct saunam *dpknam);
static void dpkr_sysinfo(struct saunam *dpknam);
static void dpkra_sysinfo(struct sysinfvb *sysinfvb);
static void *fldr_sysname(void),  *fldr_syscompany(void),
            *fldr_sysaddr1(void), *fldr_sysaddr2(void),
            *fldr_sysphone(void), *fldr_restpho(void),
            *fldr_chgperhr(void), *fldr_mincharge(void),
            *fldr_regnumber(void);
static void dpkr_sysloading(struct saunam *dpknam);
static void dpkr_syspolrate(struct saunam *dpknam);
static void dpkr_sysstat(struct saunam *dpknam);
static void dpkra_sysstat(struct stainfvb *stainfvb);
static void *fldr_numlines(void),   *fldr_othonline(void),
            *fldr_totalcalls(void), *fldr_downloads(void),
            *fldr_uploads(void),    *fldr_totalmsgs(void),
            *fldr_totalaccts(void), *fldr_totalmale(void),
            *fldr_totalfemale(void),*fldr_totalcorp(void),
            *fldr_totalansi(void);
static void dpkr_useridinfo(struct saunam *dpknam);
static void dpkr_userinfo(struct saunam *dpknam);
static void dpkra_userinfo(struct usrinfvb *usrinfvb);
static void *fldr_userid(void),    *fldr_password(void),
            *fldr_name(void),      *fldr_company(void),
            *fldr_address1(void),  *fldr_address2(void),
            *fldr_address3(void),  *fldr_phone(void),
            *fldr_systemtype(void),*fldr_ansi(void),
            *fldr_scnwidth(void),  *fldr_scnlength(void),
            *fldr_fsescnlen(void), *fldr_editorprf(void),
            *fldr_age(void),       *fldr_sex(void),
            *fldr_birthdate(void), *fldr_createdate(void),
            *fldr_laston(void),    *fldr_class(void),
            *fldr_retclass(void),  *fldr_creditrate(void),
            *fldr_credits(void),   *fldr_credever(void),
            *fldr_paidever(void),  *fldr_timeonline(void),
            *fldr_calltimlim(void),*fldr_daytimlim(void),
            *fldr_timetoday(void), *fldr_daysleft(void),
            *fldr_debtlimit(void), *fldr_exempt(void),
            *fldr_language(void),  *fldr_permlang(void),
            *fldr_acctflags(void), *fldr_secondstt(void),
            *fldr_access(void);
static void dpkr_usrclskeys(struct saunam *dpknam);
static void dpkr_usrpslkeys(struct saunam *dpknam);

/* dynapak/field write routines and aux. functions */
static void dpkw_reqgenagt(struct saunam *dpknam,unsigned length,void *value);
static void dpkw_userinfo(struct saunam *dpknam,unsigned length,void *value);
static void dpkw_usrpslkeys(struct saunam *dpknam,unsigned length,void *value);
static void dpkw_classinfo(struct saunam *dpknam,unsigned length,void *value);
static void dpkw_classkeys(struct saunam *dpknam,unsigned length,void *value);
static void dpkw_classmsgs(struct saunam *dpknam,unsigned length,void *value);
static void dpkw_classkill(struct saunam *dpknam,unsigned length,void *value);
static BOOL dpkwa_classinfo(struct clsinfvb *clsinfvb,struct acclass *clsdat);
static BOOL fldw_nextclass(char *clsstg,struct acclass *clsdat);
static BOOL fldw_limpercall(int *newlim,struct acclass *clsdat);
static BOOL fldw_limperday(int *newlim, struct acclass *clsdat);
static BOOL fldw_defdayexp(int *newexp, struct acclass *clsdat);
static BOOL fldw_debtlimtc(long *newlim, struct acclass *clsdat);
static BOOL fldw_forgivdays(int *newday,struct acclass *clsdat);
static BOOL fldw_idledays(int *newday,struct acclass *clsdat);
static BOOL fldw_flags(int *newflg,struct acclass *clsdat);
static BOOL fldw_seconds(long *newsec,struct acclass *clsdat);
static BOOL fldw_usersin(long *newusr,struct acclass *clsdat);
static void chglng(int lngact,int newlingo);
static BOOL dpkwa_userinfo(struct usrinfvb *usrinfvb, struct usracc *accrec);
static int  valinf(char *infstg,unsigned minlen,BOOL chkpfn);
static BOOL fldw_password(char *newpsw, struct usracc *accrec),
            fldw_name(char *newname,struct usracc *accrec),
            fldw_company(char *newcomp,struct usracc *accrec),
            fldw_address1(char *newaddr,struct usracc *accrec),
            fldw_address2(char *newaddr,struct usracc *accrec),
            fldw_address3(char *newaddr,struct usracc *accrec),
            fldw_phone(char *newpho,struct usracc *accrec),
            fldw_systemtype(int *newstyp,struct usracc *accrec),
            fldw_ansi(int *newansi,struct usracc *accrec),
            fldw_daysleft(long *newdays,struct usracc *accrec),
            fldw_scnwidth(int *newwid,struct usracc *accrec),
            fldw_scnlength(int *newlen,struct usracc *accrec),
            fldw_fsescnlen(int *newlen,struct usracc *accrec),
            fldw_editorprf(char *newprf,struct usracc *accrec),
            fldw_birthdate(double *newbdy,struct usracc *accrec),
            fldw_acctflags(int *newflags,struct usracc *accrec),
            fldw_sex(char *newsex,struct usracc *accrec),
            fldw_class(char *newclass,long daysleft,struct usracc *accrec),
            fldw_language(int *newlang),
            fldw_permlang(int *newlang),
            fldw_access(int *flags,struct usracc *accrec);

struct sdpkinf {                   /* standard dynapak info structure      */
     char dpknam[STDNSZ];          /*   dynapak name                       */
     void (*dpkrrou)();            /*   dynapak read routine               */
     void (*dpkwrou)();            /*   dynapak write routine              */
} stdpks[]={                       /* array of standard dynapak info       */
     {"s:agentver",   dpkr_agentver,  NULL},
     {"s:chaninfo",   dpkr_chaninfo,  NULL},
     {"s:classinfo",  dpkr_classinfo, dpkw_classinfo},
     {"s:classkeys",  dpkr_classkeys, dpkw_classkeys},
     {"s:classmsgs",  dpkr_classmsgs, dpkw_classmsgs},
     {"s:classlist",  dpkr_classlist, NULL},
     {"s:classkill",  NULL,           dpkw_classkill},
     {"s:langlist",   dpkr_langlist,  NULL},
     {"s:reqgenagt",  NULL,           dpkw_reqgenagt},
     {"s:rsptime",    dpkr_rsptime,   NULL},
     {"s:sysinfo",    dpkr_sysinfo,   NULL},
     {"s:sysloading", dpkr_sysloading,NULL},
     {"s:syspolrate", dpkr_syspolrate,NULL},
     {"s:sysstat",    dpkr_sysstat,   NULL},
     {"s:useridinfo", dpkr_useridinfo,NULL},
     {"su:userinfo",  dpkr_userinfo,  dpkw_userinfo},
     {"su:usrclskeys",dpkr_usrclskeys,NULL},
     {"su:usrpslkeys",dpkr_usrpslkeys,dpkw_usrpslkeys}
};

struct fldinf {                    /* std dpk field info structure         */
     char fldnam[STDNSZ];          /*   field name                         */
     void *(*fldrrou)();           /*   field read routine                 */
     int retlen;                   /*   length of reads' returned info     */
     BOOL (*fldwrou)();            /*   field write routine                */
};

struct fldinf cinflds[]={          /* fields for "chaninfo" std dpk        */
     {"userid",    fldr_useridc,   STGLEN,NULL},
     {"channel",   fldr_channel,   INTLEN,NULL},
     {"chantype",  fldr_chantype,  INTLEN,NULL},
     {"gcditype",  fldr_gcditype,  STGLEN,NULL},
     {"usernumber",fldr_usernumber,INTLEN,NULL},
     {"baud",      fldr_baud,      LNGLEN,NULL},
     {"mode",      fldr_mode,      INTLEN,NULL},
};

struct chninfvb {                  /* VB structure form of "chaninfo"      */
     char userid[UIDSIZ-1];        /*   userid on channel                  */
     int channel;                  /*   user's channel number              */
     int chantype;                 /*   type of channel (modem,lan,etc.)   */
     char gcditype[MXGCDI];        /*   type of chan if GCDI, or all ' '   */
     int usernumber;               /*   user number (ie. usrnum)           */
     long baud;                    /*   user's baud rate                   */
     int mode;                     /*   -1=C/S, 0-99=A/A language number   */
};

struct fldinf clsflds[]={          /* fields for "classinfo" std dpk       */
     {"nextclass", fldr_nextclass, STGLEN,fldw_nextclass},
     {"limpercall",fldr_limpercall,INTLEN,fldw_limpercall},
     {"limperday", fldr_limperday, INTLEN,fldw_limperday},
     {"defdayexp", fldr_defdayexp, INTLEN,fldw_defdayexp},
     {"debtlimit", fldr_debtlimtc, LNGLEN,fldw_debtlimtc},
     {"forgivdays",fldr_forgivdays,INTLEN,fldw_forgivdays},
     {"idledays",  fldr_idledays,  INTLEN,fldw_idledays},
     {"flags",     fldr_flags,     INTLEN,fldw_flags},
     {"seconds",   fldr_seconds,   LNGLEN,fldw_seconds},
     {"usersin",   fldr_usersin,   LNGLEN,fldw_usersin}
};

struct clsinfvb {                  /* VB structure form of "classinfo"     */
     char nextclass[NCLSSZ];       /*   class to return to when expires    */
     int limpercall;               /*   limit per call                     */
     int limperday;                /*   limit per day                      */
     int defdayexp;                /*   default days before expiring       */
     long debtlimit;               /*   debt limit                         */
     int forgivdays;               /*   days to wait before "forgiving"    */
     int idledays;                 /*   inactive days before delete        */
     int flags;                    /*   general bit flags                  */
     long seconds;                 /*   seconds used so far this month     */
     long usersin;                 /*   total # of users in this class     */
};

struct fldinf sinflds[]={          /* fields for "sysinfo" std dpk         */
     {"sysname",   fldr_sysname,   STGLEN,NULL},
     {"syscompany",fldr_syscompany,STGLEN,NULL},
     {"sysaddr1",  fldr_sysaddr1,  STGLEN,NULL},
     {"sysaddr2",  fldr_sysaddr2,  STGLEN,NULL},
     {"sysphone",  fldr_sysphone,  STGLEN,NULL},
     {"restpho",   fldr_restpho,   STGLEN,NULL},
     {"chgperhr",  fldr_chgperhr,  STGLEN,NULL},
     {"mincharge", fldr_mincharge, STGLEN,NULL},
     {"regnumber", fldr_regnumber, STGLEN,NULL}
};

struct sysinfvb {                  /* VB structure form of "sysinfo"       */
     char sysname[TTLSIZ];         /*   system name                        */
     char syscompany[CMPSIZ];      /*   system company                     */
     char sysaddr1[ADDRSZ];        /*   system address line 1              */
     char sysaddr2[ADDRSZ];        /*   system address line 2              */
     char sysphone[DTPHSZ];        /*   system phone number                */
     char restpho[LVPHSZ];         /*   system restricted phone number     */
     char chgperhr[CGHRSZ];        /*   charge per hour                    */
     char mincharge[CGMNSZ];       /*   minimum charge                     */
     char regnumber[RNOSIZ];       /*   registration number                */
};

struct fldinf staflds[]={          /* fields for "sysstat" std dpk         */
     {"numlines",   fldr_numlines,   INTLEN,NULL},
     {"othonline",  fldr_othonline,  INTLEN,NULL},
     {"totalcalls", fldr_totalcalls, LNGLEN,NULL},
     {"downloads",  fldr_downloads,  LNGLEN,NULL},
     {"uploads",    fldr_uploads,    LNGLEN,NULL},
     {"totalmsgs",  fldr_totalmsgs,  LNGLEN,NULL},
     {"totalaccts", fldr_totalaccts, LNGLEN,NULL},
     {"totalmale",  fldr_totalmale,  LNGLEN,NULL},
     {"totalfemale",fldr_totalfemale,LNGLEN,NULL},
     {"totalcorp",  fldr_totalcorp,  LNGLEN,NULL},
     {"totalansi",  fldr_totalansi,  LNGLEN,NULL}
};

struct stainfvb {                  /* VB structure form of "sysstat"       */
     int numlines;                 /*   number channels defined on server  */
     int othonline;                /*     "    of channels in use          */
     long totalcalls;              /*   total calls to date                */
     long downloads;               /*     "   downloads to date            */
     long uploads;                 /*     "   uploads to date              */
     long totalmsgs;               /*     "   messages to date             */
     long totalaccts;              /*   number of accounts                 */
     long totalmale;               /*     "    "  male accounts            */
     long totalfemale;             /*     "    "  female accounts          */
     long totalcorp;               /*     "    "  corporate accounts       */
     long totalansi;               /*     "    "  ansi accounts            */
};

struct fldinf uinflds[]={          /* fields for "userinfo" std dpk        */
     {"userid",    fldr_userid,    STGLEN,NULL},
     {"password",  fldr_password,  STGLEN,fldw_password},
     {"name",      fldr_name,      STGLEN,fldw_name},
     {"company",   fldr_company,   STGLEN,fldw_company},
     {"address1",  fldr_address1,  STGLEN,fldw_address1},
     {"address2",  fldr_address2,  STGLEN,fldw_address2},
     {"address3",  fldr_address3,  STGLEN,fldw_address3},
     {"phone",     fldr_phone,     STGLEN,fldw_phone},
     {"systemtype",fldr_systemtype,INTLEN,fldw_systemtype},
     {"ansi",      fldr_ansi,      INTLEN,fldw_ansi},
     {"scnwidth",  fldr_scnwidth,  INTLEN,fldw_scnwidth},
     {"scnlength", fldr_scnlength, INTLEN,fldw_scnlength},
     {"fsescnlen", fldr_fsescnlen, INTLEN,fldw_fsescnlen},
     {"editorprf", fldr_editorprf, CHRLEN,fldw_editorprf},
     {"age",       fldr_age,       INTLEN,NULL},
     {"birthdate", fldr_birthdate, DBLLEN,fldw_birthdate},
     {"sex",       fldr_sex,       CHRLEN,fldw_sex},
     {"createdate",fldr_createdate,DBLLEN,NULL},
     {"laston",    fldr_laston,    DBLLEN,NULL},
     {"class",     fldr_class,     STGLEN,fldw_class},
     {"retclass",  fldr_retclass,  STGLEN,NULL},
     {"creditrate",fldr_creditrate,INTLEN,NULL},
     {"credits",   fldr_credits,   LNGLEN,NULL},
     {"credever",  fldr_credever,  LNGLEN,NULL},
     {"paidever",  fldr_paidever,  LNGLEN,NULL},
     {"timeonline",fldr_timeonline,INTLEN,NULL},
     {"calltimlim",fldr_calltimlim,INTLEN,NULL},
     {"daytimlim", fldr_daytimlim, INTLEN,NULL},
     {"timetoday", fldr_timetoday, LNGLEN,NULL},
     {"seconds",   fldr_secondstt, LNGLEN,NULL},
     {"daysleft",  fldr_daysleft,  INTLEN,fldw_daysleft},
     {"debtlimit", fldr_debtlimit, LNGLEN,NULL},
     {"exempt",    fldr_exempt,    CHRLEN,NULL},
     {"language",  fldr_language,  INTLEN,fldw_language},
     {"permlang",  fldr_permlang,  INTLEN,fldw_permlang},
     {"acctflags", fldr_acctflags, INTLEN,fldw_acctflags},
     {"access",    fldr_access,    AXSLEN,fldw_access}
};

struct usrinfvb {                  /* VB structure form of "userinfo"      */
     char userid[UIDSIZ-1];        /*   userid                             */
     char password[PSWSIZ-1];      /*   password                           */
     char name[NADSIZ-1];          /*   user name                          */
     char company[NADSIZ-1];       /*   address line 1                     */
     char address1[NADSIZ-1];      /*      "     "   2                     */
     char address2[NADSIZ-1];      /*      "     "   3                     */
     char address3[NADSIZ-1];      /*      "     "   4                     */
     char phone[PHOSIZ-1];         /*   user phone number                  */
     int systemtype;               /*   system type                        */
     int ansi;                     /*   ansi preference                    */
     int scnwidth;                 /*   screen width                       */
     int scnlength;                /*   screen len                         */
     int fsescnlen;                /*   screen length for FSE              */
     char editorprf;               /*   editor preference                  */
     int age;                      /*   user age                           */
     double birthdate;             /*   user birthdate                     */
     char sex;                     /*   user sex                           */
     double createdate;            /*   account creation date              */
     double laston;                /*   last logged on date                */
     char class[KEYSIZ-1];         /*   current user class                 */
     char retclass[KEYSIZ-1];      /*   class to return to if necc.        */
     int creditrate;               /*   current credit rate                */
     long credits;                 /*   current number of credits          */
     long credever;                /*   credits to user ever               */
     long paidever;                /*   paid credits to user ever          */
     int timeonline;               /*   time online this call              */
     int calltimlim;               /*   time limit per call                */
     int daytimlim;                /*    "     "    "  day                 */
     long timetoday;               /*   time online today                  */
     long daysleft;                /*   days left in class                 */
     long debtlimit;               /*   debt limit                         */
     char exempt;                  /*   exempt from credit charges?        */
     int language;                 /*   index of current language          */
     int permlang;                 /*   index of permanent (on disk) lang  */
     int acctflags;                /*   account flags                      */
     int access[AXSSIZ];           /*   remote administrator access flags  */
};

void
inisysagt(void)                    /* initialize the system agent          */
{
     int i;

     register_agent(&sysagt);
     gcsmb=opnmsg("BBSERVER.MCV");
     supappid=stgopt(SUPAPPID);
     mmappid=stgopt(MMAPPID);
     stakey=stgopt(STAKEY);
     csnumxrf=numopt(CSNUMXRF,0,100);
     jumpflags=0;
     if (ynopt(JFLAGOFF)) {
          jumpflags|=1;
          if (ynopt(JFLAGRUN)) {
               jumpflags|=2;
          }
          else if (ynopt(JFLAGADV)) {
               jumpflags|=4;
          }
     }
     srchdat=(struct srchdat *)alczer(nterms*sizeof(struct srchdat));
     for (i=0 ; i < nterms ; i++) {
          srchdat[i].usingid=FREE2U;
          srchdat[i].uidlst=alczer(csnumxrf*(sgnusz+1)+XSFXSZ+1);
     }
     dclmrq(max(sizeof(unsigned long),sizeof(struct pndreq)));
     inigenagt();
     hook_shutdown(sysfin);
}

static void
sysread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg,*begxrf;
     int i;

     if (sameas(dpknam->sysid,msysid)) {
          setmbk(gcsmb);
          dpkstg=cnvs2d(dpknam);
          if (sameto("sf:osmupdfile ",dpkstg)) {
               *namtmp=*dpknam;
               retupdfile(filnpart(strchr(dpkstg,' ')+1),direction);
               return;
          }
          if (direction != 0) {    /* ALL AFTER HERE ARE NONDIRECTIONAL */
               rejectreq();
               return;
          }
          if (sameas(dpkstg,"s:supappid")) {
               if ((*hdlsmp)()) {
                    rsp2read(dpknam,STGLEN,spr("Y%s",supappid));
               }
               else {
                    prf("N");
                    prfmsg(NONEWU);
                    r2rprf(dpknam);
                    byenow(NOMSG);
               }
               return;
          }
          else if (sameas(dpkstg,"s:jumpflags")) {
               sprintf(rsptmp,"%d",jumpflags);
               rsp2read(dpknam,STGLEN,rsptmp);
               return;
          }
          else if (sameas(dpkstg,"s:wgmversion")) {
               retwgmvr();
               return;
          }
          else if (sameas(dpkstg,"s:osmversion")) {
               rsp2read(dpknam,STGLEN,"32767");/* old clients need update */
               return;
          }
          else if (sameas(dpkstg,"s:osmfilelist")) {
               retfilist();
               return;
          }
          else if (sameto("sf:osmfile ",dpkstg)) {
               retfile(filnpart(strchr(dpkstg,' ')+1));
               return;
          }
          else if (haskey("")) {
               if (sameto("s:useridxrf",dpkstg)) {
                    if ((begxrf=skpwht(skpwrd(dpknam->suffix))) != '\0') {
                         if (srchdat[usrnum].usingid == FREE2U) {
                              gtuids(begxrf);
                         }
                         else {
                              stzcpy(spndptr->begxrf,begxrf,XRFSIZ);
                              cycleme(wt2srch);
                         }
                         return;
                    }
               }
               else {
                    for (i=0 ; i < nelems(stdpks) ; i++) {
                         if (samepato(stdpks[i].dpknam,dpkstg)) {
                              if (stdpks[i].dpkrrou != NULL) {
                                   (*stdpks[i].dpkrrou)(dpknam);
                                   return;
                              }
                              break;
                         }
                    }
               }
          }
     }
     rejectreq();
}

static void
wt2srch(void)                      /* cycle while waiting to use x-ref fac */
{
     if (srchdat[usrnum].usingid == FREE2U) {
          cycleme(NULL);
          gtuids(spndptr->begxrf);
     }
}

static void
gtuids(                            /* get userids for userid x-ref list    */
char *begxrf)                      /*   beginning search string            */
{
     char xrf[XRFSIZ+1];

     sdatptr=&srchdat[usrnum];
     sdatptr->usingid=greqid;
     stzcpy(xrf,begxrf,XRFSIZ);
     xrf[XRFSIZ]='\0';
     setbtv(xrfbb);
     if (!agebtv(&uidxrf,xrf,0)) {
          snduids(NULL);
     }
     else {
          if (csnumxrf == 0) {
               snduids(sameas(uidxrf.userid,begxrf)
                       ? spr("%s;n=1",uidxrf.userid) : NULL);
          }
          else if (csnumxrf == 1) {
               snduids(spr("%s;n=1",uidxrf.userid));
          }
          else {
               stzcpy(sdatptr->begxrf,xrf,XRFSIZ);
               sdatptr->curpos=absbtv();
               sdatptr->nsofar=0;
               sdatptr->uidlst[0]='\0';
               cycleme(bldlst);
          }
     }
}

static void
bldlst(void)                       /* build user-id x-ref list             */
{
     struct uidxrf tmpxrf;
     int i;

     setbtv(xrfbb);
     gabbtv(&uidxrf,(sdatptr=&srchdat[usrnum])->curpos,0);
     for (i=0 ; i < XRFPCY ; i++) {
          if (!sameto(sdatptr->begxrf,uidxrf.xrfstg)) {
               break;
          }
          if (!sameas(uidxrf.userid,tmpxrf.userid)) {
               strcat(sdatptr->uidlst,spr("%s;",uidxrf.userid));
               if (++sdatptr->nsofar == csnumxrf) {
                    break;
               }
          }
          if (!qnxbtv()) {
               break;
          }
          movmem(&uidxrf,&tmpxrf,sizeof(struct uidxrf));
          movmem(xrfbb->data,&uidxrf,sizeof(struct uidxrf));
     }
     if (i < XRFPCY) {
          strcat(sdatptr->uidlst,spr("n=%d",sdatptr->nsofar));
          snduids(sdatptr->uidlst);
     }
     else {
          sdatptr->curpos=absbtv();
     }
}

static void
snduids(                           /* send userid x-ref list to client     */
char *uidlst)                      /*   list to send (NULL to reject req)  */
{
     sdatptr->usingid=FREE2U;
     if (uidlst != NULL) {
          rsp2read(&rqdptr->saunam,STGLEN,uidlst);
     }
     else {
          rejectreq();
     }
}

static void
dpkr_agentver(                     /* "agentver" std dpk read rtn          */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     char mdfnam[FNEXSZ],*appid;
     struct fndblk fb;

     appid=skpwht(skpwrd(dpknam->suffix));
     stlcpy(mdfnam,spr("%s.MDF",appid),FNEXSZ);
     if (fnd1st(&fb,mdfnam,0)) {
          rsp2read(NULL,STGLEN,scnmdf(mdfnam,"Agent version:"));
     }
     else {
          rsp2read(NULL,0,NULL);
     }
}

static void
dpkr_chaninfo(                     /* "chaninfo" std dpk read rtn          */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     char suffix[SFXSIZ],*fldnam;
     int i;
     static struct chninfvb chninfvb;

     stlcpy(suffix,dpknam->suffix,SFXSIZ);
     if (haskey(syskey) && prssfx(suffix,&fldnam)) {
          if (fldnam == NULL) {
               dpkra_chaninfo(&chninfvb);
               rsp2read(dpknam,sizeof(struct chninfvb),&chninfvb);
               return;
          }
          for (i=0 ; i < nelems(cinflds) ; i++) {
               if (sameas(cinflds[i].fldnam,fldnam)) {
                    if (cinflds[i].fldrrou != NULL) {
                         rsp2read(dpknam,cinflds[i].retlen,
                                  (*cinflds[i].fldrrou)());
                         return;
                    }
                    break;
               }
          }
     }
     rejectreq();
}

static BOOL
prssfx(                            /* parse "chaninfo" std dpk suffix      */
char *suffix,                      /*   chaninfo dpk suffix                */
char **fldnam)                     /*   ptr to set to fld name (or NULL)   */
{
     char *parm,uid[UIDSIZ],*enduid;
     int cnum,unum,ptype;

     parm=skpwht(skpwrd(suffix));
     if ((ptype=prmtyp(parm)) == ISFLD) {
          *fldnam=parm;
          parm=skpwht(skpwrd(parm));
          *skpwrd(*fldnam)='\0';
          ptype=prmtyp(parm);
     }
     else {
          *fldnam=NULL;
     }
     parm+=2;
     switch (ptype) {
     case ISNULL:
          dpkusn=usrnum;
          dpkusp=usrptr;
          dpkuap=usaptr;
          dpkext=extptr;
          return(TRUE);
     case ISCNUM:
          sscanf(parm,"%x",&cnum);
          if ((unum=usridx(cnum)) >= 0) {
               dpkusn=unum;
               dpkusp=&user[unum];
               dpkuap=uacoff(unum);
               dpkext=extoff(dpkusn);
               return(TRUE);
          }
          break;
     case ISUID:
          if ((enduid=strchr(parm,UIDDLM)) != NULL) {
               stlcpy(uid,parm,(int)(enduid-parm)+1);
               if (onsysn(uid,TRUE)) {
                    dpkusn=othusn;
                    dpkusp=othusp;
                    dpkuap=othuap;
                    dpkext=extoff(dpkusn);
                    return(TRUE);
               }
          }
          break;
     case ISUNUM:
          sscanf(parm,"%d",&unum);
          if (unum >=0 && unum < nterms) {
               dpkusn=unum;
               dpkusp=&user[unum];
               dpkuap=uacoff(unum);
               dpkext=extoff(dpkusn);
               return(TRUE);
          }
          break;
     case ISFLD:      /* can only happen if 1st parm is a field */
          break;
     }
     return(FALSE);
}

static int
prmtyp(                            /* det. type of parm in dpk suffix      */
char *parm)                        /*   parm to check                      */
{
     if (*parm == '\0') {
          return(ISNULL);
     }
     if (sameto("c=",parm)) {
          return(ISCNUM);
     }
     if (sameto("u=",parm)) {
          return(ISUID);
     }
     if (sameto("n=",parm)) {
          return(ISUNUM);
     }
     return(ISFLD);
}

static void
dpkra_chaninfo(                    /* read all "chaninfo" into structure   */
struct chninfvb *chninfvb)         /*   where to put the information       */
{
     c2bcpy(chninfvb->userid,fldr_useridc(),UIDSIZ-1);
     chninfvb->channel=cdr(fldr_channel(),int);
     chninfvb->chantype=cdr(fldr_chantype(),int);
     c2bcpy(chninfvb->gcditype,fldr_gcditype(),MXGCDI);
     chninfvb->usernumber=cdr(fldr_usernumber(),int);
     chninfvb->baud=cdr(fldr_baud(),long);
     chninfvb->mode=cdr(fldr_mode(),int);
}

static void *
fldr_useridc(void)                 /* chaninfo "userid" fld read rtn       */
{
     switch(dpkusp->class) {
     case VACANT:
          return("");
     case ONLINE:
          return("<logging on>");
     case SUPIPG:
          return("<sign up>");
     default:
          return(dpkuap->userid);
     }
}

static void *
fldr_channel(void)                 /* chaninfo "channel" fld read rtn      */
{
     return(&channel[dpkusn]);
}

static void *
fldr_chantype(void)                /* chaninfo "chantype" fld read rtn     */
{
     dpkrvint=grtype[grpnum[dpkusn]];
     return(&dpkrvint);
}

static void *
fldr_gcditype(void)                /* chaninfo "gcditype" fld read rtn     */
{
     return(dpkusp->flags&ISGCDI ? grtsub[grpnum[dpkusn]] : "");
}

static void *
fldr_usernumber(void)              /* chaninfo "usernumber" fld read rtn   */
{
     return(&dpkusn);
}

static void *
fldr_baud(void)                    /* chaninfo "baud" fld read rtn         */
{
     dpkrvlng=(grtype[grpnum[dpkusn]] <= GTSERIAL ? (long)dpkusp->baud
                                                  : nilrvlng);
     return(&dpkrvlng);
}

static void *
fldr_mode(void)                    /* chaninfo "mode" fld read rtn         */
{
     if (dpkusp->class == VACANT) {
          dpkrvint=nilrvint;
     }
     else {
          dpkrvint=(dpkusp->flags&ISGCSU ? -1 : dpkext->lingo);
     }
     return(&dpkrvint);
}

static void
dpkr_classinfo(                    /* "classinfo" std dpk read rtn         */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     char *clsnam,*fldnam,suffix[SFXSIZ];
     int i;
     static struct clsinfvb clsinfvb;

     if (haskey(syskey) || ACCESS(OPACCT)) {
          stlcpy(suffix,dpknam->suffix,SFXSIZ);
          clsnam=skpwht(skpwrd(suffix));
          fldnam=skpwht(skpwrd(clsnam));
          *(skpwrd(clsnam))='\0';
          if ((clsptr=fndcls(clsnam)) != NULL) {
               if (*fldnam == '\0') {
                    dpkra_classinfo(&clsinfvb);
                    rsp2read(dpknam,sizeof(struct clsinfvb),&clsinfvb);
                    return;
               }
               for (i=0 ; i < nelems(clsflds) ; i++) {
                    if (sameas(clsflds[i].fldnam,fldnam)) {
                         if (clsflds[i].fldrrou != NULL) {
                              rsp2read(dpknam,clsflds[i].retlen,
                                       (*clsflds[i].fldrrou)());
                              return;
                         }
                         break;
                    }
               }
          }
     }
     rejectreq();
}

static void
dpkw_classkill(                    /* "classkill" std dpk write rtn        */
struct saunam *dpknam,             /*   dynapak to write                   */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value                      */
{
     char *clsnam,suffix[SFXSIZ];

     (void)length;
     (void)value;
     if (haskey(syskey) || ACCESS(OPACCT)) {
          clrprf();
          stlcpy(suffix,dpknam->suffix,SFXSIZ);
          clsnam=skpwht(skpwrd(suffix));
          *(skpwrd(clsnam))='\0';
          if ((clsptr=fndcls(clsnam)) != NULL) {
               dltcls(clsptr);
               r2wprf(TRUE);
               return;
          }
          else {
               prf("NOTFND");
               r2wprf(FALSE);
               return;
          }
     }
     rejectreq();
}

static void
dpkw_classinfo(                    /* "classinfo" std dpk write rtn        */
struct saunam *dpknam,             /*   dynapak to write                   */
unsigned length,                   /*   length of dynapak information      */
void *value)                       /*   dynapak value (VB structure)       */
{
     BOOL vldreq;
     struct acclass clsnfo;
     struct clstab *clptr;
     char *clsnam,*fldnam,suffix[SFXSIZ],id[UIDSIZ];
     int i;

     if (haskey(syskey) || ACCESS(OPACCT)) {
          clrprf();
          stlcpy(suffix,dpknam->suffix,SFXSIZ);
          clsnam=skpwht(skpwrd(suffix));
          fldnam=skpwht(skpwrd(clsnam));
          *(skpwrd(clsnam))='\0';
          setmem(&clsnfo,sizeof(struct clstab),0);
          setbtv(clsbb);
          if ((clptr=fndcls(clsnam)) != NULL) {
               geqbtv(&clsnfo,clsnam,0);
          }
          else {
               stlcpy(clsnfo.clname,strupr(clsnam),KEYSIZ);
          }
          if (*fldnam == '\0') {
               if (length == sizeof(struct clsinfvb)) {
                    vldreq=dpkwa_classinfo((struct clsinfvb *)value,&clsnfo);
               }
          }
          else {
               vldreq=FALSE;
               for (i=0 ; i < nelems(clsflds) ; i++) {
                    if (sameas(clsflds[i].fldnam,fldnam)) {
                         if (uinflds[i].fldwrou != NULL) {
                              vldreq=(*clsflds[i].fldwrou)(value,&clsnfo);
                         }
                         break;
                    }
               }
          }
          if (vldreq == TRUE) {
               if (clptr != NULL) {
                    movmem(&clsnfo,clptr,
                           sizeof(struct clstab)-sizeof(struct clstab *));
                    updbtv(&clsnfo);
               }
               else {
                    rstbtv();
                    if (crtclass(&clsnfo)) {
                         id[0]=RINGID;
                         stlcpy(id+1,clsnfo.clname,KEYSIZ);
                         nkyrec(id);
                         r2wprf(TRUE);
                         return;
                    }
                    else {
                         prf("NOMEM");
                         r2wprf(FALSE);
                         return;
                    }
               }
          }
          else {
               rstbtv();
               prf("NOTVLD");
               r2wprf(FALSE);
               return;
          }
     }
     rstbtv();
     rejectreq();
}

static BOOL
dpkwa_classinfo(                   /* write all "classinfo" to memory/file */
struct clsinfvb *clsinfvb,         /*   where to get the information       */
struct acclass *clsdat)            /*   where to put the information       */
{
     return(fldw_nextclass(clsinfvb->nextclass,clsdat)
         && fldw_limpercall(&clsinfvb->limpercall,clsdat)
         && fldw_limperday(&clsinfvb->limperday,clsdat)
         && fldw_defdayexp(&clsinfvb->defdayexp,clsdat)
         && fldw_debtlimtc(&clsinfvb->debtlimit,clsdat)
         && fldw_forgivdays(&clsinfvb->forgivdays,clsdat)
         && fldw_idledays(&clsinfvb->idledays,clsdat)
         && fldw_flags(&clsinfvb->flags,clsdat)
         && fldw_seconds(&clsinfvb->seconds,clsdat)
         && fldw_usersin(&clsinfvb->usersin,clsdat));
}

static BOOL
fldw_nextclass(                    /* classinfo "nextclass" write routine  */
char *clsstg,
struct acclass *clsdat)
{
     int i,cnt;
     char *wrkstr,*sptr;

     wrkstr=strupr(b2ccvt(clsstg,NCLSSZ));
     cnt=itemcntd(wrkstr,";");
     for (i=0 ; i < cnt ; i++) {
          sptr=itemidxd(wrkstr,i,";");
          switch(*sptr) {
          case 'O':
               stlcpy(clsdat->nxtcls[DOUTTIM],sptr+2,KEYSIZ);
               break;
          case 'L':
               stlcpy(clsdat->nxtcls[DLOAFER],sptr+2,KEYSIZ);
               break;
          case 'E':
               stlcpy(clsdat->nxtcls[DEXPIRE],sptr+2,KEYSIZ);
               break;
          case 'C':
               stlcpy(clsdat->nxtcls[DCREDIT],sptr+2,KEYSIZ);
               break;
          default:
               break;
          }
     }
     return(TRUE);
}

static BOOL
fldw_limpercall(                   /* classinfo "limpercall" write routine */
int *newlim,
struct acclass *clsdat)
{
     if ((*newlim >= -1 && *newlim <= 1440) || (*newlim == -1)) {
          clsdat->limcal=*newlim;
          return(TRUE);
     }
     return(FALSE);
}

static BOOL
fldw_limperday(                    /* classinfo "limperday" write routine  */
int *newlim,
struct acclass *clsdat)
{
     if ((*newlim >= -1 && *newlim <= 1440)) {
          clsdat->limday=*newlim;
          return(TRUE);
     }
     return(FALSE);
}


static BOOL
fldw_defdayexp(                    /* classinfo "defdayexp" write routine  */
int *newexp,
struct acclass *clsdat)
{
     if (*newexp >= -1) {
          clsdat->dftday=*newexp;
          return(TRUE);
     }
     return(FALSE);
}

static BOOL
fldw_debtlimtc(                    /* classinfo "debtlimtc" write routine  */
long *newlim,
struct acclass *clsdat)
{
     if ((*newlim >= -1 && *newlim <= 9999999L)) {
          clsdat->dbtlmt=*newlim;
          return(TRUE);
     }
     return(FALSE);
}

static BOOL                        /* classinfo "forgivdays" write routine */
fldw_forgivdays(
int *newday,
struct acclass *clsdat)
{
     if (*newday >= -1) {
          clsdat->fgvday=*newday;
          return(TRUE);
     }
     return(FALSE);
}

static BOOL                        /* classinfo "idledays" write routine   */
fldw_idledays(
int *newday,
struct acclass *clsdat)
{
     if (*newday >= -1) {
          clsdat->idlday=*newday;
          return(TRUE);
     }
     return(FALSE);
}

static BOOL
fldw_flags(                        /* classinfo "flags" write routine      */
int *newflg,
struct acclass *clsdat)
{
     clsdat->flags=*newflg;
     return(TRUE);
}

static BOOL
fldw_seconds(                      /* classinfo "seconds" write routine    */
long *newsec,
struct acclass *clsdat)
{
     clsdat->seconds=*newsec;
     return(TRUE);
}

static BOOL
fldw_usersin(                      /* classinfo "usersin" write routine    */
long *newusr,
struct acclass *clsdat)
{
     clsdat->users=(unsigned)*newusr;
     return(TRUE);
}

static void
dpkra_classinfo(                   /* read all "classinfo" into structure  */
struct clsinfvb *clsinfvb)         /*   where to put the information       */
{
     c2bcpy(clsinfvb->nextclass,fldr_nextclass(),NCLSSZ);
     clsinfvb->limpercall=cdr(fldr_limpercall(),int);
     clsinfvb->limperday=cdr(fldr_limperday(),int);
     clsinfvb->defdayexp=cdr(fldr_defdayexp(),int);
     clsinfvb->debtlimit=cdr(fldr_debtlimtc(),long);
     clsinfvb->forgivdays=cdr(fldr_forgivdays(),int);
     clsinfvb->idledays=cdr(fldr_idledays(),int);
     clsinfvb->flags=cdr(fldr_flags(),int);
     clsinfvb->seconds=cdr(fldr_seconds(),long);
     clsinfvb->usersin=cdr(fldr_usersin(),long);
}

static void *
fldr_nextclass(void)               /* classinfo "nextclass" fld read rtn   */
{
     static char clsstg[NCLSSZ+1];

     setmem(clsstg,NCLSSZ+1,0);
     sprintf(clsstg,"O:%s;L:%s;E:%s;C:%s",
             clsptr->nxtcls[DOUTTIM],clsptr->nxtcls[DLOAFER],
             clsptr->nxtcls[DEXPIRE],clsptr->nxtcls[DCREDIT]);
     return(clsstg);
}

static void *
fldr_limpercall(void)              /* classinfo "limpercall" fld read rtn  */
{
     return(&clsptr->limcal);
}

static void *
fldr_limperday(void)               /* classinfo "limperday" fld read rtn   */
{
     return(&clsptr->limday);
}

static void *
fldr_defdayexp(void)               /* classinfo "defdayexp" fld read rtn   */
{
     return(&clsptr->dftday);
}

static void *
fldr_debtlimtc(void)               /* classinfo "debtlimit" fld read rtn   */
{
     return(&clsptr->dbtlmt);
}

static void *
fldr_forgivdays(void)              /* classinfo "forgivdays" fld read rtn  */
{
     return(&clsptr->fgvday);
}

static void *
fldr_idledays(void)                /* classinfo "idledays" fld read rtn    */
{
     return(&clsptr->idlday);
}

static void *
fldr_flags(void)                   /* classinfo "flags" fld read rtn       */
{
     return(&clsptr->flags);
}

static void *
fldr_seconds(void)                 /* classinfo "seconds" fld read rtn     */
{
     return(&clsptr->seconds);
}

static void *
fldr_usersin(void)                 /* classinfo "usersin" fld read rtn     */
{
     dpkrvlng=(long)clsptr->users;
     return(&dpkrvlng);
}

static void
dpkr_classkeys(                    /* "classkeys" std dpk read rtn         */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     if (haskey(syskey) || ACCESS(OPACCT) || ACCESS(OPDETL)) {
          gtkrng(skpwht(skpwrd(dpknam->suffix)),TRUE,dpknam);
          return;
     }
     rejectreq();
}

static void
dpkw_classkeys(                    /* "classkeys" std dpk write rtn        */
struct saunam *dpknam,             /*   dynapak to read                    */
unsigned length,                   /*   length of keyring list             */
void *value)                       /*   lists of all the keys              */
{
     if (haskey(syskey) || ACCESS(OPACCT)) {
          if (length < RINGSZ+32) {
               ptkrng(skpwht(skpwrd(dpknam->suffix)),(char *)value,TRUE);
               return;
          }
          else {
               prf("TOOLNG");
               r2wprf(FALSE);
               return;
          }
     }
     rejectreq();
}

static void
dpkr_classmsgs(                    /* "classmsgs" std dpk read rtn         */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     struct acclass clsrec;
     char id[KEYSIZ],*clsnam;

     if (haskey(syskey) || ACCESS(OPACCT)) {
          clsnam=skpwht(skpwrd(dpknam->suffix));
          stlcpy(id,clsnam,KEYSIZ);
          setbtv(clsbb);
          setmem(&clsrec,sizeof(struct acclass),0);
          if (acqbtv(&clsrec,id,0)) {
               cpyrsp(clsrec.msgs[0]);
               delimiter();
               catrsp(clsrec.msgs[1]);
               rsp2read(dpknam,STGLEN,rsptmp);
               rstbtv();
               return;
          }
     }
     rstbtv();
     rejectreq();
}

static void
dpkw_classmsgs(                    /* "classmsgs" std write dpk routine    */
struct saunam *dpknam,             /*   dynapak name                       */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value                      */
{
     struct acclass clsrec;
     char *clsnam,*fstmsg,*secmsg,id[KEYSIZ];

     (void)length;
     if (haskey(syskey) || ACCESS(OPACCT)) {
          clrprf();
          fstmsg=(char *)value;
          clsnam=skpwht(skpwrd(dpknam->suffix));
          stlcpy(id,clsnam,KEYSIZ);
          setbtv(clsbb);
          setmem(&clsrec,sizeof(struct acclass),0);
          if (acqbtv(&clsrec,id,0)) {
               if ((secmsg=strchr((const char *)fstmsg,9)) != NULL) {
                    *secmsg++='\0';
                    stlcpy(clsrec.msgs[0],fstmsg,XMSGSZ);
                    stlcpy(clsrec.msgs[1],secmsg,XMSGSZ);
               }
               updbtv(&clsrec);
               r2wprf(TRUE);
               rstbtv();
               return;
          }
          else {
               rstbtv();
               prf("NOTFND");
               r2wprf(FALSE);
               return;
          }
     }
     rstbtv();
     rejectreq();
}

static void
dpkr_classlist(                    /* "classlist" std dpk read rtn         */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     struct clstab *clmptr;

     if (haskey(syskey) || ACCESS(OPACCT) || ACCESS(OPDETL)) {
          *rsptmp='\0';
          clmptr=clshead;
          while (clmptr != NULL) {
               if (!(clmptr->flags&HASCRD && clmptr->flags&NOCRED)) {
                    if (*rsptmp != '\0') {
                         delimiter();
                    }
                    catrsp(clmptr->clname);
               }
               clmptr=clmptr->next;
          }
          rsp2read(dpknam,STGLEN,rsptmp);
          return;
     }
     rejectreq();
}

static void
dpkr_langlist(                     /* "langlist" std dpk read rtn          */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     int i;

     rsptmp[0]='\0';
     for (i=0 ; i < nlingo ; i++) {
          strcat(rsptmp,spr("%-15s %-50s%c",languages[i]->name,
                            languages[i]->desc,LNGSEP));
     }
     strcat(rsptmp,spr("n=%d",nlingo));
     rsp2read(dpknam,(LNGSIZ+LNGDSC)*nlingo+LSFXSZ,rsptmp);
}

static void
dpkr_rsptime(                      /* "rsptime" std dpk read rtn           */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     if (haskey(syskey)) {
          rsp2read(dpknam,LNGLEN,&rsptim);
          return;
     }
     rejectreq();
}

static void
dpkr_sysinfo(                      /* "sysinfo" std dpk read rtn           */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     char *fldnam;
     int i;
     static struct sysinfvb sysinfvb;

     fldnam=skpwht(skpwrd(dpknam->suffix));
     if (*fldnam == '\0') {
          dpkra_sysinfo(&sysinfvb);
          rsp2read(dpknam,sizeof(struct sysinfvb),&sysinfvb);
          return;
     }
     for (i=0 ; i < nelems(sinflds) ; i++) {
          if (sameas(sinflds[i].fldnam,fldnam)) {
               if (sinflds[i].fldrrou != NULL) {
                    rsp2read(dpknam,sinflds[i].retlen,(*sinflds[i].fldrrou)());
                    return;
               }
               break;
          }
     }
     rejectreq();
}

static void
dpkra_sysinfo(                     /* read all "sysinfo" into structure    */
struct sysinfvb *sysinfvb)         /*   where to put the information       */
{
     c2bcpy(sysinfvb->sysname,fldr_sysname(),TTLSIZ);
     c2bcpy(sysinfvb->syscompany,fldr_syscompany(),CMPSIZ);
     c2bcpy(sysinfvb->sysaddr1,fldr_sysaddr1(),ADDRSZ);
     c2bcpy(sysinfvb->sysaddr2,fldr_sysaddr2(),ADDRSZ);
     c2bcpy(sysinfvb->sysphone,fldr_sysphone(),DTPHSZ);
     c2bcpy(sysinfvb->restpho,fldr_restpho(),LVPHSZ);
     c2bcpy(sysinfvb->chgperhr,fldr_chgperhr(),CGHRSZ);
     c2bcpy(sysinfvb->mincharge,fldr_mincharge(),CGMNSZ);
     c2bcpy(sysinfvb->regnumber,fldr_regnumber(),RNOSIZ);
}

static void *
fldr_sysname(void)                 /* sysinfo "sysname" fld read rtn       */
{
     return(bbsttl);
}

static void *
fldr_syscompany(void)              /* sysinfo "syscompany" fld read rtn    */
{
     return(company);
}

static void *
fldr_sysaddr1(void)                /* sysinfo "sysaddr1" fld read rtn      */
{
     return(addres1);
}

static void *
fldr_sysaddr2(void)                /* sysinfo "sysaddr2" fld read rtn      */
{
     return(addres2);
}

static void *
fldr_sysphone(void)                /* sysinfo "sysphone" fld read rtn      */
{
     return(dataph);
}

static void *
fldr_restpho(void)                 /* sysinfo "restpho" fld read rtn       */
{
     return(liveph);
}

static void *
fldr_chgperhr(void)                /* sysinfo "chgperhr" fld read rtn      */
{
     return(chghour);
}

static void *
fldr_mincharge(void)               /* sysinfo "mincharge" fld read rtn     */
{
     return(chgmin);
}

static void *
fldr_regnumber(void)               /* sysinfo "regnumber" fld read rtn     */
{
     return(bturno);
}

static void
dpkr_sysloading(                   /* "sysloading" std dpk read rtn        */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     if (haskey(syskey)) {
          rsp2read(dpknam,INTLEN,&syslod);
          return;
     }
     rejectreq();
}

static void
dpkr_syspolrate(                   /* "syspolrate" std dpk read rtn        */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     if (haskey(syskey)) {
          rsp2read(dpknam,INTLEN,&maxpol);
          return;
     }
     rejectreq();
}

static void
dpkr_sysstat(                      /* "sysstat" std dpk read rtn           */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     char *fldnam;
     int i;
     static struct stainfvb stainfvb;

     if (haskey(stakey) || ACCESS(OPSYSS)) {
          fldnam=skpwht(skpwrd(dpknam->suffix));
          if (*fldnam == '\0') {
               dpkra_sysstat(&stainfvb);
               rsp2read(dpknam,sizeof(struct stainfvb),&stainfvb);
               return;
          }
          for (i=0 ; i < nelems(staflds) ; i++) {
               if (sameas(staflds[i].fldnam,fldnam)) {
                    if (staflds[i].fldrrou != NULL) {
                         rsp2read(dpknam,staflds[i].retlen,
                                  (*staflds[i].fldrrou)());
                         return;
                    }
                    break;
               }
          }
     }
     rejectreq();
}

static void
dpkra_sysstat(                     /* read all "sysstat" into structure    */
struct stainfvb *stainfvb)         /*   where to put the information       */
{
     stainfvb->numlines=cdr(fldr_numlines(),int);
     stainfvb->othonline=cdr(fldr_othonline(),int);
     stainfvb->totalcalls=cdr(fldr_totalcalls(),long);
     stainfvb->downloads=cdr(fldr_downloads(),long);
     stainfvb->uploads=cdr(fldr_uploads(),long);
     stainfvb->totalmsgs=cdr(fldr_totalmsgs(),long);
     stainfvb->totalaccts=cdr(fldr_totalaccts(),long);
     stainfvb->totalmale=cdr(fldr_totalmale(),long);
     stainfvb->totalfemale=cdr(fldr_totalfemale(),long);
     stainfvb->totalcorp=cdr(fldr_totalcorp(),long);
     stainfvb->totalansi=cdr(fldr_totalansi(),long);
}

static void *
fldr_numlines(void)                /* sysstat "numlines" fld read rtn      */
{
     return(&nterms);
}

static void *
fldr_othonline(void)               /* sysstat "othonline" fld read rtn     */
{
     int othusn;
     struct user *othusp;
     BOOL iginv;

     dpkrvint=0;
     iginv=haskey(syskey);
     for (othusn=0,othusp=user ; othusn < nterms ; othusn++,othusp++) {
          if (incusr(othusn,FALSE,iginv) > VACANT) {
               dpkrvint++;
          }
     }
     return(&dpkrvint);
}

static void *
fldr_totalcalls(void)              /* sysstat "totalcalls" fld read rtn    */
{
     return(&sv2.totcalls);
}

static void *
fldr_downloads(void)               /* sysstat "downloads" fld read rtn     */
{
     return(&sv.dwnlds);
}

static void *
fldr_uploads(void)                 /* sysstat "uploads" fld read rtn       */
{
     return(&sv.uplds);
}

static void *
fldr_totalmsgs(void)               /* sysstat "totalmsgs" fld read rtn     */
{
     return(&sv.msgtot);
}

static void *
fldr_totalaccts(void)              /* sysstat "totalaccts" fld read rtn    */
{
     dpkrvlng=(long)sv2.numact;
     return(&dpkrvlng);
}

static void *
fldr_totalmale(void)               /* sysstat "totalmale" fld read rtn     */
{
     dpkrvlng=(long)(sv2.numact-sv2.numfem);
     return(&dpkrvlng);
}

static void *
fldr_totalfemale(void)             /* sysstat "totalfemale" fld read rtn   */
{
     dpkrvlng=(long)sv2.numfem;
     return(&dpkrvlng);
}

static void *
fldr_totalcorp(void)               /* sysstat "totalcorp" fld read rtn     */
{
     dpkrvlng=(long)sv2.numcor;
     return(&dpkrvlng);
}

static void *
fldr_totalansi(void)               /* sysstat "totalansi" fld read rtn     */
{
     dpkrvlng=(long)sv2.numans;
     return(&dpkrvlng);
}

static void
dpkr_useridinfo(                   /* "useridinfo" std dpk read rtn        */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     char *namdef[]={"REAL","DEFAULT","ASK"};
     char retstg[UIDISZ];

     setmem(retstg,UIDISZ,0);
     sprintf(retstg,"%d %c %c %s",sgnusz,digalw ? 'Y' : 'N',
                                  fulalw ? 'Y' : 'N',namdef[namdft-1]);
     rsp2read(dpknam,STGLEN,retstg);
}

static void
dpkr_userinfo(                     /* "userinfo" std dpk read rtn          */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     char *fldnam;
     int i;
     static struct usrinfvb usrinfvb;
     BOOL vldreq;

     vldreq=vlduid(dpknam->usrid,glbkey);
     if (!vldreq && invldres == CANTALTR) {
          vldreq=ACCESS(OPDETL) || ACCESS(OPACCT);
     }
     if (vldreq) {
          fldnam=skpwht(skpwrd(dpknam->suffix));
          if (*fldnam == '\0') {
               dpkra_userinfo(&usrinfvb);
               rsp2read(dpknam,sizeof(struct usrinfvb),&usrinfvb);
               return;
          }
          for (i=0 ; i < nelems(uinflds) ; i++) {
               if (sameas(uinflds[i].fldnam,fldnam)) {
                    if (uinflds[i].fldrrou != NULL) {
                         rsp2read(dpknam,uinflds[i].retlen,
                                  (*uinflds[i].fldrrou)());
                         return;
                    }
                    break;
               }
          }
     }
     else if (accrec.userid[0] != '\0') {
          rsp2read(dpknam,STGLEN,accrec.userid);
          return;
     }
     rejectreq();
}

static void
dpkra_userinfo(                    /* read all "userinfo" into structure   */
struct usrinfvb *usrinfvb)         /*   where to put the information       */
{
     int i,*iptr;

     c2bcpy(usrinfvb->userid,fldr_userid(),UIDSIZ-1);
     c2bcpy(usrinfvb->password,fldr_password(),PSWSIZ-1);
     c2bcpy(usrinfvb->name,fldr_name(),NADSIZ-1);
     c2bcpy(usrinfvb->company,fldr_company(),NADSIZ-1);
     c2bcpy(usrinfvb->address1,fldr_address1(),NADSIZ-1);
     c2bcpy(usrinfvb->address2,fldr_address2(),NADSIZ-1);
     c2bcpy(usrinfvb->address3,fldr_address3(),NADSIZ-1);
     c2bcpy(usrinfvb->phone,fldr_phone(),PHOSIZ-1);
     usrinfvb->systemtype=cdr(fldr_systemtype(),int);
     usrinfvb->ansi=cdr(fldr_ansi(),int);
     usrinfvb->scnwidth=cdr(fldr_scnwidth(),int);
     usrinfvb->scnlength=cdr(fldr_scnlength(),int);
     usrinfvb->fsescnlen=cdr(fldr_fsescnlen(),int);
     usrinfvb->editorprf=cdr(fldr_editorprf(),char);
     usrinfvb->age=cdr(fldr_age(),int);
     usrinfvb->birthdate=cdr(fldr_birthdate(),double);
     usrinfvb->sex=cdr(fldr_sex(),char);
     usrinfvb->createdate=cdr(fldr_createdate(),double);
     usrinfvb->laston=cdr(fldr_laston(),double);
     c2bcpy(usrinfvb->class,fldr_class(),KEYSIZ-1);
     c2bcpy(usrinfvb->retclass,fldr_retclass(),KEYSIZ-1);
     usrinfvb->creditrate=cdr(fldr_creditrate(),int);
     usrinfvb->credits=cdr(fldr_credits(),long);
     usrinfvb->credever=cdr(fldr_credever(),long);
     usrinfvb->paidever=cdr(fldr_paidever(),long);
     usrinfvb->timeonline=cdr(fldr_timeonline(),int);
     usrinfvb->calltimlim=cdr(fldr_calltimlim(),int);
     usrinfvb->daytimlim=cdr(fldr_daytimlim(),int);
     usrinfvb->timetoday=cdr(fldr_timetoday(),long);
     usrinfvb->daysleft=cdr(fldr_daysleft(),int);
     usrinfvb->debtlimit=cdr(fldr_debtlimit(),long);
     usrinfvb->exempt=cdr(fldr_exempt(),char);
     usrinfvb->language=cdr(fldr_language(),int);
     usrinfvb->permlang=cdr(fldr_permlang(),int);
     usrinfvb->acctflags=cdr(fldr_acctflags(),int);
     iptr=cvp(fldr_access(),int);
     for (i=0 ; i < AXSSIZ ; i++) {
          usrinfvb->access[i]=*iptr++;
     }
}

static void *
fldr_secondstt(void)
{
     dpkrvlng=(dpkuap->timtdy);
     return(&dpkrvlng);
}

static void *
fldr_userid(void)                  /* userinfo "userid" fld read rtn       */
{
     return(dpkuap->userid);
}

static void *
fldr_password(void)                /* userinfo "password" fld read rtn     */
{
     return(uidsame || vispsw ? dpkuap->psword : "");
}

static void *
fldr_name(void)                    /* userinfo "name" fld read rtn         */
{
     return(dpkuap->usrnam);
}

static void *
fldr_company(void)                 /* userinfo "company" fld read rtn      */
{
     return(dpkuap->usrad1);
}

static void *
fldr_address1(void)                /* userinfo "address1" fld read rtn     */
{
     return(dpkuap->usrad2);
}

static void *
fldr_address2(void)                /* userinfo "address2" fld read rtn     */
{
     return(dpkuap->usrad3);
}

static void *
fldr_address3(void)                /* userinfo "address3" fld read rtn     */
{
     return(dpkuap->usrad4);
}

static void *
fldr_phone(void)                   /* userinfo "phone" fld read rtn        */
{
     return(dpkuap->usrpho);
}

static void *
fldr_systemtype(void)              /* userinfo "systemtype" fld read rtn   */
{
     dpkrvint=dpkuap->systyp;
     return(&dpkrvint);
}

static void *
fldr_ansi(void)                    /* userinfo "ansi" fld read rtn         */
{
     dpkrvint=dpkuap->ansifl;
     return(&dpkrvint);
}

static void *
fldr_scnwidth(void)                /* userinfo "scnwidth" fld read rtn     */
{
     dpkrvint=dpkuap->scnwid;
     return(&dpkrvint);
}

static void *
fldr_scnlength(void)               /* userinfo "scnlength" fld read rtn    */
{
     dpkrvint=dpkuap->scnbrk;
     return(&dpkrvint);
}

static void *
fldr_fsescnlen(void)               /* userinfo "fsescnlen" fld read rtn    */
{
     dpkrvint=dpkuap->scnfse;
     return(&dpkrvint);
}

static void *
fldr_editorprf(void)               /* userinfo "editorprf" fld read rtn    */
{
     dpkrvchr=dpkuap->usrprf&PRFLIN ? 'L' : 'F';
     return(&dpkrvchr);
}

static void *
fldr_age(void)                     /* userinfo "age" fld read rtn          */
{
     dpkrvint=dpkuap->age > 0 ? (int)dpkuap->age : nilrvint;
     return(&dpkrvint);
}

static void *
fldr_birthdate(void)
{
     dpkrvdbl=s2vdat(dpkuap->birthd,"");
     return(&dpkrvdbl);
}

static void *
fldr_sex(void)                     /* userinfo "sex" fld read rtn          */
{
     dpkrvchr=(dpkuap->sex == 'M' || dpkuap->sex == 'F' ? dpkuap->sex : 'U');
     return(&dpkrvchr);
}

static void *
fldr_createdate(void)              /* userinfo "createdate" fld read rtn   */
{
     dpkrvdbl=d2vdat(dpkuap->credat,0.0);
     return(&dpkrvdbl);
}

static void *
fldr_laston(void)                  /* userinfo "laston" fld read rtn       */
{
     if (dpkuap->usedat == 0) {
          dpkrvdbl=0.0;
     }
     else {
          dpkrvdbl=d2vdat(dpkuap->usedat,0.0);
     }
     return(&dpkrvdbl);
}

static void *
fldr_class(void)                   /* userinfo "class" fld read rtn        */
{
     return(dpkuap->curcls);
}

static void *
fldr_retclass(void)                /* userinfo "retclass" fld read rtn     */
{
     return(dpkuap->prmcls);
}

static void *
fldr_creditrate(void)              /* userinfo "creditrate" fld read rtn   */
{
     return(usron ? &dpkusp->crdrat : &nilrvint);
}

static void *
fldr_credits(void)                 /* userinfo "credits" fld read rtn      */
{
     return(&dpkuap->creds);
}

static void *
fldr_credever(void)                /* userinfo "credever" fld read rtn     */
{
     return(&dpkuap->totcreds);
}

static void *
fldr_paidever(void)                /* userinfo "paidever" fld read rtn     */
{
     return(&dpkuap->totpaid);
}

static void *
fldr_timeonline(void)              /* userinfo "timeonline" fld read rtn   */
{
     dpkrvint=usron ? (dpkusp->minut4+2)/4 : nilrvint;
     return(&dpkrvint);
}

static void *
fldr_calltimlim(void)              /* userinfo "calltimlim" fld read rtn   */
{
     return((clsptr=getctp()) != NULL ? &clsptr->limcal : &nilrvint);
}

static void *
fldr_daytimlim(void)               /* userinfo "daytimlim" fld read rtn    */
{
     return((clsptr=getctp()) != NULL ? &clsptr->limday : &nilrvint);
}

static void *
fldr_timetoday(void)               /* userinfo "timetoday" fld read rtn    */
{
     dpkrvlng=(dpkuap->timtdy+30L)/60L;
     return(&dpkrvlng);
}

static void *
fldr_daysleft(void)                /* userinfo "daysleft" fld read rtn     */
{
     if ((clsptr=getctp()) == NULL) {
          return(&nilrvlng);
     }
     dpkrvlng=clsptr->flags&DAYEXP ? (long)dpkuap->daystt : -1L;
     return(&dpkrvlng);
}

static void *
fldr_debtlimit(void)               /* userinfo "debtlimit" fld read rtn    */
{
     return((clsptr=getctp()) != NULL ? &clsptr->dbtlmt : &nilrvlng);
}

static void *
fldr_exempt(void)                  /* userinfo "exempt" fld read rtn       */
{
     if ((clsptr=getctp()) == NULL) {
          return(&nilrvchr);
     }
     dpkrvchr=clsptr->flags&CRDXMT ? 'Y' : 'N';
     return(&dpkrvchr);
}

static void *
fldr_language(void)                /* userinfo "language" fld read rtn     */
{
     return(rdlng(TRUE));
}

static void *
fldr_permlang(void)                /* userinfo "permlang" fld read rtn     */
{
     return(rdlng(FALSE));
}

static void *                      /* userinfo "acctflags" fld read rtn    */
fldr_acctflags(void)
{
     return(&dpkuap->flags);
}

static void *
fldr_access(void)                  /* userinfo "remote access" fld read rtn*/
{
     return(dpkuap->access);
}

static struct clstab *
getctp(void)                       /* get req'd uid's class table pointer  */
{
     return(usron ? dpkusp->cltptr : fndcls(dpkuap->curcls));
}

static void
dpkr_usrclskeys(                   /* "usrclskeys" std dpk read rtn        */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     if (vlduid(dpknam->usrid,syskey)) {
          gtkrng((uidsame ? dpkusp->cltptr->clname : dpkuap->curcls),
                 TRUE,dpknam);
          return;
     }
     rejectreq();
}

static void
dpkr_usrpslkeys(                   /* "usrpslkeys" std dpk read rtn        */
struct saunam *dpknam)             /*   dynapak to read                    */
{
     BOOL vldreq;

     vldreq=vlduid(dpknam->usrid,glbkey);
     if (!vldreq && invldres == CANTALTR) {
          vldreq=ACCESS(OPACCT);
     }
     if (vldreq) {
          gtkrng(dpknam->usrid,FALSE,dpknam);
          return;
     }
     rejectreq();
}

static void
dpkw_usrpslkeys(                   /* "usrpslkeys" std dpk write rtn       */
struct saunam *dpknam,             /*   dynapak to read                    */
unsigned length,                   /*   length of keyring list             */
void *value)                       /*   lists of all the keys              */
{
     if (haskey(syskey) || ACCESS(OPACCT)) {
          if (length < RINGSZ+32) {
               ptkrng(skpwht(skpwrd(dpknam->suffix)),(char *)value,FALSE);
               return;
          }
          else {
               prf("TOOLNG");
               r2wprf(FALSE);
               return;
          }
     }
     rejectreq();
}

static void
syswrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     int ilingo,i;
     char *dpkstg;

     dpkstg=cnvs2d(dpknam);
     setmbk(gcsmb);
     if (sameas(dpkstg,":sysid")) {
          sprintf(rsptmp,"%s;%s",msysid,mmappid);
          rsp2write(sameas(value,msysid),STGLEN,rsptmp);
     }
     else if (!sameas(dpknam->sysid,msysid)) {
          rejectreq();
     }
     else if (samepat(dpkstg,"su:logon")) {
          if (usaptr->userid[0] == '\0'
            && sameas(dpknam->usrid,usdptr->usrid)) {
               if (!loadacc(dpknam->usrid)) {
                    prfmsg(UIDNOG1);
               }
               else if (!csdftpsw(value)) {
                    if (++(usrptr->countr) < 3) {
                         prf("BADPASS");
                         r2wprf(FALSE);
                         setmem(usaptr,sizeof(struct usracc),0);
                    }
                    else {
                         prf("BYEPASS");
                         r2wprf(FALSE);
                         shochl("Invalid password attempt",'!',baudat(usrptr->baud,0));
                         byenow(NOMSG);
                         shocst("INVALID PASSWORD ATTEMPT",
                           "C/S attempt on \"%s\"",usaptr->userid);
                         setmem(usaptr,sizeof(struct usracc),0);
                    }
                    return;
               }
               else if (usaptr->flags&SUSPEN) {
                    prfmsg(ACCSUS);
               }
               else if (!(*hdlsmp)() && !haskey(sampky)
                                     && !(usaptr->flags&HASMST)) {
                    prfmsg(MEMONL);
               }
               else if (onbbs(dpknam->usrid,1)) {
                    prfmsg(ALRDON);
               }
               else {
                    switch (csbump(TRUE)) {
                    case BMPAOK:
                         usrflags();
                         if ((*vallon)()) {
                              if (nlingo > 1 && getgen(&genbuf,usaptr->userid)
                                && (ilingo=lngfnd(genbuf.lngnam)) != -1) {
                                   extptr->lingo=adjlgo(ilingo);
                              }
                              rsp2write(TRUE,0,NULL);
                              usrptr->class=ACTUSR;
                              gcsplon();
                              return;
                         }
                         break;         /* FALSE vallon(): reason in prfbuf*/
                    case BMPDEL:
                         prfmsg(UIDNOG1);
                         break;
                    case BMPLNV:
                    case BMPSNV:        /* should never happen at logon    */
                         prfmsg(IMMEDL);
                         break;
                    case BMPTIM:
                         prfmsg(NOTIME);
                         break;
                    }
               }
               r2wprf(FALSE);
               setmem(usaptr,sizeof(struct usracc),0);
          }
          byenow(NOMSG);
     }
     else if (!haskey("")) {
          rejectreq();
     }
     else if (samepat(dpkstg,"su:go ascii")) {
          stlcpy(mnuusr->curpag,value,PNMSIZ);
          dllock(usrnum);
          cycleme(wt4lok);
     }
     else {
          for (i=0 ; i < nelems(stdpks) ; i++) {
               if (samepato(stdpks[i].dpknam,dpkstg)) {
                    if (stdpks[i].dpkwrou != NULL) {
                         (*stdpks[i].dpkwrou)(dpknam,length,value);
                         return;
                    }
                    break;
               }
          }
          rejectreq();
     }
}

static void
dpkw_reqgenagt(                    /* "reqgenagt" std dpk write rtn        */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     (void)dpknam;
     if (length < AIDSIZ && newgenagt((char*)value)) {
          rsp2write(TRUE,0,NULL);
          return;
     }
     rejectreq();
}

static void
dpkw_userinfo(                     /* "userinfo" std dpk write rtn         */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *fldnam;
     int i;
     BOOL vldreq;

     vldreq=vlduid(dpknam->usrid,glbkey);
     if (!vldreq && invldres == CANTALTR) {
          vldreq=ACCESS(OPACCT);
     }
     if (vldreq) {
          fldnam=skpwht(skpwrd(dpknam->suffix));
          if (*fldnam == '\0') {
               if (length <= sizeof(struct usrinfvb)) {
                    vldreq=dpkwa_userinfo((struct usrinfvb *)value,&accrec);
               }
          }
          else {
               vldreq=FALSE;
               for (i=0 ; i < nelems(uinflds) ; i++) {
                    if (sameas(uinflds[i].fldnam,fldnam)) {
                         if (uinflds[i].fldwrou != NULL) {
                              vldreq=(*uinflds[i].fldwrou)(value,&accrec);
                         }
                         break;
                    }
               }
          }
     }
     if (vldreq) {
          if (usron) {
               stlcpy(dpkuap->psword,accrec.psword,PSWSIZ);
               stlcpy(dpkuap->usrnam,accrec.usrnam,NADSIZ);
               stlcpy(dpkuap->usrad1,accrec.usrad1,NADSIZ);
               stlcpy(dpkuap->usrad2,accrec.usrad2,NADSIZ);
               stlcpy(dpkuap->usrad3,accrec.usrad3,NADSIZ);
               stlcpy(dpkuap->usrad4,accrec.usrad4,NADSIZ);
               stlcpy(dpkuap->usrpho,accrec.usrpho,PHOSIZ);
               dpkuap->systyp=accrec.systyp;
               dpkuap->ansifl=accrec.ansifl;
               dpkuap->scnwid=accrec.scnwid;
               dpkuap->scnbrk=accrec.scnbrk;
               dpkuap->scnfse=accrec.scnfse;
               dpkuap->usrprf=accrec.usrprf;
               dpkuap->flags=accrec.flags;
               if ((usaptr->flags&HASMST) || ACCESS(OPSYSP)) {
                    for (i=0 ; i < AXSSIZ ; i++) {
                         dpkuap->access[i]=accrec.access[i];
                    }
               }
               stlcpy(dpkuap->birthd,accrec.birthd,DATSIZ);
               dpkuap->sex=accrec.sex;
          }
          else {
               updbtv(&accrec);
          }
          chglng(chglngt,nwlingot);
          chglng(chglngp,nwlingop);
          rsp2write(TRUE,0,NULL);
          return;
     }
     r2wprf(FALSE);
}

static void
chglng(                            /* change req'd userid's language pref  */
int lngact,                        /*   action to take to change language  */
int newlingo)                      /*   language number to change to       */
{
     switch (lngact) {
     case CHGNON:
          break;
     case CHGAUT:
          if (genbuf.lngnam[0] != '\0') {
               genbuf.lngnam[0]='\0';
               setgen(&genbuf);
          }
          break;
     case CHGONL:
          dpkext->lingo=adjlgo(newlingo);
          break;
     case CHGOND:
          strcpy(genbuf.lngnam,languages[newlingo]->name);
          setgen(&genbuf);
     }
}

static BOOL
dpkwa_userinfo(                    /* write all userinfo from structure    */
struct usrinfvb *usrinfvb,         /*   info from client to write          */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     return(fldw_password(usrinfvb->password,accrec)
         && fldw_name(usrinfvb->name,accrec)
         && fldw_company(usrinfvb->company,accrec)
         && fldw_address1(usrinfvb->address1,accrec)
         && fldw_address2(usrinfvb->address2,accrec)
         && fldw_address3(usrinfvb->address3,accrec)
         && fldw_phone(usrinfvb->phone,accrec)
         && fldw_systemtype(&usrinfvb->systemtype,accrec)
         && fldw_ansi(&usrinfvb->ansi,accrec)
         && fldw_daysleft(&usrinfvb->daysleft,accrec)
         && fldw_scnwidth(&usrinfvb->scnwidth,accrec)
         && fldw_scnlength(&usrinfvb->scnlength,accrec)
         && fldw_fsescnlen(&usrinfvb->fsescnlen,accrec)
         && fldw_editorprf(&usrinfvb->editorprf,accrec)
         && fldw_birthdate(&usrinfvb->birthdate,accrec)
         && fldw_sex(&usrinfvb->sex,accrec)
         && fldw_acctflags(&usrinfvb->acctflags,accrec)
         && fldw_access(usrinfvb->access,accrec)
         && fldw_language(&usrinfvb->language)
         && fldw_class(usrinfvb->class,usrinfvb->daysleft,accrec)
         && fldw_permlang(&usrinfvb->permlang));
}

static BOOL
fldw_password(                     /* userinfo "password" fld write rtn    */
char *newpsw,                      /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     char pass[PSWSIZ];

     b2ccpy(pass,newpsw,PSWSIZ);
     if (uidsame || vispsw) {
          if (pass[0] == '\0') {
               return(TRUE);
          }
          stlcpy(accrec->psword,pass,PSWSIZ);
          if (valinf(accrec->psword,1,FALSE) != 0) {
               prf("PSW");
               prfmsg(PTOOSML);
               return(FALSE);
          }
          else if (!safpsw && !valpsw(accrec->psword)
                && !ACCESS(OPACCT) && !(usaptr->flags&HASMST)) {
               prf("PSW");
               prfmsg(BADPSW);
               return(FALSE);
          }
          return(TRUE);
     }
     if (pass[0] == '\0') {
          return(TRUE);
     }
     prf("PSW");
     prfmsg(CANTCPSW);
     return(FALSE);
}

static BOOL
fldw_name(                         /* userinfo "name" fld write rtn        */
char *newname,                     /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     int errn;
     char tmpnam[NADSIZ];

     b2ccpy(tmpnam,newname,NADSIZ);
     if ((errn=valinf(tmpnam,5,TRUE)) != 0 && !sameas(tmpnam,accrec->usrnam)) {
          prf("NAM");
          prfmsg(errn == 1 ? NTOOSML : NPROFAN);
          return(FALSE);
     }
     stlcpy(accrec->usrnam,tmpnam,NADSIZ);
     return(TRUE);
}

static BOOL
fldw_company(                      /* userinfo "company" fld write rtn     */
char *newcomp,                     /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     char tmpadr[NADSIZ];

     b2ccpy(tmpadr,newcomp,NADSIZ);
     if (valinf(tmpadr,0,TRUE) != 0 && !sameas(tmpadr,accrec->usrad1)) {
          prf("COM");
          prfmsg(CPROFAN);
          return(FALSE);
     }
     stlcpy(accrec->usrad1,tmpadr,NADSIZ);
     return(TRUE);
}

static BOOL
fldw_address1(                     /* userinfo "address1" fld write rtn    */
char *newaddr,                     /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     int errn;
     char tmpadr[NADSIZ];

     b2ccpy(tmpadr,newaddr,NADSIZ);
     if ((errn=valinf(tmpadr,5,TRUE)) != 0 && !sameas(tmpadr,accrec->usrad2)) {
          prf("AD1");
          prfmsg(errn == 1 ? A1TOOSML : A1PROFAN);
          return(FALSE);
     }
     stlcpy(accrec->usrad2,tmpadr,NADSIZ);
     return(TRUE);
}

static BOOL
fldw_address2(                     /* userinfo "address2" fld write rtn    */
char *newaddr,                     /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     int errn;
     char tmpadr[NADSIZ];

     b2ccpy(tmpadr,newaddr,NADSIZ);
     if ((errn=valinf(tmpadr,5,TRUE)) != 0 && !sameas(tmpadr,accrec->usrad3)) {
          prf("AD2");
          prfmsg(errn == 1 ? A2TOOSML : A2PROFAN);
          return(FALSE);
     }
     stlcpy(accrec->usrad3,tmpadr,NADSIZ);
     return(TRUE);
}

static BOOL
fldw_address3(                     /* userinfo "address3" fld write rtn    */
char *newaddr,                     /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     char tmpadr[NADSIZ];

     b2ccpy(tmpadr,newaddr,NADSIZ);
     if (valinf(tmpadr,0,TRUE) != 0 && !sameas(tmpadr,accrec->usrad4)) {
          prf("AD3");
          prfmsg(A3PROFAN);
          return(FALSE);
     }
     stlcpy(accrec->usrad4,tmpadr,NADSIZ);
     return(TRUE);
}

static BOOL
fldw_phone(                        /* userinfo "phone" fld write rtn       */
char *newpho,                      /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     int errn;
     char tmppho[PHOSIZ];

     b2ccpy(tmppho,newpho,PHOSIZ);
     if ((errn=valinf(tmppho,7,TRUE)) != 0 && !sameas(tmppho,accrec->usrpho)) {
          prf("PHO");
          prfmsg(errn == 1 ? VTOOSML : VPROFAN);
          return(FALSE);
     }
     stlcpy(accrec->usrpho,tmppho,PHOSIZ);
     return(TRUE);
}

static BOOL
fldw_systemtype(                   /* userinfo "systemtype" fld write rtn  */
int *newstyp,                      /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     if ((*newstyp >= 0 && *newstyp < NSYSEL) || *newstyp == accrec->systyp) {
          accrec->systyp=*newstyp;
          return(TRUE);
     }
     prf("SYS");
     prfmsg(INVSYS);
     return(FALSE);
}

static BOOL
fldw_acctflags(                    /* userinfo "acctflags" fld write rtn   */
int *newflags,                     /*   new flags to write                 */
struct usracc *accrec)             /*   in-memory usracc struct to write   */
{
     if (usaptr->flags&HASMST) {
          accrec->flags&=~(HASMST);
          accrec->flags|=(*newflags&(HASMST));
     }
     if ((usaptr->flags&HASMST) || haskey(syskey) || ACCESS(OPPROT)) {
          accrec->flags&=~(UNDAXS);
          accrec->flags|=(*newflags&(UNDAXS));
     }
     if ((usaptr->flags&HASMST) || haskey(syskey) || ACCESS(OPDELT)) {
          accrec->flags&=~(DELTAG);
          accrec->flags|=(*newflags&(DELTAG));
     }
     if ((usaptr->flags&HASMST) || haskey(syskey) || ACCESS(OPSUSP)) {
          accrec->flags&=~(SUSPEN);
          accrec->flags|=(*newflags&(SUSPEN));
     }
     return(TRUE);
}

static BOOL
fldw_ansi(                         /* userinfo "ansi" fld write rtn        */
int *newansi,                      /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     if ((*newansi >= 0 && *newansi < NANSEL) || *newansi == accrec->ansifl) {
          accrec->ansifl=*newansi;
          return(TRUE);
     }
     prf("ANS");
     prfmsg(BADANSI);
     return(FALSE);
}

static BOOL
fldw_daysleft(
long *newdays,
struct usracc *accrec)
{
     if ((*newdays >= -1L) && (*newdays <= 32767L)) {
          accrec->daystt=(int)(*newdays);
          return(TRUE);
     }
     prf("DAY");
     return(FALSE);
}

static BOOL
fldw_scnwidth(                     /* userinfo "scnwidth" fld write rtn    */
int *newwid,                       /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     if ((*newwid >= MINSWD && *newwid <= MAXSWD)
      || *newwid == accrec->scnwid) {
          accrec->scnwid=*newwid;
          return(TRUE);
     }
     prf("SWD");
     prfmsg(BADSWD,MINSWD,MAXSWD);
     return(FALSE);
}

static BOOL
fldw_scnlength(                    /* userinfo "scnlength" fld write rtn   */
int *newlen,                       /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     if ((*newlen >= MINSLN && *newlen <= MAXSLN) || *newlen == CTNUOS
      || *newlen == accrec->scnbrk) {
          accrec->scnbrk=*newlen;
          return(TRUE);
     }
     prf("SLN");
     prfmsg(BADSLN,MINSLN,MAXSLN);
     return(FALSE);
}

static BOOL
fldw_fsescnlen(                    /* userinfo "fsescnlen" fld write rtn   */
int *newlen,                       /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     if ((*newlen >= MINSLN && *newlen <= MAXSLN)
      || *newlen == accrec->scnfse) {
          accrec->scnfse=*newlen;
          return(TRUE);
     }
     prf("FLN");
     prfmsg(BADSLN,MINSLN,MAXSLN);
     return(FALSE);
}

static BOOL
fldw_editorprf(                    /* userinfo "editorprf" fld write rtn   */
char *newprf,                      /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     char nprf;

     if ((nprf=toupper(*newprf)) == 'L') {
          accrec->usrprf|=PRFLIN;
          return(TRUE);
     }
     if (nprf == 'F') {
          accrec->usrprf&=~PRFLIN;
          return(TRUE);
     }
     prf("EPF");
     prfmsg(BADEPRF);
     return(FALSE);
}

static BOOL
fldw_birthdate(                    /* userinfo "birthdate" fld write rtn   */
double *newbdy,                    /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     char *birthd;

     if (okbday(birthd=v2sdat(*newbdy)) || sameas(birthd,accrec->birthd)) {
          stlcpy(accrec->birthd,birthd,DATSIZ);
          return(TRUE);
     }
     prf("BDY");
     prfmsg(INVBDY);
     return(FALSE);
}

static BOOL
fldw_sex(                          /* userinfo "sex" fld write rtn         */
char *newsex,                      /*   new info to write                  */
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     char nsex;

     if ((nsex=toupper(*newsex)) == 'M' || nsex == 'F' || nsex == 'U'
      || nsex == accrec->sex) {
          accrec->sex=nsex;
          return(TRUE);
     }
     prf("SEX");
     prfmsg(INVSEX);
     return(FALSE);
}

static BOOL
fldw_class(                        /* userinfo "class" fld write rtn       */
char *newclass,                    /*   new class to write                 */
long daysleft,                     /*   days to keep in if expiring tonight*/
struct usracc *accrec)             /*   in-memory usracc struct to write to*/
{
     char id[KEYSIZ],oldclass[KEYSIZ];

     stlcpy(oldclass,accrec->curcls,KEYSIZ);
     b2ccpy(id,newclass,KEYSIZ);
     if (*skpwht(id) != NULL) {
          if (!sameas(oldclass,id)) {
               if (swtcls_hook != NULL) {
                    return(swtcls_hook(accrec,id,(int)daysleft));
               }
          }
     }
     return(TRUE);
}

static BOOL
fldw_language(                     /* userinfo "language" fld write rtn    */
int *newlang)                      /*   new info to write                  */
{
     return(wrtlng(*newlang,TRUE));
}

static BOOL
fldw_access(                       /* user remote access fld write rtn     */
int *flags,                        /*   new flags to set for user          */
struct usracc *accrec)             /*   in-memory usracc struct to write   */
{
     int i,*iptr;

     if ((usaptr->flags&HASMST) || ACCESS(OPSYSP)) {
          iptr=flags;
          for (i=0; i < AXSSIZ ; i++) {
               accrec->access[i]=*iptr++;
          }
     }
     return(TRUE);
}

static BOOL
fldw_permlang(                     /* userinfo "permlang" fld write rtn    */
int *newlang)                      /*   new info to write                  */
{
     return(wrtlng(*newlang,FALSE));
}

static BOOL
wrtlng(                            /* record req'd uid's new language pref */
int newlang,                       /*   index of new language              */
BOOL wrtonl)                       /*   try to write online language 1st?  */
{
     int lngchg;

     if (chglngt == CHGAUT || chglngt == CHGOND) {
          chglngp=CHGNON;          /* su:language takes precedence */
          return(TRUE);
     }
     if (newlang == *rdlng(wrtonl)) {
          lngchg=CHGNON;
     }
     else {
          if (!uidsame || haskey(langchg)) {
               if (newlang == -1) {
                    lngchg=CHGAUT;
               }
               else if (newlang >= 0 && newlang < nlingo) {
                    lngchg=wrtonl && usron ? CHGONL : CHGOND;
               }
               else {
                    prf("LNG");
                    prfmsg(BADLANG);
                    return(FALSE);
               }
          }
          else {
               prf("LNG");
               prfmsg(CANTCLNG);
               return(FALSE);
          }
     }
     if (wrtonl) {
          chglngt=lngchg;
          nwlingot=newlang;
     }
     else {
          chglngp=lngchg;
          nwlingop=newlang;
     }
     return(TRUE);
}

static int *                       /* rets lng idx, or -1 if bad ondisk lng*/
rdlng(                             /* read req'd userid's current language */
BOOL rdonl)                        /*   try to read online language 1st?   */
{
     if (rdonl && usron) {
          dpkrvint=dpkext->lingo;
     }
     else {
          getgen(&genbuf,dpkuap->userid);
          dpkrvint=lngfnd(genbuf.lngnam);
     }
     return(&dpkrvint);
}

static int
adjlgo(                            /* make sure lang num is one w/ DEFPRT  */
int ilingo)                        /*   language number in question        */
{
     int ilg;

     if (samend(languages[ilingo]->name,spr("/%s",DFTPRT))) {
          return(ilingo);
     }
     return((ilg=chgprt(ilingo,DFTPRT)) != -1 ? ilg : 0);
}

static BOOL
vlduid(                            /* det. if req'd uid is valid, set vars */
char *dpkuid,                      /*   userid to check                    */
char *reqkey)                      /*   key req'd if uid other than self   */
{
     setbtv(accbb);
     setmem(&accrec,sizeof(struct usracc),0);
     if (!acqbtv(&accrec,dpkuid,0)) {
          prf("UID");
          prfmsg(INVUID);
          invldres=INVUID;
          return(FALSE);
     }
     chglngt=chglngp=CHGNON;
     uidsame=sameas(dpkuid,usaptr->userid);
     if (uidsame) {
          usron=TRUE;
          dpkusn=usrnum;
          dpkusp=usrptr;
          dpkuap=usaptr;
          dpkext=extptr;
          onlacc(dpkuap);
          return(TRUE);
     }
     usron=onsysn(dpkuid,TRUE);
     if (usron) {
          dpkusn=othusn;
          dpkusp=othusp;
          dpkuap=othuap;
          dpkext=extoff(dpkusn);
          onlacc(dpkuap);
     }
     else {
          dpkusn=nterms;
          dpkusp=NULL;
          dpkuap=&accrec;
          dpkext=NULL;
     }
     if (!haskey(reqkey)) {
          prf("UID");
          prfmsg(CANTALTR);
          invldres=CANTALTR;
          return(FALSE);
     }
     return(TRUE);
}

static void
onlacc(                            /* fill accrec w/ online user info      */
struct usracc *dpkuap)             /*   pointer to online info             */
                                   /*   implicit output: accrec            */
{
     stlcpy(accrec.psword,dpkuap->psword,PSWSIZ);
     stlcpy(accrec.usrnam,dpkuap->usrnam,NADSIZ);
     stlcpy(accrec.usrad1,dpkuap->usrad1,NADSIZ);
     stlcpy(accrec.usrad2,dpkuap->usrad2,NADSIZ);
     stlcpy(accrec.usrad3,dpkuap->usrad3,NADSIZ);
     stlcpy(accrec.usrad4,dpkuap->usrad4,NADSIZ);
     stlcpy(accrec.usrpho,dpkuap->usrpho,PHOSIZ);
     accrec.systyp=dpkuap->systyp;
     accrec.ansifl=dpkuap->ansifl;
     accrec.scnwid=dpkuap->scnwid;
     accrec.scnbrk=dpkuap->scnbrk;
     accrec.scnfse=dpkuap->scnfse;
     accrec.usrprf=dpkuap->usrprf;
     accrec.flags=dpkuap->flags;
     stlcpy(accrec.birthd,dpkuap->birthd,DATSIZ);
     accrec.sex=dpkuap->sex;
}

static int
valinf(                            /* check a piece of info                */
char *infstg,                      /*   info to check                      */
unsigned minlen,                   /*   minimum required length            */
BOOL chkpfn)                       /*   check profanity as well?           */
{
     if (strlen(infstg) < minlen) {
          return(1);
     }
     if (chkpfn) {
          setpfn(infstg);
          if (pfnlvl > 1) {
               return(2);
          }
     }
     return(0);
}

static void
ptkrng(                            /* put a keyring                        */
char *ringid,                      /*   ring id to update the keyring      */
char *rings,                       /*   list of rings to update            */
BOOL clsrng)                       /*   putting a class keyring?           */
{
     char id[UIDSIZ];

     if (clsrng) {
          id[0]=RINGID;
          stlcpy(id+1,ringid,KEYSIZ);
     }
     else {
          stlcpy(id,ringid,UIDSIZ);
     }
     setmem(kysbuf,RINGSZ,0);
     setbtv(keysbb);
     if (acqbtv(kysbuf,id,0)) {
          stlcpy(&kysbuf[KLSTOF],rings,RINGSZ-32);
          upvbtv((struct keyrec *)kysbuf,KLSTOF+strlen(&kysbuf[KLSTOF])+1);
          rstbtv();
          r2wprf(TRUE);
          return;
     }
     else {
          rstbtv();
          if (clsrng) {
               prf("INVCLS");
          }
          else {
               prf("INVUSR");
          }
          r2wprf(FALSE);
     }
}

static void
gtkrng(                            /* get a keyring                        */
char *ringid,                      /*    ring id to get keyring for        */
BOOL clsrng,                       /*    getting a class keyring?          */
struct saunam *dpknam)             /*    dpk name to respond with          */
{
     char id[UIDSIZ];

     if (clsrng) {
          id[0]=RINGID;
          stlcpy(id+1,ringid,KEYSIZ);
     }
     else {
          stlcpy(id,ringid,UIDSIZ);
     }
     setmem(kysbuf,RINGSZ,0);
     setbtv(keysbb);
     if (acqbtv(kysbuf,id,0)) {
          rsp2read(dpknam,STGLEN,&kysbuf[KLSTOF]);
          rstbtv();
          return;
     }
     rstbtv();
     rejectreq();
}

void
uintfy(                            /* notify C/S AD/E of class change      */
int unum,                          /*   user number to notify              */
char *uid,                         /*   userid switched                    */
struct clstab *cltptr)             /*   ptr to new class information       */
{
     struct saunam uinsau;
     struct ncicrdvb ncicrdvb;
     struct ncivb ncivb;

     stlcpy(uinsau.sysid,msysid,SIDSIZ);
     stlcpy(uinsau.appid,UINAID,AIDSIZ);
     stlcpy(uinsau.usrid,uid,UIDSIZ);
     uinsau.flags=0x00;
     stlcpy(uinsau.suffix,"class change",SFXSIZ);
     if (shwcrd) {
          c2bcpy(ncicrdvb.clname,cltptr->clname,KEYSIZ-1);
          ncicrdvb.limcal=cltptr->limcal;
          ncicrdvb.limday=cltptr->limday;
          ncicrdvb.dbtlmt=cltptr->dbtlmt;
          ncicrdvb.exempt=cltptr->flags&CRDXMT ? 'Y' : 'N';
          senddpk(unum,UINAID,NORMAL,&uinsau,sizeof(struct ncicrdvb),&ncicrdvb);
     }
     else {
          c2bcpy(ncivb.clname,cltptr->clname,KEYSIZ-1);
          ncivb.limcal=cltptr->limcal;
          ncivb.limday=cltptr->limday;
          senddpk(unum,UINAID,NORMAL,&uinsau,sizeof(struct ncivb),&ncivb);
     }
}

static void
wt4lok(void)                       /* wait for datalink lock               */
{
     if (dllokd(usrnum)) {
          w4atck=hrtval();
          cycleme(w4ldly);
     }
}

static void
w4ldly(void)                       /* wait a bit before going to A/A mode  */
{
     if (!dllokd(usrnum)) {
          cycleme(wt4lok);
     }
     else if (hrtval()-w4atck > LOKDLY) {
          gcsasc();
          cycleme(w4udly); /* chgs cyc addr, but no cyc till ret to C/S */
     }
}

static void
w4udly(void)                       /* wait a bit before return to C/S mode */
{
     if (w4atck == 0L) {      /* freshly setmem()'d due to return from A/A */
          w4atck=hrtval();
     }
     else if (hrtval()-w4atck > LOKDLY) {
          dlunlk(usrnum);
          rejectreq();
     }
}

static void
retwgmvr(void)                     /* return WGM version to caller         */
{
     FILE *fp;
     int sz;
     struct fndblk fb;
     char *path;
     static char *vercode=NULL;

     if (vercode == NULL) {
          path=spr("%s%s",OSMSUBDR,"WGM.VER");
          if (fnd1st(&fb,path,0) && (fp=fopen(path,FOPRB)) != NULL) {
               if (fb.size > 1024L) {
                    sz=1024;
               }
               else {
                    sz=(int)fb.size;
               }
               vercode=alczer(sz+1);
               fread(vercode,1,sz,fp);
               fclose(fp);
          }
          else {
               vercode="";
          }
     }
     rsp2read(NULL,STGLEN,vercode);
}

static void
retfilist(void)                    /* return OSM file list to caller       */
{
     struct fndblk fb;
     static char *biglist=NULL;

     if (biglist == NULL) {
          *rsptmp='\0';
          if (tfsopn(OSMSUBDR"GCSVCMAN.LST") == 0) {
               rsp2read(NULL,0,"");
               return;
          }
          while (tfsrdl() != TFSDUN) {
               if (tfstate == TFSLIN) {
                    depad(tfsbuf);
                    if (fnd1st(&fb,spr("%s%s",OSMSUBDR,tfsbuf),0)) {
                         sprintf(&rsptmp[strlen(rsptmp)],"%s\t%s\t%lf\t",
                            fb.name,
                            l2as(fb.size),
                            d2vdat(fb.date,fb.time));
                    }
               }
          }
          cntdir(OSMUPDDR"*.*");
          strcat(rsptmp,l2as(numbyts));
          strcpy(biglist=alcmem(strlen(rsptmp)+1),rsptmp);
     }
     rsp2read(NULL,STGLEN,biglist);
}

static void
dontzap(void)                      /* prevent user from idling offline     */
{
     usrptr->usetmr=0;
}

static void
retfile(                           /* send OSM file to user                */
char *filname)                     /*   the file name, security checked    */
{
     struct fndblk fb;
     char *path;

     if (fnd1st(&fb,path=spr("%s%s",OSMSUBDR,filname),0)) {
          cycleme(dontzap);
          rsp2read(NULL,STGLEN,spr("%s;%s",path,fb.name));
     }
     else {
          rejectreq();
     }
}

static void
retupdfile(                        /* send OSM update file to user         */
char *filname,                     /*   the file name, security checked    */
int direction)                     /*   direction of read                  */
{
     struct fndblk fb;
     char *path,best[FNEXSZ];

     if (direction == 0) {
          stlcpy(best,filname,FNEXSZ);
     }
     else {
          setmem(best,FNEXSZ,0);
          if (fnd1st(&fb,path=spr("%s*.*",OSMUPDDR),0)) {
               do {
                    if (direction > 0) {
                         if (*filname == '\0' || stricmp(fb.name,filname) > 0) {
                              if (*best == '\0' || stricmp(fb.name,best) < 0) {
                                   stlcpy(best,fb.name,FNEXSZ);
                              }
                         }
                    }
                    else {
                         if (stricmp(fb.name,filname) < 0) {
                              if (*best == '\0' || stricmp(fb.name,best) > 0) {
                                   stlcpy(best,fb.name,FNEXSZ);
                              }
                         }
                    }
               } while (fndnxt(&fb));
          }
     }
     if (*best != '\0') {
          strcpy(strchr(namtmp->suffix,' ')+1,best);
          if (fnd1st(&fb,path=spr("%s%s",OSMUPDDR,best),0)) {
               cycleme(dontzap);
               rsp2read(namtmp,STGLEN,spr("%s;%s",path,fb.name));
          }
          else {
               rejectreq();
          }
     }
     else {
          rejectreq();
     }
}

static void
sysxdone(void)                     /* system agent xfer done routine       */
{
}

static void
sysabort(void)                     /* system agent abort req routine       */
{
     if (srchdat[usrnum].usingid == greqid) {
          srchdat[usrnum].usingid=FREE2U;
     }
}

static void
sysfin(void)                       /* close down the system agent          */
{
     clsmsg(gcsmb);
}

static BOOL                        /*   returns whether password is good   */
csdftpsw(                          /* check password - client users        */
char *psword)                      /*   proposed password                  */
{
     char c,*psw;

     if (sameas(psword,psw=usaptr->psword)) {
          do {
               c=*psw;
               if (c == '\0') {
                    return(TRUE);
               }
               psw++;
          } while (!(c < ' ' && c > '\0')); /* less than 0x20, more than 0 */
     }
     return(FALSE);
}

BOOL                          /*   based on axs4op() from REMSYS.C    */
hasaxs(                       /* does user have access to this op?    */
struct usracc *uacptr,        /* pointer to user account to check     */
int op)                       /* operation to check access to         */
{
     if (sameas(uacptr->userid,"Sysop")
       || (op == 99 && usrptr->flags&MASTER)) {
          return(TRUE);
     }
     return(uacptr->access[op>>4]&(1<<(op%16)));
}
