/***************************************************************************
 *                                                                         *
 *   GCOMM.H                                                               *
 *                                                                         *
 *   Copyright (c) 1987-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file for all Galacticomm C source development      *
 *   in DOS.  It defines standard symbols for file-open modes, console     *
 *   keystroke codes, and many other standard coding items, including      *
 *   prototypes for all of the functions in GCOMM.LIB.                     *
 *                                                                         *
 *                                            - T. Stryker 2/3/92          *
 *                                                                         *
 ***************************************************************************/

#include "stdio.h"
#include "stdlib.h"
#include "values.h"
#include "ctype.h"
#include "dir.h"
#include "dos.h"
#include "io.h"
#include "math.h"
#include "mem.h"
#include "setjmp.h"
#include "string.h"
#include "stdarg.h"
#include "time.h"

#undef fileno
#define fileno(f)       ((unsigned char)(f)->fd)

#ifdef FORWINDOWS
#include "windows.h"
#define VBASIC FAR PASCAL _export
#else
typedef int BOOL;
#define TRUE  1
#define FALSE 0
#endif

#ifdef PHARLAP
#define EXPORT _export
#else
#ifdef FORWINDOWS
#define EXPORT _export
#else
#define EXPORT
#endif
#endif

#include "btvstf.h"
#include "dosface.h"
#include "dskutl.h"
#include "tfscan.h"
#include "lingo.h"
#include "msgrdr.h"
#include "vbdatim.h"

#ifdef PHARLAP
#include "phapi.h"

#define malloc      galmalloc
#define free        galfree

void *
galmalloc(                         /* Galacticomm's malloc() for debugging */
unsigned int size);

void
galfree(                           /* Galacticomm's free() for debugging   */
void *block);

void
memdbgrpt(                         /* report on special memory debugging   */
FILE *fp);                         /*   open file to report to             */

extern int memdbg;                 /* set to 0 to disable special sel dbg  */
extern int alcdbg;                 /* (memdbg) 0=running low on selectors  */
extern unsigned long nmalloc;      /* count malloc()'s                     */
extern unsigned long nmskip;       /* skip this many initial malloc's      */
extern unsigned long nmsctr;       /* counter up to nmskip                 */
extern unsigned long nmspec;       /* count of special malloc() sel's      */
extern unsigned long nmbust;       /* count special sel's averted          */
extern unsigned long nmlinr;       /* number of linear conv errors         */
extern unsigned long nmfree;       /* count free()'s                       */
#endif

#define FOPRB  "rb"     /* fopen() 2nd parameter for read binary mode       */
#define FOPWB  "wb"     /* fopen() 2nd parameter for write binary mode      */
#define FOPRWB "r+b"    /* fopen() 2nd parameter for read/write binary mode */
#define FOPWRB "w+b"    /* fopen() 2nd parameter for write/read binary mode */
#define FOPAB  "ab"     /* fopen() 2nd parameter for append binary mode     */

extern int fopavl;      /* # of fopen()s left according to Borland's table  */

#define CNTLIT 0        /* does sscanf() count literal matches?             */
#define CFREGS 1        /* REGS has a cflag field (see TurboC dos.h)        */

#ifdef MSC_C
#define getml(ln)           halloc(ln,1)
#define farfree(ptr)        hfree(ptr)
long sizmem(void);
char huge *halloc(unsigned long size,int nblocks);
void hfree(void *p);
#define FOPRA  "ra"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWA  "wa"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWA "r+a"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPWRA "w+a"    /* fopen() 2nd parameter for write/read ASCII mode  */
#define FOPAA  "aa"     /* fopen() 2nd parameter for append ASCII mode      */
#define CKNOWN
#define setmem(p,n,c)       memset(p,c,n)
#ifdef MS5
#define movmem(s,d,n)       memmove(d,s,n)   /* microsoft 5.0 memcpy does   */
#else                                        /*   not deal with overlaps    */
#define movmem(s,d,n)       memcpy(d,s,n)
#endif
#endif

#ifdef TSC_C
#define sizmem()            farcoreleft()
#define getml(ln)           farmalloc(ln)
long farcoreleft(void);
char *farmalloc(unsigned long size);
void farfree(void *p);
#define FOPRA  "rt"     /* fopen() 2nd parameter for read ASCII mode        */
#define FOPWA  "wt"     /* fopen() 2nd parameter for write ASCII mode       */
#define FOPRWA "r+t"    /* fopen() 2nd parameter for read/write ASCII mode  */
#define FOPWRA "w+t"    /* fopen() 2nd parameter for write/read ASCII mode  */
#define FOPAA  "at"     /* fopen() 2nd parameter for append ASCII mode      */
#define CKNOWN
#endif

#ifdef CKNOWN
#undef CKNOWN
#else
#error YOU SHOULD IDENTIFY THE COMPILER!
#endif

#ifndef abs
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define abs(a)          (((a) < 0) ? -(a) : (a))
#endif

#define nelems(x) (sizeof(x)/sizeof(x[0]))   /* # of elements in an array  */
#define fldoff(struc,field) ((unsigned short)&(((struct struc *)0)->field))

#define VBTRUE  0xFFFF             /* Visual Basic TRUE                    */
#define VBOOL2C(x) if (x != FALSE) x=TRUE

extern
jmp_buf disaster;             /* master longjmp() block, for catastro()    */

#define F1        (59*256)    /* function key codes, returned from getchc()*/
#define F2        (60*256)
#define F3        (61*256)
#define F4        (62*256)
#define F5        (63*256)
#define F6        (64*256)
#define F7        (65*256)
#define F8        (66*256)
#define F9        (67*256)
#define F10       (68*256)
#define SHIFT (( 84-59)*256)  /* to form shift-, alt-, and ctrl-function   */
#define CTRL  (( 94-59)*256)  /*   keys, add these values to the above...  */
#define ALT   ((104-59)*256)  /*   e.g. alt-F1's code is ALT+F1            */

#define HOME      (71*256)    /* special key codes returned from getchc()  */
#define END       (79*256)
#define PGUP      (73*256)
#define PGDN      (81*256)
#define CRSRUP    (72*256)
#define CRSRDN    (80*256)
#define CRSRLF    (75*256)
#define CRSRRT    (77*256)
#define BAKTAB    (15*256)
#define INS       (82*256)
#define DEL       (83*256)
#define TAB       9
#define ESC       27
#define CTRLEND   (117*256)
#define CTRLHOME  (119*256)
#define CTRLPGUP  (132*256)
#define CTRLPGDN  (118*256)
#define CTRLLF    (115*256)
#define CTRLRT    (116*256)
#define CTRLUP    (141*256)
#define CTRLDN    (145*256)
#define ALT_A     (30*256)
#define ALT_B     (48*256)
#define ALT_C     (46*256)
#define ALT_D     (32*256)
#define ALT_E     (18*256)
#define ALT_F     (33*256)
#define ALT_G     (34*256)
#define ALT_H     (35*256)
#define ALT_I     (23*256)
#define ALT_J     (36*256)
#define ALT_K     (37*256)
#define ALT_L     (38*256)
#define ALT_M     (50*256)
#define ALT_N     (49*256)
#define ALT_O     (24*256)
#define ALT_P     (25*256)
#define ALT_Q     (16*256)
#define ALT_R     (19*256)
#define ALT_S     (31*256)
#define ALT_T     (20*256)
#define ALT_U     (22*256)
#define ALT_V     (47*256)
#define ALT_W     (17*256)
#define ALT_X     (45*256)
#define ALT_Y     (21*256)
#define ALT_Z     (44*256)
#define ALT_0     (129*256)
#define ALT_1     (120*256)
#define ALT_2     (121*256)
#define ALT_3     (122*256)
#define ALT_4     (123*256)
#define ALT_5     (124*256)
#define ALT_6     (125*256)
#define ALT_7     (126*256)
#define ALT_8     (127*256)
#define ALT_9     (128*256)

#define NOCURS  0             /* cursiz() code to make cursor invisible    */
#define LILCURS 1             /* cursiz() code for small underscore cursor */
#define BIGCURS 2             /* cursiz() code for block (insert) cursor   */

#define SCNSIZ  4000          /* number of bytes per 80x25 screen image    */
#define scnoff(x,y) ((((y)*80)+(x))*2)  /* xlate (x,y) to screen offset    */

extern                        /* saving/restoring CRT stuff                */
struct curatr {               /* 64-byte screen & cursor status region     */
     char attrib;             /*    attribute byte for video RAM           */
     char various1[29];       /*    (internal screen & cursor status info) */
     void *scnstt;            /*    first parameter to setwin()            */
     char various2[30];       /*    (internal screen & cursor status info) */
} curatr;

extern
int explodem;                 /* yes/no controlling exploding windows      */
extern
int edtvalc;                  /* last char accepted by edtval()            */
#define MCHOICE     1         /* multiple choice question, hide cursor     */
#define ALLCAPS     2         /* convert all chars to capital letters      */
#define USEPOFF     4         /* use proff() x,y base coord offsets        */
#define MULTIEX     8         /* allow multiple field-exit conditions      */
extern
int color;                    /* flag indicating color display available   */

#define setatr(a)  sstatr(a)  /* redirected for monochrome CRT support     */
#define ltoa(a)    l2as(a)    /* redirected to ensure compatibility        */
#define getdfre(a) dskfre(a)  /* redirected to eliminate duplicate routine */

#define STATIC     static     /* change this if addrs needed in .MAP file  */

#include "transit.h"

/* MSGUTL.C prototypes */

void inimsg(unsigned maxsiz);
FILE *opnmsg(char *mcvfil);
char *rawmsg(int msgnum);
unsigned msgseek(int msgnum);
void clsmsg(FILE *mb);

extern
unsigned mxmssz;

/* RTKICK.C prototypes */

void rtkick(int delay,void (*dstrou)());
void prcrtk(void);
extern int rtkoff;

/* separately compiled routines section */

void setmbk(FILE *mb);
void rstmbk(void);
extern FILE *curmbk;
char *getasc(int msgnum);
void prfasc();
int findstg(char *stg, char *body);
char *firstwd(char *string);
char *nextwd(void);
char *lastwd(char *string);
long lngopt(int msgnum,long floor,long ceiling);
unsigned hexopt(int msgnum,unsigned floor,unsigned ceiling);
int numopt(int msgnum,int floor,int ceiling);
int ynopt(int msgnum);
int chropt(int msgnum);
char *stgopt(int msgnum);
char *pthopt(int msgnum);
int tokopt();
char *alcdup(char *stg);
char *alcmem(unsigned size);
char *alcrsz(void *mptr,unsigned oldsize,unsigned newsize);
void catastro();
extern void (*catrpt)(char *filnam);
extern int catact;
void memcata(void);
void cataexit(void);
void cursiz(int howbig);
void rstcur(void);
int curcurs(void);
int edtval(int sx,int sy,int maxlen,char *sval,int (*valrou)(),int flags);
int edtchc(int sx,int sy,char *sval,char *chcs[],int flags);
void explode(char *sctptr,int wulx,int wuly,int wlrx,int wlry);
void explodeto(char *sptr,int fux,int fuy,int flx,int fly,int tux,int tuy);
void nsexploto(char *sptr,int fux,int fuy,int flx,int fly,int tux,int tuy);
void proff(int x,int y);
void prat();
int isselc(int c);
int istxvc(int c);
int isuidc(int c);
int isfiln(int c,char *stg);
char *l2as(long longin);
char *ul2as(unsigned long ulongin);
char *mdfgets(char *buf,int size,FILE *fp);
void repmem(void *where,char *what,int totsiz);
int sameas(char *stg1,char *stg2);
int sameto(char *shorts,char *longs);
int samein(char *shorts,char *longs);
char *spr();
char *stzcpy(char *dst,char *src,unsigned num);
char *stzcat(char *dst,char *src,unsigned num);
char *stlcpy(char *dst,char *src,unsigned num);
char *stlcat(char *dst,char *src,unsigned num);
void b2ccpy(char *dest,char *src,unsigned length);
void c2bcpy(char *dest,char *src,unsigned length);
char *b2ccvt(char *str,int bufsiz);
char *c2bcvt(char *str,int bufsiz);
int validig(int c);
int validyn(int c,char *stg);
char *skpwht(char *cp);
char *skpwrd(char *cp);
char *normspec(char *dest,char *src);
void iniscn(char *filnam,void *where);
char *cvtscn(void *where);
char *scblank(char *buf,int attrib);
void sstatr(int attrib);
int scncolor(int attrib);
int alldgs(char *string);
int allhex(char *string);
unsigned scanch(char *bytes,char target,int limit);
void rmvwht(char *string);
void monorcol(void);
void imonorcol(void);
char *alczer(unsigned nbytes);
char *ibm2ans(char attr,char *buff);
void chimove(char *src,char *dst,register int cnt);
void chiset(char *dst,int cnt,char val);
int depad(char *cp);
char *unpad(char *cp);
int cputype(void);
char *msgscan(char *msgfil,char *vblnam);
char *mstscan(char *msgfil,char *vblnam,int maxsiz);
void setcnf(char *optnam,char *optval);
void applyem(char *filnam);
void padfld(char *stg,int len);
int strpln(char *stg);
char *stpans(char *str);
char *strstp(char *str,char ch);
char *strrpl(char *str,char och,char nch);
int memstp(char *block,int nbytes,char byt);
int noalen(char *stg);
char *skpans(char *stg);
int fgetstg(char *stg,int n,FILE *stream);
long xfrfil(FILE *fromfp,FILE *tofp,long nbytes);
int samend(char *longs,char *ends);
void sortstgs(char *stgs[],int num);
void setcrit(void);
void pascrit(void);
char *uniqfn(char *fspec);
int stgidx(char *string,char ch);
char *fnwext(char *fulpth);
char *fnext(char *fulpth);
char *fnroot(char *fulpth);
char *mkdosn(char *string);
void scn2mem(char *src,char *dst,unsigned len);
int undwin(void);
int rsvnam(char *name);
void fixpth(char *path);

extern
int selatr,nslatr;
int choose(int n,char *chcs[],int upx,int upy,int lox,int loy,int escok);
int choowd(char *chcs[],int fc,int upx,int upy,int lox,int loy,int escok);
int choout(void);
void supchc(int n,char *chcs[],int upx,int upy,int lox,int loy,int escok);
int hdlchc(int c);
void dspchc(void);
void jmp2chc(int fc);

char *bargph(int width,long num,long den);
extern
int bgperc;            /* percentage, 0 to 100 of the most recent bargph() */
extern
int bgpos;             /* char offset of bar from last bargph() (0..width) */

/* debug checking declarations section */

#ifdef DEBUG
#define ASSERT(cnd) ((cnd) ? ((void)0) \
                           : galastfail(__FILE__" "FILREV,__LINE__,#cnd));

#define ASSERTM(cnd,msg) ((cnd) ? ((void)0) \
                                : galastfail(__FILE__" "FILREV,__LINE__,msg));
void
galastfail(                        /* assertion failure                    */
char *filinf,                      /* source file name and revision        */
unsigned long linnum,              /* source file line number              */
char *message);                    /* ad hoc message (no %-parms allowed)  */
#else
#define ASSERT(c)    ((void)0)
#define ASSERTM(c,m) ((void)0)
#endif

extern int astmode;                /* assertion failure mode:              */
#define ASTIGN 1                   /* ignore                               */
#define ASTRPT 2                   /* make report to disk (see astrptfil)  */
#define ASTCAT 3                   /* call catastro(), shut down immed.    */
extern char *astrptfil;            /* ASTRPT: assertion failure report file*/

/* old MBBST.LIB prototype section */

void setwin(void *scn,int xul,int yul,int xlr,int ylr,int sen);
void rstwin(void);
char *frzseg(void);
void unfrez(void);
char *auxcrt(void);
void locate(int x,int y);
void rstloc(void);
int curcurx(void);
int curcury(void);
void clreol(void);
void prfspd(int delay);
void cursact(int movit);
void belper(int pitch);
void ansion(int on);

void iniprf(char *pbuf,int pfbsiz);
void prf(char *fmat,...);
void prfmsg(int msg,...);
void outprf(int chan);
void clrprf(void);
extern
char *prfbuf,
     *prfptr;

int kbhit(void);
int getchc(void);
int getch(void);
int lascan(void);
void dsairp(void);
void enairp(void);

int profan(char *string);          /* determine profanity level of string  */
extern char *pfnptr;               /* pointer to profanity in string       */
extern char *pfnlst;               /* pointer to compiled profanity list   */

int calcrc(int crc,char byt);
int odd(char byt);
char lingyn(char c);

extern char *prfbuffers;
extern char **prfpointers;
extern char *linuse;
extern int mltflg;
void inimlt(unsigned pbsize);
void clrmlt(void);
void cklonl(void);
void outmlt(int chan);
void prfmlt(int msgno,...);
void pmlt(char *ctlstg,...);

int goodstg(char *ptr);
int goodptr(void *ptr);
int goodcptr(void *ptr);
unsigned goodblk(void *ptr,unsigned nbytes);
extern char *pinstd;

void *alcblok(unsigned qty,unsigned size);
void *ptrblok(void *bigptr,unsigned index);

char *commas(char *intstg);

int deldir(char *dirpath);
extern char deldirerr[];

int   initask(void (*tskaddr)(int taskid));
void  mfytask(int taskid,void (*tskaddr)(int taskid));
void  prctask(void);

int bigdigit(char *font,int dig,int x,int y);
extern char digit2x3[];
extern char digit2x3b[];
extern char digit3x3[];
extern char digit2x5[];

extern void (*hdlgpr)(char *);

int   newarr(int incsiz,unsigned elemsiz);
void *add2arr(int arrhdl,void *newelem);
void *arrbas(int arrhdl);
int   ninarr(int arrhdl);
void *arrelem(int arrhdl,int index);

void  gmkdir(char *dirnam);
char *filnpart(char *filespec);
char *pathpart(char *filespec);

char *itemidxd(char *ctlstg,int index,char *delim);
char *itemidx(char *ctlstg,int index);
int itemcntd(char *ctlstg,char *delim);
int itemcnt(char *ctlstg);

char *gmdnam(char *mdfnam);
int gnumdb(char *mdfnam);
void snumdb(char *mdfnam,int ndbfils);
char *scnmdf(char *mdfnam,char *linpfx);
char *mdfodmd(char *mdfnam);

BOOL                               /*   returns FALSE if str not numeric   */
isfxval(                           /* convert numeric dpk suffix to int    */
unsigned *result,                  /*   buffer to place result             */
char *str);                        /*   numeric portion of suffix string   */
                                   /*   (takes olthan/ogthan into account) */

BOOL                               /*   returns FALSE if str not numeric   */
lsfxval(                           /* convert numeric dpk suffix to long   */
unsigned long *result,             /*   buffer to place result             */
char *str);                        /*   numeric portion of suffix string   */
                                   /*   (takes olthan/ogthan into account) */

void
inipool(                           /* initialize dynamic pool API          */
char *swpfil);                     /*   swap file for on-disk memory areas */
int                                /*   pool handle                        */
newpool(                           /* create a new pool of memory areas    */
unsigned areasiz,                  /*   size of each area within pool      */
int nareas,                        /*   number of areas within pool        */
int ninmem);                       /*   number of areas in memory at once  */
int                                /*   handle to area, or -1 if none avail*/
rsvarea(                           /* reserve a memory area within pool    */
int poolhdl);                      /*   handle to the pool (from newpool())*/
void *
areaptr(                           /* get pointer to a reserved mem area   */
int poolhdl,                       /*   handle to the pool (from newpool())*/
int areahdl);                      /*   handle to the area (from rsvarea())*/
void
unrarea(                           /* unreserve a memory area within pool  */
int poolhdl,                       /*   handle to the pool (from newpool())*/
int areahdl);                      /*   handle to the area (from rsvarea())*/
void
clspool(void);                     /* close down dynamic pool API          */

char *getrno(void);

char *                             /*   returns dststg                     */
strins(                            /* insert a string before another       */
char *dststg,                      /*   original and destination string    */
char *insstg,                      /*   string to insert                   */
int sizdst);                       /*   room at dststg, including '\0'     */

unsigned int                       /*   returns 16-bit CRC                 */
crc16(                             /* compute 16-bit CRC                   */
unsigned char *stg,                /*   byte array                         */
int nbytes);                       /*   number of bytes                    */

unsigned long                      /*   returns 32-bit CRC                 */
crc32(                             /* compute 32-bit CRC                   */
unsigned char *stg,                /*   byte array                         */
int nbytes);                       /*   number of bytes                    */

#define CRC32GOOD 0xDEBB20E3L

/*
         for generating 16-bit CRC:  store    crc16(stg,nbytes)
for testing validity of 16-bit CRC:  compare  crc16(stg,nbytes) == 0
         for generating 32-bit CRC:  store   ~crc32(stg,nbytes)
for testing validity of 32-bit CRC:  compare  crc32(stg,nbytes) == CRC32GOOD
*/

/* The following low-level CRC computation macros and the tables they use  */
/* come from Omen Technology's CRCTAB.H source file.                       */

#define updcrc(cp, crc) ( crctab[((crc >> 8) & 255)] ^ (crc << 8) ^ cp)
#define UPDC32(b, c) (cr3tab[((int)c ^ b) & 0xff] ^ ((c >> 8) & 0x00FFFFFFL))

extern unsigned short crctab[];
extern long cr3tab[];

unsigned char                      /*   returns 8-bit checksum             */
cksum8(                            /* compute 8-bit checksum of byte array */
unsigned char *stg,                /*   byte array                         */
int nbytes);                       /*   number of bytes                    */

unsigned int                       /*   returns 16-bit checksum            */
cksum16(                           /* compute 16-bit checksum of word array*/
unsigned int *stg,                 /*   word array                         */
int nwords);                       /*   number of words (nbytes/2)         */

BOOL
wcmatch(                           /* wild-card match input against picstg */
unsigned char *inpstr,             /*   candidate literal string           */
unsigned char *picstg);            /*   picture (wild-card) string         */

char *                             /*   return error message or NULL       */
substi(                            /* substitute new zstgs for old in file */
char *filein,                      /*   filespec of input file             */
char *fileout,                     /*   filespec of output file            */
int  nchgs,                        /*   number of old/new strings          */
char *tobechgd[],                  /*   array of zstrings to be changed    */
char *chgemto[]);                  /*   array of zstrings to change 'em to */

void
cpyfil(                            /* generic copy file utility            */
char *src,                         /*   source file name                   */
char *dst);                        /*   destination file name              */

int                                /*   error code                         */
readpfn(                           /* read profanity data file             */
const char *filnam,                /*   profanity data file path+name      */
void *buf,                         /*   buffer read into (must be aligned) */
size_t bufsiz);                    /*   size of buffer                     */

#define PFN_MAXALC 65520U          /* max size of profanity list buffer    */
#define PFNLISTFILE "galpfn.dta"   /* default profanity list data file     */
                                   /* readpfn() return codes               */
#define RDPFN_OK       0           /*   list read successfully             */
#define RDPFN_OVERFLOW 1           /*   buffer too small                   */
#define RDPFN_EOF      2           /*   unexpected end of file             */
#define RDPFN_INVALID  3           /*   invalid list file                  */
#define RDPFN_FOPEN    4           /*   unable to open list file           */
