/***************************************************************************
 *                                                                         *
 *   GALP&QH.H                                                             *
 *                                                                         *
 *   Copyright (c) 1993-1996 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is the Polls and Questionnaires header file.                     *
 *                                                                         *
 *                                 - M. Timothy Stark 10/01/93             *
 *                                                                         *
 ***************************************************************************/

#define PNAMELEN        26    /* poll name length                          */
#define PDESCLEN        40    /* poll description length                   */
#define KEYLEN          16    /* key field length                          */
#define VALLEN           4    /* dynapak value length for copy buffer      */
#define STRSIZ         240    /* string size for temporary string area     */
#define POLLSPERPG      16    /* number of polls to list per page          */
#define ANSPERPG        15    /* number of answers per page in answer list */
#define TXTSIZ        2000    /* size of text buffer for questions         */
#define PTHFILSIZ       50    /* size of text buffer for path and file name*/
#define FILESIZ         13    /* size of a file                            */
#define MSGSIZ        1024    /* max size of message area                  */
#define ANSSIZ        1000    /* size of text buffer for answer            */
#define MAXASTGS        16    /* maximum number of answer strings          */
#define ANSSTGLEN       65    /* answer string length                      */
#define MAXQUES        100    /* maximum number of questions per poll      */
#define MAXCYCS          3    /* maximum QEQ's per cycle for listing       */
#define MXLWID          80    /* maximum label width                       */
#define MAXWHEEL         7    /* maximum frames in wheel animation         */
#define MAXPARAM        16    /* maximum number of answer parameters       */
#define RESUSRS2        -1    /* substate place holder                     */
#define MAXLENCC        20    /* maximum length of a credit card entry     */
#define MINLENCC        13    /* minimum length of a credit card entry     */
#define PFNTSTY "|Y00000100"  /* poll font style                           */
#define PBUTSTY "|1B00000201EQ010E000F080700000F07000000" /* button style  */
#define QFNTSTY "|Y000002LD"  /* question font style                       */
#define QBUTSTY "|1B0P0I0201EQ01010F0F080700000F0700000P" /* button style  */

/* question types                                                          */
#define CREDIT           1    /* credit card number question type          */
#define DATE             2    /* date question type                        */
#define DISONLY          3    /* display only question type                */
#define MULTICHC         4    /* multiple choice question                  */
#define NUMERIC          5    /* numeric question type                     */
#define OPEN_ENDED       6    /* open ended response question type         */
#define TRUEFALSE        7    /* true/false question type                  */
#define YESNO            8    /* yes/no question type                      */
#define USERACCT         9    /* user account question type                */

#define SHOW             1    /* show poll to user regardless of key       */
#define DIM              2    /* dim poll to user without proper key       */
#define HIDE             3    /* hide poll from user without proper key    */

#define SKIP             1    /* skip logon process altogether             */
#define ANNOUNCE         2    /* announce new poll to user                 */
#define ASK              3    /* ask user to take this poll now            */
#define INSIST           4    /* insist user takes this poll               */

/* define poll types                                                       */
#define POLL             1    /* tallies results (doesn't allow open-ended */
                              /*   answer types though)                    */
#define QUEST            2    /* doesn't tally results (although it can    */
                              /*   save a user's answers for lookup) and   */
                              /*   allows all answer types                 */

/* define temp user flags                                                  */
#define LONMODE          1    /* user is in the logon input handler rou.   */
#define MORELIST         2    /* RETURN will continue listing display      */
#define INSISTDUN        4    /* during logon, no more insist polls        */
#define ASKDUN           8    /* during logon, no more ask polls           */
#define HASSLE          16    /* was user hassled during logon process?    */
#define REVERSE         32    /* search in reverse mode                    */
#define FNDFIRST        64    /* have found the first results record       */
#define ADDRESP        128    /* insert open ended response data           */

/* poll flags                                                              */
#define   DISBRANCH      1    /* discard branching answers                 */
#define   SPARE          2    /* spare flag (reserved for future use)      */
#define   EDITP          4    /* poll is currently being edited            */
#define   ADDP           8    /* poll is currently being added             */
#define   CLRDFLT       16    /* default all questions to clear screen?    */
#define   DELETE        32    /* poll has been tagged for deletion         */

/* question flags                                                          */
#define   BRANCH         1    /* this question contains branching          */
#define   EXMPT          2    /* exempt answer from data storage           */
#define   EDITQ          4    /* question is being edited                  */
#define   CLRSCN         8    /* clear screen before this question         */

/* data storage type definitions                                           */
#define BTRIEVE          1    /* store answers to BTRIEVE data file        */
#define ASCII            2    /* store answers to an ASCII file            */
#define BOTH             3    /* store answers to both ASCII and BTRIEVE   */
#define DISCARD          4    /* do not store answers                      */

#define ONCE             1    /* only allow user to answer once            */
#define REPLACE          2    /* replace previous answers                  */
#define ACCUMULATE       3    /* accumulate answers                        */

#define UACSYS           1    /* user has sysop access                     */
#define UACPO            2    /* user has poll-op access                   */

struct polldata {                  /* master poll data structure           */
     char      pname[PNAMELEN];    /* poll name                            */
     char      pdesc[PDESCLEN];    /* poll description                     */
     int       polltype;           /* poll type POLL=1 QUES=2              */
     int       priority;           /* poll priority 0=SKIP 1=ANNOUNCE      */
                                   /* 2=ASK 3=INSIST                       */
     int       data;               /* data storage method array element    */
                                   /* 0/1=BTRIEVE 2=ASCII 3=BOTH 4=NONE    */
     int       answer;             /* 0/1=ONCE 2=REPLACE 3=ACCUMULATE      */
     unsigned  createdate;         /* date poll was created                */
     unsigned  closedate;          /* date to close this poll              */
     char      lookup_key[KEYLEN]; /* key required to look up answers      */
     char      logon_key[KEYLEN];  /* key required to get logon option     */
     char      acc_key[KEYLEN];    /* key required to answer poll          */
     int       acc_attr;           /* access display attribute             */
     char      res_key[KEYLEN];    /* key required to view results         */
     char      grant_key[KEYLEN];  /* key to grant users that complete     */
     char      grant_class[KEYLEN];/* class to grant users that complete   */
     long      grant_crd;          /* credits to grant users that complete */
     char      grant_file[PTHFILSIZ]; /* file to grant users that complete */
     int       flags;              /* poll flags                           */
};

struct vbpdata {                   /* VB style poll data structure         */
     char      pname[PNAMELEN];    /* poll name                            */
     char      pdesc[PDESCLEN];    /* poll description                     */
     int       polltype;           /* poll type POLL=1 QUES=2              */
     int       priority;           /* poll priority 0=SKIP 1=ANNOUNCE      */
                                   /* 2=ASK 3=INSIST                       */
     int       data;               /* data storage method array element    */
                                   /* 0/1=BTRIEVE 2=ASCII 3=BOTH 4=NONE    */
     int       answer;             /* 0/1=ONCE 2=REPLACE 3=ACCUMULATE      */
     double    createdate;         /* date poll was created                */
     double    closedate;          /* date to close this poll              */
     char      lookup_key[KEYLEN]; /* key required to look up answers      */
     char      logon_key[KEYLEN];  /* key required to get logon option     */
     char      acc_key[KEYLEN];    /* key required to answer poll          */
     int       acc_attr;           /* access display attribute             */
     char      res_key[KEYLEN];    /* key required to view results         */
     char      grant_key[KEYLEN];  /* key to grant users that complete     */
     char      grant_class[KEYLEN];/* class to grant users that complete   */
     long      grant_crd;          /* credits to grant users that complete */
     char      grant_file[PTHFILSIZ]; /* file to grant users that complete */
     int       flags;              /* poll flags                           */
};

struct quesdata {                  /* poll question data structure         */
     int       qnum;               /* question identification number       */
     char      pollname[PNAMELEN]; /* poll name this question is related to*/
     int       qtype;              /* question type                        */
     char      ansstg[MAXASTGS][ANSSTGLEN];   /* array of answer strings   */
     int       branch[MAXASTGS];   /* branching designators                */
     int       prev;               /* previous question                    */
     int       next;               /* default next question                */
     long      max;                /* maximum value/length of answer       */
     long      min;                /* minimum value/length of answer       */
     int       field;              /* field array element for usracc struct*/
     int       flags;              /* question flags                       */
     int       ansparam;           /* number of answer parameters to allow */
     char      txtmsg[TXTSIZ];     /* question/text display message        */
};

struct ansrdata {                  /* poll answer data structure           */
     int       qnum;               /* question number for this answer      */
     char      pollname[PNAMELEN]; /* poll name this answer is related to  */
     char      uid[UIDSIZ];        /* userid of owner of this data         */
     char      answer[ANSSIZ];     /* variable length answer string        */
};

struct pollstat {                  /* current poll status for this user    */
     char      uid[UIDSIZ];        /* userid                               */
     char      pname[PNAMELEN];    /* poll name                            */
};

/* construct composite key for question acquisition                        */
struct quescomp {                  /* composite key for question           */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
     int       qnum;               /* question number of ques to acquire   */
};

/* construct composite key for answer acquisition                          */
struct ansrcomp {                  /* composite key for answer             */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
     char      uid[UIDSIZ];        /* userid of owner of this data         */
     int       qnum;               /* question number of this answer       */
};

/* construct composite key for answer acquisition                          */
struct cupacomp {                  /* composite key for cleanup answers    */
     int       qnum;               /* question number of this answer       */
     char      pollname[PNAMELEN]; /* pollname of poll to acquire          */
};

/* construct composite key for finding user status of polls                */
struct statcomp {
     char      uid[UIDSIZ];        /* userid                               */
     char      pname[PNAMELEN];    /* poll name                            */
};

/* construct composite key for logon poll acquisition                      */
struct usercomp {
     char      uid[UIDSIZ];        /* userid to acuire                     */
     int       prior;              /* priority to acquire                  */
     int       status;             /* status to acquire                    */
};

struct polltemp {                  /* temporary storage area for user      */
     char      tstr[STRSIZ];       /* genaral purpose storage area         */
     char      tans[ANSSIZ];       /* temporary answer storage area        */
     char      tmpid[UIDSIZ];      /* used for stat lookup                 */
     int       flags;              /* temporary user flags                 */
     int       ques;               /* place holder for listing in cycle    */
     int       fques;              /* first question for viewing results   */
     int       ans;                /* answer counter for cycle             */
     int       cur;                /* current question for auto-inc        */
     int       wheel;              /* spinning wheel place holder          */
     long      pos;                /* position holder for CYCLING          */
     long      oldpos;             /* position holder for current page     */
     char      dftinp;             /* default input character              */
     char select[POLLSPERPG][PNAMELEN]; /* poll selection array            */
     struct polldata pdata;        /* poll data structure                  */
     struct quesdata qdata;        /* question data structure              */
     struct ansrdata adata;        /* answer data structure                */
     char fsdbuf[1];               /* share VDA buffer area with FSD       */
};

struct polltally {                 /* survey answer tally structure        */
     char pollname[PNAMELEN];      /* tally for what pollname              */
     int  answer[MAXQUES][MAXASTGS];    /* tallies by question number      */
};

/* flags for reading poll status */
#define QUESDN 0x01                /* done seeking question info           */
#define ANSRDN 0x02                /* done seeking answer info             */

struct rqinfo {                    /* per-request information              */
     int idx;                      /* index number for cycling             */
     int status;                   /* current poll status - work area      */
     int highques;                 /* high question number - work area     */
     int totques;                  /* total number of questions - work area*/
     int highansr;                 /* high question answered - work area   */
     int totansr;                  /* total number of questions answered   */
     long abs;                     /* absolute address for cycling         */
     long auxabs;                  /* auxillary absolute address for cyc   */
     char pname[PNAMELEN];         /* poll name for cycling                */
     struct quescomp qcomp;        /* composite ques key structure for cyc */
     struct ansrcomp acomp;        /* composite ansr key structure for cyc */
     int cycflgs;                  /* flags used when cycling (see above)  */
     struct saunam dpknam;         /* sau structure information            */
};

struct rstat {                     /* poll status structure                */
     int status;                   /* current poll status                  */
     int highques;                 /* high question number                 */
     int totques;                  /* total number of questions            */
     int highansr;                 /* last question answered               */
     int totansr;                  /* total number of questions answered   */
};

struct vbplist {                   /* VB poll listing information structure*/
     char pname[PNAMELEN];         /* poll name                            */
     char pdesc[PDESCLEN];         /* poll description                     */
     int polltype;                 /* poll or questionnaire type           */
     int answer;                   /* poll answer status                   */
     int flags;                    /* poll flags                           */
     int data;                     /* data storage method                  */
};

struct vbqlist {                   /* VB question listing info sturcture   */
     int qnum;                     /* question number                      */
     int qtype;                    /* question type                        */
     int prev;                     /* previous question number             */
     int next;                     /* next question number                 */
     BOOL branch;                  /* branch designator                    */
     char ques[PDESCLEN];          /* brief of question                    */
};

struct gcspoll {                   /* GCS user current poll tracking info  */
     char pname[PNAMELEN];         /* poll name currently in use           */
};

/* poll status flags                                                       */
#define POLLTYPE         1         /* Listing is a Poll                    */
#define QUESTYPE         2         /* Listing is a Questionnaire           */
#define GRNCHK           4         /* User has completed this p/q          */
#define YELCHK           8         /* User has partially complete this p/q */
#define BLUEBOX         16         /* This is a new poll for this user     */
#define REDX            32         /* User does not have access to this p/q*/
#define REDM            64         /* p/q is currently undergoing maint    */

#define rqiptr ((struct rqinfo *)mrqptr)     /* ptr to information prm     */
#define rqsptr ((struct rqstat *)mrqptr)     /* ptr to status prm          */
#define pptr ((struct polldata *)(pbb->data))     /* poll data area        */
#define qptr ((struct quesdata *)(qbb->data))     /* question data area    */
#define aptr ((struct ansrdata *)(abb->data))     /* answer data area      */
#define eptr(h,x)   ((struct edpoll *)(arrelem(h,x))   /* edpoll pointer   */

#define tp          ((struct polltemp *)vdaptr)    /* define vdaptr        */
#define otp(x)      ((struct polltemp *)vdaoff(x)) /* define other vdaptr  */
#define atp         ((struct polltemp *)vdatmp)    /* define for cleanup   */

extern
struct message filmsg;             /* message header for grantstf()        */

extern
char *supkey,                      /* super user key for granting stuff    */
     *pllopkey;                    /* Poll-Op key                          */

/* GALP&QA.C (C/S prototypes) */
void polread(int direction,struct saunam *dpknam);
void polwrite(struct saunam *dpknam,unsigned length,void *value);
void polxdone(void);
void polabort(void);
void poldsc(void);
BOOL plist(int direction,struct saunam *dpknam);
BOOL rdques(int type,int direction,struct saunam *dpknam);
void skpdonly(void);
void sndqdpk(struct saunam *dpknam,int type,struct quesdata *qdata);
BOOL aread(int direction,struct saunam *dpknam);
void findans(void);
void sndadpk(struct saunam *dpknam,struct ansrdata *adata);
void qcheck(int direction,struct saunam *dpknam);
void plstat(void);
void sread(struct saunam *dpknam);
void cycsread(void);
char *cvt4tb(char *stg);
char *cfrmtb(char *stg);
void gcsudca(struct polldata *polptr);
void cycplist(void);
void gcsrst(struct polldata *pdp);
void gcsdel(struct polldata *pdp);
int pedit(int direction, struct saunam *dpknam);
int mresult(int direction, struct saunam *dpknam);
BOOL qresstat(struct saunam *dpknam);
void cycqrs(void);
int uidpoll(struct saunam *dpknam);
char *cvt4tb(char *stg);
int qlist(struct saunam *dpknam);
void cscycres(void);
void cscycres2(void);
BOOL csremtally(void);
void cscyctally(void);
void csgrantstf(void);
void pqerror(char *pFormat,...);
BOOL pollvis(struct polldata *polptr,int unum,BOOL igndel);

/* GALP&Q.C (ANSI prototypes) */
void polmsg (int msg, int mode);
int ispollop (void);
int isysop (void);
int dunques (int flags);
int listpolls (void);
int chk4poll (void);
int polmain (void);
void addprp (int msgno, int amode);
char *polrft (void);
int polvfy (int fldno, char *answer);
void poldun (int save);
void polptc (void);
void quesprp (int msgno, int amode);
char *quesrft (void);
int quesvfy (int fldno, char *answer);
void quesdun (int save);
void quesptc (void);
void astgprp (int msgno, int amode);
char *astgrft (void);
int astgvfy (int fldno, char *answer);
void astgdun (int save);
void astgptc (void);
int checkscn (void);
void setptrs (void);
void initdata (void);
int listquest (void);
int fndpoll (void);
int fndstat (void);
void cyc_inc (void);
void qtypevfy (void);
void saveques (int mode);
void gettake (void);
void getres (void);
void loadnext (void);
void loadprev (void);
int chknext (void);
int chkprev (void);
void setinplen (void);
char *questxt (void);
void editqtype (int mode);
void editmult (int mode);
void loadquestxt (void);
void showmult (int mode);
int ismult (void);
void cyc_tally (void);
int remove_tally (void);
void add_tally (int qnum, char *pname, char *answer);
int chk_answer (char *stg);
void results (void);
void getlook (void);
void shwrslt (void);
void duppoll (void);
void nonpoll (void);
void takepoll (void);
void getpoll (void);
void editpoll (void);
void addques (void);
void getques (void);
void quesopts (void);
void getlup (void);
void disstats (void);
void cyc_ques (void);
void cyc_rslt (void);
void cyc_lup (void);
void cyc_disstats (void);
void cyc_logon (void);
void cyc_resusrs (void);
void cyc_resusrs2 (void);
int gopoll (void);
void nxtpoll (void);
void pollask (void);
void pollins (void);
int notexp (void);
void cycwheel (void);
int chkpoll (void);
void apendasc (int qnum, char *pname, char *answer);
void grantstf (void);
void upaccfld (int field, char *answer);
void delconf (void);
void cyc_delques (void);
void dundelq (void);
void prf2tx (void);
void poldft (int msg);
int okdate (char *stg);
int chk_clearance (void);
void resconf (void);
void gtrfsb (int msgno, int maxbuts, char *fstyle, char *bstyle, char butarr[][MXLWID+1]);
char *rsltper (int num, int tot);
void initasc (void);
void rstflgs (void);
void pnachng (void);
void qnachng (void);
void anachng (void);
int polstat (void);
int duntake (int flags);
void saveresp (char *ansstg);
int usrinpoll(int unum,char *poll);
void EXPORT init__polmod (void);
void chkmodacc(struct saunam *dpknam);
void chk4dups(struct saunam *dpknam);
void qresacc(struct saunam *dpknam);
extern int oldbgnedt();
