/***************************************************************************
 *                                                                         *
 *   GALMJD.C                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1996 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This is Worldgroup online portion of Doors.  This allows users        *
 *   to connect to external computers which are running Doors applications *
 *                                                                         *
 *                                   - B. Love and R. Skurnick 1/28/93     *
 *   C/S agent, support                         -D. Pitchford 11/13/95     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "remote.h"
#include "gcspsrv.h"
#include "galmjd.h"

#define FILREV "$Revision: 1.6 $"

static int mjdinp(void);
static int mjddrsp(void);
static void mjdipst(void);
static void mjdlst(int retstt);
static void mjdentn(void);
static void mjdentb(void);
static void mjdente(void);
static void mjdentk(void);
static void mjdents(void);
static void mjdentt(void);
static void mjdenth(void);
static void mjdentm(void);
static void mjdentp(void);
static void mjdchkm(void);
static void mjdedta(void);
static void mjdedtd(void);
static void mjdedtb(void);
static void mjdedte(void);
static void mjdedtk(void);
static void mjdedts(void);
static void mjdedtt(void);
static void mjdedtm(void);
static void mjdedtp(void);
static void mjddela(void);
static void mjddelr(void);
static void mjdwchd(void);
static void mjdsttd(void);
static void mjdrtk(void);
static void mjdaddd(void);
static BOOL mjdfpt(struct mjdapps *app,long fpos);
static int mjdvalc(int c);
static int mjdavl(struct mjdapps *aptr);
static void mjddsp(struct mjdapps *aptr);
static int mjdved(void);
static void mjdrsvp(void);
static void mjdrpm(int news);
static void mjdpmt(int news);
static int mjdconfl(long fpos,int unum);
static void mjdcon(int msg);
static void mjdhtrm(int msg);
static void mjdtrml(int unum,int rsv,int msg);
static void mjdhwt(int other);
static void mjdthn(void);
static void mjdhup(void);
static void mjdfin(void);

#define APPNSZ       9             /* maximum size of app name w/ '\0'     */
#define APPDSC      40             /* maximum size of app desc w/ '\0'     */
#define HSKSTG      10             /* maximum size of parse stg w/ '\0'    */

#define DOORSECS    10             /* seconds to wait for door to respond  */

/* BEGIN C/S AGENT PROTOTYPES AND DECLARATIONS */

static void init_cslib(void);
static void mjdread(int direction,struct saunam *dpknam);
static void mjdwrite(struct saunam *dpknam,unsigned length,void *value);
static void mjdabort(void);
static unsigned int aps2vb(struct mjdapps *aps,struct vbmjdapps *vba);
static void vb2aps(struct vbmjdapps *vba,struct mjdapps *aps);
static BOOL vfystr(struct mjdapps *aps);
static void csdinfo(void);
static void inidoor(void);
static BOOL csmjdfpt(struct mjdapps *app,long fpos);
static void csses(void);
static void snd2door(int hwnd,int length,char *value);
static char *addlf(char *txtbuf);

static
struct agent mjdagt={              /* agent information structure          */
     "GALMJD",                     /*   appid                              */
     mjdread,                      /*   read-dynapak function pointer      */
     mjdwrite,                     /*   write-dynapak function pointer     */
     NULL,                         /*   file xfer-done function pointer    */
     mjdabort                      /*   abort-request function pointer     */
};

struct vbmjdapps {                 /* Doors app data for VB                */
     int begchn;                   /*   Starting channel for this app.     */
     int endchn;                   /*   Ending channel for this app.       */
     int flags;                    /*   Various bit flags                  */
     int surchg;                   /*   Surcharge for using this app.      */
     int hskmhd;                   /*   method to pass parameters 0-3      */
     int timalw;                   /*   time allowed in the door/0=no limit*/
     char ndkh[APPNSZ+APPDSC+KEYSIZ+HSKSTG+1]; /* aggregate strings (TAB)  */
};

static
struct mjdlst {                    /* ongoing request: list doors          */
     int reqtyp;                   /*   request type (MJDLST)              */
     char suffix[SFXSIZ];          /*   current suffix                     */
} *ml;

static
struct mjdses {                    /* ongoing request: door session        */
     int reqtyp;                   /*   request type (MJDSES)              */
     char app[APPNSZ];             /*   door being accessed                */
     int hwnd;                     /*   trigger hwnd to use                */
     int state;                    /*   connection state (like substt)     */
     int othchn;                   /*   door channel in use                */
     int surchg;                   /*   additional consumption rate        */
     long fpos;                    /*   user in door btv file position     */
     unsigned long tim;            /*   hrtval time last packet was sent   */
}*ms;

#define MJDLST 1                   /* request type: list doors             */
#define MJDSES 2                   /* request type: door session           */

/* END C/S AGENT PROTOTYPES AND DECLARATIONS */

int mjdstt;
struct module mjrdoor={            /* module interface block               */
     "",                           /*    description for main menu         */
     NULL,                         /*    user logon supplemental routine   */
     mjdinp,                       /*    input routine if selected         */
     mjdthn,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     mjdhup,                       /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     mjdfin                        /*    finish-up (sys shutdown) routine  */
};

                                   /* non message block related substates  */
#define LSTING      -1             /*   listing Doors                      */
#define LSTENT      -2             /*   list Doors for enter prompt        */
#define RSTING      -3             /*   waiting for rstchn() to complete   */
#define RSPPND      -4             /*   Door responding to initialization  */
#define BYTPST      -5             /*   passthrough mode active            */
#define WT4RST      -6             /*   setting prior to going idle        */
#define WT4PAU      -7             /*   give link some time to reset       */
#define WT4SEL      -8             /*   channel is in idle state           */
#define GETOUT      -9             /*   handle CONCEX when user was not src*/

static
char vlddos[]="ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$&'()-@^_`";

static
char valhsk[]="ABCSTU";

static
char *passtg[]={"","No Passing","Drop File","Parms Passed"};

static
char *xfrbuf,                      /* transfer buffer for passthrough      */
     *sysapp,                      /* key required for sysop access        */
     *mjdakey;                     /* key required for c/s agent access    */

static
FILE *mjdmb;                       /* Doors message file block pointer     */

static
BTVFILE *mjdbb;                    /* Doors btrieve file block pointer     */

struct mjdapps {                   /* Doors valid application data         */
     char appname[APPNSZ];         /*   Name of application                */
     char appdesc[APPDSC];         /*   Short description of application   */
     int begchn;                   /*   Starting channel for this app.     */
     int endchn;                   /*   Ending channel for this app.       */
     int flags;                    /*   Various bit flags                  */
     int surchg;                   /*   Surcharge for using this app.      */
     char keyreq[KEYSIZ];          /*   Key required to use this app.      */
     int hskmhd;                   /*   method to pass parameters 0-3      */
     char hskstg[HSKSTG];          /*   parse string for sending parms     */
     int timalw;                   /*   time allowed in the door/0=no limit*/
     char spare[100-87];           /*   spare room for growth              */
};

                                   /* Definition of bit flags for datafile */
#define MJDDIS      1              /*   application is currently disabled  */
#define MJDNOH      2              /*   does not require handshaking       */
#define MJDCAB      4              /*   user can "abort" this application  */
#define MJDXCL      8              /*   only one user in Door at a time    */

static
struct mjdapps mjdedt,             /* work area for add/modify/delete app  */
               *mjddsk;            /* btrieve transfer area - one shot use */

struct mjdusr {                    /* Doors user data structure            */
     int flags;                    /*   Various bit flags                  */
     int othchn;                   /*   channel this is linked to          */
     int wttime;                   /*   time to wait for door to respond   */
     int discnt;                   /*   number of DISCHR's received        */
     int distmr;                   /*   disconnect count timer             */
     int w4rst;                    /*   on a link channel time to clear    */
     long fpos;                    /*   file position in app database      */
     struct mjdapps app;           /*   application associated to this link*/
     char cntd;                    /*   are any apps available to list     */
     char dftinp;                  /*   default input character            */
     struct mjdses *ses;           /*   c/s session (if MJDCSL flag)       */
};

                                   /* Definition of bit flags for userdata */
#define MJDLNK      1              /*   this channel is a link channel     */
#define MJDCSL      2              /*   this link channel is hooked to c/s */

static
int mjdinu=-1;                     /* apps editor in use -1=no or usrnum   */

                                   /* Options from GALMJD.MSG              */
int rlsprt;                        /*   release port after door termination*/
char dischr;                       /*   character signaling a disconnect   */

#define mjdptr ((struct mjdusr *)vdaptr)    /* volatile data pointer casts */
#define mjdarr(u) ((struct mjdusr *)vdaoff(u))

void EXPORT
init__mjrdoor(void)                /* initialize Doors module              */
{
     stzcpy(mjrdoor.descrp,gmdnam("GALMJD.MDF"),MNMSIZ);
     mjdstt=register_module(&mjrdoor);
     mjdmb=opnmsg("galmjd.mcv");
     mjdbb=opnbtv("galmjd.dat",sizeof(struct mjdapps));
     mjddsk=(struct mjdapps *)alcmem(sizeof(struct mjdapps));
     xfrbuf=alcmem(outbsz);
     dclvda(sizeof(struct mjdusr));
     dischr=chropt(DISCHR);
     rlsprt=ynopt(RLSPRT);
     sysapp=stgopt(SYSAPP);
     init_cslib();
     rtkick(1,mjdrtk);
}

static int
mjdinp(void)                       /* input status handler for Doors       */
{
     setmbk(mjdmb);
     setbtv(mjdbb);
     chkdft(mjdptr->dftinp);
     if ((margc == 0 || (usrptr->flags&INJOIP)) && !(mjdptr->flags&MJDLNK)) {
          if (usrptr->substt == GETOUT) {
               btulok(usrnum,0);
               return(0);
          }
          else if (usrptr->substt != LSTING && usrptr->substt != LSTENT) {
               if (usrptr->substt < 0) {
                    return(1);
               }
               numcat=maxcat+1;
               mjdpmt(usrptr->substt);
          }
          else {
               mjdptr->fpos=0L;
               btuclo(usrnum);
               mjdpmt(usrptr->substt == LSTING ? INTPMT : WCHAPP);
          }
     }
     else if (margc == 1 && sameas(margv[0],"X") && !(mjdptr->flags&MJDLNK)) {
          btumil(usrnum,DFTIMX);
          if (usrnum == mjdinu) {
               mjdinu=-1;
          }
          switch (usrptr->substt) {
          case INTRO:
          case INTROS:
          case INTPMT:
          case INTPMTS:
               return(0);
          default:
               if (!(usrptr->flags&CONCEX)) {
                    numcat=maxcat+1;
                    mjdpmt(INTPMT);
               }
               condex();
          }
     }
     else {
          do {
               bgncnc();
               switch (usrptr->substt) {
               case 0:
                    cncchr();
                    usrptr->flags&=~X2MAIN;
                    mjdpmt(INTRO);
                    break;
               case INTRO:
               case INTROS:
               case INTPMT:
               case INTPMTS:
                    switch (cncchr()) {
                    case '?':
                         cncall();
                         mjdpmt(INTRO);
                         break;
                    case 'E':
                         mjdpmt(WCHAPP);
                         break;
                    case 'L':
                         mjdlst(LSTING);
                         break;
                    case 'A':
                         if (mjdved()) {
                              setmem(&mjdedt,sizeof(struct mjdapps),0);
                              mjdpmt(ENTAPP);
                         }
                         break;
                    case 'M':
                         if (mjdved()) {
                              mjdpmt(MODAPP);
                         }
                         break;
                    case 'D':
                         if (mjdved()) {
                              mjdpmt(DELAPP);
                         }
                         break;
                    default:
                         cncall();
                         prfmsg(CNOTIL);
                         mjdpmt(usrptr->substt);
                    }
                    break;
               case ENTAPP:
                    mjdentn();
                    break;
               case ENTDSC:
                    strcpy(mjdedt.appdesc,cncall());
                    mjdpmt(BEGCHN);
                    break;
               case BEGCHN:
                    mjdentb();
                    break;
               case ENDCHN:
                    mjdente();
                    break;
               case ENTKEY:
                    mjdentk();
                    break;
               case ENTSUR:
                    mjdents();
                    break;
               case ENTTIM:
                    mjdentt();
                    break;
               case ENTHSK:
                    mjdenth();
                    break;
               case ENTHMT:
                    mjdentm();
                    break;
               case ENTHST:
                    mjdentp();
                    break;
               case MODAPP:
                    mjdchkm();
                    break;
               case EDTAPP:
               case EDTPMT:
                    mjdedta();
                    break;
               case MODDSC:
                    mjdedtd();
                    break;
               case MODBCH:
                    mjdedtb();
                    break;
               case MODECH:
                    mjdedte();
                    break;
               case MODKEY:
                    mjdedtk();
                    break;
               case MODSUR:
                    mjdedts();
                    break;
               case MODTIM:
                    mjdedtt();
                    break;
               case MODHMT:
                    mjdedtm();
                    break;
               case MODHST:
                    mjdedtp();
                    break;
               case DELAPP:
                    mjddela();
                    break;
               case DELRUS:
                    mjddelr();
                    break;
               case WCHAPP:
                    mjdwchd();
                    break;
               case LSTING:
               case LSTENT:
               case WT4RST:
               case WT4PAU:
               case WT4SEL:
                    prf("");
                    break;
               case RSPPND:
                    if (!mjddrsp()) {
                         return(1);
                    }
                    mjdipst();
                    return(1);
               case BYTPST:
                    return(1);
               case GETOUT:
                    btulok(usrnum,0);
                    return(0);
               default:
                    cncall();
               }
          } while (!endcnc());
     }
     outprf(usrnum);
     return(1);
}

static int
mjddrsp(void)                      /* response from door to initialize     */
{
     int unum;

     cncall();
     if (margc == 1 && sameas(margv[0],"OK")) {
          return(1);
     }
     if (!(mjdptr->flags&MJDCSL)) {
          unum=usrnum;
          curusr(mjdptr->othchn);
          mjdcon(INVRSP);
          curusr(unum);
     }
     mjdrsvp();
     return(0);
}

static void
mjdipst(void)                      /* initiate character passthrough       */
{
     int othchn;
     struct user *uptr;
     char buf[80];

     if (!(mjdptr->flags&MJDCSL)) {
          othchn=usrnum;
          curusr(mjdptr->othchn);
          prfmsg(CONNTD);
          if (mjdarr(mjdptr->othchn)->app.flags&MJDCAB) {
               if (dischr != ' ') {
                    prfmsg(TODABT,dischr);
               }
          }
          outprf(usrnum);
          curusr(othchn);
     }
     uptr=&user[mjdptr->othchn];
     if (mjdptr->flags&MJDCSL) {
          uptr->crdrat+=(mjdptr->ses->surchg=mjdptr->app.surchg);
     }
     else {
          uptr->crdrat+=mjdptr->app.surchg;
          uptr->flags|=NOINJO;
     }
     mjdptr->wttime=0;
     sprintf(buf,"%s Door Active [%02X]",mjdptr->app.appname,
                                         channel[mjdptr->othchn]);
     shochl(buf,'D',baudat(usrptr->baud,0));
     if (!(mjdptr->flags&MJDCSL)) {
          btulok(mjdptr->othchn,0);
     }
     btuinj(usrnum,CYCLE);
     usrptr->substt=BYTPST;
     if (!(mjdptr->flags&MJDCSL)) {
          btubsz(usrnum,outbsz,INPSIZ);
          btuhwh(usrnum,outbsz-20);
          btutrg(usrnum,outbsz-1);
          btuhwh(mjdptr->othchn,INPSIZ-20);
          btutrg(mjdptr->othchn,INPSIZ-1);
          btuinj(mjdptr->othchn,CYCLE);
          uptr->substt=BYTPST;
     }
     else {
          btubsz(usrnum,outbsz/2,outbsz/2);
          btuhwh(usrnum,outbsz/2-20);
          btutrg(usrnum,outbsz/2-1);
          mjdptr->ses->state=BYTPST;
     }
}

static void
mjdlst(                            /* begin list of all avail apps         */
int retstt)
{
     mjdptr->cntd=0;
     if (alobtv(mjddsk,0)) {
          if (mjdavl(mjddsk)) {
               mjddsp(mjddsk);
          }
          else {
               prf("");
          }
          mjdptr->fpos=absbtv();
          btuinj(usrnum,CYCLE);
          usrptr->substt=retstt;
     }
     else {
          prfmsg(NONAVL);
          mjdpmt(INTPMT);
     }
}

static void
mjdentn(void)                      /* enter an application name            */
{
     char *ptr;

     cncall();
     if (margc != 1) {
          prfmsg(ONEWRD);
          mjdpmt(ENTAPP);
          return;
     }
     for (ptr=strupr(input) ; *ptr != '\0' ; ptr++) {
          if (!mjdvalc(*ptr)) {
               prfmsg(INVCHR);
               mjdpmt(ENTAPP);
               return;
          }
     }
     if (strlen(input) > APPNSZ-1) {
          prfmsg(TOOLNG,APPNSZ-1);
          mjdpmt(ENTAPP);
     }
     else if (qeqbtv(input,0)) {
          prfmsg(DUPAPP);
          mjdpmt(ENTAPP);
     }
     else {
          stzcpy(mjdedt.appname,input,APPNSZ);
          mjdpmt(ENTDSC);
     }
}

static void
mjdentb(void)                      /* enter first channel to access app    */
{
     int begchn,msg=ENDCHN;

     if ((begchn=cnchex()) < 0 || begchn > 255) {
          cncall();
          prfmsg(INVHEX2);
          msg=usrptr->substt;
     }
     else {
          mjdedt.begchn=begchn;
     }
     mjdpmt(msg);
}

static void
mjdente(void)                      /* enter last channel to access app     */
{
     int endchn,msg=ENTKEY;

     if ((endchn=cnchex()) < 0 || endchn > 255) {
          cncall();
          prfmsg(INVHEX2);
          msg=usrptr->substt;
     }
     else if (endchn < mjdedt.begchn) {
          cncall();
          prfmsg(LESHEX);
          msg=usrptr->substt;
     }
     else {
          mjdedt.endchn=endchn;
     }
     mjdpmt(msg);
}

static void
mjdentk(void)                      /* enter key required to access app     */
{
     int msg=ENTSUR;
     char *keyptr;

     if (morcnc() != '.') {
          keyptr=cncwrd();
          if (keynam(keyptr) == 1) {
               strcpy(mjdedt.keyreq,keyptr);
          }
          else {
               prfmsg(INVKEY);
               msg=usrptr->substt;
          }
     }
     else {
          cncchr();
     }
     mjdpmt(msg);
}

static void
mjdents(void)                      /* enter surcharge for this app         */
{
     mjdedt.surchg=atoi(cncall());
     mjdpmt(ENTTIM);
}

static void
mjdentt(void)                      /* enter max time allowed in door       */
{
     int msg=ENTHSK;
     int timlmt;

     if (isdigit(morcnc())) {
          timlmt=cncint();
          if (timlmt > -1 && timlmt <= 1440) {
               mjdedt.timalw=timlmt;
          }
          else {
               prfmsg(INVTIM);
               msg=ENTTIM;
          }
     }
     else {
          cncall();
          prfmsg(INVNUM);
          msg=ENTTIM;
     }
     mjdpmt(msg);
}

static void
mjdenth(void)                      /* enter handshake defaults             */
{
     char c;

     if ((c=cncyesno()) == 'Y') {
          mjdpmt(ENTHMT);
     }
     else if (c == 'N') {
          mjdedt.flags|=MJDNOH;
          mjdaddd();
     }
     else {
          prfmsg(YESONO);
          mjdpmt(ENTHSK);
     }
     cncall();
}

static void
mjdentm(void)                      /* check for method of passing parms    */
{
     int opt;

     if ((opt=cncint()) > 0 && opt < 4) {
          if ((mjdedt.hskmhd=opt) == 3) {
               mjdpmt(ENTHST);
          }
          else {
               mjdaddd();
          }
     }
     else {
          cncall();
          mjdpmt(ENTHMT);
     }
}

static void
mjdentp(void)                      /* validate string to pass              */
{
     char *ptr;

     cncall();
     if (strlen(input) > HSKSTG-1) {
          prfmsg(INVHST,HSKSTG-1);
          mjdpmt(ENTHST);
     }
     else {
          for (ptr=strupr(input) ; *ptr != NULL ; ptr++) {
               if (strchr(valhsk,*ptr) == NULL) {
                    prfmsg(INVBYT);
                    mjdpmt(ENTHST);
                    return;
               }
          }
          stzcpy(mjdedt.hskstg,input,HSKSTG);
          mjdaddd();
     }
}

static void
mjdchkm(void)                      /* check for application to modify      */
{
     int msg=EDTAPP;
     char *stg;

     if (strlen((stg=cncwrd())) > APPNSZ-1) {
          prfmsg(TOOLNG);
          msg=usrptr->substt;
     }
     else if (qeqbtv(strupr(stg),0)) {
          gcrbtv(&mjdedt,0);
     }
     else {
          cncall();
          prfmsg(NOSAPP);
          msg=usrptr->substt;
     }
     mjdpmt(msg);
}

static void
mjdedta(void)                      /* select an app option to be modified  */
{
     static int msgno[]={0,0,MODDSC,MODBCH,MODECH,MODKEY,
                         MODSUR,MODTIM,0,0,0,MODHMT,MODHST};
     char c;
     int opt,msg=EDTAPP;

     if ((c=toupper(morcnc())) == 'S') {
          cncchr();
          geqbtv(NULL,mjdedt.appname,0);
          updbtv(&mjdedt);
          mjdinu=-1;
          prfmsg(APPUPD);
          msg=INTPMT;
     }
     else if (c == '?') {
          cncchr();
     }
     else if ((opt=cncint()) > 0 && opt < 13) {
          if (((mjdedt.flags&MJDNOH) && (opt == 11 || opt == 12))
            || (mjdedt.hskmhd != 3 && opt == 12)) {
               cncall();
               prfmsg(CNOTIL);
               mjdpmt(EDTPMT);
               return;
          }
          if (msgno[opt] != 0) {
               msg=msgno[opt];
          }
          else {
               switch (opt) {
               case 1:
                    mjdedt.flags^=MJDDIS;
                    break;
               case 8:
                    mjdedt.flags^=MJDNOH;
                    if (mjdedt.flags&MJDNOH) {
                         mjdedt.hskmhd=1;
                         mjdedt.hskstg[0]='\0';
                    }
                    else {
                         msg=MODHMT;
                    }
                    break;
               case 9:
                    mjdedt.flags^=MJDCAB;
                    break;
               case 10:
                    mjdedt.flags^=MJDXCL;
                    break;
               }
          }
     }
     else {
          cncall();
          prfmsg(CNOTIL);
          msg=EDTPMT;
     }
     mjdpmt(msg);
}

static void
mjdedtd(void)                      /* modify application description       */
{
     if (morcnc() == '.') {
          cncall();
     }
     else {
          strcpy(mjdedt.appdesc,cncall());
     }
     mjdpmt(EDTPMT);
}

static void
mjdedtb(void)                      /* modify application first channel     */
{
     int begchn,msg=EDTPMT;

     if (morcnc() == '.') {
          cncall();
     }
     else if ((begchn=cnchex()) < 0 || begchn > 255) {
          cncall();
          prfmsg(INVHEX2);
          msg=usrptr->substt;
     }
     else if (begchn > mjdedt.endchn) {
          msg=usrptr->substt;
          cncall();
          prfmsg(LESHEX);
     }
     else {
          mjdedt.begchn=begchn;
     }
     mjdpmt(msg);
}

static void
mjdedte(void)                      /* modify application last channel      */
{
     int endchn,msg=EDTPMT;

     if (morcnc() == '.') {
          cncall();
     }
     else if ((endchn=cnchex()) < 0 || endchn > 255) {
          cncall();
          prfmsg(INVHEX2);
          msg=usrptr->substt;
     }
     else if (endchn < mjdedt.begchn) {
          msg=usrptr->substt;
          cncall();
          prfmsg(LESHEX);
     }
     else {
          mjdedt.endchn=endchn;
     }
     mjdpmt(msg);
}

static void
mjdedtk(void)                      /* modify key required to access app     */
{
     char c,*keyptr;
     int msg=EDTPMT;

     if ((c=morcnc()) == '.') {
          cncall();
     }
     else if (c == '~') {
          cncchr();
          mjdedt.keyreq[0]='\0';
     }
     else {
          keyptr=cncwrd();
          if (keynam(keyptr) == 1) {
               strcpy(mjdedt.keyreq,keyptr);
          }
          else {
               prfmsg(INVKEY);
               msg=usrptr->substt;
          }
     }
     mjdpmt(msg);
}

static void
mjdedts(void)                      /* modify surcharge for this app        */
{
     if (morcnc() == '.') {
          cncall();
     }
     else {
          mjdedt.surchg=atoi(cncall());
     }
     mjdpmt(EDTPMT);
}

static void
mjdedtt(void)                      /* modify time limit for this app       */
{
     int timlmt,msg=EDTPMT;
     char c;

     if ((c=morcnc()) == '.') {
          cncall();
     }
     else if (!isdigit(c)) {
          prfmsg(INVNUM);
          msg=MODTIM;
          cncall();
     }
     else {
          timlmt=cncint();
          if (timlmt > -1 && timlmt <= 1440) {
               mjdedt.timalw=timlmt;

          }
          else {
               prfmsg(INVTIM);
               msg=MODTIM;
          }
     }
     mjdpmt(msg);
}

static void
mjdedtm(void)                      /* modify handshaking parameter method  */
{
     int opt,msg=EDTAPP;

     if ((opt=cncint()) > 0 && opt < 4) {
          if ((mjdedt.hskmhd=opt) == 3) {
               msg=MODHST;
          }
     }
     else {
          cncall();
     }
     mjdpmt(msg);
}

static void
mjdedtp(void)                      /* validate new string to pass          */
{
     char *ptr;

     cncall();
     if (strlen(input) > HSKSTG-1) {
          prfmsg(INVHST,HSKSTG-1);
          mjdpmt(MODHST);
     }
     else {
          for (ptr=strupr(input) ; *ptr != NULL ; ptr++) {
               if (strchr(valhsk,*ptr) == NULL) {
                    prfmsg(INVBYT);
                    mjdpmt(MODHST);
                    return;
               }
          }
          stzcpy(mjdedt.hskstg,input,HSKSTG);
          mjdpmt(EDTAPP);
     }
}

static void
mjddela(void)                      /* check application before deletion    */
{
     int msg=DELRUS;
     char *stg;

     if (strlen((stg=cncwrd())) > APPNSZ-1) {
          prfmsg(TOOLNG);
          msg=usrptr->substt;
     }
     else if (qeqbtv(strupr(stg),0)) {
          gabbtv(&mjdedt,(mjdptr->fpos=absbtv()),0);
     }
     else {
          cncall();
          prfmsg(NOSAPP);
          msg=usrptr->substt;
     }
     mjdpmt(msg);
}

static void
mjddelr(void)                      /* confirm application deletion         */
{
     int usn;

     if (cncyesno() == 'Y') {
          if ((usn=mjdconfl(mjdptr->fpos,usrnum)) != -1) {
               prfmsg(CONFDEL,uacoff(usn)->userid);
          }
          else {
               gabbtv(NULL,mjdptr->fpos,0);
               delbtv();
               prfmsg(APPDEL);
          }
     }
     cncall();
     if (usrnum == mjdinu) {
          mjdinu=-1;
     }
     mjdpmt(INTPMT);
}

static void
mjdwchd(void)                      /* select Door to run                   */
{
     char *stg;
     int msg=WCHAPP;
     long creds,fpos;

     if (morcnc() == '?') {
          cncall();
          mjdlst(LSTENT);
          return;
     }
     strupr(stg=cncwrd());
     if (strlen(stg) > APPNSZ-1) {
          prfmsg(TOOLNG);
          msg=usrptr->substt;
     }
     else if (acqbtv(mjddsk,stg,0) && haskey(mjddsk->keyreq)) {
          fpos=absbtv();
          cncall();
          if (mjdavl(mjddsk)) {
               if (!(mjddsk->flags&MJDXCL) || (mjdconfl(fpos,-1) == -1)) {
                    creds=usrptr->crdrat+mjddsk->surchg;
                    if (creds <= 0L || tstcrd(creds)) {
                         if (mjdfpt(mjddsk,fpos)) {
                              return;
                         }
                         else {
                              prfmsg(NOCHNA);
                              msg=INTPMT;
                         }
                    }
                    else {
                         prfmsg(LKCRED);
                         msg=WCHAPP;
                    }
               }
               else {
                    prfmsg(DOORIN);
                    msg=WCHAPP;
               }
          }
          else {
               prfmsg(NOTAVL);
               msg=WCHAPP;
          }
     }
     else {
          cncall();
          prfmsg(NOSAPP);
          msg=WCHAPP;
     }
     mjdpmt(msg);
}


static void
mjdsttd(void)                      /* start talking to the link            */
{
     char *ptr,*hskptr;
     char stg[APPNSZ+10+80];

     btulok(usrnum,0);
     if (mjdptr->app.flags&MJDNOH) {
          mjdipst();
     }
     else{
          othuap=uacoff(mjdptr->othchn);
          sprintf(stg,"MBBS: %s %d",mjdptr->app.appname,mjdptr->app.hskmhd);
          switch (mjdptr->app.hskmhd) {
          case 2:
               strcat(stg," '");
               strcat(stg,othuap->userid);
               strcat(stg,"'");
               if (mjdptr->app.timalw == 0) {
                    strcat(stg,spr(" %d",32767));
               }
               else {
                    strcat(stg,spr(" %d",mjdptr->app.timalw));
               }
               if ((mjdptr->flags&MJDCSL) || (othuap->ansifl&ANSON)) {
                    strcat(stg," GR");
               }
               else {
                    strcat(stg," NG");
               }
               break;
          case 3:
               for (ptr=mjdptr->app.hskstg ; *ptr != '\0' ; ptr++) {
                    if ((hskptr=strchr(valhsk,*ptr)) != NULL) {
                         switch (*hskptr) {
                         case 'A':
                              if ((mjdptr->flags&MJDCSL) || (othuap->ansifl&ANSON)) {
                                   strcat(stg," GR");
                              }
                              else {
                                   strcat(stg," NG");
                              }
                              break;
                         case 'B':
                              strcat(stg," BAUD");
                              break;
                         case 'C':
                              strcat(stg," COM");
                              break;
                         case 'S':
                              strcat(stg," SHORT");
                              break;
                         case 'T':
                              strcat(stg," TIME=");
                              if (mjdptr->app.timalw == 0) {
                                   strcat(stg,spr("%d",32767));
                              }
                              else {
                                   strcat(stg,spr("%d",mjdptr->app.timalw));
                              }
                              break;
                         case 'U':
                              strcat(stg," '");
                              strcat(stg,othuap->userid);
                              strcat(stg,"'");
                              break;
                         }
                    }
               }
               break;
          }
          strcat(stg,"\r");
          btuxmt(usrnum,stg);
          mjdptr->wttime=DOORSECS;
          usrptr->substt=RSPPND;
     }
}

static void
mjdrtk(void)                       /* once a second rtkick - multi-purpose */
{
     struct mjdusr *mjdoth;
     struct user *ousp;
     int ousr;
     long creds;

     setmbk(mjdmb);
     for (ousr=0 ; ousr < nterms ; ousr++) {
          ousp=&user[ousr];
          if (ousp->state == mjdstt) {
               mjdoth=mjdarr(ousr);
               if (ousp->substt == BYTPST && !(mjdoth->flags&MJDLNK)
                 && (creds=ousp->crdrat+mjdoth->app.surchg) > 0L) {
                    if (!otstcrd(ousr,creds,0)) {
                         curusr(ousr);
                         mjdhtrm(OUTCRD2);
                         continue;
                    }
               }
               if (mjdoth->discnt == 0 || mjdoth->discnt > 3) {
                    mjdoth->discnt=mjdoth->distmr=0;
               }
               else {
                    mjdoth->distmr++;
               }
               if (mjdoth->discnt < 3 && mjdoth->distmr > 2) {
                    mjdoth->discnt=mjdoth->distmr=0;
               }
               else if (mjdoth->discnt == 3 && mjdoth->distmr > 3) {
                    mjdoth->discnt=mjdoth->distmr=0;
                    curusr(ousr);
                    mjdhtrm(APPTRM2);
               }
               if (ousp->substt == RSPPND) {
                    if (mjdoth->wttime > 0) {
                         if (--mjdoth->wttime == 0) {
                              if (mjdoth->flags&MJDCSL) {
                                   curusr(othusn=mjdoth->othchn);
                                   prfmsg(TIMOUT);
                                   injoth();
                              }
                              else {
                                   curusr(mjdoth->othchn);
                                   mjdcon(TIMOUT);
                              }
                              curusr(ousr);
                              mjdrsvp();
                         }
                    }
               }
               if (ousp->substt == WT4PAU) {
                    if (--mjdoth->w4rst == 0) {
                         btulok(ousr,0);
                         ousp->substt=WT4SEL;
                    }
               }
               if (kilipg == 1 && kilctr == -1
                 && (ousp->substt == WT4SEL || ousp->substt == WT4PAU)) {
                    curusr(ousr);
                    rstchn();
               }
          }
     }
     rtkick(1,mjdrtk);
}

static void
mjdaddd(void)                      /* add Door to database                 */
{

     mjdedt.flags|=MJDCAB;
     insbtv(&mjdedt);
     prfmsg(THEAPP1,mjdedt.appname,mjdedt.appdesc,spr("%X",mjdedt.begchn),
                    spr("%X",mjdedt.endchn),
                    mjdedt.keyreq[0] == '\0' ? "<none>" : mjdedt.keyreq,
                    mjdedt.surchg,
                    mjdedt.timalw == 0 ? "<no limit>"
                                       : spr("%d minute(s)",mjdedt.timalw),
                    (mjdedt.flags&MJDNOH) ? "No" : "Yes",
                    (mjdedt.flags&MJDNOH) ? ""
                                          : spr("(%s)",passtg[mjdedt.hskmhd]));

     mjdinu=-1;
     btumil(usrnum,DFTIMX);
     mjdpmt(INTRO);
}

static BOOL                        /*   returns success/failure            */
mjdfpt(                            /* find and sieze port for app          */
struct mjdapps *app,               /*   app being used                     */
long fpos)                         /*   abspos of door's btv record        */
{
     int chn,unum;
     unsigned long flags;

     for (chn=app->begchn ; chn <= app->endchn ; chn++) {
          if ((othusn=usridx(chn)) != -1) {
               othusp=&user[othusn];
               if ((othusp->class == BBSPRV && othusp->state == mjdstt
                 && othusp->substt == WT4SEL)
                 || (othusp->class == VACANT && (othusp->flags&ISRIAL)
                 && othusp->state == AWAITC && !(othusp->flags&NOHDWE))
                 || (othusp->class == VACANT && (othusp->flags&IS2698)
                 && othusp->state == AWAITC && !(othusp->flags&NOHDWE)
                 && (app->flags&MJDNOH) && haskey(sysapp))) {
                    strcpy(mjdptr->app.appname,app->appname);
                    mjdptr->othchn=othusn;
                    mjdptr->fpos=fpos;
                    unum=usrnum;
                    curusr(othusn);
                    flags=usrptr->flags;
                    rstchn();
                    usrptr->flags=(flags|NOZAP|NOINJO);
                    usrptr->class=BBSPRV;
                    usrptr->state=mjdstt;
                    usrptr->substt=RSTING;
                    setmem(mjdptr,sizeof(struct mjdusr),0);
                    mjdptr->flags|=MJDLNK;
                    mjdptr->othchn=unum;
                    movmem(app,&(mjdptr->app),sizeof(struct mjdapps));
                    shochl(spr("Opening Door for channel %02X",channel[unum]),
                           'O',baudat(usrptr->baud,0));
                    curusr(unum);
                    btulok(usrnum,1);
                    btucli(usrnum);
                    mjdpmt(WT4APP);
                    return(TRUE);
               }
          }
     }
     return(FALSE);
}

static int
mjdvalc(                           /* is application character valid       */
int c)
{
     return(strchr(vlddos,c) != NULL);
}

static int
mjdavl(                            /* is application online?               */
struct mjdapps *aptr)
{
     return((!(aptr->flags&MJDDIS) || haskey(sysapp)) && haskey(aptr->keyreq));
}

static void
mjddsp(                            /* display 1 application listing        */
struct mjdapps *aptr)
{
     if (!mjdptr->cntd) {
          prfmsg(APPHDR);
          mjdptr->cntd=1;
     }
     prfmsg(APPDET,aptr->appname,aptr->appdesc,
                   aptr->surchg,(aptr->flags&MJDDIS) ? "(offline)" : "");
}

static int
mjdved(void)                       /* Is user allowed into apps editor     */
{
     if (haskey(sysapp)) {
          if (mjdinu > -1) {
               cncall();
               prfmsg(EDTINU);
               mjdpmt(usrptr->substt);
               return(0);
          }
          mjdinu=usrnum;
          return(1);
     }
     cncall();
     prfmsg(CNOTIL);
     mjdpmt(usrptr->substt);
     return(0);
}

static void
mjdrsvp(void)                      /* resetting link & host w/poss reserve */
{
     unsigned long flags;

     if (mjdptr->flags&MJDCSL) {
          if (mjdptr->ses != NULL) {
               mjdptr->ses->app[0]='\0';
          }
     }
     else {
          mjdarr(mjdptr->othchn)->app.appname[0]='\0';
          mjdarr(mjdptr->othchn)->fpos=0L;
     }
     flags=usrptr->flags;
     rstchn();
     setmem(mjdptr,sizeof(struct mjdusr),0);
     if (rlsprt || kilipg || !(flags&ISRIAL)) {
          return;
     }
     usrptr->flags=(flags|NOZAP|NOINJO);
     usrptr->class=BBSPRV;
     usrptr->state=mjdstt;
     usrptr->substt=WT4RST;
     btuclo(usrnum);
     shochl("Door Reserved Channel",'R',baudat(usrptr->baud,0));
     mjdptr->flags|=MJDLNK;
}

static void
mjdrpm(                            /* reprompt for specified usrnum        */
int news)                          /* (no parameters allowed for prfmsg()) */
{
     if (isripu()) {
          if (news == INTPMT) {
               news=INTRO;
          }
          else if (news == INTPMTS) {
               news=INTROS;
          }
     }
     prfmsg(user[usrnum].substt=news);
     mjdarr(usrnum)->dftinp=getdft();
     outprf(usrnum);
}

static void
mjdpmt(                            /* prompt user and set substate         */
int news)
{
     int hiopt;

     if (isripu()) {
          switch (news) {
          case INTPMT:
               news=INTRO;
               break;
          case INTPMTS:
               news=INTROS;
               break;
          case EDTPMT:
               news=EDTAPP;
          }
     }
     usrptr->substt=news;
     if (!morcnc()) {
          switch(usrptr->substt) {
          case INTRO:
               condex();
               if (haskey(sysapp)) {
                    usrptr->substt=INTROS;
               }
               prfmsg(usrptr->substt);
               break;
          case INTPMT:
               condex();
               if (haskey(sysapp)) {
                    usrptr->substt=INTPMTS;
               }
               prfmsg(usrptr->substt);
               break;
          case ENTAPP:
          case MODAPP:
          case DELAPP:
          case WCHAPP:
               btumil(usrnum,APPNSZ-1);
               prfmsg(news);
               break;
          case ENTDSC:
          case MODDSC:
               btumil(usrnum,APPDSC-1);
               prfmsg(news);
               break;
          case ENTKEY:
          case MODKEY:
               btumil(usrnum,KEYSIZ-1);
               prfmsg(news);
               break;
          case ENTHST:
          case MODHST:
               btumil(usrnum,HSKSTG-1);
               prfmsg(news);
               break;
          case EDTAPP:
               btumil(usrnum,DFTIMX);
               prfmsg(news,mjdedt.appname,
                          (mjdedt.flags&MJDDIS) ? "Offline" : "Available",
                           mjdedt.appdesc,
                           spr("%X",mjdedt.begchn),
                           spr("%X",mjdedt.endchn),
                           mjdedt.keyreq[0] == '\0' ? "<none>" : mjdedt.keyreq,
                           mjdedt.surchg,
                           mjdedt.timalw == 0 ? "<no limit>"
                                              : spr("%d minute(s)",mjdedt.timalw),
                          (mjdedt.flags&MJDNOH) ? "Disabled" : "Enabled",
                          (mjdedt.flags&MJDCAB) ? "Enabled" : "Disabled",
                          (mjdedt.flags&MJDXCL) ? "Yes" : "No");
               if (!(mjdedt.flags&MJDNOH)) {
                    prfmsg(EDTAPP1,passtg[mjdedt.hskmhd]);
                    if (mjdedt.hskmhd == 3) {
                         prfmsg(EDTAPP2,mjdedt.hskstg);
                    }
               }
               prfmsg(EDTFTR);
               break;
          case EDTPMT:
               btumil(usrnum,DFTIMX);
               if (mjdedt.flags&MJDNOH) {
                    hiopt=10;
               }
               else if (mjdedt.hskmhd != 3) {
                    hiopt=11;
               }
               else {
                    hiopt=12;
               }
               prfmsg(news,hiopt);
               break;
          case DELRUS:
               btumil(usrnum,DFTIMX);
               prfmsg(news,mjdedt.appname);
               break;
          default:
               btumil(usrnum,DFTIMX);
               prfmsg(news);
          }
          mjdptr->dftinp=getdft();
     }
}

static int                         /*   returns usrnum of user in door or-1*/
mjdconfl(                          /* is door in use?                      */
long fpos,                         /*   btrieve abspos() of door's record  */
int unum)                          /*   usrnum to exclude (A/A), -1==none  */
{
     int oth;
     struct user *op;
     int ureq,sreq;
     struct mjdses *mses;

     for (oth=0,op=user ; oth < nterms ; oth++,op++) {
          if (op->class > SUPIPG) {
               if (op->flags&ISGCSU) {
                    for (ureq=0 ; ureq < MAXREQS ; ureq++) {
                         sreq=srvrqid(oth,ureq);
                         if (ismyreq(sreq,"GALMJD")) {
                              mses=(struct mjdses *)mrqoff(sreq);
                              if (mses->reqtyp == MJDSES
                               && fpos == mses->fpos) {
                                   return(oth);
                              }
                         }
                    }
               }
               else if (oth != unum
                     && op->state == mjdstt
                     && fpos == mjdarr(oth)->fpos) {
                    return(oth);
               }
          }
     }
     return(-1);
}

static void
mjdcon(                            /* perform condex exit or reprompt      */
int msg)
{
     prfmsg(msg);
     if (usrptr->flags&CONCEX) {
          outprf(usrnum);
          usrptr->substt=GETOUT;
          btulok(usrnum,1);
          btucli(usrnum);
          btuinj(usrnum,CRSTG);
     }
     else {
          mjdrpm(haskey(sysapp) ? INTPMTS : INTPMT);
          btulok(usrnum,0);
     }
}

static void
mjdhtrm(                           /* host terminating the link session    */
int msg)
{
     int unum;

     unum=usrnum;
     curusr(mjdptr->othchn);
     mjdtrml(unum,1,msg);
}

static void
mjdtrml(                           /* low level terminate link             */
int unum,
int rsv,
int msg)
{
     if (rsv) {
          mjdrsvp();
     }
     else {
          rstchn();
     }
     curusr(unum);
     if (!(usrptr->flags&ISGCSU)) {
          btutrg(usrnum,0);
          btucli(usrnum);
          btuclo(usrnum);
          mjdcon(msg);
          usrptr->flags&=~NOINJO;
          usrptr->crdrat=mmucrr;
     }
}

static void
mjdhwt(                            /* handle disconnecting link on hangup  */
int other)
{
     int othchn;

     othchn=usrnum;
     curusr(other);
     mjdrsvp();
     curusr(othchn);
}

static void
mjdthn(void)                       /* Doors status handler                 */
{
     static int indfst=0;
     int iba,oba,xfrbyts,bytred;
     int othchn;
     char *ptr;
     int cnt;
     int holdusn,unum,lnum;
     struct mjdusr *mjdoth;

     setmbk(mjdmb);
     setbtv(mjdbb);
     switch (status) {
     case CYCLE:
          if (usrptr->state == mjdstt) {
               if (usrptr->substt == BYTPST) {
                    if (mjdptr->flags&MJDCSL) {
                         if (mjdptr->ses != NULL
                          && mjdptr->ses->state == BYTPST) {
                              xfrbyts=btuibw(usrnum);
                              if (xfrbyts > MAXDPKV) {
                                   xfrbyts=MAXDPKV;
                              }
                              if (xfrbyts > 0 && vtmsndok(mjdptr->othchn)) {
                                   bytred=btuica(usrnum,xfrbuf,xfrbyts);
                                   vtmsend(mjdptr->ses->hwnd,bytred,xfrbuf);
                              }
                              else {
                                   actdet=0;
                              }
                         }
                    }
                    else {
                         iba=btuibw(usrnum);
                         oba=btuoba(othchn=mjdptr->othchn);
                         xfrbyts=min(iba,oba);
                         if (xfrbyts <= 0) {
                              btuinj(usrnum,CYCLE);
                              actdet=0;
                              return;
                         }
                         bytred=btuica(usrnum,xfrbuf,xfrbyts);
                         mjdoth=mjdarr(mjdptr->othchn);
                         if (!(mjdptr->flags&MJDLNK) && (mjdoth->app.flags&MJDCAB)) {
                              for (ptr=xfrbuf,cnt=0 ; cnt < bytred ; ptr++,cnt++) {
                                   if (*ptr == dischr && dischr != ' ') {
                                        mjdptr->discnt++;
                                   }
                                   else {
                                        mjdptr->discnt=0;
                                   }
                              }
                         }
                         btuxct(othchn,bytred,xfrbuf);
                    }
                    btuinj(usrnum,CYCLE);
               }
               else if (usrptr->substt == LSTING || usrptr->substt == LSTENT) {
                    if (btuoba(usrnum) > OUTSIZ-160) {
                         gabbtv(mjddsk,mjdptr->fpos,0);
                         if (qnxbtv()) {
                              gabbtv(mjddsk,(mjdptr->fpos=absbtv()),0);
                              if (mjdavl(mjddsk)) {
                                   mjddsp(mjddsk);
                                   outprf(usrnum);
                              }
                         }
                         else {
                              if (usrptr->substt == LSTENT) {
                                   if (isripu()) {
                                        prfmsg(ENDLST);
                                   }
                                   prfmsg(usrptr->substt=WCHAPP);
                              }
                              else {
                                   prfmsg(mjdptr->cntd ? ENDLST : NONAVL);
                                   usrptr->substt=haskey(sysapp)
                                                  ? (isripu() ? INTROS : INTPMTS)
                                                  : (isripu() ? INTRO : INTPMT);
                                   prfmsg(usrptr->substt);
                              }
                              mjdptr->fpos=0L;
                              mjdptr->dftinp=getdft();
                              outprf(usrnum);
                              return;
                         }
                    }
                    else {
                         actdet=0;
                    }
                    btuinj(usrnum,CYCLE);
               }
          }
          break;
     case RING:
     case LOST2C:
     case 254:
     case 255:
          switch (usrptr->substt) {
          case WT4APP:
               mjdhwt(mjdptr->othchn);
               dfsthn();
               break;
          case RSPPND:
               if (mjdptr->flags&MJDCSL) {
                    mjdptr->ses->app[0]='\0';
                    rstchn();
                    setmem(mjdptr,sizeof(struct mjdusr),0);
               }
               else {
                    holdusn=usrnum;
                    othchn=mjdptr->othchn;
                    mjdarr(othchn)->app.appname[0]='\0';
                    mjdarr(othchn)->fpos=0L;
                    rstchn();
                    setmem(mjdptr,sizeof(struct mjdusr),0);
                    curusr(othchn);
                    btulok(usrnum,0);
                    prfmsg(INVRSP);
                    mjdrpm(haskey(sysapp) ? INTPMTS : INTPMT);
                    curusr(holdusn);
               }
               break;
          case BYTPST:
               if (mjdptr->flags&MJDLNK) {
                    lnum=usrnum;
                    unum=mjdptr->othchn;
                    mjdtrml(unum,status == LOST2C ? 1 : 0,APPTRM2);
                    curusr(lnum);
               }
               else {
                    mjdhtrm(APPTRM2);
                    dfsthn();
               }
               break;
          case WT4RST:
          case WT4PAU:
               rstchn();
               break;
          case WT4SEL:
               if (status != LOST2C) {
                    rstchn();
               }
               break;
          default:
               if (!indfst) {
                    indfst=1;
                    dfsthn();
               }
               indfst=0;
          }
          break;
     case CMN2OK:
          if (usrptr->substt == WT4RST) {
               usrptr->substt=WT4PAU;
               mjdptr->w4rst=15;
               break;
          }
          else if ((mjdptr->flags&MJDLNK) && usrptr->substt == RSTING) {
               mjdsttd();
          }
     default:
          if (!indfst) {
               indfst=1;
               dfsthn();
          }
          indfst=0;
     }
}

static void
mjdhup(void)                       /* Doors hang up handler                */
{
     if (mjdptr->flags&MJDLNK) {
          return;
     }
     if (usrptr->state == mjdstt) {
          switch (usrptr->substt) {
          case WT4APP:
          case BYTPST:
               mjdhwt(mjdptr->othchn);
          }
          setmem(mjdptr,sizeof(struct mjdusr),0);
     }
     if (usrnum == mjdinu) {
          mjdinu=-1;
     }
}

static void
mjdfin(void)                       /* shutdown Doors module                */
{
     clsbtv(mjdbb);
     clsmsg(mjdmb);
}

/* BEGIN C/S AGENT FUNCTIONS */

static void
init_cslib(void)                   /* initialize Doors for C/S mode        */
{
     mjdakey=stgopt(MJDAKEY);
     dclmrq(max(sizeof(struct mjdlst),sizeof(struct mjdses)));
     register_agent(&mjdagt);
}

static void
mjdread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg;

     if (stdchk(mjdakey)) {
          *namtmp=*dpknam;
          dpkstg=cnvs2d(namtmp);
          if (samepato("sau:doorinfo",dpkstg)) {
               ml=(struct mjdlst *)mrqptr;
               ml->reqtyp=MJDLST;
               stlcpy(ml->suffix,dpknam->suffix,SFXSIZ);
               cycleme(csdinfo);
               csdinfo();
               return;
          }
          if (direction == 0) {
               setmbk(mjdmb);
               if (samepato("sau:door ",dpkstg)) {
                    inidoor();
                    return;
               }
               if (samepat("sau:prefs",dpkstg)) {
                    strcpy(rsptmp,getmsg(MJDCSCAP));
                    strcat(rsptmp,"\t");
                    strcat(rsptmp,getmsg(MJDCSCRD));
                    strcat(rsptmp,"\t");
                    strcat(rsptmp,getmsg(MJDCSOFF));
                    strcat(rsptmp,"\t");
                    strcat(rsptmp,haskey(sysapp) ? "1" : "0");
                    strcat(rsptmp,"\t");
                    strcat(rsptmp,addlf(getmsg(WT4APP)));
                    strcat(rsptmp,"\t");
                    rsp2read(NULL,strlen(rsptmp),rsptmp);
                    return;
               }
          }
     }
     rejectreq();
}

static void
mjdwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *dpkstg,*s;
     struct mjdapps *m;
     BOOL exists;
     int usn;

     *namtmp=*dpknam;
     dpkstg=cnvs2d(namtmp);
     if (stdchk(mjdakey)) {
          if (samepato("sau:door ",dpkstg)) {
               snd2door(atoi(lastwd(namtmp->suffix)),length,value);
               return;
          }
          if (samepato("sau:doorinfo ",dpkstg) & haskey(sysapp)) {
               m=(struct mjdapps *)mjdbb->data;
               s=skpwht(skpwrd(namtmp->suffix));
               setmbk(mjdmb);
               setbtv(mjdbb);
               exists=acqbtv(m,s,0);
               if (length == 0) { /* delete operation */
                    if (exists) {
                         if ((usn=mjdconfl(absbtv(),-1)) != -1) {
                              prfmsg(CONFDEL,uacoff(usn)->userid);
                              r2wprf(FALSE);
                         }
                         else {
                              delbtv();
                              prfmsg(APPDEL);
                              r2wprf(TRUE);
                         }
                    }
                    else {
                         prfmsg(NOSAPP);
                         r2wprf(TRUE); /* intentional */
                    }
               }
               else {
                    vb2aps(value,m);
                    if (!vfystr(m)) {
                         r2wprf(FALSE);
                    }
                    else {
                         if (exists) { /* modify */
                              updbtv(m);
                              prfmsg(APPUPD);
                         }
                         else { /* create */
                              insbtv(m);
                              prfmsg(APPADD);
                         }
                         r2wprf(TRUE);
                    }
               }
               return;
          }
     }
     rejectreq();
}

static void
mjdabort(void)                     /* dynapak abort routine                */
{
     ms=(struct mjdses *)mrqptr;
     if (ms->surchg != 0) {
          usrptr->crdrat-=ms->surchg;
          ms->surchg=0;
     }
     if (ms->reqtyp != MJDSES) {
          return;
     }
     switch (ms->state) {
     case WT4APP:
     case BYTPST:
          mjdhwt(ms->othchn);
     }
}

static unsigned int                /*   returns size of vba for VB         */
aps2vb(                            /* copy structures mjdapps to vbmjdapps */
struct mjdapps *aps,               /*   (from) mjdapps structure           */
struct vbmjdapps *vba)             /*   (to) vbmjdapps structure           */
{
     vba->begchn=aps->begchn;
     vba->endchn=aps->endchn;
     vba->flags=aps->flags;
     vba->surchg=aps->surchg;
     vba->hskmhd=aps->hskmhd;
     vba->timalw=aps->timalw;
     sprintf(vba->ndkh,"%s\t%s\t%s\t%s\t",
                       aps->appname,aps->appdesc,aps->keyreq,aps->hskstg);
     ASSERT(strlen(vba->ndkh) < APPNSZ+APPDSC+KEYSIZ+HSKSTG);
     return(sizeof(struct vbmjdapps)
           -(APPNSZ+APPDSC+KEYSIZ+HSKSTG)
           +strlen(vba->ndkh));
}

static void
vb2aps(                            /* copy structures vbmjdapps to mjdapps */
struct vbmjdapps *vba,             /*   (from) vbmjdapps structure         */
struct mjdapps *aps)               /*   (to) mjdapps structure             */
{
     aps->begchn=vba->begchn;
     aps->endchn=vba->endchn;
     aps->flags=vba->flags;
     aps->surchg=vba->surchg;
     aps->hskmhd=vba->hskmhd;
     aps->timalw=vba->timalw;
     stzcpy(aps->appname,itemidx(vba->ndkh,0),APPNSZ);
     stzcpy(aps->appdesc,itemidx(vba->ndkh,1),APPDSC);
     stzcpy(aps->keyreq,itemidx(vba->ndkh,2),KEYSIZ);
     stzcpy(aps->hskstg,itemidx(vba->ndkh,3),HSKSTG);
}

static BOOL                        /*   returns FALSE if no good           */
vfystr(                            /* verify structure, prfmsg errors      */
struct mjdapps *aps)               /*   mjdapps structure                  */
{
     char *ptr;

     strupr(aps->appname);
     strupr(aps->hskstg);
     if (aps->begchn < 0 || aps->begchn > 255
      || aps->endchn < 0 || aps->endchn > 255) {
          prfmsg(INVHEX2);
          return(FALSE);
     }
     if (aps->endchn < aps->begchn) {
          prfmsg(LESHEX);
          return(FALSE);
     }
     if (!sameas(firstwd(aps->appname),aps->appname)) {
          prfmsg(ONEWRD);
          return(FALSE);
     }
     for (ptr=aps->appname ; *ptr != '\0' ; ptr++) {
          if (!mjdvalc(*ptr)) {
               prfmsg(INVCHR);
               return(FALSE);
          }
     }
     if (aps->keyreq[0] != '\0' && keynam(aps->keyreq) == 0) {
          prfmsg(INVKEY);
          return(FALSE);
     }
     if (aps->timalw < 0 || aps->timalw > 1440) {
          prfmsg(INVTIM);
          return(FALSE);
     }
     for (ptr=aps->hskstg ; *ptr != NULL ; ptr++) {
          if (strchr(valhsk,*ptr) == NULL) {
               prfmsg(INVBYT);
               return(FALSE);
          }
     }
     return(TRUE);
}

static void
csdinfo(void)                      /* return info on doors                 */
{
     char *s;
     BOOL got=FALSE;
     struct mjdapps *m;
     struct vbmjdapps *v;
     unsigned int len;

     ml=(struct mjdlst *)mrqptr;
     if (sameas(firstwd(ml->suffix),"doorinfo")) {
          v=(struct vbmjdapps *)rsptmp;
          m=(struct mjdapps *)mjdbb->data;
          s=skpwht(skpwrd(ml->suffix));
          setbtv(mjdbb);
          switch (rqdptr->direction) {
          case 0:
               got=acqbtv(m,s,0);
               break;
          case 1:
               got=agtbtv(m,s,0);
               break;
          case -1:
               got=altbtv(m,s,0);
               break;
          }
          rstbtv();
          if (got) {
               strcpy(s,m->appname);
               if (haskey(m->keyreq)) {
                    len=aps2vb(m,v);
                    *namtmp=rqdptr->saunam;
                    strcpy(namtmp->suffix,ml->suffix);
                    rsp2read(namtmp,len,v);
                    return;
               }
               else if (rqdptr->direction != 0) {
                    /* keep cycling */
                    return;
               }
          }
     }
     rejectreq();
}

static void
inidoor(void)                      /* begin door for c/s                   */
{                                  /*   namtmp implicit                    */
     char app[APPNSZ];
     long creds,fpos;

     ms=(struct mjdses *)mrqptr;
     ms->reqtyp=MJDSES;
     stzcpy(app,firstwd(skpwht(skpwrd(namtmp->suffix))),APPNSZ);
     ms->hwnd=atoi(nextwd());
     setbtv(mjdbb);
     if (acqbtv(mjddsk,app,0) && haskey(mjddsk->keyreq)) {
          fpos=absbtv();
          if (mjdavl(mjddsk)) {
               if (!(mjddsk->flags&MJDXCL) || (mjdconfl(fpos,-1) == -1)) {
                    creds=usrptr->crdrat+mjddsk->surchg;
                    if (creds <= 0L || tstcrd(creds)) {
                         if (csmjdfpt(mjddsk,fpos)) {
                              cycleme(csses);
                              return;
                         }
                         else {
                              prfmsg(NOCHNA);
                         }
                    }
                    else {
                         prfmsg(LKCRED);
                    }
               }
               else {
                    prfmsg(DOORIN);
               }
          }
          else {
               prfmsg(NOTAVL);
          }
     }
     else {
          prfmsg(NOSAPP);
     }
     rejectreq();
     othusn=usrnum;
     injoth();
}

static BOOL                        /*   returns success/failure            */
csmjdfpt(                          /* find and sieze port for app          */
struct mjdapps *app,               /*   app being used                     */
long fpos)                         /*   abspos of door's btv record        */
{
     int chn,unum;
     unsigned long flags;

     for (chn=app->begchn ; chn <= app->endchn ; chn++) {
          if ((othusn=usridx(chn)) != -1) {
               othusp=&user[othusn];
               if ((othusp->class == BBSPRV && othusp->state == mjdstt
                 && othusp->substt == WT4SEL)
                 || (othusp->class == VACANT && (othusp->flags&ISRIAL)
                 && othusp->state == AWAITC && !(othusp->flags&NOHDWE))
                 || (othusp->class == VACANT && (othusp->flags&IS2698)
                 && othusp->state == AWAITC && !(othusp->flags&NOHDWE)
                 && (app->flags&MJDNOH) && haskey(sysapp))) {
                    ms->fpos=fpos;
                    strcpy(ms->app,app->appname);
                    ms->othchn=othusn;
                    unum=usrnum;
                    curusr(othusn);
                    flags=usrptr->flags;
                    rstchn();
                    usrptr->flags=(flags|NOZAP|NOINJO);
                    usrptr->class=BBSPRV;
                    usrptr->state=mjdstt;
                    usrptr->substt=RSTING;
                    setmem(mjdptr,sizeof(struct mjdusr),0);
                    mjdptr->flags|=MJDLNK;
                    mjdptr->flags|=MJDCSL;
                    mjdptr->othchn=unum;
                    mjdptr->ses=ms;
                    movmem(app,&(mjdptr->app),sizeof(struct mjdapps));
                    shochl(spr("Opening Door for channel %02X",channel[unum]),
                           'O',baudat(usrptr->baud,0));
                    curusr(unum);
                    ms->state=WT4APP;
                    return(TRUE);
               }
          }
     }
     return(FALSE);
}

static void
csses(void)                        /* session cycle routine                */
{
     long creds;
     int rqid;

     rqid=greqid;
     ms=(struct mjdses *)mrqptr;
     creds=usrptr->crdrat+ms->surchg;
     if (creds > 0L) {
          if (!tstcrd(creds)) {
               othusn=usrnum;
               setmbk(mjdmb);
               prfmsg(OUTCRD2);
               injoth();
               curusr(ms->othchn);
               mjdrsvp(); /* will set ms->app[0]='\0' */
               curreq(rqid);
          }
     }
     if (ms->app[0] == '\0') {
          if (ms->surchg != 0) {
               usrptr->crdrat-=ms->surchg;
               ms->surchg=0;
          }
          rejectreq();
     }
}

static void
snd2door(
int hwnd,
int length,
char *value)
{
     int i,oldid,s,oc,oba;

     for (i=0 ; i < MAXREQS ; i++) {
          s=srvrqid(usrnum,i);
          if (greqid != s && ismyreq(s,"GALMJD")) {
               oldid=greqid;
               curreq(s);
               ms=(struct mjdses *)mrqptr;
               if (ms->reqtyp == MJDSES && ms->hwnd == hwnd) {
                    oc=ms->othchn;
                    curreq(oldid);
                    if (oc >= 0 && oc <= nterms) {
                         if (mjdarr(oc)->othchn == usrnum
                          && user[oc].state == mjdstt
                          && user[oc].substt == BYTPST) {
                              oba=btuoba(oc);
                              btuxct(oc,min(oba,length),value);
                              rsp2write(TRUE,0,NULL);
                              return;
                         }
                    }
                    break;
               }
               curreq(oldid);
          }
     }
     rejectreq();
}

static char *
addlf(                             /* adds line feeds after C/Rs           */
char *txtbuf)
{
     char *ptr=txtbuf;

     while ((ptr=strchr(ptr,'\r')) != NULL) {
          ptr++;
          movmem(ptr,ptr+1,strlen(ptr)+1);
          *ptr='\n';
     }
     return(txtbuf);
}

/* END C/S AGENT FUNCTIONS */
