/***************************************************************************
 *                                                                         *
 *   GALDEBUG.C                                                            *
 *                                                                         *
 *   Copyright (c) 1995-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Collection of debugging facilities for Worldgroup baseline            *
 *                                                                         *
 *   This module should always be compiled in DEBUG mode.                  *
 *                                                                         *
 *                                  - R. Stein & D. Pitchford 1/28/95      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "remote.h"
#include "phasedbg.h"
#include "galdebug.h"

#ifndef DEBUG
#error GALDEBUG.C should always be compiled in DEBUG mode
#endif

#if (__TURBOC__ >= 0x0400)
#define STKPT1 22
#define STKPT2 36
#else
#define STKPT1 19
#define STKPT2 33
#endif

void EXPORT init__debug(void);
void begdbg(char *name,long num);
void enddbg(char *name,long num);
void rtidbg(void);
void dbgfin(void);
void rtidbg(void);
void ckmodl(void);
void vdagpr(char *rfname);
void heapchk(void);
int selchk(unsigned sel);
int dmyinp(void);
void locinf(int *loc,int x,int y);
void phsinf(int x,int y);
void sflinf(int x,int y);
void imrinf(int x,int y);
void splacem(int x,int y,int *words,int gnum,int num);
void splacen(int x,int y,char *stg,int limit);
void splace(int x,int y,char *stg);
char *hexa(int u);
char *hexc(char c);

FILE *dbgmb;                            /*---- options in GALDEBUG.MSG ----*/
char dbgxadr;                           /* display execution address?      */
int dbgxslw;                            /* slowness factor                 */
char dbgxphs;                           /* phase information display?      */
char dbgximr;                           /* IMR contents display?           */
char dbgmod;                            /* check module array?             */
char dbgheap;                           /* check for heap corruption?      */
char dbgvda;                            /* record VDA in GALGPVDA.NNN?     */

void (*oldbph)(char *name,long num);    /* record old BEG_PHASE vector     */
void (*oldeph)(char *name,long num);    /* record old END_PHASE vector     */
char *pscreen;
static char hexs[]="0123456789ABCDEF";  /* for reentrant hex formatting    */
int yat;                                /* y location of location display  */
int drib=0;                             /* to implement display slowness   */

#define RPTFILE "GALHEAP.TXT"      /* file for HEAP ERROR reports          */
#define BINFILE "GALHEAP.*"        /* file for binary copy of bad heap seg */
#define GPVDAFILE "GALGPVDA.*"     /* file for VDA contents                */
char binfile[20];                  /* actual (unique) name of binary file  */
FILE *rfp,*bfp;                    /* file handles for above               */
int crash=0;                       /* detect double heap crash             */

void (*oldfin)();                  /* old value of module[0]->finrou       */
void (*oldgpr)(char *);            /* old value of (*hdlgpr)()             */

extern unsigned __base;            /* first selector of heap               */
extern unsigned __top;             /* last selector of heap (inclusive)    */
extern unsigned __hincr;           /* increment between heap selectors     */

struct freehdr {                   /* free block intrusion into data area  */
     unsigned prev;                /* previous free block \ doubly linked  */
     unsigned next;                /* next free block     / free list      */
};

union vblpart {                    /* variable portion of heap block       */
     struct freehdr f;             /* free-list info when block is free    */
     char data[1];                 /* usable data area of allocated block  */
};

struct heapblock {                 /* block of memory in the heap          */
     unsigned size;                /* even=free size, odd=allocated size+1 */
     unsigned prev_real;           /* singly linked list of all blocks     */
     union vblpart x;              /* variable part of heap block          */
};

#define MAXBLKS 8192               /* max possible heap blocks per 64K seg */

struct module dmymodule={          /* dummy module (NEVER REGISTERED)      */
     "",                           /*    name used to refer to this module */
     NULL,                         /*    user logon supplemental routine   */
     dmyinp,                       /*    input routine if selected         */
     dfsthn,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     NULL,                         /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     NULL                          /*    finish-up (sys shutdown) routine  */
};

void EXPORT
init__debug(void)                       /* debug initialization            */
{
     dbgmb=opnmsg("galdebug.mcv");
     astmode=tokopt(DBGASTH,"IGNORE","REPORT","CRASH",NULL);
     if (astmode == ASTRPT) {
          astrptfil=stgopt(DBGASTF);
     }
     dbgxadr=ynopt(DBGXADR);
     dbgxslw=numopt(DBGXSLW,1,100);
     dbgxphs=ynopt(DBGXPHS);
     dbgximr=ynopt(DBGXIMR);
     dbgmod=ynopt(DBGMOD);
     dbgvda=ynopt(DBGVDA);
     if (tokopt(DBGXAUX,"AUX",NULL) == 1) {
          pscreen=auxcrt();
          yat=19;
     }
     else {
          pscreen=frzseg();
          unfrez();
          yat=0;
     }
     oldbph=beg_phase;
     beg_phase=begdbg;
     oldeph=end_phase;
     end_phase=enddbg;
     oldfin=module[0]->finrou;
     module[0]->finrou=dbgfin;
     if (dbgvda) {
          oldgpr=hdlgpr;
          hdlgpr=vdagpr;
     }
     if (dbgxadr) {
          rtihdlr(rtidbg);
     }
     dbgheap=!ynopt(DBGMEM) && ynopt(DBGHEAP);
     if (dbgheap) {
          if ((rfp=fopen(RPTFILE,FOPAA)) == NULL) {
               catastro("CANNOT APPEND TO "RPTFILE);
          }
          if ((bfp=fopen(uniqfn(strcpy(binfile,BINFILE)),FOPWB)) == NULL) {
               catastro("CANNOT CREATE %s",binfile);
          }
     }
}

void
begdbg(                            /* debugging work at beginning of phase */
char *name,
long num)
{
     (*oldbph)(name,num);
     if (dbgxadr) {
          if (dbgxphs) {
               phsinf(30,yat);
          }
          if (dbgximr) {
               imrinf(78,yat);
          }
     }
     if (dbgmod) {
          ckmodl();
     }
     if (dbgheap) {
          heapchk();
     }
}

void
enddbg(                            /* debugging work at end of phase       */
char *name,
long num)
{
     (*oldeph)(name,num);
     if (dbgxadr) {
          if (dbgxphs) {
               phsinf(30,yat);
          }
          if (dbgximr) {
               imrinf(78,yat);
          }
     }
     if (dbgmod) {
          ckmodl();
     }
     if (dbgheap) {
          heapchk();
     }
}

void
dbgfin(void)                       /* intercepted module 0's finrou()      */
{
     if (dbgheap) {
          dbgheap=0;               /* (can't allow any more heap cking!)   */
          if (rfp != NULL) {
               fclose(rfp);
               rfp=NULL;
          }
          if (bfp != NULL) {
               fclose(bfp);
               if (!crash) {
                    unlink(binfile);
               }
               bfp=NULL;
          }
     }
     (*oldfin)();
}

void
rtidbg(void)                       /* display info at 18 Hz                */
{
     int u=0;                      /* WARNING!  STACK POSITION CRITICAL    */

     locinf(&u,0,yat);
     sflinf(0,yat+1);
     if (dbgxphs) {
          phsinf(30,yat);
     }
     if (dbgximr) {
          imrinf(78,yat);
     }
}

void
ckmodl(void)                       /* check module structures              */
{
     int st;
     struct module *mp;

     if (errcod >= 20) {
          return;
     }
     if (!goodptr(module)) {
          catastro("MODULE POINTER CORRUPTED: %04X:%04X",FP_SEG(module),
                                                         FP_OFF(module));
     }
     for (st=0 ; st < nmods ; st++) {
          mp=module[st];
          if (mp == NULL) {
               module[st]=&dmymodule;
               catastro("MODULE POINTER FOR STATE %d CORRUPTED: %04X:%04X %04X:%04X",
                        st,FP_SEG(module),FP_OFF(module),
                           FP_SEG(mp),FP_OFF(mp));
          }
     }
}

void
vdagpr(                            /* GP addendum, records VDA contents    */
char *rfname)
{
     FILE *rfp,*bfp;
     char bfname[20];
     unsigned int nactual;
     char *vdanm1;

     if (vdarea != NULL) {
          uniqfn(strcpy(bfname,GPVDAFILE));
          if (goodstg(rfname) && (rfp=fopen(rfname,FOPAA)) != NULL) {
               vdanm1=vdaoff(nterms-1);
               fprintf(rfp,"GP Addendum:  VDA Report\n"
                           "vdaoff(0)=%04X:%04X  "
                           "vdaptr=%04X:%04X  "
                           "vdaoff(%d)=%04X:%04X\n"
                           "vdasiz=%d (decimal) %X (hex)\n",
                           FP_SEG(vdarea),FP_OFF(vdarea),
                           FP_SEG(vdaptr),FP_OFF(vdaptr),
                           nterms-1,FP_SEG(vdanm1),FP_OFF(vdanm1),
                           vdasiz,vdasiz);
               nactual=goodblk(vdaptr,vdasiz);
               fprintf(rfp,"%u-byte VDA contents stored in binary in \"%s\""
                           "\n\n",nactual,bfname);
               fclose(rfp);
               if (nactual > 0 && (bfp=fopen(bfname,FOPWB)) != NULL) {
                    fwrite(vdaptr,1,nactual,bfp);
                    fclose(bfp);
               }
          }
     }
     (*oldgpr)(rfname);
}

void
heapchk(void)                      /* check all heap selectors             */
{
     unsigned sel,err;
     extern void sdllinfo(FILE *dst);
     struct phasedbg *pdb;

     if (crash) {
          return;
     }
     for (sel=__base ; sel <= __top ; sel+=__hincr) {
          if ((err=selchk(sel)) != 0) {
               crash=1;
               fprintf(rfp,"HEAP ERROR %d DETECTED %s %s\n",
                       err,ncdate(today()),nctime(now()));
               fprintf(rfp,"The 64K-segment %04X:XXXX was recorded in %s\n",
                           sel,binfile);
               fflush(rfp);
               rptphs(rfp);
               fflush(rfp);
               fprintf(rfp,"\nDLLs:");
               sdllinfo(rfp);
               fprintf(rfp,"\n\n\n");
               fclose(rfp);
               rfp=NULL;
               fwrite(MK_FP(sel,0),256,256,bfp);
               fclose(bfp);
               bfp=NULL;
               if (errcod < 20) {
                    if ((pdb=pstphs(0)) == NULL) {
                         catastro("HEAP ERROR %d (ref "RPTFILE" and %s)",
                                  err,binfile);
                    }
                    else {
                         catastro("HEAP ERROR %d, %s %s\n(ref "RPTFILE" and %s)",
                                  err,pdb->flags&PDBBEG ? "BEG" : "END",
                                  pdb->name,binfile);
                    }
               }
          }
     }
}

int
selchk(                            /* check the 64K of this heap selector  */
unsigned sel)
{
     /*   unsigned long alcd=0L;        */
     /*   unsigned long freed=0L;       */
     /*   unsigned long infctr=0L;      */
     /*   unsigned long fresiz;         */
     /*   unsigned int mainfree;        */
     /*   unsigned int curfree;         */
     /*   unsigned int off;             */
     /*   unsigned int elemp=0,elemn=0; */
     /*   struct heapblock *blk;        */
     /*                                 */
     /*   blk=MK_FP(sel,0);             */
     /*   do {                          */ /* first, we count up all memory*/
     /*        off=blk->prev_real;      */
     /*        blk=MK_FP(sel,off);      */
     /*        if (blk->size&1) {       */
     /*             alcd+=blk->size-1;  */      /* allocated block, counted*/
     /*        }                        */
     /*        else {                   */
     /*             freed+=blk->size;   */      /* free block, counted.    */
     /*             mainfree=off;       */
     /*        }                        */
     /*        if (infctr++ > MAXBLKS) {*/      /* infinite loop checker   */
     /*             return(1);          */
     /*        }                        */
     /*   } while (off != 0);           */
     /*   if (freed+alcd != 65536L) {   */   /* freed+alcd must == 64K     */
     /*        return(2);               */
     /*   }                             */
     /*   if (freed == 0L) {            */   /* return if no free space    */
     /*        return(0);               */
     /*   }                             */

     asm  push ds
     asm  mov  ds,sel
     asm  xor  si,si               /* DS:SI is blk                         */
     asm  xor  bx,bx               /* BX is alcd                           */
     asm  xor  dx,dx               /* DX is freed                          */
     asm  mov  cx,MAXBLKS          /* CX does infctr function              */
mloop:
     asm  mov  si,[si.(struct heapblock)prev_real]
     asm  mov  ax,[si.(struct heapblock)size]
     asm  test ax,1
     asm  jz   mfree               /* odd => block is allocated            */
     asm  dec  ax                  /* (strip LSBit)                        */
     asm  add  bx,ax               /* count allocated bytes                */
     asm  jc   mbustma             /* >= 65536 allocated bytes?            */
     asm  dec  cx
     asm  jz   mstuck              /* countdown                            */
     asm  test si,si
     asm  jnz  mloop
     asm  jmp  mboth

     mstuck:                       /* must be in an infinite loop          */
     asm  pop  ds
     return(1);

     mbustma:                      /* MAYBE busted: alcd >= 65536          */
     asm  test si,si               /* the only way this could be valid:    */
     asm  jnz  mbust               /*    must be at last block (offset 0)  */
     asm  test bx,bx
     asm  jnz  mbust               /*    alcd must be 65536                */
     asm  test dx,dx
     asm  jnz  mbust               /*    freed must be 0                   */
     asm  pop  ds
     return(0);                    /*    ok, no more work to do            */

     mbustmf:                      /* MAYBE busted: freed >= 65536         */
     asm  test si,si               /* the only way this could be valid:    */
     asm  jnz  mbust               /*    must be at last block (offset 0)  */
     asm  test bx,bx
     asm  jnz  mbust               /*    alcd must be 0                    */
     asm  test dx,dx
     asm  jnz  mbust               /*    freed must be exactly 65536       */
     asm  jmp  mdone               /*    ok, go check the free list        */

     mbust:                        /* BUST: freed & alloc'd regions don't  */
     asm  pop  ds                  /* add up to exactly 65536              */
     return(2);

     mfree:                        /* even => block is free                */
     asm  add  dx,ax               /* count free bytes                     */
     asm  jc   mbustmf             /* >= 65536 free bytes?                */
     asm  mov  di,si               /* DI is mainfree                       */
     asm  dec  cx
     asm  jz   mstuck              /* countdown                            */
     asm  test si,si
     asm  jnz  mloop

     mboth:
     asm  add  bx,dx               /* freed+alcd == 65536?                 */
     asm  jnc  mbust               /* not if no carry                      */
     asm  jnz  mbust               /* not if no overflow/wraparound to 0   */
     mdone:

     /*   infctr=fresiz=0L;             */
     /*   blk=MK_FP(sel,curfree=mainfree);*/
     /*   do {                          *//* now,  check the linked lists  */
     /*        curfree=blk->x.f.prev;   *//* of free memory. backwards 1st */
     /*        blk=MK_FP(sel,curfree);  */
     /*        elemp++;                 */     /* count it                 */
     /*        fresiz+=blk->size;       */
     /*        if (fresiz&1) {          */     /* if this was really a     */
     /*             return(3);          */     /* non-free block, bomb!    */
     /*        }                        */
     /*        if (infctr++ > MAXBLKS) {*/
     /*             return(4);          */
     /*        }                        */
     /*   } while (curfree != mainfree);*/
     /*   if (fresiz != freed) {        */     /* match totals from before */
     /*        return(5);               */
     /*   }                             */

     asm  mov  cx,MAXBLKS
     asm  mov  si,di               /* DS:SI still represents blk           */
     asm  xor  ax,ax               /* AX will count up elemp and down elemn*/
     asm  xor  bx,bx               /* BX is now fresiz                     */
ploop:
     asm  mov  si,[si.(struct heapblock)x.f.prev]
     asm  inc  ax                  /* count free blocks in prev chain      */
     asm  add  bx,[si.(struct heapblock)size]   /* add up total free again */
     asm  test bx,1                /* whoops, was it odd??                 */
     asm  jnz  palcd               /* all free blocks must have even sizes */
     asm  dec  cx
     asm  jz   pstuck              /* countdown                            */
     asm  cmp  si,di
     asm  jne  ploop               /* done when you get back to mainfree   */
     asm  jmp  pdone

     palcd:                        /* found "allocated" block in free chain*/
     asm  pop  ds
     return(3);

     pstuck:                       /* free-prev must be an infinite chain  */
     asm  pop  ds
     return(4);

     pgoof:                        /* free size totals don't match         */
     asm  pop  ds
     return(5);

     pdone:
     asm  cmp  bx,dx               /* fresiz == freed?                     */
     asm  jne  pgoof

     /*   infctr=fresiz=0L;             */
     /*   blk=MK_FP(sel,curfree=mainfree);*/
     /*   do {                          */ /* now we do other linked list  */
     /*        curfree=blk->x.f.next;   */ /* in the other direction       */
     /*        blk=MK_FP(sel,curfree);  */
     /*        elemn++;                 */
     /*        fresiz+=blk->size;       */
     /*        if (fresiz&1) {          */
     /*             return(6);          */
     /*        }                        */
     /*        if (infctr++ > MAXBLKS) {*/
     /*             return(7);          */
     /*        }                        */
     /*   } while (curfree != mainfree);*/
     /*   if (fresiz != freed) {        */
     /*        return(8);               */
     /*   }                             */
     /*   if (elemp != elemn) {         */
     /*        return(9);               */
     /*   }                             */

     asm  mov  cx,MAXBLKS
     asm  mov  si,di
     asm  xor  bx,bx               /* BX is fresiz again                   */
nloop:
     asm  mov  si,[si.(struct heapblock)x.f.next]
     asm  dec  ax                  /* uncount free blocks in next chain    */
     asm  add  bx,[si.(struct heapblock)size]   /* add up total free again */
     asm  test bx,1                /* whoops, was it odd??                 */
     asm  jnz  nalcd               /* all free blocks must have even sizes */
     asm  dec  cx
     asm  jz   nstuck              /* countdown                            */
     asm  cmp  si,di
     asm  jne  nloop               /* done when you get back to mainfree   */
     asm  jmp  ndone

     nalcd:                        /* found "allocated" block in free chain*/
     asm  pop  ds
     return(6);

     nstuck:                       /* free-next must be an infinite chain  */
     asm  pop  ds
     return(7);

     ngoof:                        /* free size totals don't match         */
     asm  pop  ds
     return(8);

     nmess:                        /* free block counts don't match        */
     asm  pop  ds
     return(9);

     ndone:
     asm  cmp  bx,dx               /* fresiz == freed?                     */
     asm  jne  ngoof
     asm  test ax,ax               /* elemp == elemn?                      */
     asm  jnz  nmess

     asm  pop  ds
     return(0);
}                                  /* all lived happily ever after         */

int
dmyinp(void)                       /* dummy input handler                  */
{
     return(0);
}

/*---- intterupt level code starts here ----*/

void
locinf(                            /* 22-character wide location info      */
int *loc,                          /* CRITICAL STACK POSITION              */
int x,                             /* \ screen location (of spinner)       */
int y)                             /* /                                    */
{
     static char *items[]={"\\","","/",""};
     static int fly=0;
     static int psel,poff;

     if (++drib < dbgxslw) {
          return;
     }
     drib=0;
     splace(x+0,y,items[fly=(fly+1)&3]);
     splace(x+2,y,hexa(psel=loc[STKPT1+1]));
     splace(x+6,y,":");
     splace(x+7,y,hexa(poff=loc[STKPT1]));
     splace(x+11,y,"");
     if (psel == 0x001F && (poff == 0x0D33 || poff == 0x0D2B)) {
          splace(x+13,y,hexa(loc[STKPT2+1]));
          splace(x+17,y,":");
          splace(x+18,y,hexa(loc[STKPT2]));
     }
     else {
          splace(x+13,y,"");
     }
}

void
phsinf(                            /* 47-character wide phase info         */
int x,                             /* \ screen location (left edge)        */
int y)                             /* /                                    */
{
     struct phasedbg *pdp;

     if ((pdp=pstphs(0)) != NULL) {
          splace(x,y,pdp->flags&PDBBEG ? "BEG " : "END ");
          splacen(x+4,y,pdp->name,10);
          splace(x+14,y," ");
          splace(x+15,y,hexa((int)(pdp->num>>16)));
          splace(x+19,y,hexa((int)pdp->num));
          if (0 <= pdp->usrnum && pdp->usrnum < nterms) {
               splace(x+23,y," CH");
               splace(x+26,y,hexc(channel[pdp->usrnum]));
               splace(x+28,y," ");
               splace(x+29,y,hexc(pdp->usrcls));
               if ((pdp->usrcls > SUPIPG || pdp->usrcls == BBSPRV)
                && 0 <= pdp->usrsta && pdp->usrsta < nmods) {
                    splace(x+31,y," ");
                    splacen(x+32,y,module[pdp->usrsta]->descrp,10);
               }
               else {
                    splace(x+31,y," state=");
                    splace(x+38,y,hexa(pdp->usrsta));
               }
               splace(x+42,y," ");
               splace(x+43,y,hexa(pdp->usrsbs));
          }
          else {
               splace(x+23,y," usrnum=");
               splace(x+31,y,hexa(pdp->usrnum));
               splace(x+35,y,"            ");
          }
     }
}

void
sflinf(                            /* 15-character wide source file & line */
int x,                             /* \ screen location (left edge)        */
int y)                             /* /                                    */
{
     if (sltrak != 0) {
          splacen(x,y,sftrak,10);
          splace(x+11,y,hexa(sltrak));
     }
}

void
imrinf(                            /* 2-character wide 8259 IMR contents   */
int x,                             /* \ screen location (left edge)        */
int y)                             /* /                                    */
{
     splace(x,y,hexc(inp(0x21)));
}

void
splacem(                           /* display a series of hex words        */
int x,                             /* \ screen location (left edge)        */
int y,                             /* /                                    */
int *words,                        /* pointer to words                     */
int gnum,                          /* number readable without GP           */
int num)                           /* total number to display (.... extra) */
{
     int i;

     for (i=0 ; i < gnum ; i++) {
          splace(x+i*5,y," ");
          splace(1+x+i*5,y,hexa(words[i]));
     }
     for ( ; i < num ; i++) {
          splace(x+i*5,y," ....");
     }
     splace(x+num*5,y," ");
}

void
splacen(                           /* display a left-just space-filled stg */
int x,                             /* \ screen location (left edge)        */
int y,                             /* /                                    */
char *stg,                         /* string                               */
int limit)                         /* max number of characters             */
{
     while (limit-- > 0) {
          if (*stg != '\0') {
               pscreen[x++*2+y*160]=*stg++;
          }
          else {
               pscreen[x++*2+y*160]=' ';
          }
     }
}

void
splace(                            /* display a string                     */
int x,                             /* \ screen location (left edge)        */
int y,                             /* /                                    */
char *stg)                         /* string                               */
{
     while (*stg != '\0') {
          pscreen[x++*2+y*160]=*stg++;
     }
}

char *
hexa(                              /* format a 4-digit hex string          */
int u)                             /* word-size number                     */
{
     static char buff[]="0000";

     buff[3]=hexs[u&0xF];
     buff[2]=hexs[(u>>4)&0xF];
     buff[1]=hexs[(u>>8)&0xF];
     buff[0]=hexs[(u>>12)&0xF];
     return(buff);
}

char *
hexc(                              /* format a 2-digit hex string          */
char c)                            /* byte-size number                     */
{
     static char buff[]="00";

     buff[1]=hexs[c&0xF];
     buff[0]=hexs[(c>>4)&0xF];
     return(buff);
}

