/***************************************************************************
 *                                                                         *
 *   DATSTM.H                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   DataStream API - Interface between byte sources (clients) and         *
 *                    byte sinks (servers)                                 *
 *                                                                         *
 *                                             - R. Stein  5/9/94          *
 *                                                                         *
 ***************************************************************************/

/* Note that far pointers are used in all memory models */

#ifndef DATSTM_H
#define DATSTM_H
struct datstm {                    /* DataStream structure for a data sink */
     unsigned far (*snkwin)(       /* return how much room sink has now    */
          struct datstm far *dsp); /* (pointer to sink's datstm structure) */
     void far (*hrsone)(           /* pass one byte to the sink            */
          struct datstm far *dsp,  /* (pointer to sink's datstm structure) */
          char byte);              /* here's the one byte                  */
     unsigned far (*moveit)(       /* sink moves bytes (nactual is fedback)*/
          struct datstm far *dsp,  /* (pointer to sink's datstm structure) */
          char far *srcloc,        /* source specifies the location        */
          unsigned nwant);         /* source wants sink to move this many  */
     void far (*didmov)(           /* source reports bytes moved to snkloc */
          struct datstm far *dsp,  /* (pointer to sink's datstm structure) */
          unsigned nactual);       /* this many were moved by the source   */
     char far *snkloc;             /* snkwin output: where source can store*/
     unsigned snkmax;              /* snkwin output: maximum eventual room */
     unsigned flags;               /* DSTOVF=sink reports overflow         */
};

#define DSTOVF 0x0001              /* flags: sink may record overflow      */

struct bufstm {                    /* Buffered DataStream sink-server      */
     struct datstm datstm;         /* DataStream session (MUST BE 1ST FLD) */
     char *buffer;                 /* accumulation buffer                  */
     unsigned bufsiz;              /* permanently BUFSIZ (at least 1)      */
     unsigned bufcnt;              /* buffer count, 0..BUFSIZ-1            */
};
#endif


/*--- Stub routines for sinks implemented via moveit()  ---*/
/*---------------------------------------------------------*/
/*--- (Both parties may want to move the bytes, so the  ---*/
/*--- sink surrounds its datstm structure with a bufstm ---*/
/*--- structure, which specifies a buffer to interpose  ---*/
/*--- between the two non-lazy parties.)                ---*/

unsigned
swbufs(                            /* snkwin() stub for buffered DataStream*/
struct datstm far *dsp);           /* DataStream structure (inside bufstm) */
                                   /* returns room in buffer               */

void
hobufs(                            /* hrsone() stub for buffered DataStream*/
struct datstm far *dsp,            /* DataStream structure (inside bufstm) */
char byte);                        /* here's the one byte                  */

void
dmbufs(                            /* didmov() stub for buffered DataStream*/
struct datstm far *dsp,            /* DataStream structure (inside bufstm) */
unsigned nactual);                 /* this many were moved by the source   */


/*--- Stub routines for sinks implemented via snkwin() & didmov() ---*/
/*-------------------------------------------------------------------*/
/*--- (Neither party may want to move the bytes, so a movmem()    ---*/
/*--- may need to intervene between the two lazy parties.)        ---*/

unsigned
mviad(                             /* moveit() stub via didmov() & snkwin()*/
struct datstm far *dsp,            /* DataStream structure                 */
char far *srcloc,                  /* source location                      */
unsigned nwant);                   /* number of bytes desired to move      */
                                   /* returns actual number of bytes moved */

void
hviad(                             /* hrsone() stub via didmov() & snkwin()*/
struct datstm far *dsp,            /* DataStream structure                 */
char byte);                        /* data byte                            */

