/***************************************************************************
 *                                                                         *
 *   CSRSYS.C                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1996 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is the Remote System Console Agent module.                       *
 *                                                                         *
 *                                                - Joe Delekto 1/10/96    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "sys\stat.h"
#include "majorbbs.h"
#include "gcsasys.h"
#include "gcspsrv.h"
#include "galrsy.h"
#include "remote.h"

#define   FILREV "$Revision: 1.14 $"

#define   RSYAPN "GALRSY\0\0"      /* remote console application appid     */

#define   RSPOK  "ok"              /* ok, write had no problems            */
#define   RSPERR "error"           /* error, something went awry           */
                                        /* special args for std resp funcs */
#define   RAWMSG 1                 /* do the prfmsg() for me               */
#define   CKDMSG 2                 /* prfbuf already setup, (for args)     */

#define   NOCODE  0                /* no special code for response         */

#define   dynpak(x) "sa:"x         /* convert to full dynapak name         */
#define   fdynpak(x) "saf:"x       /* convert to full file dynapak name    */

#define   rsytmp(x) ((struct x *)vdatmp)     /* volatile fapdef structure  */
#define   rsycmn ((struct rsymem *)mrqptr)   /* command info between paks  */
#define   rsyarg (((struct rsymem *)mrqptr)->mrqu.rsyargs) /* dynapak args */
#define   rsyevn (((struct rsymem *)mrqptr)->mrqu.rsyevts) /* event info   */
#define   rsyclp (((struct rsymem *)mrqptr)->mrqu.rsyproc) /* cmd interp.  */
#define   rsyaud (((struct rsymem *)mrqptr)->mrqu.rsyaudt) /* audit trail  */
#define   rsyfnd (((struct rsymem *)mrqptr)->mrqu.rsysrch) /* audit trail  */

                                        /* special response building ops   */
#define   clear(s) *(s)='\0'                      /* set first char '0'    */
#define   cpyrsp(s) stlcpy(rsptmp,(s),MAXDPKV)    /* start new response str*/
#define   delimiter() stlcat(rsptmp,"\t",MAXDPKV) /* add delimiter to rsp  */
#define   catrsp(s) stlcat(rsptmp,(s),MAXDPKV)    /* add to response str   */
#define   cpyvda(s) stlcpy(vdatmp,(s),MAXDPKV)    /* start new response str*/
#define   vdelimiter() stlcat(vdatmp,"\t",MAXDPKV)/* add delimiter to rsp  */
#define   catvda(s) stlcat(vdatmp,(s),MAXDPKV)    /* add to response str   */


#define   nxtarg(s) skpwht(skpwrd(s))   /* point to next argument          */
#define   nularg(s) *(skpwrd(s))='\0'   /* null terminate an argument      */

#define OSTYPE "DOS"          /* type of OS Console is running on          */

#define FLDSEP "\001"         /* internal field separator for strings      */

#define POLLED "poll"         /* used to override realtime operations      */

#define SECURE "secure"       /* get security information on the server    */
#define INTERP "interp "      /* command line interpreter information      */
#define INTPRC "intprc "      /* process an outstanding command            */
#define GETCWD "getcwd"       /* get the current working directory         */
#define NXTUID "nxtuid "      /* get next user id from server              */
#define STRMON "strmon"       /* start system monitor (realtime)           */
#define STPMON "stpmon"       /* stop system monitor                       */
#define SUMINF "suminf"       /* get summary information from server       */
#define SVRLOD "svrlod"       /* get server load information               */
#define NUMTRM "numtrm"       /* get nterms on the server                  */
#define SYSABT "sysabt"       /* get about information for system          */
#define ABTRFS "abtrfs"       /* refresh pertinent about information       */
#define USRSON "usrson"       /* get a list of users online                */
#define SCHCHR "schchr"       /* get schochl() characters and attribs      */
#define SCHLNG "schlng"       /* get schochl() legend text                 */
#define CHROFF "chroff"       /* turn shochl() monitor off                 */
#define LNGOFF "lngoff"       /* turn shochl() legend monitor off          */
#define KILUSR "kilusr"       /* kill a user's channel, if the user in on  */
#define PSTUSR "pstusr"       /* post credits to a particular user         */
#define MSGUSR "msgusr"       /* pop a message to a particular user        */
#define MSGALL "msgall"       /* pop a message to all users                */
#define SYSEVT "sysevt"       /* system event is occurring                 */
#define KILSYS "kilsys"       /* system is being killed                    */
#define UPLFIL "uplfil "      /* upload a file to the system               */
#define DNLFIL "dnlfil "      /* download a file from the system           */
#define AUDSTR "audstr"       /* start audit trail                         */
#define AUDSTP "audstp"       /* stop the audit trail                      */
#define AUDSCR "audscr "      /* scroll the audit trail (line or page)     */
#define AUDGET "audget "      /* get audit trail text                      */
#define AUDNOT "audnot"       /* audit trail information avail. notific.   */
#define GETSTT "getstt "      /* get statistics information                */
#define SEARCH "search "      /* search dynapak name                       */
#define SRCHNF "srchnf"       /* return resulting information from search  */
#define LOGMSG "logmsg"       /* new system logon announcement             */
#define CHANOP "chanop "      /* perform an operation on a channel         */
#define UPLMNU "uplmnu"       /* upload a new bbsmenu.dat                  */

#define HRTONE 0x00010000UL   /* 1 second, in 1/65536 units (ala hrtval()) */

#define WAIT   0              /* wait for free qroom                       */
#define NOWAIT 1              /* qroom is available                        */

#define DIRCMD 1              /* list directory command                    */
#define TYPCMD 2              /* type out a file command                   */
#define CPYCMD 3              /* copy files command                        */
#define RENCMD 4              /* rename file command                       */
#define MKDCMD 5              /* make directory command                    */
#define RMDCMD 6              /* remove directory command                  */
#define DELCMD 7              /* delete file command                       */
#define EXTCMD 8              /* exit command interpreter command          */
#define UPLCMD 9              /* upload files command                      */
#define DNLCMD 10             /* download files command                    */
#define LNCCMD 11             /* launch a file command                     */

#define AUDUP    0            /* scroll the audit trail up                 */
#define AUDDN    1            /* scroll the audit trail down               */
#define AUDHOME  2            /* move audit trail to the top               */
#define AUDEND   3            /* move audit trail to the end               */
#define AUDPGUP  4            /* move audit trail up NUMADT elements       */
#define AUDPGDN  5            /* move audit trail down NUMADT elements     */

#define FLDUID 0              /* search for User-ID string                 */
#define FLDNAM 1              /* search for user name string               */
#define FLDPWD 2              /* search for password string                */
#define FLDCMP 3              /* search for company name, addr1            */
#define FLDAD1 4              /* search for address field one              */
#define FLDAD2 5              /* search for address field two              */
#define FLDAD3 6              /* search for address field three            */
#define FLDPHO 7              /* search for phone number string            */
#define FLDSYS 8              /* search for system type                    */
#define FLDAGE 9              /* search for age                            */
#define FLDSEX 10             /* search for sex                            */
#define FLDCLS 11             /* search for users' current class           */
#define FLDTCR 12             /* search for total credits                  */
#define FLDTPD 13             /* search for total paid credits             */
#define FLDCRD 14             /* search for credits available now          */
#define FLDCDT 15             /* search for creation date                  */
#define FLDUDT 16             /* search for last used date                 */
#define FLDDAY 17             /* search for number of days left in class   */

#define LGNSIZ 47                       /* size of label text for legend   */
#define LNMSIZ 34                       /* size of long value string       */
#define SSTSIZ 256                      /* maximum size of search string   */
#define NUMADT 8                        /* number of audit trail entries   */
#define CPYSIZ vdasiz                   /* size of chunk for copying files */

#define WRKDON 0                        /* no longer copying any files     */
#define WRKING 1                        /* currently copying a file        */

#define CHRFLG 0x01                     /* user is getting shochl() chars  */
#define LGDFLG 0x02                     /* user is getting legend info     */
#define AUDFLG 0x04                     /* user getting audit trail notif. */

#define DIRREQ 0x01                     /* this is a directory request     */
#define CPYREQ 0x02                     /* this is a copy file request     */
#define DELREQ 0x04                     /* this is a delete file request   */
#define TYPREQ 0x08                     /* this is a type file request     */
#define DNLREQ 0x10                     /* this is a download request      */
#define UPLREQ 0x20                     /* this is an upload request       */

#define LIUSTT 0                        /* lines in use statistics         */
#define SEBSTT 1                        /* sessions/Baudrate statistics    */
#define TUHSTT 2                        /* time used/hour stats            */
#define TUGSTT 3                        /* time used/group # stats         */
#define CUHSTT 4                        /* credits used/hour stats         */
#define CUGSTT 5                        /* credits used/Group # stats      */
#define DEMSTT 6                        /* demographics statistics         */
#define CLSSTT 7                        /* class statistics                */
#define MSCSTT 8                        /* miscellaneous statistics        */

#define DIRTRK 0x0001
#define CPYTRK 0x0002L                  /* track use of copy command       */
#define DELTRK 0x0004L                  /* track use of delete command     */
#define PUTTRK 0x0008L                  /* track use of upload command     */
#define GETTRK 0x0010L                  /* track use of download command   */
#define MDTRK  0x0020L                  /* track use of directory create   */
#define RDTRK  0x0040L                  /* track use of directory destroy  */
#define RENTRK 0x0080L                  /* track use of file rename        */
#define TYPTRK 0x0100L                  /* track use of type command       */
#define LNCTRK 0x0200L                  /* track use of lauch command      */
#define PSTTRK 0x0400L                  /* track use of credit posting     */
#define KILTRK 0x0800L                  /* track use of channel killing    */
#define EVTTRK 0x1000L                  /* track use of event takedown     */
#define KSYTRK 0x2000L                  /* track use of system kill        */
#define LOGTRK 0x4000L                  /* track use of logon announcement */
#define CHPTRK 0x8000L                  /* track use of channel operations */
#define MSGTRK 0x00010000L              /* track messages sent to users    */
#define AMSTRK 0x00020000L              /* track messages sent to all      */

char *rsckey;                           /* key required to use remote agent*/

static BOOL upldmnu=FALSE;              /* uploading bbsmenu.dat?          */

static char *abttl="Worldgroup -- Copyright (c) 1986-1996 Galacticomm, Inc.";

static char *crdts="Worldgroup developed by:\n\nJack Alvrus, Scott Brinker, "
     "Joe Delekto, Charles Dunn, Bill Hyatt, Ilya Minkin, Don Pitchford, "
     "Chris Robert, Richard Skurnick, Bob Stein, and Tim Stryker\n\n"
     "Documentation by:  Marc Fountain               Toolbar graphics by: "
     "Keith Kirkland";

static char *cprit="Portions of this program Copyright (C) 1982-1994\n"
     "Btrieve Technologies, Inc.  All Rights Reserved";

static char *months[]={
     "","January's","February's","March's","April's","May's","June's","July's",
     "August's","September's","October's","November's","December's"
};

static int kilmins[]={1,2,5,10,-1,0}; /* minutes until system shutdown     */
static int glthrv[5][3]={{0,1,0},{0,0,1},{1,0,0},{0,1,1},{1,1,0}}; /* direc*/

static unsigned
char rsyflg[256];                  /* rsyflags which set for unsolc. dpak  */

static unsigned mytrack;           /* date of last zeroing of statistics   */

static
struct chninf {                    /* channel legend character map struct  */
     char legend[256];             /*   legend characters                  */
     char attrib[256];             /*   attribute (color) information      */
} chnlng;

static unsigned long trkflgs;      /* flags used during operation tracking */

extern
struct clstab *clshead;            /* pointer to class info in memory      */

extern
unsigned maxspd,                   /* maximum baudrate                     */
         maxpol,                   /* poll rate if necessary               */
         dtrack;                   /* server's dtrack value for class stts */

extern
int curdlls,                       /* count of DLLs loaded                 */
    hichp1,                        /* highest channel number plus one      */
    rsykil;                        /* minutes until kill time              */

struct clstab *clmptr;             /* temporary ptr to class info          */

extern
struct uidisp {                    /* users screen display data            */
     char sing;                    /*    single character legend           */
     char attrib;                  /*    attribute for legend/labels       */
     char labl[LGNSIZ];            /*    full legend for channel           */
} *uidarr;

extern
BTVFILE *keysbb,                   /* keys database pointer                */
        *clsbb,                    /* class database pointer               */
        *xrfbb;                    /* user-id x-ref database pointer       */

extern
int sysload[60];                   /* lines in use from SUMMARY.C load grph*/

struct load {
     int loads[60];                /* load per minute on the server        */
};

struct rsymem {
     char mysuffix[SFXSIZ];             /* my suffix for identification    */
     long myflags;                      /* flags to determine my purpose   */
     union {
          struct {                      /* general purpose argument memory */
               int real;                /*   were credits paid or free?    */
               char usrnam[UIDSIZ];     /*   username passed as argument   */
               char crdstr[LNMSIZ];     /*   string used for credit posting*/
          } rsyargs;
          struct {                      /* remote sysop events information */
               int chan;                /*   hold channel to perform event */
               int timkil;              /*   time to kill channel          */
          } rsyevts;
          struct {                      /* remote sysop command interpreter*/
               int request;             /*   my request id for identity    */
               int funct;               /*   my purpose in the scheme      */
               int status;              /*   current processing status     */
               BOOL multifil;           /*   flag for multiple file copy   */
               FILE *sfptr;             /*   source file pointer           */
               FILE *dfptr;             /*   destination file pointer      */
               struct fndblk dirblk;    /*   structure used for directory  */
               struct filinf myfinf;    /*   my file information for upld  */
               char sfname[FNDSIZE];    /*   file name 1 for general use   */
               char sfpath[FNDSIZE];    /*   src path name for multi-copy  */
               char dfname[FNDSIZE];    /*   file name 2 for general use   */
               char dfpath[FNDSIZE];    /*   dest path name for multi-copy */
          } rsyproc;
          struct {                      /* remote sysop audit trail info   */
               int request;             /*   saved outstanding write reqid */
               BOOL faddle;             /*   can audit trail be updated?   */
               long ratptrs[NUMADT];    /*   btrieve audit trail pointers  */
          } rsyaudt;
          struct {                      /* remote sysop account search eng.*/
               int field;               /*   field which is being searched */
               int relate;              /*   ==, >, <, >=, <= operations   */
               long fpos;               /*   position in the account dbase */
               char srchstg[SSTSIZ];    /*   string to be searching for    */
          } rsysrch;
     } mrqu;
};

extern
     void (*shochl_hook)(int chan);     /* Our very own hook to shochl()!  */
extern
     void (*rsyfad_hook)(void);         /* Our hook to audit trail disp.   */
extern
     BOOL (*swtcls_hook)(struct usracc *usract,char *class,int days);
extern
     BTVFILE *audbb;                    /* Btrieve file block ptr for audit*/

static void rsyread(int direction,struct saunam *dpknam);
static void rsywrite(struct saunam *dpknam,unsigned length,void *value);
static void rsyxdone(void);
static void rsyabort(void);

struct agent rsyagt={              /* agent information structure          */
     RSYAPN,                       /*   appid                              */
     rsyread,                      /*   read-dynapak function pointer      */
     rsywrite,                     /*   write-dynapak function pointer     */
     rsyxdone,                     /*   file xfer-done function pointer    */
     rsyabort                      /*   abort-request function pointer     */
};

extern
char *osversn(void);               /* get os version from about.c          */

static BOOL doswitch(struct usracc *usract,char *class,int days);
static void initaud(void);
static void topaud(void);
static void scraud(int dirct);
static void getaud(void);
static void rsyfadd(void);
static void legends(int chan);
static void shwchr(int chan);
static void shwlng(int chan);
static void getntrm(void);
static void getsyst(void);
static void dosabt(void);
static void listdir(void);
static char *stpname(char *fname);
static char *makpath(char *fname);
static char *stppath(char *fname);
static char *fixfil(char *fname);
static BOOL isdir(char *fname);
static BOOL iswild(char *fname);
static BOOL strtfil(void);
static BOOL strttyp(void);
static BOOL strtcpy(void);
static BOOL strtdnl(void);
static BOOL prepcpy(void);
static BOOL strtdel(void);
static BOOL lockmnu(BOOL on);
static void dodelt(void);
static void docopy(void);
static void dotype(void);
static void dodnl(void);
static void accsrch(void);
static BOOL chkstr(char *string);
static BOOL chkcdt(long credits);
static BOOL chkdte(int date);
static BOOL chknum(int number);
static void demstt(void);
static void clsstt(void);
static void mscstt(void);
static void initgrph(void);
static void liugph(void);
static void sebgph(void);
static void tuhgph(void);
static void tuggph(void);
static void cuhgph(void);
static void cuggph(void);
static struct clstab *nxtcls(struct clstab *from);
char *rtmfmt(unsigned long ntval);

void
inicsrsy(void)                /* called from remsys init, mcv file set up  */
{
     int index;

     rsckey=stgopt(RSCKEY);
     trkflgs=0L;
     if (ynopt(TRKDIR)) {
          trkflgs|=DIRTRK;
     }
     if (ynopt(TRKCPY)) {
          trkflgs|=CPYTRK;
     }
     if (ynopt(TRKDEL)) {
          trkflgs|=DELTRK;
     }
     if (ynopt(TRKPUT)) {
          trkflgs|=PUTTRK;
     }
     if (ynopt(TRKGET)) {
          trkflgs|=GETTRK;
     }
     if (ynopt(TRKMD)) {
          trkflgs|=MDTRK;
     }
     if (ynopt(TRKRD)) {
          trkflgs|=RDTRK;
     }
     if (ynopt(TRKREN)) {
          trkflgs|=RENTRK;
     }
     if (ynopt(TRKTYP)) {
          trkflgs|=TYPTRK;
     }
     if (ynopt(TRKLNC)) {
          trkflgs|=LNCTRK;
     }
     if (ynopt(TRKPST)) {
          trkflgs|=PSTTRK;
     }
     if (ynopt(TRKKIL)) {
          trkflgs|=KILTRK;
     }
     if (ynopt(TRKEVT)) {
          trkflgs|=EVTTRK;
     }
     if (ynopt(TRKKSY)) {
          trkflgs|=KSYTRK;
     }
     if (ynopt(TRKLOG)) {
          trkflgs|=LOGTRK;
     }
     if (ynopt(TRKCHP)) {
          trkflgs|=CHPTRK;
     }
     if (ynopt(TRKMSG)) {
          trkflgs|=MSGTRK;
     }
     if (ynopt(TRKAMS)) {
          trkflgs|=AMSTRK;
     }
     register_agent(&rsyagt);
     dclmrq(sizeof(struct rsymem));
     dclvda(MAXDPKV);
     for (index=0 ; index < 256 ; index++) {
          rsyflg[index]=0;
     }
     shochl_hook=legends;
     swtcls_hook=doswitch;
     rsyfad_hook=rsyfadd;
}

static void
rsyread(
int direction,
struct saunam *dpknam)
{
     int index,outer,inner,cntr,comval,savreq,clireq;
     struct user *uptr;
     struct usracc nxtusr,*aptr;
     struct load *ld;
     char *dpkstg,*usrid,*arg1,*arg2;
     unsigned long eavl;
     BOOL result;

     if (stdchk(rsckey)) {
          stlcpy(rsycmn->mysuffix,dpknam->suffix,SFXSIZ);
          *namtmp=*dpknam;
          dpkstg=cnvs2d(namtmp);
          if (sameto(dynpak(NXTUID),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPDETL)) {
                    usrid=nxtarg(dpkstg);
                    setbtv(accbb);
                    switch (direction) {
                    case 0:
                         result=acqbtv(&nxtusr,usrid,0);
                         break;
                    case 1:
                         result=agtbtv(&nxtusr,usrid,0);
                         break;
                    case -1:
                         result=altbtv(&nxtusr,usrid,0);
                         break;
                    }
                    clear(rsptmp);
                    if (result) {
                         cpyrsp(nxtusr.userid);
                         stlcpy(namtmp->suffix,NXTUID,SFXSIZ);
                         stlcat(namtmp->suffix,nxtusr.userid,UIDSIZ);
                         rsp2read(namtmp,STGLEN,rsptmp);
                         return;
                    }
                    else {
                         rejectreq();
                    }
                    rstbtv();
               }
               else {
                    rejectreq();
               }
               return;
          }
          if (direction == 0) {
               if (samepato(dynpak(SECURE),dpkstg)) {
                    clear(rsptmp);
                    if (vispsw) {
                         catrsp(RSPOK);
                    }
                    delimiter();
                    if (usaptr->flags&HASMST) {
                         catrsp(RSPOK);
                    }
                    delimiter();
                    if (haskey(syskey)) {
                         catrsp(RSPOK);
                    }
                    delimiter();
                    for (index=0 ; index < AXSSIZ ; index++) {
                         catrsp(spr("%d",usaptr->access[index]));
                         if (index < (AXSSIZ-1)) {
                              delimiter();
                         }
                    }
                    rsp2read(NULL,STGLEN,rsptmp);
                    return;
               }
               if (samepato(dynpak(CHANOP),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPCHNG)) {
                         clear(rsptmp);
                         arg1=nxtarg(dpkstg);
                         arg2=nxtarg(arg1);
                         nularg(arg1);
                         nularg(arg2);
                         comval=atoi(arg1);
                         cntr=atoi(arg2);
                         if ((cntr < 0) || (cntr > 255)) {
                              rejectreq();
                              return;
                         }
                         if ((inner=usridx(cntr)) == -1) {
                              cpyrsp(RSPERR);
                              delimiter();
                              catrsp("Sorry, but no operations can be "
                                     "performed on that channel.");
                              rsp2read(NULL,STGLEN,rsptmp);
                              return;
                         }
                         if (user[inner].class != VACANT) {
                              cpyrsp(RSPERR);
                              delimiter();
                              catrsp("Sorry, but that channel is currently "
                                     "active.  First disconnect any user from "
                                     "that channel and try again.");
                              rsp2read(NULL,STGLEN,rsptmp);
                              return;
                         }
                         switch(comval) {
                         case 0:
                              comval=BUSYRS;
                              cpyvda("BUSY-OUT");
                              break;
                         case 1:
                              comval=NANSRS;
                              cpyvda("NO-ANSWER");
                              break;
                         case 2:
                              comval=NORMRS;
                              cpyvda("NORMAL");
                              break;
                         default:
                              comval=NORMRS;
                              cpyvda("NORMAL");
                              break;
                         }
                         rsmodes[inner]=comval;
                         kilchn(inner);
                         cpyrsp(RSPOK);
                         if (trkflgs&CHPTRK) {
                              shocst("REMOTE CHANNEL OPERATION",
                                     "[%-33s]  Channel: %-2x  Op: %-9s",
                                     usaptr->userid,cntr,vdatmp);
                         }
                         rsp2read(NULL,0,NULL);
                         return;
                    }
               }
               if (samepato(dynpak(STRMON),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPMNTR)) {
                         usrptr->flags|=(NOINJO+MONALL);
                         rsp2read(NULL,0,NULL);
                         return;
                    }
               }
               else if (samepato(dynpak(STPMON),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPMNTR)) {
                         usrptr->flags&=~(NOINJO+MONALL+MONINP);
                         rsp2read(NULL,0,NULL);
                         return;
                    }
               }
               else if (samepato(dynpak(SUMINF),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         clear(rsptmp);
                         DosMemAvail(&eavl);
                         catrsp(dbytes(eavl));
                         delimiter();
                         eavl=getdfre(0);
                         catrsp(dbytes(eavl));
                         delimiter();
                         catrsp(rtmfmt(rsptim));
                         delimiter();
                         eavl=(unsigned long)sv.emlopn;
                         catrsp(ultoa(eavl,vdatmp,10));
                         delimiter();
                         eavl=(unsigned long)sv.sigopn;
                         catrsp(ultoa(eavl,vdatmp,10));
                         delimiter();
                         catrsp(l2as(sv.msgtot));
                         delimiter();
                         eavl=(unsigned long)sv2.numact;
                         catrsp(ultoa(eavl,vdatmp,10));
                         delimiter();
                         catrsp(l2as(sv2.totcalls));
                         delimiter();
                         catrsp(l2as(sv.uplds));
                         delimiter();
                         catrsp(l2as(sv.dwnlds));
                         delimiter();
                         catrsp(itoa(dtmin(now()),vdatmp,10));
                         delimiter();
                         catrsp(nctime(now()));
                         delimiter();
                         catrsp(ncdate(today()));
                         rsp2read(NULL,STGLEN,rsptmp);
                         return;
                    }
               }
               else if (samepato(dynpak(SVRLOD),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         ld=(struct load *)vdatmp;
                         for (index=0 ; index < 60 ; index++) {
                              ld->loads[index]=sysload[index];
                         }
                         rsp2read(namtmp,sizeof(struct load),ld);
                         return;
                    }
               }
               else if (samepato(dynpak(NUMTRM),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         clear(rsptmp);
                         getntrm();
                         rsp2read(namtmp,STGLEN,rsptmp);
                         return;
                    }
               }
               else if (samepato(dynpak(SYSABT),dpkstg)) {
                    clear(rsptmp);
                    catrsp(OSTYPE);
                    delimiter();
                    catrsp(abttl);
                    delimiter();
                    catrsp(crdts);
                    delimiter();
                    catrsp(cprit);
                    delimiter();
                    getntrm();
                    delimiter();
                    catrsp(l2as(maxspd));
                    if (maxspd != maxpol) {
                         catrsp("/");
                         catrsp(l2as(maxpol));
                    }
                    delimiter();
                    catrsp(bturno);
                    delimiter();
                    dosabt();      /* #ifdef this for OS types        */
                    rsp2read(namtmp,STGLEN,rsptmp);
                    return;
               }
               else if (samepato(dynpak(ABTRFS),dpkstg)) {
                    clear(rsptmp);
                    catrsp(OSTYPE);
                    delimiter();
                    getsyst();
                    rsp2read(namtmp,STGLEN,rsptmp);
                    return;
               }
               else if (samepato(dynpak(USRSON),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPUSRS)) {
                         clear(rsptmp);
                         for (index=0,uptr=user ; index < nterms ;
                            index++,uptr++) {
                              aptr=uacoff(index);
                              switch (incusr(index,TRUE,TRUE)) {
                              case UIDNGD:
                              case VACANT:
                              case ONLINE:
                              case SUPIPG:
                                   break;
                              case BBSPRV:
                                   catrsp(aptr->userid);
                                   delimiter();
                                   catrsp(spr("%2x",channel[index]));
                                   delimiter();
                                   catrsp(module[uptr->state]->descrp);
                                   delimiter();
                                   delimiter();
                                   delimiter();
                                   catrsp(spr("%d",(uptr->minut4+2)>>2));
                                   delimiter();
                                   if (index < (nterms-1)) {
                                        stlcat(rsptmp,FLDSEP,MAXDPKV);
                                   }
                                   break;
                              case SUPLON:
                              case SUPLOF:
                              case ACTUSR:
                                   catrsp(aptr->userid);
                                   delimiter();
                                   catrsp(spr("%2x",channel[index]));
                                   delimiter();
                                   catrsp(module[uptr->state]->descrp);
                                   delimiter();
                                   catrsp(aptr->curcls);
                                   delimiter();
                                   catrsp(l2as(aptr->creds));
                                   delimiter();
                                   catrsp(spr("%d",(uptr->minut4+2)>>2));
                                   delimiter();
                                   if (user[index].flags&INVISB) {
                                        catrsp("Y");
                                   }
                                   else {
                                        catrsp("N");
                                   }
                                   if (index < (nterms-1)) {
                                        stlcat(rsptmp,FLDSEP,MAXDPKV);
                                   }
                                   break;
                              }
                         }
                         rsp2read(namtmp,STGLEN,rsptmp);
                         return;
                    }
               }
               else if (samepato(dynpak(SCHCHR),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         cntr=0;
                         for (outer=0 ; outer < 16 ; outer++) {
                              for (inner=0 ; inner < 16 ; inner++) {
                                   index=((16*inner)+outer);
                                   if (cntr < hichp1) {
                                        chnlng.legend[index]=uidarr[cntr].sing;
                                        chnlng.attrib[index]=uidarr[cntr].attrib;
                                   }
                                   else {
                                        chnlng.legend[index]='\376';
                                        chnlng.attrib[index]=0x03;
                                   }
                                   cntr++;
                              }
                         }
                         if (!sameas(nxtarg(dpknam->suffix),POLLED)) {
                              rsyflg[usrnum]|=CHRFLG;
                         }
                         rsp2read(namtmp,sizeof(struct chninf),&chnlng);
                         return;
                    }
               }
               else if (samepato(dynpak(SCHLNG),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         clear(rsptmp);
                         for (index=0 ; index < 256 ; index++) {
                              if (index < hichp1) {
                                   catrsp(uidarr[index].labl);
                              }
                              if (index < 255) {
                                   delimiter();
                              }
                         }
                         if (!sameas(nxtarg(dpknam->suffix),POLLED)) {
                              rsyflg[usrnum]|=LGDFLG;
                         }
                         rsp2read(namtmp,STGLEN,rsptmp);
                         return;
                    }
               }
               else if (samepato(dynpak(CHROFF),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         rsyflg[usrnum]&=(~CHRFLG);
                         rsp2read(namtmp,0,NULL);
                         return;
                    }
               }
               else if (samepato(dynpak(LNGOFF),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         rsyflg[usrnum]&=(~LGDFLG);
                         rsp2read(namtmp,0,NULL);
                         return;
                    }
               }
               else if (samepato(dynpak(KILUSR),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPHNGP)) {
                         clear(rsptmp);
                         arg1=nxtarg(dpkstg);
                         if (onsysn(arg1,TRUE)) {
                              btuinj(othusn,RING);
                              catrsp(RSPOK);
                         }
                         else {
                              catrsp(RSPERR);
                         }
                         if (trkflgs&KILTRK) {
                              shocst("USER KICKED OFF OF SERVER",
                                     "[%-24s] User kicked: %-23s",
                                     usaptr->userid,arg1);
                         }
                         rsp2read(namtmp,STGLEN,rsptmp);
                         return;
                    }
               }
               else if (samepato(dynpak(SYSEVT),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPCLNP)) {
                         arg1=nxtarg(dpkstg);
                         outer=atoi(itemidx(arg1,0));
                         inner=atoi(itemidx(arg1,1));
                         if ((outer >= 1) && (outer <= 5)) {
                              if ((inner >= 1) && (inner <= 10)) {
                                   rsyevn.chan=outer;
                                   rsykil=inner+1;
                                   errcod=(rsyevn.chan == 1 ? 0 :
                                           rsyevn.chan+9);
                                   cntr=greqid;
                                   rsyevn.chan=usrnum;
                                   rsmode=rsetop;
                                   if (trkflgs&EVTTRK) {
                                        shocst("REMOTE CLEANUP/EVENT SHUTDOWN",
                                        "[%-23s]  Op: %-25s",usaptr->userid,
                                        ((outer == 1) ? "SYSTEM CLEANUP" :
                                        spr("TIMED EVENT %d",(outer-1))));
                                   }
                                   prepff();
                                   rsyevt();
                                   curusr(rsyevn.chan);
                                   if (ismyreq(cntr,RSYAPN)) {
                                        curreq(cntr);
                                        rsp2read(namtmp,0,NULL);
                                        return;
                                   }
                              }
                         }
                    }
               }
               else if (samepato(dynpak(KILSYS),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPSHDN)) {
                         arg1=nxtarg(dpkstg);
                         outer=atoi(itemidx(arg1,0));
                         if ((outer >=1) && (outer <= 7)) {
                              if (outer == 7) {
                                   kilipg=0;
                                   errcod=1;
                                   rsyevn.chan=usrnum;
                                   rsmode=NORMRS;
                                   prepff();
                                   kilctr=-1;
                                   curusr(rsyevn.chan);
                                   if (trkflgs&KSYTRK) {
                                        shocst("REMOTE SHUTDOWN CANCELLED",
                                               "[%-35s]",usaptr->userid);
                                   }
                                   rsp2read(namtmp,0,NULL);
                              }
                              else {
                                   if (trkflgs&KSYTRK) {
                                        shocst("REMOTE SHUTDOWN INITIATED",
                                               "[%-35s]",usaptr->userid);
                                   }
                                   rsp2read(namtmp,0,NULL);
                                   kilsrc=usrnum;
                                   errcod=8;
                                   kilctr=kilmins[outer-1];
                                   fupkil();
                              }
                              return;
                         }
                    }
               }
               else if (samepato(dynpak(GETCWD),dpkstg)) {
                    clear(rsptmp);
                    normspec(rsptmp,".");
                    rsp2read(namtmp,STGLEN,rsptmp);
                    return;
               }
               else if (samepato(dynpak(AUDGET),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         arg1=nxtarg(dpkstg);
                         nularg(arg1);
                         clireq=atoi(arg1);
                         rsyaud.request=srvrqid(usrnum,clireq);
                         if (ismyreq(rsyaud.request,RSYAPN)) {
                              savreq=greqid;
                              curreq(rsyaud.request);
                              clear(rsptmp);
                              if (sameas(rsycmn->mysuffix,AUDSTR)) {
                                   getaud();
                              }
                              curreq(savreq);
                              rsp2read(NULL,STGLEN,rsptmp);
                              return;
                         }
                    }
               }
               else if (samepato(dynpak(AUDSCR),dpkstg)) {
                    if (haskey(syskey) || ACCESS(OPAUDT)) {
                         arg1=nxtarg(dpkstg);
                         arg2=nxtarg(arg1);
                         nularg(arg1);
                         nularg(arg2);
                         clireq=atoi(arg1);
                         comval=atoi(arg2);
                         rsyaud.request=srvrqid(usrnum,clireq);
                         if (ismyreq(rsyaud.request,RSYAPN)) {
                              savreq=greqid;
                              curreq(rsyaud.request);
                              if (sameas(rsycmn->mysuffix,AUDSTR)) {
                                   clear(rsptmp);
                                   cntr=-1;
                                   switch(comval) {
                                   case AUDHOME:
                                        topaud();
                                        getaud();
                                        break;
                                   case AUDEND:
                                        initaud();
                                        getaud();
                                        break;
                                   case AUDPGDN:
                                        cntr=1;
                                        break;
                                   case AUDPGUP:
                                        cntr=0;
                                        break;
                                   case AUDDN:
                                        scraud(0);
                                        getaud();
                                        break;
                                   case AUDUP:
                                        scraud(1);
                                        getaud();
                                        break;
                                   default:
                                        break;
                                   }
                                   if (cntr != -1) {
                                        for (index=0 ; index < NUMADT ;
                                         index++) {
                                             scraud(cntr);
                                        }
                                        getaud();
                                   }
                              }
                              curreq(savreq);
                              rsp2read(NULL,STGLEN,rsptmp);
                              return;
                         }
                    }
               }
               else if (samepato(dynpak(GETSTT),dpkstg)) {
                    arg1=nxtarg(dpkstg);
                    nularg(arg1);
                    comval=atoi(arg1);
                    clear(rsptmp);
                    if ((comval >= LIUSTT) && (comval <= CUGSTT)) {
                         if (!haskey(syskey) && !ACCESS(OPSYSS)) {
                              rejectreq();
                              return;
                         }
                    }
                    switch(comval) {
                    case LIUSTT:
                         liugph();
                         break;
                    case SEBSTT:
                         sebgph();
                         break;
                    case TUHSTT:
                         tuhgph();
                         break;
                    case TUGSTT:
                         tuggph();
                         break;
                    case CUHSTT:
                         cuhgph();
                         break;
                    case CUGSTT:
                         cuggph();
                         break;
                    case DEMSTT:
                         if (haskey(syskey) || ACCESS(OPDEMS)) {
                              demstt();
                         }
                         else {
                              rejectreq();
                              return;
                         }
                         break;
                    case CLSSTT:
                         if (haskey(syskey) || ACCESS(OPCLSS)) {
                              clsstt();
                         }
                         else {
                              rejectreq();
                              return;
                         }
                         break;
                    case MSCSTT:
                         if (haskey(syskey) || ACCESS(OPMODS)) {
                              mscstt();
                         }
                         else {
                              rejectreq();
                              return;
                         }
                         break;
                    default:
                         break;
                    }
                    rsp2read(NULL,STGLEN,rsptmp);
                    return;
               }
               else if (samepato(dynpak(INTPRC),dpkstg) ||
                        samepato(fdynpak(INTPRC),dpkstg)) {
                    arg1=nxtarg(dpkstg);
                    arg2=nxtarg(arg1);
                    nularg(arg1);
                    nularg(arg2);
                    comval=atoi(arg1);
                    clireq=atoi(arg2);
                    rsyclp.request=srvrqid(usrnum,clireq);
                    if (ismyreq(rsyclp.request,RSYAPN)) {
                         switch (comval) {
                         case DIRCMD:
                              listdir();
                              return;
                         case CPYCMD:
                              if (prepcpy()) {
                                   return;
                              }
                              rsp2read(NULL,0,NULL);
                              return;
                         case DELCMD:
                              dodelt();
                              return;
                         case TYPCMD:
                              dotype();
                              return;
                         case DNLCMD:
                              dodnl();
                              return;
                         default:
                              break;
                         }
                    }
               }
          }
     }
     rejectreq();
}

static void rsywrite(
struct saunam *dpknam,
unsigned length,
void *value)
{
     char *dpkstg,*arg1,*arg2;
     int comval,savreq,stroff,outer,reqidx,reqnum;
     struct filinf *myfinptr;

     if (stdchk(rsckey)) {
          stlcpy(rsycmn->mysuffix,dpknam->suffix,SFXSIZ);
          rsycmn->myflags=0L;
          *namtmp=*dpknam;
          dpkstg=cnvs2d(namtmp);
          if (samepato(dynpak(PSTUSR),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPACCT)) {
                    stlcpy(rsyarg.usrnam,itemidx(value,0),UIDSIZ);
                    stlcpy(rsyarg.crdstr,itemidx(value,1),LNMSIZ);
                    if (sameas(itemidx(value,2),"paid")) {
                         rsyarg.real=1;
                    }
                    else {
                         rsyarg.real=0;
                    }
                    if (trkflgs&PSTTRK) {
                         shocst("REMOTE POSTING OF CREDITS",
                                "[%-23s]  Posted to: %-23s",usaptr->userid,
                                rsyarg.usrnam);
                    }
                    switch(addcrd(rsyarg.usrnam,rsyarg.crdstr,rsyarg.real)) {
                    case 0:
                         break;
                    case 1:
                         saycrd(rsyarg.crdstr,rsyarg.real);
                    case -1:
                         break;
                    }
                    rsp2write(TRUE,0,NULL);
                    return;
               }
          }
          else if (samepato(dynpak(LOGMSG),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPLOGN)) {
                    arg1=(char *)value;
                    xltctls(arg1);
                    stlcpy(sv.lonmsg,value,MTXSIZ);
                    if (trkflgs&LOGTRK) {
                         shocst("SYSTEM LOGON MESSAGE CHANGED",
                                "[%-35s]",usaptr->userid);
                    }
                    rsp2write(TRUE,0,NULL);
                    return;
               }
          }
          else if (samepato(dynpak(MSGUSR),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPSEND)) {
                    arg1=nxtarg(dpkstg);
                    if (onsysn(arg1,TRUE)) {
                         if (length > 0) {
                              snd2ch(othusn,value);
                              if (trkflgs&MSGTRK) {
                                   shocst("REMOTE MESSAGE SENT TO USER",
                                          "[%-23s]  Message to: %-23s",
                                          usaptr->userid,arg1);
                              }
                         }
                    }
                    rsp2write(TRUE,0,NULL);
                    return;
               }
          }
          else if (samepato(dynpak(MSGALL),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPSALL)) {
                    if (length > 0) {
                         snd2al(value);
                         if (trkflgs&AMSTRK) {
                              shocst("REMOTE MESSAGE SENT TO ALL",
                                        "[%-35s]",usaptr->userid);
                         }
                    }
                    rsp2write(TRUE,0,NULL);
                    return;
               }
          }
          else if (samepato(dynpak(SEARCH),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPSRCH)) {
                    arg1=nxtarg(dpkstg);
                    arg2=nxtarg(arg1);
                    nularg(arg1);
                    nularg(arg2);
                    comval=atoi(arg1);
                    rsyfnd.relate=atoi(arg2);
                    if ((comval >= FLDUID) && (comval <= FLDDAY)) {
                         rsyfnd.field=comval;
                         stlcpy(rsyfnd.srchstg,(char *)value,SSTSIZ);
                         setbtv(accbb);
                         if (slobtv(NULL)) {
                              rsyfnd.fpos=absbtv();
                              rstbtv();
                              cycleme(accsrch);
                              accsrch();
                              return;
                         }
                         else {
                              rstbtv();
                              rsp2write(TRUE,0,NULL);
                              return;
                         }
                    }
               }
          }
          else if (samepato(dynpak(AUDSTR),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPAUDT)) {
                    for (reqidx=0 ; reqidx < 30 ; reqidx++) {
                         reqnum=srvrqid(usrnum,reqidx);
                         if (ismyreq(reqnum,RSYAPN) && (reqnum != greqid)) {
                              savreq=greqid;
                              curreq(reqnum);
                              if (sameas(rsycmn->mysuffix,AUDSTR)) {
                                   rsp2write(TRUE,0,NULL);
                              }
                              curreq(savreq);
                         }
                    }
                    initaud();
                    rsyflg[usrnum]|=AUDFLG;
                    return;
               }
          }
          else if (samepato(dynpak(AUDSTP),dpkstg)) {
               rsyflg[usrnum]&=(~AUDFLG);
               for (reqidx=0 ; reqidx < 30 ; reqidx++) {
                    reqnum=srvrqid(usrnum,reqidx);
                    if (ismyreq(reqnum,RSYAPN) && (reqnum != greqid)) {
                         savreq=greqid;
                         curreq(reqnum);
                         if (sameas(rsycmn->mysuffix,AUDSTR)) {
                              rsp2write(TRUE,0,NULL);
                         }
                         curreq(savreq);
                    }
               }
               rsp2write(TRUE,0,NULL);
               return;
          }
          else if (samepato(dynpak(INTERP),dpkstg)) {
               for (reqidx=0 ; reqidx < 30 ; reqidx++) {
                    reqnum=srvrqid(usrnum,reqidx);
                    if (ismyreq(reqnum,RSYAPN) && (reqnum != greqid)) {
                         savreq=greqid;
                         curreq(reqnum);
                         if (sameas(rsycmn->mysuffix,INTERP)) {
                              rsp2write(TRUE,0,NULL);
                         }
                         curreq(savreq);
                    }
               }
               arg1=nxtarg(dpkstg);
               comval=atoi(arg1);
               clear(rsptmp);
               switch (comval) {
               case DIRCMD:
                    if (haskey(syskey) || ACCESS(OPDIR)) {
                         rsycmn->myflags|=DIRREQ;
                         stlcpy(rsyclp.sfname,value,FNDSIZE);
                         if (trkflgs&DIRTRK) {
                              shocst("REMOTE DIR COMMAND USED",
                                     "[%-23s]  arg: %-29s",usaptr->userid,
                                     value);
                         }
                         if (strtfil()) {
                              return;
                         }
                         catrsp(RSPERR);
                         delimiter();
                         catrsp("DIR");
                         rsp2write(FALSE,STGLEN,rsptmp);
                         return;
                    }
                    break;
               case CPYCMD:
                    if (haskey(syskey) || ACCESS(OPCOPY)) {
                         rsycmn->myflags|=CPYREQ;
                         arg1=value;
                         arg2=nxtarg(arg1);
                         nularg(arg1);
                         nularg(arg2);
                         if (*arg1 != '\0' && *arg2 != '\0') {
                              stlcpy(rsyclp.sfname,arg1,FNDSIZE);
                              stlcpy(rsyclp.dfname,arg2,FNDSIZE);
                              if (trkflgs&CPYTRK) {
                                   shocst("REMOTE COPY COMMAND USED",
                                          "[%-15s] arg1: %-15s arg2: %-15s",
                                          usaptr->userid,arg1,arg2);
                              }
                              if (strtcpy()) {
                                   return;
                              }
                         }
                         catrsp(RSPERR);
                         delimiter();
                         catrsp("CPY");
                         rsp2write(FALSE,STGLEN,rsptmp);
                         return;
                    }
                    break;
               case DELCMD:
                    if (haskey(syskey) || ACCESS(OPDEL)) {
                         rsycmn->myflags|=DELREQ;
                         arg1=value;
                         nularg(arg1);
                         if (*arg1 != '\0') {
                              stlcpy(rsyclp.sfname,arg1,FNDSIZE);
                              if (trkflgs&DELTRK) {
                                   shocst("REMOTE DEL COMMAND USED",
                                          "[%-23s] arg: %-20s",usaptr->userid,
                                          arg1);
                              }
                              if (strtdel()) {
                                   return;
                              }
                         }
                         catrsp(RSPERR);
                         delimiter();
                         catrsp("DEL");
                         rsp2write(FALSE,STGLEN,rsptmp);
                         return;
                    }
                    break;
               case TYPCMD:
                    if (haskey(syskey) || ACCESS(OPTYPE)) {
                         rsycmn->myflags|=TYPREQ;
                         arg1=value;
                         nularg(arg1);
                         stlcpy(rsyclp.sfname,arg1,FNDSIZE);
                         if (trkflgs&TYPTRK) {
                              shocst("REMOTE TYPE COMMAND USED",
                                     "[%-23s] arg: %-20s",usaptr->userid,
                                     arg1);
                         }
                         if (strttyp()) {
                              return;
                         }
                         catrsp(RSPERR);
                         delimiter();
                         catrsp("TYP");
                         rsp2write(FALSE,STGLEN,rsptmp);
                         return;
                    }
                    break;
               case MKDCMD:
                    if (haskey(syskey) || ACCESS(OPMD)) {
                         arg1=value;
                         nularg(arg1);
                         stlcpy(vdatmp,arg1,FNDSIZE);
                         if (trkflgs&MDTRK) {
                              shocst("REMOTE MD COMMAND USED",
                                     "[%-23s] arg: %-20s",usaptr->userid,
                                     arg1);
                         }
                         clear(rsptmp);
                         if (mkdir(vdatmp) == 0) {
                              stlcpy(rsptmp,vdatmp,FNDSIZE);
                              rsp2write(TRUE,STGLEN,rsptmp);
                              return;
                         }
                         catrsp(RSPERR);
                         delimiter();
                         catrsp("MD");
                         rsp2write(FALSE,STGLEN,rsptmp);
                         return;
                    }
                    break;
               case RMDCMD:
                    if (haskey(syskey) || ACCESS(OPRD)) {
                         arg1=value;
                         nularg(arg1);
                         stlcpy(vdatmp,arg1,FNDSIZE);
                         if (trkflgs&RDTRK) {
                              shocst("REMOTE RD COMMAND USED",
                                     "[%-23s] arg: %-20s",usaptr->userid,
                                     arg1);
                         }
                         clear(rsptmp);
                         if (rmdir(vdatmp) == 0) {
                              stlcpy(rsptmp,vdatmp,FNDSIZE);
                              rsp2write(TRUE,STGLEN,rsptmp);
                              return;
                         }
                         catrsp(RSPERR);
                         delimiter();
                         catrsp("RD");
                         rsp2write(FALSE,STGLEN,rsptmp);
                         return;
                    }
                    break;
               case RENCMD:
                    if (haskey(syskey) || ACCESS(OPRENM)) {
                         arg1=value;
                         arg2=nxtarg(arg1);
                         nularg(arg1);
                         nularg(arg2);
                         stlcpy(rsyclp.sfpath,stppath(arg1),FNDSIZE);
                         stlcpy(rsyclp.sfname,arg1,FNDSIZE);
                         stlcpy(rsyclp.dfname,rsyclp.sfpath,FNDSIZE);
                         stlcat(rsyclp.dfname,stpname(arg2),FNDSIZE);
                         clear(rsptmp);
                         if (trkflgs&RENTRK) {
                              shocst("REMOTE RENAME COMMAND USED",
                                        "[%-15s] arg1: %-15s arg2: %-15s",
                                        usaptr->userid,rsyclp.sfname,
                                        rsyclp.dfname);
                         }
                         if (rename(rsyclp.sfname,rsyclp.dfname) == 0) {
                              stlcpy(rsptmp,rsyclp.sfname,81);
                              stlcat(rsptmp,"->",81);
                              stlcat(rsptmp,rsyclp.dfname,81);
                              rsp2write(TRUE,STGLEN,rsptmp);
                              return;
                         }
                         catrsp(RSPERR);
                         delimiter();
                         catrsp("REN");
                    }
                    break;
               case DNLCMD:
               case LNCCMD:
                    if (haskey(syskey) || ACCESS(OPTRNF)) {
                         rsycmn->myflags|=DNLREQ;
                         arg1=value;
                         nularg(arg1);
                         stlcpy(rsyclp.sfname,arg1,FNDSIZE);
                         if ((trkflgs&GETTRK) || (trkflgs&LNCTRK)) {
                              shocst("REMOTE GET/LAUNCH COMMAND USED",
                                     "[%-23s] arg: %-20s",usaptr->userid,
                                     arg1);
                         }
                         if (strtdnl()) {
                              return;
                         }
                         rsp2write(TRUE,0,NULL);
                         return;
                    }
                    break;
               case UPLCMD:
                    if (haskey(syskey) || ACCESS(OPTRNF)) {
                         rsycmn->myflags|=UPLREQ;
                         arg1=value;
                         nularg(arg1);
                         stroff=strlen(arg1);
                         if (trkflgs&PUTTRK) {
                              shocst("REMOTE PUT COMMAND USED",
                                     "[%-23s] arg: %-20s",usaptr->userid,
                                     arg1);
                         }
                         if (stroff > 0) {
                              if (*(arg1+stroff-1) == '\\') {
                                   rsyclp.multifil=TRUE;
                              }
                              else if ((rsyclp.multifil=isdir(arg1)) == TRUE) {
                                   stlcpy(rsyclp.dfpath,arg1,FNDSIZE);
                                   stlcat(rsyclp.dfpath,"\\",FNDSIZE);
                              }
                              else {
                                   stlcpy(rsyclp.dfpath,stppath(arg1),FNDSIZE);
                                   stlcpy(rsyclp.dfname,stpname(arg1),FNDSIZE);
                              }
                              return;
                         }
                         else {
                              stlcpy(rsyclp.dfpath,".\\",FNDSIZE);
                              rsyclp.multifil=TRUE;
                              return;
                         }
                    }
                    break;
               default:
                    break;
               }
          }
          else if (samepato(fdynpak(UPLMNU),dpkstg)) {
               if (haskey(syskey) || ACCESS(OPTRNF)) {
                    if (upldmnu) {
                         rejectreq();
                         return;
                    }
                    upldmnu=TRUE;
                    ok2write("newmenu.$$$");
                    return;
               }
          }
          else if (samepato(fdynpak(INTPRC),dpkstg)) {
               arg1=nxtarg(dpkstg);
               arg2=nxtarg(arg1);
               nularg(arg1);
               nularg(arg2);
               comval=atoi(arg1);
               outer=atoi(arg2);
               rsyclp.request=srvrqid(usrnum,outer);
               switch (comval) {
               case UPLCMD:
                    if (ismyreq(rsyclp.request,RSYAPN)) {
                         rsycmn->myflags|=UPLREQ;
                         myfinptr=FINFPTR;
                         rsyclp.myfinf=*myfinptr;
                         savreq=greqid;
                         curreq(rsyclp.request);
                         if (rsycmn->myflags&UPLREQ) {
                              clear(rsptmp);
                              cpyrsp(rsyclp.dfpath);
                              if (rsyclp.multifil == TRUE) {
                                   catrsp(myfinptr->name);
                              }
                              else {
                                   catrsp(rsyclp.dfname);
                              }
                              curreq(savreq);
                              if (rsvnam(rsptmp)) {
                                   rejectreq();
                                   return;
                              }
                              ok2write(rsptmp);
                              return;
                         }
                         curreq(savreq);
                    }
                    break;
               default:
                    break;
               }
          }
     }
     rejectreq();
}

static void
rsyxdone(void)
{
     extern BTVFILE *mnubb;

     if (rsycmn->myflags&UPLREQ) {
          rsp2write(TRUE,0,NULL);
     }
     if (sameas(rsycmn->mysuffix,UPLMNU)) {
          clsbtv(mnubb);
          unlink("bbsmenu.dat");
          rename("newmenu.$$$","bbsmenu.dat");
          mnubb=opnbtv("bbsmenu.dat",sizeof(struct mnupag));
          shocst("NEW BBSMENU.DAT UPLOADED","Uploading user: %s",
                 usaptr->userid);
          rsp2write(TRUE,0,NULL);
          upldmnu=FALSE;
     }
     if (sameto(INTPRC,rsycmn->mysuffix)) {
          if (sameas("bbsmenu.dat",rsyclp.dirblk.name)) {
               lockmnu(FALSE);
          }
     }
}

static void
rsyabort(void)
{
     if (sameas(rsycmn->mysuffix,AUDSTR)) {
          rsyflg[usrnum]&=(~AUDFLG);
     }
     else if (sameas(rsycmn->mysuffix,SCHCHR)) {
          rsyflg[usrnum]&=(~CHRFLG);
     }
     else if (sameas(rsycmn->mysuffix,SCHLNG)) {
          rsyflg[usrnum]&=(~LGDFLG);
     }
     else if (sameas(rsycmn->mysuffix,UPLMNU)) {
          unlink("newmenu.$$$");
          upldmnu=FALSE;
     }
     if (sameto(INTPRC,rsycmn->mysuffix)) {
          if (sameas("bbsmenu.dat",rsyclp.dirblk.name)) {
               lockmnu(FALSE);
          }
     }
     if (rsycmn->myflags&CPYREQ) {
          rsyclp.status=WRKDON;
          if (rsyclp.sfptr != NULL) {
               fclose(rsyclp.sfptr);
               rsyclp.sfptr=NULL;
          }
          if (rsyclp.dfptr != NULL) {
               fclose(rsyclp.dfptr);
               rsyclp.dfptr=NULL;
               unlink(rsyclp.dfname);
          }
     }
     else if (rsycmn->myflags&TYPREQ) {
          if (rsyclp.sfptr != NULL) {
               fclose(rsyclp.sfptr);
               rsyclp.sfptr=NULL;
          }
     }
}

static void
dosabt(void)                       /* handle "about" info for DOS server   */
{
     catrsp(version);
     catrsp(subvers);
     delimiter();
     catrsp(osversn());
     delimiter();
     if (multsk) {
          catrsp("Yes - ");
          if (mulmth == COMIRP) {
               catrsp("Interrupt");
          }
          else {
               catrsp("Timer");
          }
     }
     else {
          catrsp("No");
     }
     delimiter();
     if (btrset[0] != '\0') {
          catrsp(btrset);
     }
     else {
          catrsp("defaults");
     }
     delimiter();
     catrsp(itoa(curdlls,vdatmp,10));
}

static void
getntrm(void)                      /* get nterms into rsptmp               */
{
     catrsp(itoa(nterms,vdatmp,10));
}

static void
getsyst(void)                      /* get system statistics into rsptmp    */
{
     unsigned long ravl=0L, eavl=0L;

     catrsp(dbytes(getdfre(0)));
     delimiter();
     catrsp("N/A");
     delimiter();
     DosRealAvail(&ravl);
     DosMemAvail(&eavl);
     catrsp(dbytes(eavl));
     delimiter();
     catrsp(dbytes(ravl));
}

static void
legends(                      /* this hook to schochl() updates legend info*/
int chan)                     /*   channel currently serviced by shochl()  */
{
     shwchr(chan);
     shwlng(chan);
}

static void
shwchr(                       /* show channel character legend matrix      */
int chan)                     /*   channel whose information is changed    */
{
     int index;
     struct saunam rfdpk;
     char tmpstr[17];

     cpyvda(itoa((chan&0x0F),tmpstr,10));
     vdelimiter();
     catvda(itoa(((chan&0xF0)>>4),tmpstr,10));
     vdelimiter();
     catvda(itoa(uidarr[chan].sing,tmpstr,10));
     vdelimiter();
     catvda(itoa(uidarr[chan].attrib,tmpstr,10));
     setmem(&rfdpk,sizeof(struct saunam),0);
     stlcpy(rfdpk.sysid,msysid,SIDSIZ);
     stlcpy(rfdpk.appid,RSYAPN,AIDSIZ);
     rfdpk.usrid[0]='\0';
     stlcpy(rfdpk.suffix,SCHCHR,SFXSIZ);
     for (index=0 ; index < nterms ; index++) {
          if ((user[index].flags&ISGCSU) && (rsyflg[index]&CHRFLG)) {
               if (qroom(index,NORMAL)) {
                    senddpk(index,RSYAPN,NORMAL,&rfdpk,STGLEN,vdatmp);
               }
          }
          else {
               if (rsyflg[usrnum]&CHRFLG) {
                    rsyflg[usrnum]&=(~CHRFLG);
               }
          }
     }
}

static void
shwlng(                       /* show visible channel legend text          */
int chan)                     /*   channel to get string for               */
{
     struct saunam rfdpk;
     int index;
     char tmpstr[17];

     cpyvda(itoa(chan,tmpstr,10));
     vdelimiter();
     catvda(uidarr[chan].labl);
     setmem(&rfdpk,sizeof(struct saunam),0);
     stlcpy(rfdpk.sysid,msysid,SIDSIZ);
     stlcpy(rfdpk.appid,RSYAPN,AIDSIZ);
     rfdpk.usrid[0]='\0';
     stlcpy(rfdpk.suffix,SCHLNG,SFXSIZ);
     for (index=0 ; index < nterms ; index++) {
          if ((user[index].flags&ISGCSU) && (rsyflg[index]&LGDFLG)) {
               if (qroom(index,NORMAL)) {
                    senddpk(index,RSYAPN,NORMAL,&rfdpk,STGLEN,vdatmp);
               }
          }
          else {
               if (rsyflg[usrnum]&LGDFLG) {
                    rsyflg[usrnum]&=(~LGDFLG);
               }
          }
     }
}

char *
rtmfmt(                            /* format Response Time number          */
unsigned long ntval)               /* interval, 1/65536 second units       */
{                                  /* returns pointer to 7-character string*/
     char *cp;

     if (ntval >= HRTONE) {
          if (strlen(cp=ul2as((ntval+HRTONE/2)>>16)) > 3) {
               return("999 sec");
          }
          else if ((ntval=((ntval+HRTONE/20)*10)>>16) > 99L) {
               return(spr("%3s sec",cp));
          }
          else {
               return(spr("%d.%d sec",((int)ntval)/10,((int)ntval)%10));
          }
     }
     else {
          if (strlen(cp=ul2as(ntval=((ntval+HRTONE/2000)*1000)>>16)) > 3) {
               return(" 999 ms");
          }
          else if (ntval > 0L) {
               return(spr("%4s ms",cp));
          }
          else {
               return(" < 1 ms");
          }
     }
}

static BOOL
strtfil(void)                 /* get first file name for a directory list  */
{
     if (!iswild(rsyclp.sfname)) {
          if (isdir(rsyclp.sfname)) {
               stlcat(rsyclp.sfname,"\\*.*",FNDSIZE);
          }
          else {
               fixfil(rsyclp.sfname);
          }
     }
     if (fnd1st(&rsyclp.dirblk,rsyclp.sfname,FAMDIR)) {
          return(TRUE);
     }
     return(FALSE);
}

static BOOL
strtdnl(void)                 /* get first filename for download suite     */
{
     if (iswild(rsyclp.sfname)) {
          rsyclp.multifil=TRUE;
     }
     else if (isdir(rsyclp.sfname)) {
          stlcat(rsyclp.sfname,"\\*.*",FNDSIZE);
          rsyclp.multifil=TRUE;
     }
     stlcpy(rsyclp.sfpath,stppath(rsyclp.sfname),FNDSIZE);
     rsyclp.multifil=iswild(rsyclp.sfname);
     if (fnd1st(&rsyclp.dirblk,rsyclp.sfname,0)) {
          return(TRUE);
     }
     return(FALSE);
}

static BOOL
strtcpy(void)                 /* get first filename for file copy          */
{
     rsyclp.status=WRKDON;
     if ((rsyclp.multifil=iswild(rsyclp.sfname)) != FALSE) {
          if (!isdir(rsyclp.dfname)) {
               return(FALSE);
          }
     }
     else if ((rsyclp.multifil=isdir(rsyclp.sfname)) != FALSE) {
          stlcat(rsyclp.sfname,"\\*.*",FNDSIZE);
          if (!isdir(rsyclp.dfname)) {
               return(FALSE);
          }
     }
     else {
          rsyclp.multifil=iswild(fixfil(rsyclp.sfname));
     }
     if ((rsyclp.multifil) || isdir(rsyclp.dfname)) {
          stlcpy(rsyclp.sfpath,stppath(rsyclp.sfname),FNDSIZE);
          stlcpy(rsyclp.dfpath,makpath(rsyclp.dfname),FNDSIZE);
          if (!rsyclp.multifil) {
               stlcpy(rsyclp.dfname,rsyclp.dfpath,FNDSIZE);
               stlcat(rsyclp.dfname,stpname(rsyclp.sfname),FNDSIZE);
          }
     }
     if (fnd1st(&rsyclp.dirblk,rsyclp.sfname,0)) {
          return(TRUE);
     }
     return(FALSE);
}

static BOOL
strtdel(void)                 /* get first filename for delete operation   */
{
     rsyclp.multifil=FALSE;
     if (iswild(rsyclp.sfname)) {
          rsyclp.multifil=TRUE;
     }
     else if (isdir(rsyclp.sfname)) {
          stlcat(rsyclp.sfname,"\\*.*",FNDSIZE);
          rsyclp.multifil=TRUE;
     }
     if (rsyclp.multifil) {
          stlcpy(rsyclp.dfpath,stppath(rsyclp.sfname),FNDSIZE);
     }
     if (fnd1st(&rsyclp.dirblk,rsyclp.sfname,0)) {
          return(TRUE);
     }
     return(FALSE);
}

static BOOL
strttyp(void)                 /* get filename for type operation           */
{
     if (iswild(rsyclp.sfname) || isdir(rsyclp.sfname)
         || rsvnam(rsyclp.sfname)) {
          return(FALSE);
     }
     rsyclp.sfptr=fopen(rsyclp.sfname,FOPRA);
     if (rsyclp.sfptr == NULL) {
          return(FALSE);
     }
     return(TRUE);
}

static void
dotype(void)                  /* Handle the file viewing process           */
{
     int savreq,hldreq;

     clear(rsptmp);
     savreq=greqid;
     curreq(rsyclp.request);
     if (rsycmn->myflags&TYPREQ) {
          clear(vdatmp);
          if (fgets(vdatmp,81,rsyclp.sfptr) != NULL) {
               stlcpy(rsptmp,vdatmp,81);
               curreq(savreq);
               rsp2read(NULL,STGLEN,stp4cs(rsptmp));
               return;
          }
          else {
               fclose(rsyclp.sfptr);
               rsyclp.sfptr=NULL;
               curreq(savreq);
               hldreq=rsyclp.request;
               rsp2read(NULL,STGLEN,stp4cs(rsptmp));
               curreq(hldreq);
               rsp2write(TRUE,0,NULL);
               return;
          }
     }
     curreq(savreq);
     rejectreq();
}

static void
dodelt(void)                  /* handle the cycled deleting process        */
{
     int savreq,hldreq;

     clear(rsptmp);
     savreq=greqid;
     curreq(rsyclp.request);
     if (rsycmn->myflags&DELREQ) {
          if (rsyclp.multifil) {
               stlcpy(rsyclp.sfname,rsyclp.dfpath,FNDSIZE);
               stlcat(rsyclp.sfname,rsyclp.dirblk.name,FNDSIZE);
          }
          if (unlink(rsyclp.sfname) == 0) {
               stlcpy(rsptmp,rsyclp.sfname,81);
               stlcat(rsptmp," Deleted!",81);
          }
          curreq(savreq);
          hldreq=rsyclp.request;
          rsp2read(NULL,STGLEN,rsptmp);
          curreq(hldreq);
          if (!rsyclp.multifil) {
               rsp2write(TRUE,0,NULL);
          }
          else if (!fndnxt(&rsyclp.dirblk)) {
               rsp2write(TRUE,0,NULL);
          }
     }
}

static BOOL
prepcpy(void)                 /* prepare for cycled copy processing        */
{
     int savreq;

     savreq=greqid;
     curreq(rsyclp.request);
     if (!(rsycmn->myflags&CPYREQ) || (rsyclp.status == WRKING)) {
          curreq(savreq);
          return(FALSE);
     }
     rsyclp.status=WRKING;
     if (rsyclp.multifil) {
          stlcpy(rsyclp.dfname,rsyclp.dfpath,FNDSIZE);
          stlcat(rsyclp.dfname,rsyclp.dirblk.name,FNDSIZE);
          stlcpy(rsyclp.sfname,rsyclp.sfpath,FNDSIZE);
          stlcat(rsyclp.sfname,rsyclp.dirblk.name,FNDSIZE);
     }
     if (rsvnam(rsyclp.sfname) || rsvnam(rsyclp.dfname)) {
          cycleme(NULL);
          rsyclp.status=WRKDON;
          rsyclp.sfptr=NULL;
          rsyclp.dfptr=NULL;
          rsp2write(NULL,0,NULL);
          curreq(savreq);
          return(FALSE);
     }
     rsyclp.sfptr=fopen(rsyclp.sfname,FOPRB);
     rsyclp.dfptr=fopen(rsyclp.dfname,FOPWB);
     if ((rsyclp.sfptr == NULL) || (rsyclp.dfptr == NULL)) {
          cycleme(NULL);
          rsyclp.status=WRKDON;
          if (rsyclp.sfptr != NULL) {
               fclose(rsyclp.sfptr);
          }
          if (rsyclp.dfptr != NULL) {
               fclose(rsyclp.dfptr);
          }
          rsyclp.sfptr=NULL;
          rsyclp.dfptr=NULL;
          rsp2write(NULL,0,NULL);
          curreq(savreq);
          return(FALSE);
     }
     curreq(savreq);
     cycleme(docopy);
     return(TRUE);
}

static void
docopy(void)                  /* perform the actual copy process           */
{
     int siz,savreq,hldreq;
     long tdstamp;

     savreq=greqid;
     if (ismyreq(rsyclp.request,RSYAPN)) {
          curreq(rsyclp.request);
          if (rsycmn->myflags&CPYREQ) {
               if ((rsyclp.sfptr != NULL) && (rsyclp.dfptr != NULL)) {
                    siz=fread(vdatmp,1,CPYSIZ,rsyclp.sfptr);
                    if (siz > 0) {
                         fwrite(vdatmp,1,siz,rsyclp.dfptr);
                    }
                    if (siz <= 0) {
                         cycleme(NULL);
                         rsyclp.status=WRKDON;
                         if (rsyclp.sfptr != NULL) {
                              tdstamp=getdtd(fileno(rsyclp.sfptr));
                              fclose(rsyclp.sfptr);
                              rsyclp.sfptr=NULL;
                              setdtd(rsyclp.dfname,(unsigned)tdstamp,
                                        (unsigned)(tdstamp>>16));
                         }
                         if (rsyclp.dfptr != NULL) {
                              fclose(rsyclp.dfptr);
                              rsyclp.dfptr=NULL;
                         }
                         clear(rsptmp);
                         cpyrsp(rsyclp.sfname);
                         curreq(savreq);
                         hldreq=rsyclp.request;
                         rsp2read(NULL,STGLEN,rsptmp);
                         curreq(hldreq);
                         if (rsyclp.multifil) {

                              if (!fndnxt(&rsyclp.dirblk)) {
                                   rsp2write(TRUE,0,NULL);
                              }
                         }
                         else {
                              rsp2write(TRUE,0,NULL);
                         }
                         return;
                    }
               }
               else {
                    curreq(savreq);
                    cycleme(NULL);
                    rejectreq();
               }
          }
          else {
               curreq(savreq);
               cycleme(NULL);
               rejectreq();
          }
          curreq(savreq);
     }
     else {
          rejectreq();
     }
}

static void
dodnl(void)                   /* Perform the actual download process       */
{
     int savreq,hldreq;

     savreq=greqid;
     curreq(rsyclp.request);
     clear(rsptmp);
     clear(vdatmp);
     if (rsycmn->myflags&DNLREQ) {
          cpyrsp(rsyclp.sfpath);
          catrsp(rsyclp.dirblk.name);
          cpyvda(rsyclp.dirblk.name);
          if (sameas("bbsmenu.dat",rsyclp.dirblk.name)) {
               hldreq=greqid;
               curreq(savreq);
               stlcpy(rsyclp.dirblk.name,vdatmp,FNDSIZE);
               curreq(hldreq);
               if (!lockmnu(TRUE)) {
                    hldreq=greqid;
                    curreq(savreq);
                    rsp2read(NULL,0,NULL);
                    curreq(hldreq);
                    rsp2write(TRUE,0,NULL);
                    return;
               }
          }
          hldreq=greqid;
          curreq(savreq);
          rsp2read(NULL,STGLEN,rsptmp);
          curreq(hldreq);
          if (!fndnxt(&rsyclp.dirblk)) {
               rsp2write(TRUE,0,NULL);
          }
     }
}

static void
listdir(void)                 /* get a directory listing from server       */
{
     int hr,savreq,hldreq;

     savreq=greqid;
     curreq(rsyclp.request);
     clear(vdatmp);
     if (rsycmn->myflags&DIRREQ) {
          hr=dthour(rsyclp.dirblk.time)%12;
          if (hr == 0) {
               hr=12;
          }
          cpyvda(spr("%-12.12s ",rsyclp.dirblk.name));
          catvda(spr("%8.8s ",(rsyclp.dirblk.attr&FAMDIR) ?
             "<DIR>" : l2as(rsyclp.dirblk.size)));
          catvda(spr("%8.8s ",ncdate(rsyclp.dirblk.date)));
          catvda(spr("%2d:%02d%s",hr,dtmin(rsyclp.dirblk.time),
             ((dthour(rsyclp.dirblk.time)/12) ? "p" : "a")));
          clear(rsptmp);
          cpyrsp(vdatmp);
          curreq(savreq);
          hldreq=rsyclp.request;
          rsp2read(NULL,STGLEN,rsptmp);
          curreq(hldreq);
          if (!fndnxt(&rsyclp.dirblk)) {
               rsp2write(TRUE,0,NULL);
          }
     }
}

static char *
stpname(                      /* get a pointer to filename sans path       */
char *fname)                  /*   fully qualified filespec                */
{
     int stroff;
     char *sptr;

     stlcpy(vdatmp,fname,FNDSIZE);
     stroff=strlen(vdatmp);
     if (stroff > 0) {
          sptr=vdatmp+stroff-1;
     }
     else {
          clear(vdatmp);
          return(vdatmp);
     }
     while ((*sptr != '\\') && (sptr > vdatmp)) {
          sptr--;
     }
     if (*sptr == '\\' && (sptr < vdatmp+stroff-1)) {
          sptr++;
     }
     if (*sptr == NULL) {
          clear(vdatmp);
          return(vdatmp);
     }
     return(sptr);
}

static char *
makpath(char *fname)          /* expand string to qualified pathname       */
{
     int stroff;

     stroff=strlen(fname);
     if (stroff > 0) {
          switch(*(fname+stroff-1)) {
          case '\\':
               break;
          default:
               stlcat(fname,"\\",FNDSIZE);
               break;
          }
     }
     else {
          stlcpy(fname,"\\",FNDSIZE);
     }
     return(fname);
}

static char *
stppath(char *fname)          /* strip the pathname from a filespec        */
{
     int stroff;
     char *sptr;

     stlcpy(vdatmp,fname,FNDSIZE);
     stroff=strlen(vdatmp);
     if (stroff > 0) {
          sptr=vdatmp+stroff-1;
     }
     else {
          clear(vdatmp);
          return(vdatmp);
     }
     while ((*sptr != '\\') && (sptr > vdatmp)) {
          sptr--;
     }
     if ((*sptr == '\\') && (sptr < vdatmp+stroff-1)) {
          sptr++;

     }
     *sptr='\0';
     return(vdatmp);
}


static BOOL
iswild(                       /* does this filespec contain wildcards?     */
char *fname)                  /*   filename to check for wildcards         */
{
     if ((strchr(fname,'*') != NULL) || (strchr(fname,'?') != NULL)) {
          return(TRUE);
     }
     return(FALSE);
}

static char *
fixfil(                       /* this will fix args to give full filespec  */
char *fname)                  /*   passed filename which may be modified   */
{
     int stroff;

     stroff=strlen(fname);
     if (stroff > 0) {
          switch(*(fname+(stroff-1))) {
          case '.':
               stlcat(fname,"\\*.*",FNDSIZE);
               break;
          case ':':
          case '\\':
               stlcat(fname,"*.*",FNDSIZE);
               break;
          default:
               break;
          }
     }
     else {
          stlcat(fname,".\\*.*",FNDSIZE);
     }
     return(fname);
}

static BOOL
isdir(                        /* is the path filespec a directory?         */
char *fname)                  /*   filename spec to check                  */
{
     struct fndblk fnblk;

     if (fnd1st(&fnblk,fname,FAMDIR)) {
          if (fnblk.attr&FAMDIR) {
               return(TRUE);
          }
     }
     return(FALSE);
}


static BOOL
doswitch(                     /* swtclass vector for account change        */
struct usracc *usract,        /*   user account to switch                  */
char *class,                  /*   name of class to switch them to         */
int days)                     /*   number of days to remain in class       */
{
     struct clstab *clptr;

     (void)days;
     clptr=fndcls(class);
     if (clptr != NULL) {
          if (clptr->flags&DAYEXP) {
               swtcls(usract,1,class,3,clptr->dftday);
          }
          else if (!(clptr->flags&HASCRD && clptr->flags&NOCRED)) {
               swtcls(usract,1,class,3,0);
          }
          else {
               return(FALSE);
          }
     }
     else {
          return(FALSE);
     }
     return(TRUE);
}

static void
initaud(void)                      /* initialize the audit trail at end    */
{
     int i;

     setbtv(audbb);
     rsyaud.faddle=FALSE;
     setmem(rsyaud.ratptrs,sizeof(rsyaud.ratptrs),0);
     ghibtv(NULL,0);
     for (i=1 ; i <= NUMADT ; i++) {
          rsyaud.ratptrs[NUMADT-i]=absbtv();
          if (!qprbtv()) {
               break;
          }
     }
     rstbtv();
}

static void
topaud(void)                       /* scroll to topmost part of audit trail*/
{
     int i,j;
     long tmpptrs[NUMADT];

     setbtv(audbb);
     rsyaud.faddle=TRUE;
     setmem(tmpptrs,sizeof(tmpptrs),0);
     setmem(rsyaud.ratptrs,sizeof(rsyaud.ratptrs),0);
     globtv(NULL,0);
     for (i=0 ; i < NUMADT ; i++) {
          tmpptrs[i]=absbtv();
          if (!qnxbtv()) {
               break;
          }
     }
     j=NUMADT-1;
     for (i=1 ; i <= NUMADT ; i++) {
          if (tmpptrs[NUMADT-i] != 0) {
               rsyaud.ratptrs[j]=tmpptrs[NUMADT-i];
               j--;
          }
     }
     if (j >= 0) {
          rsyaud.faddle=FALSE;
     }
     rstbtv();
}

static void
scraud(                            /* scroll audit trail pointers around   */
int dirct)                         /*   direction-> 0=up, 1=down           */
{
     setbtv(audbb);
     rsyaud.faddle=TRUE;
     if (dirct) {
          gabbtv(NULL,rsyaud.ratptrs[NUMADT-1],0);
          if (qnxbtv()) {
               movmem(rsyaud.ratptrs+1,rsyaud.ratptrs,(NUMADT-1)*sizeof(long));
               rsyaud.ratptrs[NUMADT-1]=absbtv();
          }
          else {
               rsyaud.faddle=FALSE;
          }
     }
     else if (rsyaud.ratptrs[0] != 0) {
          gabbtv(NULL,rsyaud.ratptrs[0],0);
          movmem(rsyaud.ratptrs,rsyaud.ratptrs+1,(NUMADT-1)*sizeof(long));
          if (qprbtv()) {
               rsyaud.ratptrs[0]=absbtv();
          }
          else {
               rsyaud.ratptrs[0]=0;
          }
     }
     rstbtv();
}

static void
getaud(void)                       /* get full audit trail lines           */
{
     int index;

     setbtv(audbb);
     for (index=0 ; index < NUMADT ; index++) {
          if (rsyaud.ratptrs[index] != 0) {
               gabbtv(NULL,rsyaud.ratptrs[index],0);
               catrsp(audbb->data);
               delimiter();
               catrsp(audbb->data+67);
               if (index < (NUMADT-1)) {
                    delimiter();
               }
          }
          else {
               delimiter();
               if (index < (NUMADT-1)) {
                    delimiter();
               }
          }
     }
     rstbtv();
}

static void
rsyfadd(void)                       /* add new entry to the audit trail    */
{
     void *mrqptr;
     int usridx,reqidx,reqnum;
     struct saunam rfdpk;
     long audptr;

     setbtv(audbb);
     ghibtv(NULL,0);
     audptr=absbtv();
     for (usridx=0 ; usridx < nterms ; usridx++) {
          if ((user[usridx].flags&ISGCSU) && (rsyflg[usridx]&AUDFLG)) {
               for (reqidx=0 ; reqidx < 30 ; reqidx++) {
                    reqnum=srvrqid(usridx,reqidx);
                    if (ismyreq(reqnum,RSYAPN)) {
                         mrqptr=(void *)mrqoff(reqnum);
                         if (sameas(rsycmn->mysuffix,AUDSTR)) {
                              if (rsyaud.faddle == FALSE) {
                                   movmem(rsyaud.ratptrs+1,rsyaud.ratptrs,
                                          (NUMADT-1)*sizeof(long));
                                   rsyaud.ratptrs[NUMADT-1]=audptr;
                                   if (qroom(usridx,NORMAL)) {
                                        setmem(&rfdpk,sizeof(struct saunam),0);
                                        stlcpy(rfdpk.sysid,msysid,SIDSIZ);
                                        stlcpy(rfdpk.appid,RSYAPN,AIDSIZ);
                                        rfdpk.usrid[0]='\0';
                                        stlcpy(rfdpk.suffix,AUDNOT,SFXSIZ);
                                        senddpk(usridx,RSYAPN,NORMAL,&rfdpk,
                                                0,NULL);
                                   }
                                   break;
                              }
                         }
                    }
               }
          }
     }
     rstbtv();
}

static void
accsrch(void)                      /* Search the account database          */
{
     struct saunam rfdpk;
     struct usracc tmpacc;
     BOOL found;

     setbtv(accbb);
     clear(vdatmp);
     gabbtv(&tmpacc,rsyfnd.fpos,0);
     found=FALSE;
     switch(rsyfnd.field) {
     case FLDUID:
          found=chkstr(tmpacc.userid);
          break;
     case FLDNAM:
          found=chkstr(tmpacc.usrnam);
          break;
     case FLDPWD:
          found=chkstr(tmpacc.psword);
          break;
     case FLDCMP:
          found=chkstr(tmpacc.usrad1);
          break;
     case FLDAD1:
          found=chkstr(tmpacc.usrad2);
          break;
     case FLDAD2:
          found=chkstr(tmpacc.usrad3);
          break;
     case FLDAD3:
          found=chkstr(tmpacc.usrad4);
          break;
     case FLDPHO:
          found=chkstr(tmpacc.usrpho);
          break;
     case FLDSYS:
          found=chkstr(sysstg[tmpacc.systyp]);
          break;
     case FLDAGE:
          found=chknum(tmpacc.age);
          break;
     case FLDSEX:
          found=(toupper(rsyfnd.srchstg[0]) == tmpacc.sex);
          break;
     case FLDCLS:
          found=chkstr(tmpacc.curcls);
          break;
     case FLDTCR:
          found=chkcdt(tmpacc.totcreds);
          break;
     case FLDTPD:
          found=chkcdt(tmpacc.totpaid);
          break;
     case FLDCRD:
          found=chkcdt(tmpacc.creds);
          break;
     case FLDCDT:
          found=chkdte(tmpacc.credat);
          break;
     case FLDUDT:
          found=chkdte(tmpacc.usedat);
          break;
     case FLDDAY:
          found=chknum(tmpacc.daystt);
          break;
     default:
          break;
     }
     if (found) {
          cpyvda(tmpacc.userid);
          vdelimiter();
          catvda(tmpacc.usrnam);
          setmem(&rfdpk,sizeof(struct saunam),0);
          stlcpy(rfdpk.sysid,msysid,SIDSIZ);
          stlcpy(rfdpk.appid,RSYAPN,AIDSIZ);
          stlcpy(rfdpk.usrid,usaptr->userid,UIDSIZ);
          stlcpy(rfdpk.suffix,SRCHNF,SFXSIZ);
     }
     if (qroom(usrnum,NORMAL)) {
          if (found) {
               senddpk(usrnum,RSYAPN,NORMAL,&rfdpk,STGLEN,vdatmp);
          }
          if (snxbtv(&tmpacc)) {
               rsyfnd.fpos=absbtv();
               rstbtv();
          }
          else {
               rstbtv();
               rsp2write(NULL,0,NULL);
               return;
          }
     }
}

static BOOL
chkstr(                       /* compare database string to search key     */
char *string)                 /*   string to compare to                    */
{
     return(findstg(rsyfnd.srchstg,string));
}

static BOOL
chkcdt(                       /* compare database credits to search key    */
long credits)                 /*   number of credits to compare with       */
{
     long a;

     a=atol(rsyfnd.srchstg);
     if ((rsyfnd.relate >= 1) && (rsyfnd.relate <= 5)) {
          return(glthrv[rsyfnd.relate-1]
                 [(credits >= a ? 1 : 0)+(credits > a ? 1 : 0)]);
     }
     return(FALSE);
}

static BOOL
chkdte(                       /* compare database date with search key     */
int date)                     /*   dos date format to comare with          */
{
     int a;

     a=dcdate(rsyfnd.srchstg);
     if ((rsyfnd.relate >= 1) && (rsyfnd.relate <= 5)) {
          return(glthrv[rsyfnd.relate-1]
                 [(date >= a ? 1 : 0)+(date > a ? 1 : 0)]);
     }
     return(FALSE);
}

static BOOL
chknum(                       /* compare database number with search key   */
int number)                   /*   number to compare with                  */
{
     int a;

     a=atoi(rsyfnd.srchstg);
     if ((rsyfnd.relate >= 1) && (rsyfnd.relate <= 5)) {
          return(glthrv[rsyfnd.relate-1]
                 [(number >= a ? 1 : 0)+(number > a ? 1 : 0)]);
     }
     return(FALSE);
}

static void
demstt(void)                  /* Get demographics statistics               */
{
     int ct,ab;
     static unsigned cttot;
     static unsigned agetot[NAGEBK];

     setmem(agetot,sizeof(agetot),0);
     for (ct=1 ; ct < NACMTY ; ct++) {
          for (ab=0,cttot=0 ; ab < NAGEBK ; ab++) {
               catrsp(spr("%u ",sv2.matrix[ct][ab]));
               cttot+=sv2.matrix[ct][ab];
               agetot[ab]+=sv2.matrix[ct][ab];
          }
          catrsp(spr("%u",cttot));
          delimiter();
     }
     for (ab=0,cttot=0 ; ab < NAGEBK ; ab++) {
          catrsp(spr("%u ",sv2.matrix[0][ab]));
          cttot+=sv2.matrix[0][ab];
          agetot[ab]+=sv2.matrix[0][ab];
     }
     catrsp(spr("%u",cttot));
     delimiter();
     for (ab=0 ; ab < NAGEBK ; ab++) {
          catrsp(spr("%u ",agetot[ab]));
     }
     catrsp(spr("%u ",sv2.numact));
     delimiter();
     catrsp(spr("%u ",sv2.numact-sv2.numfem));
     catrsp(spr("%u ",sv2.numfem));
     catrsp(spr("%u ",sv2.numcor));
     catrsp(spr("%u",sv2.numans));
}

static void
clsstt(void)                  /* Get class statistical information         */
{
     long val;

     if ((clsptr=clshead) == NULL) {
          return;
     }
     while (clsptr != NULL) {
          if (clsptr->flags&HASCRD && clsptr->flags&NOCRED) {
               clsptr=nxtcls(clsptr);
          }
          catrsp(clsptr->clname);
          delimiter();
          val=(clsptr->seconds+1800L)/3600L;
          catrsp(l2as(val));
          delimiter();
          val=(((clsptr->seconds+1800L)/3600L)*24+dtrack/2)/dtrack;
          catrsp(l2as(val));
          delimiter();
          catrsp(spr("%u",clsptr->users));
          delimiter();
          val=((clsptr->seconds)*24+dtrack/2)/dtrack;
          val=(val/(clsptr->users > 0 ? clsptr->users : 1)+30L)/60L;
          catrsp(l2as(val));
          clsptr=nxtcls(clsptr);
          if (clsptr != NULL) {
               catrsp(FLDSEP);
          }
     }
}

static
struct clstab *
nxtcls(                            /* get the next class in sequence       */
struct clstab *from)                    /* starting from here              */
{
     struct clstab *ptr=from;

     while (ptr != NULL) {
          ptr=ptr->next;
          if (ptr == NULL || !(ptr->flags&HASCRD && ptr->flags&NOCRED)) {
               break;
          }
     }
     return(ptr);
}

static void
mscstt(void)                       /* get miscellaneous and module stats   */
{
     int i;

     catrsp(l2as(sv2.totcalls));
     delimiter();
     catrsp(l2as(sv.uplds));
     delimiter();
     catrsp(l2as(sv.dwnlds));
     delimiter();
     catrsp(l2as(sv.msgtot));
     delimiter();
     catrsp(l2as(sv.emlopn));
     delimiter();
     catrsp(l2as(sv.sigopn));
     delimiter();
     catrsp(l2as(sv2.x25mbs));
     delimiter();
     catrsp(l2as(sv2.x25kps));
     delimiter();
     catrsp(l2as(sv2.freepst));
     delimiter();
     catrsp(l2as(sv2.paidpst));
     delimiter();
     for (i=0 ; i < nmods ; i++) {
          catrsp(mdstats[i].mdname);
          catrsp(FLDSEP);
          catrsp(l2as((mdstats[i].seconds+1800L)/3600L));
          catrsp(FLDSEP);
          catrsp(l2as(mdstats[i].creds));
          if (i < (nmods-1)) {
               delimiter();
          }
     }
}

static void
initgrph(void)                     /* initialize variables for graphs */
{
     if (sv2.lstzer == 0) {
          sv2.lstzer=today();
          mytrack=1;
     }
     else {
          mytrack=cofdat(today())-cofdat(sv2.lstzer);
          mytrack=(mytrack == 0 ? 1 : mytrack);
     }
     catrsp(months[ddmon(sv2.lstzer)]);
     delimiter();
}

static void
liugph(void)
{
     int i;
     long biggest;

     initgrph();
     for (i=0 ; i < 48 ; i++) {
          biggest=(long)((sv2.nliniu[i]+mytrack/2)/mytrack);
          catrsp(l2as(biggest));
          if (i < 47) {
               catrsp(FLDSEP);
          }
     }
}

static void
sebgph(void)                       /* get sessions/baudrate data      */
{
     int i;

     initgrph();
     for (i=0 ; i < 8 ; i++) {
          catrsp(l2as((long)sv.calls[i]));
          if (i < 7) {
               catrsp(FLDSEP);
          }
     }
}

static void
tuhgph(void)                       /* get time used statistics info   */
{
     int i,j;
     long totals[24];

     initgrph();
     setmem(totals,sizeof(long)*24,0);
     for (i=0 ; i < 24 ; i++) {
          for (j=0 ; j < NGROUPS-1 ; j++) {
               totals[i]+=sv3.secghr[j][i];
          }
          totals[i]=((totals[i]+30L)/60L+mytrack/2)/mytrack;
     }
     for (i=0 ; i < 24 ; i++) {
          catrsp(l2as(totals[i]));
          if (i < 23) {
               catrsp(FLDSEP);
          }
     }
}

static void
tuggph(void)
{
     int i,j;
     long totals[NGROUPS-1],temp;

     initgrph();
     setmem(totals,sizeof(long)*(NGROUPS-1),0);
     for (i=0 ; i < NGROUPS-1 ; i++) {
          for (j=0 ; j < 24 ; j++) {
               totals[i]+=sv3.secghr[i][j];
          }
          totals[i]=(temp=((totals[i]+1800L)/3600L+mytrack/2)/mytrack) > 9999L
               ? 9999L : temp;
     }
     for (i=0 ; i < NGROUPS-1 ; i++) {
          catrsp(l2as(totals[i]));
          if (i < (NGROUPS-2)) {
               catrsp(FLDSEP);
          }
     }
}

static void
cuhgph(void)                       /* draw graph of credits used      */
{
     int i,j;
     long totals[24];

     initgrph();
     setmem(totals,sizeof(long)*24,0);
     for (i=0 ; i < 24 ; i++) {
          for (j=0 ; j < NGROUPS-1 ; j++) {
               totals[i]+=sv3.crdghr[j][i];
          }
          totals[i]=((totals[i]+500L)/1000L+mytrack/2)/mytrack;
     }
     for (i=0 ; i < 24 ; i++) {
          catrsp(l2as(totals[i]));
          if (i < 23) {
               catrsp(FLDSEP);
          }
     }
}

static void
cuggph(void)                       /* draw graph of credits used/g#   */
{
     int i,j;
     long totals[NGROUPS-1],temp;

     initgrph();
     setmem(totals,sizeof(long)*(NGROUPS-1),0);
     for (i=0 ; i < NGROUPS-1 ; i++) {
          for (j=0 ; j < 24 ; j++) {
               totals[i]+=sv3.crdghr[i][j];
          }
          totals[i]=(temp=((totals[i]+500L)/1000L+mytrack/2)/mytrack) > 9999L
               ? 9999L : temp;
     }
     for (i=0 ; i < NGROUPS-1 ; i++) {
          catrsp(l2as(totals[i]));
          if (i < (NGROUPS-2)) {
               catrsp(FLDSEP);
          }
     }
}

static BOOL
lockmnu(                           /* download BBSMENU.DAT (start or end)  */
BOOL on)                                /* are we beginning or ending?     */
{
     extern BTVFILE *mnubb;

     if (on && mnudnl == usrnum) {      /* trying a download again...      */
          return(TRUE);
     }
     if ((on && mnudnl != -1) || (!on && mnudnl != usrnum)) {
          return(FALSE);
     }
     if (on) {
          clsbtv(mnubb);
          chmod("bbsmenu.dat",S_IREAD);
          omdbtv(RONLBV);
          mnubb=opnbtv("bbsmenu.dat",sizeof(struct mnupag));
          omdbtv(PRIMBV);
          mnudnl=usrnum;
     }
     else {
          clsbtv(mnubb);
          chmod("bbsmenu.dat",S_IREAD|S_IWRITE);
          mnubb=opnbtv("bbsmenu.dat",sizeof(struct mnupag));
          mnudnl=-1;
     }
     return(TRUE);
}
