/***************************************************************************
 *                                                                         *
 *   CNCUTL.C                                                              *
 *                                                                         *
 *   Copyright (c) 1988-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are the Worldgroup command concatenation utilities.             *
 *                                                                         *
 *                                 - T. Stryker & S. Brinker 7/5/88        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 1.2 $"

                                   /* constants for backward compatibility */
#define SIGIDC '/'                 /*   forum name identifier character    */
#define SIGSIZ 10                  /*   max size of SIG names (incl. '\0') */

char *nxtcmd;                 /* pointer to next char. for command concat. */

int maxcat,                   /* maximum number of concat'd commands       */
    numcat;                   /* number of commands concat'd so far        */

void
bgncnc(void)                  /* prepare input for command concatenation   */
{
     nxtcmd=margv[0];
     clrprf();
     rstrin();
}

int
endcnc(void)                  /* check for end of command concatenation    */
{
     if (margc == 0) {
          return(1);
     }
     movmem(nxtcmd,input,strlen(nxtcmd)+1);
     parsin();
     if (++numcat >= maxcat) {
          return(1);
     }
     return(margc == 0);
}

char
cncchr(void)                  /* gobble-character command concatenation    */
{
     char retval;

     if ((retval=toupper(*nxtcmd)) != '\0') {
          nxtcmd++;
     }
     return(retval);
}

int
cncint(void)                  /* atoi() look-alike for command concat.     */
{
     return((int)cnclon());
}

long
cnclon(void)                  /* atol() look-alike for command concat.     */
{
     long retval=0L;

     while (isdigit(*nxtcmd)) {
          retval=retval*10+*(nxtcmd++)-'0';
     }
     return(retval);
}

char *
cncuid(void)                  /* grab a userid; prepares for Btrieve too   */
{
     char *rp;
     static char retval[UIDSIZ];

     if (*nxtcmd == SIGIDC) {
          return(cncsig());
     }
     setmem(retval,UIDSIZ,0);
     for (rp=retval ; isuidc(*nxtcmd) && rp-retval < UIDSIZ-1 ; nxtcmd++,rp++) {
          *rp=*nxtcmd;
     }
     return(retval);
}

char *
cncsig(void)                  /* grab a sig name with or w/o leading slash */
{
     char *rp;
     static char retval[SIGSIZ];

     setmem(retval,SIGSIZ,0);
     if (*nxtcmd == SIGIDC) {
          nxtcmd++;
     }
     retval[0]=SIGIDC;
     rp=retval+1;
     while (*nxtcmd != '\0' && *nxtcmd != ' ' && rp-retval < SIGSIZ-1) {
          *rp++=*nxtcmd++;
     }
     return(retval);
}

char
cncyesno(void)                /* yes/no -- returns a char, chomps rest too */
{
     char retval;
     struct lingo *lptr;

     lptr=languages[clingo];
     if ((retval=cncchr()) == toupper(lptr->yes[0])) {
          if (strlen(lptr->yes) > 1 && sameto(&lptr->yes[1],nxtcmd)) {
               nxtcmd+=strlen(&lptr->yes[1]);
          }
          retval='Y';
     }
     else if (retval == toupper(lptr->no[0])) {
          if (strlen(lptr->no) > 1 && sameto(&lptr->no[1],nxtcmd)) {
               nxtcmd+=strlen(&lptr->no[1]);
          }
          retval='N';
     }
     return(retval);
}

char *
cncwrd(void)                  /* grab one space-delimited word             */
{
     char *rp;
     static char retval[UIDSIZ];

     rp=retval;
     setmem(retval,UIDSIZ,0);
     while (*nxtcmd != '\0' && *nxtcmd != ' ' && rp-retval < UIDSIZ-1) {
          *rp++=*nxtcmd++;
     }
     return(retval);
}

char *
cncbgw(                       /* grab a big space-delimited word           */
char *buffer,                 /* buffer where to put it (returned val too) */
int sizbuf)                   /* size for buffer, including NUL terminator */
{
     char *rp;

     setmem(rp=buffer,sizbuf,0);
     while (*nxtcmd != '\0' && *nxtcmd != ' ' && rp-buffer < sizbuf-1) {
          *rp++=*nxtcmd++;
     }
     return(buffer);
}

char *
cncall(void)                  /* grab rest of input; ends concatenation    */
{
     char *retval;

     retval=nxtcmd;
     nxtcmd="";
     return(retval);
}

char
morcnc(void)                  /* check for more commands to be concat'd    */
{                             /*  (rets 0 if not or the next char if so)   */
     if (numcat >= maxcat) {
          return(0);
     }
     while (isspace(*nxtcmd)) {
          nxtcmd++;
     }
     return(toupper(*nxtcmd));
}

int
cnchex(void)                  /* take a hex number and return decimal amt  */
{
     int i,retval=0,flag=0;
     static char hex[6]={
          'A','B','C','D','E','F'
     };

     while (1) {
          if (isdigit(*nxtcmd)) {
               retval=(retval<<4)+(*nxtcmd-'0');
          }
          else {
               for (i=0 ; i < 6 ; i++) {
                    if (toupper(*nxtcmd) == hex[i]) {
                         retval=(retval<<4)+10+i;
                         break;
                    }
               }
               if (i == 6) {
                    return(flag && (*nxtcmd == ' ' || *nxtcmd == '\0') ? retval
                                                                       : -1);
               }
          }
          nxtcmd++;
          flag=1;
     }
}

char *
cncnum(void)                  /* return an ASCII-coded decimal             */
{
     int i=0;
     static char retval[12];

     if (*nxtcmd == '-') {
          retval[i++]=*(nxtcmd++);
     }
     while (isdigit(*nxtcmd) && i < 11) {
          retval[i++]=*(nxtcmd++);
     }
     retval[i]='\0';
     return(retval);
}

int
cnclng(void)                  /* return a language index (or -1=invalid)   */
{
     int ilingo;
     char *cp;

     if (alldgs(cp=cncwrd()) && (ilingo=atoi(cp)-1) >= 0 && ilingo < nlingo) {
          return(ilingo);
     }
     return(lngfnd(cp));
}
