/***************************************************************************
 *                                                                         *
 *   BBSRPT.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1996 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Worldgroup Offline Report Utility.                                    *
 *                                                                         *
 *                                                     E. Bush  2/7/92     *
 *                                                     R. Skurnick         *
 ***************************************************************************/

#include "gcomm.h"
#include "plstuff.h"
#include "bbsrpt.h"
#include "majorbbs.h"
#include "gme.h"
#include "gmeutl.h"
#include "gmeloc.h"
#include "gmeoff.h"

#define FILREV "$Revision: 1.2 $"

static void prtsp();

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Variable Definitions                                          :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

int state;                    /* current state of program                  */
int substate=1;               /* current substate of program               */
int datval=0;                 /* return code of getdate routine            */
int redir=0;                  /* is output specified to goto other out     */
int pagbrk=0;                 /* page break location   0=nobreak           */
int line=-1;                  /* line counter for output                   */

char curpos;                  /* current postion in menu                   */

int auddone=0,                /* end of program variable                   */
    printer=0,                /* Printing it out?                          */
    found,                    /* Did the scan find one yet?                */
    done,                     /* Should we stop now?                       */
    stop,                     /* Should we stop now?                       */
    form,                     /* Count on form feed                        */
    state,                    /* State switch variable                     */
    credit,                   /* Count credits?                            */
    fward,                    /* Forward or backward search                */
    wchmnu,                   /* Return to which menu 0=main 1=user        */
    casesn,                   /* Is this a case sensative search?          */
    cntlin;                   /* count the number of lines used on screen  */

char date1[9],                /* date fields for use                       */
     date2[9],                /* date fields for use                       */
     retdat[9];               /* date fields for return code               */

char repchr[2],               /* response character with '\0'              */
       yorn[4],               /* yes or no repsonce with '\0'              */
     forwrd[10];              /* foward or backwards holding location      */

char unam[120],               /* user id field holding structure           */
     uad1[120],               /* user id field holding structure           */
     uad2[120],               /* user id field holding structure           */
     uad3[120];               /* user id field holding structure           */

char inpnam[15],              /* input file name storage location          */
     outnam[15];              /* name of where to put output               */

char c;                       /* Random Character Holder                   */

char datone[DATESIZ],         /* Date holder for 01/01/80 form             */
     datnone[DATESIZ],        /* Date holder for 010180 form               */
     dattwo[DATESIZ],         /* date holder for 01/01/80 form             */
     datntwo[DATESIZ],        /* date holder for 010180 form               */
     name[NAMESIZ],           /* Output file name                          */
     search[SCHSTG],          /* Random String Search Character array      */
     srcstg[STGSIZ],          /* Search String                             */
     uid[UIDSIZ],             /* current User-ID we're working with        */
     search1[STGSIZ],         /* String to search for #1                   */
     search2[STGSIZ],         /* String to search for #2                   */
     search3[STGSIZ],         /* Comment String                            */
     audrec[AUDSIZ];          /* Auditrail input line                      */

char *keytmp;                 /* buffer for loading in the key data   */

void *scrsav1,                /* screen save locations                     */
     *scrsav2,                /* screen save locations                     */
     *scrsav3;                /* screen save locations                     */


FILE *outf=stdout;            /* file pointer for output                   */

char chkkey[KEYSIZ+1];        /* hold key name for Sysop access to Forums  */
BOOL gmeup=FALSE;             /* has the GME been initialized?             */
struct qscfg *qsptr;          /* user quickscan record pointer             */

BTVFILE *bfp,                 /* btrieve file pointer                      */
        *bfp2,                /* btrieve file pointer                      */
        *accbb,               /* user account btrieve file ptr             */
        *keybb;               /* user keys btrieve file ptr                */


long credits,                 /* Credits scanned on auditrail              */
     finish;                  /* End of search within BTRIEVE file (post)  */

STATIC                        /* report header for sig access levels       */
char *rpthdr={
"\
Legend of Forums and Default Levels\n\
-----------------------------------\n\n\
  No.        Name        Non Priv    Priv    Max Non Priv  Privileged Key\n\
 -----  ---------------  --------  --------  ------------  --------------\n"
};

STATIC                        /* report header for remote access report    */
char *remhdr={
"\
Legend of Remote Options and Flags\n\
----------------------------------\n\n\
HASMST - Has Master Key to System\n\
SUSPEN - Account has been suspended\n\
UNDAXS - Account can not be deleted\n\n\
 Option        Description of Access\n\
--------  -------------------------------\n"
};

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Structure Definitions                                         :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

struct usracc acct;           /* user account structure                    */

struct acclass class;         /* class structure                           */

struct usracc *usaptr;        /* ptr to current user's usracc entry        */

STATIC
char *lvls[]={"Zero","","Read","","D/L","","Write","","U/L","",
              "Coop","","Forum-Op","","Sysop","Default"
};

STATIC
struct valop {
     char *opname;
     int op;
} valops[]={
     {"SENDALL", 11},
     {"SEND",    12},
     {"LOGON",   13},
     {"DETAIL",  22},
     {"AUDIT",   23},
     {"USERS",   24},
     {"SEARCH",  25},
     {"HANGUP",  31},
     {"SUSPEND", 32},
     {"PROTECT", 33},
     {"DELETE",  34},
     {"SHUTDOWN",35},
     {"CLEANUP", 36},
     {"SYSTATS", 41},
     {"MODSTATS",42},
     {"DEMSTATS",43},
     {"CLSSTATS",44},
     {"EMULATE", 51},
     {"MONITOR", 52},
     {"INPUT",   53},
     {"CHANGE",  54},
     {"TYPE",    61},
     {"COPY",    62},
     {"RENAME",  63},
     {"DIR",     64},
     {"MD",      65},
     {"RD",      66},
     {"DEL",     67},
     {"ACCOUNT", 71},
     {"TRANSFER",73}
};

struct option {                    /* Data on each menu option             */
     char stroke;                  /* keystroke to invoke                  */
     int x,y;                      /* position on screen of menu option    */
     char u,d,l,r;                 /* connects for arrow keys              */
     char *title;                  /* name of option                       */
} options[] = {
     {'0',30,17,'4','0','4','8',"Return to Introductory Menu"},
     {'1', 8, 5,'1','2','1','5',"Audit Trail Search Utility"},
     {'2', 8, 8,'1','3','2','6',"Type User Account Labels"},
     {'3', 8,11,'2','4','3','7',"Type User Account Database"},
     {'4', 8,14,'3','0','4','8',"Forum Quickscan Report"},
     {'5',46, 5,'5','6','1','5',"Forum Access Report"},
     {'6',46, 8,'5','7','2','6',"User Key Report"},
     {'7',46,11,'6','8','3','7',"Remote Access Report"},
     {'8',46,14,'7','0','4','8',"User Classes Report"},
};

int helpx=5,helpy=21;              /* location of help box in main screen  */
int done=0;                        /* have we finished with the program?   */

char *help[9][2]={                /* help messages for each option        */
     {{"                    Return to Introductory Menu."},
      {""}},
     {{"  Search Audit Trail for specific information and report findings to"},
      {"                       printer, screen, or file."}},
     {{"        Dump the user account database into 6-line ASCII labels."},
      {""}},
     {{"                Dump the entire user account database."},
      {""}},
     {{"            Report on user quickscan lists, indexed by Forum."},
      {""}},
     {{"              Report on non-default access levels to Forums,"},
      {"                           indexed by User-ID."}},
     {{"               Report detailing \"keys\" held by each User-ID."},
      {""}},
     {{"    Report all User-IDs having any access to the Remote System Menu"},
      {"             and the options that each such user can access."}},
     {{"               Dump a list of all classes within the system."},
      {""}},
};

struct option *cursor=options+1;  /* options cursor                        */

BTVFILE *genbb;               /* generic user data file btrieve file ptr   */

extern char scntbl[][SCNSIZ];

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Mainline code                                                 :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
main(void)                         /* start of main line code              */
{
     int i;

     protinit("BBSRPT ");
     if (setjmp(disaster)) {
          exit(1);
     }
     scrsav1=alcmem(SCNSIZ);
     scrsav2=alcmem(SCNSIZ);
     scrsav3=alcmem(SCNSIZ);
     keytmp=alcmem(RINGSZ);
     monorcol();
     for (i=0 ; i < NUMSCN ; i++ ) {
          cvtscn(scntbl[i]);
     }
     state=MNMENU;
     curpos='1';
     while (state != ENDPRG) {
          movmem(scntbl[6],frzseg(),SCNSIZ);
          newpos(curpos,(curpos-'0'));
          switch(state) {
          case MNMENU:
               mnmenu();
               break;
          case ACCLBL:
               acclbl();
               break;
          case ACCUSR:
               accusr();
               break;
          case FORACS:
               foracs();
               break;
          case LOKNKY:
               loknky();
               break;
          case REMACS:
               remacs();
               break;
          case USRCLS:
               usrcls();
               break;
          case FORQSC:
               forqsc();
               break;
          case AUDSCN:
               audscn();
               break;
          }
     }
     endprg();
}

STATIC
void
mnmenu(void)                       /* main menu keyhit handling routine    */
{
     int c;          /* 01234567890123--6789*//* where you're starting from  */
     static char fwd[]="12345678001234567800";/* where to go after PgDn, etc. */
     static char rev[]="80123456788012345678";/* where to go after PgUp, etc. */

     locate(0,25);
     cursact(0);
     c=getchc();
     if (c == '\r') {
          c=cursor->stroke;
     }
     switch (c) {
     case '1':
     case F1:
          newpos('1',1);
          state=AUDSCN;
          substate=AUDPRTMNU;
          break;
     case F2:
     case '2':
          newpos('2',1);
          state=ACCLBL;
          break;
     case '3':
     case F3:
          newpos('3',1);
          state=ACCUSR;
          break;
     case '4':
     case F4:
          newpos('4',1);
          state=FORQSC;
          break;
     case '5':
     case F5:
          newpos('5',1);
          state=FORACS;
          break;
     case '6':
     case F6:
          newpos('6',1);
          state=LOKNKY;
          break;
     case '7':
     case F7:
          newpos('7',1);
          state=REMACS;
          break;
     case '8':
     case F8:
          newpos('8',1);
          state=USRCLS;
          break;
     case ESC:
     case '0':
     case F10:
          newpos('0',1);
          state=ENDPRG;
          break;
     case CRSRUP:
          newpos(cursor->u,1);
          break;
     case CRSRDN:
          newpos(cursor->d,1);
          break;
     case CRSRLF:
          newpos(cursor->l,1);
          break;
     case CRSRRT:
          newpos(cursor->r,1);
          break;
     case ' ':
     case '\t':
     case PGDN:
     case END:
          newpos(fwd[cursor->stroke-'0'],1);
          break;
     case '\b':
     case BAKTAB:
     case PGUP:
     case HOME:
          newpos(rev[cursor->stroke-'0'],1);
          break;
     }
}

STATIC
void
endprg(void)                       /* end the program                      */
{
     closgme();
     cursact(1);
     locate(0,24);
     exit(0);
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Dump User Account Label Routines                              :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

STATIC
void
acclbl(void)                       /* account label dump main line         */
{
     int chkdon=0;
     int ziponl=0;
     int strdat=0;
     int cremon,creday,creyar;
     int startm=1,startd=1,starty=80;

     locate(0,25);
     cursact(0);
     if (cancel()) {
          return;
     }
     cursact(1);
     explodeto(scntbl[1],0,4,39,7,12,5);
     strcpy(yorn,"No");
     do {
          if (!edtval(25,7,sizeof(yorn),yorn,validyn,0)) {
               state=MNMENU;
               return;
          }
     } while (yorn[0] == '\0');
     strcpy(date1,"01/01/80");
     if (yorn[0] == 'Y') {
          strdat=1;
          explodeto(scntbl[1],0,8,39,11,17,8);
          locate(34,10);
          setatr(0x0f);
          printf("  /  /  ");
          locate(34,10);
          while(!chkdon) {
               switch(getdat()) {
               case -2:
                    state=MNMENU;
                    chkdon=1;
                    return;
               case -1:
                    scn2mem(frzseg(),scrsav2,SCNSIZ);
                    locate(0,25);
                    explodeto(scntbl[0],0,17,37,22,19,7);
                    getchc();
                    movmem(scrsav2,frzseg(),SCNSIZ);
                    locate(34,10);
                    setatr(0x0f);
                    printf("  /  /  ");
                    locate(34,10);
                    break;
               case 0:
                    locate(34,10);
                    setatr(0x2f);
                    printf("01/01/80");
                    strcpy(date1,"01/01/80");
                    chkdon=1;
                    break;
               case 1:
                    locate (34,10);
                    setatr(0x2f);
                    printf("%s",retdat);
                    strcpy(date1,retdat);
                    chkdon=1;
                    break;
               }
          }
     }
     strcpy(repchr,"1");
     if (strdat) {
          explodeto(scntbl[1],0,0,39,3,22,11);
     }
     else {
          explodeto(scntbl[1],0,0,39,3,17,8);
     }
     strcpy(yorn,"No");
     do {
          if (strdat) {
               if (!edtval(35,13,sizeof(yorn),yorn,validyn,0)) {
                    state=MNMENU;
                    return;
               }
          }
          else {
               if (!edtval(30,10,sizeof(yorn),yorn,validyn,0)) {
                    state=MNMENU;
                    return;
               }
          }
     } while (yorn[0] == '\0');
     if (yorn[0] == 'Y') {
          ziponl=1;
     }
     else {
          ziponl=0;
     }
     explode(scntbl[4],0,0,79,24);
     setatr(0x1f);
     prtcen(1,"Type User Account Labels");
     bfp=opnbtv("bbsusr.dat",sizeof(struct usracc));
     setbtv(bfp);
     if (!qlobtv(0)) {
          catastro("User account file is empty!");
     }
     setatr(0x1f);
     setwin(0L,2,3,76,22,1);
     cursact(0);
     locate(2,3);
     if (redir) {
          printf("Now outputting report to \"%s\"\n",inpnam);
     }
     do {
          gcrbtv(&acct,0);
          cremon=creday=creyar=0;
          sscanf(ncdate(acct.credat),"%d/%d/%d",&cremon,&creday,&creyar);
          sscanf(date1,"%d/%d/%d",&startm,&startd,&starty);
          if (creyar > starty ||
             (creyar == starty && (cremon > startm ||
                                  (cremon == startm && creday >= startd)))) {
               refmt(acct.usrnam,unam);
               refmt(acct.usrad1,uad1);
               refmt(acct.usrad2,uad2);
               refmt(acct.usrad3,uad3);
               if (cisazp(uad3) || !ziponl) {
                    if (pagbrk > 0 && (line+=6) >= pagbrk) {
                         if (finup() == ESC) {
                              break;
                         }
                         line=0;
                    }
                    if (alblank(uad1)) {
                         prtsp("%-40s%s\n%s\n%s\n\n\n\n",unam,
                              acct.userid,
                              uad2,uad3);
                    }
                    else {
                         prtsp("%-40s%s\n%s\n%s\n%s\n\n\n",unam,
                              acct.userid,
                              uad1,
                              uad2,uad3);
                    }
               }
          }
     } while (qnxbtv());
     clsbtv(bfp);
     fclose(outf);
     endrpt();
}

STATIC
int
myvalid(c,stg)                     /* validate 1, 2, or 3 for edtval() call*/
int c;                                  /* integer value of character      */
char *stg;                              /* string being filled in          */
{
     switch(c) {
     case '1':
          strcpy(stg,"1");
          break;
     case '2':
          strcpy(stg,"2");
          break;
     case '3':
          strcpy(stg,"3");
          break;
     default:
          return(1);
     }
     return(0);
}

STATIC
int
cisazp(stg)                        /* check for a valid zip code sequence  */
char *stg;                              /* string to be checked            */
{
     if (pcmtch(stg,"\5\5\5\2\2\2\2\2")) {
          if (pcmtch(stg,"\5\5\5, \2\2\2\2\2")) {
               movmem(stg+strlen(stg)-6,stg+strlen(stg)-7,7);
          }
          if (pcmtch(stg,"\5\5\5 \1\1 \2\2\2\2\2")) {
               *(stg+strlen(stg)-7)=toupper(*(stg+strlen(stg)-7));
          }
          return(1);
     }
     if (pcmtch(stg,"\5\5\5\2\2\2\2\2-\2\2\2\2")) {
          if (pcmtch(stg,"\5\5\5, \2\2\2\2\2-\2\2\2\2")) {
               movmem(stg+strlen(stg)-11,stg+strlen(stg)-12,12);
          }
          if (pcmtch(stg,"\5\5\5 \1\1 \2\2\2\2\2-\2\2\2\2")) {
               *(stg+strlen(stg)-12)=toupper(*(stg+strlen(stg)-12));
          }
          return(1);
     }
     return(0);
}

STATIC
int
pcmtch(input,picstg)
char *input,*picstg;
{
     char c,pc;
     char *lanypc=NULL,*lanyin;

     while ((c=*input++) != '\0') {
          if ((pc=*picstg++) == '\5') {
               while ((pc=*(picstg+=2)) == '\5') {
                    picstg++;
               }
               while (!cmtch(c,pc)) {
                    if (c == '\0') {
                         return(0);
                    }
                    c=*input++;
               }
               lanypc=picstg-3;
               lanyin=input;
               input--;
          }
          else {
               if (!cmtch(c,pc)) {
                    if (lanypc != NULL) {
                         picstg=lanypc;
                         input=lanyin;
                    }
                    else {
                         return(0);
                    }
               }
          }
     }
     while (*picstg == '\5') {
          picstg+=3;
     }
     return(*picstg == '\0');
}

int
cmtch(c,pc)
char c,pc;
{
     switch (pc) {
     case '\1':                       /* alpha */
          return(isalpha(c));
     case '\2':                       /* numeric */
          return(isdigit(c));
     case '\3':                       /* plus-or-minus */
          return(c == '+' || c == '-' || c == ' ');
     case '\4':                       /* any-char */
          return(1);
     default:
          return(c == pc);
     }
}

int
efflen(stg)
char *stg;
{
     int i,len;

     for (i=len=0 ; *stg != '\0' ; ) {
          i++;
          if (*stg++ != ' ') {
               len=i;
          }
     }
     return(len);
}

void
refmt(stg,rts)                     /* remformat with proper uppers for add */
char *stg,*rts;
{
     int alpha1,c;
     char *inistg;

     inistg=stg;
     *(stg+efflen(stg))='\0';
     alpha1=1;
     for ( ; *stg != '\0' ; stg++) {
          if (isalpha(*stg) || isdigit(*stg) || *stg == '\'') {
               if (alpha1) {
                    *rts++=toupper(*stg);
                    alpha1=0;
               }
               else if (*(stg-2) == ' '
                 && ((c=toupper(*(stg-1))) == 'N' || c == 'S')
                 && ((c=toupper(*stg)) == 'E' || c == 'W')
                 && (*(stg+1) == ' ' || *(stg+1) == '\0')) {
                    *rts++=toupper(*stg);
               }
               else if (stg == inistg+1
                 && ((c=toupper(*(stg-1))) == 'P')
                 && ((c=toupper(*stg)) == 'O')
                 && ((c=toupper(*(stg+1))) == ' ' || c == 'B')) {
                    *rts++=toupper(*stg);
               }
               else {
                    *rts++=tolower(*stg);
               }
          }
          else {
               alpha1=1;
               if ((*stg == '.' || *stg == ',') && *(stg+1) != ' '
                 && *(stg+1) != ',') {
                    *rts++=*stg;
                    *rts++=' ';
               }
               else if (*stg == ' ' && (*(stg+1) == ' ' || *(stg+1) == ',')) {
                    /* do nothing */
               }
               else {
                    *rts++=*stg;
               }
          }
     }
     *rts='\0';
}

int
alblank(stg)                       /* return 1 if all spaces in string     */
char *stg;
{
     while (*stg != '\0') {
          if (*stg != ' ') {
               return(0);
          }
          stg++;
     }
     return(1);
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Dump User Account Database Routines                           :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
accusr(void)                       /* User account dump main line code     */
{
     long numact,numpai,numale,numfem,useavl;

     locate(0,25);
     cursact(0);
     if (cancel()) {
          return;
     }
     explode(scntbl[4],0,0,79,24);
     setatr(0x1f);
     prtcen(1,"Type User Account Database");
     scn2mem(frzseg(),scrsav1,SCNSIZ);
     numact=numpai=numale=numfem=useavl=0L;
     bfp=opnbtv("bbsusr.dat",sizeof(struct usracc));
     genbb=opnbtv("bbsgen.dat",GENSIZ);
     setbtv(bfp);
     if (!qlobtv(0)) {
          catastro("User account file is empty!");
     }
     locate(2,3);
     setatr(0x1f);
     setwin(0L,2,3,76,22,1);
     if (redir) {
          printf("Now outputting report to \"%s\"\n",inpnam);
     }
     cursact(0);
     do {
          gcrbtv(&acct,0);
          getgen(&genbuf,acct.userid);
          if (!redir) {
               printf("\014");
          }
          prtsp("UserID   : %-30s     Password: %-10s\n",
                 acct.userid,acct.psword);
          prtsp("Real Name: %-30s     System Type: %d%s\n",acct.usrnam,acct.systyp,
                 ((acct.ansifl&ANSON) ? "(A)" : "   "));
          prtsp("Address 1: %-30s     Born: %-8s  Sex: %s\n",acct.usrad1,
                 acct.birthd,(acct.sex == 'M' ? "Male" : "Female"));
          prtsp("Address 2: %-30s     CRT: %2dx%2d\n",acct.usrad2,
                 acct.scnwid,acct.scnbrk);
          prtsp("Address 3: %-30s     Date Created: %s\n",acct.usrad3,
                 ncdate(acct.credat));
          prtsp("Address 4: %-30s     Date Last Used: %s\n",acct.usrad4,
                 ncdate(acct.usedat));
          prtsp("Phone Number: %-30s  Default Editor: %s\n",acct.usrpho,
                (acct.usrprf&PRFLIN) ? "LINE" : "FSE");
          prtsp("Language: %s\n",genbuf.lngnam[0] != '\0' ? genbuf.lngnam
                                                          : "<none selected>");
          prtsp("\n");
          prtsp("Current Class (Keyring): %-16s      Days in Class: %d\n\n",
             acct.curcls,acct.daystt);
          prtsp("Credits Available: %8ld  Total ever: %8ld  Total Paid: %8ld\n\n",
             acct.creds,acct.totcreds,acct.totpaid);
          numact++;
          if (acct.totpaid != 0L) {
               numpai++;;
          }
          if (acct.sex == 'M') {
               numale++;
          }
          else {
               numfem++;
          }
          useavl+=acct.creds;
          if (pagbrk > 0) {
               if (finup() == ESC) {
                    break;
               }
               line=0;
          }
     } while (qnxbtv());
     if (pagbrk > 0) {
          printf("\014\n");
     }
     clsbtv(genbb);
     clsbtv(bfp);
     prtsp("\nTotal Accounts:  %ld\n",numact);
     prtsp("Paying Accounts: %ld\n",numpai);
     prtsp("Male Accounts:   %ld\n",numale);
     prtsp("Female Accounts: %ld\n",numfem);
     prtsp("Total Number of Credits: %ld\n",useavl);
     fclose(outf);
     endrpt();
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Forum Access Report Routines                                  :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
foracs(void)                       /* forum access report main line code   */
{
     locate(0,25);
     cursact(0);
     if (cancel()) {
          return;
     }
     explode(scntbl[4],0,0,79,24);
     setatr(0x1f);
     prtcen(1,"Forum Access Report");
     scn2mem(frzseg(),scrsav1,SCNSIZ);
     initgme();
     strcpy(chkkey,msgscan("galme.msg","FORSYS"));
     accbb=opnbtv("bbsusr.dat",sizeof(struct usracc));
     keybb=opnbtv("bbsk.dat",RINGSZ);
     locate(2,3);
     setatr(0x1f);
     if (redir) {
          printf("Now outputting report to \"%s\"\n",inpnam);
     }
     setwin(0L,2,3,76,22,1);
     prtqsc();
     prtsp("\n");
     prtleg();
     shtdwn();
     endrpt();
}

void
prtqsc(void)                       /* Cycle through each user's bqscfg rec */
{
     cntlin=0;
     setbtv(qscbb);
     if (qlobtv(0)) {
          do {
               gcrbtv(qsptr,0);
               if (!procqsc()) {
                    break;
               }
               setbtv(qscbb);
          } while (qnxbtv());
     }
}

int
procqsc(void)                      /* Report on a users non-default access */
{
     int i,prtuid,numprt,retlvl,anynon;
     struct fordef *fdef;

     setbtv(accbb);
     if (!acqbtv(&acct,qsptr->userid,0)) {
          setbtv(qscbb);
          geqbtv(qsptr,qsptr->userid,0);
          delbtv();
          return(1);
     }
     rstbtv();
     anynon=0;
     prtuid=1;
     numprt=4;
     for (i=0 ; i < numforums() ; i++) {
          fdef=seqdef(i);
          if ((retlvl=rdautl(fdef->forum)) != NOTSET) {
               if (prtuid) {
                    prtdln();
                    prtsp("USER-ID: %s",qsptr->userid);
                    cntlin+=2;
                    prtuid=0;
                    anynon=1;
               }
               if (numprt == 4) {
                    prtsp("\n     ");
                    cntlin++;
                    numprt=0;
               }
               if (!redir && cntlin >= 19) {
                    if (finup() == ESC) {
                         return(0);
                    }
                    cntlin=0;
               }
               prtsp("%6u-",fdef->forum);
               prtsp("%-10s",lvls[retlvl]);
               numprt++;
          }
     }
     if (anynon) {
          prtsp("\n");
     }
     return(1);
}

void
prtleg(void)                       /* Print legend of current sig defaults */
{
     int i;
     struct fordef *fdef;

     prtsp("%s",rpthdr);
     for (i=0 ; i < numforums() ; i++) {
          fdef=seqdef(i);
          prtsp(" %05u  %-15s  ",fdef->forum,fdef->name);
          prtsp("%-10s",lvls[fdef->dfnpv]);
          prtsp("%-10s",lvls[fdef->dfprv]);
          prtsp("%-14s",lvls[fdef->mxnpv]);
          prtsp("%s\n",fdef->forlok);
     }
}

void
prtdln(void)                       /* Print dash line                      */
{
     int i;

     for (i=0 ; i < 74 ; i++) {
          prtsp("-");
     }
     prtsp("\n");
}

int
rdautl(forum)                      /* Read access level, curr guy          */
unsigned forum;
{
     int i,level;
     char chkcls[KEYSIZ];
     struct fmidky *fmarr;

     if (sameas(acct.userid,"Sysop")) {
          return(SYAXES);
     }
     chkcls[0]=RINGID;
     chkcls[1]='\0';
     strcat(chkcls,acct.curcls);
     setbtv(keybb);
     if (acqbtv(keytmp,chkcls,0) && fndakey(chkkey,&keytmp[KLSTOF])) {
          rstbtv();
          return(SYAXES);
     }
     if (acqbtv(keytmp,acct.userid,0) && fndakey(chkkey,&keytmp[KLSTOF])) {
          rstbtv();
          return(SYAXES);
     }
     rstbtv();
     fmarr=(struct fmidky *)qsptr->accmsg;
     level=NOTSET;
     for (i=0 ; i < qsptr->nforums ; i++) {
          if (fmarr[i].forum == forum) {
               level=acclvl(qsptr->accmsg+qsptr->nforums*sizeof(struct fmidky),
                            i);
               break;
          }
     }
     return(level);
}

int
fndakey(lock,keylist)              /* find a key in list                   */
char *lock,*keylist;
{
     char *keyptr,*ptr;

     keyptr=ptr=keylist;
     while (*ptr != '\0') {
          if (*ptr == ' ') {
               *ptr='\0';
               if (sameas(lock,keyptr)) {
                    return(1);
               }
               *ptr=' ';
               keyptr=ptr+1;
          }
          ptr++;
     }
     return(0);
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Key Report Routines                                           :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
loknky(void)                       /* Key report main line code            */
{
     locate(0,25);
     cursact(0);
     if (cancel()) {
          return;
     }
     explode(scntbl[4],0,0,79,24);
     setatr(0x1f);
     prtcen(1,"User Key Report");
     scn2mem(frzseg(),scrsav1,SCNSIZ);
     setwin(0L,2,3,76,22,1);
     bfp=opnbtv("bbsusr.dat",sizeof(struct usracc));
     bfp2=opnbtv("bbsk.dat",RINGSZ);
     if (usaptr == NULL) {
          usaptr=(struct usracc *)alcmem(sizeof(struct usracc));
     }
     setbtv(bfp);
     if (!qlobtv(0)) {
          catastro("User account file is empty!");
     }
     setatr(0x1f);
     setwin(0L,2,3,76,22,1);
     cursact(0);
     locate(2,3);
     if (redir) {
          printf("Now outputting report to \"%s\"\n",inpnam);
     }
     cntlin=0;
     do {
          gcrbtv(&acct,0);
          prtsp("USER-ID: %-30s  Current Class (Keyring): %s\n",acct.userid,
                 acct.prmcls);
          prtsp("This user has the following special keys:\n");
          cntlin+=2;
          dspkey(acct.userid,0);
          if (!redir && cntlin >= 16) {
               cntlin=0;
               if (finup() == ESC) {
                    break;
               }
          }
     } while (qnxbtv());
     clsbtv(bfp);
     clsbtv(bfp2);
     endrpt();
}

STATIC
void
dspkey(                            /* display a rough list of keys in list */
char *keyr,                             /* keyring name to display (or UID)*/
int ring)                               /* is it a keyring? (0 or 1)       */
{
     int i=0;
     char *bas,*ptr,keyring[UIDSIZ];

     if (ring) {
          keyring[0]=RINGID;
          strcpy(keyring+1,keyr);
     }
     else {
          strcpy(keyring,keyr);
     }
     if (!getkey(keyring)) {
          prtsp("No special keys for this user\n\n");
          cntlin+=2;
          return;
     }
     ptr=&keytmp[KLSTOF];
     if (*ptr == '\0') {
          prtsp("No special keys for this user\n\n");
          cntlin+=2;
          return;
     }
     while (1) {
          bas=ptr;
          while (*ptr != ' ') {
               if (*ptr++ == '\0') {
                    prtsp("%-16.16s\n",bas);
                    prtsp("\n");
                    cntlin++;
                    return;
               }
          }
          *ptr='\0';
          prtsp("%-16.16s ",bas);
          *ptr++=' ';
          if (++i > 3) {      /* (4 on each line) */
               prtsp("\n");
               cntlin++;
               i=0;
          }
     }
}

STATIC
int
getkey(                            /* get a list of keys from BTRIEVE      */
char *uid)                              /* user-id or keyring name to get  */
{
     int acq;

     setbtv(bfp2);
     acq=acqbtv(keytmp,uid,0);
     rstbtv();
     return(acq);
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Remote Sysop Access Routines                                  :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
remacs(void)                       /* Remote sysop access report main line */
{
     locate(0,25);
     cursact(0);
     if (cancel()) {
          return;
     }
     explode(scntbl[4],0,0,79,24);
     setatr(0x1f);
     prtcen(1,"Remote Sysop Access Report");
     scn2mem(frzseg(),scrsav1,SCNSIZ);
     setwin(0L,2,3,76,22,1);
     bfp=opnbtv("bbsusr.dat",sizeof(struct usracc));
     if (usaptr == NULL) {
          usaptr=(struct usracc *)alcmem(sizeof(struct usracc));
     }
     locate(2,3);
     setatr(0x1f);
     prtrsy();
     prtlst();
     clsbtv(bfp);
     endrpt();
}

void
prtrsy(void)                       /* Cycle through each users usracc recor*/
{
     setbtv(bfp);
     if (qlobtv(0)) {
          do {
               gcrbtv(usaptr,0);
               procrsy();
          } while (qnxbtv());
     }
}

void
procrsy(void)                      /* Report on a users if has flags or acc*/
{
     int i,cnt=0;

     if (anyaxs() || (usaptr->flags&(HASMST|UNDAXS|SUSPEN))) {
          prtsp("USER-ID: %-30.30s     ",usaptr->userid);
          if ((usaptr->flags&HASMST) || sameas(usaptr->userid,"Sysop")) {
               prtsp("HASMST ");
          }
          if (usaptr->flags&SUSPEN) {
               prtsp("SUSPEN ");
          }
          if ((usaptr->flags&UNDAXS) || sameas(usaptr->userid,"Sysop")) {
               prtsp("UNDAXS ");
          }
          prtsp("\n");
          for (i=0 ; i < (sizeof(valops)/sizeof(struct valop)) ; i++) {
               if (axs4op(valops[i].op)) {
                    if (cnt == 6) {
                         cnt=0;
                         prtsp("\n");
                    }
                    if (cnt == 0) {
                         prtsp("     ");
                    }
                    prtsp("%-10s",valops[i].opname);
                    cnt++;
               }
          }
          prtsp("\n\n");
     }
}

void
prtlst(void)                       /* Print legend of current sig defaults */
{
     if (pagbrk) {
          if (finup() == ESC) {
               return;
          }
     }
     if (redir) {
          fprintf(outf,"%s",remhdr);
     }
     printf("%s",remhdr);
     prtsp("SENDALL   Send Message to All\n");
     prtsp("SEND      Send Message to User-ID\n");
     prtsp("LOGON     Edit server Log-on Message\n");
     prtsp("DETAIL    Detail Info on User-ID\n");
     prtsp("AUDIT     Display the Audit Trail\n");
     prtsp("USERS     Stats of Users Online\n");
     prtsp("SEARCH    Account Database Search\n");
     prtsp("HANGUP    Disconnect a User-ID\n");
     prtsp("SUSPEND   Suspend/Unsuspend a User-ID\n");
     prtsp("PROTECT   Protect/Unprotect a User-ID\n");
     if (!redir) {
          if (finup() == ESC) {
               return;
          }
     }
     prtsp("DELETE    Delete a User-ID\n");
     prtsp("SHUTDOWN  Shutdown the System\n");
     prtsp("CLEANUP   Force Cleanup or Event\n");
     prtsp("SYSTATS   View Overall Statistics\n");
     prtsp("MODSTATS  View Module Usage\n");
     prtsp("DEMSTATS  View Demographic Statistics\n");
     prtsp("CLSSTATS  View Class Statistics\n");
     prtsp("EMULATE   Emulate a channel\n");
     prtsp("MONITOR   Monitor All mode\n");
     prtsp("INPUT     Monitor Input mode\n");
     prtsp("CHANGE    Change Channel Status\n");
     prtsp("TYPE      TYPE (a file)\n");
     prtsp("COPY      COPY (a file)\n");
     prtsp("RENAME    RENAME (a file)\n");
     prtsp("DIR       DIR (directory listing)\n");
     prtsp("MD        MD (make a directory)\n");
     prtsp("RD        RD (remove a directory)\n");
     prtsp("DEL       DELETE (a file)\n");
     prtsp("ACCOUNT   Accounting Access\n");
     prtsp("TRANSFER  Transfer File Access\n\n");
}

int
anyaxs(void)                       /* does user have any access at all?    */
{
     int i;

     if (sameas(usaptr->userid,"Sysop")) {
          return(1);
     }
     for (i=0 ; i < AXSSIZ ; i++) {
          if (usaptr->access[i]&0xFFFF) {
               return(1);
          }
     }
     return(0);
}

int
axs4op(op)                         /* does user have access to this op?    */
int op;
{
     if (sameas(usaptr->userid,"Sysop")) {
          return(1);
     }
     return(usaptr->access[op>>4]&(1<<(op%16)));
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: User Classes Report Routines                                  :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
usrcls(void)                       /* list classes main line code          */
{
     locate(0,25);
     cursact(0);
     if (cancel()) {
          return;
     }
     explode(scntbl[4],0,0,79,24);
     setatr(0x1f);
     prtcen(1,"User Classes Report");
     scn2mem(frzseg(),scrsav1,SCNSIZ);
     locate(2,3);
     setatr(0x1f);
     if (redir) {
          printf("Now outputting report to \"%s\"\n",inpnam);
     }
     setwin(0L,2,3,76,22,1);
     bfp2=opnbtv("bbsk.dat",RINGSZ);
     bfp=opnbtv("bbsclas.dat",sizeof(struct acclass));
     if (!qlobtv(0)) {
          catastro("Classes Data file is empty!");
     }
     do {
          gcrbtv(&class,0);
          if (!(class.flags&HASCRD && class.flags&NOCRED)) {
               if (!redir) {
                    printf("\014");
               }
               prtsp("Class Name:  %-16s\n\n",class.clname);
               prtsp("Number of minutes user can spend online per call: %s\n",
                  ((class.limcal == -1) ? "Unlimited" :
                      spr("%d %s",class.limcal,"Minutes")));
               prtsp("Number of minutes user can spend online per  day: %s\n",
                  ((class.limday == -1) ? "Unlimited" :
                      spr("%d %s",class.limday,"Minutes")));
               if (class.limday != -1) {
                    prtsp("If the time limit for the day is reached, the system will %s\n",
                       ((class.flags&KCKOFF) ? "disconnect them." :
                       spr("switch them \n     to the %s class.",class.nxtcls[DOUTTIM])));
                    prtsp("  (Class transition message used: %s)\n",(class.msgs[0][0] == '\0') ?
                          "the default." : "<< Custom >>");
               }
               prtsp("Users in this class are %sexempt from credit charges.\n",
                  ((class.flags&CRDXMT) ? "" : "NOT "));
               prtsp("Users in this class are %sallowed to go into debt%s.\n",
                  (class.dbtlmt == 0 ? "NOT " : ""),((class.dbtlmt == 0) ?
                  "" : (class.dbtlmt == -1 ? " (for unlimited credits)"
                  : spr(" (for %s credits)",l2as(class.dbtlmt)))));
               prtsp("%s",(class.dbtlmt == 0 ? "" : fgvchk()));
               swtch();
               prtsp("\n");
               prtsp("Keys held by class (%s keyring):\n",class.clname);
               dspkey(class.clname,1);
               prtsp("\n");
               if (!redir) {
                    if (finup() == ESC) {
                         break;
                    }
               }
          }
     } while (qnxbtv());
     clsbtv(bfp);
     clsbtv(bfp2);
     endrpt();
}

void
swtch(void)                        /* list why a class would switch        */
{
     if (class.flags&(NOCRED|DBTLMT|HASCRD|DAYEXP|IDLEXP)) {
          prtsp("Users in this class will switch to another class if:\n\n");
          if (class.flags&NOCRED) {
               prtsp("     They run out of credits (switch to %s).\n",
                     class.nxtcls[DCREDIT]);
                    prtsp("       (Class transition message used: %s)\n",(class.msgs[1][0] == '\0') ?
                          "the default." : "<< Custom >>");
          }
          if (class.flags&DBTLMT) {
               prtsp("     They reach their debt limit (switch to %s).\n",
                     class.nxtcls[DCREDIT]);
                    prtsp("       (Class transition message used: %s)\n",(class.msgs[1][0] == '\0') ?
                          "the default." : "<< Custom >>");
          }
          if (class.flags&HASCRD) {
               prtsp("     They are posted credits (switch to %s).\n",
                     class.nxtcls[DCREDIT]);
                    prtsp("       (Class transition message used: %s)\n",(class.msgs[1][0] == '\0') ?
                          "the default." : "<< Custom >>");
          }
          if (class.flags&DAYEXP) {
               prtsp("     They have been in the class for %d days (switch to %s).\n",
                     class.dftday,class.nxtcls[DEXPIRE]);
          }
          if (class.flags&IDLEXP) {
               prtsp("     They haven't logged on for %d days (switch to %s).\n",
                     class.idlday,class.nxtcls[DLOAFER]);
          }
     }
}

char *
fgvchk(void)                       /* when to forgive check and report     */
{
     static char buf[120];
     int used=0;

     strcpy(buf,"All debts on this account will be cleared ");
     if (class.flags&MONDAY) {
          strcat(buf,"on Every Monday");
          used=1;
     }
     if (class.flags&FSTMTH) {
          strcat(buf,"on the 1st of each month");
          used=1;
     }
     if (class.flags&NUMDAY) {
          strcat(buf,spr("every %d days",class.fgvday));
          used=1;
     }
     if (class.flags&HITLMT) {
          strcat(buf,"when they hit their debt limit");
          used=1;
     }
     if (used) {
          strcat(buf,(!class.flags&REPDBT) ? ".\n" : " and\nwill be reported.\n");
     }
     else {
          strcpy(buf,"Debts will never be cleared.\n");
     }
     return(buf);
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Forum Quickscan Report Routines                               :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
forqsc(void)                       /* Forum quickscan report main line     */
{
     locate(0,25);
     cursact(0);
     if (cancel()) {
          return;
     }
     explode(scntbl[4],0,0,79,24);
     setatr(0x1f);
     prtcen(1,"Forum Quickscan Report");
     scn2mem(frzseg(),scrsav1,SCNSIZ);
     setatr(0x1f);
     locate(2,3);
     setwin(0L,2,3,76,22,1);
     initgme();
     strcpy(chkkey,msgscan("galme.msg","FORSYS"));
     accbb=opnbtv("bbsusr.dat",sizeof(struct usracc));
     keybb=opnbtv("bbsk.dat",RINGSZ);
     cycqsc();
     shtdwn();
     endrpt();
}

void
cycqsc(void)                       /* Cycle through each SIG in sigtab     */
{
     int i;
     unsigned forum;

     cntlin=0;
     for (i=0 ; i < numforums() ; i++) {
          forum=seqdef(i)->forum;
          prtshdr(forum);
          if (!prcusrs(forum)) {
               return;
          }
     }
}

int
prcusrs(forum)                     /* report on Forum and its q-scanners   */
unsigned forum;                    /*  (and others with non-default access)*/
{
     int i,retlvl;
     char dspusr[80];
     struct fmidky *fmarr;
     long himsg;

     setbtv(qscbb);
     if (qlobtv(0)) {
          do {
               gcrbtv(qsptr,0);
               if (sameas(qsptr->userid,"Sysop")) {
                    continue;
               }
               setbtv(accbb);
               if (!acqbtv(&acct,qsptr->userid,0)) {
                    rstbtv();
                    geqbtv(qsptr,qsptr->userid,0);
                    delbtv();
               }
               else {
                    rstbtv();
                    fmarr=(struct fmidky *)qsptr->accmsg;
                    himsg=0L;
                    for (i=0 ; i < qsptr->nforums ; i++) {
                         if (fmarr[i].forum == forum) {
                              himsg=fmarr[i].msgid;
                              break;
                         }
                    }
                    if ((retlvl=rdautl(forum)) != NOTSET || himsg > 1L) {
                         setmem(dspusr,sizeof(dspusr),0);
                         sprintf(dspusr,"%-30s %c%s",qsptr->userid,
                                (himsg > 1L ? '*' : ' '),lvls[retlvl]);
                         strcat(dspusr,"\n");
                         prtsp(dspusr);
                         cntlin++;
                         if (!redir && cntlin >= 19) {
                              cntlin=0;
                              if (finup() == ESC) {
                                   return(0);
                              }
                         }
                    }
               }
               setbtv(qscbb);
          } while (qnxbtv());
          prtdln();
          cntlin++;
     }
     return(1);
}

void
prtshdr(forum)                     /* print header info for this Forum     */
unsigned forum;
{
     struct fordef *fdef;

     fdef=getdef(forum);
     prtsp("            Forum Name: %-16s\n",fdef->name);
     prtsp("              Forum ID: %-6u\n",fdef->forum);
     prtsp(" Non-Privileged Access: %-8s\n",lvls[fdef->dfnpv]);
     prtsp("     Privileged Access: %-8s\n",lvls[fdef->dfprv]);
     prtsp("    Max Non-Privileged: %-8s\n",lvls[fdef->mxnpv]);
     prtsp("        Privileged Key: %-16s\n",fdef->forlok);
     prtdln();
     cntlin+=6;
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Audscan Report Routines                                       :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

void
audscn(void)                       /* audit trail scanner main line        */
{
     locate(0,25);
     cursact(0);
     while (!auddone) {
          switch (substate) {
               case AUDMENU:
                    audmenu();
                    break;
               case AUDUMENU:
                    audumenu();
                    break;
               case AUDPRTMNU:
                    audprtmnu();
                    break;
               case AUDPRTUMNU:
                    audprtumnu();
                    break;
               case AUDPWHERE2:
                    pwhere();
                    break;
               case AUDFOWARD:
                    foward();
                    break;
               case AUDGETDAT1:
                    auddat1();
                    break;
               case AUDGETDAT2:
                    auddat2();
                    break;
               case AUDGETUID:
                    getuid();
                    break;
               case AUDSTRSCH:
                    strsch();
                    break;
          }
     }
     movmem(scntbl[6],frzseg(),SCNSIZ);
     newpos('1',1);
     auddone=0;
     state=MNMENU;
}

void
audmenu(void)                      /* handle menu choice                   */
{
     uid[0]='\0';
     casesn=1;
     redir=printer=0;
     movmem(scntbl[2],frzseg(),SCNSIZ);
     cursact(1);
     locate(67,19);
     substate=AUDPWHERE2;
     switch (c=toupper(getchc())) {
     case 'A':
          setscn("USER CREDIT TRANSFER","->","All Credit Transfers",1);
          break;
     case 'B':
          setscn("CREDITS POSTED","","All Credit Posts",1);
          break;
     case 'C':
          setscn("CREDITS POSTED","FREE","All FREE Credit Posts",1);
          break;
     case 'D':
          setscn("CREDITS POSTED","PAID","All PAID Credit Posts",1);
          break;
     case 'E':
          setscn("UPLOAD","","All Uploads To System",0);
          break;
     case 'F':
          setscn("DOWNLOAD","","All Downloads From System",0);
          break;
     case 'G':
          setscn("Console","","All Main Console Activity",0);
          break;
     case 'H':
          setscn("SERVER UP: V","","All SERVER-UP Entries",0);
          break;
     case 'I':
          setscn("SERVER SHUTDOWN","","All SHUTDOWN Entries",0);
          break;
     case 'J':
          setscn("Cleanup","","All Auto-Cleanup Entries",0);
          break;
     case 'K':
          setscn("USER ACCOUNT DELETED","","All User-ID Deletions",0);
          break;
     case 'L':
          setscn("USER ACCOUNT SUSPENDED","","All User-ID Suspensions",0);
          break;
     case 'M':
          setscn("USER ACCOUNT UNSUSPENDED","","All User-ID Un-suspensions",0);
          break;
     case 'N':
          setscn("NEW USER SIGNUP","","All New Sign-Ups",0);
          break;
     case 'O':
          setscn("TELECONFERENCE LINK-UP","","All \"LINKED\" Entries",0);
          break;
     case 'P':
          if (agetstr()) {
               setscn("",search,search,0);
               casesn=0;
          }
          break;
     case 'Q':
          setscn("USER ACCOUNT PROTECTED","","All User-ID Protections",0);
          break;
     case 'R':
          setscn("USER ACCOUNT UNPROTECTED","","All User-ID Un-protections",0);
          break;
     case 'S':
          setscn("","","Entire Audit Trail",0);
          break;
     case 'T':
          substate=AUDGETUID;
          break;
     case 'X':
     case ESCKEY:
          printf("\n\n");
          auddone=1;
          break;
     default:
          substate=AUDMENU;
          printf("\7");
     }
}

void
audumenu(void)                     /* handle USER menu entry               */
{
     casesn=0;
     wchmnu=1;
     movmem(scntbl[3],frzseg(),SCNSIZ);
     locate(36,4);
     setatr(0x1f);
     printf("%s",uid);
     cursact(1);
     locate(54,18);
     substate=AUDPWHERE2;
     switch (c=toupper(getchc())) {
     case 'A':
          strcpy(srcstg,"->");
          strcat(srcstg,uid);
          setscn("USER CREDIT TRANSFER",srcstg,spr("Credit Transfers TO %s",uid),1);
          break;
     case 'B':
          strcpy(srcstg,uid);
          strcat(srcstg,"->");
          setscn("USER CREDIT TRANSFER",srcstg,spr("Credit Transfers FROM %s",uid),1);
          break;
     case 'C':
          setscn("USER CREDIT TRANSFER",uid,spr("Credit Transfers With %s",uid),1);
          break;
     case 'D':
          setscn("CREDITS POSTED",uid,spr("Credit Posts To %s",uid),1);
          break;
     case 'E':
          setscn("FREE",uid,spr("FREE Credit Posts To %s",uid),1);
          break;
     case 'F':
          setscn("PAID",uid,spr("PAID Credit Posts To %s",uid),1);
          break;
     case 'G':
          setscn("DOWNLOAD",uid,spr("Downloads To %s",uid),0);
          break;
     case 'H':
          setscn("UPLOAD",uid,spr("Uploads From %s",uid),0);
          break;
     case 'I':
          setscn("LOGON",uid,spr("Logons For %s",uid),0);
          break;
     case 'J':
          setscn("LOGOFF",uid,spr("Logoffs For %s",uid),0);
          break;
     case 'K':
          setscn(uid,"",uid,0);
          break;
     case 'X':
     case ESCKEY:
          wchmnu=0;
          substate=AUDPRTMNU;
          break;
     default:
          substate=AUDUMENU;
          printf("\7");
     }
}

void
auddat1(void)
{
     int chkdon=0;
     int mon=0,day=0,year=0;

     explodeto(scntbl[0],38,18,77,22,25,6);
     locate(27,7);
     printf("Enter the STARTING date for search\n");
     locate(27,8);
     printf("in the form MM/DD/YY, OR");
     locate(27,9);
     printf("<RETURN> for none: ");
     locate(46,9);
     setatr(0x0f);
     printf("  /  /  ");
     locate(46,9);
     while(!chkdon) {
          switch(getdat()) {
          case -2:
               substate=wchmnu == 0  ? AUDMENU : AUDUMENU;
               chkdon=1;
               break;
          case -1:
               baddat();
               break;
          case 0:
               strcpy(datnone,fward == 0 ? "999999" : "000000");
               strcpy(datone,"<NONE>");
               locate(46,9);
               setatr(0x2f);
               printf("<NONE>  ");
               substate=AUDGETDAT2;
               chkdon=1;
               break;
          case 1:
               locate(46,9);
               setatr(0x2f);
               printf("%s",retdat);
               strcpy(datone,retdat);
               sscanf(datone,"%d/%d/%d",&mon,&day,&year);
               setmem(datnone,DATESIZ,0);
               sprintf(datnone,"%02d%02d%02d",year,mon,day);
               chkdon=1;
               substate=AUDGETDAT2;
               break;
          }
     }
}

void
auddat2(void)                           /* get second date for audscan     */
{
     int chkdon=0;
     int mon=0,day=0,year=0;
     unsigned edat,bdat;

     explodeto(scntbl[0],38,18,77,22,35,10);
     setatr(0x2f);
     locate(37,11);
     printf("Enter the ENDING date for search  ");
     locate(37,12);
     printf("in the form MM/DD/YY, OR");
     locate(37,13);
     printf("<RETURN> for none: ");
     locate(56,13);
     setatr(0x0f);
     printf("  /  /  ");
     locate(56,13);
     while(!chkdon) {
          switch(getdat()) {
          case -2:
               substate=wchmnu == 0  ? AUDMENU : AUDUMENU;
               chkdon=1;
               break;
          case -1:
               baddat();
               break;
          case 0:
               strcpy(datntwo,fward == 0 ? "000000" : "999999");
               locate(56,13);
               setatr(0x2f);
               printf("<NONE>  ");
               strcpy(dattwo,"<NONE>");
               substate=AUDSTRSCH;
               chkdon=1;
               break;
          case 1:
               locate(56,13);
               setatr(0x2f);
               printf("%s",retdat);
               strcpy(dattwo,retdat);
               sscanf(dattwo,"%d/%d/%d",&mon,&day,&year);
               setmem(datntwo,DATESIZ,0);
               sprintf(datntwo,"%02d%02d%02d",year,mon,day);
               if (!sameas(datone,"<NONE>")
                  && !sameas(dattwo,"<NONE>")) {
                    bdat=(unsigned)dcdate(datone);
                    edat=(unsigned)dcdate(dattwo);
                    if ((fward == 1 && edat < bdat) ||
                        (fward == 0 && bdat < edat)) {
                         baddat();
                    }
                    else {
                         substate=AUDSTRSCH;
                    }
               }
               else {
                    substate=AUDSTRSCH;
               }
               chkdon=1;
               break;
          }
     }
}

void
setscn(stg1,stg2,desc,addcrd) /* Set Search Parameters for scan            */
char *stg1,*stg2,*desc;
int addcrd;
{
     strcpy(search1,stg1);
     strcpy(search2,stg2);
     strcpy(search3,desc);
     credit=addcrd;
}

void
pwhere(void)                       /* Prompt for where to send output      */
{
     substate=(whrout() == 0 ? (wchmnu == 0 ? AUDMENU : AUDUMENU)
                            : AUDFOWARD);
}

void
foward(void)                       /* Search Forward or Backward           */
{
     explodeto(scntbl[0],38,10,77,13,10,3);
     strcpy(forwrd,"Forward");
     do {
          if (!(edtval(22,5,sizeof(forwrd),forwrd,fwdchk,MCHOICE))) {
               substate=wchmnu == 0  ? AUDMENU : AUDUMENU;
               return;
          }
     } while (forwrd[0] == '\0');
     fward=forwrd[0] == 'F' ? 1 : 0;
     substate=AUDGETDAT1;
}

int
fwdchk(c,stg)                      /* check routine for forward backward   */
int c;
char *stg;
{
     if (tolower(c) == 'f') {
          strcpy(stg,"Forward");
     }
     else if (tolower(c) == 'b') {
          strcpy(stg,"Backward");
     }
     else {
          if (*stg == 'F') {
               strcpy(stg,"Backward");
          }
          else {
               strcpy(stg,"Forward");
          }
     }
     return(0);
}

void
audprtmnu(void)                    /* Print Main Menu                      */
{
     scblank(frzseg(),0x0f);
     explodeto(scntbl[2],0,0,79,21,0,0);
     cursact(1);
     locate(67,19);
     substate=AUDMENU;
}

void
audprtumnu(void)                   /* Print User Search Menu               */
{
     scblank(frzseg(),0x0f);
     explode(scntbl[3],0,0,79,20);
     cursact(1);
     locate(54,18);
     substate=AUDUMENU;
}

void
strsch(void)                      /* Start searching the audit trail      */
{
     int c,acqb=0,acqe,abt=0;

     found=0;
     done=0;
     stop=0;
     form=0;
     credits=0L;
     finish=0L;
     locate(0,25);
     cursact(0);

     explode(scntbl[5],0,0,79,24);
     locate(30,1);
     setatr(0x1f);
     printf("\"%s\"",search3);
     bfp=opnbtv("bbsaudit.dat",AUDSIZ);
     setwin(0L,2,3,76,22,1);
     locate(2,3);
     setatr(0x1f);
     if (fward == 1 ? qlebtv(datntwo,0) : qgebtv(datntwo,0)) {
          acqb=1;
          finish=absbtv();
     }
     if (redir) {
          fprintf(outf,"\nSearching Audit Trail for \"%s\"\n",search3);
          fprintf(outf,"Searching %sWARDS ",fward ? "FOR" : "BACK");
          fprintf(outf,"Starting Date: %s Ending Date: %s \n\n",datone,dattwo);
     }
     acqe=(fward == 1 ? qgebtv(datnone,0) : qlebtv(datnone,0));
     if (acqb == 0 || acqe == 0) {
          norecs();
          eofrpt(abt);
          return;
     }
     else {
          do {
               gcrbtv(audrec,0);
               if (stgsbs(audrec,search1,casesn)
                  || stgsbs(audrec+67,search1,casesn)) {
                    if (*search2 == '\0' || (stgsbs(audrec,search2,casesn)
                       || stgsbs(audrec+67,search2,casesn))) {
                         found=1;
                         prtsp("\n%14.14s %-32.32s %s\n",
                                  audrec,audrec+14,audrec+47);
                         prtsp("     %-64s",audrec+67);
                         stop+=2;
                         form+=2;
                         if (credit) {
                              credits+=scncrd(audrec);
                         }
                    }
               }
               if (kbhit()) {
                    if ((c=getchc()) == ' ' || c == CTRLS){
                         stop=0;
                         finup2();
                    }
                    else {
                         abt=1;
                         printf("\n                          *** REPORT ABORTED ***\n");
                         if (redir) {
                              fprintf(outf,
                               "\n                     *** REPORT ABORTED ***\n");
                         }
                         break;
                    }
               }
               if (printer && form >= 54) {
                    fprintf(outf,"\f\n\n\n");
                    form=0;
               }
               if (!redir && stop >= 18) {
                    finup2();
                    stop=0;
               }
               if (finish == absbtv()) {
                    done=1;
               }
               acqe=fward == 1 ? qnxbtv() : qprbtv();
               if  (acqe == 0) {
                    done=1;
               }
          } while (!(done));
     }
     clsbtv(bfp);
     if (!found) {
          norecs();
     }
     if (found && credit) {
          printf("\n\n");
          printf("               Total amount of %s: %s",search3,l2as(credits));
          printf("\n");
          if (redir) {
               fprintf(outf,"\n\nTotal amount of %s: %s\n",search3,
                                                           l2as(credits));
          }
     }
     eofrpt(abt);
}

void
eofrpt(abt)                        /* End of report printing               */
int abt;
{
     if (!abt) {
          printf("\n                          *** END OF REPORT ***\n");
          if (redir) {
               fprintf(outf,"\n                      *** END OF REPORT *** \n");
          }
     }
     if (redir) {
          if (printer) {
               fprintf(outf,"\f");
          }
          fclose(outf);
     }
     finup2();
     substate=wchmnu == 0 ? AUDMENU : AUDUMENU;
}

void
norecs(void)                       /* No records found                     */
{
     printf("\n                           No Matching Records\n\n");
     if (redir) {
          fprintf(outf,"\n                       No Matching Records\n");
     }
}

long
scncrd(stg)                        /* Scan Auditrail for Credit Amount     */
char *stg;
{
     int neg=0;
     long retval=0L;

     stg+=67;
     while (*stg != '\0') {
          if (*stg == '-') {
               neg=1;
               stg++;
               continue;
          }
          if (isdigit(*stg)) {
               do {
                    retval=(retval*10)+(*stg-'0');
                    stg++;
                    if (*stg == ' ' || *stg == '\0') {
                         if (neg) {
                              retval=-retval;
                         }
                         return(retval);
                    }
               } while (isdigit(*stg));
               retval=0L;
          }
          stg++;
          neg=0;
     }
     return(0L);
}

void
prtcen(int y,char *stg)            /* Center and print a string            */
{
     char buffer[81];

     sprintf(buffer,stg);
     locate((80-strlen(buffer))/2,(y == -1) ? curcury() : y);
     printf("%s",buffer);
}

int
finup(void)                        /* Hit any key to continue              */
{
     int c;

     printf("           << Hit Any Key to Continue or ESC to abort >>");
     c=getchc();
     printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
            "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
            "\b\b\b\b");
     return(c);
}

void
finup2(void)                       /* Hit any key to continue              */
{
     printf("                      << Hit Any Key to Continue >>");
     getchc();
     printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
            "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
            "\b\b");
}

void
getuid(void)                       /* get userid for scanning auditrail    */
{
     setmem(uid,UIDSIZ,0);
     scn2mem(frzseg(),scrsav2,SCNSIZ);
     explodeto(scntbl[0],38,6,79,9,19,5);
     do {
          if (!(edtval(26,7,sizeof(uid),uid,isuidc,0))) {
               substate=AUDMENU;
               return;
          }
          if (strlen(uid) < 3) {
               uid[0]='\0';
          }
     } while (uid[0] == '\0');
     movmem(scrsav2,frzseg(),SCNSIZ);
     strcpy(search2,uid);
     substate=AUDPRTUMNU;
}

STATIC
int
agetstr(void)                      /* get a string from the user           */
{
     explodeto(scntbl[1],40,0,78,4,19,5);
     setmem(search,SCHSTG,0);
     do {
          if (!edtval(21,8,SCHSTG,search,valsch,0)) {
               substate=AUDMENU;
               return(0);
          }
     } while (search[0] == '\0');
     return(1);
}

STATIC int
valsch(c)                          /* validate string search               */
int c;                                  /* created value from edtval       */
{
     if (c <= 255 && isprint(c)) {
          return(1);
     }
     else {
          return(0);
     }
}

int
stgsbs(stg1,stg2,cas)              /* Check auditrail entry for strings    */
char *stg1,*stg2;                       /* strings to search for           */
int cas;                                /* case sensative?                 */
{
     char *startp,*compare;

     startp=stg1;
     compare=stg2;
     while (*startp != '\0') {
          if (cas) {
               while (*stg1 == *stg2 && *stg1 != '\0') {
                    stg1++;
                    stg2++;
               }
          }
          else {
               while (tolower(*stg1) == tolower(*stg2) && *stg1 != '\0') {
                    stg1++;
                    stg2++;
               }
          }
          if (*stg2 == '\0') {
               return(1);
          }
          startp++;
          stg1=startp;
          stg2=compare;
     }
     return(0);
}

/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/
/*: BBSRPT: Shared Routines                                               :*/
/*:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:*/

int
whrout(void)                       /* find out where to put output         */
{
     scn2mem(frzseg(),scrsav3,SCNSIZ);
     strcpy(repchr,"1");
     explodeto(scntbl[0],0,0,37,9,19,5);
     do {
          cursact(1);
          if (!(edtval(51,13,sizeof(repchr),repchr,myvalid,0))) {
               return(0);
          }
     } while(repchr[0] == '\0');
     switch (repchr[0]) {
     case '1':
          outnam[0]='\0';
          pagbrk=19;
          line=-1;
          redir=0;
          break;
     case '2':
          pagbrk=0;
          line=-1;
          strcpy(inpnam,"PRN");
          if ((outf=fopen(inpnam,FOPWA)) == NULL) {
               scn2mem(frzseg(),scrsav2,SCNSIZ);
               explodeto(scntbl[0],38,0,75,5,19,7);
               getchc();
               movmem(scrsav2,frzseg(),SCNSIZ);
               inpnam[0]='\0';
          }
          redir=1;
          break;
     case '3':
          pagbrk=0;
          line=-1;
          if (getfil()) {
               strcpy(outnam,inpnam);
               redir=1;
               }
          else {
               inpnam[0]='\0';
          }
          break;
     }
     movmem(scrsav3,frzseg(),SCNSIZ);
     return(1);
}

int
getfil(void)                       /* if out to file, get the file name    */
{
     inpnam[0]='\0';
     scn2mem(frzseg(),scrsav2,SCNSIZ);
     explodeto(scntbl[0],38,14,77,17,19,7);
     do {
          if (!edtval(44,9,sizeof(inpnam),inpnam,valfil,0)) {
               movmem(scrsav2,frzseg(),SCNSIZ);
               return(0);
          }
          if (!rsvnam(inpnam)) {
               if ((outf=fopen(inpnam,FOPWA)) == NULL) {
                    scn2mem(frzseg(),scrsav2,SCNSIZ);
                    explodeto(scntbl[0],0,11,37,16,19,7);
                    getchc();
                    movmem(scrsav2,frzseg(),SCNSIZ);
                    inpnam[0]='\0';
               }
          }
          else {
               scn2mem(frzseg(),scrsav2,SCNSIZ);
               explodeto(scntbl[0],0,11,37,16,19,7);
               getchc();
               movmem(scrsav2,frzseg(),SCNSIZ);
               inpnam[0]='\0';
          }
     } while (inpnam[0] == '\0');
     return(1);
}

valfil(c)                          /* validate file name                   */
int c;
{
     if (!isprint(c)) {
          return(0);
     }
     return(1);
}

static
void
prtsp(stg,p1,p2,p3,p4,p5)          /* print to proper places during output */
char *stg;
long p1,p2,p3,p4,p5;
{
     char buffer[1024];

     sprintf(buffer,stg,p1,p2,p3,p4,p5);
     if (redir) {
          fprintf(outf,"%s",buffer);
     }
     printf("%s",buffer);
}

void
draw(cleanup)                      /* draw an option on the screen         */
int cleanup;                            /* is this a reverse option? 1=no  */
{
     locate(cursor->x-1,cursor->y);
     if (cleanup) {
          setatr(0x2f);
     }
     else {
          setatr(0x70);
     }
     printf(" %c ",cursor->stroke);
     if (cleanup) {
          setatr(0x1f);
     }
     else {
          setatr(0x70);
     }
     locate(cursor->x+4,cursor->y);
     printf(" %s ",cursor->title);
}

void
newpos(ch,cleanup)                 /* point to a new option                */
char ch;
int cleanup;
{
     if (cleanup) {
          draw(1);
     }
     curpos=ch;
     cursor=options+ch-'0';
     setatr(0x70);
     draw(0);
     setwin(NULL,helpx,helpy,75,23,0);
     locate(helpx,helpy);
     setatr(0x2f);
     printf(help[ch-'0'][0]);
     clreol();
     locate(helpx,helpy+1);
     printf(help[ch-'0'][1]);
     clreol();
     setatr(0x1f);
     rstwin();
     home();
}

int
getdat(void)                        /* get date from user with validation   */
{
     int c,i=0,isdon=0;

     do {
          switch (c=getchc()) {
          case RETKEY:
               if (i == 0) {
                    isdon=1;
                    datval=0;
               }
               else if (i == 8) {
                    if (!chkdate(retdat)) {
                         datval=-1;
                         isdon=1;
                    }
                    else {
                         retdat[i]='\0';
                         datval=1;
                         isdon=1;
                    }
               }
               else {
                     printf("\7");
               }
               break;
          case CRSRLF:
          case '\b':
               if (i == 0) {
                    printf("\7");
               }
               else {
                    retdat[i--]='\0';
                    printf("\b");
                    if (i == 2 || i == 5) {
                         retdat[i--]='\0';
                         printf("\b");
                         locate(curcurx()+1,curcury());
                         printf("/");
                         locate(curcurx()-2,curcury());
                    }
               }
               break;
          case ESCKEY:
               return(-2);
          default:
               if (!isascii(c) || !isdigit(c) || i == DATESIZ-1) {
                    printf("\7");
               }
               else {
                    retdat[i++]=c;
                    printf("%c",c);
                    if (i == 2 || i == 5) {
                         retdat[i++]='/';
                         printf("/");
                    }
               }
          }
     } while (!isdon);
     return(datval);
}


chkdate(stg)                       /* check date and make sure it is valid */
char *stg;
{
     static int mths=12,ndays[]={31,28,31,30,31,30,31,31,30,31,30,31};
     int mon=0,day=0,year=0;
     int isleap;
     int retval=1;

     year=4;
     if (sscanf(stg,"%d/%d/%d",&mon,&day,&year) != 3) {
          if (sscanf(stg,"%d/%d",&mon,&day) != 2) {
               return(0);
          }
     }
     isleap=((year%4) == 0 ? 1 : 0);
     if (mon < 1 || mon > mths) {
          retval=0;
     }
     else if (day < 1 || (day > ndays[mon-1] && !isleap) ||
                         (day > ndays[mon-1]+1 && isleap)) {
          retval=0;
     }
     return(retval);
}

int
cancel(void)                       /* where should output go?              */
{
     if (!whrout()) {
          state=MNMENU;
          return(1);
     }
     cursact(1);
     locate(0,25);
     cursact(0);
     return(0);
}

void
baddat(void)                       /* display bad date msg and reprompt    */
{
     scn2mem(frzseg(),scrsav3,SCNSIZ);
     locate(0,25);
     explodeto(scntbl[0],0,17,37,22,19,7);
     getchc();
     movmem(scrsav3,frzseg(),SCNSIZ);
     if (substate == AUDGETDAT1) {
          locate(46,9);
          setatr(0x0f);
          printf("  /  /  ");
          locate(46,9);
     }
     else if (substate == AUDGETDAT2) {
          locate(56,13);
          setatr(0x0f);
          printf("  /  /  ");
          locate(56,13);
     }
}

void
endrpt(void)
{
     printf("\nEnd of report.\n");
     printf("\nHit any key to continue\n");
     getchc();
     state=MNMENU;
}

void
shtdwn(void)                       /* Close all files for termination      */
{
     if (accbb != NULL) {
          clsbtv(accbb);
          accbb=NULL;
     }
     if (keybb != NULL) {
          clsbtv(keybb);
          keybb=NULL;
     }
     if (outf != NULL) {
          fclose(outf);
          outf=NULL;
     }
}

void
initgme(void)                      /* initialize the GME                   */
{
     if (!gmeup) {
          iniogme();
          qsptr=(struct qscfg *)alcmem(MAXQSR);
          gmeup=TRUE;
     }
}

void
closgme(void)                      /* close down the GME                   */
{
     if (gmeup) {
          clsogme(FALSE);
          gmeup=FALSE;
     }
}

void
appgprept(void)                    /* application-specific GP info (stub)  */
{
}

void
appgprecd(void)                    /* application-specific GP record (stub)*/
{
}
