/***************************************************************************
 *                                                                         *
 *   BBSMAINM.C                                                            *
 *                                                                         *
 *   Copyright (C) 1993 Consensus Systems, Inc.  All rights reserved.      *
 *   Copyright (C) 1993-1996 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This is the Galacticomm Client/Server main menu agent.                *
 *                                                                         *
 *                                              - T. Stryker 11/26/93      *
 *                                                C. Robert                *
 *                                                B. Love                  *
 *                                                D. Pitchford 6/9/94      *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "bbsmainm.h"
#include "gcwinver.h"

#define FILREV "$Revision: 1.18 $"

static void mmuread(int direction,struct saunam *dpknam);
static void dpkmenu(int direction);
static void dpkstart(int direction);
static void dpkiconf(int direction);
static void dpkhpsf(int direction);
static void dpkfpage(void);
static void dpkexefl(BOOL cmp);
static void dpksupfl(int direction,BOOL cmp);
static void dpksupfs(void);
static void dpkappif(int direction);
static void dpkappth(void);
static void dpkrecnt(void);
static void dpkusron(void);
static void dontzap(void);
static void sendpage(char *override);
static char *autosel(struct mnupag *autmnu);
static BOOL hasaxs(struct mnupag *page);
static void startups(void);
static void setstfunc(char *dllnfunc,BOOL (**stfunc)(void));
static void loadhpsl(void);
static char *gethps(char *pagnam);
static unsigned int filtpage(char *page,unsigned int totlen);
static void makflist(char *fils);
static void eatpage(char *page);
static BOOL eatobj(char *page);
static void dpkhpsmenu(void);
static void mmuwrite(struct saunam *dpknam,unsigned length,void *value);
static void mmuxdone(void);
static void mmuabort(void);
static void invis(BOOL inv);
static void pagestat(BOOL ison,BOOL isok);
static void pageuser(char *uid,char *msg);
static int pagcsusr(char *from,char *msg);
static void gappnams(void);
static char *appid(char *modnam);
static void announce(int direction);
static BOOL annvec(void);
static void annvecyc(void);
static void dpkbkgdf(void);
static void dpksplaf(char *filename);
static void dpklaunchpg(void);
static void dpkssfile(BOOL cmp);
static void dpkssfinf(int direction);
static int getnsupfs(char *data);
static struct dpkwv *getssfinf(char *filnam);
static char *compext(char *filnam);
static void pagecon(void);

#define ICONDIR  "WGSICONS\\"      /* local directory for icon files       */
#define ICONEXT  ".ICO"            /* extension for icon files             */
#define DEFICO   "WGSDEF"          /* default icon file name               */
#define IMGICO   "WGSIMAGE"        /* default system icon file name        */
#define PKEYSIZE (1+2*PNMSIZ)      /* menu page key size                   */
#define ICOPSIZE (MAXPATH+1+FNEXSZ)/* icon path with ; and suggestion fnam */
#define MDATSZ (TITLSZ+MAXSEL*(PNMSIZ+SHDSIZ+LNDSIZ+FNSIZE))
#define MAINMAPP "BBSMAINM"

static
struct agent mmuagt={              /* agent information structure          */
     MAINMAPP,                     /*   appid                              */
     mmuread,                      /*   read-dynapak function pointer      */
     mmuwrite,                     /*   write-dynapak function pointer     */
     mmuxdone,                     /*   file xfer-done function pointer    */
     mmuabort                      /*   abort-request function pointer     */
};

struct cshdr {                     /* three page types after common data   */
     int pagetype;                 /*   page type 0=menu, 1=mod, 2,3=file  */
     char pagnam[PNMSIZ-1];        /*   page name                          */
     BOOL access;                  /*   has access to the page             */
     BOOL cango;                   /*   has access to FIND/GO the page     */
};

struct csmenu {                    /* menu page                            */
     struct cshdr hdr;             /*   common header to pages             */
     int mnutyp;                   /*   menu type (see types below)        */
     BOOL autosel;                 /*   autoselect menu                    */
     long ichange;                 /*   time code of changes to icons      */
     int nopts;                    /*   number of selections on the menu   */
     char data[MDATSZ];            /*   menu data                          */
};
                                   /* menu type codes                      */
#define ICOMNU -1                  /*   icon menu                          */
#define LBXMNU 0                   /*   listbox menu                       */
#define HPSMNU 1                   /*   hypermedia menu                    */

#define csmenupg ((struct csmenu *)rsptmp)

struct csmod {                     /* module page                          */
     struct cshdr hdr;             /*   common header to pages             */
     int modutype;                 /*   mod type: 0=C/S 1=A/A              */
     char appid[AIDSIZ-1];         /*   appid of executable                */
     char cmdstg[CMDSIZ-1];        /*   command stg for entry to module    */
};

#define csmodpg ((struct csmod *)rsptmp)

struct csfile {                    /* file page                            */
     struct cshdr hdr;             /*   common header to pages             */
     char filname[FNEXSZ-1];       /*   file name (w/ ext.) being shown    */
     char caption[LNDSIZ-1];       /*   window caption to put on display   */
};

#define csfilepg ((struct csfile *)rsptmp)

static
struct startup {                   /* singly linked list of startup apps   */
     char *appid;                  /*   App-ID + optional dll and function */
     BOOL (*stfunc)(void);         /*   permission function to call        */
     struct startup *next;         /*   next startup app                   */
} *cssfirst=NULL;

struct options {                   /* main menu options                    */
     BOOL invis;                   /*   user is invisible (unsec.)         */
     BOOL pageon;                  /*   user's page is on/off              */
     BOOL pageok;                  /*   user is /P OK                      */
     BOOL caninv;                  /*   user can toggle invis (unsec.)     */
     BOOL canlook;                 /*   user can lookup users (unsec.)     */
     int pagint;                   /*   page interval in minutes           */
     BOOL deftbstt;                /*   toolbar appears by default         */
     BOOL usrtbtog;                /*   user able to show/hide toolbar     */
     int confses;                  /*   confirm shutdown:1=yes -1=no 0=user*/
     BOOL confusr;                 /*   confirm by default (confses=0)     */
};

struct mmrqi {                     /* per request information              */
     int reqtype;                  /*   type of request                    */
     int index;                    /*   request index for announce()       */
};

/* NOTE: the size of this structure MUST match the #define ANNOSIZE        */

#define mmptr ((struct mmrqi *)mrqptr)

#define MMRQNULL 0                 /* ordinary request                     */
#define MMRQANNO 1                 /* announcement request                 */
#define MMRQMENU 2                 /* downloading main menu                */

static
struct appref {                    /* cross-reference app-id to module name*/
     char appid[AIDSIZ];           /*   appid                              */
     char modnam[MNMSIZ];          /*   module name                        */
} *apps;                           /*   app elements loaded                */

static
int numapps;                       /* number of elements in **dlls         */

#define xsize(a) (*((unsigned int *)a))

struct xstg {                      /* structure for bytestring-encoded stg */
     int stglen;                   /*   length of string                   */
     char stg[1];                  /*   string                             */
};

struct pheader {                   /* struct: page header in .HPS files    */
     int len;                      /*   length of page header              */
     int version;                  /*   version of .HPS file               */
     struct xstg bgfile;           /*   graphic file bytestring            */
};

struct oheader {                   /* struct: object headers in .HPS files */
     int len;                      /*   length of object                   */
     int otype;                    /*   type of object                     */
     struct xstg keyreq;           /*   key required bytestring            */
};

extern
BTVFILE *mnubb;                    /* menu information btrieve file pointer*/

static
struct mnupag mnutmp,mnutmp2;      /* temporary menu pages for access check*/

static
char *wgsicon,                     /* actual bbs icon file name, w/o ext.  */
     *aboutmsg,                    /* message, if any, for About... box    */
     *eggappid,                    /* appid for easter egg                 */
     *longdesc,                    /* long description set by hasaxs()     */
     *shrtdesc,                    /* short description set by hasaxs()    */
     *hpspp,                       /* path prefix for .HPS files           */
     **hpsfils,                    /* list of all .HPS files in hpspp      */
     **curflist;                   /* per-user current HPS page file lists */

static
int numhps,                        /* total number of .HPS files in hpsfils*/
    confses;                       /* reference confses in struct options  */

static
BOOL deftbstt,                     /* system default toolbar state         */
     usrtbtog,                     /* users allowed to toggle own toolbars */
     confusr=FALSE;                /* reference confusr in struct options  */

static
struct saunam *rspdpk;             /* modifiable copy of req. dynapak hdr. */

static
char *splashf,                     /* name of graphic file for "splash"    */
     *butext,                      /* text on "splash" screen's button     */
     *splashs;                     /* name of sound file for "splash"      */

static
int tbbopt,                        /* timer, button or both "splash" opt   */
    artprg;                        /* display art download progress boxes? */

static
int mnucfg[2];                     /* menu configuration options           */

static
int spload;                        /* load splash scn in bkgd              */

static
BOOL *canpage;                     /* nterms array of page-able C/S users  */

#define TIMER   1                  /* "timer" option for splash screen     */
#define BUTTON  2                  /* "button" option for splash screen    */
#define BOTH    3                  /* "both" option for splash screen      */

static
int tmrval;                        /* value of splash timer (in seconds)   */

static
FILE *bbmsg;

void EXPORT
init__bbsmainm(void)               /* agent initialization routine         */
{
     char *sptr;

     register_agent(&mmuagt);
     bbmsg=opnmsg("BBSMAINM.MCV");
     dclmrq(sizeof(struct mmrqi));
     wgsicon=getmsg(ABOUTICO);
     if ((sptr=strchr(wgsicon,'.')) != NULL) {
          *sptr='\0';
     }
     if (*wgsicon == '\0') {
          wgsicon=IMGICO;
     }
     else {
          wgsicon=strcpy(alcmem(strlen(wgsicon)+1),wgsicon);
     }
     eggappid=stgopt(EGGIE);
     stp4cs(sptr=getmsg(ABOUTLIN));
     while (sptr[0] == '\n') {
          sptr++;
     }
     while (strlen(sptr) > 0 && sptr[strlen(sptr)-1] == '\n') {
          sptr[strlen(sptr)-1]='\0';
     }
     strcpy(aboutmsg=alcmem(strlen(sptr)+1),sptr);
     hpspp=pthopt(HPSPP);
     deftbstt=ynopt(TBDEFT);
     usrtbtog=ynopt(TBALOW);
     switch (tokopt(CONFSES,"ALWAYS","NEVER","CHOICE",NULL)) {
     case 1: /* "ALWAYS" */
          confses=1;
          break;
     case 3: /* "CHOICE" */
          confses=0;
          confusr=ynopt(CONFUSR);
          break;
     default:
     case 2: /* "NEVER" */
          confses=-1;
     }
     splashf=stgopt(SPLASHF);
     butext=stgopt(BUTEXT);
     splashs=stgopt(SPLASHS);
     tbbopt=tokopt(TBBOPT,"TIMER","BUTTON","BOTH");
     tmrval=numopt(TMRVAL,1,60);
     artprg=ynopt(ARTPRG);
     mnucfg[0]=tokopt(ICOLFORE,"BLACK","WHITE","YELLOW","RED","CYAN");
     mnucfg[1]=tokopt(ICOLBACK,"TRANSP","BLACK","WHITE","D-GREY","L-GREY");
     spload=ynopt(SPLOAD);
     setmem(&mnutmp,sizeof(struct mnupag),0);
     setmem(&mnutmp2,sizeof(struct mnupag),0);
     rspdpk=(struct saunam *)alcmem(sizeof(struct saunam));
     gappnams();
     loadhpsl();
     curflist=(char **)alczer(nterms*sizeof(char *));
     canpage=(BOOL *)alczer(nterms*sizeof(BOOL));
     cspagerou=pagcsusr;
     hook_connect(pagecon);
     rtkick(1,startups);
}

static void
mmuread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg;
     char icopath[ICOPSIZE];
     struct fndblk fb;
     struct options opts;

     *rspdpk=*dpknam;
     dpkstg=cnvs2d(rspdpk);
     mmptr->reqtype=MMRQNULL;
     if (samepato("sa:appinfo ",dpkstg) || samepato("saf:appfile ",dpkstg)) {
          dpkappif(direction);
          return;
     }
     if (samepato("sa:apppath ",dpkstg)) {
          dpkappth();
          return;
     }
     if (samepato("saf:supfile ",dpkstg)) {
          dpksupfl(direction,FALSE);
          return;
     }
     if (samepato("saf:csupfile ",dpkstg)) {
          dpksupfl(direction,TRUE);
          return;
     }
     if (samepato("sa:ssfinf ",dpkstg)) {
          dpkssfinf(direction);
          return;
     }
     if (direction == 0) {
          if (samepato("saf:ssfile ",dpkstg)) {
               dpkssfile(FALSE);
               return;
          }
          if (samepato("saf:cssfile ",dpkstg)) {
               dpkssfile(TRUE);
               return;
          }
          if (samepato("saf:exefile ",dpkstg)) {
               dpkexefl(FALSE);
               return;
          }
          if (samepato("saf:cexefile ",dpkstg)) {
               dpkexefl(TRUE);
               return;
          }
          if (samepato("sa:supfiles ",dpkstg)) {
               dpksupfs();
               return;
          }
     }
     if (!stdchk("")) {  /* ALL HANDLERS AFTER THIS POINT ARE stdchk()'D */
          rejectreq();
          return;
     }
     if (samepato("sau:announce ",dpkstg)) {
          announce(direction);
          return;
     }
     if (samepato("sau:menu ",dpkstg)) {
          dpkmenu(direction);
          return;
     }
     if (samepato("sa:startup ",dpkstg)) {
          dpkstart(direction);
          return;
     }
     if (samepato("sauf:iconfile ",dpkstg)) {
          dpkiconf(direction);
          return;
     }
     if (samepato("sauf:hpsfile ",dpkstg)) {
          dpkhpsf(direction);
          return;
     }
     if (direction != 0) {  /* ALL HANDLERS AFTER THIS ARE NONDIRECTIONAL */
          rejectreq();
          return;
     }
     if (sameto("sau:hpsmenu ",dpkstg)) {
          dpkhpsmenu();
          return;
     }
     if (samepat("sa:recents",dpkstg)) {
          dpkrecnt();
          return;
     }
     if (samepat("sa:about",dpkstg)) {
          sprintf(vdatmp,"%s %s",bturno,aboutmsg);
          rsp2read(rspdpk,STGLEN,vdatmp);
          return;
     }
     if (samepat("sa:about eggie",dpkstg)) {
          rsp2read(rspdpk,STGLEN,eggappid);
          return;
     }
     if (samepat("saf:sysicon",dpkstg)) {
          sprintf(icopath,"%s%s%s",ICONDIR,wgsicon,ICONEXT);
          if (fnd1st(&fb,icopath,0) && fb.size < 2048L) {
               strcat(icopath,";");
               strcat(icopath,IMGICO);
               strcat(icopath,ICONEXT);
               rsp2read(rspdpk,STGLEN,icopath);
          }
          else {
               rejectreq();
          }
          return;
     }
     if (samepat("sau:options",dpkstg)) {
          opts.invis=(usrptr->flags&INVISB) ? VBTRUE : FALSE;
          opts.pageon=pageset != NULL
                                   && (*pageset)() == 3 ? VBTRUE : FALSE;
          opts.pageok=pageset != NULL
                                   && (*pageset)() == 1 ? VBTRUE : FALSE;
          opts.caninv=haskey(glbkeyi) ? VBTRUE : FALSE;
          opts.canlook=haskey(glbkey) ? VBTRUE : FALSE;
          opts.pagint=(gpirou == NULL ? gpagint : gpirou(usrnum))/60;
          opts.deftbstt=deftbstt ? VBTRUE : FALSE;
          opts.usrtbtog=usrtbtog ? VBTRUE : FALSE;
          opts.confses=confses;
          opts.confusr=confusr ? VBTRUE : FALSE;
          rsp2read(rspdpk,sizeof(struct options),&opts);
          return;
     }
     if (samepat("sa:userson",dpkstg)) {
          dpkusron();
          return;
     }
     if (samepato("saf:fpage ",dpkstg)) {
          dpkfpage();
          return;
     }
     if (samepato("saf:bkgdbmp ",dpkstg)) {
          dpkbkgdf();
          return;
     }
     if (samepat("saf:splashfile",dpkstg)) {
          dpksplaf(splashf);
          return;
     }
     if (samepat("saf:splashwav",dpkstg)) {
          dpksplaf(splashs);
          return;
     }
     if (samepat("sa:artopts",dpkstg)) {
          sprintf(rsptmp,"%d\t%d\t%d\t%s\t%d\t%d\t%d",
                   artprg,tbbopt,tmrval,butext,
                   mnucfg[0],mnucfg[1],spload);
          rsp2read(rspdpk,STGLEN,rsptmp);
          return;
     }
     if (samepato("saf:launchpage ",dpkstg)) {
          dpklaunchpg();
          return;
     }
     rejectreq();
}

static void
dpkmenu(                           /* find menu page to return on request  */
int direction)                          /* read direction                  */
{
     char pagkey[PKEYSIZE];

     pagkey[0]='C';
     if (sameto("menu ",rspdpk->suffix)) {
          stzcpy(&pagkey[1],&rspdpk->suffix[strlen("menu ")],PNMSIZ);
     }
     else {
          pagkey[1]='\0';
     }
     setbtv(mnubb);
     switch (direction) {
     case 0:
          if (!acqbtv(menupg,pagkey,0)) {
               rejectreq();
               return;
          }
          break;
     case 1:
          if (!agtbtv(menupg,pagkey,0) || pagkey[0] != menupg->menutype[0]) {
               rejectreq();
               return;
          }
          break;
     case -1:
          if (!altbtv(menupg,pagkey,0) || pagkey[0] != menupg->menutype[0]) {
               rejectreq();
               return;
          }
          break;
     default:
          rejectreq();
          return;
     }
     sprintf(rspdpk->suffix,"menu %s",menupg->pagnam);
     sendpage("");
}

static void
dpkstart(                          /* tell what appid's are startup apps   */
int direction)                          /* read direction                  */
{
     char *s;
     int idx,cloop;
     struct startup *cur;

     s=skpwht(skpwrd(rspdpk->suffix));
     idx=atoi(s);
     if ((s=strrchr(rspdpk->suffix,' ')) == NULL) {
          rejectreq();
          return;
     }
     s++;
     if (*s == '\0' && direction == 1) {
          idx=-1;
     }
     while (1) {
          idx+=direction;
          if (idx < 0) {
               rejectreq();
               return;
          }
          for (cur=cssfirst,cloop=0 ; cur != NULL ; cur=cur->next,cloop++) {
               if (cloop == idx) {
                    if (cur->stfunc == NULL || (*cur->stfunc)()) {
                         sprintf(s,"%02d",idx);
                         rsp2read(rspdpk,STGLEN,cur->appid);
                         return;
                    }
                    break;
               }
          }
          if (cur == NULL || direction == 0) {
               rejectreq();
               return;
          }
     }
}

static void
dpkiconf(                          /* transfer icon file                   */
int direction)                          /* read direction                  */
{
     struct fndblk fb;
     char pagkey[PKEYSIZE];
     char icopath[ICOPSIZE];
     char *s,*icofile;
     int idx,i,pg=0;

     pagkey[0]='C';
     stzcpy(&pagkey[1],&rspdpk->suffix[strlen("iconfile ")],2*PNMSIZ);
     if ((s=strchr(pagkey,' ')) == NULL) {
          rejectreq();
          return;
     }
     *s++='\0';
     if (*s == '\0') {
          idx=0;
     }
     else {
          idx=atoi(s)+direction;
     }
     if (idx < 0 || idx >= MAXSEL) {
          rejectreq();
          return;
     }
     if ((s=strrchr(rspdpk->suffix,' ')) == NULL) {
          rejectreq();
          return;
     }
     sprintf(++s,"%02d",idx);
     setbtv(mnubb);
     if ((!sameas(mnutmp2.menutype,pagkey) && !acqbtv(&mnutmp2,pagkey,0))
        || (mnutmp2.flags&(MDLPAG|FILPAG))
        || !(mnutmp2.flags&DFTDSP)
        || !hasaxs(&mnutmp2)) {
          rejectreq();
          return;
     }
     do {
          s=autosel(&mnutmp2);
     } while (*s != '\0');
     for (i=0 ; i < mnutmp2.npages ; i++) {
          if (haskey(mnutmp2.page[i].keyreq)
            || mnutmp2.page[i].optdsp != 0) {
               if (pg == idx) {
                    break;
               }
               else {
                    pg++;
               }
          }
     }
     if (i >= mnutmp2.npages) {
          rejectreq();
          return;
     }
     icofile=mnutmp2.page[i].iconame;
     if (icofile[0] == '\0') {
          icofile=DEFICO;
     }
     sprintf(icopath,"%s%s%s",ICONDIR,icofile,ICONEXT);
     while (!fnd1st(&fb,icopath,0) || fb.size > 2048L) {
          if (icofile == DEFICO) {
               rejectreq();
               return;
          }
          else {
               icofile=DEFICO;
               sprintf(icopath,"%s%s%s",ICONDIR,icofile,ICONEXT);
          }
     }
     strcat(icopath,";");
     strcat(icopath,icofile);
     strcat(icopath,ICONEXT);
     rsp2read(rspdpk,STGLEN,icopath);
}

static void
dpkhpsf(                           /* get hypermedia file                  */
int direction)                     /*   read direction                     */
{
     char *filnam,*found;
     int nitems,i;
     struct fndblk fb;

     if (curflist[usrnum] == NULL || direction == -1) {
          rejectreq();
          return;
     }
     filnam=skpwrd(&rspdpk->suffix[strlen("hpsfile ")]);
     if (*filnam != ' ') {
          strcpy(filnam," ");
     }
     filnam++;
     nitems=itemcnt(curflist[usrnum]);
     for (i=0 ; i < nitems ; i++) {
          found=itemidx(curflist[usrnum],i);
          if (direction == 0) {
               if (sameas(filnam,found)) {
                    found=spr("%s%s",hpspp,found);
                    if (fnd1st(&fb,found,0)) {
                         rsp2read(rspdpk,STGLEN,found);
                    }
                    else {
                         rejectreq();
                    }
                    return;
               }
          }
          else {
               if (stricmp(filnam,found) < 0) {
                    strcpy(filnam,found);
                    found=spr("%s%s",hpspp,found);
                    if (fnd1st(&fb,found,0)) {
                         rsp2read(rspdpk,STGLEN,found);
                         return;
                    }
               }
          }
     }
     rejectreq();
}

static void
dpkfpage(void)                     /* transfer file page file              */
{
     struct fndblk fb;
     int i;
     BOOL good=FALSE;
     char fpath[MAXPATH];
     char pagkey[PKEYSIZE];
     static struct mnupag tmpag;

     pagkey[0]='C';
     stzcpy(&pagkey[1],&rspdpk->suffix[6],2*PNMSIZ);
     setbtv(mnubb);
     if (!acqbtv(&mnutmp2,pagkey,0)) {
          rejectreq();
          return;
     }
     if ((mnutmp2.flags&(AUTPAG|FILPAG)) == AUTPAG) {
          for (i=0 ; i < mnutmp2.npages; i++) {
               stzcpy(&pagkey[1],mnutmp2.page[i].destpage,PNMSIZ);
               if (acqbtv(&tmpag,pagkey,0) && hasaxs(&tmpag)) {
                    if (tmpag.flags&FILPAG) {
                         movmem(&tmpag,&mnutmp2,sizeof(struct mnupag));
                         good=TRUE;
                         break;
                    }
                    else {
                         rejectreq();
                         return;
                    }
               }
          }
          if (!good) {
               rejectreq();
               return;
          }
     }
     else if (!(mnutmp2.flags&FILPAG) || !hasaxs(&mnutmp2)) {
          rejectreq();
          return;
     }
     stzcpy(fpath,mnutmp2.fname,MAXPATH);
     if (!fnd1st(&fb,fpath,0)) {
          rejectreq();
          shocst("C/S FILE PAGE FILE MISSING","%s %s",mnutmp2.pagnam,fpath);
          return;
     }
     rsp2read(rspdpk,STGLEN,fpath);
}

static void
dpkexefl(                          /* transfer app executable              */
BOOL cmp)                          /*   compressed one?                    */
{
     struct fndblk fb;
     struct saunam local;
     char appid[AIDSIZ];

     if (!sameas(rspdpk->sysid,msysid)) {
          rejectreq();
          return;
     }
     stzcpy(appid,skpwht(skpwrd(rspdpk->suffix)),AIDSIZ);
     if (!stdchk("") && !sameas(appid,supappid)) {
          rejectreq();
          return;
     }
     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     local.flags=FLGFIL;
     stzcpy(local.suffix,spr("appfile %s EXE",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     if (cmp) {
          strcpy(rsptmp,compext(GDPBTR->value));
          if (fnd1st(&fb,rsptmp,0)) {
               rsp2read(rspdpk,STGLEN,rsptmp);
               return;
          }
     }
     strcpy(rsptmp,GDPBTR->value);
     if (fnd1st(&fb,rsptmp,0)) {
          rsp2read(rspdpk,STGLEN,rsptmp);
          return;
     }
     rejectreq();
}

static void
dpksupfl(                          /* transfer support file                */
int direction,                     /*   direction of read                  */
BOOL cmp)                          /*   compressed version?                */
{
     struct saunam local;
     char *s,appid[AIDSIZ];
     struct fndblk fb;
     int idx;

     if (!sameas(rspdpk->sysid,msysid)) {
          rejectreq();
          return;
     }
     if ((s=strrchr(rspdpk->suffix,' ')) != NULL) {
          idx=atoi(++s);
          if (*s == '\0' && direction == 1) {
               idx=0;
          }
          else {
               idx+=direction;
          }
          if (direction != 0) {
               sprintf(s,"%02d",idx);
          }
     }
     else {
          rejectreq();
          return;
     }
     stzcpy(appid,firstwd(skpwht(skpwrd(rspdpk->suffix))),AIDSIZ);
     if (!stdchk("") && !sameas(appid,supappid)) {
          rejectreq();
          return;
     }
     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0
      || idx >= getnsupfs(GDPBTR->value)) {
          rejectreq();
          return;
     }
     local.flags=FLGFIL;
     stzcpy(local.suffix,spr("appfile %s %d",appid,idx),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     if (cmp) {
          strcpy(rsptmp,compext(GDPBTR->value));
          if (fnd1st(&fb,rsptmp,0)) {
               rsp2read(rspdpk,STGLEN,rsptmp);
               return;
          }
     }
     strcpy(rsptmp,GDPBTR->value);
     if (fnd1st(&fb,rsptmp,0)) {
          rsp2read(rspdpk,STGLEN,rsptmp);
          return;
     }
     rejectreq();
}

static void
dpksupfs(void)                     /* send all support file names          */
{
     char appid[AIDSIZ];
     struct saunam local;
     int idx,nsupfl;

     if (!sameas(rspdpk->sysid,msysid)) {
          rejectreq();
          return;
     }
     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(appid,&rspdpk->suffix[9],AIDSIZ);
     if (!stdchk("") && !sameas(appid,supappid)) {
          rejectreq();
          return;
     }
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     nsupfl=getnsupfs(GDPBTR->value);
     local.flags=FLGFIL;
     vdatmp[0]='\0';
     for (idx=0 ; idx < nsupfl ; idx++) {
          stzcpy(local.suffix,spr("appfile %s %d",appid,idx),SFXSIZ);
          if (readgdp(0,&local,0,NULL) == 0) {
               rejectreq();
               return;
          }
          strcat(vdatmp,GDPBTR->value);
          strcat(vdatmp," "); /* note: space is required after last element */
     }
     rsp2read(rspdpk,STGLEN,vdatmp);
}

static void
dpkappif(                          /* return information on an app         */
int direction)                     /*   read direction                     */
{
     char *appid;

     if (!sameas(rspdpk->sysid,msysid)) {
          rejectreq();
          return;
     }
     appid=firstwd(skpwht(skpwrd(rspdpk->suffix)));
     if (sameas(appid,supappid) || sameas(appid,MAINMAPP)) {
          cycleme(dontzap);
          mmptr->reqtype=MMRQMENU;
     }
     if (!stdchk("") && !sameas(appid,supappid)) {
          rejectreq();
          return;
     }
     r2rgdp(direction,rspdpk);
}

static void
dpkappth(void)                     /* send app exe file name and info.     */
{
     char appid[AIDSIZ],path[2*MAXPATH];
     struct saunam local;

     if (!sameas(rspdpk->sysid,msysid)) {
          rejectreq();
          return;
     }
     stzcpy(appid,&rspdpk->suffix[8],AIDSIZ);
     if (!stdchk("") && !sameas(appid,supappid)) {
          rejectreq();
          return;
     }
     setmem(&local,sizeof(struct saunam),0);
     stzcpy(local.appid,MAINMAPP,AIDSIZ);
     stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
          return;
     }
     local.flags=FLGFIL;
     stzcpy(local.suffix,spr("appfile %s EXE",appid),SFXSIZ);
     if (readgdp(0,&local,0,NULL) == 0) {
          rejectreq();
     }
     else {
          stzcpy(path,GDPBTR->value,2*MAXPATH);
          stzcat(path," ",2*MAXPATH);
          stzcpy(local.suffix,spr("appinfo %s",appid),SFXSIZ);
          local.flags=0;
          if (readgdp(0,&local,0,NULL) == 0) {
               rejectreq();
          }
          else {
               stzcat(path,GDPBTR->value,2*MAXPATH);
               rsp2read(rspdpk,STGLEN,path);
          }
     }
}

static void
dpkrecnt(void)                     /* info on one recent caller            */
{
     char *uid,*buf,*tim;
     int idx;
     struct recalls *rv;

     buf=prfbuf;
     for (idx=0 ; idx < nreccl ; idx++) {
          rv=&recents[idx];
          uid=rv->userid;
          if (uid[0] != '\0') {
               tim=nctime(rv->logon);
               *buf++=atoi(&tim[0])+32;
               *buf++=atoi(&tim[3])+32;
               *buf++=atoi(&tim[6])+32;
               tim=nctime(rv->logoff);
               *buf++=atoi(&tim[0])+32;
               *buf++=atoi(&tim[3])+32;
               *buf++=atoi(&tim[6])+32;
               sprintf(buf,"%s%c",uid,9);
               buf+=strlen(uid)+1;
          }
     }
     if (buf == prfbuf) {
          rejectreq();
     }
     else {
          rsp2read(rspdpk,(int)(buf-prfbuf),prfbuf);
     }
}

static void
dpkusron(void)                     /* return all users online              */
{
     int idx;

     clrmlt();
     for (idx=0 ; idx < nterms ; idx++) {
          if (user[idx].class >= SUPLON && !(user[idx].flags&INVISB)) {
               prf("%s%s%c",spr("%02X",channel[idx]),uacoff(idx)->userid,9);
          }
     }
     rsp2read(rspdpk,STGLEN,prfbuf);
}

static void
dontzap(void)                      /* prevent user from idling offline     */
{
     usrptr->usetmr=0;
     if (!(usrptr->flags&NOINJO)) {
          usrptr->flags|=NOINJO;  /* no pages while receiving system file  */
     }
}

static void
sendpage(                          /* send the page found                  */
char *override)                         /* overriding page name for autsel */
{
     int i,typ;
     BOOL axs;
     char *s,*stg,*ldesc,*sdesc;
     struct cshdr *header;

     for (i=menupg->npages ; i < MAXSEL ; i++) {
          setmem(&menupg->page[i],sizeof(struct pglink),0);
     }
     if (menupg->flags&FILPAG) {
          typ=2;
          header=&csfilepg->hdr;
     }
     else if (menupg->flags&MDLPAG) {
          typ=1;
          header=&csmodpg->hdr;
     }
     else {
          if (*(s=autosel(menupg)) != '\0') {
               sendpage(s);
               return;
          }
          typ=0;
          header=&csmenupg->hdr;
     }
     c2bcpy(header->pagnam,override[0] == '\0' ? menupg->pagnam : override,
        PNMSIZ-1);
     longdesc="";
     shrtdesc="";
     axs=override[0] != '\0' || hasaxs(menupg);
     ldesc=longdesc; /* set by hasaxs() */
     sdesc=shrtdesc; /* set by hasaxs() */
     header->cango=((menupg->flags&CNGOTO) && haskey(menupg->golock)
        && override[0] == '\0');
     header->access=(axs ? VBTRUE : FALSE);
     header->cango=(header->cango ? VBTRUE : FALSE);
     header->pagetype=typ;
     switch (typ) {
     case 0: /* menu */
          if (gethps(menupg->pagnam) != NULL) {
               csmenupg->mnutyp=HPSMNU;
          }
          else {
               csmenupg->mnutyp=((menupg->flags&DFTDSP) ? ICOMNU : LBXMNU);
          }
          csmenupg->autosel=(override[0] != '\0' ? VBTRUE : FALSE);
          csmenupg->ichange=menupg->ichange;
          csmenupg->nopts=0;
          setmem(csmenupg->data,MDATSZ,0);
          if (!axs) {
               rsp2read(rspdpk,sizeof(struct csmenu)-MDATSZ,csmenupg);
               break;
          }
          sprintf(csmenupg->data,"%s\t",menupg->mnuttl);
          for (i=0 ; i < MAXSEL ; i++) {
               if ((haskey(menupg->page[i].keyreq)
                       || menupg->page[i].optdsp > 0)
                       && menupg->page[i].selchr != '\0') {
                    strcat(csmenupg->data,menupg->page[i].destpage);
                    strcat(csmenupg->data,"\t");
                    strcat(csmenupg->data,menupg->page[i].shortd);
                    strcat(csmenupg->data,"\t");
                    strcat(csmenupg->data,menupg->page[i].longd);
                    strcat(csmenupg->data,"\t");
                    strcat(csmenupg->data,menupg->page[i].iconame);
                    strcat(csmenupg->data,"\t");
                    csmenupg->nopts++;
               }
          }
          rsp2read(rspdpk,
             sizeof(struct csmenu)-MDATSZ+strlen(csmenupg->data),csmenupg);
          break;
     case 1: /* module */
          csmodpg->modutype=((menupg->flags&CSMPAG) ? 0 : 1);
          c2bcpy(csmodpg->appid,axs ? appid(menupg->modnam) : "",AIDSIZ-1);
          c2bcpy(csmodpg->cmdstg,axs ? menupg->cmdstg : "",CMDSIZ-1);
          rsp2read(rspdpk,sizeof(struct csmod),csmodpg);
          break;
     case 2: /* file */
          if (menupg->flags&NOFPHD) {
               header->pagetype=3; /* launchable! */
          }
          stg=axs ? menupg->fname : "";
          while ((s=strchr(stg,'\\')) != NULL) {
               stg=++s;
          }
          c2bcpy(csfilepg->filname,stg,FNEXSZ-1);
          stg=ldesc[0] == '\0' ? sdesc : ldesc;
          c2bcpy(csfilepg->caption,(axs ? stg : ""),LNDSIZ-1);
          rsp2read(rspdpk,sizeof(struct csfile),csfilepg);
          break;
     default:
          rejectreq();
     }
}

static char *
autosel(                           /* auto-select menu page support        */
struct mnupag *autmnu)
{
     int i;
     char pagkey[PKEYSIZE];
     static struct mnupag tmpag;
     static char oldnam[PNMSIZ];

     oldnam[0]='\0';
     if (autmnu->flags&AUTPAG) {
          pagkey[0]='C';
          setbtv(mnubb);
          for (i=0 ; i < autmnu->npages; i++) {
               stzcpy(&pagkey[1],autmnu->page[i].destpage,PNMSIZ);
               if (haskey(autmnu->page[i].keyreq) && pagkey[1] != '\0') {
                    if (acqbtv(&tmpag,pagkey,0)) {
                         stzcpy(oldnam,autmnu->pagnam,PNMSIZ);
                         movmem(&tmpag,autmnu,sizeof(struct mnupag));
                         return(oldnam);
                    }
               }
          }
     }
     return("");
}

static BOOL
hasaxs(                            /* user has direct access to page       */
struct mnupag *page)                    /* page to test                    */
{
     BOOL access;
     int i;

     setbtv(mnubb);
     if (sameas("TOP",page->pagnam)) {
          access=TRUE;
     }
     else {
          if (page->parpag[0] == '\0'
             || !acqbtv(&mnutmp,spr("C%s",page->parpag),0)) {
               access=TRUE;
          }
          else {
               access=FALSE;
               for (i=0 ; i < mnutmp.npages ; i++) {
                    if (sameas(mnutmp.page[i].destpage,page->pagnam)) {
                         access=haskey(mnutmp.page[i].keyreq);
                         longdesc=mnutmp.page[i].longd;
                         shrtdesc=mnutmp.page[i].shortd;
                         break;
                    }
               }
          }
     }
     if (!access) {
          access=((page->flags&CNGOTO) && haskey(page->golock));
     }
     return(access);
}

static void
startups(void)                     /* determine startup apps               */
{
     struct startup **cur;

     cur=&cssfirst;
     if (tfsopn("MJRBBS.CFG") == 0) {
          catastro("BBSMAINM: Can't find MJRBBS.CFG!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN && tfspfx("CSTART=")) {
               *cur=(struct startup *)alczer(sizeof(struct startup));
               (*cur)->next=NULL;
               (*cur)->appid=alcdup(firstwd(strupr(tfspst)));
               setstfunc(skpwht(skpwrd(tfspst)),&(*cur)->stfunc);
               cur=&(*cur)->next;
          }
     }
}

static void
setstfunc(
char *dllnfunc,
BOOL (**stfunc)(void))
{
     char *dll,*func;
     HMODULE handle;

     dll=alcdup(firstwd(dllnfunc));
     func=alcdup(spr("_%s",nextwd()));
     if (DosGetModHandle(dll,&handle) == 0) {
          if (DosGetProcAddr(handle,func,(PPFN)stfunc) != 0) {
               stfunc=NULL;
          }
     }
     free(func);
     free(dll);
}

static void
loadhpsl(void)                     /* load up list of all .HPS files       */
{
     char allfils[MAXPATH];
     struct fndblk fb;
     int count;

     stlcpy(allfils,hpspp,MAXPATH);
     stlcat(allfils,"*.HPS",MAXPATH);
     numhps=0;
     if (fnd1st(&fb,allfils,0)) {
          do {
               numhps++;
          } while (fndnxt(&fb));
     }
     if (numhps > 0) {
          hpsfils=(char **)alcmem(numhps*sizeof(char *));
          count=0;
          fnd1st(&fb,allfils,0);
          do {
               ASSERT(count < numhps);
               hpsfils[count++]=alcdup(fnroot(fb.name));
          } while (fndnxt(&fb));
          ASSERT(count == numhps);
     }
}

static char *
gethps(                            /* get .HPS file for page (or NULL)     */
char *pagnam)                      /*   page name to get filename for      */
{
     int i;
     char filnam[MAXFILE];

     stzcpy(filnam,pagnam,MAXFILE);
     for (i=0 ; i < numhps ; i++) {
          if (sameas(hpsfils[i],filnam)) {
               return(hpsfils[i]);
          }
     }
     return(NULL);
}

static unsigned int
filtpage(                          /* prepare .HPS page for transmission   */
char *page,                        /*   the .HPS page                      */
unsigned int totlen)               /*   total length of .HPS page          */
{
     unsigned int retval=0;
     int len;

     vdatmp[0]='\0';
     len=xsize(page)+sizeof(unsigned int);
     if (len > totlen || len < sizeof(unsigned int)) {
          return(0);
     }
     eatpage(page);
     page+=len;
     retval+=len;
     totlen-=len;
     while (totlen >= sizeof(unsigned int)) {
          len=xsize(page)+sizeof(unsigned int);
          if (len > totlen || len < sizeof(unsigned int)) {
               return(0);
          }
          if (eatobj(page)) {
               if (totlen-len != 0) {
                    movmem(page+len,page,totlen-len);
               }
          }
          else {
               page+=len;
               retval+=len;
          }
          totlen-=len;
     }
     makflist(vdatmp);
     return(retval);
}

static void
makflist(                          /* make list of files from page source  */
char *fils)                        /*   TAB-delimited list of filenames    */
{
     char **filnam;
     char *sptr;
     int i,nfils,lenfl;

     if (curflist[usrnum] != NULL) {
          free(curflist[usrnum]);
          curflist[usrnum]=NULL;
     }
     if (fils[0] == '\0') {
          return;
     }
     strupr(fils);
     nfils=itemcnt(fils);
     filnam=(char **)alcmem(nfils*sizeof(char *));
     sptr=fils;
     i=0;
     while (sptr != NULL) {
          filnam[i]=sptr;
          i++;
          if ((sptr=strchr(sptr,'\t')) != NULL) {
               *sptr++='\0';
          }
     }
     ASSERT(i == nfils);
     sortstgs(filnam,nfils);
     lenfl=0;
     for (i=0 ; i < nfils ; i++) {
          if (i < nfils-1 && sameas(filnam[i],filnam[i+1])) {
               filnam[i]=NULL;
          }
          else {
               lenfl+=strlen(filnam[i])+1;
          }
     }
     curflist[usrnum]=alczer(lenfl);
     for (i=0 ; i < nfils ; i++) {
          if (filnam[i] != NULL) {
               if (curflist[usrnum][0] != '\0') {
                    strcat(curflist[usrnum],"\t");
               }
               strcat(curflist[usrnum],filnam[i]);
          }
     }
}

static void
eatpage(                           /* build file list for page files       */
char *page)                        /*   preverified header page            */
{
     struct pheader *phead;
     struct xstg *sfile;
     unsigned int ltotal,chop;
     char bgfile[FLNSIZ],sndfile[FLNSIZ];

     phead=(struct pheader *)page;
     ltotal=phead->len+sizeof(unsigned int);
     if (ltotal < sizeof(struct pheader)) {
          return;
     }
     chop=fldoff(pheader,bgfile)+fldoff(xstg,stg);
     ltotal-=chop;
     page+=chop;
     if (phead->bgfile.stglen > ltotal) {
          return;
     }
     stlcpy(bgfile,phead->bgfile.stg,min(FLNSIZ,phead->bgfile.stglen+1));
     ltotal-=phead->bgfile.stglen;
     page+=phead->bgfile.stglen;
     if (ltotal < sizeof(unsigned int)) {
          return;
     }
     sfile=(struct xstg *)page;
     if (sfile->stglen+fldoff(xstg,stg) > ltotal) {
          return;
     }
     stlcpy(sndfile,sfile->stg,min(FLNSIZ,sfile->stglen+1));
     if (strlen(bgfile) > 0) {
          if (vdatmp[0] != '\0') {
               stlcat(vdatmp,"\t",vdasiz);
          }
          stlcat(vdatmp,bgfile,min(strlen(vdatmp)+strlen(bgfile)+1,vdasiz));
     }
     if (strlen(sndfile) > 0) {
          if (vdatmp[0] != '\0') {
               stlcat(vdatmp,"\t",vdasiz);
          }
          stlcat(vdatmp,sndfile,min(strlen(vdatmp)+strlen(sndfile)+1,vdasiz));
     }
}

static BOOL                        /*   TRUE=destroy object for user       */
eatobj(                            /* check user access and build file list*/
char *page)                        /*   preverified object page            */
{
     struct oheader *obj;
     struct xstg *flist;
     unsigned int ltotal,chop;
     char key[KEYSIZ];

     obj=(struct oheader *)page;
     ltotal=obj->len+sizeof(unsigned int);
     if (ltotal < sizeof(struct oheader)) {
          return(TRUE);
     }
     chop=fldoff(oheader,keyreq)+fldoff(xstg,stg);
     ltotal-=chop;
     page+=chop;
     if (obj->keyreq.stglen > ltotal) {
          return(TRUE);
     }
     stlcpy(key,obj->keyreq.stg,min(KEYSIZ,obj->keyreq.stglen+1));
     if (!haskey(key)) {
          return(TRUE);
     }
     ltotal-=obj->keyreq.stglen;
     page+=obj->keyreq.stglen;
     if (ltotal < sizeof(unsigned int)) {
          return(FALSE);
     }
     flist=(struct xstg *)page;
     if (flist->stglen+fldoff(xstg,stg) > ltotal) {
          return(TRUE);
     }
     if (flist->stglen > 0) {
          if (vdatmp[0] != '\0') {
               stlcat(vdatmp,"\t",vdasiz);
          }
          stlcat(vdatmp,flist->stg,min(strlen(vdatmp)+flist->stglen+1,vdasiz));
     }
     return(FALSE);
}

static void
dpkhpsmenu(void)                   /* respond with HPS menu                */
{
     char pagkey[PKEYSIZE],*s;
     FILE *fp;
     unsigned int rtlen;

     pagkey[0]='C';
     stzcpy(&pagkey[1],&rspdpk->suffix[strlen("hpsmenu ")],PNMSIZ);
     setbtv(mnubb);
     if (!acqbtv(menupg,pagkey,0)) {
          rejectreq();
          return;
     }
     do {
          s=autosel(menupg);
     } while (*s != '\0');
     if (!hasaxs(menupg)) {
          rejectreq();
          return;
     }
     s=gethps(menupg->pagnam);
     if (s == NULL) {
          rejectreq();
          return;
     }
     if ((fp=fopen(spr("%s%s.HPS",hpspp,s),FOPRB)) == NULL) {
          rejectreq();
          return;
     }
     rtlen=fread(rsptmp,1,MAXDPKV,fp);
     fclose(fp);
     if (rtlen < 1 || rtlen > MAXDPKV) {
          rejectreq();
          return;
     }
     rtlen=filtpage(rsptmp,rtlen);
     rsp2read(NULL,rtlen,rsptmp);
}

static void
mmuwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *dpkstg;
     struct options opts;

     if (!stdchk("")) {
          rejectreq();
          return;
     }
     dpkstg=cnvs2d(dpknam);
     mmptr->reqtype=MMRQNULL;
     if (samepat("sau:options",dpkstg)) {
          if (length >= sizeof(struct options)) {
               movmem(value,&opts,sizeof(struct options));
               invis(opts.invis);
               pagestat(opts.pageon,opts.pageok);
               rsp2write(TRUE,0,NULL);
               return;
          }
     }
     if (samepat("sa:pagon",dpkstg)) {
          canpage[usrnum]=TRUE;
          rsp2write(TRUE,0,NULL);
          return;
     }
     if (sameas(dpknam->suffix,"page") && sameas(dpknam->sysid,msysid)) {
          pageuser(dpknam->usrid,value);
          return;
     }
     rejectreq();
}

static void
mmuxdone(void)                     /* file transfer-done handler           */
{
     if (mmptr->reqtype == MMRQMENU) {
          usrptr->flags&=~NOINJO;  /* page on, main menu file received */
     }
}

static void
mmuabort(void)                     /* abort-request handler                */
{
     if (mmptr->reqtype == MMRQMENU) {
          usrptr->flags&=~NOINJO;  /* page on, main menu file receive abort */
     }
}

static void
invis(                             /* become visible/invisible             */
BOOL inv)
{
     if (haskey(glbkeyi)) {
          if (inv) {
               usrptr->flags|=INVISB;
               usaptr->flags|=GOINVB;
          }
          else {
               usrptr->flags&=~INVISB;
               usaptr->flags&=~GOINVB;
          }
     }
}

static void
pagestat(                          /* set page on/off/ok                   */
BOOL ison,                              /* is to be set on?                */
BOOL isok)                              /* is to be set ok (priority)?     */
{
     if (spageset != NULL) {
          (*spageset)(ison,isok);
     }
}

static void
pageuser(                          /* page user with message               */
char *uid,                              /* user to page                    */
char *msg)                              /* message to page                 */
{
     BOOL okpage;
     char usrid[UIDSIZ];

     if (pagerou == NULL) {
          rejectreq();
          return;
     }
     stzcpy(usrid,uid,UIDSIZ);
     okpage=((*pagerou)(usrid,msg) == 1) ? TRUE : FALSE;
     if (okpage) {
          clrprf();
     }
     r2wprf(okpage);
}

static int
pagcsusr(                          /* page c/s user with a message         */
char *from,                             /* user the message is from        */
char *msg)                              /* message to send                 */
{
     setmem(rspdpk,sizeof(struct saunam),0);
     if (!(othusp->flags&NOINJO)) {
          if (canpage[othusn]) {
               if (cnvd2s(spr("su=%s;:pgf %s",othuap->userid,from),rspdpk)) {
                    senddpk(othusn,MAINMAPP,NORMAL,rspdpk,STGLEN,msg);
                    return(1);
               }
          }
          else { 
               setmbk(bbmsg);
               if (*msg == '\0') {
                    prfmlt(PAGMSG,from);
               }
               else {
                    prfmlt(PAGNOT,from,msg);
               }
               injoth();
               clrmlt();
               rstmbk();
               return(1);
          }
     }
     return(0);
}

static void
gappnams(void)                     /* get module names vs. appids          */
{
     numapps=0;
     if (tfsopn("MJRBBS.CFG") == 0) {
          catastro("Can't find APP list (MJRBBS.CFG)!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN && tfspfx("APP=")) {
               numapps++;
          }
     }
     if (numapps == 0) {
          return;
     }
     apps=(struct appref *)alczer(numapps*sizeof(struct appref));
     numapps=0;
     if (tfsopn("MJRBBS.CFG") == 0) {
          catastro("Can't find APP list (MJRBBS.CFG)!");
     }
     while (tfsrdl() != TFSDUN) {
          if (tfstate == TFSLIN && tfspfx("APP=")) {
               stzcpy(apps[numapps].appid,firstwd(tfspst),AIDSIZ);
               stzcpy(apps[numapps].modnam,skpwht(skpwrd(tfspst)),MNMSIZ);
               numapps++;
          }
     }
}

static char *
appid(                             /* given module name, return its appid  */
char *modnam)
{
     int i;
     struct appref *dr;

     for (i=0 ; i < numapps ; i++) {
          dr=&apps[i];
          if (sameas(dr->modnam,modnam)) {
               return(dr->appid);
          }
     }
     return("");
}

static void
announce(                          /* respond with announcements           */
int direction)                     /*   index direction                    */
{
     char *s;

     setmem(mrqptr,mrqsiz,0);
     mmptr->reqtype=MMRQANNO;
     s=skpwht(skpwrd(rspdpk->suffix));
     if (*s == '\0') {
          if (direction > 0) {
               mmptr->index=0;
          }
          else {
               rejectreq();
               return;
          }
     }
     else {
          mmptr->index=atoi(s)+direction;
     }
     if (!annvec()) {
          cycleme(annvecyc);
     }
}

static BOOL                        /*   returns TRUE is request answered   */
annvec(void)                       /* call hook_announce vectors           */
{
     struct saunam sn;
     BOOL rv=FALSE;

     annomem=mrqptr+ANNOSIZE;
     if (mmptr->index <= ninarr(annohdl)) {
          *rsptmp='\0';
          if (mmptr->index == 0) {
               addanno(sv.lonmsg);
          }
          else {
               clrprf();
               (*(void (**)())arrelem(annohdl,mmptr->index-1))();
          }
          if (itemcnt(rsptmp) > 1) {
               if (strlen(itemidx(rsptmp,0)) > 0
                  && cnvd2s(spr("sau:announce %04d",mmptr->index),&sn)) {
                    rsp2read(&sn,STGLEN,rsptmp);
                    rv=TRUE;
               }
               else {
                    mmptr->index++;
                    setmem(annomem,mrqsiz-ANNOSIZE,0);
               }
          }
     }
     else {
          rejectreq();
          rv=TRUE;
     }
     return(rv);
}

static void
annvecyc(void)                     /* cycleme() call annvec()              */
{
     annvec();
}

static void
dpkbkgdf(void)
{
     char fname[FNSIZE];
     struct fndblk fb;

     stzcpy(fname,skpwht(skpwrd(rspdpk->suffix)),FNSIZE);
     if (strstr(fname,"..") != NULL) {
          rejectreq();
          return;
     }
     sprintf(rsptmp,"%s%s.BMP",hpspp,fname);
     if (!fnd1st(&fb,rsptmp,0)) {
          sprintf(rsptmp,"%s%s.WMF",hpspp,fname);
          if (!fnd1st(&fb,rsptmp,0)) {
               sprintf(rsptmp,"%s%s.DIB",hpspp,fname);
               if (!fnd1st(&fb,rsptmp,0)) {
                    rejectreq();
                    return;
               }
          }
     }
     rsp2read(rspdpk,STGLEN,rsptmp);
}

static void
dpksplaf(                          /* return splash (graphic/snd) file     */
char *filename)                    /*   name of file to return             */
{
     struct fndblk fb;

     sprintf(rsptmp,"%s%s",hpspp,filename);
     if (filename[0] != '\0' && fnd1st(&fb,rsptmp,0)) {
          rsp2read(rspdpk,STGLEN,rsptmp);
     }
     else {
          rejectreq();
     }
}

static void
dpklaunchpg(void)                  /* launch a file page - request         */
{
     char pagkey[PKEYSIZE];
     struct fndblk fb;

     pagkey[0]='C';
     stzcpy(&pagkey[1],&rspdpk->suffix[strlen("launchpage ")],PNMSIZ);
     setbtv(mnubb);
     if (acqbtv(menupg,pagkey,0)) {
          if (menupg->flags&FILPAG) {
               if (menupg->flags&NOFPHD) {
                    if (hasaxs(menupg)) {
                         if (fnd1st(&fb,menupg->fname,0)) {
                              rsp2read(rspdpk,STGLEN,menupg->fname);
                              return;
                         }
                    }
               }
          }
     }
     rejectreq();
}

static void
dpkssfile(                         /* read shared support file             */
BOOL cmp)                          /*   compressed version?                */
{
     struct dpkwv *inf;
     struct fndblk fb;
     char sfpath[MAXPATH];

     if (!sameas(rspdpk->sysid,msysid)
        || (inf=getssfinf(skpwht(skpwrd(rspdpk->suffix)))) == NULL) {
          rejectreq();
          return;
     }
     sprintf(sfpath,"%s\\%s",SSFDIR,filnpart(inf->filnam));
     if (cmp) {
          strcpy(rsptmp,compext(sfpath));
          if (fnd1st(&fb,rsptmp,0)) {
               rsp2read(rspdpk,STGLEN,rsptmp);
               return;
          }
     }
     strcpy(rsptmp,sfpath);
     if (fnd1st(&fb,rsptmp,0)) {
          rsp2read(rspdpk,STGLEN,rsptmp);
          return;
     }
     rejectreq();
}

static void
dpkssfinf(                         /* return support file name & verinfo   */
int direction)
{
     char appid[AIDSIZ],*fnum,path[MAXPATH];
     int num;
     struct saunam genam;
     struct dpkwv *inf;

     if (!sameas(rspdpk->sysid,msysid)) {
          rejectreq();
          return;
     }
     stzcpy(appid,firstwd(skpwht(skpwrd(rspdpk->suffix))),AIDSIZ);
     if (!stdchk("") && !sameas(appid,supappid)) {
          rejectreq();
          return;
     }
     fnum=nextwd();
     if (*fnum == '\0' && direction == 1) {
          num=0;
     }
     else {
          num=atoi(fnum)+direction;
     }
     if (num < 0) {
          rejectreq();
          return;
     }
     setmem(&genam,sizeof(struct saunam),0);
     stzcpy(genam.appid,MAINMAPP,AIDSIZ);
     genam.flags=FLGFIL;
     sprintf(genam.suffix,"%s %s %d",firstwd(rspdpk->suffix),appid,num);
     sprintf(rspdpk->suffix,"%s %s %03d",firstwd(genam.suffix),appid,num);
     if (readgdp(0,&genam,MAXPATH,path) && (inf=getssfinf(path)) != NULL) {
          stlcat(path,"\t",MAXPATH);
          stlcat(path,l2as(inf->size),MAXPATH);
          stlcat(path,"\t",MAXPATH);
          stlcat(path,ncdate(inf->date),MAXPATH);
          stlcat(path,"\t",MAXPATH);
          stlcat(path,nctime(inf->time),MAXPATH);
          stlcat(path,"\t",MAXPATH);
          stlcat(path,l2as(inf->msl),MAXPATH);
          stlcat(path,"\t",MAXPATH);
          stlcat(path,l2as(inf->lsl),MAXPATH);
          rsp2read(rspdpk,STGLEN,path);
     }
     else {
          rejectreq();
     }
}

static int
getnsupfs(                         /* return number of support files       */
char *data)                        /*   when given an appinfo value        */
{
     return(atoi(itemidxd(data,2,"\n")));
}

static struct dpkwv *
getssfinf(                         /* return shared support file info      */
char *filnam)                      /*   filename to return for             */
{
     struct saunam genam;
     static struct dpkwv bestinf;

     setmem(&genam,sizeof(struct saunam),0);
     stlcpy(genam.appid,MAINMAPP,AIDSIZ);
     genam.flags=FLGFIL;
     sprintf(genam.suffix,"ssfile %s",filnam);
     if (readgdp(0,&genam,sizeof(struct dpkwv),&bestinf)) {
          return(&bestinf);
     }
     return(NULL);
}

static char *
compext(                           /* return path w/ compressed file name  */
char *filnam)                      /*   [path and] file name, uncompressed */
{
     char *fnam,*s;
     static char retval[MAXPATH];

     fnam=filnpart(filnam);
     stlcpy(retval,pathpart(filnam),MAXPATH);
     stlcat(retval,"COMPRESS\\",MAXPATH);
     stlcat(retval,fnam,MAXPATH);
     s=strrchr(fnam,'.');
     if (s == NULL) {
          stlcat(retval,"._",MAXPATH);
     }
     else {
          if (strlen(s) == 4) {
               retval[strlen(retval)-1]='_';
          }
          else {
               stlcat(retval,"_",MAXPATH);
          }
     }
     return(retval);
}

static void
pagecon(void)                      /* hook_connect routine to clear flag   */
{
     canpage[usrnum]=FALSE;
}

