/***************************************************************************/
/*                                                                         */
/*   BBSIGNUP.C                                                            */
/*                                                                         */
/*   Copyright (c) 1993 Consensus Systems, Inc.  All rights reserved.      */
/*   Copyright (c) 1993-1996 Galacticomm, Inc.   All rights reserved.      */
/*                                                                         */
/*   This is the Galacticomm Client/Server signup agent.                   */
/*                                                                         */
/*                                              - T. Stryker 11/26/93      */
/*                                                C. Robert                */
/*                                                B. Love                  */
/*                                                                         */
/***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "bbsignup.h"
#undef LEVEL6                      /* avoid conflicts                      */
#include "bbssup.h"

#define FILREV "$Revision: 1.5 $"

#define  NMQSTS    10              /* # of possible addtn'l signup ques    */
#define  ANSSIZ    80              /* size of each free-form signup answer */
#define  MXASLN    (NMQSTS*(ANSSIZ-1)) /* max len of add sup ans stg fm cli*/
#define  QSFXSZ    4               /* sz of suffix info on sup ques stg    */
#define  MXPRT1    8               /* max # of ques can fit into 1 dpk     */

struct supcfg {                    /* signup config info                   */
     BOOL asknam;                  /*   ask name?                          */
     BOOL askcom;                  /*   ask company?                       */
     BOOL askadr;                  /*   ask address?                       */
     BOOL askpho;                  /*   ask phone number?                  */
     BOOL asksys;                  /*   ask system type?                   */
     BOOL askbdy;                  /*   ask birthday?                      */
     BOOL asksex;                  /*   ask sex?                           */
     int  nmasup;                  /*   # of addtn'l signup ques. (0=none) */
     int  sgnusz;                  /*   max size of userids                */
     BOOL digalw;                  /*   allow digits in userids?           */
     BOOL fulalw;                  /*   allow space and punc in userids?   */
     int  namdft;                  /*   how do we handle signups?          */
} supcfg;                          /* info to send to client               */

struct supdat {                    /* new user signup data sent by client  */
     char userid[UIDSIZ-1];        /*   userid                             */
     char psword[PSWSIZ-1];        /*   password                           */
     char usrnam[NADSIZ-1];        /*   name                               */
     char usrad1[NADSIZ-1];        /*   address line 1 (company)           */
     char usrad2[NADSIZ-1];        /*   address line 2                     */
     char usrad3[NADSIZ-1];        /*   address line 3                     */
     char usrad4[NADSIZ-1];        /*   address line 4                     */
     char usrpho[PHOSIZ-1];        /*   phone number                       */
     int  systyp;                  /*   system type code                   */
     int  sex;                     /*   sex                                */
     char birthd[DATSIZ-1];        /*   birthdate                          */
};

STATIC void supread(int direction,struct saunam *dpknam);
STATIC void supwrite(struct saunam *dpknam,unsigned length,void *value);
STATIC void supxdone(void);
STATIC void supabort(void);

void savusr(char *answers0);

struct agent supagt={              /* agent information structure          */
     "BBSIGNUP",                   /*   appid                              */
     supread,                      /*   read-dynapak function pointer      */
     supwrite,                     /*   write-dynapak function pointer     */
     supxdone,                     /*   file xfer-done function pointer    */
     supabort                      /*   abort-request function pointer     */
};

STATIC
FILE *bbsupmb;                     /* agent message block pointer          */

STATIC
char *supstg1=NULL,                /* stg to store add. signup questions   */
     *supstg2=NULL,                /* extra stg for add. signup questions  */
     answers[NMQSTS][ANSSIZ],      /* ans's to addtn'l signup questions    */
     quesep[]={9,'\0'};            /* ques delimiter in sup ques string    */

STATIC
int lsqlingo=-1;                   /* last lang used for signup ques stgs  */

extern
FILE *supmb;                       /* signup named-message file pointer    */

extern
int supfrm;                        /* format output in fixed-length ASCII? */

struct suprqi {                    /* signup per-request information       */
     int insstt;                   /*   insacc() state for finalization    */
};

#define rqiptr ((struct suprqi *)mrqptr)

STATIC void getsups(void);
STATIC BOOL goodsd(struct supdat *supdat);
STATIC int  valinf(char *infstg,unsigned minlen,BOOL chkpfn);
STATIC void insacc(void);
STATIC void supfin(void);

void EXPORT
init__bbsignup(void)               /* agent initialization routine         */
{
     int msgnum=SUPQS1;


     register_agent(&supagt);
     dclmrq(sizeof(struct suprqi));
     bbsupmb=opnmsg("BBSIGNUP.MCV");
     supcfg.asknam=(asktbl[TBLNAM][0] ? VBTRUE : FALSE);
     supcfg.askcom=(asktbl[TBLAD1][0] ? VBTRUE : FALSE);
     supcfg.askadr=(asktbl[TBLAD2][0] ? VBTRUE : FALSE);
     supcfg.askpho=(asktbl[TBLPHO][0] ? VBTRUE : FALSE);
     supcfg.asksys=(asktbl[TBLSYS][0] ? VBTRUE : FALSE);
     supcfg.askbdy=(asktbl[TBLBDY][0] ? VBTRUE : FALSE);
     supcfg.asksex=(asktbl[TBLSEX][0] ? VBTRUE : FALSE);
     setmbk(supmb);
     for (supcfg.nmasup=0 ; msgnum <= SUPQ10 ; supcfg.nmasup++,msgnum++) {
          if (*(getmsg(msgnum)) == '\0') {
               break;
          }
     }
     rstmbk();
     supcfg.sgnusz=sgnusz;
     supcfg.digalw=(digalw ? VBTRUE : FALSE);
     supcfg.fulalw=(fulalw ? VBTRUE : FALSE);
     supcfg.namdft=namdft;
     hook_shutdown(supfin);
}

STATIC void
getsups(void)                      /* assemble add. sup. ques. stgs        */
{
     int i,lenall=0,len1=0,len2=0,msgnum;
     char *cssuphdr,*cssupend,*csasupq[NMQSTS];

     if (supcfg.nmasup > 0) {
          if (supstg1 != NULL) {
               free(supstg1);
          }
          if (supstg2 != NULL) {
               free(supstg2);
          }
          setmbk(supmb);
          for (i=0,msgnum=SUPQS1 ; i < supcfg.nmasup ; i++,msgnum++) {
               csasupq[i]=stgopt(msgnum);
               stp4cs(csasupq[i]);
               lenall+=strlen(csasupq[i])+1;
          }
          cssuphdr=stgopt(SUPHDR);
          stp4cs(cssuphdr);
          cssupend=stgopt(SUPEND);
          stp4cs(cssupend);
          lenall+=strlen(cssuphdr)+1+strlen(cssupend)+1+QSFXSZ+1;
          if (lenall <= MAXDPKV) {
               supstg1=alczer(lenall);
               strcat(supstg1,cssuphdr);
               strcat(supstg1,quesep);
               for (i=0 ; i < supcfg.nmasup ; i++) {
                    strcat(supstg1,csasupq[i]);
                    strcat(supstg1,quesep);
               }
               strcat(supstg1,cssupend);
               strcat(supstg1,spr("%sn=%d",quesep,supcfg.nmasup));
               supstg2=NULL;
          }
          else {
               for (i=0 ; i < MXPRT1 ; i++) {
                    len1+=strlen(csasupq[i])+1;
               }
               len1+=strlen(cssuphdr)+1+QSFXSZ+1;
               supstg1=alczer(len1);
               strcat(supstg1,cssuphdr);
               strcat(supstg1,quesep);
               for (i=0 ; i < MXPRT1 ; i++) {
                    strcat(supstg1,csasupq[i]);
                    strcat(supstg1,quesep);
               }
               strcat(supstg1,spr("n=%d",MXPRT1));
               for (i=MXPRT1 ; i < supcfg.nmasup ; i++) {
                    len2+=strlen(csasupq[i])+1;
               }
               len2+=strlen(cssupend)+1+QSFXSZ+1;
               supstg2=alczer(len2);
               for (i=MXPRT1 ; i < supcfg.nmasup ; i++) {
                    strcat(supstg2,csasupq[i]);
                    strcat(supstg2,quesep);
               }
               strcat(supstg2,cssupend);
               strcat(supstg2,spr("%sn=%d",quesep,supcfg.nmasup-MXPRT1));
          }
          for (i=0 ; i < supcfg.nmasup ; i++) {
               free(csasupq[i]);
          }
          free(cssuphdr);
          free(cssupend);
          lsqlingo=clingo;
          rstmbk();
     }
}

STATIC void
supread(                           /* read-dynapak handler                 */
int direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     char *dpkstg;

     if (sameas(dpknam->sysid,msysid) && direction == 0 && (*hdlsmp)()) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sa:supcfg")) {
               rsp2read(NULL,sizeof(struct supcfg),&supcfg);
               usrptr->class=SUPIPG;
               usrptr->usetmr=0;
               shochl("Client/server new user logon",'',baudat(usrptr->baud,0));
               return;
          }
          if (sameas(dpkstg,"sa:supques1")) {
               if (supcfg.nmasup > 0 && lsqlingo != clingo) {
                    getsups();
               }
               rsp2read(NULL,STGLEN,supstg1);
               return;
          }
          if (sameas(dpkstg,"sa:supques2")) {
               if (supcfg.nmasup > 0 && lsqlingo != clingo) {
                    getsups();
               }
               rsp2read(NULL,STGLEN,supstg2);
               return;
          }
     }
     rejectreq();
}

STATIC void
supwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
unsigned length,                   /*   length of dynapak value            */
void *value)                       /*   dynapak value to write             */
{
     char *dpkstg;
     int i;
     BOOL vldreq=TRUE;

     setmbk(bbsupmb);
     if (sameas(dpknam->sysid,msysid) && !haskey("") && (*hdlsmp)()) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sa:supdat") && length == sizeof(struct supdat)
           && !(usrptr->flags&GCSDUN)) {
               if (!goodsd(value)) {
                    setmem(usaptr,sizeof(struct usracc),0);
                    r2wprf(FALSE);
               }
               else {
                    rsp2write(TRUE,0,NULL);
               }
               return;
          }
          if (sameas(dpkstg,"sa:supdone") && usaptr->userid[0] != '\0'
           && !(usrptr->flags&GCSDUN)) {
               if (supcfg.nmasup > 0) {
                    if (length < 1 || length > MXASLN) {
                         vldreq=FALSE;
                    }
                    else {
                         for (i=0 ; i < supcfg.nmasup ; i++) {
                              b2ccpy(answers[i],(char *)value+i*(ANSSIZ-1),
                                     ANSSIZ-1);
                         }
                    }
               }
               if (vldreq) {
                    savusr(answers[0]);
                    usrptr->flags|=GCSDUN;
                    rqiptr->insstt=1;
                    cycleme(insacc);
                    return;
               }
          }
     }
     rejectreq();
}

STATIC BOOL
goodsd(                            /* chk signup info, record in usaptr    */
struct supdat *supdat)             /*   info to check                      */
{
     int errn;
     static int baduid[]={CSNAAUID,CSPL1UID,CSPL2UID,CSPL3UID,CSSMLUID,
                          CSBIGUID,CSUIDINU};
     static int baduin[]={NAAUIN,PL1UIN,PL2UIN,PL3UIN,SMLUIN,BIGUIN,UININU};

     setmem(usaptr,sizeof(struct usracc),0);
     supdfts();
     b2ccpy(usaptr->userid,supdat->userid,UIDSIZ);
     setpfn(usaptr->userid);
     if ((errn=valuid(usaptr->userid)) != 0) {
          prf(namdft == 1 ? "NAM" : "UID");
          prfmsg(namdft == 1 ? baduin[errn-1] : baduid[errn-1],usaptr->userid);
          return(FALSE);
     }
     b2ccpy(usaptr->psword,supdat->psword,PSWSIZ);
     if ((errn=valinf(usaptr->psword,1,FALSE)) != 0) {
          prf("PSW");
          prfmsg(PTOOSML);
          return(FALSE);
     }
     else if (!safpsw && !valpsw(usaptr->psword)) {
          prf("PSW");
          prfmsg(BADPSW);
          return(FALSE);
     }
     if (asktbl[TBLNAM][0]) {
          b2ccpy(usaptr->usrnam,supdat->usrnam,NADSIZ);
          if ((errn=valinf(usaptr->usrnam,5,TRUE)) != 0) {
               prf("NAM");
               prfmsg(errn == 1 ? NTOOSML : NPROFAN);
               return(FALSE);
          }
     }
     if (asktbl[TBLAD1][0]) {
          b2ccpy(usaptr->usrad1,supdat->usrad1,NADSIZ);
          if ((errn=valinf(usaptr->usrad1,0,TRUE)) != 0) {
               prf("COM");
               prfmsg(CPROFAN);
               return(FALSE);
          }
     }
     if (asktbl[TBLAD2][0]) {
          b2ccpy(usaptr->usrad2,supdat->usrad2,NADSIZ);
          if ((errn=valinf(usaptr->usrad2,5,TRUE)) != 0) {
               prf("AD1");
               prfmsg(errn == 1 ? A1TOOSML : A1PROFAN);
               return(FALSE);
          }
          b2ccpy(usaptr->usrad3,supdat->usrad3,NADSIZ);
          if ((errn=valinf(usaptr->usrad3,5,TRUE)) != 0) {
               prf("AD2");
               prfmsg(errn == 1 ? A2TOOSML : A2PROFAN);
               return(FALSE);
          }
          b2ccpy(usaptr->usrad4,supdat->usrad4,NADSIZ);
          if ((errn=valinf(usaptr->usrad4,0,TRUE)) != 0) {
               prf("AD3");
               prfmsg(A3PROFAN);
               return(FALSE);
          }
     }
     if (asktbl[TBLPHO][0]) {
          b2ccpy(usaptr->usrpho,supdat->usrpho,PHOSIZ);
          if ((errn=valinf(usaptr->usrpho,7,TRUE)) != 0) {
               prf("PHO");
               prfmsg(errn == 1 ? VTOOSML : VPROFAN);
               return(FALSE);
          }
     }
     if (asktbl[TBLSYS][0]) {
          usaptr->systyp=supdat->systyp;
          if (usaptr->systyp > 3) {
               prf("SYS");
               prfmsg(INVSYS);
               return(FALSE);
          }
     }
     if (asktbl[TBLSEX][0]) {
          usaptr->sex=supdat->sex;
          if (usaptr->sex != 'M' && usaptr->sex != 'F') {
               prf("SEX");
               prfmsg(INVSEX);
               return(FALSE);
          }
     }
     if (asktbl[TBLBDY][0]) {
          b2ccpy(usaptr->birthd,supdat->birthd,DATSIZ);
          if (!okbday(usaptr->birthd)) {
               prf("BDY");
               prfmsg(INVBDY);
               return(FALSE);
          }
     }
     return(TRUE);
}

STATIC int
valinf(                            /* check a piece of info                 */
char *infstg,                      /*   info to check                       */
unsigned minlen,                   /*   minimum required length             */
BOOL chkpfn)                       /*   check profanity as well?            */
{
     if (strlen(infstg) < minlen) {
          return(1);
     }
     if (chkpfn) {
          setpfn(infstg);
          if (pfnlvl > 1) {
               return(2);
          }
     }
     return(0);
}

STATIC void
insacc(void)                       /* cycle routine to record new usr info  */
{
     if ((rqiptr->insstt=morsup(rqiptr->insstt)) == DUNINS) {
          usrptr->class=ACTUSR;
          endsup();
          if (csbump(FALSE) == BMPAOK) {
               usrflags();
               if ((*vallon)()) {
                    rsp2write(TRUE,STGLEN,"Y");
                    gcsplon();
               }
               else {
                    strins(prfbuf,"N",PFBSIZ);
                    r2wprf(TRUE);
                    setbbye();
               }
          }
          else {
               prf("N");
               setmbk(bbsupmb);
               prfmsg(IMMEDB);
               r2wprf(TRUE);
               setbbye();
          }
     }
}

STATIC void
supxdone(void)                     /* file transfer-done handler           */
{
}

STATIC void
supabort(void)                     /* abort-request handler                */
{
     if (rqiptr->insstt != 0) {
          abosup(rqiptr->insstt);
          byenow(NOMSG);
     }
}

STATIC void
supfin(void)                       /* system shutdown hook handler         */
{
     clsmsg(bbsupmb);
}

